;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: bonus stage					*
;*	file name	: ys_bonas					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_color.h
		include		../union/ys_mapobj.h
		include		ys_presno.h
		include		ys_pld.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
;
		GLB	BONUSIT,BONUSMV,ITEMINPUT_L
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	BLNKOFF,VRAMCL,OAMCLR,URAMCLR,OAMDXCLR,RANDAM
		EXT	BNSIN
		EXT	SOUND_TR_2
		EXT	SOUND_3_ON
;
		EXT	HMPIN,EGG00,JSRSUB
;
;-------------< ys_save >------------------------------------------------
		EXT	SVDTSV
;
;-------------< ys_init >------------------------------------------------
		EXT	DIVDTST,CHRSET,COLSET,GMMDST,M_DMA_BFST,VRAMDX_ST
;
		EXT	BONUS_1_CHR,BONUS_1_COL,BONUS1
;
		EXT	PL_COLBK
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENRAMCLR,ENCSET_DM,ENINSR2,EN_XYMOVE
;
		EXT	BABYM,DSMK0
;
;-------------< ys_enmy4 >-----------------------------------------------
		EXT	BABYMMV
;
		EXT	BABYM_RMODE40
;
;-------------< ys_play >------------------------------------------------
		EXT	PLCSET, CHNGXPS, CHNGYPS
;
;-------------< ys_exst >------------------------------------------------
		EXT	EXSTRA,EXINSR
;
;-------------< ys_game >------------------------------------------------
		EXT	MSGDSP,MSGDSP_X
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,NEWVMADL
;
;-------------< ys_hmap >------------------------------------------------
		EXT	WINAREA
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_10	GROUP	Bonus_pro
Bonus_pro	SECT	REL
;
;----------------------------------------------------------------
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSL	BONUSIT ( bonus stage initial set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COLRDT0		EQU	$
		WORD	BNS_BG_COL_00,BNS_BG_COL_20,BNS_BG_COL_40,BNS_BG_COL_50
		WORD	BNS_BG_COL_30,BNS_BG_COL_10
;
;;;;;;;;		WORD	BNS_BG_COL_00,BNS_BG_COL_20,BNS_BG_COL_10,BNS_BG_COL_30
;;;;;;;;		WORD	BNS_BG_COL_40,BNS_BG_COL_50
;;;;;;;;;
COLRDT1		EQU	$
		WORD	BNS_BG_COL_03,BNS_BG_COL_23,BNS_BG_COL_43,BNS_BG_COL_53
		WORD	BNS_BG_COL_33,BNS_BG_COL_13
;
;;;;;;;;		WORD	BNS_BG_COL_03,BNS_BG_COL_23,BNS_BG_COL_13,BNS_BG_COL_33
;;;;;;;;		WORD	BNS_BG_COL_43,BNS_BG_COL_53
;;;;;;;;;
COLRDT2		EQU	$
		WORD	MAP_AICON_COL,MAP_AICON_COL,MAP_AICON_COL,MAP_AICON_COL
		WORD	MAP_AICON_COL,MAP_AICON_COL
;
COLRDT3		EQU	$
		WORD	MAP_AICON_COL,MAP_AICON_COL,MAP_AICON_COL,MAP_AICON_COL
		WORD	MAP_AICON_COL,MAP_AICON_COL
;
;
 IF  PAL  ;**** PAL Ή [1995/07/31] *****************************
SCRDAT_DAT0	EQU	$
		WORD	CHR38A,CHR38A,CHRPAL12A
;
SCRDAT_DAT1	EQU	$
		WORD	CHR38B,CHR38B,CHRPAL12B
;
SCRDAT_DAT2	EQU	$
		WORD	CHR39-CHR10,CHRPAL10-CHR10,CHRPAL11-CHR10
 ENDIF    ;**** PAL Ή [1995/07/31] *****************************
;
;
SCRDAT1		EQU	$
		WORD	BNS11,BNS31,BNS51,BNS61,BNS41,BNS21
;
;;;;;;;;		WORD	BNS11,BNS31,BNS21,BNS41,BNS51,BNS61
;;;;;;;;;
SCRDAT2		EQU	$
		WORD	BNS12,BNS32,BNS52,BNS62,BNS42,BNS22
;
;;;;;;;;		WORD	BNS12,BNS32,BNS22,BNS42,BNS52,BNS62
;;;;;;;;;
SCRDAT3		EQU	$
		WORD	BNS3,BNS3,BNS3,BNS3,BNS3,BNS3
;
;-------------- bonus window parameter data -----------------------------
BSHDMA0		EQU	$
		BYTE	01000100B
		BYTE	026H
		LWORD	HDMAPR0
;
BSHDMAD0	EQU	$
		BYTE	069H+80H
		WORD	WINDBUF
		BYTE	069H+80H
		WORD	WINDBUF+(069H*4)
		HEX	000
BSHDMAD0E	EQU	$
;
;
BONUSIT		EQU	$
		JSL	>VRAMCL		; V-ram clear !!
		JSL	>URAMCLR	; use RAM clear !!
		JSL	>ENRAMCLR	; enmy ram clear !!
		JSL	>OAMDXCLR	; OAM clear sub !!
		JSL	>DIVDTST	; div data set sub !!
;
;-------------< screen character set >-------------
		I16			; index 8 bit mode !!
;
 IF  PAL  ;**** PAL Ή [1995/07/31] *****************************
		M16			; memory 16bit mode
		LDA	!LNGG_SL
		ASL	A
		TAY
		M8			; memory 8bit mode
		LDA	SCRDAT_DAT0,Y
		STA	<WORK10
		LDA	SCRDAT_DAT1,Y
		STA	<WORK11
		LDA	SCRDAT_DAT2,Y
		STA	<WORK12
		LDY	BONUSNO
		LDX	!SCRDAT1,Y
		STX	<WORK13
		LDX	!SCRDAT2,Y
		STX	<WORK14
		LDX	!SCRDAT3,Y
		STX	<WORK15
		LDY	#BONUS_1_CHR
		JSL	>CHRSET
 ENDIF    ;**** PAL Ή [1995/07/31] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/07/31] *****************************
		LDY	BONUSNO
		LDX	!SCRDAT1,Y
		STX	<WORK10
		LDX	!SCRDAT2,Y
		STX	<WORK12
		LDX	!SCRDAT3,Y
		STX	<WORK14
		LDY	#BONUS_1_CHR
		JSL	>CHRSET
 ENDIF         ;**** { or NES Ή [1995/07/31] *****************************
;
;-------------< color set >-------------
		MI16			; memory,index 16 bit mode !!
;
;;;;K;;;;		LDX	MPTYPE
		LDX	BONUSNO
		LDA	!COLRDT0,X
		STA	<WORK10
		LDA	!COLRDT1,X
		STA	<WORK12
		LDA	!COLRDT2,X
		STA	<WORK14
		LDA	!COLRDT3,X
		STA	<WORK16
		LDA	!P_COLOR
		ASL	A
		TAX
		LDA	>PL_COLBK,X
		STA	<WORK18
		LDX	#BONUS_1_COL
		JSL	>COLSET
;
		MEM8
		IDX8
;
;-------------< PPU regster set >-------------
		LDX	#BONUS1
		JSL	>GMMDST
;
;;;;;;;;		LDA	#00110000B
;;;;;;;;		STA	0212AH
;;;;;;;;		LDA	#00000011B
;;;;;;;;		STA	0212BH
;;;;;;;;;
;
;-------------< H-DMA data set >-------------
		LDX	#004
;
HMA050		EQU	$
		LDA	!BSHDMA0,X
		STA	4350H,X
		DEX
		BPL	HMA050
;
		LDA	#BANK HDMABUF
		STA	4377H
;
		LDX	#(BSHDMAD0E-BSHDMAD0)-1
;
HMA100		EQU	$
		LDA	!BSHDMAD0,X
		STA	>HDMAPR0,X
		DEX
		BPL	HMA100
;
		LDA	#00100000B
		STA	HD420C
;
		MI16
;
;-------------< ram initial set >-------------
		LDA	#00028H
		STA	<WINXPS		; window X position set !!
		LDA	#000B4H
		STA	<WINYPS		; window Y position set !!
		STZ	<WINDPT		; a set !!
		LDA	#00002
		STA	<WINDMK		; window open or close muki set !!
		LDA	#00018H
		STA	BONSTM		; timer set !!
;
		LDA	#07FFFH
		STA	NUKCOL		; nuki color set !!
;
		STZ	<SCCH1
		STZ	<SCCH2
		STZ	<SCCH3
		LDA	#00100H
		STA	<SCCV1
		STA	<SCCV2
		STZ	<SCCV3
;
		STZ	BONSMD		; mode clear !!
;
		LDY	#00000
		STY	PLWALK		; paturn No. set !!
		LDA	!PLTRNDT,Y
		STA	PLPATN		; player paturn set !!
		LDA	!PLTIMDT,Y
		STA	PLWKTM		; player paturn timer set !!
		LDA	#000D0H
		STA	PLXPSL		; player X position set !!
		LDA	#000A8H
		STA	PLYPSL		; player Y position set !!
		LDA	#00002
		STA	PLCMKI		; player muki set !!
;
		I8			; index 8 bit mode !!
;
		LDY	#(003-1)*2
		LDA	#0FFFFH
;
RMS050		EQU	$
		STA	OBJCHR_BNK,Y
		DEY
		DEY
		BPL	RMS050
;
		LDA	#BABYM
		LDY	#000
		JSL	>ENINSR2
;
		LDA	#BABYM_RMODE40
		STA	ENWRK2
		LDA	#02000H
		STA	BABYNO
		LDA	#00000
		STA	ENCHPT
		LDA	#00020H
		STA	ENXPSL		; baby X position set !!
		LDA	#000B8H
		STA	ENYPSL		; baby Y position set !!
		LDA	#00002
		STA	ENMUKI		; baby muki set !!
		LDA	#0003AH
		STA	ENCLOR		; baby priority set !!
;
		M8			; memory 8bit mode !!
		LDA	!CARDXDT
		STA	CRCXPS
		LDA	!CARDYDT
		STA	CRCYPS
		STZ	CARDMV
		STZ	WITEM0
		STZ	WITEM1
		STZ	WITEM2
		STZ	WITEM3
		STZ	WITEM4
		STZ	WITEM5
		STZ	WITEM6
		M16			; memory 16bit mode !!
;
		STZ	ESCCH1		; H scroll clear !!
		STZ	ESCCV1		; V scroll clear !!
;
;-------------< window initial set >-------------
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
		M_CHIP	WINBFCLR
;
		I16			; index 16 bit mode !!
;
		JSR	WINDSET		; window open or close set sub !!
;
;-------------< player counter set >-------------
		JSR	PLCNTST		; player counter set sub !!
;
		MI8			; memory,index 8 bit mode !!
;
		JSL	>NEWVMADL
;
		MI16			; memory,index 16 bit mode !!
;
;-------------< world bonus stege initial set >-------------
;;;;K;;;;		LDX	MPTYPE
		LDX	BONUSNO
		JSR	(!BSINTAR,X)	; bonus stege initial set sub !!
;
		MI8			; memory,index 8 bit mode !!
;
;-------------- TEhvO] -------------------------
		LDX	#06		;(X) <-- TEhvO]e[umD
		JSL	>SOUND_TR_2
;
;;;;K;;;;		LDA	!BONUSNO
;;;;K;;;;		LSR	A
;;;;K;;;;		STA	<SOUND_0
		LDA	#001
		STA	<SOUND_0
;
;-------------- NMI-IRQ "ON" ------------------------------------
		STZ	NMI_PROG_NO	;荞݃vOmD
;
		LDA	#02H		;IRQ counter set
		STA	IRQFLG
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0D8H		;V counter set
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
;
		INC	MODENO		; mode No. inc. !!
;
		PLB
		RTL
;
;
BSINTAR		EQU	$
		WORD	BABAINT		; WORLD 1 oo
		WORD	GINGINT		; WORLD 2 ⎆
		WORD	SINKINT		; WORLD 3 ꂩ
		WORD	SLT1INT		; WORLD 4 _o
		WORD	SUZIINT		; WORLD 5 ̋@[bg
		WORD	SLOTINT		; WORLD 6 Xbg
;
;
		MEM16
		IDX16
;
;
;----------------------------------------------------------------
;-	ACe̓o^						-
;-		(A) <- ACemD				-
;----------------------------------------------------------------
ItemMax		EQU	27
;
ITEMINPUT	EQU	$
		PHP
;
		MI8				; memory,index 8bit mode !!
;
		PHA
;
		LDY	#00
ITEMINPUT0040	EQU	$
		LDA	!ITEMBUF,Y
		BEQ	ITEMINPUT0080		; 󂢂ĂH [yes->ITEMINPUT0080]
;
		INY
		CPY	#ItemMax
		BNE	ITEMINPUT0040		; `FbNIH [no->ITEMINPUT0040]
;
		LDY	#00
		LDX	#01
ITEMINPUT0060	EQU	$
		LDA	!ITEMBUF,X
		STA	!ITEMBUF,Y
		INX
		INY
		CPY	#ItemMax-1
		BNE	ITEMINPUT0060		; IH [no->ITEMINPUT0060]
;
ITEMINPUT0080	EQU	$
		PLA
		STA	!ITEMBUF,Y
;
		PLP
		RTS
;
ITEMINPUT_L	EQU	$
		JSR	ITEMINPUT
;
		RTL
;
		MEM16
		IDX16
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	WINDSET ( window open or close set sub )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
RPOTDAT		EQU	$
		WORD	00020H,00000H
;
RINCDAT		EQU	$
		WORD	00002H,0FFFEH
;
;
WINDSET		EQU	$
		I8			; index 8 bit mode !!
;
		STZ	<WINDFG
		LDY	<WINDMK
		LDA	<WINDPT
		CMP	!RPOTDAT,Y
		BEQ	WDT050		; window set ?
;					; Yes !!
		INC	<WINDFG
		CLC
		ADC	!RINCDAT,Y
		STA	<WINDPT
;
WDT050		EQU	$
		STA	R12		; a
		LDA	#BANK WINAREA
		STA	R0		; ~f[^[AhXZbg
		LDA	#WINAREA
		STA	R4		; ~f[^[AhXoNZbg
		LDA	<WINYPS
		SEC
		SBC	#00008
		STA	R2		; SxW
		LDA	<WINXPS
		STA	R1		; SwW
		LDA	#00000
		STA	R11		; W
;
		M_CHIP	BS_CIRCLWD
;
		LDA	<WINDPT
		STA	R12		; a
		LDA	#BANK WINAREA
		STA	R0		; ~f[^[AhXZbg
		LDA	#WINAREA
		STA	R4		; ~f[^[AhXoNZbg
		LDA	<WINYPS
		SEC
		SBC	#00008
		STA	R2		; SxW
		LDA	<WINXPS
		CLC
		ADC	#000B0H
		STA	R1		; SwW
		LDA	#00002
		STA	R11		; EW
;
		M_CHIP	BS_CIRCLWD
;
		I16			; index 16 bit mode !!
;
DMABFST		EQU	$
		JSL	>M_DMA_BFST
		LWORD	WINDBUF		; ]AhX
		LWORD	WINDBF		; ]AhX
		WORD	(0D2H*4)	; ]oCg
;
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PLCNTST ( player counter set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SCRADRD		EQU	$
;;;;;;;;		WORD	039DBH,03878H,03878H,03800H,03800H,03800H
		WORD	068D8H,068D8H,068D8H,068D9H,068D8H,068D8H
;
SUUJID0		EQU	$
;			0	      1		    2		  3
		WORD	03CD6H,0FCD6H,03CC0H,03CD0H,03CC1H,03CD1H,03CC2H,03CD2H
;			4	      5		    6		  7
		WORD	03CC3H,03CD3H,03CC4H,03CD4H,03CC5H,03CD5H,03CC2H,03CD0H
;			8	      9
		WORD	03CC6H,03CD5H,0FCD5H,0FCC5H
;
COINBUF		EQU	$
		WORD	BONAS_CNT	; J[h߂Q[
		WORD	BONAS_CNT	; XNb`Q[
		WORD	BONAS_CNT	; 񂾂߂Q[
		WORD	BONAS_CNT	; _oQ[
		WORD	YSCOIN		; [bgQ[
		WORD	YSCOIN		; Xbg}V[Q[
;
;
PLCNTST		EQU	$
		LDA	!BONUSNO
		CMP	#00008H
		BNE	PNT030		; [bgQ[ ?
;					; yes
		LDA	!MODENO
		CMP	#BNSIN
		BNE	PNT030		; bonus inital ?
;					; yes
		DEC	!PLCONT		; player -1
PNT030		EQU	$
		LDY	#00000
		LDX	#00000
		LDA	PLCONT
;
PNT050		EQU	$
		LDY	#00000
;
PNT100		EQU	$
		CMP	#00010
		BCC	PNT150		; player counter >= "10" ?
;					; Yes !!
		SBC	#00010
		INY
		BRA	PNT100
;
PNT150		EQU	$
		ASL	A
		ASL	A
		STA	<WORK0,X
		TYA
		INX
		INX
		CPX	#00006
		BNE	PNT050		; PUiϊI ?
;					; Yes !!
;;;;K;;;;		LDX	MPTYPE
		LDX	BONUSNO
		LDA	>SCRADRD,X
;;;;;;;;		STA	<WORKE
;;;;;;;;		JSR	CONTSET
;;;;;;;;;
;;;;;;;;		LDX	#00000
;;;;;;;;;;;;K;;;;		LDY	MPTYPE
;;;;;;;;		LDY	BONUSNO
;;;;;;;;		LDA	!COINBUF,Y
;;;;;;;;		STA	<WORK0
;;;;;;;;		LDA	(<WORK0)
;;;;;;;;;;;;;;;;		LDA	YSCOIN
;;;;;;;;;
;;;;;;;;PNT200		EQU	$
;;;;;;;;		LDY	#00000
;;;;;;;;;
;;;;;;;;PNT250		EQU	$
;;;;;;;;		CMP	#00010
;;;;;;;;		BCC	PNT300		; yosshy coin >= "10" ?
;;;;;;;;;					; Yes !!
;;;;;;;;		SBC	#00010
;;;;;;;;		INY
;;;;;;;;		BRA	PNT250
;;;;;;;;;
;;;;;;;;PNT300		EQU	$
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		STA	<WORK0,X
;;;;;;;;		TYA
;;;;;;;;		INX
;;;;;;;;		INX
;;;;;;;;		CPX	#00006
;;;;;;;;		BNE	PNT200		; PUiϊI ?
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	<WORKE
;;;;;;;;		CLC
;;;;;;;;		ADC	#00040H
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CONTSET ( counter V-ram set sub )		x
;x									x
;x			initial "A"   <-- V-ram address			x
;x				WORK0 <-- P̈ʃf[^[		x
;x				WORK2 <-- PÖʃf[^[		x
;x				WORK4 <-- POÖʃf[^[		x
;x									x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CONTSET		EQU	$
;
		PHB
		LDX	#BANK VRAMDX
		PHX
		PLB
;
		LDY	VRAMDX
		STA	0,Y		; u|AhXZbg
		CLC
		ADC	#00020H
		STA	18,Y
;
		LDA	#00180H
		STA	2,Y
		STA	20,Y
;
		LDA	#00018H
		STA	4,Y
		STA	22,Y
;
		TYA
		CLC
		ADC	#00012
		STA	5,Y		; f[^[AhXZbg
		CLC
		ADC	#00018
		STA	23,Y
;
		LDA	#BANK VRAMDX
		STA	7,Y		; f[^[AhXoNZbg
		STA	25,Y
;
		LDA	#00006
		STA	8,Y		; f[^[oCgZbg
		STA	26,Y
;
		TYA
		CLC
		ADC	#00018
		STA	10,Y		; mdwsAhXZbg
		CLC
		ADC	#00018
		STA	28,Y
		STA	VRAMDX
;
		PLB
		PLB
;
		TYA
		SEC
		SBC	#VRAMDX+2
		TAX
;
		LDY	#00004
		STY	<WORK6
		STZ	<WORK8
		STZ	<WORKA
;
CTT050		EQU	$
		LDA	WORK0,Y
		BNE	CTT100		; "0" ?
;					; Yes !!
		LDA	<WORK8
		BEQ	CTT150		; sentou ?
;					; No !!
CTT100		EQU	$
		LDA	WORK0,Y
		TAY
		LDA	!SUUJID0,Y
		STA	>VRAMDX+14,X
		LDA	!SUUJID0+2,Y
		STA	>VRAMDX+32,X
		STA	<WORK8
		INC	<WORKA
		INC	<WORKA
		INX
		INX
;
CTT150		EQU	$
		DEC	<WORK6
		DEC	<WORK6
		LDY	<WORK6
		BEQ	CTT100
		BPL	CTT050		; set end ?
;					; Yes !!
		LDA	#03C7DH
		LDY	<WORKA
;
CTT200		EQU	$
		CPY	#00006
		BEQ	CTT250
;
		STA	>VRAMDX+14,X
		STA	>VRAMDX+32,X
		INX
		INX
		INY
		INY
		BRA	CTT200
;
CTT250		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	BABAINT ( WORLD 1 oo initial set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BS_CMODE_DATA	EQU	$
		BYTE	011H,011H,011H,011H,011H,011H,011H,011H
		BYTE	011H,011H,011H,011H
;
BS_CMODE_DAT1	EQU	$
		BYTE	011H,011H,011H,011H,011H,011H,015H,015H
		BYTE	015H,015H,015H,015H
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
BS_PAL_DAT0	EQU	$
		BYTE	009H*2,00EH*2,010H*2
;
BS_PAL_DAT1	EQU	$
		BYTE	00AH*2,00FH*2,011H*2
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
BABAINT		EQU	$
;-------------< bit map char set >-------------
		I8			; index 8 bit mode !!
;
		LDY	#10000000B
		STY	02115H
		LDA	#00000001B+(18H*100H)
		STA	04300H
;
		LDA	#BS_CMODE_DATA
		STA	CCWORK1
		LDA	#BANK BS_CMODE_DATA
		STA	CCWORK0
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		LDX	!LNGG_SL
		LDA	BS_PAL_DAT0,X
		AND	#000FFH
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] *****************************
		LDA	#00009H*2
 ENDIF         ;**** { or NES Ή [1995/08/02] *****************************
;
		STA	R9
		M_CHIP	MPCHRVRMST
;
		STZ	02116H
;
		LDA	#WOB7CHR
		STA	04302H
		LDY	#BANK WOB7CHR
		STY	04304H
		LDA	#01000H
		STA	04305H
		LDY	#00000001B
		STY	420BH
;
		LDA	#BS_CMODE_DAT1
		STA	CCWORK1
		LDA	#BANK BS_CMODE_DAT1
		STA	CCWORK0
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		LDX	!LNGG_SL
		LDA	BS_PAL_DAT1,X
		AND	#000FFH
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] *****************************
		LDA	#0000AH*2
 ENDIF         ;**** { or NES Ή [1995/08/02] *****************************
;
		STA	R9
		M_CHIP	MPCHRVRMST
;
		LDA	#00800H
		STA	02116H
;
		LDA	#WOB7CHR
		STA	04302H
		LDY	#BANK WOB7CHR
		STY	04304H
		LDA	#01000H
		STA	04305H
		LDY	#00000001B
		STY	420BH
;
		I16			; index 16 bit mode !!
;
;-------------< tabel random set >-------------
		JSR	RANDSET
;[1995/05/02]		JSR	ITEMIDX		; ACe CfbNX Zbg
;
		RTS
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	GINGINT ( WORLD 2 ⎆ initial set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
GINGINT		EQU	$
;-------------< bit map char set >-------------
		I8			; index 8 bit mode !!
;
		LDY	#10000000B
		STY	02115H
		LDA	#00000001B+(18H*100H)
		STA	04300H
;
		LDA	#BS_CMODE_DATA
		STA	CCWORK1
		LDA	#BANK BS_CMODE_DATA
		STA	CCWORK0
		LDA	#00009H*2
		STA	R9
		M_CHIP	MPCHRVRMST
;
		STZ	02116H
		LDY	#BANK WOB7CHR
		STY	04304H
		LDY	#00000001B
		LDX	#00007
;
GGT050		EQU	$
		LDA	#WOB7CHR+(00048H*20H)
		STA	04302H
		LDA	#00009*20H
		STA	04305H
		STY	420BH
		DEX
		BNE	GGT050
;
		JMP	GINGAMIINIT
;;;		RTS
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTINT ( WORLD 3 Xbg initial set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTINT		EQU	$
		M8			; memory 8bit mode !!
;
		LDA	!STOTTBL+00	; 
		STA	SLOT00
		LDA	!STOTTBL+01
		STA	SLOT00+1
		LDA	!STOTTBL+02
		STA	SLOT00+2
		LDA	!STOTTBL+03
		STA	SLOT00+3
;
		LDA	!STOTTBL+08	; 
		STA	SLOT10
		LDA	!STOTTBL+09
		STA	SLOT10+1
		LDA	!STOTTBL+0AH
		STA	SLOT10+2
		LDA	!STOTTBL+0BH
		STA	SLOT10+3
;
		LDA	!STOTTBL+10H	; E
		STA	SLOT20
		LDA	!STOTTBL+11H
		STA	SLOT20+1
		LDA	!STOTTBL+12H
		STA	SLOT20+2
		LDA	!STOTTBL+13H
		STA	SLOT20+3
;
		LDA	#004		;  
		STA	SLTIDX+0
		STA	SLTIDX+1
		STA	SLTIDX+2
;
		STZ	SLTCAN		; cancel flag (by.not)
;
		M16			; memory 16bit mode !!
;
;;;;;;;		LDA	#04800H		; x |WV
		LDA	#05800H		; x |WV
		STA	SLTYPS+0
		STA	SLTYPS+2
		STA	SLTYPS+4
;
		LDA	#05000H		; p |WV
		STA	TUGIYP+0
		STA	TUGIYP+2
		STA	TUGIYP+4
;
		JSR	SLOTIT0		; ̑ CjV
;
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SUZIINT ( WORLD 4  initial set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SUZIINT		EQU	$
;
		MEM16
;
		LDA	!PLCONT
		STA	!PLCNT		; player count -> base set
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		STZ	!SLMODE		; select mode
		STZ	!PWORK0		; index clear
		STZ	!PWORK1		; index clear
;
		STZ	!DEMOFG		; key data clear
;
		STZ	!PWORKE		; roolet stop flag clear
;
		LDA	#060H
		STA	!PWORK2		; initial time set
		LDA	#080H
		STA	!PWORK3		; initial time set
		STZ	!PWORK8		; initial clear
		STZ	!PWORK9		; initial clear
;
		LDA	#009H
		STA	!DSPOT1		; display 1 no ke_ta
		STA	!DSPOT10	; display 10 no ke_ta
		STZ	!DSPOT100	; display 100 no ke_ta
;
		LDA	#001H
		STA	!BETCNT		; bet count 1 clear
		STZ	!TOTLCNT	; total count LOW 0 clear
		STZ	!TOTLCNT+1	; total count HI  0 clear
		STZ	!KEYWTTM	; key wait timer clear
;
		LDA	#040H
		STA	!MSGTM
;
		STZ	!MSGPT
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		RTS
;
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SINKINT ( WORLD 5 ꂩ initial set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SINKINT		EQU	$
;-------------< bit map char set >-------------
		I8			; index 8 bit mode !!
;
		LDY	#10000000B
		STY	02115H
		LDA	#00000001B+(18H*100H)
		STA	04300H
;
		LDA	#BS_CMODE_DAT1
		STA	CCWORK1
		LDA	#BANK BS_CMODE_DAT1
		STA	CCWORK0
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		LDX	!LNGG_SL
		LDA	BS_PAL_DAT1,X
		AND	#000FFH
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] *****************************
		LDA	#0000AH*2
 ENDIF         ;**** { or NES Ή [1995/08/02] *****************************
;
		STA	R9
		M_CHIP	MPCHRVRMST
;
		STZ	02116H
		LDY	#BANK WOB7CHR
		STY	04304H
		LDY	#00000001B
		LDX	#00006
;
SKIT050		EQU	$
		LDA	#WOB7CHR+((7*9)*20H)
		STA	04302H
		LDA	#00009*20H
		STA	04305H
		STY	420BH
		DEX
		BNE	SKIT050
;
;-------------------------------
		LDA	#BS_CMODE_DATA
		STA	CCWORK1
		LDA	#BANK BS_CMODE_DATA
		STA	CCWORK0
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		LDX	!LNGG_SL
		LDA	BS_PAL_DAT0,X
		AND	#000FFH
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] *****************************
		LDA	#00009H*2
 ENDIF         ;**** { or NES Ή [1995/08/02] *****************************
;
		STA	R9
		M_CHIP	MPCHRVRMST
;
		LDA	#WOB7CHR
		STA	04302H
		LDY	#BANK WOB7CHR
		STY	04304H
		LDA	#00900H
		STA	04305H
		LDY	#00000001B
		STY	420BH
;
		LDA	#BS_CMODE_DAT1
		STA	CCWORK1
		LDA	#BANK BS_CMODE_DAT1
		STA	CCWORK0
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		LDX	!LNGG_SL
		LDA	BS_PAL_DAT1,X
		AND	#000FFH
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] *****************************
		LDA	#0000AH*2
 ENDIF         ;**** { or NES Ή [1995/08/02] *****************************
;
		STA	R9
		M_CHIP	MPCHRVRMST
;
		LDA	#00800H
		STA	02116H
;
		LDA	#WOB7CHR
		STA	04302H
		LDY	#BANK WOB7CHR
		STY	04304H
		LDA	#01000H
		STA	04305H
		LDY	#00000001B
		STY	420BH
;
		JMP	ATEMONINIT
;;;		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLT1INT ( WORLD 6 _o initial set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BS_CMODE_DAT2	EQU	$
;[1995/05/03]		     BYTE    015H,011H,011H,011H,011H,015H,015H,015H
;[1995/05/03]		     BYTE    015H,015H,015H,015H
		BYTE	015H,011H,011H,011H,011H,011H,011H,011H
		BYTE	011H,011H,011H,011H
;
 IF  PAL  ;**** PAL Ή [1995/08/03] *****************************
SLT_PAL_DAT	EQU	$
		BYTE	0000BH*2,00014H*2,00015H*2
 ENDIF    ;**** PAL Ή [1995/08/03] *****************************
;
;
SLT1INT		EQU	$
;-------------< bit map char set >-------------
;[1995/05/03]		I8			; index 8 bit mode !!
;[1995/05/03];
;[1995/05/03]		LDY	#10000000B
;[1995/05/03]		STY	02115H
;[1995/05/03]		LDA	#00000001B+(18H*100H)
;[1995/05/03]		STA	04300H
;[1995/05/03];
;[1995/05/03]		LDA	#BS_CMODE_DAT2
;[1995/05/03]		STA	CCWORK1
;[1995/05/03]		LDA	#BANK BS_CMODE_DAT2
;[1995/05/03]		STA	CCWORK0
;[1995/05/03]		LDA	#0000BH*2
;[1995/05/03]		STA	R9
;[1995/05/03]		M_CHIP	MPCHRVRMST
;[1995/05/03];
;[1995/05/03]		STZ	02116H
;[1995/05/03]		LDY	#BANK WOB7CHR
;[1995/05/03]		STY	04304H
;[1995/05/03]		LDY	#00000001B
;[1995/05/03];
;[1995/05/03]		LDA	#WOB7CHR
;[1995/05/03]		STA	04302H
;[1995/05/03]		LDA	#(9*12)*20H
;[1995/05/03]		STA	04305H
;[1995/05/03]		STY	420BH
;[1995/05/03];
;----------------------------------------------
;
		I8			; index 8 bit mode !!
;
		LDY	#10000000B
		STY	02115H
		LDA	#00000001B+(18H*100H)
		STA	04300H
;
		LDA	#BS_CMODE_DAT2
		STA	CCWORK1
		LDA	#BANK BS_CMODE_DAT2
		STA	CCWORK0
;
 IF  PAL  ;**** PAL Ή [1995/08/03] *****************************
		LDX	!LNGG_SL
		LDA	SLT_PAL_DAT,X
		AND	#000FFH
 ENDIF    ;**** PAL Ή [1995/08/03] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/03] *****************************
		LDA	#0000BH*2
 ENDIF         ;**** { or NES Ή [1995/08/03] *****************************
;
		STA	R9
		M_CHIP	MPCHRVRMST
;
		STZ	02116H
;
		LDA	#WOB7CHR
		STA	04302H
		LDY	#BANK WOB7CHR
		STY	04304H
		LDA	#01000H
		STA	04305H
		LDY	#00000001B
		STY	420BH
;
		LDA	#BS_CMODE_DAT1
		STA	CCWORK1
		LDA	#BANK BS_CMODE_DAT1
		STA	CCWORK0
		LDA	#0000AH*2
		STA	R9
		M_CHIP	MPCHRVRMST
;
		LDA	#00800H
		STA	02116H
;
		LDA	#WOB7CHR
		STA	04302H
		LDY	#BANK WOB7CHR
		STY	04304H
		LDA	#01000H
		STA	04305H
		LDY	#00000001B
		STY	420BH
;
		I16			; index 16 bit mode !!
;
;----------------------------------------------
;
;
 IF  PAL  ;**** PAL Ή [1995/08/01] *****************************
		LDA	LNGG_SL
		CMP	#00002
		BNE	SL1IN01		; hCcH
;					: yes
;
		JSR	PAIRSSET	; PAIR'S' Zbg
;					: (hCcFTREFFER)
SL1IN01		EQU	$
;
 ENDIF    ;**** PAL Ή [1995/08/01] *****************************
;
;
		JSR	COINRAN		; table random set
;
		RTS
;
;
;
;
;============== MOVE ====================================================
;
		MEM8
		IDX8
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSL	BONUSMV ( bonus stage move set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BONUSMV		EQU	$
		JSL	>OAMDXCLR	; OAM clear sub !!
		JSL	>ENCSET_DM	; enemy char set sub !!
;
		MI16			; index 16 bit mode !!
;
		JSR	DAIOAMS		; dai OAM set sub !!
;;;;K;;;;		LDX	MPTYPE
		LDX	BONUSNO
		JSR	(!BSMOVAR,X)	; bonus stege move sub !!
		JSR	COLCHNG		; J[f[^[`FW
;
		JSR	PLBABYS		; player & baby pause set sub !!
;
		MI8			; memory,index 8 bit mode !!
;
		JSL	>PLCSET		; player char set sub !!
;
		M16			; memory 16 bit mode !!
;
		M_CHIP	DX_OAM
;
		M8			; memory 8 bit mode !!
;
		PLB
		RTL
;
;
BSMOVAR		EQU	$
		WORD	BABAMOV		; WORLD 1 oo
		WORD	GINGMOV		; WORLD 2 ⎆
		WORD	SINKMOV		; WORLD 3 ꂩ
		WORD	SLT1MOV		; WORLD 4 _o
		WORD	SUZIMOV		; WORLD 5 ̋@[bg
		WORD	SLOTMOV		; WORLD 6 Xbg
;
;
		MEM16
		IDX16
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	DAIOAMS ( dai OAM set sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DAIOAMS		EQU	$
		LDY	OAMIDX
		LDA	#000C8H
		STA	SOAM_DX,Y
		STA	SOAM_DX+08H,Y
		LDA	#000D8H
		STA	SOAM_DX+10H,Y
		STA	SOAM_DX+18H,Y
		LDA	#00018H
		STA	SOAM_DX+20H,Y
		STA	SOAM_DX+28H,Y
		LDA	#00028H
		STA	SOAM_DX+30H,Y
		STA	SOAM_DX+38H,Y
;
		LDA	#000C0H
		STA	SOAM_DX+02H,Y
		STA	SOAM_DX+12H,Y
		STA	SOAM_DX+22H,Y
		STA	SOAM_DX+32H,Y
		LDA	#000D0H
		STA	SOAM_DX+0AH,Y
		STA	SOAM_DX+1AH,Y
		STA	SOAM_DX+2AH,Y
		STA	SOAM_DX+3AH,Y
;
		LDA	#00F0DH
		STA	SOAM_DX+04H,Y
		STA	SOAM_DX+24H,Y
		LDA	#00F2DH
		STA	SOAM_DX+0CH,Y
		STA	SOAM_DX+2CH,Y
		LDA	#04F0DH
		STA	SOAM_DX+14H,Y
		STA	SOAM_DX+34H,Y
		LDA	#04F2DH
		STA	SOAM_DX+1CH,Y
		STA	SOAM_DX+3CH,Y
;
		LDA	#04002H
		STA	SOAM_DX+06H,Y
		STA	SOAM_DX+0EH,Y
		STA	SOAM_DX+16H,Y
		STA	SOAM_DX+1EH,Y
		STA	SOAM_DX+26H,Y
		STA	SOAM_DX+2EH,Y
		STA	SOAM_DX+36H,Y
		STA	SOAM_DX+3EH,Y
;
		TYA
		CLC
		ADC	#00008*8
		STA	OAMIDX
;
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COLCHNG ( J[f[^[`FW )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COLDATA2	EQU	$
		WORD	044A6H,048C7H,04CE8H,05109H
;
COLDATA		EQU	$
		WORD	0001FH,0023FH,0037FH,003F3H,00327H,07F20H,07E66H,07D77H
		WORD	07C1FH
;
;
COLCHNG		EQU	$
		LDA	<FRCNT
		AND	#00007
		BNE	CCG200		; color chenge ?
;					; Yes !!
		INC	BSCLPT
		LDA	BSCLPT
		ASL	A
		TAY
		CPY	#COLCHNG-COLDATA
		BNE	CCG050		; color pointer over ?
;					; Yes !!
		LDY	#00000
		STY	BSCLPT		; color pointer clear !!
;
CCG050		EQU	$
		LDX	#(9*2)-2
;
CCG100		EQU	$
		LDA	!COLDATA,Y
		STA	>DATACOL+(13H*2),X
		INY
		INY
		CPY	#COLCHNG-COLDATA
		BNE	CCG150		; color data pointer over ?
;					; Yes !!
		LDY	#00000
;
CCG150		EQU	$
		DEX
		DEX
		BPL	CCG100		; color data set end ?
;					; Yes !!
; ( kouhan kakikae )
		INC	BSCLPT2
		LDA	BSCLPT2
		AND	#00003
		ASL	A
		TAY
;
		LDX	#(4*2)-2
;
CCG170		EQU	$
		LDA	!COLDATA2,Y
		STA	>DATACOL+(1CH*2),X
		DEY
		DEY
		BPL	CCG180
;
		LDY	#(COLDATA-COLDATA2)-2
;
CCG180		EQU	$
		DEX
		DEX
		BPL	CCG170
;
;
CCG200		EQU	$
		RTS
;
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	BABAMOV ( WORLD 1 oo move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BABAMOV		EQU	$
		LDA	BONSMD
		ASL	A
		TAX
		JMP	(!BABAADR,X)
;
;
BABAADR		EQU	$
		WORD	TIMEDEC		; 0 timer dec. set sub !!
		WORD	WINDOPN		; 1 window open sub !!
		WORD	TIMDEC0		; 2 timer dec. set sub !!
		WORD	MSWINOP		; 3 messege window open sub !!
		WORD	WINCLSB		; 4 window color sub !!
;;;;;;;;		WORD	TIMDEC1		; 5 timer dec. set sub !!
		WORD	SCRDOWN		; 5 screen down move sub !!
		WORD	SCRYURE		; 6 screen yure sub !!
		WORD	TIMDEC2		; 7 timer dec. set sub !!
;[1995/02/08]		WORD	COINDEC		; 8 yosshy coin dec. sub !!
;;;;;;;;		WORD	MASKOPN		; 7 mask open sub !!
;;;;;;;;		WORD	TIMDEC3		; 8 timer dec. set sub !!
CARDGM		WORD	CARDSEL		; 9 card select
		WORD	EGGMOVE		; A egg move
HKROMT		WORD	HKRKEROMOTE	; B
		WORD	HKRKERURA	; C
BS1WIN		WORD	GAMEWIN		; D "X" button messege window sub !!
BONSCT		WORD	BONUSCT		; E player up & yossi coin up !!
KAMEIN		WORD	KAMEINT		; F kamekku initial sub !!
KAMEMV		WORD	KAMEMIN		;10 kamekku move sub !!
BS1MAP		WORD	MODEMAP		;11 map initial mode set sub !!
ZOOMIN		WORD	ZOOMVDN		;12 <seisan> card zoom down
		WORD	ZOOMVUP		;13	    "          up
;
;
CADGM		EQU	(CARDGM-BABAADR)/2
HKROM		EQU	(HKROMT-BABAADR)/2
BS1WN		EQU	(BS1WIN-BABAADR)/2
BONSM		EQU	(BONSCT-BABAADR)/2
KAMIN		EQU	(KAMEIN-BABAADR)/2
KAMEM		EQU	(KAMEMV-BABAADR)/2
BS1MP		EQU	(BS1MAP-BABAADR)/2
ZOMIN		EQU	(ZOOMIN-BABAADR)/2
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PLBABYS ( player & baby move set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PLTRNDT		EQU	$		; vC[|[Y
		WORD	OS1A,OS1B,OS1A,P107,OS18,OS19,OS18
;
PLTRND1		EQU	$		; vC[|[Y
;not;		WORD	TN01,TN02,TN03,TN04,TN05,TN06,TN07,TN08,TN09,TN0A
		WORD	TN05,TN02,TN03,TN04,TN05,TN06,TN07,TN08,TN09,TN0A
;
PLTRND2		EQU	$		; vC[у|[Y
		WORD	P106,BN02,BN03,BN04,BN05,P011,P012,P011
;
PLTRND3		EQU	$		; vC[|ꍞރ|[Y
		WORD	BN0D,DM00,DM02,DM03,DM04
;
PLTRND4		EQU	$		; vC[Q|[Y
		WORD	BN12
;
PLTRND5		EQU	$		; vC[P|[Y
		WORD	BN13
;
PLTRND6		EQU	$
;
;
PLTRNAR		EQU	$
		WORD	PLTRNDT-PLTRNDT
		WORD	PLTRND1-PLTRNDT
		WORD	PLTRND2-PLTRNDT
		WORD	PLTRND3-PLTRNDT
		WORD	PLTRND4-PLTRNDT
		WORD	PLTRND5-PLTRNDT
;
PLTRNA1		EQU	$
		WORD	PLTRND1-PLTRNDT
		WORD	PLTRND2-PLTRNDT
		WORD	PLTRND3-PLTRNDT
		WORD	PLTRND4-PLTRNDT
		WORD	PLTRND6-PLTRNDT
		WORD	PLTRND6-PLTRNDT
;
;
PLTIMDT		EQU	$
		WORD	0006H,0006H,0006H,0006H,0006H,0006H,0006H
;not;		WORD	0032H,0001H,0004H,0001H,0008H,0004H,0001H,0001H,0001H,0005H
;i^Ȃj
		WORD	0001H,0001H,0004H,0001H,0008H,0004H,0001H,0001H,0001H,0005H
		WORD	0004H,0008H,0004H,0008H,000CH,0004H,0004H,0004H
		WORD	0008H,0020H,0004H,0004H,8000H
		WORD	0010H
		WORD	0010H
;
BABYPTN		EQU	$
		WORD	0004,0004,0004,0004
;
PLBABYS		EQU	$
		LDA	#00030H
		STA	PLPRIO
		LDX	BSPLTP
		JSR	(!PLBABYS_ADR,X)
;
;-------------< baby walk pause >-------------
BABYSET		EQU	$
		LDA	<FRCNT
		AND	#00007
		BNE	BYT100		; baby paturn chenge ?
;					; Yes !!
		LDA	<FRCNT
		AND	#00011000B
		LSR	A
		LSR	A
		TAY
		LDA	!BABYPTN,Y
		STA	ENCHPT		; baby paturn set !!
;
BYT100		EQU	$
		I8
;
		PHB
		LDX	#BANK BABYMMV
		PHX
		PLB
		PHD
;
		LDA	#EN0RAM
		TCD
;
;;;;;;;;		LDA	#EMOVE
;;;;;;;;		STA	ENMODE
		LDX	#000
		STX	ENINDX
;
		JSL	>BABYMMV	; baby move sub !!
		JSL	>EXSTRA		; ʂnaiZbgII
;
		PLD
		PLB
;
		I16			; index 16 bit mode !!
;
		RTS
;
;
PLBABYS_ADR	EQU	$
PWALK0		WORD	PWALKMV		; vC[p^[Zbg
PNAGE0		WORD	PNAGEMV		; vC[p^[Zbg
PYOROK		WORD	PYOROMV		; vC[уp^[Zbg
PTAORE		WORD	PTAORMV		; vC[|ꍞރp^[Zbg
PMIRU2		WORD	PMIR2MV		; vC[Qp^[Zbg
PMIRU1		WORD	PMIR1MV		; vC[Pp^[Zbg
;
;
PWALK		EQU	PWALK0-PLBABYS_ADR
PNAGE		EQU	PNAGE0-PLBABYS_ADR
PYORO		EQU	PYOROK-PLBABYS_ADR
PTAOR		EQU	PTAORE-PLBABYS_ADR
PMIR2		EQU	PMIRU2-PLBABYS_ADR
PMIR1		EQU	PMIRU1-PLBABYS_ADR
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PWALKMV ( vC[p^[Zbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PWALKMV		EQU	$
PTAORMV		EQU	$
PMIR2MV		EQU	$
PMIR1MV		EQU	$
;-------------< player walk pause >-------------
		DEC	PLWKTM
		BNE	PAS100		; player timer "0" ?
;					; Yes !!
		LDA	PLWALK
		INC	A
		INC	A
		CMP	!PLTRNA1,X
		BNE	PAS050		; paturn over ?
;					; Yes!!
		LDA	!PLTRNAR,X
;
PAS050		EQU	$
		STA	PLWALK
		TAY
		LDA	!PLTRNDT,Y
		STA	PLPATN		; player paturn set !!
		LDA	!PLTIMDT,Y
		STA	PLWKTM		; player paturn timer set !!
;
PAS100		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PNAGEMV ( vC[p^[Zbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PNAGEMV		EQU	$
;-------------< player nage pause >-------------
		DEC	PLWKTM
		BNE	PAS100		; player timer "0" ?
;					; Yes !!
		LDA	PLWALK
		INC	A
		INC	A
		CMP	!PLTRNA1,X
		BNE	PAS050		; player nage pause end ?
;					; Yes !!
		LDA	#00020H
		JSL	>SOUND_3_ON	; []
;
		LDX	#00000
		STX	BSPLTP		; player walk type !!
		TXA
		BRA	PAS050
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PYOROMV ( vC[уp^[Zbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PYOROMV		EQU	$
		DEC	PLWKTM
		BNE	PYOROMV_150	; player timer "0" ?
;					; Yes !!
		LDA	PLWALK
		INC	A
		INC	A
		CMP	!PLTRNA1,X
		BNE	PYOROMV_050	; paturn over ?
;					; Yes!!
		LDA	!PLTRNAR,X
;
PYOROMV_050	EQU	$
		STA	PLWALK
		TAY
		CMP	#PLTRND2+2-PLTRNDT
		BNE	PYOROMV_100	; vC[Wv@H
;					; Yes !!
		LDA	#0FC00H
		STA	PLYSPD		; vC[WvXs[hZbg
		INC	PLJUMP		; vC[WvtOhnmh
;
PYOROMV_100	EQU	$
		LDA	!PLTRNDT,Y
		STA	PLPATN		; player paturn set !!
		LDA	!PLTIMDT,Y
		STA	PLWKTM		; player paturn timer set !!
;
PYOROMV_150	EQU	$
		LDA	PLJUMP
		BEQ	PYOROMV_250	; vC[Wv@H
;					; Yes !!
		LDA	PLYSPD
		CLC
		ADC	#00040H
		STA	PLYSPD
		CLC
		ADC	PLYPSL-1
		CMP	#0A800H
		BCC	PYOROMV_200	; WvI@H
;					; Yes !!
		STZ	PLJUMP
		LDA	#0A800H
;
PYOROMV_200	EQU	$
		STA	PLYPSL-1
;
PYOROMV_250	EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	TIMEDEC ( timer dec. set sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
TIMEDEC		EQU	$
		DEC	BONSTM
		BNE	TEC050		; timer "0" ?
;					; Yes !!
		INC	BONSMD		; mode inc. !!
		STZ	<WINDMK
;
TEC050		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	WINDOPN ( window open sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
WINDOPN		EQU	$
		JSR	WINDSET		; window open set sub !!
		LDA	<WINDFG
		BNE	WDN050		; window open end ?
;					; Yes !!
		LDA	#00030H
		STA	BONSTM		; timer set !!
		INC	BONSMD		; mode inc. !!
;
WDN050		EQU	$
NOPRETN		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	TIMDEC0 ( timer dec. set sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MESGDAT		EQU	$
		WORD	00010*4,(10+12)*4,(10+48)*4,(10+60)*4,(10+36)*4,(10+24)*4
;
;;;;;;;;		WORD	00010*2,(10+12)*2,(10+24)*2,(10+36)*2,(10+48)*2,(10+60)*2
;
;
TIMDEC0		EQU	$
		DEC	BONSTM
		BNE	TD0050		; timer "0" ?
;					; Yes !!
;;;;K;;;;		LDX	MPTYPE
		LDX	BONUSNO
		LDA	!MESGDAT,X
		STA	>MSG_RAM+2	; messege No. set !!
		INC	MSGMOD		; messege window "ON" !!
		INC	BONSMD		; mode inc. !!
;
TD0050		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MSWINOP ( messege window open sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BONSNOD		EQU	$
		WORD	BS1MP,BS2MP,BS5MP,BS6MP,BS4MP,BS3MP
;;;;;;;;		WORD	BS1MP,BS2MP,BS3MP,BS4MP,BS5MP,BS6MP
;
;
MSWINOP		EQU	$
		MI8			; memory,index 8 bit mode !!
;
		JSL	>MSGDSP_X	; messege window open sub !!
;
		MI16			; memory,index 16 bit mode !!
;
		JSR	WINDSET
;
		LDA	MSGMOD
		BNE	WIP100		; messege window open end ?
;					; Yes !!
;;;;K;;;;		LDY	MPTYPE
		LDY	BONUSNO
		LDX	BONSMD
		INX
;;;;K;;;;		LDA	>MSG_ANS
;;;;K;;;;		BEQ	WIP050		; game cansel ?
;;;;K;;;;;					; Yes !!
;;;;K;;;;		LDA	#00030H
;;;;K;;;;		STA	BONSTM		; timer set !!
;;;;K;;;;		LDX	!BONSNOD,Y
;;;;K;;;;;
;;;;K;;;;WIP050		EQU	$
		STX	BONSMD		; mode inc. !!
;
WIP100		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	WINCLSB ( window color sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
WINCLSB		EQU	$
		LDA	<FRCNT
		AND	#00001
		BNE	WCB050		; nuki color chenge ?
;					; Yes !!
		LDA	NUKCOL
		SEC
		SBC	#0000010000100001B
		STA	NUKCOL
		BNE	WCB050		; nuki color chenge end ?
;					; Yes !!
		LDA	#00046H
		JSL	>SOUND_3_ON	; []
;
		INC	BONSMD		; mode inc. !!
;
;;;;K;;;;		LDY	MPTYPE
		LDY	BONUSNO
		CPY	#00005*2
		BNE	WCB050		; world 6 ?
;					; Yes !!
		M8			; memory 8 bit mode !!
;
		LDA	#010H
		STA	WMANSL		; window main disp set !!
		LDA	#091H
		STA	SUBADF		; J[Zf[^[Zbg
		LDA	#030H
		STA	WIND25
		STZ	WIND23
		STZ	WIND24
		LDY	#04A53H
;
		INC	SLTCAN		; cancel flag (by.not)
		STY	NUKCOL		; nuki color data set !!
;
		M16			; memory 16 bit mode !!
;
		JMP	SDN070
;
WCB050		EQU	$
		LDY	BONUSNO
		CPY	#00004H*2
		BNE	WCB100		; world 5 ?
;					; Yes !!
		LDA	PLCONT
		INC	A		; player + "BETCNT"
		CMP	#00001H
		BNE	WCB100		; cll@H
;					; Yes !!
		LDA	#00001H
		STA	PLCONT
		LDA	#HMPIN
		STA	MODENO		; map initial mode set !!
		STZ	BONAS_CNT
;
WCB100		EQU	$
		RTS
;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	TIMDEC1 ( timer dec. set sub )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;TIMDEC1		EQU	$
;;;;;;;;		DEC	BONSTM
;;;;;;;;		BNE	TD1050		; timer "0" ?
;;;;;;;;;					; Yes !!
;;;;;;;;		INC	BONSMD		; mode inc. !!
;;;;;;;;;
;;;;;;;;;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		STZ	MASKNO
;;;;;;;;;;;;;;;;		LDA	MASKNO
;;;;;;;;;;;;;;;;		STA	R5
;;;;;;;;;;;;;;;;		M_CHIP	BS_MASKST
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		JSL	>M_DMA_BFST
;;;;;;;;;;;;;;;;		LWORD	WINDBUF		; ]AhX
;;;;;;;;;;;;;;;;		LWORD	WINDBF		; ]AhX
;;;;;;;;;;;;;;;;		WORD	(0D2H*4)	; ]oCg
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		LDY	#002H
;;;;;;;;;;;;;;;;		STY	WMANSL		; window main select clear !!
;;;;;;;;;;;;;;;;		LDY	#084H
;;;;;;;;;;;;;;;;		STY	SUBADF
;;;;;;;;;;;;;;;;		LDY	#0A0H
;;;;;;;;;;;;;;;;		STY	WIND23
;;;;;;;;;;;;;;;;		LDY	#000H
;;;;;;;;;;;;;;;;		STY	WIND24
;;;;;;;;;;;;;;;;		STY	WIND25
;;;;;;;;;;;;;;;;;;;;;;;;		LDY	#002
;;;;;;;;;;;;;;;;;;;;;;;;		STY	0212AH
;;;;;;;;;;;;;;;;;;;;;;;;		LDY	#000
;;;;;;;;;;;;;;;;;;;;;;;;		STY	0212BH
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;;;;;;;;;
;;;;;;;;TD1050		EQU	$
;;;;;;;;		JMP	PLBABYS
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SCRDOWN ( screen down move sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SCRDOWN		EQU	$
		LDA	<SCCV1
		SEC
		SBC	#00008
		STA	<SCCV1
		STA	<SCCV2
		BNE	SDN050		; screen down move end ?
;					; Yes !!
		LDA	#00046H
		JSL	>SOUND_3_ON	;[]
		INC	BONSMD		; mode inc. !!
		STZ	SCDTPT
		LDY	SCDTPT
		LDA	!SCRSPDL,Y
		STA	SCRSPD		; scroll speed (L) set !!
		LDA	!SCRSPDH,Y
		STA	SCRSPD+2	; scroll speed (H) set !!
;
SDN050		EQU	$
;;;;K;;;;		LDX	MPTYPE
		LDX	BONUSNO
		CPX	#00005*2
		BNE	SDN100		; world 6 ?
;					; Yes !!
SDN070		EQU	$
		I8			; index 8 bit mode !!
;
		LDA	<SCCV1
		STA	R1
		M_CHIP	BS_SLOTWIN
;
		I16
;
		JSR	DMABFST		; window buffer tensou sub !!
;;;;;;;		JSR	SLOTHAD		; wxZbg
		JMP	SLOTCST		; slot OBJ set sub !!
;
SDN100		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SCRYURE ( screen yure sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SCRSPDL		EQU	$
		WORD	00000H,00000H,00000H,00000H,00000H
;
SCRSPDH		EQU	$
		WORD	00005H,00004H,00003H,00002H,00001H
;
;
SCRYURE		EQU	$
		LDA	SCRSPD
		SEC
		SBC	#08000H
		STA	SCRSPD
		LDA	SCRSPD+2
		SBC	#00000H
		STA	SCRSPD+2
;
		LDA	SCRSPD
		CLC
		ADC	HSCRLL
		STA	HSCRLL
		LDA	<SCCV1
		ADC	SCRSPD+2
		STA	<SCCV1
		STA	<SCCV2
		BPL	SYE150		; scroll over ?
;					; Yes !!
		LDA	#00046H
		JSL	>SOUND_3_ON	;[]
		STZ	HSCRLL		; scroll (L) clear !!
		STZ	<SCCV1		; screen 1 scroll set !!
		STZ	<SCCV2		; screen 2 scroll set !!
;
		LDA	SCDTPT
		INC	A
		INC	A
		STA	SCDTPT
		TAY
		CPY	#SCRSPDH-SCRSPDL
		BNE	SYE100		; initial speed data pointer over ?
;					; Yes !!
		INC	BONSMD		; mode inc. !!
		LDA	#00030H
		STA	BONSTM		; timer set !!
		BRA	SYE150
;
SYE100		EQU	$
		LDA	!SCRSPDL,Y
		STA	SCRSPD		; initial speed (L) set !!
		LDA	!SCRSPDH,Y
		STA	SCRSPD+2	; initial speed (H) set !!
;
SYE150		EQU	$
		JMP	SDN050
;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	SCRYURE ( screen yure sub )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;SCRYURE		EQU	$
;;;;;;;;		INC	BONSTM
;;;;;;;;		LDA	BONSTM
;;;;;;;;		CMP	#00011H
;;;;;;;;		BEQ	SYE050		; yure end ?
;;;;;;;;;					; No !!
;;;;;;;;		AND	#00001H
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		STA	<SCCV1
;;;;;;;;		STA	<SCCV2
;;;;;;;;		LDA	#00009
;;;;;;;;		STA	SOUND3		;[]
;;;;;;;;		BRA	SYE100
;;;;;;;;;
;;;;;;;;SYE050		EQU	$
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	BONSTM		; timer set !!
;;;;;;;;		INC	BONSMD		; mode inc. !!
;;;;;;;;;
;;;;;;;;SYE100		EQU	$
;;;;;;;;		JMP	SDN050
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	TIMDEC2 ( timer dec. set sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINTMD		EQU	$
		WORD	00005H,00005H,00010H,00015H,00010H,00029H
;;;;;;;;		WORD	00051H,00029H,00010H,00079H,00010H,00015H
;;;;;;;;;;;;;;;;		WORD	00029H,00011H,00019H,00000H,00029H,000F1H
;
;
TIMDEC2		EQU	$
		DEC	BONSTM
		BNE	TD2050		; timer "0" ?
;					; Yes !!
;;;;K;;;;		LDY	MPTYPE
		LDY	BONUSNO
		LDA	!COINTMD,Y
		STA	BONSTM		; yoshi coin counter set !!
		INC	BONSMD		; mode inc. !!
;
TD2050		EQU	$
		JMP	SDN050
;
;[1995/02/08];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/02/08];x		JSR	COINDEC ( yosshy coin dec. sub )		x
;[1995/02/08];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/02/08]COINDEC		EQU	$
;[1995/02/08]		DEC	BONSTM
;[1995/02/08]		BEQ	CNC050		; timer "0" ?
;[1995/02/08];					; No !!
;[1995/02/08]		LDA	BONSTM
;[1995/02/08]		AND	#00003
;[1995/02/08]		BNE	CNC100		; yosshy coin dec. ?
;[1995/02/08];					; Yes !!
;[1995/02/08]		LDA	#00009H
;[1995/02/08]		JSL	>SOUND_3_ON	; []
;;;;K;;;;		LDA	MPTYPE
;[1995/02/08]		LDA	BONUSNO
;[1995/02/08]		CMP	#00005*2
;[1995/02/08]		BNE	CNC030		; U[h@H
;[1995/02/08];					; Yes !!
;[1995/02/08]		DEC	YSCOIN		; bV[RCZ
;[1995/02/08]		BRA	CNC100
;[1995/02/08];
;[1995/02/08]CNC030		EQU	$
;[1995/02/08]		DEC	BONAS_CNT
;[1995/02/08]		BRA	CNC100
;[1995/02/08];
;[1995/02/08]CNC050		EQU	$
;[1995/02/08]		INC	BONSMD		; mode inc. !!
;[1995/02/08];
;[1995/02/08]CNC100		EQU	$
;[1995/02/08]		JSR	PLCNTST		; player counter & yosshy coin set sub	!!
;[1995/02/08]		JMP	SDN050
;[1995/02/08];
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	GAMEWIN ( "X" button messege window sub )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
GAMEWIN		EQU	$
		MI8			; memory,index 8 bit mode !!
;
		JSL	>MSGDSP		; messege window open sub !!
;
		MI16			; memory,index 16 bit mode !!
;
		JSR	DMABFST
;
		LDA	MSGMOD
		BNE	GEN100		; messege window open end ?
;					; Yes !!
;
		JSR	EGGMOVE		;  lnud
;
		LDX	#CADGM
		LDA	>MSG_ANS
		BEQ	GEN050		; game end ?
;					; No !!
;
;;;;K;;;;		LDY	MPTYPE
		LDY	BONUSNO
		CPY	#00000
		BNE	GEN010		; [hPH
;					: yes
;**1994/07/18**		LDA	WITEM0
;**1994/07/18**		STA	<WORK0
;**1994/07/18**		JSR	PLUPSET		; vC[ to Zbg
;
		MI8			; memory,index 8bit mode
;
		LDY	#006
GEN005		EQU	$
		LDA	WITEM0,Y
		BNE	GEN006
		DEY
		BPL	GEN005
		BRA	GEN007
;
GEN006		EQU	$
		MI16
		LDA	#00005H
		STA	<SOUND_0	; [] TEhZbg
		LDA	#00090H
		STA	BONSTM		; wait timer
		LDX	#PYORO		; vC[
		STX	BSPLTP		; player type set !!
		LDA	!PLTRNAR,X
		JSR	PAS050
		MI8
;
		JSR	ITEMBST		; ACe obt@Zbg
;
GEN007		EQU	$
		MI16			; memory,index 16bit mode
;
GEN010		EQU	$
		LDX	BONSMD
		INX
;
GEN050		EQU	$
		STX	BONSMD		; mode inc. !!
;
GEN100		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MODEMAP ( map mode set sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MODEMAP		EQU	$
		JSR	EGGMOVE		;  lnud
;
		LDA	<KEYC2L
		AND	#000F0H
		ORA	<KEYC2
		BNE	MEP030		; push any key ?
;					; Yes !!
		DEC	BONSTM
		BNE	MEP050		; timer "0" ?
;					; Yes !!
MEP030		EQU	$
		LDA	#HMPIN
		STA	MODENO		; map initial mode set !!
		STZ	!BONAS_CNT
;
		MI8			; memory , index 8bit mode
		JSL	>SVDTSV
		MI16			; memory , index 16bit mode
;
MEP050		EQU	$
;;;;K;;;;		LDX	MPTYPE
		LDX	BONUSNO
		CPX	#00005*2
		BNE	MEP100		; world 6 ?
;					; Yes !!
;
;[1995/06/12]		JSR	SLOTHAD		; wxZbg
		JMP	SLOTCST		; slot OBJ set sub !!
;
MEP100		EQU	$
		RTS
;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	MASKOPN ( mask open set sub )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;MASKOPN		EQU	$
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		INC	MASKNO
;;;;;;;;		LDA	MASKNO
;;;;;;;;		STA	R5
;;;;;;;;		M_CHIP	BS_MASKST
;;;;;;;;;
;;;;;;;;		JSL	>M_DMA_BFST
;;;;;;;;		LWORD	WINDBUF		; ]AhX
;;;;;;;;		LWORD	WINDBF		; ]AhX
;;;;;;;;		WORD	(0D2H*4)	; ]oCg
;;;;;;;;;
;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	MASKNO
;;;;;;;;		CMP	#00020H
;;;;;;;;		BNE	MKN050		; mask window open end ?
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	BONSTM		; timer set !!
;;;;;;;;		INC	BONSMD		; mode inc. !!
;;;;;;;;;
;;;;;;;;MKN050		EQU	$
;;;;;;;;		JMP	PLBABYS
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	TIMDEC3 ( timer dec. set sub )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;TIMDEC3		EQU	$
;;;;;;;;		DEC	BONSTM
;;;;;;;;		BNE	TD3050		; timer "0" ?
;;;;;;;;;					; Yes !!
;;;;;;;;		INC	BONSMD		; mode inc. !!
;;;;;;;;;
;;;;;;;;TD3050		EQU	$
;;;;;;;;		JMP	PLBABYS
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;**1994/07/18**;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;**1994/07/18**;		JSR	PLUPSET ( vC[ to JEg Zbg )	x
;**1994/07/18**;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;**1994/07/18**;
;**1994/07/18**;	ihmj
;**1994/07/18**;		vnqjO   F	   to JEg
;**1994/07/18**;
;**1994/07/18**;========================================================================
;**1994/07/18**;
;**1994/07/18**PLUPSET		EQU	$
;**1994/07/18**		PHP
;**1994/07/18**;
;**1994/07/18**		M16
;**1994/07/18**		LDA	<WORK0
;**1994/07/18**		AND	#000FFH
;**1994/07/18**		CLC
;**1994/07/18**		ADC	PLUPCT
;**1994/07/18**		STA	PLUPCT
;**1994/07/18**;
;**1994/07/18**		PLP
;**1994/07/18**		RTS
;**1994/07/18**;
;**1994/07/18**;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	RANDSET ( WORLD 1 oo _ Zbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
card_hate	EQU	00H	  ; nei_
card_suka	EQU	01H	  ; XJi[`j
card_mi_g	EQU	02H	  ; ؂̎i΁j
card_mi_r	EQU	03H	  ; ؂̎iԁj
card_10up	EQU	04H	  ; PO
card_eggf	EQU	05H	  ; etkk
card_st10	EQU	06H	  ; X^[iPOj
card_st20	EQU	07H	  ; X^[iQOj
card_powb	EQU	08H	  ; onv
card_musi	EQU	09H	  ; ዾ
card_hazu	EQU	0AH	  ; nYiJbNj
card_mi_b	EQU	0BH	  ; ؂̎ij
;
;
CARDTBL		EQU	$
;(0)
		BYTE	card_hazu,card_st10,card_eggf,card_powb
		BYTE	card_hate,card_musi,card_mi_g,card_suka
;(1)
		BYTE	card_hazu,card_st10,card_st20,card_powb
		BYTE	card_hate,card_musi,card_suka,card_suka
;(2)
		BYTE	card_hazu,card_hazu,card_st20,card_mi_g
		BYTE	card_mi_r,card_mi_b,card_suka,card_suka
;(3)
		BYTE	card_hazu,card_hazu,card_st10,card_st20
		BYTE	card_st10,card_eggf,card_suka,card_suka
;(4)
		BYTE	card_hazu,card_st20,card_mi_g,card_mi_r
		BYTE	card_mi_b,card_suka,card_suka,card_suka
;(5)
		BYTE	card_hazu,card_hazu,card_hazu,card_st20
		BYTE	card_st20,card_st20,card_suka,card_suka
;(6)
		BYTE	card_hazu,card_st10,card_st10,card_hate
		BYTE	card_musi,card_suka,card_suka,card_suka
;(7)
		BYTE	card_hazu,card_hazu,card_st10,card_st10
		BYTE	card_st20,card_musi,card_suka,card_suka
;
;
;
RANDSET		EQU	$
;==========================================================
;;;;;;	LDA	#00008		; JbN fobOp
;;;;;;	STA	SLCOIN		; ( I )
;==========================================================
;
;-----< me[uEZNg >-----------------------------------------
;
		JSL	>RANDAM		; _ 
;
		MI8			; memory,index 8 bit mode !!
;
		LDA	RANDM0
		AND	#007
		TAX
;
		LDA	#000
RAND010		EQU	$
		DEX
		BMI	RAND012
;
		CLC
		ADC	#008		; #009
		BRA	RAND010
;
RAND012		EQU	$
		TAY			; f[^CfbNX
;
		M16			; memory 16bit mode !!
;
		LDA	!CARDTBL,Y
		STA	<WORK0
		LDA	!CARDTBL+2,Y
		STA	<WORK2
		LDA	!CARDTBL+4,Y
		STA	<WORK4
		LDA	!CARDTBL+6,Y
		STA	<WORK6
		LDA	!CARDTBL+8,Y
		STA	<WORK8
;
		M8			; memory 8 bit mode !!
;
;
;-----< J[he[uEZbg >-----------------------------------------
;
		LDA	#008		; #009
		STA	<WORKA		; 搔
		LDY	#000		; e[uE|Cg
;
RAND020		EQU	$
		JSL	>RANDAM		; _ 
;
		LDA	<WORKA
		STA	4202H
		LDA	RANDM0
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		M16			; memory 16bit mode !!
		LDA	4216H
		XBA
		M8			; memory 8bit mode !!
		AND	#00FH
		TAX
		LDA	<WORK0,X
		STA	RANTBL,Y
		INY
		CPY	#007		; #008
		BEQ	RAND024		; chPhH
;					: no
		DEC	<WORKA
RAND022		EQU	$
		CPX	<WORKA
		BEQ	RAND020		; last point ?
;					: no
		LDA	<WORK0+1,X	; f[^Ol
		STA	<WORK0,X
		INX
		BRA	RAND022
;
RAND024		EQU	$
		TXA
		EOR	#001
		TAX
		LDA	<WORK0,X
;[1994/09/26]		STA	RANTBL+8	; last data set !!
		STA	RANTBL+7	; last data set !!
;
;
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDSEL ( WORLD 1 oo J[h ZNg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CARDSEL		EQU	$
		MI8			; memory,index 8bit mode !!
;
;-----<  lnud I`FbN >---------------------------------------
;
		LDA	ENWRK0
		BEQ	CARS000		;  lnud H
;					: yes
;
		JSR	EGGMOVE		;  lnud
;
		BRA	CARS099
;
;-----< I`FbN (͂) >------------------------------------------
;
CARS000		EQU	$
;[1994/09/27]		LDA	SLCOIN
;[1994/09/27]		BEQ	CARS0001	; J[hP߂@H
;[1994/09/27];					; Yes !!
;[1994/09/27]		LDA	<KEYC2L
;[1994/09/27]		AND	#01000000B
;[1994/09/27]		BEQ	CARS0001	; "X" button "ON" ?
;[1994/09/27];					; Yes !!
;[1994/09/27];
;[1994/09/27]		LDA	#00010*4+1	; #00010*2+1
;[1994/09/27]		STA	>MSG_RAM+2	; messege No. set !!
;[1994/09/27]		INC	MSGMOD
;[1994/09/27]		LDA	#BS1WN
;[1994/09/27]		BRA	CARS0015
;
CARS0001	EQU	$
		LDA	CARDNUM
		CMP	#00AH
		BNE	CARS002		; ͂iJbNjH
;					: yes
CARS001		EQU	$
		MI16
		LDX	#PTAOR
		STX	BSPLTP		; player type set !!
		LDA	!PLTRNAR,X
;?????		STA	PLWALK		; paturn No. set !!
		JSR	PAS050
		MI8
;
;[1995/06/07]		LDA	#07DH
;[1995/06/07]		JSL	>SOUND_3_ON	; [] TEhZbg
;
		LDA	#BS1MP		; next mode
CARS0015	EQU	$
		STA	BONSMD
		LDA	#0C0H		; timer
		STA	BONSTM
;
		BRA	CARS099
;
;-----< I`FbN (c薇) >----------------------------------------
;
CARS002		EQU	$
		LDA	SLCOIN
		CMP	#007		; #008
		BNE	CARS007		; cPH
;					: yes
;
		JSR	ITEMBST		; ACe obt@Zbg
;
		MI16
		LDX	#PYORO
		STX	BSPLTP		; player type set !!
		LDA	!PLTRNAR,X
;?????		STA	PLWALK		; paturn No. set !!
		JSR	PAS050
		MI8
;
		LDA	#KAMIN
		STA	BONSMD		; next mode
		LDA	#060H
		STA	BONSTM		; timer
		BRA	CARS099
;
;-----< C  >------------------------------------------------
;
CARS007		EQU	$
		LDA	CARDMV
		BEQ	CARS010		; J[\ Ă ?
;					: yes
;
		JSR	CARDMOV		; J[\ lnud
		BRA	CARS020
;
CARS010		EQU	$
		JSR	CARDKEY		;  `FbN
;
CARS020		EQU	$
		JSR	CARDOAM		; J[\ n`l Zbg
;
;------------------------------------------------------------------------
;
CARS099		EQU	$
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDMOV ( WORLD 1 oo J[\ lnud )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
;	<< CARDMV >>
;
;		0 : rsno
;		1 : 
;		2 : E
;		3 : 
;		4 : 
;
;========================================================================
;
CARDXDT		EQU	$
		HEX	058,078,098
CARDYDT		EQU	$
		HEX	060,080,0A0
CARDADD		EQU	$
		HEX	002,0FE
;
;
CARDMOV		EQU	$
		MI8			; memory,index 8bit mode !!
;
		LDA	CARDMV
		CMP	#003
		BCS	CARS050
;
;-----< R lnud >--------------------------------------------------
;
		LDX	CRCNXP
		LDA	!CARDXDT,X
		CMP	CRCXPS
		BEQ	CARS080		; move end ?
;					: no
		LDA	CARDMV
		AND	#001
		TAX
		LDA	CRCXPS
		CLC
		ADC	!CARDADD,X
		STA	CRCXPS
		BRA	CARS090
;
;-----< ^e lnud >--------------------------------------------------
;
CARS050		EQU	$
		LDX	CRCNYP
		LDA	!CARDYDT,X
		CMP	CRCYPS
		BEQ	CARS080		; move end ?
;					: no
		LDA	CARDMV
		AND	#001
		TAX
		LDA	CRCYPS
		CLC
		ADC	!CARDADD,X
		STA	CRCYPS
		BRA	CARS090
;
;-----< tO NA[ >------------------------------------------------
;
CARS080		EQU	$
		STZ	CARDMV
;
;------------------------------------------------------------------------
;
CARS090		EQU	$
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDKEY ( WORLD 1 oo  `FbN )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CARDKEY		EQU	$
		MI8			; memory,index 8bit mode !!
;
;
		LDA	KEYA2
		AND	#11000000B
		BNE	CARK010		; (B)or(Y) key on ?
;					: yes
		LDA	KEYA2L
		AND	#10000000B
		BNE	CARK010		; (A) key on ?
;					: no
		JMP	CARK050
;
;-----< J[h߂ >---------------------------------------------------
;
CARK010		EQU	$
		LDA	CRCNYP
		ASL	A
		ORA	CRCNYP
		CLC
		ADC	CRCNXP
		STA	CARDPOS		; J[h onr
		CMP	#004
		BNE	CARK015		; Z ?
;					: yes
		LDA	#001
		STA	ENWRK0		; [V [h
		INC	BONSMD		; mode inc. !!
		BRA	CARK042
;
CARK015		EQU	$
		BMI	CARK020		; >4 ?
;					: yes
;
		DEC	A		; (A)-1
;
CARK020		EQU	$
		TAX
		LDA	RANTBL,X
		CMP	#0FFH
		BNE	CARK040		; A߂Ă H
;					: yes
CARK030		EQU	$
		JMP	CARK090
;
CARK040		EQU	$
		STA	CARDNUM		; J[h mD
;[1994/09/26]		STX	CARDPOS		; J[h onr
		LDA	#0FFH
		STA	RANTBL,X	; ߂`
		LDA	#001
		STA	ENWRK0		; [V [h
		INC	SLCOIN		; J[h JEg Abv
;
		INC	BONSMD		; mode inc. !!
;
		LDA	CARDNUM
		CMP	#card_suka
		BEQ	CARK042		; XJi[`jH
;					: No
		CMP	#card_hazu
		BEQ	CARK042		; nYiJbNjH
;					: No
;
		JSR	ITEMCUP		; ACe JEgAbv
;
CARK042		EQU	$
		JSR	EGG_KAMAE	;  CjVi܂j
;
		MI16			; memory,index 16bit mode !!
;
		LDA	#TN01
		STA	PLPATN		; player paturn set !!
;[1994/09/01]		LDA	#00002
;[1994/09/01]		STA	BSPLTP		; player type set !!
;[1994/09/01]		LDA	#00000
;[1994/09/01]		STA	PLWALK		; paturn No. set !!
;[1994/09/01]		JMP	CARK090
;
		LDX	#PNAGE
		STX	BSPLTP		; player type set !!
		LDA	!PLTRNAR,X
;?????		STA	PLWALK		; paturn No. set !!
		JMP	PAS050
;
;
;-----< J[\ lnud >----------------------------------------------
;
CARK050		EQU	$
		MI8			; memory,index 8bit mode !!
;
		LDA	KEYA2
		AND	#00001111B
		BEQ	CARK030		; (+) key on ?
;					: yes
		LDA	#05CH
		JSL	>SOUND_3_ON	; [] TEhZbg
;
		LDA	KEYA2
		AND	#00000011B
		BEQ	CARK070
;
		AND	#00000010B
		BEQ	CARK060
;
; ----------- [  ] -----------
;
		LDA	CRCNXP
		BNE	CARK052		; "Left" position ?
;					: yes
		LDX	#002
		STX	CRCNXP
		LDA	CARDXDT,X
		STA	CRCXPS
;
		LDA	CRCNYP
		DEC	A
		BPL	CARK051
		LDA	#002
CARK051		EQU	$
		STA	CRCNYP
		TAX
		LDA	CARDYDT,X
		STA	CRCYPS		; (Y) pos reset !!
		JMP	CARK090
;
CARK052		EQU	$
		DEC	CRCNXP
		LDA	#001
		STA	CARDMV		; flag set
		JMP	CARK090
;
; ----------- [ E ] -----------
;
CARK060		EQU	$
		LDA	CRCNXP
		CMP	#002
		BNE	CARK062		; "Right" position ?
;					: yes
		LDX	#000
		STX	CRCNXP
		LDA	CARDXDT,X
		STA	CRCXPS
;
		LDA	CRCNYP
		INC	A
		CMP	#003
		BNE	CARK061
		LDA	#000
CARK061		EQU	$
		STA	CRCNYP
		TAX
		LDA	CARDYDT,X
		STA	CRCYPS		; (Y) pos reset !!
		BRA	CARK090
;
CARK062		EQU	$
		INC	CRCNXP
		LDA	#002
		STA	CARDMV		; flag set
		BRA	CARK090
;
;
CARK070		EQU	$
		LDA	KEYA2
		AND	#00001000B
		BEQ	CARK080
;
; ----------- [  ] -----------
;
		LDA	CRCNYP
		BNE	CARK072		; "Up" position ?
;					: yes
		LDX	#002
		STX	CRCNYP
		LDA	CARDYDT,X
		STA	CRCYPS
		BRA	CARK090
;
CARK072		EQU	$
		DEC	CRCNYP
		LDA	#003
		STA	CARDMV		; flag set
		BRA	CARK090
;
; ----------- [  ] -----------
;
CARK080		EQU	$
		LDA	CRCNYP
		CMP	#002
		BNE	CARK082		; "Down" position ?
;					: yes
		LDX	#000
		STX	CRCNYP
		LDA	CARDYDT,X
		STA	CRCYPS
		BRA	CARK090
;
CARK082		EQU	$
		INC	CRCNYP
		LDA	#004
		STA	CARDMV		; flag set
;
;-------------------------------------------------------------------------
;
CARK090		EQU	$
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;[1995/05/02];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/05/02];x		JSR	ITEMIDX ( WORLD 1 oo ACe index )	x
;[1995/05/02];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/05/02]ITEMIDX		EQU	$
;[1995/05/02]		MI8			; memory,index 8bit mode !!
;[1995/05/02];
;[1995/05/02]		LDX	#000
;[1995/05/02]ITDX010		EQU	$
;[1995/05/02]		LDA	ITEMBUF,X
;[1995/05/02]		BEQ	ITDX090
;[1995/05/02];
;[1995/05/02]		INX
;[1995/05/02]		CPX	#027
;[1995/05/02]		BNE	ITDX010
;[1995/05/02];
;[1995/05/02]ITDX090		EQU	$
;[1995/05/02]		STX	ITEMID		; CfbNX Zbg
;[1995/05/02];
;[1995/05/02]		RTS
;[1995/05/02];
;[1995/05/02];
;[1995/05/02];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/05/02];x		JSR	ITMFULL ( WORLD 1 oo ACe etkk )	x
;[1995/05/02];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/05/02]ITMFULL		EQU	$
;[1995/05/02]		JSL	>RANDAM		; _ 
;[1995/05/02];
;[1995/05/02]		LDA	RANDM0
;[1995/05/02]		AND	#001
;[1995/05/02]		BNE	ITFL010		;  H
;[1995/05/02];					: yes
;[1995/05/02];
;[1995/05/02]		M16			; memory 16bit mode !!
;[1995/05/02];
;[1995/05/02]		LDA	PLCONT
;[1995/05/02]		CMP	#999
;[1995/05/02]		BEQ	ITFL010		; vC[ XXXl H
;[1995/05/02];					: no
;[1995/05/02];
;[1995/05/02]		M8			; memory 8bit mode !!
;[1995/05/02];
;[1995/05/02]		INC	WITEM0		; vC[ 
;[1995/05/02]		LDA	#002		; P  G
;[1995/05/02]		STA	CARDNUM
;[1995/05/02]		BRA	ITFL090
;[1995/05/02];
;[1995/05/02]ITFL010		EQU	$
;[1995/05/02]		M8			; memory 8bit mode !!
;[1995/05/02];
;[1995/05/02]		LDA	#001		; v[G
;[1995/05/02]		STA	CARDNUM
;[1995/05/02];
;[1995/05/02]ITFL090		EQU	$
;[1995/05/02]		RTS
;[1995/05/02];
;[1995/05/02];
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ITEMBST ( WORLD 1 oo obt@Zbg)	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ITEMBST		EQU	$
		MI8			; memory.index 8bit mode
;
		LDX	#000
ITBS010		EQU	$
		LDA	WITEM0,X
		BEQ	ITBS090		; ACe̓o^H
;					: yes
;
		PHX			; (X) push
;
		JSR	ITEMINPUT	; ACe̓o^
;
		PLX			; (X) pull
;
		INX
		CPX	#007
		BNE	ITBS010		; l`wZbgH
;					: yes
ITBS090		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ITEMCUP ( WORLD 1 oo ACe Abv )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
;	ACeۑq`l
;
;		vhsdlO`U : ACemD
;		vhsdlV	 : ACeCfbNX
;		vhsdlW	 : gp
;		vhsdlX	 : v[[l
;
;========================================================================
;
hate_adr	EQU	06H	 ; nei_
mi_g_adr	EQU	07H	 ; ؂̎i΁j
mi_r_adr	EQU	09H	 ; ؂̎iԁj
eggf_adr	EQU	04H	 ; etkk
st10_adr	EQU	01H	 ; X^[iPOj
st20_adr	EQU	02H	 ; X^[iQOj
powb_adr	EQU	03H	 ; onv
musi_adr	EQU	05H	 ; ዾ
mi_b_adr	EQU	08H	 ; ؂̎ij
;
ITEMADR		EQU	$
		BYTE	hate_adr	; (0) nei_
		BYTE	000		; (1) XJi[`j
		BYTE	mi_g_adr	; (2) ؂̎i΁j
		BYTE	mi_r_adr	; (3) ؂̎iԁj
		BYTE	000		; (4) PO
		BYTE	eggf_adr	; (5) etkk
		BYTE	st10_adr	; (6) X^[iPOj
		BYTE	st20_adr	; (7) X^[iQOj
		BYTE	powb_adr	; (8) onv
		BYTE	musi_adr	; (9) ዾ
		BYTE	000		; (A) nYiJbNj
		BYTE	mi_b_adr	; (B) ؂̎ij
;
;
ITEMCUP		EQU	$
		MI8			; memory,index 8bit mode !!
;
		LDY	WITEM7
		LDX	CARDNUM
		LDA	!ITEMADR,X
		STA	WITEM0,Y
		INC	WITEM7
		RTS
;
;
		MEM16
		IDX16
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDOAM ( WORLD 1 oo J[\ OAM set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CARDOAM		EQU	$
		MI16			; memory,index 16bit mode !!
;
		LDY	OAMIDX
		LDA	<FRCNT
		AND	#00008H
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0		; move work
;
		LDA	<FRCNT
		AND	#00010H
		BEQ	CAOM010
;
		LDA	<WORK0
		EOR	#0FFFFH
		INC	A
		STA	<WORK0
;
CAOM010		EQU	$
		LDA	CRCXPS
		INC	A
		CLC
		ADC	<WORK0
		AND	#000FFH
		STA	SOAM_DX+00H,Y
		STA	SOAM_DX+10H,Y
		LDA	CRCXPS
		DEC	A
		CLC
		ADC	#010H
		SEC
		SBC	<WORK0
		AND	#000FFH
		STA	SOAM_DX+08H,Y
		STA	SOAM_DX+18H,Y
;
		LDA	CRCYPS
		INC	A
		CLC
		ADC	<WORK0
		AND	#000FFH
		STA	SOAM_DX+02H,Y
		STA	SOAM_DX+0AH,Y
		LDA	CRCYPS
		DEC	A
		CLC
		ADC	#010H
		SEC
		SBC	<WORK0
		AND	#000FFH
		STA	SOAM_DX+12H,Y
		STA	SOAM_DX+1AH,Y
;
		LDA	#0309FH
		STA	SOAM_DX+04H,Y
		LDA	#0709FH
		STA	SOAM_DX+0CH,Y
		LDA	#0B09FH
		STA	SOAM_DX+14H,Y
		LDA	#0F09FH
		STA	SOAM_DX+1CH,Y
;
		LDA	#00000
		STA	SOAM_DX+06H,Y
		STA	SOAM_DX+0EH,Y
		STA	SOAM_DX+16H,Y
		STA	SOAM_DX+1EH,Y
;
		TYA
		CLC
		ADC	#00008*4
		STA	OAMIDX		; next index set !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	BONUSCT ( WORLD 1 oo player & coin up )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BONUSCT		EQU	$
		JSR	EGGMOVE		;  lnud
;
		DEC	BONSTM
		BNE	BOCT090		; timer "0" ?
;					: yes
;
;-----< I`FbN >---------------------------------------------------
;
		LDA	WITEM9
		AND	#000FFH
		BNE	BOCT010		; vC[I H
;					: yes
		LDA	#00080H
		STA	BONSTM		; timer
		LDA	#BS1MP
		STA	BONSMD		; next mode
		BRA	BOCT090
;
;-----< vC[ >-----------------------------------------------------
;
BOCT010		EQU	$
		LDA	PLCONT
		CMP	#999
		BNE	BOCT011
;
		M8			; memory 8bit mode !!
		STZ	WITEM9
		M16			; memory 16bit mode !!
		INC	BONSTM		; timer <-- "1"
		BRA	BOCT090
;
BOCT011		EQU	$
		M8			; memory 8bit mode !!
		DEC	WITEM9
		LDA	#008H
		JSL	>SOUND_3_ON	; [] TEhZbg
		M16			; memory 16bit mode !!
;
		INC	PLCONT
;
;-----< f[^ vqhsd >----------------------------------------------
;
BOCT030		EQU	$
		JSR	PLCNTST		; vC[ Abv
;
		LDA	#00030H
		STA	BONSTM		; timer
;
;------------------------------------------------------------------------
;
BOCT090		EQU	$
		RTS
;
;
;
;--------------------------------------------------------
;-	Babanuki card mekuri				-
;--------------------------------------------------------
bg1_adrs	EQU	06800H
bg2_adrs	EQU	03800H
nuki_chr	EQU	00000H
omote_data	EQU	011006CH
open_speed	EQU	008H
;
;[1995/05/01] card_6C		EQU	0100H
;[1995/05/01] card_6D		EQU	card_6C+9
;[1995/05/01] card_6E		EQU	card_6D+9
;[1995/05/01] card_6F		EQU	card_6E+9
;[1995/05/01] card_70		EQU	card_6F+9
;[1995/05/01] card_71		EQU	card_70+9
;[1995/05/01] card_72		EQU	card_71+9
;[1995/05/01] card_73		EQU	card_72+9
;[1995/05/01] card_74		EQU	card_73+9
;[1995/05/01] card_75		EQU	card_74+9
;[1995/05/01] card_76		EQU	card_75+9
;[1995/05/01] card_77		EQU	card_76+9
;[1995/05/01] card_78		EQU	0180H
;[1995/05/01] card_79		EQU	card_78+9
;[1995/05/01] ;
;[1995/05/01] CARDDATA	EQU	$
;[1995/05/01]		HEX	6D, 6E, 75, 76
;[1995/05/01]		HEX	78, 6F, 70, 79
;[1995/05/01]		HEX	71, 72, 73, 77
;[1995/05/01] ;
;[1995/05/01] CARDBGCHR EQU	$
;[1995/05/01]		WORD	0001010000000000B+card_6D, 0001010000000000B+card_6D+1, 0001010000000000B+card_6D+2
;[1995/05/01]		WORD	0001010000000000B+card_6D+3, 0001010000000000B+card_6D+4, 0001010000000000B+card_6D+5
;[1995/05/01]		WORD	0001010000000000B+card_6D+6, 0001010000000000B+card_6D+7, 0001010000000000B+card_6D+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0001010000000000B+card_6E, 0001010000000000B+card_6E+1, 0001010000000000B+card_6E+2
;[1995/05/01]		WORD	0001010000000000B+card_6E+3, 0001010000000000B+card_6E+4, 0001010000000000B+card_6E+5
;[1995/05/01]		WORD	0001010000000000B+card_6E+6, 0001010000000000B+card_6E+7, 0001010000000000B+card_6E+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0000110000000000B+card_75, 0000110000000000B+card_75+1, 0000110000000000B+card_75+2
;[1995/05/01]		WORD	0000110000000000B+card_75+3, 0000110000000000B+card_75+4, 0000110000000000B+card_75+5
;[1995/05/01]		WORD	0000110000000000B+card_75+6, 0000110000000000B+card_75+7, 0000110000000000B+card_75+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0000110000000000B+card_76, 0000110000000000B+card_76+1, 0000110000000000B+card_76+2
;[1995/05/01]		WORD	0000110000000000B+card_76+3, 0000110000000000B+card_76+4, 0000110000000000B+card_76+5
;[1995/05/01]		WORD	0000110000000000B+card_76+6, 0000110000000000B+card_76+7, 0000110000000000B+card_76+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0000110000000000B+card_78, 0000110000000000B+card_78+1, 0000110000000000B+card_78+2
;[1995/05/01]		WORD	0000110000000000B+card_78+3, 0000110000000000B+card_78+4, 0000110000000000B+card_78+5
;[1995/05/01]		WORD	0000110000000000B+card_78+6, 0000110000000000B+card_78+7, 0000110000000000B+card_78+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0000110000000000B+card_6F, 0000110000000000B+card_6F+1, 0000110000000000B+card_6F+2
;[1995/05/01]		WORD	0000110000000000B+card_6F+3, 0000110000000000B+card_6F+4, 0000110000000000B+card_6F+5
;[1995/05/01]		WORD	0000110000000000B+card_6F+6, 0000110000000000B+card_6F+7, 0000110000000000B+card_6F+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0000110000000000B+card_70, 0000110000000000B+card_70+1, 0000110000000000B+card_70+2
;[1995/05/01]		WORD	0000110000000000B+card_70+3, 0000110000000000B+card_70+4, 0000110000000000B+card_70+5
;[1995/05/01]		WORD	0000110000000000B+card_70+6, 0000110000000000B+card_70+7, 0000110000000000B+card_70+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0000110000000000B+card_79, 0000110000000000B+card_79+1, 0000110000000000B+card_79+2
;[1995/05/01]		WORD	0000110000000000B+card_79+3, 0000110000000000B+card_79+4, 0000110000000000B+card_79+5
;[1995/05/01]		WORD	0000110000000000B+card_79+6, 0000110000000000B+card_79+7, 0000110000000000B+card_79+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0001010000000000B+card_71, 0001010000000000B+card_71+1, 0001010000000000B+card_71+2
;[1995/05/01]		WORD	0001010000000000B+card_71+3, 0001010000000000B+card_71+4, 0001010000000000B+card_71+5
;[1995/05/01]		WORD	0001010000000000B+card_71+6, 0001010000000000B+card_71+7, 0001010000000000B+card_71+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0001010000000000B+card_72, 0001010000000000B+card_72+1, 0001010000000000B+card_72+2
;[1995/05/01]		WORD	0001010000000000B+card_72+3, 0001010000000000B+card_72+4, 0001010000000000B+card_72+5
;[1995/05/01]		WORD	0001010000000000B+card_72+6, 0001010000000000B+card_72+7, 0001010000000000B+card_72+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0001010000000000B+card_73, 0001010000000000B+card_73+1, 0001010000000000B+card_73+2
;[1995/05/01]		WORD	0001010000000000B+card_73+3, 0001010000000000B+card_73+4, 0001010000000000B+card_73+5
;[1995/05/01]		WORD	0001010000000000B+card_73+6, 0001010000000000B+card_73+7, 0001010000000000B+card_73+8
;[1995/05/01] ;
;[1995/05/01]		WORD	0000110000000000B+card_77, 0000110000000000B+card_77+1, 0000110000000000B+card_77+2
;[1995/05/01]		WORD	0000110000000000B+card_77+3, 0000110000000000B+card_77+4, 0000110000000000B+card_77+5
;[1995/05/01]		WORD	0000110000000000B+card_77+6, 0000110000000000B+card_77+7, 0000110000000000B+card_77+8
;
;
card_6C		EQU	0100H		; ghs
card_6D		EQU	card_6C+9	; nei_
card_6E		EQU	card_6D+9	; XJi[`j
card_6F		EQU	card_6E+9	; etkk
card_70		EQU	card_6F+9	; X^[iPOj
card_71		EQU	card_70+9	; onv
card_72		EQU	card_71+9	; ዾ
card_73		EQU	card_72+9	; nYiJbNj
card_74		EQU	card_73+9	; H
card_78		EQU	0180H		; PO
card_79		EQU	card_78+9	; X^[iQOj
card_7A		EQU	card_79+9	; ؂̎iԁj
card_7B		EQU	card_7A+9	; ؂̎i΁j
card_7C		EQU	card_79+9	; ؂̎ij
;
CARDDATA	EQU	$
		HEX	6D, 6E, 7A, 7B
		HEX	78, 6F, 70, 79
		HEX	71, 72, 73, 7A
;
CARDBGCHR	EQU	$
;ynei_z
		WORD	0000110000000000B+card_6D+0, 0000110000000000B+card_6D+1, 0000110000000000B+card_6D+2
		WORD	0000110000000000B+card_6D+3, 0000110000000000B+card_6D+4, 0000110000000000B+card_6D+5
		WORD	0000110000000000B+card_6D+6, 0000110000000000B+card_6D+7, 0000110000000000B+card_6D+8
;yXJz
		WORD	0001010000000000B+card_6E+0, 0001010000000000B+card_6E+1, 0001010000000000B+card_6E+2
		WORD	0001010000000000B+card_6E+3, 0001010000000000B+card_6E+4, 0001010000000000B+card_6E+5
		WORD	0001010000000000B+card_6E+6, 0001010000000000B+card_6E+7, 0001010000000000B+card_6E+8
;y؂̎i΁jz
		WORD	0001000000000000B+card_7A+0, 0001000000000000B+card_7A+1, 0001000000000000B+card_7A+2
		WORD	0001000000000000B+card_7A+3, 0001000000000000B+card_7A+4, 0001000000000000B+card_7A+5
		WORD	0001000000000000B+card_7A+6, 0001000000000000B+card_7A+7, 0001000000000000B+card_7A+8
;y؂̎iԁjz
		WORD	0001010000000000B+card_7B+0, 0001010000000000B+card_7B+1, 0001010000000000B+card_7B+2
		WORD	0001010000000000B+card_7B+3, 0001010000000000B+card_7B+4, 0001010000000000B+card_7B+5
		WORD	0001010000000000B+card_7B+6, 0001010000000000B+card_7B+7, 0001010000000000B+card_7B+8
;yPOz
		WORD	0000110000000000B+card_78+0, 0000110000000000B+card_78+1, 0000110000000000B+card_78+2
		WORD	0000110000000000B+card_78+3, 0000110000000000B+card_78+4, 0000110000000000B+card_78+5
		WORD	0000110000000000B+card_78+6, 0000110000000000B+card_78+7, 0000110000000000B+card_78+8
;yetkkz
		WORD	0000110000000000B+card_6F+0, 0000110000000000B+card_6F+1, 0000110000000000B+card_6F+2
		WORD	0000110000000000B+card_6F+3, 0000110000000000B+card_6F+4, 0000110000000000B+card_6F+5
		WORD	0000110000000000B+card_6F+6, 0000110000000000B+card_6F+7, 0000110000000000B+card_6F+8
;yX^[iPOjz
		WORD	0000110000000000B+card_70+0, 0000110000000000B+card_70+1, 0000110000000000B+card_70+2
		WORD	0000110000000000B+card_70+3, 0000110000000000B+card_70+4, 0000110000000000B+card_70+5
		WORD	0000110000000000B+card_70+6, 0000110000000000B+card_70+7, 0000110000000000B+card_70+8
;yX^[iQOjz
		WORD	0001010000000000B+card_79+0, 0001010000000000B+card_79+1, 0001010000000000B+card_79+2
		WORD	0001010000000000B+card_79+3, 0001010000000000B+card_79+4, 0001010000000000B+card_79+5
		WORD	0001010000000000B+card_79+6, 0001010000000000B+card_79+7, 0001010000000000B+card_79+8
;yonvz
		WORD	0001010000000000B+card_71+0, 0001010000000000B+card_71+1, 0001010000000000B+card_71+2
		WORD	0001010000000000B+card_71+3, 0001010000000000B+card_71+4, 0001010000000000B+card_71+5
		WORD	0001010000000000B+card_71+6, 0001010000000000B+card_71+7, 0001010000000000B+card_71+8
;yዾz
		WORD	0000110000000000B+card_72+0, 0000110000000000B+card_72+1, 0000110000000000B+card_72+2
		WORD	0000110000000000B+card_72+3, 0000110000000000B+card_72+4, 0000110000000000B+card_72+5
		WORD	0000110000000000B+card_72+6, 0000110000000000B+card_72+7, 0000110000000000B+card_72+8
;ynYiJbNjz
		WORD	0001010000000000B+card_73+0, 0001010000000000B+card_73+1, 0001010000000000B+card_73+2
		WORD	0001010000000000B+card_73+3, 0001010000000000B+card_73+4, 0001010000000000B+card_73+5
		WORD	0001010000000000B+card_73+6, 0001010000000000B+card_73+7, 0001010000000000B+card_73+8
;y؂̎ijz
		WORD	0000110000000000B+card_7C+0, 0000110000000000B+card_7C+1, 0000110000000000B+card_7C+2
		WORD	0000110000000000B+card_7C+3, 0000110000000000B+card_7C+4, 0000110000000000B+card_7C+5
		WORD	0000110000000000B+card_7C+6, 0000110000000000B+card_7C+7, 0000110000000000B+card_7C+8
;
;ybV[iRCӂ₵jz
		WORD	0000110000000000B+card_6C+0, 0000110000000000B+card_6C+1, 0000110000000000B+card_6C+2
		WORD	0000110000000000B+card_6C+3, 0000110000000000B+card_6C+4, 0000110000000000B+card_6C+5
		WORD	0000110000000000B+card_6C+6, 0000110000000000B+card_6C+7, 0000110000000000B+card_6C+8
;
CARDADDR	EQU	$
		WORD	018BH+bg1_adrs, 018FH+bg1_adrs, 0193H+bg1_adrs
		WORD	020BH+bg1_adrs, 020FH+bg1_adrs, 0213H+bg1_adrs
		WORD	028BH+bg1_adrs, 028FH+bg1_adrs, 0293H+bg1_adrs
;
CLEARCARD	EQU	$
		WORD	nuki_chr, nuki_chr, nuki_chr
;
CARDXPOSDT	EQU	$
		HEX	54, 74, 94
		HEX	54, 74, 94
		HEX	54, 74, 94
;
CARDYPOSDT	EQU	$
		HEX	5C, 5C, 5C
		HEX	7C, 7C, 7C
		HEX	9C, 9C, 9C
;
CARDATTRDTOMOTE EQU	$
		BYTE	00110110B, 00110010B, 00110110B
		BYTE	00110010B, 00110110B, 00110010B
		BYTE	00110110B, 00110010B, 00110110B
;
CARDATTRDTURA	EQU	$
		BYTE	00110010B, 00110110B, 00110100B, 00110110B
		BYTE	00110010B, 00110010B, 00110010B, 00110110B
		BYTE	00110110B, 00110110B, 00110110B, 00110010B
;
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
BNS_PAL_DT	EQU	$
		BYTE	000H*12,005H*12,006H*12
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
HKRKERINIT	EQU	$
		LDA	!CARDPOS		; card address number load !!
		AND	#000FFH
		PHA
		ASL	A
		TAX
		LDA	#00003H
		STA	<WORKE
		LDY	CARDADDR,X
HKINT0010	EQU	$
		LDA	#BANK CLEARCARD
		STA	<WORK1
		LDX	#CLEARCARD
		LDA	#0006H
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		DEC	<WORKE
		BNE	HKINT0010		; card clear end ? [no->HKINT0010]
;
		PLA				; card address number pull !!
		TAX
		CLC
		ADC	#CARDATTRDTOMOTE
		STA	<WORK0			; attribute data address
		TXA
		CLC
		ADC	#CARDXPOSDT
		STA	<WORK2			; x position data address
		TXA
		CLC
		ADC	#CARDYPOSDT
		STA	<WORK4			; y position data address
		JSR	CARDOAMSET		; card OAM set !!
;
		STZ	!OPENCNT
;
		LDA	#omote_data
		LDX	#BANK omote_data
		JSR	CARDOPEN
;
		RTS
;
;
HKRKEROMOTE	EQU	$
		JSR	EGGMOVE		;  lnud
;
		LDA	!OPENCNT
		CLC
		ADC	#open_speed
		STA	!OPENCNT
		CMP	#00080H
		BMI	HKOMOTE0010		;
;
		INC	!BONSMD
		RTS
;
HKOMOTE0010	EQU	$
		LDA	!CARDPOS		; card address number load !!
		AND	#000FFH
		TAX
		CLC
		ADC	#CARDATTRDTOMOTE
		STA	<WORK0			; attribute data address
		TXA
		CLC
		ADC	#CARDXPOSDT
		STA	<WORK2			; x position data address
		TXA
		CLC
		ADC	#CARDYPOSDT
		STA	<WORK4			; y position data address
		JSR	CARDOAMSET		; card OAM set !!
;
		LDA	#omote_data
		LDX	#BANK omote_data
		JMP	CARDOPEN
;
;
HKRKERURA	EQU	$
		JSR	EGGMOVE		;  lnud
;
		LDA	!OPENCNT
		SEC
		SBC	#open_speed
		STA	!OPENCNT
;;;;;;;;		BPL	HKURA0080		;
		BMI	HKURA0005
		JMP	HKURA0080
;
HKURA0005	EQU	$
		LDA	!CARDPOS		; card address number load !!
		AND	#000FFH
		ASL	A
		TAX
		LDY	CARDADDR,X
		LDA	!CARDNUM
		AND	#000FFH
		STA	<WORK0
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	<WORK0
		CLC
		ADC	<WORK0
		CLC
		ADC	#CARDBGCHR
		TAX
		LDA	#00003H
		STA	<WORKE
HKURA0010	EQU	$
		LDA	#BANK CARDBGCHR
		STA	<WORK1
		LDA	#0006H
		PHX
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		PLA
		CLC
		ADC	#00006H
		TAX
		DEC	<WORKE
		BNE	HKURA0010		; card clear end ? [no->HKURA0010]
;
		LDA	BONSMD
		CMP	#BONSM
		BEQ	HKURA0040	; JbNH
;					: no
		LDA	SLCOIN
		CMP	#00009
		BNE	HKURA0020	; W߂H
;					: yes
		LDA	#00020H
		STA	BONSTM		; timer
		LDA	#KAMEM
		BRA	HKURA0030
;
HKURA0020	EQU	$
		LDA	CARDNUM
		AND	#000FFH
		CMP	#card_suka
		BNE	HKURA0021	; XJi[`jH
;					: yes
		LDA	#00090H
		BRA	HKURA0025
;
HKURA0021	EQU	$
		CMP	#card_hazu
		BNE	HKURA0022	; nYiJbNjH
;					: yes
		LDA	#0007DH
		BRA	HKURA0025
;
HKURA0022	EQU	$		; ̑ij
		LDA	#0008FH
;
HKURA0025	EQU	$
		JSL	>SOUND_3_ON	; [] TEhZbg

		LDA	#CADGM
HKURA0030	EQU	$
		STA	!BONSMD		; next mode
;
HKURA0040	EQU	$
		RTS
;
;
HKURA0080	EQU	$
		LDA	!CARDNUM
		AND	#000FFH
		TAY
		CLC
		ADC	#CARDATTRDTURA
		STA	<WORK0			; attribute data address
		LDA	!CARDPOS		; card address number load !!
		AND	#000FFH
		TAX
		CLC
		ADC	#CARDXPOSDT
		STA	<WORK2			; x position data address
		TXA
		CLC
		ADC	#CARDYPOSDT
		STA	<WORK4			; y position data address
		JSR	CARDOAMSET		; card OAM set !!
;
		LDA	CARDDATA,Y
		AND	#000FFH
		LDX	#00011H
;
CARDOPEN	EQU	$
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		CMP	#0006FH		;etkk
		BEQ	BNS_PAL_500
		CMP	#0006CH		;H
		BNE	BNS_PAL_900
BNS_PAL_500	EQU	$
		LDY	!LNGG_SL
		CLC
		ADC	BNS_PAL_DT,Y
		AND	#000FFH
BNS_PAL_900	EQU	$
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
		STA	R3
;;;		LDA	#00011H
;;;		STA	R1
		STX	R1
		LDA	!OPENCNT		; kaiten counter set !!
		STA	R2
		LDA	#00100H
		STA	R11
;
		I8				; index 8bit mode !!
;
		M_CHIP	AICONHKAITEN
;
		I16				; index 16bit mode !!
;
		JSR	BCOBJCHRDMA
;
		RTS
;
;
CARDOAMSET	EQU	$
		PHY
		LDY	!OAMIDX
;---- x position set ----
		LDA	(<WORK2)
		AND	#000FFH
		STA	!SOAM_DX,Y
		STA	!SOAM_DX+16,Y
		CLC
		ADC	#00010H
		STA	!SOAM_DX+8,Y
		STA	!SOAM_DX+24,Y
;---- y position set ----
		LDA	(<WORK4)
		AND	#000FFH
		STA	!SOAM_DX+2,Y
		STA	!SOAM_DX+8+2,Y
		CLC
		ADC	#00010H
		STA	!SOAM_DX+16+2,Y
		STA	!SOAM_DX+24+2,Y
;---- char number set ----
;---- attribute set ----
		LDA	(<WORK0)
		XBA
		AND	#0FF00H
		ORA	#001E8H			; obj char number
		STA	!SOAM_DX+4,Y
		INC	A
		INC	A
		STA	!SOAM_DX+8+4,Y
		INC	A
		INC	A
		STA	!SOAM_DX+16+4,Y
		INC	A
		INC	A
		STA	!SOAM_DX+24+4,Y
;---- oamsub set ----
		LDA	#00002H
		STA	!SOAM_DX+6,Y
		STA	!SOAM_DX+8+6,Y
		STA	!SOAM_DX+16+6,Y
		STA	!SOAM_DX+24+6,Y
;---- oam index koshin ----
		TYA
		CLC
		ADC	#32
		STA	!OAMIDX
		PLY
		RTS
;
;
BCOBJCHRDMA	EQU	$
		LDA	#BANK WOB7CHR
		STA	<WORK1		;(WK1) <-- ]AhXiaj
		LDY	#05E80H		;(Y) <-- uq`lAhX
		LDX	#WOB7CHR	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#05F80H		;(Y) <-- uq`lAhX
		LDX	#WOB7CHR+200H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#05EC0H		;(Y) <-- uq`lAhX
		LDX	#WOB7CHR+400H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#05FC0H		;(Y) <-- uq`lAhX
		LDX	#WOB7CHR+600H	;(X) <-- ]AhX (k,g)
		LDA	#00080H		;(A) <-- ]oCg
		JSL	>VRAMDX_ST
		RTS
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	EGG_KAMAE ( WORLD 1 ܂ initial )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PLNAGEXP	EQU	$
		WORD	00007H		; [old] 0000EH
		WORD	0000DH
		WORD	0000CH
		WORD	0000AH
		WORD	00008H
		WORD	00008H
		WORD	00003H
		WORD	0FFFDH
		WORD	0FFF6H
;
PLNAGEYP	EQU	$
		WORD	0000AH		; [old] 00010H
		WORD	00010H
		WORD	00010H
		WORD	0000CH
		WORD	0000BH
		WORD	00004H
		WORD	00003H
		WORD	00003H
		WORD	00003H
;
;
EGG_KAMAE	EQU	$
		M16			; memory 16bit mode
		I8			; index 8bit mode
;
		LDY	#00004
		LDA	#EGG00
		JSL	>ENINSR2	;  Zbg
;
		LDA	PLXPSL
		CLC
		ADC	!PLNAGEXP
		STA	ENXPSL+4	; w |WV
		LDA	PLYPSL
		CLC
		ADC	!PLNAGEYP
		STA	ENYPSL+4	; x |WV
		STZ	ENXSPD+4	; w Xs[h
		STZ	ENYSPD+4	; x Xs[h
		LDA	#00001H
		STA	ENYUSN+4
		LDA	#00030H		; D揇ʁuRv
		STA	ENCLOR+4
		STZ	ENWRK6		; TEh^C}[
;
		I16			; index 16bit mode
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	EGGINIT1 ( WORLD 1  initial )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGGMVXP		EQU	$
		WORD	00050H+00010H,00070H+00010H,00090H+00010H
;
EGGMVYP		EQU	$
		WORD	00058H+00010H,00078H+00010H,00098H+00010H
;
;
;
EGGINIT1	EQU	$
		I8			; index 8bit mode
;
;;;;;;;		LDY	#00004
;;;;;;;		LDA	#EGG00
;;;;;;;		JSL	>ENINSR2	;  Zbg
;
;;;;;;;		LDA	#EGGSHXP	; w |WV
;;;;;;;		STA	ENXPSL+4
		LDA	ENXPSL+4
		STA	R3		;iqRj || ݂wW
;;;;;;;		LDA	#EGGSHYP	; x |WV
;;;;;;;		STA	ENYPSL+4
		LDA	ENYPSL+4
		STA	R4		;iqSj || ݂xW
;
		LDA	CRCNXP
		AND	#000FFH
		ASL	A
		TAX
		LDA	!EGGMVXP,X
		STA	R1		;iqPj || ڕWwW
		LDA	CRCNYP
		AND	#000FFH
		ASL	A
		TAX
		LDA	!EGGMVYP,X
		STA	R2		;iqQj || ڕWxW
		LDA	#00600H
		I8			; index 8bit mode
		STA	R6		;iqUj || T[`Xs[h
;
		M_CHIP	SEARCH_SPEED
;
		LDA	R1		;iqPj || wXs[h
		STA	ENXSPD+4
		LDA	R2		;iqQj || xXs[h
		STA	ENYSPD+4
;
		I16			; index 16bit mode
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	EGGINIT6 ( WORLD 6  initial )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGGMVXP6	EQU	$
		WORD	0003CH,0005CH,0007CH,0009CH,000BCH
		WORD	0002CH,0004CH,000ACH,000CCH
		WORD	0003CH,0005CH,0007CH,0009CH,000BCH
;
EGGMVYP6	EQU	$
		WORD	0005CH,0005CH,0005CH,0005CH,0005CH
		WORD	0007CH,0007CH,0007CH,0007CH
		WORD	0009CH,0009CH,0009CH,0009CH,0009CH
;
;
EGGINIT6	EQU	$
		I8			; index 8bit mode
;
		LDA	ENXPSL+4
		STA	R3		;iqRj || ݂wW
		LDA	ENYPSL+4
		STA	R4		;iqSj || ݂xW
;
		LDA	COINPT
		AND	#000FFH
		ASL	A
		TAX
		LDA	!EGGMVXP6,X
		STA	R1		;iqPj || ڕWwW
		LDA	!EGGMVYP6,X
		STA	R2		;iqQj || ڕWxW
		LDA	#00600H
		I8			; index 8bit mode
		STA	R6		;iqUj || T[`Xs[h
;
		M_CHIP	SEARCH_SPEED
;
		LDA	R1		;iqPj || wXs[h
		STA	ENXSPD+4
		LDA	R2		;iqQj || xXs[h
		STA	ENYSPD+4
;
		I16			; index 16bit mode
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	EGGMOVE ( WORLD 1 oo  lnud )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGGMOVE		EQU	$
		M16			; memory 16bit mode
		I8			; index 8bit mode
;
		LDA	ENWRK0
		BNE	EGGM000		;  ȂH
;					: yes
		JMP	EGGM090
;
;
EGGM000		EQU	$
;
;-----< ̎ `FbN >--------------------------------------------
;
;
EGGM001		EQU	$
		CMP	#00002
		BEQ	EGGM005		; i lnud H
		CMP	#00003
;;;;;;		BEQ	EGGM020		; oEh lnud H
		BNE	EGGM0001	; oEh lnud H
;
		JMP	EGGM020
;
EGGM0001		EQU	$
;
;-----<  [V lnud >-------------------------------------
;
		LDA	PLPATN
		CMP	#TN0A
		BNE	EGGM002		;  nj H
;					: yes
		LDA	#04AH		; #020H
		JSL	>SOUND_3_ON	; [] TEhZbg
;
;;;;K;;;;		LDA	MPTYPE
		LDA	BONUSNO
		CMP	#00006H
		BEQ	EGGM0011	; [h H
;
		JSR	EGGINIT1	; World (1) CjV
		BRA	EGGM0012
;
EGGM0011	EQU	$
		JSR	EGGINIT6	; World (6) CjV
;
EGGM0012	EQU	$
		INC	ENWRK0		; i [h
		JMP	EGGM090
;
;|||mVbgETEhZbgn|||||||||||||||
;
EGGM002		EQU	$
;[1995/04/27]		INC	ENWRK6
;[1995/04/27]		LDA	ENWRK6
;[1995/04/27]		AND	#00003H
;[1995/04/27]		BNE	EGGM003		; TEhZbgH
;[1995/04/27];					: yes
;[1995/04/27]		LDA	ENWRK6
;[1995/04/27]		AND	#0007CH
;[1995/04/27]		LSR	A
;[1995/04/27]		LSR	A
;[1995/04/27]		CLC
;[1995/04/27]		ADC	#0004AH
;[1995/04/27]		CMP	#00051H		; sound 4BH~50H
;[1995/04/27]		BCC	EGGM0027
;[1995/04/27];
;[1995/04/27]EGGM0025	EQU	$
;[1995/04/27]		LDA	#009H		; p[l`w
;[1995/04/27]EGGM0027	EQU	$
;[1995/04/27]		JSL	>SOUND_3_ON	; [] TEhZbg
;[1995/04/27];
;|||||||||||||||||||||||||||||||||
;
EGGM003		EQU	$
		LDY	#PNAGE
		LDA	PLWALK
		SEC
		SBC	!PLTRNAR,Y
		TAX
		LDA	PLXPSL
		CLC
		ADC	!PLNAGEXP,X
		STA	ENXPSL+4	; w |WV
		LDA	PLYPSL
		CLC
		ADC	!PLNAGEYP,X
		STA	ENYPSL+4	; x |WV
		BRA	EGGM040
;
;
;-----<  i lnud >-----------------------------------------------
;
EGGM005		EQU	$
		JSR	SMOKEST		; Zbg
;
;;;;K;;;;		LDA	MPTYPE
		LDA	BONUSNO
		CMP	#006H
		BEQ	EGGM006		; [h H
;
		JSR	EGSTMV1		; World (1)
		BRA	EGGM010
;
EGGM006		EQU	$
		JSR	EGSTMV6		; World (6)
;
EGGM010		EQU	$
		CPY	#000
		BEQ	EGGM040		; |WV over ?
;					: yes
;
		LDA	#0FF00H		; w Xs[h
		STA	ENXSPD+4
		LDA	#0FC00H		; x Xs[h
		STA	ENYSPD+4
		INC	ENWRK0		;  ԃtOioEhj
;
		LDA	BONSMD
		CMP	#ZOMIN
		BEQ	EGGM040		; ZH
;					: no
		LDA	#067H
		JSL	>SOUND_3_ON	; [] TEhZbg
		INC	BONSMD		; oEh [h
		BRA	EGGM040
;
;
;-----<  oEh lnud >-------------------------------------------
;
EGGM020		EQU	$
		LDA	ENYPSL+4
		CMP	#000E0H
		BCS	EGGM030		; ďH
;					: no
		LDA	ENYSPD+4
		CLC
		ADC	#00040H		; d
		STA	ENYSPD+4
		BRA	EGGM040
;
EGGM030		EQU	$
		STZ	ENWRK0		;  ԃtO NA[
;
		BRA	EGGM050
;
;-----<  |WV Zbg >-------------------------------------------
;
EGGM040		EQU	$
;;;;;		LDA	#00030H		; D揇ʁuRv
;[1994/09/01]		TSB	ENCLOR+4
;;;;;		STA	ENCLOR+4
;
		LDX	#004
		JSL	>EN_XYMOVE
;
;-----< J[\ n`l Zbg >-----------------------------------------
;
EGGM050		EQU	$
;;;;;;;		JSR	CARDOAM
;
;------------------------------------------------------------------------
;
EGGM090		EQU	$
		I16			; index 16bit mode
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	EGSTMV1 ( WORLD 1  i move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGSTMV1		EQU	$
		I8			; index 8bit mode
;
		LDY	#000
;
		LDA	CRCNXP
		AND	#000FFH
		ASL	A
		TAX
		LDA	ENXPSL+4
		CMP	!EGGMVXP,X
		BCC	EGS1010		; w |WV over ?
;					: no
		LDA	CRCNYP
		AND	#000FFH
		ASL	A
		TAX
		LDA	ENYPSL+4
		CMP	!EGGMVYP,X
		BCS	EGS1020		; x |WV over ?
;					: yes
;
EGS1010		EQU	$
		M8			; memory 8bit mode
		I16			; index 16bit mode
;
		LDA	CRCNYP
		ASL	A
		ORA	CRCNYP
		CLC
		ADC	CRCNXP
		CMP	#004
		BNE	EGS1015		; ZH
;					: yes
;
		M16			; memory 16bit mode
;
		JSR	SEISERAS	; ZJ[h 
;
	JSR	SEIOAMSET	; OAM set
		LDA	#00100H
		STA	OPENCNT		; {
	JSR	SEISZOOM	; Y[Zbg
		LDA	#008H
		JSL	>SOUND_3_ON	; [] TEhZbg
		LDA	#ZOMIN
		STA	BONSMD		; next mode
		BRA	EGS1017
;
EGS1015		EQU	$
		M16			; memory 16bit mode
;
		JSR	HKRKERINIT	;iPjJ[h߂ CjV
;
EGS1017		EQU	$
		LDY	#00001
EGS1020		EQU	$
		I8			; index 8bit mode
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	EGSTMV6 ( WORLD 6  i move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGSTMV6		EQU	$
		I8			; index 8bit mode
;
		LDY	#000
;
		LDA	COINPT
		AND	#000FFH
		CMP	#00008
		BEQ	EGS6005		; iE[ H
;					: no
		ASL	A
		TAX
		LDA	ENXPSL+4
		CMP	!EGGMVXP6,X
		BCC	EGS6010		; w |WV over ?
;					: no
		LDA	ENYPSL+4
		CMP	!EGGMVYP6,X
		BCS	EGS6020		; x |WV over ?
;					: yes
		BRA	EGS6010
;
;
EGS6005		EQU	$
		ASL	A
		TAX
		LDA	ENXPSL+4
		CMP	!EGGMVXP6,X
		BCC	EGS6020		; w |WV over ?
;					: yes
;
EGS6010		EQU	$
		I16			; index 16bit mode
;
		JSR	COINRIT		;iUj_o CjV
;
		LDY	#001
EGS6020		EQU	$
		I8			; index 8bit mode
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SMOKEST ( WORLD 1 oo Zbg )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SMOKEST		EQU	$
		LDA	FRCNT
		AND	#001
		BNE	SMOK090
;
		LDA	#DSMK0
		JSL	>EXINSR
		LDA	ENXPSL+4
		STA	EXXPSL,Y
		LDA	ENYPSL+4
		STA	EXYPSL,Y
		LDA	#005
		STA	EXWRK0,Y
		LDA	#005
		STA	EXCHPT,Y
		LDA	#004
		STA	EXTIM0,Y
		LDA	#006
		STA	EXYUSN,Y
		LDA	#020H+00001100B		; priority,color
		STA	EXCLOR,Y
;
SMOK090		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMEINT ( WORLD 1 oo JbNhmhs )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KAMEINT		EQU	$
;;;;;;;		JSR	EGGMOVE
;
		DEC	BONSTM
		BPL	KAMIN090
;
		MI8			; memory,index 8bit mode !!
;
		LDA	#006H
		STA	<SOUND_0	; [] TEhZbg
;
		LDX	#000
KAMIN010	EQU	$
		LDA	RANTBL,X
		CMP	#0FFH
		BNE	KAMIN020	; JbNH
;					: no
		INX
		BRA	KAMIN010
;
KAMIN020	EQU	$
		STA	CARDNUM		; J[h mD
;
		CPX	#004
		BMI	KAMIN030	; > ZH
;					: yes
		INX			; (X)+1
KAMIN030	EQU	$
		STX	CARDPOS		; J[h onr
;
		INC	SLCOIN		; ߂J[h JE^[
		INC	BONSMD		; next mode
;
		MI16			; memory,index 16bit mode !!
;
		LDA	#00100H
		STA	OPENCNT		; {
		LDA	#051H
		JSL	>SOUND_3_ON	; [] TEhZbg
;
;-----------------------------------------------
;;;;;;		LDA	#HKROM
;;;;;;		STA	BONSMD		; next mode
;;;;;;;
;;;;;;		LDA	#01CH
;;;;;;		STA	<SOUND3		;  TEhZbg
;;;;;;;
;;;;;;		MI16			; memory,index 16bit mode !!
;;;;;;;
;;;;;;		JMP	HKRKERINIT	; J[h߂ CjV
;-----------------------------------------------
;
KAMIN090	EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMEMIN ( WORLD 1 oo JbN l`hm )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
;	<< RAM >>
;
;		ENWRK0		; J[h Y[ lncd
;		ENWRK1		;	   "
;		ENWRK2		;  lncd
;		ENWRK3		;     "
;		ENWRK4		; JbN lncd
;		ENWRK5		;	 "
;
;========================================================================
;
KAMEMIN		EQU	$
		JSR	CZOOMST		; J[h Y[
		JSR	SMOKEMV		; 
		JSR	KAMKMOV		; JbN
;
KAMENOP		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CZOOMST ( WORLD 1 oo card zoom set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CZOOMST		EQU	$
		LDA	KAMMD0
		ASL	A
		TAX
		JMP	(!ZOOMADR,X)
;
;
ZOOMADR		EQU	$
		WORD	ZOOMUP		; zoom up
;;;;;;;		WORD	ZOOMSTOP	; zoom stop
		WORD	ZOOMDOWN	; zoom down
		WORD	FLIPINT		; kaiten initial
		WORD	FLIPMOV		; kaiten move
		WORD	KAMENOP		; (no play)
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ZOOMUP ( WORLD 1 oo "zoom up" move )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ZOOMCNT		EQU	00004
;
;
ZOOMUP		EQU	$
		JSR	ZOOMOAM		; OAM set
;
		LDA	OPENCNT
		CMP	#00150H
		BNE	ZOUP010
;
		LDA	#053H
		JSL	>SOUND_3_ON	; [] TEhZbg
		INC	KAMMD0		; next mode (zoom)
		BRA	ZOUP020
;
ZOUP010		EQU	$
		CLC
		ADC	#ZOOMCNT
		STA	OPENCNT
;
ZOUP020		EQU	$
		JMP	CARDZOOM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ZOOMSTOP ( WORLD 1 oo "zoom stop" move )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;ZOOMSTOP	EQU	$
;;;;;;		JSR	ZOOMOAM		; OAM set
;;;;;;;
;;;;;;		LDA	OPENCNT
;;;;;;		JMP	CARDZOOM
;;;;;;;
;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ZOOMDOWN  ( WORLD 1 oo "zoom down" move ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ZOOMDOWN	EQU	$
		LDA	OPENCNT
		CMP	#00120H
		BNE	ZODN010		; яo^C~OH
;					: yes
;
		INC	KAMMD1		; next mode (kemuri)
		INC	KAMMD2		; next mode (kamekku)
		LDA	#004H
		JSL	>SOUND_3_ON	; [] TEhZbg
		BRA	ZODN020
;
ZODN010		EQU	$
		CMP	#00100H
		BNE	ZODN020
;
		INC	KAMMD0		; next mode (zoom)
		BRA	ZODN030
;
ZODN020		EQU	$
		JSR	ZOOMOAM		; OAM set
;
		LDA	OPENCNT
		SEC
		SBC	#ZOOMCNT
		STA	OPENCNT
;
ZODN030		EQU	$
		JMP	CARDZOOM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ZOOMOAM	 ( WORLD 1 oo card zoom OAM set ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ZOOMOAM		EQU	$
		LDA	CARDPOS
		AND	#000FFH
		TAX
		CLC
		ADC	#CARDATTRDTOMOTE
		STA	<WORK0		; attribute data address
		TXA
		CLC
		ADC	#CARDXPOSDT
		STA	<WORK2		; x position data address
		TXA
		CLC
		ADC	#CARDYPOSDT
		STA	<WORK4		; y position data address
;
		JSR	CARDOAMSET	; card OAM set !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDZOOM ( WORLD 1 oo J[h Y[ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CARDZOOM	EQU	$
		STA	R6		; {
		LDA	#00011H
		STA	R1		; CMODE NO.
		LDA	#0006CH
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		LDY	!LNGG_SL
		CLC
		ADC	BNS_PAL_DT,Y
		AND	#000FFH
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
		STA	R3		; R[X mn.
;
		I8			; index 8bit mode
;
		M_CHIP	MPAICNZM
;
		I16			; index 16bit mode
;
		JSR	BCOBJCHRDMA
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	FLIPINT ( WORLD 1 oo ] initial )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
FLIPSPD		EQU	00040H
FLIPCNT		EQU	00002H
;
;
FLIPINT		EQU	$
		LDA	ENXPSL+4
		CMP	KMOLDXP
		BCS	FLIN010
;
		M8			; memory 8bit mode
;
		LDA	#004
		STA	CARDNUM		; POJ[hZbg
		LDA	#010
		STA	WITEM9		; lZbg
;
		M16			; memory 16bit mode
;
		STZ	ENWRK0
		LDA	#FLIPSPD
		STA	KCARDSP		; ] Xs[h
		STZ	KCARDFA		; \^ tO
;
		JSR	HKRKERINIT	; ЂԂ initial
;
;;;;;;;		STZ	OPENCNT
;
		LDA	#051H
		JSL	>SOUND_3_ON	; [] TEhZbg
;
		INC	KAMMD0		; next mode (zoom)
;
FLIN010		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	FLIPMOV ( WORLD 1 oo ] lnud )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MINFLSP		EQU	00004		; minimum flip speed
;
FLIPMOV		EQU	$
		LDA	KCARDFA
		AND	#00001
		BNE	FLMV010
;
;-----< \ lnud >----------------------------------------------------
;
		LDA	OPENCNT
		CLC
		ADC	KCARDSP
		CMP	#00080H
		BCC	FLMV050		; \^ `FW H
;					: yes
		SEC
		SBC	#00080H
		STA	<WORK0
;
		LDA	#00080H
		SEC
		SBC	<WORK0
		STA	OPENCNT
		BRA	FLMV020
;
;-----<  lnud >----------------------------------------------------
;
FLMV010		EQU	$
		LDA	OPENCNT
		SEC
		SBC	KCARDSP
		BPL	FLMV050		; \^ `FW H
;					: yes
		STA	<WORK0
;
		LDA	KCARDFA
		AND	#00003
		CMP	#00001
		BNE	FLMV015		; PO H
;					: yes
		LDX	KCARDSP
		CPX	#MINFLSP
		BNE	FLMV015		; ]IH
;					: yes
;
		STZ	SLCOIN		; ߂NA
		LDA	WITEM0
		CLC
		ADC	#00010
		STA	WITEM0		; vC[
		LDA	#BONSM
		STA	BONSMD		; next mode
;[1995/06/07]		      LDA     #005H
;[1995/06/07]		      STA     <SOUND_0	      ; [] TEhZbg
		LDA	#00090H		; #00200H
		STA	BONSTM		; timer
		JMP	HKURA0005
;
FLMV015		EQU	$
		LDA	<WORK0
		EOR	#0FFFFH
		INC	A
		STA	OPENCNT
;
;-----< \^ `FW >------------------------------------------------
;
FLMV020		EQU	$
		LDA	KCARDSP
		CMP	#MINFLSP
		BEQ	FLMV030
;
		SEC
		SBC	#FLIPCNT
		STA	KCARDSP
;
FLMV030		EQU	$
		INC	KCARDFA
		LDA	KCARDFA
		AND	#000001
		BNE	FLMV060
;
		LDA	#007H
		JSL	>SOUND_3_ON	; [] TEhZbg
		BRA	FLMV060
;
;
;-----< J[hZbg >---------------------------------------------------
;
FLMV050		EQU	$
		STA	OPENCNT
;
FLMV060		EQU	$
		LDA	OPENCNT
;;;;;;;		CMP	#00080H
;;;;;;;		BNE	FLMV070		; \Ȃ H
;					: yes
		CMP	#0007CH
		BCC	FLMV070		; \Ȃ H
;					: yes
		RTS
;
;
FLMV070		EQU	$
		LDA	KCARDFA
		AND	#00003
		ASL	A
		TAX
		JMP	(!HIKRIAD,X)
;
;
HIKRIAD		EQU	$
		WORD	HKOMOTE0010	; \ ighsj
		WORD	HKURA0080	;  iPOj
		WORD	HKURA0080	;  iPOj
		WORD	HKOMOTE0010	; \ ighsj
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SMOKEMV ( WORLD 1 oo card kemuri set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SMOKEMV		EQU	$
		LDA	KAMMD1
		BEQ	SMMV090
;
		CMP	#(SMOKXPS-SMOKETB)+1
		BCS	SMMV090
;
		JSR	SMOKE00		; kemuri move
;
		INC	KAMMD1		; next mode (kemuri)
;
SMMV090		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SMOKE00 ( WORLD 1 oo kemuri move set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SMOKECH		EQU	$
		WORD	02CE1H		; 0
		WORD	02CE2H		; 1
		WORD	02CF0H		; 2
		WORD	02CF1H		; 3
		WORD	02CF2H		; 4
;
SMOKETB		EQU	$
		HEX	004,004,004
		HEX	001,001,001
		HEX	001,001,001
		HEX	002,002,002,002
		HEX	003,003,003,003,003
		HEX	000,000,000,000,000
;
SMOKXPS		EQU	$
		HEX	061,081,0A1
		HEX	061,081,0A1
		HEX	061,081,0A1
;
SMOKYPS		EQU	$
		HEX	069,069,069
		HEX	089,089,089
		HEX	0A9,0A9,0A9
;
;
SMOKE00		EQU	$
;;;;;;;		LDA	KAMMD1
;;;;;;;		CLC
;;;;;;;		ADC	#00018		; S{a
		LDA	KAMMD1
		DEC	A
		AND	#0FFFCH
		LSR	A
		LSR	A
		CLC
		ADC	#00017
		STA	<WORKE		; add,sub count
;
		LDA	CARDPOS
		AND	#000FFH
		TAX
		LDA	!SMOKXPS,X
		AND	#000FFH
		STA	<WORK4		; <middle> X pos
		TAY
		SEC
		SBC	<WORKE
		STA	<WORK0		; <left> X pos
		TYA
		CLC
		ADC	<WORKE
		STA	<WORK2		; <right> X pos
;
		LDA	!SMOKYPS,X
		AND	#000FFH
		STA	<WORKA		; <middle> Y pos
		TAY
		SEC
		SBC	<WORKE
		STA	<WORK6		; <up> Y pos
		TYA
		CLC
		ADC	<WORKE
		STA	<WORK8		; <down> Y pos
;
		JSR	SMOKEOM		; OAM set
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SMOKEOM ( WORLD 1 oo kemuri OAM set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SMOKEOM		EQU	$
		LDY	OAMIDX
;
		LDA	<WORK0
		STA	SOAM_DX+00H,Y
		STA	SOAM_DX+18H,Y
		STA	SOAM_DX+28H,Y
		LDA	<WORK2
		STA	SOAM_DX+10H,Y
		STA	SOAM_DX+20H,Y
		STA	SOAM_DX+38H,Y
		LDA	<WORK4
		STA	SOAM_DX+08H,Y
		STA	SOAM_DX+30H,Y
;
		LDA	<WORK6
		STA	SOAM_DX+02H,Y
		STA	SOAM_DX+0AH,Y
		STA	SOAM_DX+12H,Y
		LDA	<WORK8
		STA	SOAM_DX+2AH,Y
		STA	SOAM_DX+32H,Y
		STA	SOAM_DX+3AH,Y
		LDA	<WORKA
		STA	SOAM_DX+1AH,Y
		STA	SOAM_DX+22H,Y
;
		LDA	KAMMD1
		DEC	A
		TAX
		LDA	!SMOKETB,X
		AND	#000FFH
		ASL	A
		TAX
		LDA	!SMOKECH,X
		STA	SOAM_DX+04H,Y
		STA	SOAM_DX+0CH,Y
		STA	SOAM_DX+14H,Y
		STA	SOAM_DX+1CH,Y
		STA	SOAM_DX+24H,Y
		STA	SOAM_DX+2CH,Y
		STA	SOAM_DX+34H,Y
		STA	SOAM_DX+3CH,Y
;
		LDA	#00000
		STA	SOAM_DX+06H,Y
		STA	SOAM_DX+0EH,Y
		STA	SOAM_DX+16H,Y
		STA	SOAM_DX+1EH,Y
		STA	SOAM_DX+26H,Y
		STA	SOAM_DX+2EH,Y
		STA	SOAM_DX+36H,Y
		STA	SOAM_DX+3EH,Y
;
		TYA
		CLC
		ADC	#00008*8
		STA	OAMIDX
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMKMOV ( WORLD 1 oo JbN move set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KAMKMOV		EQU	$
		LDA	KAMMD2
		ASL	A
		TAX
		JMP	(!KAMEADR,X)
;
;
KAMEADR		EQU	$
		WORD	KAMENOP		; (no play)
		WORD	KAMEM00		; CjV
KSTART		WORD	KAMEM01		; яo
		WORD	KAMEM02		; ~
KMLEFT		WORD	KAMEM03		; E獶
		WORD	KAMENOP		; (no play)
;
;
KSTAT		EQU	(KSTART-KAMEADR)/2
KLEFT		EQU	(KMLEFT-KAMEADR)/2
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMEM00 ( WORLD 1 oo JbN )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KAMKXPS		EQU	$
		WORD	06000H,08000H,0A000H
		WORD	06000H,08000H,0A000H
		WORD	06000H,08000H,0A000H
;
KAMKYPS		EQU	$
		WORD	05800H,05800H,05800H
		WORD	07800H,07800H,07800H
		WORD	09800H,09800H,09800H
;
KAMKXSD		EQU	00500H		; яo wXs[h
KAMKYSD		EQU	0FD00H		;    "     xXs[h
KAMKXSD1	EQU	00020H		; ~ wXs[h
KAMKYSD1	EQU	00040H		;    " xXs[h
KAMKXSD2	EQU	0FFF0H		; E獶 wXs[h
KAMKYSD2	EQU	00200H		;    "     xXs[h
KAMWAIT		EQU	00020H		; EFCg^C}[
;
;
KAMEM00		EQU	$
		M8			; ̑ݏII
		LDA	#0FFH
		STA	ENYUSN+4
		M16
		STZ	ENMODE+4
;
		LDA	CARDPOS
		AND	#000FFH
		ASL	A
		TAX
		LDA	!KAMKXPS,X
		STA	ENXPSL+4	; w|WV
		SEC
		SBC	#02000H		; ]`FbN␳l
		STA	KMOLDXP		; ( Z[up )
		LDA	!KAMKYPS,X
		STA	ENYPSL+4	; x|WV
		LDA	#KAMKXSD
		STA	ENXSPD+4	; wXs[h
		LDA	#KAMKYSD
		STA	ENYSPD+4	; xXs[h
		LDA	#KAMWAIT
		STA	ENWRK0		; EFCg^C}[
;
		JSR	KAMOMST		; OAM set
;
		INC	KAMMD2		; next mode (kamekku)
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMEM01 ( WORLD 1 oo JbN яo )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KAMEM01		EQU	$
		JSR	KMXSCLC
		JSR	KMYSCLC
;
		LDA	ENXSPD+4
		BPL	KM1010
;
		LDA	#KAMKXSD1
		STA	ENXSPD+4	; ~ wXs[h
		LDA	#KAMKYSD1
		STA	ENYSPD+4	; ~ xXs[h
		INC	KAMMD2		; next mode (kamekku)
		BRA	KM1020
;
KM1010		EQU	$
		JSR	KMXPCLC
		JSR	KMYPCLC
;
KM1020		EQU	$
		JSR	KAMOMST		; OAM set
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KMXPCLC ( WORLD 1 oo JbN X pos clc ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KMXPCLC		EQU	$
		LDA	ENXPSL+4
		CLC
		ADC	ENXSPD+4
		STA	ENXPSL+4
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMYCLC ( WORLD 1 oo JbN Y pos clc ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KMYPCLC		EQU	$
		LDA	ENYPSL+4
		CLC
		ADC	ENYSPD+4
		STA	ENYPSL+4
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KMXSCLC ( WORLD 1 oo JbN X spd clc ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KXJYUCT		EQU	$		; (wd)
		WORD	0FFC0H		; яo
		WORD	00000H		; ~
		WORD	0FFE0H		; E獶
;
;
KMXSCLC		EQU	$
		LDA	KAMMD2
		SEC
		SBC	#KSTAT
		ASL	A
		TAX
		LDA	!KXJYUCT,X
		CLC
		ADC	ENXSPD+4
		STA	ENXSPD+4
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KMYSCLC ( WORLD 1 oo JbN Y spd clc ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KYJYUCT		EQU	$		; (xd)
		WORD	00010H		; яo
		WORD	00006H		; ~
		WORD	0FFF0H		; E獶
;
;
KMYSCLC		EQU	$
		LDA	KAMMD2
		SEC
		SBC	#KSTAT
		ASL	A
		TAX
		LDA	!KYJYUCT,X
		CLC
		ADC	ENYSPD+4
		STA	ENYSPD+4
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMOMST ( WORLD 1 oo JbN OAM set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KAMCHDT		EQU	$
		WORD	03709H+00H,03709H+02H	; J
		WORD	03709H+20H,03709H+22H
;
		WORD	03749H+00H,03749H+02H	; 
		WORD	03749H+20H,03749H+22H
;
;
KAMOMST		EQU	$
		LDY	OAMIDX
		LDA	ENXPSL+4
		AND	#0FF00H
		CMP	#0E000H
		BCC	KMOST005	; w  I[o[ H
;					: yes
		ORA	#000FFH
KMOST005	EQU	$
		XBA
		STA	SOAM_DX+00H,Y
		STA	SOAM_DX+10H,Y
		CLC
		ADC	#00010H
		STA	SOAM_DX+08H,Y
		STA	SOAM_DX+18H,Y
;
		LDA	ENYPSL+4
		AND	#0FF00H
		XBA
		STA	SOAM_DX+02H,Y
		STA	SOAM_DX+0AH,Y
		CLC
		ADC	#00010H
		STA	SOAM_DX+12H,Y
		STA	SOAM_DX+1AH,Y
;
		LDA	KAMMD2
		CMP	#KLEFT
		BEQ	KMOST010
;
		LDX	#00000
		BRA	KMOST020
;
KMOST010	EQU	$
		LDX	#00008
KMOST020	EQU	$
		LDA	!KAMCHDT+0,X
		STA	SOAM_DX+04H,Y
		LDA	!KAMCHDT+2,X
		STA	SOAM_DX+0CH,Y
		LDA	!KAMCHDT+4,X
		STA	SOAM_DX+14H,Y
		LDA	!KAMCHDT+6,X
		STA	SOAM_DX+1CH,Y
;
		LDA	#00002
		STA	SOAM_DX+06H,Y
		STA	SOAM_DX+0EH,Y
		STA	SOAM_DX+16H,Y
		STA	SOAM_DX+1EH,Y
;
		TYA
		CLC
		ADC	#00008*4
		STA	OAMIDX
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMEM02 ( WORLD 1 oo JbN ~ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KAMEM02		EQU	$
		DEC	ENWRK0
		BPL	KM2010
;
		LDA	#KAMKXSD2
		STA	ENXSPD+4	; E獶  wXs[h
		LDA	#KAMKYSD2
		STA	ENYSPD+4	; E獶  xXs[h
;
		LDA	#019H
		JSL	>SOUND_3_ON	; [] TEhZbg
		INC	KAMMD2		; next mode (kamekku)
;
KM2010		EQU	$
		JSR	KMXSCLC
		JSR	KMYSCLC
		JSR	KMXPCLC
		JSR	KMYPCLC
;
		JSR	KAMOMST		; OAM set
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KAMEM03 ( WORLD 1 oo JbN E獶 )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KAMEM03		EQU	$
		LDA	ENXPSL+4
		BPL	KM3010
		CMP	#00000-02000H
		BCC	KM3010
		CMP	#00000-01000H
		BCS	KM3010		;  H
;					: yes
;
		INC	KAMMD2		; next mode (kamekku)
;;;;	LDX	#00020H
;;;;	STX	BONSTM
;;;;	INC	BONSMD
		BRA	KM3020
;
KM3010		EQU	$
		JSR	KMXSCLC
		JSR	KMYSCLC
		JSR	KMXPCLC
		JSR	KMYPCLC
;
		JSR	KAMOMST		; OAM set
;
KM3020		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ZOOMVDN ( WORLD 1 oo ZY[_E )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ZOMDNCT		EQU	00020H		; Y[_EEJEg
ZOMUPCT		EQU	00010H		; Y[AbvEJEg
;
;
ZOOMVDN		EQU	$
		JSR	EGGMOVE		;  lnud
		JSR	SEIOAMSET	; OAM set
;
		LDA	OPENCNT
		CMP	#000C0H
		BNE	ZMUP010		; zoom down end ?
;					: yes
;
		INC	BONSMD		; next mode
		BRA	ZMUP020
;
ZMUP010		EQU	$
		SEC
		SBC	#ZOMDNCT
		STA	OPENCNT
;
ZMUP020		EQU	$
		JMP	SEISZOOM	; Y[Zbg
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ZOOMVUP	 ( WORLD 1 oo ZY[Abv )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ZOOMVUP		EQU	$
		JSR	EGGMOVE		;  lnud
;
		LDA	OPENCNT
		CMP	#00100H
		BNE	ZMDN020		; zoom up end ?
;					: yes
;
		JSR	SEISRETN	; ZJ[h 
;
		LDA	#00010*4+1
		STA	>MSG_RAM+2	; message No. set !!
		INC	MSGMOD
		LDA	#BS1WN
		STA	BONSMD		; next mode
		LDA	#00001H
		STA	BONSTM		; timer
		BRA	ZMDN030
;
ZMDN020		EQU	$
		JSR	SEIOAMSET	; OAM set

		LDA	OPENCNT
		CLC
		ADC	#ZOMUPCT
		STA	OPENCNT
;
ZMDN030		EQU	$
		JMP	SEISZOOM	; Y[Zbg
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SEIOAMSET ( WORLD 1 oo Z OAM set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SEIOAMSET	EQU	$
		PHY
		LDY	!OAMIDX
;---- x position set ----
		LDA	!CARDXPOSDT+4
		AND	#000FFH
		STA	!SOAM_DX,Y
		STA	!SOAM_DX+16,Y
		CLC
		ADC	#00010H
		STA	!SOAM_DX+8,Y
		STA	!SOAM_DX+24,Y
;---- y position set ----
		LDA	!CARDYPOSDT+4
		AND	#000FFH
		STA	!SOAM_DX+2,Y
		STA	!SOAM_DX+8+2,Y
		CLC
		ADC	#00010H
		STA	!SOAM_DX+16+2,Y
		STA	!SOAM_DX+24+2,Y
;---- char number set ----
;---- attribute set ----
		LDA	#039E8H			; pri(3),attribute(6)
		STA	!SOAM_DX+4,Y
		INC	A
		INC	A
		STA	!SOAM_DX+8+4,Y
		INC	A
		INC	A
		STA	!SOAM_DX+16+4,Y
		INC	A
		INC	A
		STA	!SOAM_DX+24+4,Y
;---- oamsub set ----
		LDA	#00002H
		STA	!SOAM_DX+6,Y
		STA	!SOAM_DX+8+6,Y
		STA	!SOAM_DX+16+6,Y
		STA	!SOAM_DX+24+6,Y
;---- oam index koshin ----
		TYA
		CLC
		ADC	#32
		STA	!OAMIDX
		PLY
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SEISZOOM ( WORLD 1 oo Z J[hY[ ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
SEISZOOM_PAL	EQU	$
		BYTE	000H*12,000H*12,006H*12
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
;
SEISZOOM	EQU	$
		STA	R6		; {
		LDA	#00015H
		STA	R1		; CMODE NO.
;
		LDA	#00012*10+9
;
 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
		LDY	!LNGG_SL
		CLC
		ADC	SEISZOOM_PAL,Y
		AND	#000FFH
 ENDIF    ;**** PAL Ή [1995/08/02] *****************************
;
		STA	R3		; R[X mn.
;
		I8			; index 8bit mode
;
		M_CHIP	MPAICNZM
;
		I16			; index 16bit mode
;
		JSR	BCOBJCHRDMA
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SEISERAS ( WORLD 1 oo Z J[h )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SEISERAS	EQU	$
		LDA	#00003H
		STA	<WORKE
		LDY	!CARDADDR+4*2
SEER010		EQU	$
		LDA	#BANK CLEARCARD
		STA	<WORK1
		LDX	#CLEARCARD
		LDA	#00006
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		DEC	<WORKE
		BNE	SEER010
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SEISRETN ( WORLD 1 oo Z J[h )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CR_seisan	EQU	001D1H
SEISAN_CHR	EQU	$
		WORD	0001100000000000B+CR_seisan
		WORD	0001100000000000B+CR_seisan+1
		WORD	0001100000000000B+CR_seisan+2
		WORD	0001100000000000B+CR_seisan+3
		WORD	0001100000000000B+CR_seisan+4
		WORD	0001100000000000B+CR_seisan+5
		WORD	0001100000000000B+CR_seisan+6
		WORD	0001100000000000B+CR_seisan+7
		WORD	0001100000000000B+CR_seisan+8
;
SEISRETN	EQU	$
		LDA	#00003H
		STA	<WORKE
		LDY	!CARDADDR+4*2
		LDX	#SEISAN_CHR
SERT010		EQU	$
		LDA	#BANK SEISAN_CHR
		STA	<WORK1
		LDA	#00006
		PHX
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		PLA
		CLC
		ADC	#00006H
		TAX
		DEC	<WORKE
		BNE	SERT010
;
		RTS
;
;
;
;
		MEM16
		IDX16
;
;============== vnqkc@Q ==========================================
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	GINGMOV ( WORLD 2 ⎆ move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
GINGMOV		EQU	$
		LDA	BONSMD
		ASL	A
		TAX
		JMP	(!GINGADR,X)
;
;
GINGADR		EQU	$
		WORD	TIMEDEC		; 0 timer dec. set sub !!
		WORD	WINDOPN		; 1 window open sub !!
		WORD	TIMDEC0		; 2 timer dec. set sub !!
		WORD	MSWINOP		; 3 messege window open sub !!
		WORD	WINCLSB		; 4 window color sub !!
		WORD	SCRDOWN		; 5 screen down move sub !!
		WORD	SCRYURE		; 6 screen yure sub !!
		WORD	TIMDEC2		; 7 timer dec. set sub !!
;[1995/02/08]		WORD	COINDEC		; 8 yosshy coin dec. sub !!
		WORD	GINGAMIMAIN	; 9
		WORD	G_MAIN2		; A
		WORD	G_MAIN3		; B
		WORD	G_FLASH		; C
		WORD	BONUSPLAYERUP	; D player count up
BS2MAP		WORD	MODEMAP		; E map initial mode set sub !!
;
;
BS2MP		EQU	(BS2MAP-GINGADR)/2
;
;
;--------------------------------------------------------
;-	GINGAMI HAGASHI					-
;--------------------------------------------------------
soundplayerup	EQU	008H
soundcslmove	EQU	05CH	;006H
soundcslkettei	EQU	009H
soundcslhazure	EQU	02AH
soundhikkaki	EQU	032H
gin_csl0	EQU	03564H
gin_csl1	EQU	03566H
keycount0	EQU	00020H
keycount1	EQU	00010H
g_democount	EQU	00080H
gingamichr	EQU	05384E4H
gin_0		EQU	00000H
gin_1		EQU	gin_0+90H
gin_2		EQU	gin_1+90H
gin_3		EQU	gin_2+90H
gin_4		EQU	gin_3+90H
gin_5		EQU	gin_4+90H
gin_6		EQU	gin_5+90H
g_search	EQU	00200H
g_lastcnt	EQU	00080H
g_flushtimer	EQU	5
;
GCARDPOS	EQU	$
		WORD	00187H+bg2_adrs, 0018BH+bg2_adrs
		WORD	00205H+bg2_adrs, 00209H+bg2_adrs, 0020DH+bg2_adrs
		WORD	00287H+bg2_adrs, 0028BH+bg2_adrs
;
GCARD0CHR	EQU	$
		WORD	00A23H, 00A24H, 00A25H
		WORD	00A33H, 00A34H, 00A35H
		WORD	00A43H, 00A44H, 00A45H
;
GCARD1CHR	EQU	$
		WORD	00A20H, 00A21H, 00A22H
		WORD	00A30H, 00A31H, 00A32H
		WORD	00A40H, 00A41H, 00A42H
;
GINCHADTABLE	EQU	$
		LWORD	GCARD0CHR
		LWORD	GCARD1CHR
;
GINTABLE	EQU	$
		HEX	03, 00, 00, 03, 00, 00, 03
;
GCSLXPOS	EQU	$
		HEX	38, 58, 28, 48, 68, 38, 58
;
GCSLYPOS	EQU	$
		HEX	60, 60, 80, 80, 80, A0, A0
;
;
GCSLXADD	EQU	$
		HEX	00, 01, FF, 00
;
GCSLYADDUP	EQU	$
		HEX	05, 05, FE, FE, FD, FD, FD
;
GCSLYADDDOWN	EQU	$
		HEX	02, 02, 03, 03, 02, FB, FB
;
GINCHRADDR	EQU	$
		WORD	gin_0, gin_1, gin_2, gin_3, gin_4, gin_5, gin_6
;
GINPOS0		EQU	$
		HEX	00, 00, 00, 17
		HEX	01, 00, 01, 17, 03, 00, 03, 17, 05, 00, 05, 17
		HEX	07, 00, 07, 17, 09, 00, 09, 17, 0B, 00, 0B, 17
		HEX	0D, 00, 0D, 17, 0F, 00, 0F, 17, 11, 00, 11, 17
		HEX	13, 00, 13, 17, 15, 00, 15, 17, 17, 00, 17, 17
		HEX	FF
GINPOS1		EQU	$
		HEX	01, 00, 00, 01, 03, 00, 00, 03, 05, 00, 00, 05
		HEX	07, 00, 00, 07, 09, 00, 00, 09, 0B, 00, 00, 0B
		HEX	0D, 00, 00, 0D, 0F, 00, 00, 0F, 11, 00, 00, 11
		HEX	13, 00, 00, 13, 15, 00, 00, 15, 17, 00, 00, 17
		HEX	16, 17, 17, 16, 14, 17, 17, 14, 12, 17, 17, 12
		HEX	10, 17, 17, 10, 0E, 17, 17, 0E, 0C, 17, 17, 0C
		HEX	0A, 17, 17, 0A, 08, 17, 17, 08, 06, 17, 17, 06
		HEX	04, 17, 17, 04, 02, 17, 17, 02, 00, 17, 17, 00
		HEX	FF
GINPOS2		EQU	$
		HEX	00, 00, 17, 17, 17, 00, 00, 17, 01, 00, 02, 17
		HEX	03, 00, 04, 17, 05, 00, 06, 17, 07, 00, 08, 17
		HEX	09, 00, 0A, 17, 0B, 00, 0C, 17, 0D, 00, 0E, 17
		HEX	0F, 00, 10, 17, 11, 00, 12, 17, 13, 00, 14, 17
		HEX	15, 00, 16, 17, 17, 00, 17, 17
		HEX	FF
GINPOS3		EQU	$
		HEX	00, 17, 17, 17, 00, 15, 17, 15, 00, 13, 17, 13
		HEX	00, 11, 17, 11, 00, 0F, 17, 0F, 00, 0D, 17, 0D
		HEX	00, 0B, 17, 0B, 00, 09, 17, 09, 00, 07, 17, 07
		HEX	00, 05, 17, 05, 00, 03, 17, 03, 00, 01, 17, 01
		HEX	00, 00, 17, 00
		HEX	FF
;
GINADDR		EQU	$
		WORD	GINPOS0, GINPOS1, GINPOS2, GINPOS3
;
;
GINGAMIINIT	EQU	$
		MI8				; memory, index 8bit mode !!
;
		LDA	#00
		STA	!GCSLNUM
		TAY
		LDA	GCSLXPOS,Y
		STA	!CRCXPS
		LDA	GCSLYPOS,Y
		STA	!CRCYPS
;
		LDX	#006H
		TXY
GGINIT0040	EQU	$
		LDA	GINTABLE,X
		STA	<WORK,X
		DEX
		BPL	GGINIT0040		; table number set end ? [no->GGINIT0040]
;
		LDA	#LOW GINTBLRM
		STA	<WORK2D
		LDA	#HIGH GINTBLRM
		STA	<WORK2E
		JSR	RANDTBLSET		; table ram set !!
;
		STZ	!GINWRCNT
		STZ	!GDEMOCNT
		LDY	#06
		LDA	#00
GGINIT0060	EQU	$
		STA	!GOPENFLG,Y
		DEY
		BPL	GGINIT0060		; open flag clear ? [yes->GGINIT0060]
;
		MI16				; memory, index 16bit mode !!
;
		LDY	#00006H
GGINIT0080	EQU	$
		PHY
		LDA	!GINTBLRM,Y
		AND	#000FFH
		TAX
		LDA	GINCHADTABLE+2,X
		AND	#000FFH
		STA	<WORK1
		LDA	GINCHADTABLE,X
		TAX
		TYA
		ASL	A
		TAY
		LDA	GCARDPOS,Y
		TAY
		LDA	#3
		STA	<WORK1E
GGINIT00A0	EQU	$
		PHY
		PHX
		LDA	#3*2
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#3*2
		TAX
		PLA
		CLC
		ADC	#00020H
		TAY
		DEC	<WORK1E
		BNE	GGINIT00A0		;
;
		PLY
		DEY
		BPL	GGINIT0080		;
;
		LDA	#00080H
		STA	!GINXPOS
		STA	!GINYPOS
		RTS
;
;
GINGAMIMAIN	EQU	$
		JSL	>RANDAM
;
		M8				; memory 8bit mode !!
;
		LDA	!KEYCOUNT
		BEQ	GGM0010			; key counter zero ? [yes->GGM0010]
;
		DEC	!KEYCOUNT
GGM0010		EQU	$
		M16				; memory 16bit mode !!
;
		LDA	!CRCXPS
		AND	#000FFH
		CLC
		ADC	#00014H
		STA	<WORK0
		LDA	!CRCYPS
		AND	#000FFH
		CLC
		ADC	#00014H
		STA	<WORK2
		LDA	#gin_csl0
		STA	<WORK4
		JSR	GINGAMICSLOAM		;
;;;		JSR	CARDOAM			; card cursor oam set !!
;
		LDA	!KEYA2L
		AND	#1100000010000000B
		BNE	GGM0020			; B,Y,A on ? [yes->GGM0020]
;
		JMP	GGM0040			; B,Y,A on ? [no->GGM0040]
;
GGM0020		EQU	$
		LDA	!GCSLNUM
		AND	#000FFH
		TAX
		LDA	!GOPENFLG,X
		AND	#000FFH
		BEQ	GGM0030			; close ? [yes->GGM0030]
;
		LDA	#soundcslhazure
		JSL	>SOUND_3_ON		; TEh ZbgII
;
		BRA	GGM0040			; close ? [no->GGM0040]
;
GGM0030		EQU	$
		LDA	#soundcslkettei
		JSL	>SOUND_3_ON		; TEh ZbgII
;
		LDY	#PMIR1
		STY	!BSPLTP
		LDA	PLTRNAR,Y
		JSR	PAS050
;
		MI8				; memory, index 8bit mode !!
;
		LDA	#018H
		STA	!KEYCOUNT
		INC	!GOPENFLG,X
		INC	!BONSMD
;
;;;;		LDA	#g_democount
;;;;		STA	!GDEMOCNT
;
		JSL	>RANDAM
;
		LDA	!RANDM0
		STA	4202H
		LDA	#04
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4217H
		ASL	A
		TAX
;
		M16				; memory 16bit mode !!
;
		LDY	#00
		LDA	GINADDR,X
		STA	<GINXPSAD		; position address
		LDA	(<GINXPSAD),Y
		INY
		AND	#000FFH
		XBA
		STA	!GINXPOS
		LDA	(<GINXPSAD),Y
		INY
		STY	!GDEMOCNT
		AND	#000FFH
		XBA
		STA	!GINYPOS
		LDA	#BANK gingamichr
		STA	R0
		LDA	#gingamichr
		STA	R3
		M_CHIP	GININIT
;
		I16				; index 16bit mode !!
		BRA	GGM00F0
;
GGM0040		EQU	$
		JSR	G_CURSOLMV		; card cursor move !!
;
GGM00F0		EQU	$
		RTS
;
;
G_MAIN2		EQU	$
		M8				; memory 8bit mode !!
;
		LDA	!KEYCOUNT
		BNE	G_M20004		;
;
		LDA	#020H
		STA	!KEYCOUNT
		LDA	#soundhikkaki
		JSL	>SOUND_3_ON		; TEh ZbgII
;
		BRA	G_M20005
;
G_M20004	EQU	$
		DEC	!KEYCOUNT
G_M20005	EQU	$
		LDA	!CRCXPS
		CLC
		ADC	!GINXPOS+1
		STA	<WORK0
		LDA	!CRCYPS
		CLC
		ADC	!GINYPOS+1
		STA	<WORK2
		STZ	<WORK1
		STZ	<WORK3
;
		M16				; memory 16bit mode !!
;
		LDA	#gin_csl0
		STA	<WORK4
		JSR	GINGAMICSLOAM		;
;
		I8				; index 8bit mode !!
;
		LDA	!GINXPOS+1
		AND	#000FFH
		STA	R3
		LDA	!GINYPOS+1
		AND	#000FFH
		STA	R4
		M_CHIP	GINGAMI
;
		I16				; index 16bit mode !!
;
		LDA	#BANK WOB7CHR
		STA	<WORK1
		LDA	!GCSLNUM
		AND	#000FFH
		ASL	A
		TAX
		LDY	GINCHRADDR,X
		LDX	#WOB7CHR
		LDA	#3
		STA	<WORKE
G_M20010	EQU	$
		LDA	#00060H
		PHX
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#30H
		TAY
		PLA
		CLC
		ADC	#0200H
		TAX
		DEC	<WORKE
		BNE	G_M20010		; vram set end ? [no->G_M20010]
;
		MI8				; memory, index 8bit mode !!
;
		LDY	!GDEMOCNT
		LDA	(<GINXPSAD),Y
		BPL	G_M20040		; demo end ? [no->G_M20040]
;
		LDA	#090H
		LDX	!GCSLNUM
		LDY	!GINTBLRM,X
		BEQ	G_M20018		; ͂H [yes->G_M20018]
;
		LDA	#08FH
G_M20018	EQU	$
		JSL	>SOUND_3_ON		; TEh ZbgII
;
		INC	!GINWRCNT
		LDA	!GINWRCNT
		CMP	#03
		BNE	G_M20020		; [->G_M20020]
;
		INC	!BONSMD
		BRA	G_M20100
;
G_M20020	EQU	$
		DEC	!BONSMD
;
		MI16				; memory, index 16bit mode !!
;
		LDY	#PWALK
		STY	!BSPLTP
		LDA	PLTRNAR,Y
		JMP	PAS050
;;;;;;;;		BRA	G_M20100
;
G_M20040	EQU	$
		JSR	G_FINGERMV		; finger move !!
;
G_M20100	EQU	$
;
		MI16				; memory, index 16bit mode !!
		RTS
;
;
G_MAIN3		EQU	$
		MI8				; memory, index 8bit mode !!
;
		STZ	!BABYCNT
		LDY	#06
G_M30040	EQU	$
		LDA	!GOPENFLG,Y
		BEQ	G_M30080		;
;
		LDA	!GINTBLRM,Y
		BEQ	G_M30080		;
;
		INC	!BABYCNT
G_M30080	EQU	$
		DEY
		BPL	G_M30040		; baby count end ? [no->G_M30040]
;
		LDY	!BABYCNT
		LDA	G_UPSUU,Y
		STA	!SLCOIN
		STZ	!SLCOIN+1
		LDA	G_TIMEL,Y
		STA	!BONSTM
		LDA	G_TIMEH,Y
		STA	!BONSTM+1
		STZ	<GINXPSAD
		STZ	<GINXPSAD+1
		STZ	<GINYPSAD
		STZ	<GINYPSAD+1
		LDA	G_SOUND,Y
		CPY	#00
		BNE	G_M300C0		; 薳H [no->G_M300C0]
;
		PHY
		JSL	>SOUND_3_ON		; TEh ZbgII
		PLY
;
		BRA	G_M300D0		; [->G_M300D0]
;
G_M300C0	EQU	$
		STA	!SOUND_0
G_M300D0	EQU	$
		INC	!BONSMD
;
		MI16				; memory, index 16bit mode !!
;
		TYA
		ASL	A
		TAY
		LDA	G_YOSSY,Y
		STA	!BSPLTP
		TAY
		LDA	PLTRNAR,Y
		JMP	PAS050
;
G_M30100	EQU	$
		MI16				; memory, index 16bit mode !!
;
		RTS
;
;
G_UPSUU		EQU	$
		BYTE	0, 1, 2, 5
;[1995.04.27.TH]		BYTE	0, 1, 2, 9
;
G_SOUND		EQU	$
		HEX	7D, 05, 05, 05
;
G_YOSSY		EQU	$
		WORD	PTAOR, PYORO, PYORO, PYORO
;
G_TIMEL		EQU	$
		BYTE	LOW (g_flushtimer*24), LOW (g_flushtimer*24)
		BYTE	LOW (g_flushtimer*24), LOW (g_flushtimer*24)
;[1995.04.27.TH]		BYTE	LOW (g_flushtimer*64), LOW (g_flushtimer*100)
;[1995.04.27.TH]		BYTE	LOW (g_flushtimer*100), LOW (g_flushtimer*200)
;
G_TIMEH		EQU	$
		BYTE	HIGH (g_flushtimer*24), HIGH (g_flushtimer*24)
		BYTE	HIGH (g_flushtimer*24), HIGH (g_flushtimer*24)
;[1995.04.27.TH]		BYTE	HIGH (g_flushtimer*64), HIGH (g_flushtimer*100)
;[1995.04.27.TH]		BYTE	HIGH (g_flushtimer*100), HIGH (g_flushtimer*200)
;
BONUSPLAYERUP	EQU	$
		LDA	!BONSTM
		BEQ	BPU0040			; [->BPU0040]
;
		DEC	!BONSTM
		BRA	BPU0100			;
;
BPU0040		EQU	$
		LDA	!SLCOIN
		BNE	BPU0060			; count end ? [no->BPU0060]
;
BPU0050		EQU	$
		LDA	#g_lastcnt
		STA	!BONSTM
		INC	!BONSMD
		BRA	BPU0100
;
BPU0060		EQU	$
		LDY	!PLCONT
		CPY	#999
		BEQ	BPU0050			; player max ? [yes->BPU0050]
;
		PHA
		LDA	#008H
		JSL	>SOUND_3_ON		; TEh ZbgIIiPj
		PLA
;
		LDY	#30H
		STY	!BONSTM
		CMP	#111
		BCS	BPU00C0			; !SLCOIN < 111 [no->BPU00C0]
;
		CMP	#11
		BCS	BPU00A0			; !SLCOIN < 11 [no->BPU00A0]
;
		INC	!PLCONT
		JSR	PLCNTST
;
BPU0080		EQU	$
		DEC	!SLCOIN
		BRA	BPU0100
;
BPU00A0		EQU	$
		LDA	!PLCONT
		CLC
		ADC	#10
		CMP	#1000
		BCC	BPU00B0			; !PLCONT < 1000 [yes->BPU00B0]
;
		LDA	#999
BPU00B0		EQU	$
		STA	!PLCONT
		JSR	PLCNTST
;
		LDA	!SLCOIN
		SEC
		SBC	#10
		STA	!SLCOIN
		BRA	BPU0100
;
BPU00C0		EQU	$
		LDA	!PLCONT
		CLC
		ADC	#100
		CMP	#1000
		BCC	BPU00D0			; !PLCONT < 1000 [yes->BPU00D0]
;
		LDA	#999
BPU00D0		EQU	$
		STA	!PLCONT
		JSR	PLCNTST
;
		LDA	!SLCOIN
		SEC
		SBC	#100
		STA	!SLCOIN
BPU0100		EQU	$
		RTS
;
;
BONUSPLAYERDOWN EQU	$
		LDA	!BONSTM
		BEQ	BPD0040			; bonus timer dec ? [no->BPD0040]
;
		DEC	!BONSTM
		JMP	BPD0100
;
BPD0040		EQU	$
		LDA	!PLCONT
		BEQ	BPD0060			; player down cound end ? [yes->BPD0060]
;
		LDA	!SLCOIN
		BNE	BPD0080			; player down cound end ? [no->BPD0080]
;
BPD0060		EQU	$
		LDA	#g_lastcnt
		STA	!BONSTM
		INC	!BONSMD
		BRA	BPD0100
;
BPD0080		EQU	$
;;;;		    LDY	    #soundplayerdown
;;;;		    STY	    !SOUND3
		LDY	#30H
		STY	!BONSTM
		CMP	#111
		BCS	BPD00C0			; !SLCOIN < 111 [no->BPD00C0]
;
		CMP	#11
		BCS	BPD00A0			; !SLCOIN < 11 [no->BPD00A0]
;
		LDA	!PLCONT
		DEC	A
		CMP	#01
		BPL	BPD0090			; vC[  PH [no->BPD0090]
;
		LDA	#01
BPD0090		EQU	$
		STA	!PLCONT
		JSR	PLCNTST
;
		DEC	!SLCOIN
		BRA	BPD0100
;
BPD00A0		EQU	$
		LDA	!PLCONT
		SEC
		SBC	#10
		CMP	#01
		BPL	BPD00B0			; vC[  PH [no->BPD00B0]
;
		LDA	#01
BPD00B0		EQU	$
		STA	!PLCONT
		JSR	PLCNTST
;
		LDA	!SLCOIN
		SEC
		SBC	#10
		STA	!SLCOIN
		BRA	BPD0100
;
BPD00C0		EQU	$
		LDA	!PLCONT
		SEC
		SBC	#100
		CMP	#01
		BPL	BPD00D0			; vC[  PH [no->BPD00D0]
;
		LDA	#01
BPD00D0		EQU	$
		STA	!PLCONT
		JSR	PLCNTST
;
		LDA	!SLCOIN
		SEC
		SBC	#100
		STA	!SLCOIN
BPD0100		EQU	$
		RTS
;
;
G_CURSOLMV	EQU	$
		MI8				; memory, index 8bit mode !!
;
		LDA	!KEYA2
		AND	#00001111B
		BEQ	GCSLMV0040		; up or down or left or right key press ?
;						; [no->GCSLMV0040]
		LDY	#keycount0
		BRA	GCSLMV0050
;
GCSLMV0040	EQU	$
		LDY	!KEYCOUNT
		BNE	GCSLMV0100		; key check ? [no->GCSLMV0100]
;
		LDY	#keycount1
GCSLMV0050	EQU	$
		STY	!KEYCOUNT
		LDA	!KEYA1
		AND	#00001111B
		BNE	GCSLMV0080		; up or down or left or right key press ?
;						; [no->GCSLMV0080]
		BRA	GCSLMV0100
;
GCSLMV0080	EQU	$
		PHA
		AND	#00000011B
		TAY
		LDA	!GCSLNUM
		CLC
		ADC	GCSLXADD,Y
		BPL	GCSLMV0090		; area over ? [no->GCSLMV0090]
;
		LDA	#6
		BRA	GCSLMV00A0
;
GCSLMV0090	EQU	$
		CMP	#6+1
		BCC	GCSLMV00A0		; area over ? [no->GCSLMV00A0]
;
		LDA	#0
GCSLMV00A0	EQU	$
		STA	!GCSLNUM
		TAY
		PLA
		LSR	A
		LSR	A
		BIT	#00000001B
		BEQ	GCSLMV00B0		; down on ? [no->GCSLMV00B0]
;
		TYA
		CLC
		ADC	GCSLYADDDOWN,Y
		BRA	GCSLMV00C0
;
GCSLMV00B0	EQU	$
		BIT	#00000010B
		BEQ	GCSLMV00D0		; down on ? [no->GCSLMV00D0]
		TYA
		CLC
		ADC	GCSLYADDUP,Y
GCSLMV00C0	EQU	$
		STA	!GCSLNUM
		TAY
GCSLMV00D0	EQU	$
		LDA	GCSLXPOS,Y
		STA	!CRCXPS
		LDA	GCSLYPOS,Y
		STA	!CRCYPS
		LDA	#soundcslmove
		JSL	>SOUND_3_ON		; TEh ZbgII
;
GCSLMV0100	EQU	$
		MI16				; memory, index 16bit mode !!
		RTS
;
;
		MEM8
		IDX8
;
G_FINGERMV	EQU	$
		M16				; memory 16bit mode !!
;
		LDA	(<GINXPSAD),Y
		AND	#000FFH
		STA	R1
		INY
		LDA	(<GINXPSAD),Y
		AND	#000FFH
		STA	R2
		LDA	!GINXPOS+1
		AND	#000FFH
		STA	R3
		LDA	!GINYPOS+1
		AND	#000FFH
		STA	R4
		LDA	#g_search
		STA	R6
		M_CHIP	SEARCH_SPEED
;
		LDA	!GINXPOS
		CLC
		ADC	R1
		STA	!GINXPOS
		LDA	!GINYPOS
		CLC
		ADC	R2
		STA	!GINYPOS
;
		LDY	!GDEMOCNT
		LDA	(<GINXPSAD),Y
		AND	#000FFH
		XBA
		SEC
		SBC	!GINXPOS
		BEQ	G_FIN0080		; [->G_FIN0080]
;
		EOR	R1
		BPL	G_FIN00C0		; [->G_FIN00C0]
;
		LDA	(<GINXPSAD),Y
		AND	#000FFH
		XBA
		STA	!GINXPOS
G_FIN0080	EQU	$
		INY
		LDA	(<GINXPSAD),Y
		AND	#000FFH
		XBA
		SEC
		SBC	!GINYPOS
		BEQ	G_FIN00A0		; [->G_FIN00A0]
;
		EOR	R2
		BPL	G_FIN00C0		; [->G_FIN00C0]
;
		LDA	(<GINXPSAD),Y
		AND	#000FFH
		XBA
		STA	!GINYPOS
G_FIN00A0	EQU	$
		INY
		STY	!GDEMOCNT
G_FIN00C0	EQU	$
		M8				; memory 16bit mode !!
;
		RTS
;
		MEM16
		IDX16
;
;
GINGAMICSLOAM	EQU	$
		LDY	!OAMIDX
		LDA	<WORK0			; x position
		SEC
		SBC	#07
		STA	!SOAM_DX,Y
		LDA	<WORK2			; y position
		STA	!SOAM_DX+2,Y
		LDA	<WORK4
;;;;;;;;		ORA	#03400H
		STA	!SOAM_DX+4,Y
		LDA	#00002H
		STA	!SOAM_DX+6,Y
		TYA
		CLC
		ADC	#00008H
		STA	!OAMIDX
		RTS
;
;
G_CLR		EQU	$
		WORD	000FCH|atr3, 000FCH|atr3, 000FCH|atr3, 000FCH|atr3
		WORD	000FCH|atr3, 000FCH|atr3, 000FCH|atr3
;
G_9UPH		EQU	$
		WORD	00250H|atr2, 00251H|atr2, 000FCH|atr3, 00262H|atr2
		WORD	000CBH|atr3, 002E0H|atr3, 002E1H|atr3
;[1995.04.27.TH]		WORD	080DCH|atr3, 002E0H|atr3, 002E1H|atr3
G_9UPL		EQU	$
		WORD	00260H|atr2, 00261H|atr2, 00252H|atr2, 00264H|atr2
		WORD	000DBH|atr3, 002F0H|atr3, 002F1H|atr3
;[1995.04.27.TH]		WORD	000DEH|atr3, 002F0H|atr3, 002F1H|atr3
;
G_2UPH		EQU	$
		WORD	00250H|atr2, 00251H|atr2, 000FCH|atr3, 00262H|atr2
		WORD	000C8H|atr3, 002E0H|atr3, 002E1H|atr3
G_2UPL		EQU	$
		WORD	00260H|atr2, 00261H|atr2, 00252H|atr2, 00263H|atr2
		WORD	000D8H|atr3, 002F0H|atr3, 002F1H|atr3
;
G_1UPH		EQU	$
		WORD	00250H|atr2, 00251H|atr2, 000FCH|atr3, 00253H|atr2
		WORD	000C7H|atr3, 002E0H|atr3, 002E1H|atr3
G_1UPL		EQU	$
		WORD	00260H|atr2, 00261H|atr2, 00252H|atr2, 00254H|atr2
		WORD	000D7H|atr3, 002F0H|atr3, 002F1H|atr3
;
G_SRCADRS	EQU	$
		WORD	G_1UPH, G_2UPH, G_9UPH
;
G_FLADRS	EQU	$
		WORD	0292H+bg2_adrs, 0232H+bg2_adrs, 01D2H+bg2_adrs
;
G_FLASH		EQU	$
		LDA	!BABYCNT
		AND	#000FFH
		BNE	G_FL0020		; hazure ? [no->G_FL0020]
;
;;;;;;;;		LDA	#0002AH
;;;;;;;;		STA	!SOUND3
		LDA	!BONSTM
		BEQ	G_FL0010
;
		DEC	!BONSTM
		RTS
;
;
G_FL0010	EQU	$
		LDA	#g_lastcnt
		STA	!BONSTM
		INC	!BONSMD
		BRA	G_FL0028
;
G_FL0020	EQU	$
		DEC	A
		ASL	A
		TAY
		LDA	!BONSTM
		BNE	G_FL0030		;
;
		LDA	#00020H
		STA	!BONSTM
		JSR	G_FLSRC
;
G_FL0028	EQU	$
		INC	!BONSMD
		RTS
;
;
G_FL0030	EQU	$
		DEC	!BONSTM
		LDA	<GINXPSAD
		BEQ	G_FL0040
;
		DEC	<GINXPSAD
		BRA	G_FL0100
;
G_FL0040	EQU	$
		LDA	<GINYPSAD
		EOR	#02
		STA	<GINYPSAD		; write mode set !!
		TAX
		JSR	(G_SCOREFL,X)
;
		LDA	#g_flushtimer
		STA	<GINXPSAD		; flush timer set !!
;
G_FL0100	EQU	$
		RTS
;
;
G_SCOREFL	EQU	$
		WORD	G_FLCLR
		WORD	G_FLSRC
;
G_FLSRC		EQU	$
		LDA	#BANK G_1UPH
		STA	<WORK1
		LDX	G_SRCADRS,Y
		LDA	G_FLADRS,Y
		TAY
		LDA	#(G_9UPH-G_CLR)
		PHX
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		PLA
		CLC
		ADC	#(G_9UPH-G_CLR)
		TAX
		LDA	#(G_9UPH-G_CLR)
		JSL	>VRAMDX_ST
;
		RTS
;
;
G_FLCLR		EQU	$
		LDA	#BANK G_CLR
		STA	<WORK1
		LDX	#G_CLR
		LDA	G_FLADRS,Y
		TAY
		LDA	#(G_9UPH-G_CLR)
		PHX
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		PLX
		LDA	#(G_9UPH-G_CLR)
		JSL	>VRAMDX_ST
;
		RTS
;
;
;------------------------------------------------------------------------
;-	randam table set						-
;-		(Y) <- kazu(01H - 1FH)					-
;-		WORK0 - 1F <- set number				-
;-		WORK2D,2E <- table ram address				-
;------------------------------------------------------------------------
RANDTBLSET	EQU	$
		PHP
		MI8				; memory, index 8bit mode !!
;
RANDTBLST00	EQU	$
		JSL	>RANDAM
;
		LDA	!RANDM0
		STA	4202H
		TYA
		INC	A
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDX	4217H
		LDA	<WORK,X
		STA	(<WORK2D),Y
		STY	<WORK2F
RANDTBLST40	EQU	$
		CPX	<WORK2F
		BEQ	RANDTBLST80		; [->RANDTBLST80]
;
		LDA	<WORK+1,X
		STA	<WORK,X
		INX
		BRA	RANDTBLST40
;
RANDTBLST80	EQU	$
		DEY
		BNE	RANDTBLST00		; table set end ? [no->RANDTBLST00]
;
		LDA	<WORK
		STA	(<WORK2D),Y
;
		PLP
		RTS
;
;
		MEM16
		IDX16
;
;============== vnqkc@R ==========================================
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTMOV ( WORLD 3 Xbg move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTMOV		EQU	$
		LDA	BONSMD
		ASL	A
		TAX
		JMP	(!SLOTADR,X)
;
;
SLOTADR		EQU	$
		WORD	TIMEDEC		; 0 timer dec. set sub !!
		WORD	WINDOPN		; 1 window open sub !!
		WORD	TIMDEC0		; 2 timer dec. set sub !!
		WORD	MSWINOP		; 3 messege window open sub !!
		WORD	WINCLSB		; 4 window color sub !!
		WORD	SCRDOWN		; 5 screen down move sub !!
		WORD	SCRYURE		; 6 screen yure sub !!
		WORD	TIMDEC2		; 7 timer dec. set sub !!
;[1995/02/08]		WORD	COINDEC		; 8 yosshy coin dec. sub !!
SLOTIN		WORD	SLOTKAS		; 9 slot kasoku move
		WORD	SLOTMIN		; A slot move main
		WORD	SLFLASH		; B slot atari flash !!
		WORD	SLTCOIN		; C player inc. set sub !!
BS3MAP		WORD	MODEMAP		; D map initial mode set sub !!
;
;
BS3MP		EQU	(BS3MAP-SLOTADR)/2
SLTIN		EQU	(SLOTIN-SLOTADR)/2
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTIT0 ( WORLD 3 Xbg CjV )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTIT0		EQU	$
		LDA	#00000H		; x Xs[h
		STA	SLTYSD+0
		STA	SLTYSD+2
		STA	SLTYSD+4
		STZ	SLCOIN		; vC[ Abv
;
		M8			; memory 8bit mode !!
;
		STZ	SLOTPS		; [ |WV
		STZ	SLTSTP+0	; Xgbv |WV
		STZ	SLTSTP+1
		STZ	SLTSTP+2
		STZ	SLTTIM+0	; Xgbv ^C}[
		STZ	SLTTIM+1
		STZ	SLTTIM+2
		STZ	SLPUSH+0	; otrg tO
		STZ	SLPUSH+1
		STZ	SLPUSH+2
;
		M16			; memory 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTKAS ( WORLD 3 Xbg  Zbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SKASOKU		EQU	00010H		; l
;
;
SLOTKAS		EQU	$
;
;-----< CjV `FbN >--------------------------------------------
;
		LDA	SLTYSD+0
		BNE	SLKS005		; CjV H
;					: yes
		LDX	#PMIR2
		STX	BSPLTP		; player type set !!
		LDA	!PLTRNAR,X
;?????		STA	PLWALK		; paturn No. set !!
		JSR	PAS050
		BRA	SLKS010
;
;-----< I `FbN >--------------------------------------------------
;
SLKS005		EQU	$
		CMP	#KIHNSPD
		BNE	SLKS010		; Xs[h nj H
;					: yes
;
		INC	BONSMD		; next mode !!
		BRA	SLKS020
;
;-----<  C >----------------------------------------------------
;
SLKS010		EQU	$
		CLC
		ADC	#SKASOKU
		STA	SLTYSD+0
		STA	SLTYSD+2
		STA	SLTYSD+4
;
SLKS020		EQU	$
		JSR	SLOTYCL		; y postion clc
		JSR	SLOTPCK		; position check
		JSR	TUGIYPC		; tsugime position check
;;;;;;;		JSR	SLOTHAD		; wxZbg
		JSR	SLOTCST		; character set
;
;------------------------------------------------------------------------
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTMIN ( WORLD 3 Xbg C )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTMIN		EQU	$
;
;-----< I `FbN >--------------------------------------------------
;
		LDA	SLTYSD+0
		ORA	SLTYSD+2
		ORA	SLTYSD+4
		BNE	SLMN010		; S [ rsno H
;					: yes
;
		JSR	COINCNT		;  `FbN
;
;**1994/07/18**		LDA	SLCOIN
;**1994/07/18**		STA	<WORK0
;**1994/07/18**		JSR	PLUPSET		; vC[ to Zbg
;
		LDA	#00080H
		STA	BONSTM		; timer
;
		INC	BONSMD		; next mode !!
;
		LDA	SLCOIN
		BEQ	SLMN005		; atari ?
;					: yes
;
		LDA	#00090H
		STA	FLASHTM		; flash timer
		LDA	#005H
		STA	<SOUND_0	; [] TEhZbg
		BRA	SLMN020
;
SLMN005		EQU	$
		INC	BONSMD		; next mode !!
		BRA	SLMN020
;
;-----< C [` >------------------------------------------------
;
SLMN010		EQU	$
		JSR	SLOTSTP		; stop
		JSR	SLOTYSC		; y speed clc
		JSR	SLOTYCL		; y postion clc
		JSR	SLOTPCK		; position check
		JSR	TUGIYPC		; tsugime position check
		JSR	SLOTHAD		; hand set
SLMN020		EQU	$
		JSR	SLOTCST		; character set
;
;------------------------------------------------------------------------
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTYCL ( WORLD 3 Xbg {^ `FbN )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTSTP		EQU	$
		MI8			; memory index 8bit mode !!
;
		LDA	SLPUSH+0
		BEQ	SLST005
		LDA	SLPUSH+1
		BEQ	SLST005
		LDA	SLPUSH+2
		BNE	SLST090		; S {^  H
;					: no
;
SLST005		EQU	$
;
;-----< J[\ ړ >--------------------------------------------------
;
		LDA	SLOTPS
		STA	<WORK0
;
		LDA	KEYA2
		AND	#00000011B
		BEQ	SLST040		; E L[ nm H
;					: yes
		AND	#00000010B
		BEQ	SLST020
;;;;;;;
;;;;;;; ----------- [  ] -----------
;;;;;;;
;;;;;;		LDX	SLOTPS
;;;;;;SLST010		EQU	$
;;;;;;		DEX
;;;;;;		BPL	SLST025
;;;;;;;
;;;;;;		LDX	#002
;;;;;;		BRA	SLST025
;;;;;;;
;;;;;;; ----------- [ E ] -----------
;;;;;;;
;;;;;;SLST020		EQU	$
;;;;;;		LDX	SLOTPS
;;;;;;		INX
;;;;;;		CPX	#003
;;;;;;		BNE	SLST025
;;;;;;;
;;;;;;		LDX	#000
;;;;;;SLST025		EQU	$
;;;;;;		STX	SLOTPS
;;;;;;		BRA	SLST090
;;;;;;;
;
; ----------- [  ] -----------
;
		LDX	SLOTPS
SLST010		EQU	$
		DEX
		BPL	SLST011
;
		LDX	#002
SLST011		EQU	$
		LDA	SLPUSH,X
		BNE	SLST010
		BRA	SLST025
;
; ----------- [ E ] -----------
;
SLST020		EQU	$
		LDX	SLOTPS
SLST021		EQU	$
		INX
		CPX	#003
		BNE	SLST022
;
		LDX	#000
SLST022		EQU	$
		LDA	SLPUSH,X
		BNE	SLST021
;
SLST025		EQU	$
		STX	SLOTPS
;
		CPX	<WORK0
		BEQ	SLST090
;
		LDA	#05CH
		JSL	>SOUND_3_ON	; [] TEhZbg
		BRA	SLST090
;
;
;-----< (A),(B),(Y) {^ >---------------------------------------------
;
SLST040		EQU	$
		LDA	KEYA2
		AND	#11000000B
		BNE	SLST050		; (B),(Y) {^ nm H
;					: yes
		LDA	KEYA2L
		AND	#10000000B
		BEQ	SLST090		; (A) {^ nm H
;					: yes
SLST050		EQU	$
		LDX	SLOTPS
		LDA	SLPUSH,X
		BNE	SLST090		; tO nm
;					: no
		INC	SLPUSH,X
;
		JSR	SLOTMSP		; ^C  Xs[h Zbg
;
		LDA	#033H
		JSL	>SOUND_3_ON	; [] TEhZbg
;
		MI16			; memory index 16bit mode !!
		JSR	PUSHBOT		; {^ 
		MI8			; memory index 8bit mode !!
;
		LDX	SLOTPS
SLST051		EQU	$
		INX
		CPX	#003
		BNE	SLST052
;
		LDX	#000
SLST052		EQU	$
		CPX	SLOTPS
		BEQ	SLST090
		LDA	SLPUSH,X
		BNE	SLST051		; Ă H
;					: no
		STX	SLOTPS
;
;
;------------------------------------------------------------------------
;
SLST090		EQU	$
		MI16			; memory index 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTMSP ( WORLD 3 Xbg ^C  Xs[h ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
;=====< o[W >=================================================
;
SLOTTIM		EQU	$
		HEX	002,004,006,008,00A,00C
SLOTTED		EQU	$
SLTMCNT		EQU	SLOTTED-SLOTTIM
;
KIHNSPD		EQU	00380H		; {Xs[h
SLOTSPD		EQU	$
		WORD	KIHNSPD	  - (KIHNSPD>>3)	; 00380H
		WORD	KIHNSPD	  - (KIHNSPD>>2)	; 00300H
		WORD	KIHNSPD/2 + (KIHNSPD>>3)	; 00280H
		WORD	KIHNSPD/2			; 00200H
		WORD	KIHNSPD/2 - (KIHNSPD>>3)	; 00180H
		WORD	KIHNSPD/4			; 00100H
;
;=====< Xbgo[W >=============================================
;
;;;;SLOTTIM		EQU	$
;;;;		HEX	001,001,001,001,001,001
;;;;SLOTTED		EQU	$
;;;;SLTMCNT		EQU	SLOTTED-SLOTTIM
;;;;;
;;;;KIHNSPD		EQU	00400H		; {Xs[h
;;;;SLOTSPD		EQU	$
;;;;		WORD	KIHNSPD
;;;;		WORD	KIHNSPD
;;;;		WORD	KIHNSPD
;;;;		WORD	KIHNSPD
;;;;		WORD	KIHNSPD
;;;;		WORD	KIHNSPD
;
;     
;	<< SLOTPCK >>		BNE	SLCK020 
;				BCC	SLCK020 ɂ
;
;========================================================================
;
;
SLOTMSP		EQU	$
		MI8			; memory,index 8bit mode !!
;
		INC	SLTSTP,X
;
		LDY	SLTSTP,X
		DEY
		LDA	!SLOTTIM,Y
		STA	SLTTIM,X	; timer set
;
		M16			; memory 16bit mode !!
;
		TXA
		ASL	A
		TAY
		LDA	SLTSTP,X
		DEC	A
		ASL	A
		TAX
		LDA	!SLOTSPD,X
		STA	SLTYSD,Y	; y speed set
;
		M8			; memory 8bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTYSC ( WORLD 3 Xbg x Xs[h Zbg ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTYSC		EQU	$
		MI8			; memory,index 8bit mode !!
;
		LDX	#002
SLYS010		EQU	$
		LDA	SLTSTP,X
		BEQ	SLYS050		; ꂽ H
;					: yes
		DEC	SLTTIM,X
		BPL	SLYS050		; ^C}[ "O" H
;					: yes
		LDA	SLTSTP,X
		CMP	#SLTMCNT
		BEQ	SLYS050		; [ rsno H
;					: no
;
		PHX			; (X) push
;
		JSR	SLOTMSP		; ^C  Xs[h Zbg
;
		PLX			; (X) pull
;
SLYS050		EQU	$
		DEX
		BPL	SLYS010
;
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTYCL ( WORLD 3 Xbg x  vZ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTYCL		EQU	$
		LDX	#00004
SLYC010		EQU	$
		LDA	SLTYPS,X
		CLC
		ADC	SLTYSD,X
		STA	SLTYPS,X
		LDA	TUGIYP,X
		CLC
		ADC	SLTYSD,X
		STA	TUGIYP,X
		DEX
		DEX
		BPL	SLYC010
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTPCK ( WORLD 3 Xbg x  `FbN ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTPCK		EQU	$
		MI8			; memory index 8bit mode !!
;
		LDX	#002
SLCK010		EQU	$
		TXA
		ASL	A
		TAY
		LDA	SLTYPS+1,Y
		CMP	#058H
		BNE	SLCK020		; "stop" position over ?
;					: yes
		LDA	SLTSTP,X
		CMP	#SLTMCNT
		BCC	SLCK020		; [ Xgbv H
;					: yes
		LDA	SLTTIM,X
		BPL	SLCK020		; ^C}[ "O" H
;					: yes
;
		M16			; memory 16bit mode !!
;
		LDA	#00000H
		STA	SLTYSD,Y	; y speed clear
		LDA	#05800H
		STA	SLTYPS,Y	; "reel" y position
		LDA	#05000H
		STA	TUGIYP,Y	; "tsugime" y position
;
		M8			; memory 8bit mode !!
;
;;;;;;		JSR	SLOTIXP		; next set
;
		BRA	SLCK030
;
;
SLCK020		EQU	$
		LDA	SLTYPS+1,Y
		CMP	#068H		; #060H
		BCC	SLCK030		; "change" position over ?
;					: yes
		LDA	#006H
		JSL	>SOUND_3_ON	; [] TEhZbg
;
		JSR	SLOTIXP		; next set
;
		TXA
		ASL	A
		TAY
		LDA	SLTYPS+1,Y
		SEC
		SBC	#020H		; #018H
		STA	SLTYPS+1,Y	; y pos reset
;
SLCK030		EQU	$
		DEX
		BPL	SLCK010
;
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTIXP ( WORLD 3 Xbg  |Cg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTIXP		EQU	$
		MI8			; memory,index 8bit mode !!
;
		LDA	SLTIDX,X
		CLC
		ADC	#001
		AND	#007
		STA	SLTIDX,X	; next index set
;
		TXA
		ASL	A
		ASL	A
		TAY
		LDA	SLOT00+2,Y
		STA	SLOT00+3,Y
		LDA	SLOT00+1,Y
		STA	SLOT00+2,Y
		LDA	SLOT00+0,Y
		STA	SLOT00+1,Y
;
		PHY			; (Y) push
		TXA
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	SLTIDX,X
		TAY
		LDA	!STOTTBL,Y
		PLY			; (Y) pull
		STA	SLOT00+0,Y
;
;;;;;;;		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;
		MEM16
		IDX16
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTCST ( WORLD 3 Xbg LN^[Zbg ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CHERY		EQU	0	; `F[
TAMGO		EQU	1	; 
HEIHO		EQU	2	; wCz[
HOSHI		EQU	3	; X^[
SUIKA		EQU	4	; XCJ
SEVEN		EQU	5	; V
;
;
STOTTBL		EQU	$
		BYTE	CHERY,TAMGO,HEIHO,HOSHI,SUIKA,SEVEN,CHERY,TAMGO ; [
		BYTE	TAMGO,CHERY,HOSHI,SUIKA,SEVEN,CHERY,TAMGO,HEIHO ; [
		BYTE	HEIHO,HOSHI,SUIKA,SEVEN,CHERY,TAMGO,HEIHO,HOSHI ; E[
;
SLOTXPS		EQU	$
		WORD	00030H,00038H,00040H,00030H
		WORD	00050H,00058H,00060H,00050H
		WORD	00070H,00078H,00080H,00070H
;
SLOTCDT		EQU	$
		WORD	02100H,02100H+011H,02100H+002H,02100H+020H	; `F[
		WORD	02103H,02103H+011H,02103H+002H,02103H+020H	; 
		WORD	02106H,02106H+011H,02106H+002H,02106H+020H	; wCz[
		WORD	02133H,02133H+011H,02133H+002H,02133H+020H	; X^[
		WORD	02136H,02136H+011H,02136H+002H,02136H+020H	; XCJ
		WORD	02130H,02130H+011H,02130H+002H,02130H+020H	; V
;
;
SLOTCST		EQU	$
		LDY	OAMIDX
		LDA	#00000
		STA	<WORK0		; [ mD
;
TUCS010		EQU	$
;
;-----< w |WV >--------------------------------------------------
;
		LDA	<WORK0
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	!SLOTXPS,X
		STA	SOAM_DX+00H,Y
		STA	SOAM_DX+20H,Y
		STA	SOAM_DX+40H,Y
;;;;;;;		STA	SOAM_DX+60H,Y
		LDA	!SLOTXPS+2,X
		STA	SOAM_DX+08H,Y
		STA	SOAM_DX+28H,Y
		STA	SOAM_DX+48H,Y
;;;;;;;		STA	SOAM_DX+68H,Y
		LDA	!SLOTXPS+4,X
		STA	SOAM_DX+10H,Y
		STA	SOAM_DX+30H,Y
		STA	SOAM_DX+50H,Y
;;;;;;;		STA	SOAM_DX+70H,Y
		LDA	!SLOTXPS+6,X
		STA	SOAM_DX+18H,Y
		STA	SOAM_DX+38H,Y
		STA	SOAM_DX+58H,Y
;;;;;;;		STA	SOAM_DX+78H,Y
;
;-----< x |WV >--------------------------------------------------
;
		LDA	<WORK0		; P
		ASL	A
		TAX
		LDA	SLTYPS,X
		XBA
		DEC	A		; position (-1)
		AND	#000FFH
		SEC
		SBC	<SCCV1
		SEC
		SBC	#00008
		STA	SOAM_DX+02H,Y
		STA	SOAM_DX+12H,Y
		CLC
		ADC	#00008
		STA	SOAM_DX+0AH,Y
		CLC
		ADC	#00008
		STA	SOAM_DX+1AH,Y
		CLC			; Q
		ADC	#00010H		; #00008
		STA	SOAM_DX+22H,Y
		STA	SOAM_DX+32H,Y
		CLC
		ADC	#00008
		STA	SOAM_DX+2AH,Y
		CLC
		ADC	#00008
		STA	SOAM_DX+3AH,Y
		CLC			; R
		ADC	#00010H		; #00008
		STA	SOAM_DX+42H,Y
		STA	SOAM_DX+52H,Y
		CLC
		ADC	#00008
		STA	SOAM_DX+4AH,Y
		CLC
		ADC	#00008
		STA	SOAM_DX+5AH,Y
;;;;;;;		CLC			; S
;;;;;;;		ADC	#00010H		; #00008
;;;;;;;		STA	SOAM_DX+62H,Y
;;;;;;;		STA	SOAM_DX+72H,Y
;;;;;;;		CLC
;;;;;;;		ADC	#00008
;;;;;;;		STA	SOAM_DX+6AH,Y
;;;;;;;		CLC
;;;;;;;		ADC	#00008
;;;;;;;		STA	SOAM_DX+7AH,Y
;
;-----< LAgr[g >-----------------------------------------
;
		LDA	<WORK0
		ASL	A
		ASL	A
		STA	<WORK2
		TAX
		LDA	SLOT00,X
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	!SLOTCDT+0,X	; P
		STA	SOAM_DX+04H,Y
		LDA	!SLOTCDT+2,X
		STA	SOAM_DX+0CH,Y
		LDA	!SLOTCDT+4,X
		STA	SOAM_DX+14H,Y
		LDA	!SLOTCDT+6,X
		STA	SOAM_DX+1CH,Y
;
		LDX	<WORK2
		LDA	SLOT00+1,X
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	!SLOTCDT+0,X	; Q
		STA	SOAM_DX+24H,Y
		LDA	!SLOTCDT+2,X
		STA	SOAM_DX+2CH,Y
		LDA	!SLOTCDT+4,X
		STA	SOAM_DX+34H,Y
		LDA	!SLOTCDT+6,X
		STA	SOAM_DX+3CH,Y
;
		LDX	<WORK2
		LDA	SLOT00+2,X
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
		TAX
		LDA	!SLOTCDT+0,X	; R
		STA	SOAM_DX+44H,Y
		LDA	!SLOTCDT+2,X
		STA	SOAM_DX+4CH,Y
		LDA	!SLOTCDT+4,X
		STA	SOAM_DX+54H,Y
		LDA	!SLOTCDT+6,X
		STA	SOAM_DX+5CH,Y
;
;;;;;;;		LDX	<WORK2
;;;;;;;		LDA	SLOT00+3,X
;;;;;;;		AND	#000FFH
;;;;;;;		ASL	A
;;;;;;;		ASL	A
;;;;;;;		ASL	A
;;;;;;;		TAX
;;;;;;;		LDA	!SLOTCDT+0,X	; S
;;;;;;;		STA	SOAM_DX+64H,Y
;;;;;;;		LDA	!SLOTCDT+2,X
;;;;;;;		STA	SOAM_DX+6CH,Y
;;;;;;;		LDA	!SLOTCDT+4,X
;;;;;;;		STA	SOAM_DX+74H,Y
;;;;;;;		LDA	!SLOTCDT+6,X
;;;;;;;		STA	SOAM_DX+7CH,Y
;
;-----< n`lrta >---------------------------------------------------
;
		LDA	#00002
		STA	SOAM_DX+06H,Y
		STA	SOAM_DX+0EH,Y
		STA	SOAM_DX+26H,Y
		STA	SOAM_DX+2EH,Y
		STA	SOAM_DX+46H,Y
		STA	SOAM_DX+4EH,Y
;;;;;;;		STA	SOAM_DX+66H,Y
;;;;;;;		STA	SOAM_DX+6EH,Y
		LDA	#00000
		STA	SOAM_DX+16H,Y
		STA	SOAM_DX+1EH,Y
		STA	SOAM_DX+36H,Y
		STA	SOAM_DX+3EH,Y
		STA	SOAM_DX+56H,Y
		STA	SOAM_DX+5EH,Y
;;;;;;;		STA	SOAM_DX+76H,Y
;;;;;;;		STA	SOAM_DX+7EH,Y
;
;------------------------------------------------------------------------
;
		INC	<WORK0
		LDA	<WORK0
		CMP	#00003
		BEQ	TUCS090		; QI H
;					: no
		TYA
		CLC
		ADC	#00020H*3
		TAY
		JMP	TUCS010
;
TUCS090		EQU	$
		LDA	OAMIDX
		CLC
		ADC	#00020H*3*3	; #00020H*4*3
		STA	OAMIDX
;
;
		JMP	TUGICST		; pڃZbg
;
;;;;;;;		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLOTHAD ( WORLD 3 Xbg  Zbg )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
HANDXPS		EQU	$
		WORD	00034H,00054H,00074H
;
HANDYPS		EQU	000B0H
;
PUSHHND		EQU	03162H		; 
NORMHND		EQU	03160H		; ĂȂ
;
;
SLOTHAD		EQU	$
		LDA	SLTCAN
		BEQ	SLHD090		; ߂Ă H
;					: no
		LDY	OAMIDX
		LDA	SLOTPS
		AND	#000FFH
		ASL	A
		TAX
		LDA	!HANDXPS,X
		STA	SOAM_DX+00,Y
		LDA	#HANDYPS
		SEC
		SBC	<SCCV1
		STA	SOAM_DX+02,Y
;
		LDA	KEYA1
		AND	#000C0H
		BNE	SLHD005		; (B),(Y) push ?
;					: no
		LDA	KEYA1L
		AND	#00080H
		BEQ	SLHD010		; (A) push ?
;					: yes
SLHD005		EQU	$
		LDA	#PUSHHND
		BRA	SLHD020
SLHD010		EQU	$
		LDA	#NORMHND
SLHD020		EQU	$
		STA	SOAM_DX+04,Y
		LDA	#00002H
		STA	SOAM_DX+06,Y
;
		LDA	OAMIDX
		CLC
		ADC	#00008
		STA	OAMIDX
;
SLHD090		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINCNT ( WORLD 3 Xbg  `FbN )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINCNT		EQU	$
		MI8			; memory,index 8bit mode !!
;
		LDA	SLOT00+1
		CMP	#HEIHO
		BNE	COIN010
;
		LDA	SLOT10+1
		CMP	#HOSHI
		BNE	COIN010
;
		LDA	SLOT20+1
		CMP	#SUIKA
		BNE	COIN080		; wCz[EX^[EXCJ H
;					: yes
		BRA	COIN040
;
;
COIN010		EQU	$
		LDA	SLOT00+1
		CMP	SLOT10+1
		BNE	COIN080
		CMP	SLOT20+1
		BNE	COIN080
;
		CMP	#CHERY
		BNE	COIN020		; `F[ H
;					: yes
		LDA	#002		; #005
		BRA	COIN050
;
COIN020		EQU	$
		CMP	#TAMGO
		BNE	COIN030		;  H
;					: yes
		LDA	#003
		BRA	COIN050

COIN030		EQU	$
		CMP	#SEVEN
		BNE	COIN040		; V ?
;					: yes
		LDA	#005		; #002
		BRA	COIN050
;
COIN040		EQU	$		; ̑
		LDA	#001
;
COIN050		EQU	$
		STA	SLCOIN
;
		MI16
		LDX	#PYORO
		STX	BSPLTP		; player type set !!
		BRA	COIN090
;
COIN080		EQU	$
		MEM8
;
		LDA	#07DH		; nY
		JSL	>SOUND_3_ON	; [] TEhZbg
;
		MI16
		LDX	#PTAOR
		STX	BSPLTP		; player type set !!
;
COIN090		EQU	$
		LDA	!PLTRNAR,X
;?????		STA	PLWALK		; paturn No. set !!
		JSR	PAS050
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLTCOIN ( WORLD 3 Xbg vC[ Abv )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLTCOIN		EQU	$
		DEC	BONSTM
		BNE	SLCN090		; timer "0" ?
;					: yes
;
;-----< Xbg I`FbN >------------------------------------------
;
		LDA	SLCOIN
		AND	#000FFH
		BNE	SLCN010
;
;;;;;;		JSR	SLOTIT0		; CjV
;
;;;;;;		LDA	#SLTIN		; next mode
;;;;;;		STA	BONSMD
;
SLCN005		EQU	$
		LDA	#00080H		; timer
		STA	BONSTM
		INC	BONSMD		; next mode
;
		BRA	SLCN090
;
;
;-----< vC[JEg Abv >--------------------------------------
;
SLCN010		EQU	$
		LDA	PLCONT
		CMP	#999
		BEQ	SLCN005
;[1994/08/30]		BNE	SLCN020
;[1994/08/30];
;[1994/08/30]		M8			; memory 8bit mode !!
;[1994/08/30]		STZ	SLCOIN
;[1994/08/30]		M16			; memory 16bit mode !!
;[1994/08/30]		BRA	SLCN090
;
SLCN020		EQU	$
		DEC	SLCOIN
		INC	!PLCONT
		JSR	PLCNTST		; vC[ Abv
;
		M8			; memory 8bit mode !!
		LDA	#008H
		JSL	>SOUND_3_ON	; [] TEhZbg
		M16			; memory 16bit mode !!
;
		LDA	#00030H
		STA	BONSTM
;
;------------------------------------------------------------------------
;
SLCN090		EQU	$
;[1995/06/12]		JSR	SLOTHAD		; wxZbg
		JSR	SLOTCST		; Xbg LN^[Zbg
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	TUGICST ( WORLD 3 Xbg pڃZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
TSUGIXP		EQU	$
		WORD	00030H
		WORD	00050H
		WORD	00070H
;
TSGICDT		EQU	02D68H
;
;
TUGICST		EQU	$
		LDY	OAMIDX
		LDA	#00000
		STA	<WORK0		; [ mD
;
SLCS010		EQU	$
;
;-----< w |WV >--------------------------------------------------
;
		LDA	<WORK0
		ASL	A
		TAX
		LDA	!TSUGIXP,X
		STA	SOAM_DX+00H,Y
		STA	SOAM_DX+18H,Y
		STA	SOAM_DX+30H,Y
		CLC
		ADC	#00008H
		STA	SOAM_DX+08H,Y
		STA	SOAM_DX+20H,Y
		STA	SOAM_DX+38H,Y
		CLC
		ADC	#00008H
		STA	SOAM_DX+10H,Y
		STA	SOAM_DX+28H,Y
		STA	SOAM_DX+40H,Y
;
;-----< x |WV >--------------------------------------------------
;
		LDA	<WORK0		; P
		ASL	A
		TAX
		LDA	TUGIYP,X
		XBA
		DEC	A		; position (-1)
		AND	#000FFH
		SEC
		SBC	<SCCV1
	SEC
	SBC	#00008
		STA	SOAM_DX+02H,Y
		STA	SOAM_DX+0AH,Y
		STA	SOAM_DX+12H,Y
		CLC			; Q
		ADC	#00020H
		STA	SOAM_DX+1AH,Y
		STA	SOAM_DX+22H,Y
		STA	SOAM_DX+2AH,Y
		CLC			; R
		ADC	#00020H
		STA	SOAM_DX+32H,Y
		STA	SOAM_DX+3AH,Y
		STA	SOAM_DX+42H,Y
;
;-----< LAgr[g >-----------------------------------------
;
		LDA	#TSGICDT
		STA	SOAM_DX+04H,Y	; P
		STA	SOAM_DX+0CH,Y
		STA	SOAM_DX+14H,Y
		STA	SOAM_DX+1CH,Y	; Q
		STA	SOAM_DX+24H,Y
		STA	SOAM_DX+2CH,Y
		STA	SOAM_DX+34H,Y	; R
		STA	SOAM_DX+3CH,Y
		STA	SOAM_DX+44H,Y
;
;
;-----< n`lrta >---------------------------------------------------
;
		LDA	#00000
		STA	SOAM_DX+06H,Y
		STA	SOAM_DX+0EH,Y
		STA	SOAM_DX+16H,Y
		STA	SOAM_DX+1EH,Y
		STA	SOAM_DX+26H,Y
		STA	SOAM_DX+2EH,Y
		STA	SOAM_DX+36H,Y
		STA	SOAM_DX+3EH,Y
		STA	SOAM_DX+46H,Y
;
;------------------------------------------------------------------------
;
		INC	<WORK0
		LDA	<WORK0
		CMP	#00003
		BEQ	SLCS090		; RI H
;					: no
		TYA
		CLC
		ADC	#00080H
		TAY
		JMP	SLCS010
;
SLCS090		EQU	$
		LDA	OAMIDX
		CLC
		ADC	#00010H*3*3
		STA	OAMIDX
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	TUGIYPC ( WORLD 3 Xbg p `FbN )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
TUGIYPC		EQU	$
		LDX	#00004
TUCK010		EQU	$
		LDA	TUGIYP,X
		CMP	#06800H		; #06000H
		BCC	TUCK030		; position over ?
;					: yes
;
		LDA	TUGIYP+0,X
		SEC
		SBC	#02000H
		STA	TUGIYP+0,X
;
TUCK030		EQU	$
		DEX
		DEX
		BPL	TUCK010
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PUSHBOT ( WORLD 3 Xbg {^  )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BOTNADR		EQU	$
		WORD	002A6H+bg1_adrs		; left
		WORD	002AAH+bg1_adrs		; middle
		WORD	002AEH+bg1_adrs		; right
;
BOTCHUP		EQU	03CF4H
BOTCHDN		EQU	03CF7H
;
;
PUSHBOT		EQU	$
		LDA	SLOTPS
		AND	#000FFH
		ASL	A
		TAY
		LDA	>VRAMD
		TAX
;
		LDA	!BOTNADR,Y
		STA	>VRAMD+2,X
		CLC
		ADC	#00020H
		STA	>VRAMD+12,X
;
		LDA	#00003H*2-1
		STA	>VRAMD+4,X
		STA	>VRAMD+14,X
;
		LDA	#BOTCHUP
		STA	>VRAMD+6,X
		INC	A
		STA	>VRAMD+8,X
		INC	A
		STA	>VRAMD+10,X
		LDA	#BOTCHDN
		STA	>VRAMD+16,X
		INC	A
		STA	>VRAMD+18,X
		INC	A
		STA	>VRAMD+20,X
;
		LDA	#0FFFFH
		STA	>VRAMD+22,X
;
		TXA
		CLC
		ADC	#00020
		STA	>VRAMD
;
FLASHEND	EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLFLASH ( WORLD 3 Xbg  tbV )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLFLASH		EQU	$
;[1995/06/12]		JSR	SLOTHAD		; wxZbg
		JSR	SLOTCST		; Xbg LN^[Zbg
;
		DEC	FLASHTM
		BPL	SLFL010		; timer end ?
;					: yes
		LDA	#00001H
		STA	BONSTM
		INC	BONSMD
		RTS
;
;
SLFL010		EQU	$
		LDA	SLCOIN
		AND	#000FFH
		DEC	A
		ASL	A
		TAX
		JMP	(!FLASHADR,X)
;
FLASHADR	EQU	$
		WORD	FLASH01		; 1 upiheiho,star,suikaj
		WORD	FLASH00		; 2 up (cherry)
		WORD	FLASH00		; 3 up (egg)
		WORD	FLASHEND	; dummy
		WORD	FLASH00		; 5 up (seven)
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	FLASH00 ( WORLD 3 Xbg tbV P )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ATARAD0		EQU	$
		WORD	001F3H+bg1_adrs		; cherry
		WORD	001B3H+bg1_adrs		; egg
		WORD	00173H+bg1_adrs		; seven
;
ATARDT0		EQU	$
		WORD	00000H			; nuki
		WORD	02CFCH			; beta
;
;
FLASH00		EQU	$
		LDA	SLCOIN
		AND	#000FFH
		SEC
		SBC	#00002
		CMP	#00003
		BNE	FLSH010
;
		DEC	A
FLSH010		EQU	$
		ASL	A
		TAY
;
		LDA	>VRAMD
		TAX
;
		LDA	!ATARAD0,Y
		STA	>VRAMD+2,X
		CLC
		ADC	#00020H
		STA	>VRAMD+8,X
;
		LDA	#00007H*2
		ORA	#04000H
		STA	>VRAMD+4,X
		STA	>VRAMD+10,X
;
		LDA	FLASHTM
		AND	#00004H
		LSR	A
		TAY
		LDA	!ATARDT0,Y
		STA	>VRAMD+6,X
		STA	>VRAMD+12,X
;
		LDA	#0FFFFH
		STA	>VRAMD+14,X
;
		TXA
		CLC
		ADC	#00012
		STA	>VRAMD
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	FLASH01 ( WORLD 3 Xbg tbV Q )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ATARAD1		EQU	00233H+bg1_adrs		; heiho,star,suika
;
;
FLASH01		EQU	$
		LDA	>VRAMD
		TAX
;
		LDA	#ATARAD1
		STA	>VRAMD+2,X
		CLC
		ADC	#00020H
		STA	>VRAMD+8,X
		CLC
		ADC	#00020H
		STA	>VRAMD+14,X
		CLC
		ADC	#00020H
		STA	>VRAMD+20,X
		CLC
		ADC	#00020H
		STA	>VRAMD+26,X
;
		LDA	#00007H*2
		ORA	#04000H
		STA	>VRAMD+4,X
		STA	>VRAMD+10,X
		STA	>VRAMD+16,X
		STA	>VRAMD+22,X
		STA	>VRAMD+28,X
;
		LDA	FLASHTM
		AND	#00004H
		LSR	A
		TAY
		LDA	!ATARDT0,Y
		STA	>VRAMD+6,X
		STA	>VRAMD+12,X
		STA	>VRAMD+18,X
		STA	>VRAMD+24,X
		STA	>VRAMD+30,X
;
		LDA	#0FFFFH
		STA	>VRAMD+32,X
;
		TXA
		CLC
		ADC	#00030
		STA	>VRAMD
;
		RTS
;
;
;
;
;
;
;
;
;
;
;
;============== vnqkc@S ==========================================
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SUZIMOV ( WORLD 4  move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
		MEM16
		IDX16
;
;
SUZIMOV		EQU	$
		LDA	BONSMD
		ASL	A
		TAX
		JMP	(!SUZIADR,X)
;
;
SUZIADR		EQU	$
		WORD	TIMEDEC		; 0 timer dec. set sub !!
		WORD	WINDOPN		; 1 window open sub !!
		WORD	TIMDEC0		; 2 timer dec. set sub !!
		WORD	MSWINOP		; 3 messege window open sub !!
		WORD	WINCLSB		; 4 window color sub !!
		WORD	SCRDOWN		; 5 screen down move sub !!
		WORD	SCRYURE		; 6 screen yure sub !!
		WORD	TIMDEC2		; 7 timer dec. set sub !!
		WORD	B4MAIN		; 8 bonus 4 main plogram
BS4MAP		WORD	MODEMAP		; 9 map initial mode set sub !!
;
;
BS4MP		EQU	(BS4MAP-SUZIADR)/2
;
;
;************************************************************************
;*		bonus 4 Main  Program					*
;************************************************************************
B4MAINPL	EQU	$
MP00		BYTE	LOW BETSET		; 0 : bet set
MP01		BYTE	LOW ROLTPL		; 1 : roolet play
MP02		BYTE	LOW RESULT		; 2 : ke_kka
MP03		BYTE	LOW PLYINC		; 3 : player inc
;
;
B4MAINPH	EQU	$
		BYTE	HIGH BETSET
		BYTE	HIGH ROLTPL
		BYTE	HIGH RESULT
		BYTE	HIGH PLYINC
;
;
B4MAINPB	EQU	$
		BYTE	BANK BETSET
		BYTE	BANK ROLTPL
		BYTE	BANK RESULT
		BYTE	BANK PLYINC
;
;
;
;
BETST		EQU	(MP00-MP00)
ROLPL		EQU	(MP01-MP00)
RESLT		EQU	(MP02-MP00)
PLINC		EQU	(MP03-MP00)
;
B4MAIN		EQU	$
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		JSL	>B4MAIN_P
;
		JSR	RLTFSSB
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		RTS
;
		MEM8
		IDX8
;
B4MAIN_P	EQU	$
;
		LDX	!SLMODE
		LDA	>B4MAINPL,X
		STA	<WORK3
		LDA	>B4MAINPH,X
		STA	<WORK4
		LDA	>B4MAINPB,X
		STA	<WORK5
		JML	(!WORK3)
;
;
;
;************************************************************************
;*		bet set					(BETSET)	*
;************************************************************************
BETSET		EQU	$
		LDA	<KEYC2L
		AND	#10000000B
		BNE	BST000		; push A button ?
;					; no
		LDA	<KEYC2
		BIT	#11000000B
		BEQ	BST010		; push Y or B button ?
;
BST000		EQU	$		; *** bet set check ***
;					; yes
;;;		MEM16
;;;		REP	#00100000B	; memory 16bit mode
;;;;
;;;		LDA	!BETCNT
;;;		AND	#00FFH
;;;		STA	<WORK0		; ke_ta a_wa_se
;;;;
;;;		LDA	!PLCNT
;;;		CMP	<WORK0
;;;		BCS	BST005		; player count >= bet count ?
;;;;					; no
;;;		MEM8
;;;		SEP	#00100000B	; memory 8bit mode
;;;;
;;;;		RTL
;;;BST005		EQU	$
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
;;;		LDA	!BETCNT
;;;		BEQ	BSTEND		; no bet ?
;					; no
;;;		STA	!WAITCNT	; wait counter set
;;;		STZ	!WAITCNT+1
;
		LDA	#ROLPL
		STA	!SLMODE		; player dec mode set
;
		LDA	#01CH		;  TEhZbg ({^)
		JSL	>SOUND_3_ON
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	#PMIR2
		STA	!BSPLTP		; vC[ |[Y Zbg
		TAY
		LDA	!PLTRNAR,Y
		JSR	PAS050
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		JSR	BETDSP1		; bet display 1
		RTL
;
BST010		EQU	$
		AND	#00001100B
		BNE	BST050		; push up or down key ?
;					; no
		LDA	<KEYC1
		AND	#00001100B
		BNE	BST020		; push up or down key ?
;					; no
		STZ	!KEYWTTM
		RTL
;
BST020		EQU	$
		INC	!KEYWTTM
		LDX	!KEYWTTM
		CPX	#020H
		BNE	BSTEND		; push push time max ?
;					; yes
		DEC	!KEYWTTM	; continue push push
BST050		EQU	$
		STA	<WORKF
;
		LDA	!KEYWTTM
		CMP	#01FH
		BNE	BST060		; key push push ?
;					; yes
		LDA	<FRCNT
		AND	#00000001B
		BEQ	BST070		; sound on flame ? (2 flame again)
;
BST060		EQU	$
		LDA	!PLCNT+1
		BNE	BST065			; player 255 i_jyo ?
;						; no
		LDA	!PLCNT
		CMP	#001H
		BNE	BST065			; player 1 ?
;						; yes
		LDA	!BETCNT
		CMP	#001H
		BEQ	BST080			; bet count 1 ?
;						; no
;
BST065		EQU	$
		LDA	#009H		;  TEhZbg (ads㉺)
		JSL	>SOUND_3_ON
;NOM;		LDA	#006H
;NOM;		STA	<SOUND3		;  TEhZbg (ads㉺)
;
BST070		EQU	$
		JSR	BETSUB		; bet set sub
;;;		JSR	PLTLDSP		; player counter set
;
BST080		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	!BETCNT
		AND	#00FFH
		STA	<WORK0		; HI clear
;
		LDA	!PLCNT
		SEC
		SBC	<WORK0
		INC	A		; min bet 1 plus
		STA	!PLCONT		; player display out ram set
		JSR	PLCNTST		; player counter set (new)
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		JSR	BETDSP		; bet counter set
;
BSTEND		EQU	$
		RTL
;
;;;;************************************************************************
;;;;*		plyer dec				(PLYDEC)	*
;;;;************************************************************************
;;;PLYDEC		EQU	$
;;;;
;;;		MEM16
;;;		REP	#00100000B	; memory 16bit mode
;;;;
;;;		LDA	!WAITCNT
;;;		DEC	!PLCONT
;;;;
;;;		LDX	#001H
;;;		STX	<SOUND3		;  TEhZbg (ni_n_zu_u minus)
;;;;
;;;		DEC	A
;;;		STA	!WAITCNT
;;;		BNE	PLDEND
;;;;
;;;		MEM8
;;;		SEP	#00100000B	; memory 8bit mode
;;;;
;;;		LDA	#ROLPL
;;;		STA	!SLMODE		; roolet play mode set
;;;PLDEND		EQU	$
;;;;
;;;		MEM8
;;;		SEP	#00100000B	; memory 8bit mode
;;;;
;;;;;;		JSR	PLTLDSP		; player counter set
;;;;
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B	; memory,index 16bit mode
;;;;
;;;		JSR	PLCNTST		; player counter set (new)
;;;;
;;;		MEM8
;;;		IDX8
;;;		SEP	#00110000B	; memory,index 8bit mode
;;;;
;;;		RTL
;;;;
;************************************************************************
;*		roolet play				(ROLTPL)	*
;************************************************************************
ROLTPL		EQU	$
		LDA	!DEMOFG
		BNE	RPL040		; push button after ?
;					; no
		LDA	<KEYC2L
		AND	#10000000B
		BNE	RPL030		; push A button ?
;					; no
		LDA	<KEYC2
		AND	#11000000B
		BEQ	RPL040		; push Y or B button ?
;					; yes
RPL030		EQU	$
		INC	!DEMOFG
		LDA	#050H
		STA	!PWORK2		; slow start time set
		STA	!PWORK3		; slow start time set
RPL040		EQU	$
;
		LDX	#000H		; left roolet:0 right roolet:1
RPL050		EQU	$
		LDA	!PWORKE
		DEC	A
		STA	<WORK0
		CPX	<WORK0
		BEQ	RPL060		; move roolet ?
;					; no
		JSR	SPDCMP0		; speed comp & bg out sub
RPL060		EQU	$
		INX
		CPX	#002H
		BNE	RPL050		; left and right roolet display out end ?
;					; yes
RPLEND		EQU	$
;;;		JSR	PLTLDSP		; player counter set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		JSR	PLCNTST		; player counter set (new)
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		JSR	BETDSP
		RTL
;
;************************************************************************
;*		result display out			(RESULT)	*
;************************************************************************
RESULT		EQU	$
;
		DEC	!MSGTM
		BNE	RSLTEND		; next display out ?
;					; yes
		JSR	RSLOTSB
;
		LDA	#040H
		STA	!MSGTM		; wait timer set
;
		INC	!MSGPT		; next messege mode
		LDA	!MSGPT
		CMP	#EDDSP
		BNE	RSLTEND		; messege end ?
;					; yes
		LDA	#PLINC
		STA	!SLMODE
;
;;;		LDA	!TOTLCNT
;;;		STA	!WAITCNT
;;;		LDA	!TOTLCNT+1
;;;		STA	!WAITCNT+1
;
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00040H
		STA	!BONSTM		; wait timer set
		LDA	!TOTLCNT
		STA	!SLCOIN		; player up set
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		BEQ	RSLT010
;
		LDA	!TOTLCNT+1
		BNE	RSLT005		; player up ? (255 i_jyo_u UP ?)
;					; no
		LDA	!BETCNT
		CMP	!TOTLCNT
		BCS	RSLT030		;  |[Y ?
;					; yes
RSLT005		EQU	$
		LDA	#005H		;  TEhZbg (t@t@[)
		STA	<SOUND_0
		BRA	RSLT030
RSLT010		EQU	$
		LDA	#07DH		;  TEhZbg (~O)
		JSL	>SOUND_3_ON
;NOM;		LDA	#02AH
;NOM;		STA	<SOUND3		;  TEhZbg (~O)
RSLT030		EQU	$		; vC[ |[Y Zbg
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#PYORO		;  |[Y
		LDA	!BETCNT
		AND	#00FFH
		CMP	!TOTLCNT
		BCC	RSLT050		; |[Y Zbg ?
;					; yes
		PHP
;
		LDX	#PWALK		;  |[Y
;
		PLP
;
		BEQ	RSLT050		; |[Y Zbg ?
;					; yes
		LDX	#PTAOR		; ̂ē|ꍞ |[Y
RSLT050		EQU	$
		STX	!BSPLTP
		LDA	!PLTRNAR,X
		JSR	PAS050
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
RSLTEND		EQU	$
		RTL
;************************************************************************
;*		player inc				(PLYINC)	*
;************************************************************************
PLYINC		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		JSR	BONUSPLAYERUP
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		RTL
;
;;;;
;;;		LDA	!WAITCNT
;;;		BEQ	PLI010		; plus counter 0 ?
;;;;					; no
;;;		LDA	!PLCONT
;;;		CMP	#003E7H
;;;		BCS	PLI000		; 999 counter stop ?
;;;;					; no
;;;		INC	!PLCONT
;;;;
;;;		LDX	#005H
;;;		STX	<SOUND3		;  TEhZbg (Pto)
;;;;
;;;PLI000		EQU	$
;;;		LDA	!WAITCNT
;;;		DEC	A
;;;		STA	!WAITCNT
;;;		BNE	PLIEND		; plus counter end ?
;;;;					; yes
;;;PLI010		EQU	$
;;;;
;;;		INC	!BONSMD		; return bonus out mode set
;;;		LDA	#00080H
;;;		STA	!BONSTM
;;;;
;;;PLIEND		EQU	$
;;;;
;;;		MEM8
;;;		SEP	#00100000B	; memory 8bit mode
;;;;
;;;;;;		JSR	PLTLDSP		; player counter set
;;;;
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B	; memory,index 16bit mode
;;;;
;;;		JSR	PLCNTST		; player counter set (new)
;;;;
;;;		MEM8
;;;		IDX8
;;;		SEP	#00110000B	; memory,index 8bit mode
;;;;
;;;		RTL
;
;
;
;
;################################################################################
;#		result out sub							#
;################################################################################
RSLOTSB		EQU	$
		LDA	!MSGPT
		JSL	>JSRSUB
;
;
RSOMD0		WORD	KEKADSP		; 0 : ke_kka display
RSOMD1		WORD	DAMMY		; 1 : dammy
;
;
KADSP		EQU	(RSOMD0-RSOMD0)/2
EDDSP		EQU	(RSOMD1-RSOMD0)/2
;
;
;################################################################################
;#		bet player hyo_u_ji bg data 1 (result)				#
;################################################################################
BETDAT1		EQU	$
		HEX	F5,39,03,00
		WORD	02CFCH,02CFCH
;
		HEX	15,3A,03,00
		WORD	02CFCH,02CFCH
;
		WORD	0FFFFH
BETDT1E		EQU	$
;
;################################################################################
;#		bet player hyo_u_ji bg out 1 (result)				#
;################################################################################
BETDSP1		EQU	$
;
		LDA	!BETCNT
		STA	<WORKE
		STZ	<WORKF
		JSR	DSPCHGSB		; DSPOT1,DSPOT10,DSPOT100 ram set sub
;
		STZ	<WORK3
		STZ	<WORK5
;
		LDA	!DSPOT1
		ASL	A
		STA	<WORK4			; charcter 1  index set
		LDA	!DSPOT10
		ASL	A
		STA	<WORK2			; charcter 10 index set
;
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	>VRAMD
		CLC
		ADC	#(BETDT1E-BETDAT1)-1
		TAX				; vramd address set
		DEC	A
		STA	>VRAMD
		LDY	#(BETDT1E-BETDAT1)-1
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
BDS1200		EQU	$
		LDA	BETDAT1,Y
		STA	>VRAMD+2,X		; hi low ko_su_u data set
		DEX
		DEY
		BPL	BDS1200			; base data set end ?
;						; yes
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	>VRAMD
		SEC
		SBC	#00CH
		TAX
;
		LDY	<WORK2
		BEQ	BDS1210			; 10 no ke_ta 0 ?
;						; no
		LDA	NUMBERHIGH,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2,X		; charcter No. set
;
BDS1210		EQU	$
		LDY	<WORK4
		LDA	NUMBERHIGH,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+4,X		; charcter No. set
;
;
;
		LDA	>VRAMD
		SEC
		SBC	#004H
		TAX
;
		LDY	<WORK2
		BEQ	BDS1220			; 10 no ke_ta 0 ?
;						; no
		LDA	NUMBERLOW,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2,X		; charcter No. set
;
BDS1220		EQU	$
		LDY	<WORK4
		LDA	NUMBERLOW,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+4,X		; charcter No. set
;
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
DAMMY		EQU	$
		RTS
;
;################################################################################
;#		marker hyo_u_ji bg out						#
;################################################################################
MRKDAT		EQU	$
		HEX	F7,39,01,00
		WORD	02CFCH
;
		HEX	17,3A,01,00
		WORD	02CFCH
;
		WORD	0FFFFH
MRKDTE		EQU	$
;
;
MRKCHR		EQU	$ (up)
;			   +	  *
		WORD	03EF8H,03EF6H
;
MRKCHR1		EQU	$ (down)
		WORD	03EF9H,03EF7H
;################################################################################
;#		marker hyo_u_ji bg out (result)					#
;################################################################################
MARKDSP		EQU	$
;
		PHX
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	>VRAMD
		CLC
		ADC	#(MRKDTE-MRKDAT)-1
		TAX				; vramd address set
		DEC	A
		STA	>VRAMD
		LDY	#(MRKDTE-MRKDAT)-1
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
MKDS010		EQU	$
		LDA	MRKDAT,Y
		STA	>VRAMD+2,X		; hi low ko_su_u data set
		DEX
		DEY
		BPL	MKDS010			; base data set end ?
;						; yes
		LDA	!PWORK0			; left roolet stop data index
		TAY
		LDA	LMARKDT,Y		; X or + data set
		ASL	A
		TAY				; charcter index set (MRKCHR,MRKCHR1)
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	>VRAMD
		SEC
		SBC	#008H
		TAX
;
		LDA	MRKCHR,Y
		STA	>VRAMD+2,X		; charcter No. set
;
;
		LDA	>VRAMD
		SEC
		SBC	#002H
		TAX
;
		LDA	MRKCHR1,Y
		STA	>VRAMD+2,X		; charcter No. set
;
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		PLX
;
		RTS
;
;################################################################################
;#		a_ta_i hyo_u_ji bg out (result)					#
;################################################################################
ATIDAT		EQU	$
		HEX	F8,39,01,00
		WORD	02CFCH
;
		HEX	18,3A,01,00
		WORD	02CFCH
;
		WORD	0FFFFH
ATIDTE		EQU	$
;
;################################################################################
;#		a_ta_i hyo_u_ji bg out (result)					#
;################################################################################
ATAIDSP		EQU	$
;
		PHX
;
		STZ	<WORK3
;
		LDY	!PWORK1			; right roolet stop data index
		LDA	RMARKDT,Y
		ASL	A
		STA	<WORK2
;
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	>VRAMD
		CLC
		ADC	#(ATIDTE-ATIDAT)-1
		TAX				; vramd address set
		DEC	A
		STA	>VRAMD
		LDY	#(ATIDTE-ATIDAT)-1
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
ATDS010		EQU	$
		LDA	ATIDAT,Y
		STA	>VRAMD+2,X		; hi low ko_su_u data set
		DEX
		DEY
		BPL	ATDS010			; base data set end ?
;						; yes
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	>VRAMD
		SEC
		SBC	#008H
		TAX
;
		LDY	<WORK2
		LDA	NUMBERHIGH,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2,X		; charcter No. set
;
;
		LDA	>VRAMD
		SEC
		SBC	#002H
		TAX
;
		LDA	NUMBERLOW,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2,X		; charcter No. set
;
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		PLX
;
		RTS
;
;################################################################################
;#		ke_kka hyo_u_ji bg out	(result)				#
;################################################################################
KEKADAT		EQU	$
		HEX	35,3A,09,00
		WORD	02CFCH,02CFCH,02CFCH,03E9CH,03E9DH
;
		HEX	55,3A,09,00
		WORD	02CFCH,02CFCH,02CFCH,03E9EH,03E9FH
;
		WORD	0FFFFH
KEKADTE		EQU	$
;
;
;################################################################################
;#		game total player hyo_u_ji bg out				#
;################################################################################
KEKADSP		EQU	$
		JSR	RSLSUB			; ke_kka comp sub
;
		LDA	!TOTLCNT
		STA	<WORKE
		LDA	!TOTLCNT+1
		STA	<WORKF
		JSR	DSPCHGSB		; DSPOT1,DSPOT10,DSPOT100 ram set sub
;
		STZ	<WORK1
		STZ	<WORK3
		STZ	<WORK5
;
		LDA	!DSPOT1
		ASL	A
		STA	<WORK4
		LDA	!DSPOT10
		ASL	A
		STA	<WORK2
		LDA	!DSPOT100
		ASL	A
		STA	<WORK0
;
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	>VRAMD
		CLC
		ADC	#(KEKADTE-KEKADAT)-1
		TAX				; vramd address set
		DEC	A
		STA	>VRAMD
		LDY	#(KEKADTE-KEKADAT)-1
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
KADS010		EQU	$
		LDA	KEKADAT,Y
		STA	>VRAMD+2,X		; hi low ko_su_u data set
		DEX
		DEY
		BPL	KADS010			; base data set end ?
;						; yes
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	>VRAMD
		SEC
		SBC	#018H
		TAX
;
		LDY	<WORK0
		BEQ	KADS020			; 100 no ke_ta 0 ?
;						; no
		LDA	NUMBERHIGH,Y		; 100 no ke_ta (up)
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2,X		; charcter No. set
;
KADS020		EQU	$
;
		LDY	<WORK2
		BNE	KADS025			; 10 no ke_ta 0 ?
;						; yes
		LDA	<WORK0
		BEQ	KADS030			; 100 no ke_ta 0 ?
;						; no
KADS025		EQU	$
		LDA	NUMBERHIGH,Y		; 10 no ke_ta (up)
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+4,X		; charcter No. set
;
KADS030		EQU	$
;
		LDY	<WORK4
		LDA	NUMBERHIGH,Y		; 1 no ke_ta (up)
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2+4,X		; charcter No. set
;
;
		LDA	>VRAMD
		SEC
		SBC	#00AH
		TAX
;
		LDY	<WORK0
		BEQ	KADS040			; 100 no ke_ta 0 ?
;						; no
		LDA	NUMBERLOW,Y		; 100 no ke_ta (down)
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2,X		; charcter No. set
;
KADS040		EQU	$
;
		LDY	<WORK2
		BNE	KADS045			; 10 no ke_ta 0 ?
;						; yes
		LDA	<WORK0
		BEQ	KADS050			; 100 no ke_ta 0 ?
;						; no
KADS045		EQU	$
		LDA	NUMBERLOW,Y		; 10 no ke_ta (down)
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2+2,X		; charcter No. set
;
KADS050		EQU	$
;
		LDY	<WORK4
		LDA	NUMBERLOW,Y		; 1 no ke_ta (down)
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2+4,X		; charcter No. set
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		RTS
;
;;;;################################################################################
;;;;#	result bg clear data							#
;;;;################################################################################
;;;BGCLDAT		EQU	$
;;;;;;		HEX	39,D4,00,0C
;;;;;;;		HEX	D4,39,0B,00
;;;;;;;		WORD	0207DH,0207DH,0207DH,0207DH,0207DH,0207DH
;;;;;;;;
;;;;;;		HEX	39,F4,00,0C
;;;;;;;		HEX	F4,39,0B,00
;;;;;;;		WORD	0207DH,0207DH,0207DH,0207DH,0207DH,0207DH
;;;;;;;;
;;;;;;		HEX	3A,15,00,0A
;;;;;;;		HEX	15,3A,09,00
;;;;;;;		WORD	0207DH,0207DH,0207DH,0207DH,0207DH
;;;;;;;;
;;;;;;		HEX	3A,35,00,0A
;;;;;;;		HEX	35,3A,09,00
;;;;;;;		WORD	0207DH,0207DH,0207DH,0207DH,0207DH
;;;;
;;;;
;;;;
;;;;;;		HEX	3A,15,00,0A
;;;		HEX	14,3A,0B,00
;;;		WORD	02CFCH,02CFCH,02CFCH,02CFCH,02CFCH,02CFCH
;;;;
;;;;;;		HEX	3A,35,00,0A
;;;		HEX	34,3A,0B,00
;;;		WORD	02CFCH,02CFCH,02CFCH,02CFCH,02CFCH,02CFCH
;;;;
;;;		WORD	0FFFFH
;;;BGCLDTE		EQU	$
;;;;
;;;;
;;;;################################################################################
;;;;#		result bg clear							#
;;;;################################################################################
;;;RESLCLR		EQU	$
;;;;
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B		; memory,index 16bit mode
;;;;
;;;		LDA	>VRAMD
;;;		CLC
;;;		ADC	#(BGCLDTE-BGCLDAT)-1
;;;		TAX				; vramd address set
;;;		DEC	A
;;;		STA	>VRAMD
;;;		LDY	#(BGCLDTE-BGCLDAT)-1
;;;;
;;;		MEM8
;;;		SEP	#00100000B		; memory 8bit mode
;;;;
;;;RSCL010		EQU	$
;;;		LDA	BGCLDAT,Y
;;;		STA	>VRAMD+2,X
;;;		DEX
;;;		DEY
;;;		BPL	RSCL010
;;;;
;;;		IDX8
;;;		SEP	#00010000B		; index 8bit mode
;;;;
;;;		RTS
;;;;
;################################################################################
;#		result sub data							#
;################################################################################
LMARKDT		EQU	$
;;;		HEX	01,00,01,00,00,01,00,01,00	; (00:+,01:*)
;;;		HEX	01,00,00,01,00
;
		HEX	01,00,00,01,00,01,00,01,00,00,01,00,01,00	; (00:+,01:*)
RMARKDT		EQU	$
;;;		HEX	02,00,01,02,01,03,00,01,00	; (00,01,02,03)
;;;		HEX	02,01,00,01,00
;;;		HEX	03,00,01,00	; (00,01,02,03)
;;;		HEX	02,01,00,01,00,02,00,01,02,01
		HEX	03,00,01,00	; (00,01,02,03)
		HEX	02,00,01,00,02,00,01,00,01,00
;################################################################################
;#		result sub							#
;################################################################################
RSLSUB		EQU	$
		LDX	!PWORK0
		LDA	LMARKDT,X
		JSL	>JSRSUB
;
;
RSMD0		WORD	KASAN		; 0 : ka_sa_n
RSMD1		WORD	JYOZAN		; 1 : jyo_za_n
;
;
KASN		EQU	(RSMD0-RSMD0)/2
JYZN		EQU	(RSMD1-RSMD0)/2
;
;
;################################################################################
;#		ka_sa_n sub							#
;################################################################################
KASAN		EQU	$
		STZ	!TOTLCNT+1	; HI clear
		LDY	!PWORK1
		LDA	!BETCNT
		CLC
		ADC	RMARKDT,Y	; bet + a_ta_i
		STA	!TOTLCNT
		RTS
;################################################################################
;#		jyo_za_n sub							#
;################################################################################
JYOZAN		EQU	$
		STZ	<WORK0
		STZ	<WORK1
		LDY	!PWORK1
		LDX	RMARKDT,Y
		BEQ	JZN050		; a_ta_i 0 ?
;					; no
		LDA	!BETCNT
JZN010		EQU	$
		DEX
		BEQ	JZN030		; dec end ?
;					; no
		CLC
		ADC	!BETCNT
		BCC	JZN020		; carry set ?
;					; yes
		INC	<WORK1
JZN020		EQU	$
		BRA	JZN010
;
JZN030		EQU	$
		STA	<WORK0
JZN050		EQU	$
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	<WORK0
		STA	!TOTLCNT	; ke_kka ram set
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		RTS
;
;
;################################################################################
;#		bet sub data							#
;################################################################################
BETDT0		EQU	$
		BYTE	0FFH,001H
;################################################################################
;#		bet sub								#
;################################################################################
BETSUB		EQU	$
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#00063H
		STA	<WORK0			;  99 (POi) set
		INC	A
		STA	<WORK2			; 100 (POi) set
;
		LDA	!PLCNT
		CMP	#00063H
		BCS	BET010			; 99 ȉ ?
;						; yes
		STA	<WORK0
		INC	A
		STA	<WORK2
BET010		EQU	$
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	<WORKF
		LSR	A
		LSR	A			; (00000010B up key ,00000001B down key)
		DEC	A
		TAX
		LDA	!BETCNT
		CLC
		ADC	BETDT0,X
		STA	!BETCNT			; bet data set
		CMP	<WORK2
		BNE	BET050			; min ?
;						; yes
		LDA	#001H
		STA	!BETCNT			; min bet set
		RTS
BET050		EQU	$
		CMP	#000H
		BNE	BETEND			; max ?
;						; yes
		LDA	<WORK0
		STA	!BETCNT
BETEND		EQU	$
		RTS
;
;################################################################################
;#		speed sub data							#
;################################################################################
ANDDT		EQU	$
		BYTE	00000001B
		BYTE	00000011B
;
ADDDT		EQU	$
		BYTE	001H,001H
CMPDT		EQU	$
		BYTE	00EH,00EH
INTDT		EQU	$
		BYTE	000H,000H
;
INTDT1		EQU	$
		BYTE	00DH,00DH
MINDT		EQU	$
		BYTE	008H,004H
;################################################################################
;#		speed sub							#
;################################################################################
SPDCMP0		EQU	$
		LDA	!DEMOFG
		BEQ	SPD010		; push key ? ( ?)
;					; yes
		LDA	!PWORK8,X
		BEQ	SPD008
;
		CMP	#01H
		BEQ	SPD012
;
		DEC	!PWORK8,X
		BRA	SPD020

SPD008		EQU	$
		LDA	<FRCNT
		AND	ANDDT,X
		BNE	SPD010		; dec flame ?
;
		DEC	!PWORK2,X	; base count -1
SPD010		EQU	$
		LDA	!PWORK2,X
		BEQ	SPD030
;
		CMP	MINDT,X		; min speed
		BNE	SPD020		; stop ?
;					; yes
		LDA	#50H
		STA	!PWORK8,X	; Srop revise time !
;
		BRA	SPD020
SPD012		EQU	$
		TXA
		INC	A
		ORA	!PWORKE
		STA	!PWORKE		; roolet stop flag set
		AND	#00000011B
		CMP	#00000011B
		BNE	SPD015		; all roolet move end ?
;					; yes
		LDA	#RESLT
		STA	!SLMODE		; result mode
		JSR	ATAIDSP		; a_ta_I display sub
		RTS
;
SPD015		EQU	$
		JSR	MARKDSP		; marker display sub
		RTS
SPD020		EQU	$
		LDA	!PWORK2,X
		CLC
		ADC	!PWORK4,X
		STA	!PWORK4,X
		BCC	SPDEND
;
SPD030		EQU	$
		TXY
		PHY
		LDA	#050H		;  TEhZbg ([bglnud)
		JSL	>SOUND_3_ON
		PLY
;NOM;		LDA	#023H
;NOM;		STA	<SOUND3		;  TEhZbg ([bglnud)
		LDA	!PWORK0,X
		CLC
		ADC	ADDDT,Y
		CMP	CMPDT,Y
		BNE	SPD040		; index end ?
;					; yes
		LDA	INTDT,Y		; end index set
SPD040		EQU	$
		STA	!PWORK0,X	; bg make index set
		DEC	A
		BPL	SPD050		; index end ?
;					; yes
		LDA	INTDT1,Y	; start index set
SPD050		EQU	$
		STA	!PWORK6,X	; bg recover index set
;
;
		LDA	#000H
		CPX	#000H
		BEQ	SPD055		; right roolet ?
;					; yes
		LDA	#010H
SPD055		EQU	$
		STA	<WORKF
		LDY	#000H
		LDA	!PWORK0,X
		STA	!PWORKF		; write index set
SPD060		EQU	$
		JSR	ROOLTST
		LDA	!PWORK6,X
		STA	!PWORKF		; write index set
		INY
		CPY	#002H
		BNE	SPD060
;
;
SPDEND		EQU	$
		RTS
;################################################################################
;#		bg data								#
;################################################################################
ROOADS00	EQU	$
;;;		HEX	3A,0D,00,04
;;;		HEX	2D,3A,03,00
		WORD	03A2DH,00003H
ROOADS01	EQU	$
;;;		HEX	3A,4C,00,04
;;;		HEX	6C,3A,03,00
		WORD	03A6CH,00003H
ROOADS02	EQU	$
;;;		HEX	3A,6A,00,04
;;;		HEX	8A,3A,03,00
		WORD	03A8AH,00003H
ROOADS03	EQU	$
;;;		HEX	3A,68,00,04
;;;		HEX	88,3A,03,00
		WORD	03A88H,00003H
ROOADS04	EQU	$
;;;		HEX	3A,66,00,04
;;;		HEX	86,3A,03,00
		WORD	03A86H,00003H
ROOADS05	EQU	$
;;;		HEX	3A,44,00,04
;;;		HEX	64,3A,03,00
		WORD	03A64H,00003H
ROOADS06	EQU	$
;;;		HEX	3A,03,00,04
;;;		HEX	23,3A,03,00
		WORD	03A23H,00003H
ROOADS07	EQU	$
;;;		HEX	39,C3,00,04
;;;		HEX	E3,39,03,00
		WORD	039E3H,00003H
ROOADS08	EQU	$
;;;		HEX	39,84,00,04
;;;		HEX	A4,39,03,00
		WORD	039A4H,00003H
ROOADS09	EQU	$
;;;		HEX	39,66,00,04
;;;		HEX	86,39,03,00
		WORD	03986H,00003H
ROOADS0A	EQU	$
;;;		HEX	39,68,00,04
;;;		HEX	88,39,03,00
		WORD	03988H,00003H
ROOADS0B	EQU	$
;;;		HEX	39,6A,00,04
;;;		HEX	8A,39,03,00
		WORD	0398AH,00003H
ROOADS0C	EQU	$
;;;		HEX	39,8C,00,04
;;;		HEX	AC,39,03,00
		WORD	039ACH,00003H
ROOADS0D	EQU	$
;;;		HEX	39,CD,00,04
;;;		HEX	ED,39,03,00
		WORD	039EDH,00003H
;
ROOADS10	EQU	$
;;;		HEX	3A,11,00,04
;;;		HEX	31,3A,03,00
		WORD	03A31H,00003H
ROOADS11	EQU	$
;;;		HEX	39,D1,00,04
;;;		HEX	F1,39,03,00
		WORD	039F1H,00003H
ROOADS12	EQU	$
;;;		HEX	39,92,00,04
;;;		HEX	B2,39,03,00
		WORD	039B2H,00003H
ROOADS13	EQU	$
;;;		HEX	39,74,00,04
;;;		HEX	94,39,03,00
		WORD	03994H,00003H
ROOADS14	EQU	$
;;;		HEX	39,76,00,04
;;;		HEX	96,39,03,00
		WORD	03996H,00003H
ROOADS15	EQU	$
;;;		HEX	39,78,00,04
;;;		HEX	98,39,03,00
		WORD	03998H,00003H
ROOADS16	EQU	$
;;;		HEX	39,9A,00,04
;;;		HEX	BA,39,03,00
		WORD	039BAH,00003H
ROOADS17	EQU	$
;;;		HEX	39,DB,00,04
;;;		HEX	FB,39,03,00
		WORD	039FBH,00003H
ROOADS18	EQU	$
;;;		HEX	3A,1B,00,04
;;;		HEX	3B,3A,03,00
		WORD	03A3BH,00003H
ROOADS19	EQU	$
;;;		HEX	3A,5A,00,04
;;;		HEX	7A,3A,03,00
		WORD	03A7AH,00003H
ROOADS1A	EQU	$
;;;		HEX	3A,78,00,04
;;;		HEX	98,3A,03,00
		WORD	03A98H,00003H
ROOADS1B	EQU	$
;;;		HEX	3A,76,00,04
;;;		HEX	96,3A,03,00
		WORD	03A96H,00003H
ROOADS1C	EQU	$
;;;		HEX	3A,74,00,04
;;;		HEX	94,3A,03,00
		WORD	03A94H,00003H
ROOADS1D	EQU	$
;;;		HEX	3A,52,00,04
;;;		HEX	72,3A,03,00
		WORD	03A72H,00003H
;
;
ROOCHR100	EQU	$
		WORD	02283H,06283H
ROOCHR101	EQU	$
		WORD	06288H,02288H
ROOCHR102	EQU	$
		WORD	0A285H,0E285H
ROOCHR103	EQU	$
		WORD	0E28AH,0A28AH
ROOCHR104	EQU	$
		WORD	06288H,02288H
ROOCHR105	EQU	$
		WORD	02283H,06283H
ROOCHR106	EQU	$
		WORD	0A289H,0E289H
ROOCHR107	EQU	$
		WORD	06284H,02284H
ROOCHR108	EQU	$
		WORD	0E28AH,0A28AH
ROOCHR109	EQU	$
		WORD	0A285H,0E285H
ROOCHR10A	EQU	$
		WORD	02287H,06287H
ROOCHR10B	EQU	$
		WORD	06288H,02288H
ROOCHR10C	EQU	$
		WORD	0E286H,0A286H
ROOCHR10D	EQU	$
		WORD	0A289H,0E289H
;
ROOCHR110	EQU	$
		WORD	0228BH,0628BH	;0
ROOCHR111	EQU	$
		WORD	0228CH,0228DH	;1
ROOCHR112	EQU	$
		WORD	0228BH,0628BH	;0
ROOCHR113	EQU	$
		WORD	0228CH,0228DH	;1
ROOCHR114	EQU	$
		WORD	0228BH,0628BH	;0
ROOCHR115	EQU	$
		WORD	02291H,02292H	;3
ROOCHR116	EQU	$
		WORD	0228BH,0628BH	;0
ROOCHR117	EQU	$
		WORD	0228CH,0228DH	;1
ROOCHR118	EQU	$
		WORD	0228BH,0628BH	;0
ROOCHR119	EQU	$
		WORD	0228EH,0228FH	;2
ROOCHR11A	EQU	$
		WORD	0228BH,0628BH	;0
ROOCHR11B	EQU	$
		WORD	0228CH,0228DH	;1
ROOCHR11C	EQU	$
		WORD	0228BH,0628BH	;0
ROOCHR11D	EQU	$
		WORD	0228EH,0228FH	;2
;
;;		WORD	0228BH,0628BH	;0
;;		WORD	0228CH,0228DH	;1
;;		WORD	0228EH,0228FH	;2
;;		WORD	02291H,02292H	;3
;
;
;
;
ROOCHR200	EQU	$
		WORD	0A283H,0E283H
ROOCHR201	EQU	$
		WORD	0E288H,0A288H
ROOCHR202	EQU	$
		WORD	02285H,06285H
ROOCHR203	EQU	$
		WORD	0628AH,0228AH
ROOCHR204	EQU	$
		WORD	0E288H,0A288H
ROOCHR205	EQU	$
		WORD	0A283H,0E283H
ROOCHR206	EQU	$
		WORD	02289H,06289H
ROOCHR207	EQU	$
		WORD	0E284H,0A284H
ROOCHR208	EQU	$
		WORD	0628AH,0228AH
ROOCHR209	EQU	$
		WORD	02285H,06285H
ROOCHR20A	EQU	$
		WORD	0A287H,0E287H
ROOCHR20B	EQU	$
		WORD	0E288H,0A288H
ROOCHR20C	EQU	$
		WORD	06286H,02286H
ROOCHR20D	EQU	$
		WORD	02289H,06289H
;
ROOCHR210	EQU	$
		WORD	0A28BH,0E28BH	;0
ROOCHR211	EQU	$
		WORD	0E28DH,0A28DH	;1
ROOCHR212	EQU	$
		WORD	0A28BH,0E28BH	;0
ROOCHR213	EQU	$
		WORD	0E28DH,0A28DH	;1
ROOCHR214	EQU	$
		WORD	0A28BH,0E28BH	;0
ROOCHR215	EQU	$
		WORD	0A291H,02293H	;3
ROOCHR216	EQU	$
		WORD	0A28BH,0E28BH	;0
ROOCHR217	EQU	$
		WORD	0E28DH,0A28DH	;1
ROOCHR218	EQU	$
		WORD	0A28BH,0E28BH	;0
ROOCHR219	EQU	$
		WORD	02290H,0E28EH	;2
ROOCHR21A	EQU	$
		WORD	0A28BH,0E28BH	;0
ROOCHR21B	EQU	$
		WORD	0E28DH,0A28DH	;1
ROOCHR21C	EQU	$
		WORD	0A28BH,0E28BH	;0
ROOCHR21D	EQU	$
		WORD	02290H,0E28EH	;2
;
;;		WORD	0A28BH,0E28BH	;0
;;		WORD	0E28DH,0A28DH	;1
;;		WORD	02290H,0E28EH	;2
;;		WORD	0A291H,02293H	;3
;
;
;
;
ROOIDX		EQU	$
		WORD	ROOADS09		; 09
		WORD	ROOADS0A		; 0A
		WORD	ROOADS0B		; 0B
		WORD	ROOADS0C		; 0C
		WORD	ROOADS0D		; 0D
		WORD	ROOADS00		; 00
		WORD	ROOADS01		; 01
		WORD	ROOADS02		; 02
		WORD	ROOADS03		; 03
		WORD	ROOADS04		; 04
		WORD	ROOADS05		; 05
		WORD	ROOADS06		; 06
		WORD	ROOADS07		; 07
		WORD	ROOADS08		; 08
		WORD	ROOADS00		; 0E	;dammy
		WORD	ROOADS00		; 0F	;dammy
		WORD	ROOADS15		; 15
		WORD	ROOADS16		; 16
		WORD	ROOADS17		; 17
		WORD	ROOADS18		; 18
		WORD	ROOADS19		; 19
		WORD	ROOADS1A		; 1A
		WORD	ROOADS1B		; 1B
		WORD	ROOADS1C		; 1C
		WORD	ROOADS1D		; 1D
		WORD	ROOADS10		; 10
		WORD	ROOADS11		; 11
		WORD	ROOADS12		; 12
		WORD	ROOADS13		; 13
		WORD	ROOADS14		; 14
;
ROOIDX1		EQU	$
		WORD	ROOCHR109		; 09
		WORD	ROOCHR10A		; 0A
		WORD	ROOCHR10B		; 0B
		WORD	ROOCHR10C		; 0C
		WORD	ROOCHR10D		; 0D
		WORD	ROOCHR100		; 00
		WORD	ROOCHR101		; 01
		WORD	ROOCHR102		; 02
		WORD	ROOCHR103		; 03
		WORD	ROOCHR104		; 04
		WORD	ROOCHR105		; 05
		WORD	ROOCHR106		; 06
		WORD	ROOCHR107		; 07
		WORD	ROOCHR108		; 08
		WORD	ROOCHR100		; 0E	;dammy
		WORD	ROOCHR100		; 0F	;dammy
		WORD	ROOCHR115		; 15
		WORD	ROOCHR116		; 16
		WORD	ROOCHR117		; 17
		WORD	ROOCHR118		; 18
		WORD	ROOCHR119		; 19
		WORD	ROOCHR11A		; 1A
		WORD	ROOCHR11B		; 1B
		WORD	ROOCHR11C		; 1C
		WORD	ROOCHR11D		; 1D
		WORD	ROOCHR110		; 10
		WORD	ROOCHR111		; 11
		WORD	ROOCHR112		; 12
		WORD	ROOCHR113		; 13
		WORD	ROOCHR114		; 14
;
ROOIDX2		EQU	$
		WORD	ROOCHR209		; 09
		WORD	ROOCHR20A		; 0A
		WORD	ROOCHR20B		; 0B
		WORD	ROOCHR20C		; 0C
		WORD	ROOCHR20D		; 0D
		WORD	ROOCHR200		; 00
		WORD	ROOCHR201		; 01
		WORD	ROOCHR202		; 02
		WORD	ROOCHR203		; 03
		WORD	ROOCHR204		; 04
		WORD	ROOCHR205		; 05
		WORD	ROOCHR206		; 06
		WORD	ROOCHR207		; 07
		WORD	ROOCHR208		; 08
		WORD	ROOCHR200		; 0E	;dammy
		WORD	ROOCHR200		; 0F	;dammy
		WORD	ROOCHR215		; 15
		WORD	ROOCHR216		; 16
		WORD	ROOCHR217		; 17
		WORD	ROOCHR218		; 18
		WORD	ROOCHR219		; 19
		WORD	ROOCHR21A		; 1A
		WORD	ROOCHR21B		; 1B
		WORD	ROOCHR21C		; 1C
		WORD	ROOCHR21D		; 1D
		WORD	ROOCHR210		; 10
		WORD	ROOCHR211		; 11
		WORD	ROOCHR212		; 12
		WORD	ROOCHR213		; 13
		WORD	ROOCHR214		; 14
;
ROORDT		EQU	$
;			 white	guray
		WORD	00800H,01C00H
;
;
;################################################################################
;#		roolet display out	(Y <- 0:now index  1:back index)	#
;################################################################################
ROOLTST		EQU	$
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		PHX
		PHY
;
		TYA
		AND	#00001H
		ASL	A
		TAY
		LDA	ROORDT,Y
		STA	<WORK6			; BG color 'or' data set
;
		LDA	!PWORKF			; now index load
		AND	#00FFH
		ORA	<WORKF			; left roolet:00H right roolet:10H
		ASL	A
		TAX
		LDA	ROOIDX,X
		STA	<WORK0			; hi low data index set
		LDA	ROOIDX1,X
		STA	<WORK2			; charcter up data index set
		LDA	ROOIDX2,X
		STA	<WORK4			; charcter down data index set
;
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDA	>VRAMD
		TAX				; vramd address set
		LDY	#00000H
;
SJD010		EQU	$
		LDA	(<WORK0),Y
		STA	>VRAMD+2,X		; hi low ko_su_u data set
		CPY	#00000H
		BNE	SJD020
;
		CLC
		ADC	#00020H			; next low data set
SJD020		EQU	$
		STA	>VRAMD+2+8,X		; hi low ko_su_u data set
		INX
		INX
		INY
		INY
		CPY	#00004H
		BNE	SJD010			; vramd set end ?
;						; yes
		LDY	#00000H
SJD030		EQU	$
		LDA	(<WORK2),Y
		ORA	<WORK6
		STA	>VRAMD+2,X		; up charcter No. set
;
		LDA	(<WORK4),Y
		ORA	<WORK6
		STA	>VRAMD+2+8,X		; down charcter No. set
;
		INX
		INX
		INY
		INY
		CPY	#00004H
		BNE	SJD030			; vramd set end ?
;						; yes
		INX
		INX
		LDA	#0FFFFH
		STA	>VRAMD+2+6,X		; end code set
		TXA
		CLC
		ADC	#006H
		STA	>VRAMD			; vramd next index set
;
		MEM8
		IDX8
		SEP	#00110000B		;memory,index 8bit mode
;
SJDEND		EQU	$
;
		PLY
		PLX
;
		RTS
;
;################################################################################
;#		roolet flassing sub						#
;################################################################################
RLTFSSB		EQU	$
		LDA	!PWORKE
		BEQ	RFSEND		; stop flag on ?
;					; yes
		LDX	#001H
		AND	#00000010B
		BNE	RFS010		; left and right roolet stop ?
;					; no
		LDX	#000H
RFS010		EQU	$
		LDA	#000H
		CPX	#000H
		BEQ	RFS020		; loop (left roolet) ?
;					; no
		LDA	#010H
RFS020		EQU	$
		STA	<WORKF
;
		LDY	#000H		; white color index
		LDA	!BONSMD
		CMP	#BS4MP
		BEQ	RFS030		; map mode back ?
;					; no
		LDA	<FRCNT
		AND	#00000001B
		BNE	RFS030		; 2 flame again ?
;					; yes
		INY			; normal color index
RFS030		EQU	$
		LDA	!PWORK0,X
		STA	!PWORKF
		JSR	ROOLTST		; roolet corsol set
		DEX
		BPL	RFS010		; all flassing set ok ?
;					; yes
RFSEND		EQU	$
		RTS
;;;;################################################################################
;;;;#		game total player hyo_u_ji bg data					#
;;;;################################################################################
;;;TOTLDAT		EQU	$
;;;;;;		HEX	38,5B,00,06
;;;		HEX	5B,38,05,00
;;;		WORD	020FEH,020FEH,020FEH
;;;;
;;;;;;		HEX	38,7B,00,06
;;;		HEX	7B,38,05,00
;;;		WORD	020FEH,020FEH,020FEH
;;;;
;;;		WORD	0FFFFH
;;;TOTLDTE		EQU	$
;;;;
;;;;
;;;;################################################################################
;;;;#		game total player hyo_u_ji bg out				#
;;;;################################################################################
;;;PLTLDSP		EQU	$
;;;		LDA	!PLCNT
;;;		STA	<WORKE
;;;		LDA	!PLCNT+1
;;;		STA	<WORKF
;;;		JSR	DSPCHGSB
;;;;
;;;		STZ	<WORK1
;;;		STZ	<WORK3
;;;		STZ	<WORK5
;;;;
;;;		LDA	!DSPOT1
;;;		ASL	A
;;;		ASL	A
;;;		STA	<WORK4
;;;		LDA	!DSPOT10
;;;		ASL	A
;;;		ASL	A
;;;		STA	<WORK2
;;;		LDA	!DSPOT100
;;;		ASL	A
;;;		ASL	A
;;;		STA	<WORK0
;;;;
;;;;
;;;		MEM16
;;;		IDX16
;;;		REP	#00110000B		; memory,index 16bit mode
;;;;
;;;		LDA	>VRAMD
;;;		CLC
;;;		ADC	#(TOTLDTE-TOTLDAT)-1
;;;		TAX				; vramd address set
;;;		DEC	A
;;;		STA	>VRAMD
;;;		LDY	#(TOTLDTE-TOTLDAT)-1
;;;;
;;;		MEM8
;;;		SEP	#00100000B		; memory 8bit mode
;;;;
;;;PTD200		EQU	$
;;;		LDA	TOTLDAT,Y
;;;		STA	>VRAMD+2,X		; hi low ko_su_u data set
;;;		DEX
;;;		DEY
;;;		BPL	PTD200
;;;;
;;;		MEM16
;;;		REP	#00100000B		; memory 16bit mode
;;;;
;;;		LDA	>VRAMD
;;;		SEC
;;;		SBC	#010H
;;;		TAX
;;;;
;;;		LDY	<WORK0
;;;		LDA	SUUJID0,Y
;;;		ORA	#01C00H			; white color atribute set
;;;		STA	>VRAMD+2,X		; charcter No. set
;;;;
;;;		LDY	<WORK2
;;;		LDA	SUUJID0,Y
;;;		ORA	#01C00H			; white color atribute set
;;;		STA	>VRAMD+2+2,X		; charcter No. set
;;;;
;;;		LDY	<WORK4
;;;		LDA	SUUJID0,Y
;;;		ORA	#01C00H			; white color atribute set
;;;		STA	>VRAMD+2+4,X		; charcter No. set
;;;;
;;;;
;;;		LDA	>VRAMD
;;;		SEC
;;;		SBC	#006H
;;;		TAX
;;;;
;;;		LDY	<WORK0
;;;		INY
;;;		INY
;;;		LDA	SUUJID0,Y
;;;		ORA	#01C00H			; white color atribute set
;;;		STA	>VRAMD+2,X		; charcter No. set
;;;;
;;;		LDY	<WORK2
;;;		INY
;;;		INY
;;;		LDA	SUUJID0,Y
;;;		ORA	#01C00H			; white color atribute set
;;;		STA	>VRAMD+2+2,X		; charcter No. set
;;;;
;;;		LDY	<WORK4
;;;		INY
;;;		INY
;;;		LDA	SUUJID0,Y
;;;		ORA	#01C00H			; white color atribute set
;;;		STA	>VRAMD+2+4,X		; charcter No. set
;;;;
;;;		MEM8
;;;		IDX8
;;;		SEP	#00110000B		; memory,index 8bit mode
;;;;
;;;		RTS
;;;;
;################################################################################
;#		bet player hyo_u_ji bg data					#
;################################################################################
BETDAT		EQU	$
;;;		HEX	39,EA,00,04
;;;		HEX	EA,39,03,00
		HEX	09,3A,03,00
		WORD	02CFCH,02CFCH
;
;;;		HEX	3A,0A,00,04
;;;		HEX	0A,3A,03,00
		HEX	29,3A,03,00
		WORD	02CFCH,02CFCH
;
		WORD	0FFFFH
BETDTE		EQU	$
;
;################################################################################
;#		bet player hyo_u_ji bg out				#
;################################################################################
BETDSP		EQU	$
		LDA	!BETCNT
		STA	<WORKE
		STZ	<WORKF
		JSR	DSPCHGSB		; DSPOT1,DSPOT10,DSPOT100 ram set sub
;
		STZ	<WORK3
		STZ	<WORK5
;
		LDA	!DSPOT1
		ASL	A
		STA	<WORK4
		LDA	!DSPOT10
		ASL	A
		STA	<WORK2
;
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDA	>VRAMD
		CLC
		ADC	#(BETDTE-BETDAT)-1
		TAX				; vramd address set
		DEC	A
		STA	>VRAMD
		LDY	#(BETDTE-BETDAT)-1
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
BDS200		EQU	$
		LDA	BETDAT,Y
		STA	>VRAMD+2,X		; hi low ko_su_u data set
		DEX
		DEY
		BPL	BDS200
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	>VRAMD
		SEC
		SBC	#00CH
		TAX
;
		LDA	<WORK2
		BEQ	BDS210
;
		LDY	<WORK2
		LDA	NUMBERHIGH,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2,X		; charcter No. set
;
BDS210		EQU	$
		LDY	<WORK4
		LDA	NUMBERHIGH,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2+2,X		; charcter No. set
;
;
;
		LDA	>VRAMD
		SEC
		SBC	#004H
		TAX
;
		LDA	<WORK2
		BEQ	BDS220
;
		LDY	<WORK2
		LDA	NUMBERLOW,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2,X		; charcter No. set
;
BDS220		EQU	$
		LDY	<WORK4
		LDA	NUMBERLOW,Y
		ORA	#00C00H			; white color atribute set
		STA	>VRAMD+2+2,X		; charcter No. set
;
;
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		RTS
;
;################################################################################
;#		display out data ram chenge sub					#
;################################################################################
DSPCHGSB	EQU	$
		STZ	!DSPOT100
		STZ	!DSPOT10
		STZ	!DSPOT1
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	<WORKE
		CMP	#00100H
		BCC	DCS170			; HI ke_ta ?
;						; yes
		STZ	<WORK0			; data save ram clear
DCS140		EQU	$
		CMP	#00064H
		BCC	DCS150			; 100 i_jyo ?
;						; yes
		INC	<WORK0			; 100 no ke_ta set
		SEC
		SBC	#00064H			; (A)-100
		BRA	DCS140
DCS150		EQU	$
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDX	<WORK0
		STX	!DSPOT100		; 100 no ke_ta set
;
DCS170		EQU	$
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		CMP	#064H
		BCC	DCS180			; 100 i_jyo ?
;						; yes
		INC	!DSPOT100		; 100 no ke_ta set
		SEC
		SBC	#064H			; (A)-100
		BRA	DCS170
DCS180		EQU	$
		CMP	#00AH
		BCC	DCS190			; 10 i_jyo ?
;						; yes
		INC	!DSPOT10		; 10 no ke_ta set
		SEC
		SBC	#00AH			; (A)-10
		BRA	DCS180
DCS190		EQU	$
		STA	!DSPOT1			; 1 no ke_ta set
;
		RTS
;
;
		MEM16
		IDX16
;
;
;
;
;============== vnqkc@T ==========================================
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SINKMOV ( WORLD 5 ꂩ move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SINKMOV		EQU	$
		LDA	BONSMD
		ASL	A
		TAX
		JMP	(!SINKADR,X)
;
;
SINKADR		EQU	$
		WORD	TIMEDEC		; 0 timer dec. set sub !!
		WORD	WINDOPN		; 1 window open sub !!
		WORD	TIMDEC0		; 2 timer dec. set sub !!
		WORD	MSWINOP		; 3 messege window open sub !!
		WORD	WINCLSB		; 4 window color sub !!
		WORD	SCRDOWN		; 5 screen down move sub !!
		WORD	SCRYURE		; 6 screen yure sub !!
		WORD	TIMDEC2		; 7 timer dec. set sub !!
		WORD	ATEMON		; 8
		WORD	ATEMON2		; 9
AT3		WORD	ATEMON3		; A
		WORD	ATEMON4		; A
BS5MAP		WORD	MODEMAP		; B map initial mode set sub !!
;
;
BS5MP		EQU	(BS5MAP-SINKADR)/2
atemon3		EQU	(AT3-SINKADR)/2
;
;
;----------------------------------------------------------------
;-	ATEMON							-
;----------------------------------------------------------------
item00		EQU	0136H
item01		EQU	item00+9
item02		EQU	item01+9
item03		EQU	item02+9
item04		EQU	item03+9
item05		EQU	item04+9
item06		EQU	item05+9
item07		EQU	item06+9
item08		EQU	item07+9
item09		EQU	item08+9
item10		EQU	item09+9
item11		EQU	item10+9
item12		EQU	0180H
item13		EQU	item12+9
item14		EQU	item13+9
item15		EQU	item14+9
;
ate_csl		EQU	03160H
shutterchr	EQU	053A420H
a_lastcnt	EQU	080H
soundplayerdown EQU	013H
atemon_0	EQU	00000H
atemon_1	EQU	atemon_0+90H
atemon_2	EQU	atemon_1+90H
atemon_3	EQU	atemon_2+90H
atemon_4	EQU	atemon_3+90H
atemon_5	EQU	atemon_4+90H
atemon_6	EQU	atemon_5+90H
atr0		EQU	00000H
atr1		EQU	00400H
atr2		EQU	00800H
atr3		EQU	00C00H
atr4		EQU	01000H
atr5		EQU	01400H
atr6		EQU	01800H
atr7		EQU	01C00H
zerohigh	EQU	000CFH
zerolow		EQU	080CFH
onehigh		EQU	000C7H
onelow		EQU	onehigh+10H
twohigh		EQU	000C8H
twolow		EQU	twohigh+10H
threehigh	EQU	000C9H
threelow	EQU	threehigh+10H
fourhigh	EQU	000CAH
fourlow		EQU	fourhigh+10H
fivehigh	EQU	000CBH
fivelow		EQU	fivehigh+10H
sixhigh		EQU	000CCH
sixlow		EQU	sixhigh+10H
sevenhigh	EQU	000CDH
sevenlow	EQU	sevenhigh+10H
eighthigh	EQU	000CEH
eightlow	EQU	000DCH
ninehigh	EQU	080DCH
ninelow		EQU	000DEH
multchrhigh	EQU	002CEH|atr3
multchrlow	EQU	082CEH|atr3
pluschrhigh	EQU	002CDH|atr3
pluschrlow	EQU	082CDH|atr3
minuschrhigh	EQU	002CFH|atr2
minuschrlow	EQU	082CFH|atr2
spacechr	EQU	0FCH|atr2
;
ATEMONCHRAD	EQU	$
		WORD	atemon_0, atemon_1, atemon_2, atemon_3, atemon_4, atemon_5
;
ACSLXPOS	EQU	$
		HEX	50, 78, A0
		HEX	50, 78, A0
;
ACSLYPOS	EQU	$
		HEX	68, 68, 68
		HEX	90, 90, 90
;
ACSLYADD	EQU	$
		HEX	03, 03, 03, FD, FD, FD
;
ATEMONTABLE	EQU	$
		HEX	00, 01, 02, 03, 04, 05, 06, 07, 08
;
ATMNVRAD	EQU	$
		WORD	01AAH+bg2_adrs, 01AFH+bg2_adrs, 01B4H+bg2_adrs
		WORD	024AH+bg2_adrs, 024FH+bg2_adrs, 0254H+bg2_adrs
;
;
ATEMONINIT	EQU	$
;
		MI8				; memory, index 8bit mode !!
;
		LDA	#00
		STA	!GCSLNUM
		TAY
		LDA	ACSLXPOS,Y
		STA	!CRCXPS
		LDA	ACSLYPOS,Y
		STA	!CRCYPS
;
		LDX	#09-1
		TXY
ATMNINT0040	EQU	$
		TXA
		STA	<WORK,X
		DEX
		BPL	ATMNINT0040		; table number set end ? [no->ATMNINT0040]
;
		LDA	#LOW RANTBL
		STA	<WORK2D
		LDA	#HIGH RANTBL
		STA	<WORK2E
		JSR	RANDTBLSET		; table ram set !!
;
		LDX	#06-1
		TXY
ATMNINT0050	EQU	$
		TXA
		STA	<WORK,X
		DEX
		BPL	ATMNINT0050		; [->ATMNINT0050]
;
		LDA	#LOW GINTBLRM
		STA	<WORK2D
		LDA	#HIGH GINTBLRM
		STA	<WORK2E
		JSR	RANDTBLSET		; table ram set !!
;
		LDY	#03-1
		LDA	!GOAL_TTL_PT
		CMP	#50
		BCS	ATMNINT0060		; XRAH [no->ATMNINT0060]
;
		LDY	#00
ATMNINT0060	EQU	$
		LDA	#09
ATMNINT0068	EQU	$
		LDX	!GINTBLRM,Y
		STA	!RANTBL,X
		DEY
		BPL	ATMNINT0068		; ͂ZbgIH [no->ATMNINT0068]
;
		MI16				; memory, index 16bit mode !!
;
		LDA	#WORKBF
		STA	<WORK12
		LDA	#BANK WORKBF
		STA	<WORK14
		LDY	#00005H
ATMNINT0080	EQU	$
		TYA
		ASL	A
		TAX
		LDA	ATMNVRAD,X
		STA	<WORK10
		LDA	!RANTBL,Y
		AND	#000FFH
		ASL	A
		TAX
		PHY
		LDA	ITEMBGCHRNOAD,X
		JSR	ATMNBGWT
;
		PLY
		LDA	<WORK12
		CLC
		ADC	#9*2
		STA	<WORK12
		LDA	<WORK14
		ADC	#00000H
		STA	<WORK14
		DEY
		BPL	ATMNINT0080		;
;
		RTS
;
;
ITEMBGCHRNOAD	EQU	$
		WORD	ITEMBGCHRNO0
		WORD	ITEMBGCHRNO1
		WORD	ITEMBGCHRNO2
		WORD	ITEMBGCHRNO3
		WORD	ITEMBGCHRNO4
		WORD	ITEMBGCHRNO5
		WORD	ITEMBGCHRNO6
		WORD	ITEMBGCHRNO7
		WORD	ITEMBGCHRNO8
		WORD	ITEMBGCHRNO9
;
ITEMBGCHRNO0	EQU	$		;X^[PO
		WORD	(item04+0)|atr3, (item04+1)|atr3, (item04+2)|atr3
		WORD	(item04+3)|atr3, (item04+4)|atr3, (item04+5)|atr3
		WORD	(item04+6)|atr3, (item04+7)|atr3, (item04+8)|atr3
ITEMBGCHRNO1	EQU	$		;X^[QO
		WORD	(item13+0)|atr5, (item13+1)|atr5, (item13+2)|atr5
		WORD	(item13+3)|atr5, (item13+4)|atr5, (item13+5)|atr5
		WORD	(item13+6)|atr5, (item13+7)|atr5, (item13+8)|atr5
ITEMBGCHRNO2	EQU	$		;ł^}S
		WORD	(item03+0)|atr3, (item03+1)|atr3, (item03+2)|atr3
		WORD	(item03+3)|atr3, (item03+4)|atr3, (item03+5)|atr3
		WORD	(item03+6)|atr3, (item03+7)|atr3, (item03+8)|atr3
ITEMBGCHRNO3	EQU	$		;ǂłonv
		WORD	(item05+0)|atr5, (item05+1)|atr5, (item05+2)|atr5
		WORD	(item05+3)|atr5, (item05+4)|atr5, (item05+5)|atr5
		WORD	(item05+6)|atr5, (item05+7)|atr5, (item05+8)|atr5
ITEMBGCHRNO4	EQU	$		;G݂ȁH_
		WORD	(item01+0)|atr3, (item01+1)|atr3, (item01+2)|atr3
		WORD	(item01+3)|atr3, (item01+4)|atr3, (item01+5)|atr3
		WORD	(item01+6)|atr3, (item01+7)|atr3, (item01+8)|atr3
ITEMBGCHRNO5	EQU	$		;؂̎i΁j
		WORD	(item14+0)|atr4, (item14+1)|atr4, (item14+2)|atr4
		WORD	(item14+3)|atr4, (item14+4)|atr4, (item14+5)|atr4
		WORD	(item14+6)|atr4, (item14+7)|atr4, (item14+8)|atr4
ITEMBGCHRNO6	EQU	$		;؂̎iԁj
		WORD	(item15+0)|atr5, (item15+1)|atr5, (item15+2)|atr5
		WORD	(item15+3)|atr5, (item15+4)|atr5, (item15+5)|atr5
		WORD	(item15+6)|atr5, (item15+7)|atr5, (item15+8)|atr5
ITEMBGCHRNO7	EQU	$		;؂̎ij
		WORD	(item14+0)|atr3, (item14+1)|atr3, (item14+2)|atr3
		WORD	(item14+3)|atr3, (item14+4)|atr3, (item14+5)|atr3
		WORD	(item14+6)|atr3, (item14+7)|atr3, (item14+8)|atr3
ITEMBGCHRNO8	EQU	$		;閧̒ዾ
		WORD	(item06+0)|atr3, (item06+1)|atr3, (item06+2)|atr3
		WORD	(item06+3)|atr3, (item06+4)|atr3, (item06+5)|atr3
		WORD	(item06+6)|atr3, (item06+7)|atr3, (item06+8)|atr3
ITEMBGCHRNO9	EQU	$		;JbN
		WORD	(item07+0)|atr5, (item07+1)|atr5, (item07+2)|atr5
		WORD	(item07+3)|atr5, (item07+4)|atr5, (item07+5)|atr5
		WORD	(item07+6)|atr5, (item07+7)|atr5, (item07+8)|atr5
;
;
ATEMONITEM	EQU	$
		HEX	01, 02, 04, 03, 06, 07, 09, 08, 05
;
;
;----------------------------------------------------------------
;-	(A) <- char data address				-
;----------------------------------------------------------------
ATMNBGWT	EQU	$
		STA	<WORK16
		LDX	#09
		LDY	#00
ATMNBGWT0040	EQU	$
		LDA	(<WORK16),Y
		STA	[<WORK12],Y
		INY
		INY
		DEX
		BNE	ATMNBGWT0040		; LN^ZbgIH [no->ATMNBGWT0040]
;
;----------------------------------------------------------------
;-	WORK12, 13 <- work buffer address			-
;-	WORK14, 15 <-	"     "	  bank				-
;----------------------------------------------------------------
WKBFVRSET	EQU	$
		LDA	#03
		STA	<WORKE
		LDA	<WORK14
		STA	<WORK1
		LDY	<WORK10
		LDX	<WORK12
WKBFVRST40	EQU	$
		LDA	#3*2
		PHY
		PHX
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#3*2
		TAX
		PLA
		CLC
		ADC	#00020H
		TAY
		DEC	<WORKE
		BNE	WKBFVRST40		; set end ? [no->WKBFVRST40]
;
		RTS
;
;
ATEMON		EQU	$
		M8				; memory 8bit mode !!
;
		LDA	!KEYCOUNT
		BEQ	ATMN0010		; key counter zero ? [yes->ATMN0010]
;
		DEC	!KEYCOUNT
ATMN0010	EQU	$
		M16				; memory 16bit mode !!
;
		LDA	!CRCXPS
		AND	#000FFH
		CLC
		ADC	#00014H
		STA	<WORK0
		LDA	!CRCYPS
		AND	#000FFH
		CLC
		ADC	#00014H
		STA	<WORK2
		LDA	#ate_csl
		STA	<WORK4
		JSR	GINGAMICSLOAM		; cursol display !!
;
		LDA	!KEYA2L
		AND	#1100000010000000B
		BEQ	ATMN0080		; B,Y,A on ? [no->ATMN0080]
;
		LDA	#soundcslkettei
		JSL	>SOUND_3_ON		; TEh ZbgII
;
		LDY	#PMIR1
		STY	!BSPLTP
		LDA	PLTRNAR,Y
		JSR	PAS050
;
		MI8				; memory, index 8bit mode !!
;
		LDA	#018H
		STA	!KEYCOUNT
		INC	!BONSMD
;
		M16				; memory 16bit mode !!
;
		STZ	!GDEMOCNT
		I16				; index 16bit mode !!
		RTS
;
ATMN0080	EQU	$
A_CURSOLMV	EQU	$
		MI8				; memory, index 8bit mode !!
;
		LDA	!KEYA2
		AND	#00001111B
		BEQ	ACSLMV0040		; up or down or left or right key press ?
;						; [no->ACSLMV0040]
		LDY	#keycount0
		BRA	ACSLMV0050
;
ACSLMV0040	EQU	$
		LDY	!KEYCOUNT
		BNE	ACSLMV0100		; key check ? [no->ACSLMV0100]
;
		LDY	#keycount1
ACSLMV0050	EQU	$
		STY	!KEYCOUNT
		LDA	!KEYA1
		AND	#00001111B
		BNE	ACSLMV0080		; up or down or left or right key press ?
;						; [no->ACSLMV0080]
		BRA	ACSLMV0100
;
ACSLMV0080	EQU	$
		PHA
		AND	#00000011B
		TAY
		LDA	!GCSLNUM
		CLC
		ADC	GCSLXADD,Y
		BPL	ACSLMV0090		; area over ? [no->ACSLMV0090]
;
		LDA	#5
		BRA	ACSLMV00A0
;
ACSLMV0090	EQU	$
		CMP	#5+1
		BCC	ACSLMV00A0		; area over ? [no->ACSLMV00A0]
;
		LDA	#0
ACSLMV00A0	EQU	$
		STA	!GCSLNUM
		TAY
		PLA
		LSR	A
		LSR	A
		BIT	#00000011B
		BEQ	ACSLMV00D0		; down on ? [no->ACSLMV00D0]
;
		TYA
		CLC
		ADC	ACSLYADD,Y
		STA	!GCSLNUM
		TAY
ACSLMV00D0	EQU	$
		LDA	ACSLXPOS,Y
		STA	!CRCXPS
		LDA	ACSLYPOS,Y
		STA	!CRCYPS
		LDA	#soundcslmove
		JSL	>SOUND_3_ON		; TEh ZbgII
;
ACSLMV0100	EQU	$
		MI16				; memory, index 16bit mode !!
		RTS
;
;
ATEMON2		EQU	$
		M8				; memory 8bit mode !!
;
		LDA	!KEYCOUNT
		BNE	ATMN20010		; sound on ? [no->ATMN20010]
;
		LDA	#020H
		STA	!KEYCOUNT
		LDA	#soundhikkaki
		JSL	>SOUND_3_ON		; TEh ZbgII
;
		BRA	ATMN20020
;
ATMN20010	EQU	$
		DEC	!KEYCOUNT
ATMN20020	EQU	$
;
		M16				; memory 16bit mode !!
		I8				; index 8bit mode !!
;
		LDA	#BANK shutterchr
		STA	R0
		LDA	#shutterchr
		STA	R3
		LDA	!GDEMOCNT
		STA	R4
		LDA	#0
		STA	R5
		M_CHIP	SHUTTER
;
		I16				; index 16bit mode !!
;
		LDA	#BANK WOB7CHR
		STA	<WORK1
		LDA	!GCSLNUM
		AND	#000FFH
		ASL	A
		TAX
		LDY	ATEMONCHRAD,X
		LDX	#WOB7CHR
		LDA	#3
		STA	<WORKE
ATMN20040	EQU	$
		LDA	#00060H
		PHX
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#30H
		TAY
		PLA
		CLC
		ADC	#0200H
		TAX
		DEC	<WORKE
		BNE	ATMN20040		; vram set end ? [no->ATMN20040]
;
		MI8				; memory, index 8bit mode !!
;
		LDA	!GDEMOCNT
		CMP	#00CH
		BEQ	ATMN20080		; demo end ? [yes->ATMN20080]
;
		LDA	<FRCNT
		AND	#03
		BNE	ATMN20100		;
;
		INC	!GDEMOCNT
ATMN20100	EQU	$
		MI16				; memory, index 16bit mode !!
		RTS
;
ATMN20080	EQU	$
		MI16				; memory, index 16bit mode !!
;
		INC	!BONSMD
		LDA	!GCSLNUM
		AND	#000FFH
		TAY
		LDA	RANTBL,Y
		AND	#000FFH
		CMP	#0009
		BEQ	ATMN200C0		; oUCH [no->ATMN200C0]
;
		TAY
		LDA	ATEMONITEM,Y
		JSR	ITEMINPUT		; ACeo^II
;
		LDA	#00005H
		STA	!SOUND_0		; TEh ZbgIIit@t@[j
;
		LDY	#PYORO
		BRA	ATMN200D0		; [->ATMN200D0]
;
ATMN200C0	EQU	$
		LDA	#0007DH
		JSL	>SOUND_3_ON		; TEh ZbgII
;
		LDY	#PTAOR
ATMN200D0	EQU	$
		STY	!BSPLTP
		LDA	#00080H
		STA	!BONSTM
		LDA	PLTRNAR,Y
		JMP	PAS050
;
;
ATEMON3		EQU	$
		DEC	!BONSTM
		BNE	ATMN30100		; next mode ? [no->ATMN30100]
;
		INC	!BONSMD
ATMN30100	EQU	$
		RTS
;
;
ATEMON4		EQU	$
		LDA	#BANK shutterchr
		STA	R0
		LDA	#shutterchr
		STA	R3
		LDA	#0
		STA	R4
		LDA	!BONSTM
		STA	R5
;
		I8				; index 8bit mode !!
;
		M_CHIP	SHUTTER
;
		I16				; index 16bit mode !!
;
		LDA	!GCSLNUM
		AND	#000FFH
		STA	<WORKE
		LDX	#05
ATMN40080	EQU	$
		CPX	<WORKE
		BEQ	ATMN400A0		; buffer set ? [no->ATMN400A0]
;
		PHX
		TXA
		ASL	A
		TAX
		LDA	#BANK WOB7CHR
		STA	<WORK1
		LDY	ATEMONCHRAD,X
		LDX	#WOB7CHR
		LDA	#00060H
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00030H
		TAY
		LDX	#WOB7CHR+200H
		LDA	#00060H
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00030H
		TAY
		LDX	#WOB7CHR+400H
		LDA	#00060H
		JSL	>VRAMDX_ST
;
		PLX
ATMN400A0	EQU	$
		DEX
		BPL	ATMN40080		; next set ? [yes->ATMN40080]
;
		LDA	!BONSTM
		CMP	#0000CH
		BNE	ATMN400B0		; next mode ? [no->ATMN400B0]
;
		STZ	!PLDNCT
		STZ	!PLUPCT
		LDA	#100
		STA	!GOAL_TTL_PT
		LDA	#a_lastcnt
		STA	!BONSTM
		INC	!BONSMD
ATMN400B0	EQU	$
		LDA	<FRCNT
		AND	#00003H
		BNE	ATMN400C0		;
;
		INC	!BONSTM
ATMN400C0	EQU	$
		RTS
;
;
NUMBERHIGH	EQU	$
		WORD	zerohigh, onehigh, twohigh, threehigh, fourhigh
		WORD	fivehigh, sixhigh, sevenhigh, eighthigh, ninehigh
;
NUMBERLOW	EQU	$
		WORD	zerolow, onelow, twolow, threelow, fourlow
		WORD	fivelow, sixlow, sevenlow, eightlow, ninelow
;
;[1995.04.28.FR];----------------------------------------------------------------
;[1995.04.28.FR];-	ATEMON							-
;[1995.04.28.FR];----------------------------------------------------------------
;[1995.04.28.FR]ate_csl		EQU	03160H
;[1995.04.28.FR]shutterchr	EQU	053A420H
;[1995.04.28.FR]a_lastcnt	EQU	080H
;[1995.04.28.FR]soundplayerdown EQU	013H
;[1995.04.28.FR]atemon_0	EQU	00000H
;[1995.04.28.FR]atemon_1	EQU	atemon_0+90H
;[1995.04.28.FR]atemon_2	EQU	atemon_1+90H
;[1995.04.28.FR]atemon_3	EQU	atemon_2+90H
;[1995.04.28.FR]atemon_4	EQU	atemon_3+90H
;[1995.04.28.FR]atemon_5	EQU	atemon_4+90H
;[1995.04.28.FR]atemon_6	EQU	atemon_5+90H
;[1995.04.28.FR]atr0		EQU	00000H
;[1995.04.28.FR]atr1		EQU	00400H
;[1995.04.28.FR]atr2		EQU	00800H
;[1995.04.28.FR]atr3		EQU	00C00H
;[1995.04.28.FR]atr4		EQU	01000H
;[1995.04.28.FR]atr5		EQU	01400H
;[1995.04.28.FR]atr6		EQU	01800H
;[1995.04.28.FR]atr7		EQU	01C00H
;[1995.04.28.FR]zerohigh	EQU	000CFH
;[1995.04.28.FR]zerolow		EQU	080CFH
;[1995.04.28.FR]onehigh		EQU	000C7H
;[1995.04.28.FR]onelow		EQU	onehigh+10H
;[1995.04.28.FR]twohigh		EQU	000C8H
;[1995.04.28.FR]twolow		EQU	twohigh+10H
;[1995.04.28.FR]threehigh	EQU	000C9H
;[1995.04.28.FR]threelow	EQU	threehigh+10H
;[1995.04.28.FR]fourhigh	EQU	000CAH
;[1995.04.28.FR]fourlow		EQU	fourhigh+10H
;[1995.04.28.FR]fivehigh	EQU	000CBH
;[1995.04.28.FR]fivelow		EQU	fivehigh+10H
;[1995.04.28.FR]sixhigh		EQU	000CCH
;[1995.04.28.FR]sixlow		EQU	sixhigh+10H
;[1995.04.28.FR]sevenhigh	EQU	000CDH
;[1995.04.28.FR]sevenlow	EQU	sevenhigh+10H
;[1995.04.28.FR]eighthigh	EQU	000CEH
;[1995.04.28.FR]eightlow	EQU	000DCH
;[1995.04.28.FR]ninehigh	EQU	080DCH
;[1995.04.28.FR]ninelow		EQU	000DEH
;[1995.04.28.FR]multchrhigh	EQU	002CEH|atr3
;[1995.04.28.FR]multchrlow	EQU	082CEH|atr3
;[1995.04.28.FR]pluschrhigh	EQU	002CDH|atr3
;[1995.04.28.FR]pluschrlow	EQU	082CDH|atr3
;[1995.04.28.FR]minuschrhigh	EQU	002CFH|atr2
;[1995.04.28.FR]minuschrlow	EQU	082CFH|atr2
;[1995.04.28.FR]spacechr	EQU	0FCH|atr2
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMONCHRAD	EQU	$
;[1995.04.28.FR]		WORD	atemon_0, atemon_1, atemon_2, atemon_3, atemon_4, atemon_5
;[1995.04.28.FR];
;[1995.04.28.FR]ACSLXPOS	EQU	$
;[1995.04.28.FR]		HEX	50, 78, A0
;[1995.04.28.FR]		HEX	50, 78, A0
;[1995.04.28.FR];
;[1995.04.28.FR]ACSLYPOS	EQU	$
;[1995.04.28.FR]		HEX	68, 68, 68
;[1995.04.28.FR]		HEX	90, 90, 90
;[1995.04.28.FR];
;[1995.04.28.FR]ACSLYADD	EQU	$
;[1995.04.28.FR]		HEX	03, 03, 03, FD, FD, FD
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMONTABLE	EQU	$
;[1995.04.28.FR]		HEX	00, 01, 02, 03, 04, 05
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMONTABLE20	EQU	$
;[1995.04.28.FR]		HEX	00, 00, 00, 02, 04, 05
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMONAD	EQU	$
;[1995.04.28.FR]		HEX	00, 00, 17, 00, 00, 02, 17, 02, 00, 04, 17, 04
;[1995.04.28.FR]		HEX	00, 06, 17, 06, 00, 08, 17, 08, 00, 0A, 17, 0A
;[1995.04.28.FR]		HEX	00, 0C, 17, 0C, 00, 0E, 17, 0E, 00, 10, 17, 10
;[1995.04.28.FR]		HEX	00, 12, 17, 12, 00, 14, 17, 14, 00, 16, 17, 16
;[1995.04.28.FR]		HEX	00, 18, 17, 18
;[1995.04.28.FR]		HEX	FF
;[1995.04.28.FR];
;[1995.04.28.FR]ATMNVRAD	EQU	$
;[1995.04.28.FR]		WORD	01AAH+bg2_adrs, 01AFH+bg2_adrs, 01B4H+bg2_adrs
;[1995.04.28.FR]		WORD	024AH+bg2_adrs, 024FH+bg2_adrs, 0254H+bg2_adrs
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMONINIT	EQU	$
;[1995.04.28.FR]		LDA	GOAL_TTL_PT
;[1995.04.28.FR]		BEQ	ATMNINT0010		; [->ATMNINT0010]
;[1995.04.28.FR];
;[1995.04.28.FR]		CMP	#21
;[1995.04.28.FR]		BCS	ATMNINT0010		; score < 21 [no->ATMNINT0010]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#ATEMONTABLE20
;[1995.04.28.FR]		BRA	ATMNINT0020
;[1995.04.28.FR];
;[1995.04.28.FR]ATMNINT0010	EQU	$
;[1995.04.28.FR]		LDA	#ATEMONTABLE
;[1995.04.28.FR]ATMNINT0020	EQU	$
;[1995.04.28.FR]		STA	<WORK1E
;[1995.04.28.FR];
;[1995.04.28.FR]		MI8				; memory, index 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#00
;[1995.04.28.FR]		STA	!GCSLNUM
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		LDA	ACSLXPOS,Y
;[1995.04.28.FR]		STA	!CRCXPS
;[1995.04.28.FR]		LDA	ACSLYPOS,Y
;[1995.04.28.FR]		STA	!CRCYPS
;[1995.04.28.FR];
;[1995.04.28.FR]		LDX	#005H
;[1995.04.28.FR]		PHX
;[1995.04.28.FR]ATMNINT0040	EQU	$
;[1995.04.28.FR]		TXY
;[1995.04.28.FR]		LDA	(<WORK1E),Y
;[1995.04.28.FR]		STA	<WORK,X
;[1995.04.28.FR]		DEX
;[1995.04.28.FR]		BPL	ATMNINT0040		; table number set end ? [no->ATMNINT0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		PLY
;[1995.04.28.FR]		LDA	#LOW GINTBLRM
;[1995.04.28.FR]		STA	<WORK2D
;[1995.04.28.FR]		LDA	#HIGH GINTBLRM
;[1995.04.28.FR]		STA	<WORK2E
;[1995.04.28.FR]		JSR	RANDTBLSET		; table ram set !!
;[1995.04.28.FR];
;[1995.04.28.FR]		MI16				; memory, index 16bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#WORKBF
;[1995.04.28.FR]		STA	<WORK12
;[1995.04.28.FR]		LDA	#BANK WORKBF
;[1995.04.28.FR]		STA	<WORK14
;[1995.04.28.FR]		LDY	#00005H
;[1995.04.28.FR]ATMNINT0080	EQU	$
;[1995.04.28.FR]		TYA
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		LDA	ATMNVRAD,X
;[1995.04.28.FR]		STA	<WORK10
;[1995.04.28.FR]		LDA	!GINTBLRM,Y
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		PHY
;[1995.04.28.FR]		JSR	(ATMNINITTBL,X)
;[1995.04.28.FR];
;[1995.04.28.FR]		PLY
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#9*2
;[1995.04.28.FR]		STA	<WORK12
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00000H
;[1995.04.28.FR]		STA	<WORK14
;[1995.04.28.FR]		DEY
;[1995.04.28.FR]		BPL	ATMNINT0080		;
;[1995.04.28.FR];
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATMNINITTBL	EQU	$
;[1995.04.28.FR]		WORD	X2UPINIT
;[1995.04.28.FR]		WORD	DOWN10ININIT
;[1995.04.28.FR]		WORD	DOWNDEV2INIT
;[1995.04.28.FR]		WORD	DOWNNOWPINIT
;[1995.04.28.FR]		WORD	UPBEFOREINIT
;[1995.04.28.FR]		WORD	DOWNBEFOREIT
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]UPLABEL		EQU	$
;[1995.04.28.FR]		WORD	002C7H|atr2, 002C8H|atr2, 002C9H|atr2
;[1995.04.28.FR];
;[1995.04.28.FR]DOWNLABEL	EQU	$
;[1995.04.28.FR]		WORD	002CAH|atr2, 002CBH|atr2, 002CCH|atr2
;[1995.04.28.FR];
;[1995.04.28.FR]X2UPINIT	EQU	$
;[1995.04.28.FR]		LDX	#03
;[1995.04.28.FR]		LDY	#00
;[1995.04.28.FR]X2UIT0040	EQU	$
;[1995.04.28.FR]		LDA	UPLABEL,Y
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		DEX
;[1995.04.28.FR]		BNE	X2UIT0040		; up label set end ? [no->X2UIT0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#multchrhigh
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		LDA	#spacechr
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		LDA	#twohigh
;[1995.04.28.FR]		ORA	#atr3
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		LDA	#multchrlow
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		LDA	#spacechr
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		LDA	#twolow
;[1995.04.28.FR]		ORA	#atr3
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		JMP	WKBFVRSET
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]DOWN10ININIT	EQU	$
;[1995.04.28.FR]		LDX	#03
;[1995.04.28.FR]		LDY	#00
;[1995.04.28.FR]D10IT0040	EQU	$
;[1995.04.28.FR]		LDA	DOWNLABEL,Y
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		DEX
;[1995.04.28.FR]		BNE	D10IT0040		; down label set end ? [no->D10IT0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#minuschrhigh
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		LDA	#minuschrlow
;[1995.04.28.FR]		STA	[<WORK16],Y
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		CMP	#10
;[1995.04.28.FR]		BCC	D10IT0060		; !PLCONT < 10 [yes->D10IT0060]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#10
;[1995.04.28.FR]D10IT0060	EQU	$
;[1995.04.28.FR]		STA	<WORK2E
;[1995.04.28.FR]		LDA	#atr2
;[1995.04.28.FR]		STA	<WORK2C
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#4*2
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		JSR	NUMBERSTORE		; number write !!
;[1995.04.28.FR];
;[1995.04.28.FR]		JMP	WKBFVRSET
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]DOWNDEV2INIT	EQU	$
;[1995.04.28.FR]		LDX	#03
;[1995.04.28.FR]		LDY	#00
;[1995.04.28.FR]DD2IT0040	EQU	$
;[1995.04.28.FR]		LDA	DOWNLABEL,Y
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		DEX
;[1995.04.28.FR]		BNE	DD2IT0040		; down label set end ? [no->DD2IT0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#minuschrhigh
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		LDA	#minuschrlow
;[1995.04.28.FR]		STA	[<WORK16],Y
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		LSR	A
;[1995.04.28.FR]		CMP	#100
;[1995.04.28.FR]		BCC	DD2IT0060		; (!PLCONT / 2) < 100 [yes->DD2IT0060]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#99
;[1995.04.28.FR]DD2IT0060	EQU	$
;[1995.04.28.FR]		STA	<WORK2E
;[1995.04.28.FR]		LDA	#atr2
;[1995.04.28.FR]		STA	<WORK2C
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#4*2
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		JSR	NUMBERSTORE		; number write !!
;[1995.04.28.FR];
;[1995.04.28.FR]		JMP	WKBFVRSET
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]DOWNNOWPINIT	EQU	$
;[1995.04.28.FR]		LDX	#03
;[1995.04.28.FR]		LDY	#00
;[1995.04.28.FR]DNPIT0040	EQU	$
;[1995.04.28.FR]		LDA	DOWNLABEL,Y
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		DEX
;[1995.04.28.FR]		BNE	DNPIT0040		; down label set end ? [no->DNPIT0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#minuschrhigh
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		LDA	#minuschrlow
;[1995.04.28.FR]		STA	[<WORK16],Y
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		CMP	#100
;[1995.04.28.FR]		BCC	DNPIT0060		; !PLCONT < 100 [yes->DNPIT0060]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#99
;[1995.04.28.FR]DNPIT0060	EQU	$
;[1995.04.28.FR]		STA	<WORK2E
;[1995.04.28.FR]		LDA	#atr2
;[1995.04.28.FR]		STA	<WORK2C
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#4*2
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		JSR	NUMBERSTORE		; number write !!
;[1995.04.28.FR];
;[1995.04.28.FR]		JMP	WKBFVRSET
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]UPBEFOREINIT	EQU	$
;[1995.04.28.FR]		LDX	#03
;[1995.04.28.FR]		LDY	#00
;[1995.04.28.FR]UBIT0040	EQU	$
;[1995.04.28.FR]		LDA	UPLABEL,Y
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		DEX
;[1995.04.28.FR]		BNE	UBIT0040		; up label set end ? [no->UBIT0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#pluschrhigh
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		LDA	#pluschrlow
;[1995.04.28.FR]		STA	[<WORK16],Y
;[1995.04.28.FR]		LDA	!PLDNCT
;[1995.04.28.FR]		CMP	#100
;[1995.04.28.FR]		BCC	UBIT0060		; !PLDNCT < 100 [yes->UBIT0060]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#99
;[1995.04.28.FR]UBIT0060	EQU	$
;[1995.04.28.FR]		STA	<WORK2E
;[1995.04.28.FR]		LDA	#atr3
;[1995.04.28.FR]		STA	<WORK2C
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#4*2
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		JSR	NUMBERSTORE		; number write !!
;[1995.04.28.FR];
;[1995.04.28.FR]		JMP	WKBFVRSET
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]DOWNBEFOREIT	EQU	$
;[1995.04.28.FR]		LDX	#03
;[1995.04.28.FR]		LDY	#00
;[1995.04.28.FR]DBIT0040	EQU	$
;[1995.04.28.FR]		LDA	DOWNLABEL,Y
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		INY
;[1995.04.28.FR]		DEX
;[1995.04.28.FR]		BNE	DBIT0040		; down label set end ? [no->DBIT0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#minuschrhigh
;[1995.04.28.FR]		STA	[<WORK12],Y
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		LDA	#minuschrlow
;[1995.04.28.FR]		STA	[<WORK16],Y
;[1995.04.28.FR]		LDA	!PLUPCT
;[1995.04.28.FR]		CMP	#100
;[1995.04.28.FR]		BCC	DBIT0060		; !PLUPCT < 100 [yes->DBIT0060]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#99
;[1995.04.28.FR]DBIT0060	EQU	$
;[1995.04.28.FR]		STA	<WORK2E
;[1995.04.28.FR]		LDA	#atr2
;[1995.04.28.FR]		STA	<WORK2C
;[1995.04.28.FR]		LDA	<WORK12
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#4*2
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		JSR	NUMBERSTORE		; number write !!
;[1995.04.28.FR];
;[1995.04.28.FR]		JMP	WKBFVRSET
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMON		EQU	$
;[1995.04.28.FR]		M8				; memory 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!KEYCOUNT
;[1995.04.28.FR]		BEQ	ATMN0010		; key counter zero ? [yes->ATMN0010]
;[1995.04.28.FR];
;[1995.04.28.FR]		DEC	!KEYCOUNT
;[1995.04.28.FR]ATMN0010	EQU	$
;[1995.04.28.FR]		M16				; memory 16bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!CRCXPS
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#00014H
;[1995.04.28.FR]		STA	<WORK0
;[1995.04.28.FR]		LDA	!CRCYPS
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#00014H
;[1995.04.28.FR]		STA	<WORK2
;[1995.04.28.FR]		LDA	#ate_csl
;[1995.04.28.FR]		STA	<WORK4
;[1995.04.28.FR]		JSR	GINGAMICSLOAM		; cursol display !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!KEYA2L
;[1995.04.28.FR]		AND	#1100000010000000B
;[1995.04.28.FR]		BEQ	ATMN0080		; B,Y,A on ? [no->ATMN0080]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#soundcslkettei
;[1995.04.28.FR]		JSL	>SOUND_3_ON		; TEh ZbgII
;[1995.04.28.FR];
;[1995.04.28.FR]		LDY	#PMIR1
;[1995.04.28.FR]		STY	!BSPLTP
;[1995.04.28.FR]		LDA	PLTRNAR,Y
;[1995.04.28.FR]		JSR	PAS050
;[1995.04.28.FR];
;[1995.04.28.FR]		MI8				; memory, index 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#018H
;[1995.04.28.FR]		STA	!KEYCOUNT
;[1995.04.28.FR]		INC	!BONSMD
;[1995.04.28.FR];
;[1995.04.28.FR]		M16				; memory 16bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR];;;;		LDY	#00
;[1995.04.28.FR];;;;		LDA	#ATEMONAD
;[1995.04.28.FR];;;;		STA	<GINXPSAD		; position address
;[1995.04.28.FR];;;;		LDA	(<GINXPSAD),Y
;[1995.04.28.FR];;;;		INY
;[1995.04.28.FR];;;;		AND	#000FFH
;[1995.04.28.FR];;;;		XBA
;[1995.04.28.FR];;;;		STA	!GINXPOS
;[1995.04.28.FR];;;;		LDA	(<GINXPSAD),Y
;[1995.04.28.FR];;;;		INY
;[1995.04.28.FR];;;;		STY	!GDEMOCNT
;[1995.04.28.FR];;;;		AND	#000FFH
;[1995.04.28.FR];;;;		XBA
;[1995.04.28.FR];;;;		STA	!GINYPOS
;[1995.04.28.FR];;;;		LDA	#BANK shutterchr
;[1995.04.28.FR];;;;		STA	R0
;[1995.04.28.FR];;;;		LDA	#shutterchr
;[1995.04.28.FR];;;;		STA	R3
;[1995.04.28.FR];;;;		M_CHIP	GININIT
;[1995.04.28.FR];;;;;
;[1995.04.28.FR];
;[1995.04.28.FR]		STZ	!GDEMOCNT
;[1995.04.28.FR]		I16				; index 16bit mode !!
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR]ATMN0080	EQU	$
;[1995.04.28.FR];;;		JMP	A_CURSOLMV		; cursol move !!
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]A_CURSOLMV	EQU	$
;[1995.04.28.FR]		MI8				; memory, index 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!KEYA2
;[1995.04.28.FR]		AND	#00001111B
;[1995.04.28.FR]		BEQ	ACSLMV0040		; up or down or left or right key press ?
;[1995.04.28.FR];						; [no->ACSLMV0040]
;[1995.04.28.FR]		LDY	#keycount0
;[1995.04.28.FR]		BRA	ACSLMV0050
;[1995.04.28.FR];
;[1995.04.28.FR]ACSLMV0040	EQU	$
;[1995.04.28.FR]		LDY	!KEYCOUNT
;[1995.04.28.FR]		BNE	ACSLMV0100		; key check ? [no->ACSLMV0100]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDY	#keycount1
;[1995.04.28.FR]ACSLMV0050	EQU	$
;[1995.04.28.FR]		STY	!KEYCOUNT
;[1995.04.28.FR]		LDA	!KEYA1
;[1995.04.28.FR]		AND	#00001111B
;[1995.04.28.FR]		BNE	ACSLMV0080		; up or down or left or right key press ?
;[1995.04.28.FR];						; [no->ACSLMV0080]
;[1995.04.28.FR]		BRA	ACSLMV0100
;[1995.04.28.FR];
;[1995.04.28.FR]ACSLMV0080	EQU	$
;[1995.04.28.FR]		PHA
;[1995.04.28.FR]		AND	#00000011B
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		LDA	!GCSLNUM
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	GCSLXADD,Y
;[1995.04.28.FR]		BPL	ACSLMV0090		; area over ? [no->ACSLMV0090]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#5
;[1995.04.28.FR]		BRA	ACSLMV00A0
;[1995.04.28.FR];
;[1995.04.28.FR]ACSLMV0090	EQU	$
;[1995.04.28.FR]		CMP	#5+1
;[1995.04.28.FR]		BCC	ACSLMV00A0		; area over ? [no->ACSLMV00A0]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#0
;[1995.04.28.FR]ACSLMV00A0	EQU	$
;[1995.04.28.FR]		STA	!GCSLNUM
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		PLA
;[1995.04.28.FR]		LSR	A
;[1995.04.28.FR]		LSR	A
;[1995.04.28.FR]		BIT	#00000011B
;[1995.04.28.FR]		BEQ	ACSLMV00D0		; down on ? [no->ACSLMV00D0]
;[1995.04.28.FR];
;[1995.04.28.FR]		TYA
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	ACSLYADD,Y
;[1995.04.28.FR]		STA	!GCSLNUM
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]ACSLMV00D0	EQU	$
;[1995.04.28.FR]		LDA	ACSLXPOS,Y
;[1995.04.28.FR]		STA	!CRCXPS
;[1995.04.28.FR]		LDA	ACSLYPOS,Y
;[1995.04.28.FR]		STA	!CRCYPS
;[1995.04.28.FR]		LDA	#soundcslmove
;[1995.04.28.FR]		JSL	>SOUND_3_ON		; TEh ZbgII
;[1995.04.28.FR];
;[1995.04.28.FR]ACSLMV0100	EQU	$
;[1995.04.28.FR]		MI16				; memory, index 16bit mode !!
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMON2		EQU	$
;[1995.04.28.FR]		M8				; memory 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!KEYCOUNT
;[1995.04.28.FR]		BNE	ATMN20010		; sound on ? [no->ATMN20010]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#020H
;[1995.04.28.FR]		STA	!KEYCOUNT
;[1995.04.28.FR]		LDA	#soundhikkaki
;[1995.04.28.FR]		JSL	>SOUND_3_ON		; TEh ZbgII
;[1995.04.28.FR];
;[1995.04.28.FR]		BRA	ATMN20020
;[1995.04.28.FR];
;[1995.04.28.FR]ATMN20010	EQU	$
;[1995.04.28.FR]		DEC	!KEYCOUNT
;[1995.04.28.FR]ATMN20020	EQU	$
;[1995.04.28.FR];;;;		LDA	!CRCXPS
;[1995.04.28.FR];;;;		CLC
;[1995.04.28.FR];;;;		ADC	!GINXPOS+1
;[1995.04.28.FR];;;;		STA	<WORK0
;[1995.04.28.FR];;;;		LDA	!CRCYPS
;[1995.04.28.FR];;;;		CLC
;[1995.04.28.FR];;;;		ADC	!GINYPOS+1
;[1995.04.28.FR];;;;		STA	<WORK2
;[1995.04.28.FR];;;;		STZ	<WORK1
;[1995.04.28.FR];;;;		STZ	<WORK3
;[1995.04.28.FR];
;[1995.04.28.FR]		M16				; memory 16bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR];;;;		JSR	GINGAMICSLOAM		;
;[1995.04.28.FR];
;[1995.04.28.FR]		I8				; index 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#BANK shutterchr
;[1995.04.28.FR]		STA	R0
;[1995.04.28.FR]		LDA	#shutterchr
;[1995.04.28.FR]		STA	R3
;[1995.04.28.FR]		LDA	!GDEMOCNT
;[1995.04.28.FR]		STA	R4
;[1995.04.28.FR]		LDA	#0
;[1995.04.28.FR]		STA	R5
;[1995.04.28.FR]		M_CHIP	SHUTTER
;[1995.04.28.FR];
;[1995.04.28.FR];;;;		LDA	!GINXPOS+1
;[1995.04.28.FR];;;;		AND	#000FFH
;[1995.04.28.FR];;;;		STA	R3
;[1995.04.28.FR];;;;		LDA	!GINYPOS+1
;[1995.04.28.FR];;;;		AND	#000FFH
;[1995.04.28.FR];;;;		STA	R4
;[1995.04.28.FR];;;;		M_CHIP	GINGAMI
;[1995.04.28.FR];;;;;
;[1995.04.28.FR]		I16				; index 16bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#BANK WOB7CHR
;[1995.04.28.FR]		STA	<WORK1
;[1995.04.28.FR]		LDA	!GCSLNUM
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		LDY	ATEMONCHRAD,X
;[1995.04.28.FR]		LDX	#WOB7CHR
;[1995.04.28.FR]		LDA	#3
;[1995.04.28.FR]		STA	<WORKE
;[1995.04.28.FR]ATMN20040	EQU	$
;[1995.04.28.FR]		LDA	#00060H
;[1995.04.28.FR]		PHX
;[1995.04.28.FR]		PHY
;[1995.04.28.FR]		JSL	>VRAMDX_ST
;[1995.04.28.FR];
;[1995.04.28.FR]		PLA
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#30H
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		PLA
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#0200H
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		DEC	<WORKE
;[1995.04.28.FR]		BNE	ATMN20040		; vram set end ? [no->ATMN20040]
;[1995.04.28.FR];
;[1995.04.28.FR]		MI8				; memory, index 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!GDEMOCNT
;[1995.04.28.FR]		CMP	#00CH
;[1995.04.28.FR]		BEQ	ATMN20080		; demo end ? [yes->ATMN20080]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	<FRCNT
;[1995.04.28.FR]		AND	#03
;[1995.04.28.FR]		BNE	ATMN20100		;
;[1995.04.28.FR];
;[1995.04.28.FR]		INC	!GDEMOCNT
;[1995.04.28.FR];
;[1995.04.28.FR];;;;		LDY	!GDEMOCNT
;[1995.04.28.FR];;;;		LDA	(<GINXPSAD),Y
;[1995.04.28.FR];;;;		BMI	ATMN20080		; demo end ? [yes->ATMN20080]
;[1995.04.28.FR];;;;;
;[1995.04.28.FR];;;;		JSR	G_FINGERMV		; finger move !!
;[1995.04.28.FR];;;;;
;[1995.04.28.FR]ATMN20100	EQU	$
;[1995.04.28.FR]		MI16				; memory, index 16bit mode !!
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATMN20080	EQU	$
;[1995.04.28.FR]		MI16				; memory, index 16bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		INC	!BONSMD
;[1995.04.28.FR]		LDA	!GCSLNUM
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		LDA	GINTBLRM,Y
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		JSR	(ATMNTBL,X)
;[1995.04.28.FR];
;[1995.04.28.FR]		LDY	#PWALK
;[1995.04.28.FR]		LDA	!SLCOIN
;[1995.04.28.FR]		BEQ	ATMN200C0		; vC[ςȂ ? [yes->ATMN200C0]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDY	#PYORO
;[1995.04.28.FR]		LDA	PL_UP_DOWN,X
;[1995.04.28.FR]		BPL	ATMN200C0		; vC[ ? [yes->ATMN200C0]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDY	#PTAOR
;[1995.04.28.FR]ATMN200C0	EQU	$
;[1995.04.28.FR]		STY	!BSPLTP
;[1995.04.28.FR]		LDA	PLTRNAR,Y
;[1995.04.28.FR]		JMP	PAS050
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATMNTBL		EQU	$
;[1995.04.28.FR]		WORD	X2UP
;[1995.04.28.FR]		WORD	DOWN10
;[1995.04.28.FR]		WORD	DOWNDEV2
;[1995.04.28.FR]		WORD	DOWNNOWP
;[1995.04.28.FR]		WORD	UPBEFORE
;[1995.04.28.FR]		WORD	DOWNBEFORE
;[1995.04.28.FR];
;[1995.04.28.FR]PL_UP_DOWN	EQU	$
;[1995.04.28.FR]		WORD	0001, -0001, -0001, -0001, 0001, -0001
;[1995.04.28.FR];
;[1995.04.28.FR]X2UP		EQU	$
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		STA	!SLCOIN
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]DOWN10		EQU	$
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		CMP	#10
;[1995.04.28.FR]		BCC	D100040			; !PLCONT < 10 [yes->D100040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#10
;[1995.04.28.FR]D100040		EQU	$
;[1995.04.28.FR]		STA	!SLCOIN
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]DOWNDEV2	EQU	$
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		LSR	A
;[1995.04.28.FR]		CMP	#100
;[1995.04.28.FR]		BCC	DD20040			; (!PLCONT / 2) < 100 [yes->DD20040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#99
;[1995.04.28.FR]DD20040		EQU	$
;[1995.04.28.FR]		STA	!SLCOIN
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]DOWNNOWP	EQU	$
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		CMP	#100
;[1995.04.28.FR]		BCC	DNP0040			; !PLCONT < 100 [yes->DNP0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#99
;[1995.04.28.FR]DNP0040		EQU	$
;[1995.04.28.FR]		STA	!SLCOIN
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]UPBEFORE	EQU	$
;[1995.04.28.FR]		LDA	!PLDNCT
;[1995.04.28.FR]		STA	!SLCOIN
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]DOWNBEFORE	EQU	$
;[1995.04.28.FR]		LDA	!PLUPCT
;[1995.04.28.FR]		STA	!SLCOIN
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMON3		EQU	$
;[1995.04.28.FR]		LDA	!GCSLNUM
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		LDA	GINTBLRM,Y
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		JSR	(ATMNCOUNTTBL,X)
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!BONSMD
;[1995.04.28.FR]		CMP	#atemon3
;[1995.04.28.FR]		BEQ	ATMN30100		; next mode ? [no->ATMN30100]
;[1995.04.28.FR];
;[1995.04.28.FR];;;;		LDA	#BANK shutterchr
;[1995.04.28.FR];;;;		STA	R0
;[1995.04.28.FR];;;;		LDA	#shutterchr
;[1995.04.28.FR];;;;		STA	R3
;[1995.04.28.FR];;;;;
;[1995.04.28.FR];;;;		I8				; index 8bit mode !!
;[1995.04.28.FR];;;;;
;[1995.04.28.FR];;;;		M_CHIP	GININIT
;[1995.04.28.FR];;;;;
;[1995.04.28.FR];;;;		I16				; index 16bit mode !!
;[1995.04.28.FR];;;;;
;[1995.04.28.FR];;;;		LDA	#64-2
;[1995.04.28.FR]		LDA	#00
;[1995.04.28.FR]		STA	!BONSTM
;[1995.04.28.FR]ATMN30100	EQU	$
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATMNCOUNTTBL	EQU	$
;[1995.04.28.FR]		WORD	BONUSPLAYERUP		; 1
;[1995.04.28.FR]		WORD	BONUSPLAYERDOWN		; 2
;[1995.04.28.FR]		WORD	BONUSPLAYERDOWN		; 3
;[1995.04.28.FR]		WORD	BONUSPLAYERDOWN		; 4
;[1995.04.28.FR]		WORD	BONUSPLAYERUP		; 5
;[1995.04.28.FR]		WORD	BONUSPLAYERDOWN		; 6
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]BONUSPLAYERDOWN EQU	$
;[1995.04.28.FR]		LDA	!BONSTM
;[1995.04.28.FR]		BEQ	BPD0040			; bonus timer dec ? [no->BPD0040]
;[1995.04.28.FR];
;[1995.04.28.FR]		DEC	!BONSTM
;[1995.04.28.FR]		JMP	BPD0100
;[1995.04.28.FR];
;[1995.04.28.FR]BPD0040		EQU	$
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		BEQ	BPD0060			; player down cound end ? [yes->BPD0060]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!SLCOIN
;[1995.04.28.FR]		BNE	BPD0080			; player down cound end ? [no->BPD0080]
;[1995.04.28.FR];
;[1995.04.28.FR]BPD0060		EQU	$
;[1995.04.28.FR]		LDA	#g_lastcnt
;[1995.04.28.FR]		STA	!BONSTM
;[1995.04.28.FR]		INC	!BONSMD
;[1995.04.28.FR]		BRA	BPD0100
;[1995.04.28.FR];
;[1995.04.28.FR]BPD0080		EQU	$
;[1995.04.28.FR]		LDY	#soundplayerdown
;[1995.04.28.FR]		STY	!SOUND3
;[1995.04.28.FR]		LDY	#20H
;[1995.04.28.FR]		STY	!BONSTM
;[1995.04.28.FR]		CMP	#111
;[1995.04.28.FR]		BCS	BPD00C0			; !SLCOIN < 111 [no->BPD00C0]
;[1995.04.28.FR];
;[1995.04.28.FR]		CMP	#11
;[1995.04.28.FR]		BCS	BPD00A0			; !SLCOIN < 11 [no->BPD00A0]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		DEC	A
;[1995.04.28.FR]		CMP	#01
;[1995.04.28.FR]		BPL	BPD0090			; vC[  PH [no->BPD0090]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#01
;[1995.04.28.FR]BPD0090		EQU	$
;[1995.04.28.FR]		STA	!PLCONT
;[1995.04.28.FR]		JSR	PLCNTST
;[1995.04.28.FR];
;[1995.04.28.FR]		DEC	!SLCOIN
;[1995.04.28.FR]		BRA	BPD0100
;[1995.04.28.FR];
;[1995.04.28.FR]BPD00A0		EQU	$
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		SEC
;[1995.04.28.FR]		SBC	#10
;[1995.04.28.FR]		CMP	#01
;[1995.04.28.FR]		BPL	BPD00B0			; vC[  PH [no->BPD00B0]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#01
;[1995.04.28.FR]BPD00B0		EQU	$
;[1995.04.28.FR]		STA	!PLCONT
;[1995.04.28.FR]		JSR	PLCNTST
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!SLCOIN
;[1995.04.28.FR]		SEC
;[1995.04.28.FR]		SBC	#10
;[1995.04.28.FR]		STA	!SLCOIN
;[1995.04.28.FR]		BRA	BPD0100
;[1995.04.28.FR];
;[1995.04.28.FR]BPD00C0		EQU	$
;[1995.04.28.FR]		LDA	!PLCONT
;[1995.04.28.FR]		SEC
;[1995.04.28.FR]		SBC	#100
;[1995.04.28.FR]		CMP	#01
;[1995.04.28.FR]		BPL	BPD00D0			; vC[  PH [no->BPD00D0]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#01
;[1995.04.28.FR]BPD00D0		EQU	$
;[1995.04.28.FR]		STA	!PLCONT
;[1995.04.28.FR]		JSR	PLCNTST
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!SLCOIN
;[1995.04.28.FR]		SEC
;[1995.04.28.FR]		SBC	#100
;[1995.04.28.FR]		STA	!SLCOIN
;[1995.04.28.FR]BPD0100		EQU	$
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR]ATEMON4		EQU	$
;[1995.04.28.FR]		LDA	#BANK shutterchr
;[1995.04.28.FR]		STA	R0
;[1995.04.28.FR]		LDA	#shutterchr
;[1995.04.28.FR]		STA	R3
;[1995.04.28.FR]		LDA	#0
;[1995.04.28.FR]		STA	R4
;[1995.04.28.FR]		LDA	!BONSTM
;[1995.04.28.FR]		STA	R5
;[1995.04.28.FR];
;[1995.04.28.FR]		I8				; index 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		M_CHIP	SHUTTER
;[1995.04.28.FR];
;[1995.04.28.FR]		I16				; index 16bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR];;;		LDX	!BONSTM
;[1995.04.28.FR];;;		LDA	>CHNGXPS,X
;[1995.04.28.FR];;;		AND	#000FFH
;[1995.04.28.FR];;;		STA	!CCWORK0
;[1995.04.28.FR];;;		LDA	>CHNGXPS+1,X
;[1995.04.28.FR];;;		STA	!CCWORK1
;[1995.04.28.FR];;;		LDA	>CHNGYPS,X
;[1995.04.28.FR];;;		AND	#000FFH
;[1995.04.28.FR];;;		STA	!CCWORK2
;[1995.04.28.FR];;;		LDA	>CHNGYPS+1,X
;[1995.04.28.FR];;;		STA	!CCWORK3
;[1995.04.28.FR];;;;
;[1995.04.28.FR];;;		I8				; index 8bit mode !!
;[1995.04.28.FR];;;;
;[1995.04.28.FR];;;		M_CHIP	DOTERASE
;[1995.04.28.FR];;;;
;[1995.04.28.FR];;;		I16				; index 16bit mode !!
;[1995.04.28.FR];;;;
;[1995.04.28.FR]		LDA	!GCSLNUM
;[1995.04.28.FR]		AND	#000FFH
;[1995.04.28.FR]		STA	<WORKE
;[1995.04.28.FR]		LDX	#05
;[1995.04.28.FR]ATMN40080	EQU	$
;[1995.04.28.FR]		CPX	<WORKE
;[1995.04.28.FR]		BEQ	ATMN400A0		; buffer set ? [no->ATMN400A0]
;[1995.04.28.FR];
;[1995.04.28.FR]		PHX
;[1995.04.28.FR]		TXA
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		LDA	#BANK WOB7CHR
;[1995.04.28.FR]		STA	<WORK1
;[1995.04.28.FR]		LDY	ATEMONCHRAD,X
;[1995.04.28.FR]		LDX	#WOB7CHR
;[1995.04.28.FR]		LDA	#00060H
;[1995.04.28.FR]		PHY
;[1995.04.28.FR]		JSL	>VRAMDX_ST
;[1995.04.28.FR];
;[1995.04.28.FR]		PLA
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#00030H
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		LDX	#WOB7CHR+200H
;[1995.04.28.FR]		LDA	#00060H
;[1995.04.28.FR]		PHY
;[1995.04.28.FR]		JSL	>VRAMDX_ST
;[1995.04.28.FR];
;[1995.04.28.FR]		PLA
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#00030H
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		LDX	#WOB7CHR+400H
;[1995.04.28.FR]		LDA	#00060H
;[1995.04.28.FR]		JSL	>VRAMDX_ST
;[1995.04.28.FR];
;[1995.04.28.FR]		PLX
;[1995.04.28.FR]ATMN400A0	EQU	$
;[1995.04.28.FR]		DEX
;[1995.04.28.FR]		BPL	ATMN40080		; next set ? [yes->ATMN40080]
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	!BONSTM
;[1995.04.28.FR]		CMP	#0000CH
;[1995.04.28.FR]		BNE	ATMN400B0		; next mode ? [no->ATMN400B0]
;[1995.04.28.FR];
;[1995.04.28.FR]		STZ	!PLDNCT
;[1995.04.28.FR]		STZ	!PLUPCT
;[1995.04.28.FR]		LDA	#100
;[1995.04.28.FR]		STA	!GOAL_TTL_PT
;[1995.04.28.FR]		LDA	#a_lastcnt
;[1995.04.28.FR]		STA	!BONSTM
;[1995.04.28.FR]		INC	!BONSMD
;[1995.04.28.FR]ATMN400B0	EQU	$
;[1995.04.28.FR]		LDA	<FRCNT
;[1995.04.28.FR]		AND	#00003H
;[1995.04.28.FR]		BNE	ATMN400C0		;
;[1995.04.28.FR];
;[1995.04.28.FR]		INC	!BONSTM
;[1995.04.28.FR];;;;		DEC	!BONSTM
;[1995.04.28.FR];;;;		DEC	!BONSTM
;[1995.04.28.FR]ATMN400C0	EQU	$
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR];----------------------------------------------------------------
;[1995.04.28.FR];-	WORK12, 13 <- work buffer address			-
;[1995.04.28.FR];-	WORK14, 15 <-	"     "	  bank				-
;[1995.04.28.FR];----------------------------------------------------------------
;[1995.04.28.FR]WKBFVRSET	EQU	$
;[1995.04.28.FR]		LDA	#03
;[1995.04.28.FR]		STA	<WORKE
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		STA	<WORK1
;[1995.04.28.FR]		LDY	<WORK10
;[1995.04.28.FR]		LDX	<WORK12
;[1995.04.28.FR]WKBFVRST40	EQU	$
;[1995.04.28.FR]		LDA	#3*2
;[1995.04.28.FR]		PHY
;[1995.04.28.FR]		PHX
;[1995.04.28.FR]		JSL	>VRAMDX_ST
;[1995.04.28.FR];
;[1995.04.28.FR]		PLA
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#3*2
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		PLA
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#00020H
;[1995.04.28.FR]		TAY
;[1995.04.28.FR]		DEC	<WORKE
;[1995.04.28.FR]		BNE	WKBFVRST40		; set end ? [no->WKBFVRST40]
;[1995.04.28.FR];
;[1995.04.28.FR]		RTS
;[1995.04.28.FR];
;[1995.04.28.FR];
;[1995.04.28.FR];----------------------------------------------------------------
;[1995.04.28.FR];-	WORK16,17 <- work buffer address			-
;[1995.04.28.FR];-	WORK18,19 <-   "    "	 bank				-
;[1995.04.28.FR];-	WORK2C,2D <- attribute					-
;[1995.04.28.FR];-	WORK2E,2F <- number					-
;[1995.04.28.FR];----------------------------------------------------------------
;[1995.04.28.FR]NUMBERSTORE	EQU	$
;[1995.04.28.FR]		LDA	<WORK2E
;[1995.04.28.FR]		CMP	#10
;[1995.04.28.FR]		BCC	NST0060			; WORK2E < 10 [yes->NST0060]
;[1995.04.28.FR];
;[1995.04.28.FR]		STA	4204H
;[1995.04.28.FR];
;[1995.04.28.FR]		M8				; memory 8bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	#10
;[1995.04.28.FR]		STA	4206H
;[1995.04.28.FR];
;[1995.04.28.FR]		M16				; memory 16bit mode !!
;[1995.04.28.FR];
;[1995.04.28.FR]		NOP
;[1995.04.28.FR]		NOP
;[1995.04.28.FR]		NOP
;[1995.04.28.FR]		NOP
;[1995.04.28.FR]		NOP
;[1995.04.28.FR]		NOP
;[1995.04.28.FR]		NOP
;[1995.04.28.FR];
;[1995.04.28.FR]		LDA	4214H
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		LDA	NUMBERHIGH,X
;[1995.04.28.FR]		ORA	<WORK2C
;[1995.04.28.FR]		STA	[<WORK16]
;[1995.04.28.FR]		LDA	<WORK16
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK1A
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK1C
;[1995.04.28.FR]		LDA	NUMBERLOW,X
;[1995.04.28.FR]		ORA	<WORK2C
;[1995.04.28.FR]		STA	[<WORK1A]
;[1995.04.28.FR]		LDA	<WORK16
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#02
;[1995.04.28.FR]		STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK18
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		LDA	4216H
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		LDA	NUMBERHIGH,X
;[1995.04.28.FR]		ORA	<WORK2C
;[1995.04.28.FR]		STA	[<WORK16]
;[1995.04.28.FR]		LDA	<WORK16
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK1A
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK1C
;[1995.04.28.FR]		LDA	NUMBERLOW,X
;[1995.04.28.FR]		ORA	<WORK2C
;[1995.04.28.FR]		STA	[<WORK1A]
;[1995.04.28.FR]		BRA	NST0080
;[1995.04.28.FR];
;[1995.04.28.FR]NST0060		EQU	$
;[1995.04.28.FR]		ASL	A
;[1995.04.28.FR]		TAX
;[1995.04.28.FR]		LDA	#spacechr
;[1995.04.28.FR]		STA	[<WORK16]
;[1995.04.28.FR]		LDA	<WORK16
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK1A
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK1C
;[1995.04.28.FR]		LDA	#spacechr
;[1995.04.28.FR]		STA	[<WORK1A]
;[1995.04.28.FR]		LDA	<WORK16
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#02
;[1995.04.28.FR]			STA	<WORK16
;[1995.04.28.FR]		LDA	<WORK18
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK18
;[1995.04.28.FR]		LDA	NUMBERHIGH,X
;[1995.04.28.FR]		ORA	<WORK2C
;[1995.04.28.FR]		STA	[<WORK16]
;[1995.04.28.FR]		LDA	<WORK16
;[1995.04.28.FR]		CLC
;[1995.04.28.FR]		ADC	#06
;[1995.04.28.FR]		STA	<WORK1A
;[1995.04.28.FR]		LDA	<WORK14
;[1995.04.28.FR]		ADC	#00
;[1995.04.28.FR]		STA	<WORK1C
;[1995.04.28.FR]		LDA	NUMBERLOW,X
;[1995.04.28.FR]		ORA	<WORK2C
;[1995.04.28.FR]		STA	[<WORK1A]
;[1995.04.28.FR]NST0080		EQU	$
;[1995.04.28.FR]		RTS
;
;
		MEM16
		IDX16
;
;============== vnqkc@U ==========================================
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SLT1MOV ( WORLD 6 _o move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLT1MOV		EQU	$
		LDA	BONSMD
		ASL	A
		TAX
		JMP	(!SLT1ADR,X)
;
;
SLT1ADR		EQU	$
		WORD	TIMEDEC		; 0  timer dec. set sub !!
		WORD	WINDOPN		; 1  window open sub !!
		WORD	TIMDEC0		; 2  timer dec. set sub !!
		WORD	MSWINOP		; 3  messege window open sub !!
		WORD	WINCLSB		; 4  window color sub !!
		WORD	SCRDOWN		; 5  screen down move sub !!
		WORD	SCRYURE		; 6  screen yure sub !!
		WORD	TIMDEC2		; 7  timer dec. set sub !!
;[1995/02/08]		WORD	COINDEC		; 8 yosshy coin dec. sub !!
CRALLT		WORD	CARDALLT	; 9  CjV]Ci-->\j
COINMV		WORD	COINMIN		; A  main move !!
EGGMOV		WORD	EGGMOVE		; B  egg move
		WORD	COINRMV1	; C  coin turn (ura-->1/2)
		WORD	COINRMV2	; D  coin turn (1/2-->omote)
BS6MAP		WORD	MODEMAP		; E  map initial mode set sub !!
YSYORO		WORD	YSYORMOV	; F  bV[ 
YSKANA		WORD	YSKANMOV	; 10 bV[ ߂
CARTIN		WORD	CARDRTIN	; 11 Q[ԂiCjVj
CRRTN1		WORD	CARDRTN1	; 12 Q[Ԃi\-->1/2j
CRRTN2		WORD	CARDRTN2	; 13 Q[Ԃi1/2-->j
;[1995/04/28]CRCINT		WORD	CARDCMOV	; 14 J[hւ
CRA10M		WORD	COINRMV10	; 15 CjV]i-->1/2j
CRA20M		WORD	COINRMV20	; 16 CjV]i1/2-->\j
;[1995/04/28]CRTRMN		WORD	CARDRTNM	; 17 CjVԂC
;[1995/04/28]		WORD	CARDRTN1	; 18 CjVԂi\-->1/2j
;[1995/04/28]		WORD	CARDRTN2	; 19 CjVԂi1/2-->j
CRALLR		WORD	CARDALLR	;    CjV]Ci\-->j
		WORD	CARDRTN1	;    CjVԂi\-->1/2j
		WORD	CARDRTN2	;    CjVԂi1/2-->j

;
;
COINM		EQU	(COINMV-SLT1ADR)/2
EGGMV		EQU	(EGGMOV-SLT1ADR)/2
BS6MP		EQU	(BS6MAP-SLT1ADR)/2
YYORO		EQU	(YSYORO-SLT1ADR)/2
YKANA		EQU	(YSKANA-SLT1ADR)/2
CRTIN		EQU	(CARTIN-SLT1ADR)/2
CRALL		EQU	(CRALLT-SLT1ADR)/2
;[1995/04/28]CRINT		EQU	(CRCINT-SLT1ADR)/2
CRRT1		EQU	(CRRTN1-SLT1ADR)/2
CRRT2		EQU	(CRRTN2-SLT1ADR)/2
CR10M		EQU	(CRA10M-SLT1ADR)/2
CR20M		EQU	(CRA20M-SLT1ADR)/2
;[1995/04/28]CRTNM		EQU	(CRTRMN-SLT1ADR)/2
CRALR		EQU	(CRALLR-SLT1ADR)/2
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COININT ( WORLD 6 _o initial set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COININT		EQU	$
		STZ	SLCOIN		; yA̐
		STZ	KAMMD0		; ͂ꂽ
		STZ	TUGIYP		; l
		LDA	#000FFH
		STA	SHINNUM+0	; yAe[u
		STA	SHINNUM+2
;
		MI8			; memory,index 8bit mode !!
;
		LDX	#014-2
COINT010	EQU	$
		STZ	CHNGTBL,X	; ւe[u
		STZ	CHNGTBL+1,X	; ւe[u
		DEX
		DEX
		BPL	COINT010
;
		LDA	!COINXDT+0
		STA	CRCXPS
		LDA	!COINYDT+0
		STA	CRCYPS
		STZ	CARDMV		; cursole move flag
		STZ	COINPT		; cursole index
		STZ	CONXSD		; cursole X speed
		STZ	TRCOIN		; ߂iPyAj
;
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINRAN ( WORLD 6 _o _Zbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
;	 e[u̒g (COINTBL) 
;
;	   COINRDT
;		O@F@nei_
;		Q@F@؂̎i΁j
;		R@F@؂̎iԁj
;		T@F@etkk
;		U@F@X^[iPOj
;		V@F@X^[iQOj
;		W@F@onv
;		X@F@ዾ
;		a@F@؂̎ij
;
;
;========================================================================
;
COINRDT		EQU	$
		HEX	00,02,03,05,06,07,08,09,0B
;
COINCDT		EQU	$
		BYTE	01,01,02,02,03,03,05,50
;
;
COINRAN		EQU	$
		MI8			; memory,index 8bit mode
;
;-----< [Ne[uE_Zbg >---------------------------------
;
		JSR	RANDSEL		; _ZNg
		STA	<WORK20
;
CORA010		EQU	$
		JSR	RANDSEL		; _ZNg
		CMP	<WORK20
		BEQ	CORA010		; H
;					: No
		STA	<WORK21
;
		LDX	#000
		TXY
CORA012		EQU	$
		CPY	<WORK20
		BEQ	CORA015
;
		CPY	<WORK21
		BEQ	CORA015
;
		LDA	!COINRDT,Y
		STA	<WORK0+0,X
		STA	<WORK0+1,X
;
		INX
		INX
;
CORA015		EQU	$
		INY
		CPX	#007*2
		BNE	CORA012
;
;-----< RCe[uEZbg >-----------------------------------------
;
		LDA	#014
		STA	<WORKE		; 搔
		LDY	#000		; e[uE|Cg
;
CORA020		EQU	$
		JSL	>RANDAM		; _ 
;
		LDA	<WORKE
		STA	4202H
		LDA	RANDM0
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		M16			; memory 16bit mode !!
		LDA	4216H
		XBA
		M8			; memory 8bit mode !!
		AND	#00FH
		TAX
		LDA	<WORK0,X
		STA	COINTBL,Y
		INY
		CPY	#013
		BEQ	CORA024		; chPhH
;					: no
		DEC	<WORKE
CORA022		EQU	$
		CPX	<WORKE
		BEQ	CORA020		; last point ?
;					: no
		LDA	<WORK0+1,X
		STA	<WORK0,X	; f[^Ol
		INX
		BRA	CORA022
;
CORA024		EQU	$
		TXA
		EOR	#001
		TAX
		LDA	<WORK0,X
		STA	COINTBL+13	; last data set !!
;
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	RANDSEL ( WORLD 6 _o ZNg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
RANDSEL		EQU	$
		M8			; memory 8bit mode
;
		JSL	>RANDAM		; _
;
		LDA	#009
		STA	4202H		; 搔
		LDA	RANDM0
		STA	4203H		; 搔
		NOP
		NOP
		NOP
		NOP
		M16			; memory 16bit mode
		LDA	4216H
		XBA
		M8			; memory 8bit mode
		AND	#00FH
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINMIN ( WORLD 6 _o main move )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINMIN		EQU	$
		MI8			; memory,index 8bit mode !!
;
		LDA	ENWRK0
		BEQ	COMN010		; ͌ݓĂH
;					: yes
		JSR	EGGMOVE
		BRA	COMN090
;
COMN010		EQU	$
;
;=====[ fobOp ]==============================================
;;;;;	LDA	TRCOIN
;;;;;	CMP	#14
;;;;;	BNE	COMN020
;;;;;;
;;;;;	LDA	#BS6MP
;;;;;	STA	BONSMD
;;;;;	LDA	#0FFH
;;;;;	STA	BONSTM
;;;;;	BRA	COMN090
;=================================================================
;
		LDA	TRCOIN
		CMP	#002
		BNE	COMN020		; Q߁H
;					: yes
;
		JSR	COINEND		; I`FbN
		BRA	COMN090
;
COMN020		EQU	$
		JSR	COINCMV		; J[\lnud
		JSR	COINKEY		; `FbN
		JSR	CARDOAM		; J[\n`l Zbg
;
COMN090		EQU	$
		MI16			; memory,index 16bit mode !!
;
		RTS
;
;
		MEM8
		IDX8
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINEND ( WORLD 6 _o I`FbN )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINEND		EQU	$
		LDA	SLCOIN
		CMP	#(014-2)/2
		BNE	COED020		; J[hS߂H
;					: yes
;[1995/05/03]		     LDA     !COINCDT+7
		LDA	#010
		STA	TUGIYP		; lZbg
		LDA	#005H
		STA	<SOUND_0	; [] TEhZbg
		LDA	#090H
		STA	BONSTM		; timer set
;
		MI16
		INC	SLCOIN
		JSR	TOTALCS		; g[^yAZbg
;
		BRA	COED027
;
;
;=====< yA`FbN >===============================================
;
COED020		EQU	$
		MI8
		LDA	SHINNUM+0
		CMP	SHINNUM+2
		BNE	COED030
;
;--------[ IyA ]-----------------------------------------
;
		LDA	SLCOIN
		CMP	#(012-2)/2
		BNE	COED025		; cQH
;					: yes
;
		JSR	PL50UPST	; TOZbg
;
COED025		EQU	$
		LDA	#0FFH
		LDX	SHINPOS+0
		STA	COINTBL,X
		LDX	SHINPOS+2
		STA	COINTBL,X
;
		MI16
		INC	SLCOIN
;
 IF  NES  ;**** NES Ή [1995/07/26] *****************************
		LDA	SLCOIN
		CMP	#00002
		BNE	COED026
;
		JSR	PAIRSSET	; PAIR'S' Zbg
;
COED026		EQU	$
;
 ENDIF    ;**** NES Ή [1995/07/26] *****************************
;
 IF  PAL  ;**** PAL Ή [1995/07/26] *****************************
		LDA	LNGG_SL
		CMP	#00002
		BEQ	COED026		; hCcH
;					: No !!
		LDA	SLCOIN
		CMP	#00002
		BNE	COED026
;
		JSR	PAIRSSET	; PAIR'S' Zbg
;
COED026		EQU	$
;
 ENDIF    ;**** PAL Ή [1995/07/26] *****************************
;
		JSR	TOTALCS		; g[^yAZbg
;
		LDA	SHINNUM+0
		AND	#000FFH
;[1995/05/03]		     TAX
;[1995/05/03]		     LDA     !COINCDT,X
;[1995/05/03]		     AND     #000FFH
;[1995/05/03]		     STA     TUGIYP	     ; lZbg
;
		TAX
		LDA	!ITEMADR,X
		AND	#000FFH
;
		JSR	ITEMINPUT	; ACe̓o^
;
		LDA	#000FFH
		STA	SHINNUM+0	; yAe[uENA
		STA	SHINNUM+2
;
		LDA	#0008FH
		JSL	>SOUND_3_ON	; [] TEhZbg
		LDA	#00090H
		STA	BONSTM		; timer set
;
COED027		EQU	$
		LDA	#YYORO		; bV[
		STA	BONSMD		; next mode
		LDX	#PYORO
		STX	BSPLTP		; player type set !!
		BRA	COED040
;
;--------[ cOAnY ]-----------------------------------------
;
COED030		EQU	$
		MI16
		INC	KAMMD0
		LDA	KAMMD0
		CMP	#002
		BNE	COED035		; Q͂ꂽH
;					: Yes
		LDA	#0007DH
		JSL	>SOUND_3_ON	; [] TEhZbg
;
		LDA	#BS6MP
		BRA	COED037
;
COED035		EQU	$
		LDA	#00090H
		JSL	>SOUND_3_ON	; [] TEhZbg
;
		LDA	#YKANA		; bV[߂
COED037		EQU	$
		STA	BONSMD		; next mode
		LDA	#080H
		STA	BONSTM		; timer set
;
		LDX	#PTAOR
		STX	BSPLTP		; player type set !!
;
COED040		EQU	$
		LDA	!PLTRNAR,X
;?????		STA	PLWALK		; paturn No. set !!
		JSR	PAS050
		MI8
;
COED090		EQU	$
		RTS
;
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/07/26] ************************
;
		MEM16
		IDX16
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PAIRSSET ( WORLD 6 _o PAIR'S' set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
S_chr_high	EQU	000AFH | 00001100B << 8
S_chr_low	EQU	000BFH | 00001100B << 8
;
PAIRSSET	EQU	$
		LDA	>VRAMD
		TAX
		LDA	#00213H+bg1_adrs
		STA	>VRAMD+02H,X
		LDA	#08000H+00002H*2-1
		STA	>VRAMD+04H,X
		LDA	#S_chr_high
		STA	>VRAMD+06H,X
		LDA	#S_chr_low
		STA	>VRAMD+08H,X
		LDA	#0FFFFH
		STA	>VRAMD+0AH,X
		TXA
		CLC
		ADC	#00008H
		STA	>VRAMD
		RTS
;
		MEM8
		IDX8
;
 ENDIF    ;**** NES or PAL Ή [1995/07/26] *****************************
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	   JSR	   PL50UPST ( WORLD 6 _o POZbg )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PL50UPST   EQU	   $
	   LDX	   #014-1
PLUP010		   EQU	   $
	   CPX	   SHINPOS+0
	   BEQ	   PLUP020
	   CPX	   SHINPOS+2
	   BEQ	   PLUP020
;
	   LDA	   COINTBL,X
	   CMP	   #0FFH
	   BEQ	   PLUP020	   ; cQ̂PH
;				   : Yes
;[1995/05/04];		LDA	#007
	   LDA	   #card_10up
	   STA	   COINTBL,X	   ; POZbg
;
PLUP020		   EQU	   $
	   DEX
	   BPL	   PLUP010
;
	   RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINCMV ( WORLD 6 _o cursole move )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINXDT		EQU	$
		BYTE	030H+8,050H+8,070H+8,090H+8,0B0H+8
		BYTE	020H+8,040H+8,0A0H+8,0C0H+8
		BYTE	030H+8,050H+8,070H+8,090H+8,0B0H+8
;
COINYDT		EQU	$
		BYTE	058H,058H,058H,058H,058H
		BYTE	078H,078H,078H,078H
		BYTE	098H,098H,098H,098H,098H
;
COINADD		EQU	$
		HEX	002,0FE
;
;
COINCMV		EQU	$
		LDX	COINPT
		LDA	CARDMV
		BEQ	COCM090		; J[\ Ă ?
;					: yes
		CMP	#003
		BCS	COCM050
;
;-----<  lnud >----------------------------------------------------
;
		LDA	!COINXDT,X
		CMP	CRCXPS
		BEQ	COCM080		; move end ?
;					: no
		LDA	CARDMV
		AND	#001
		TAX
		LDA	!COINADD,X
		CLC
		ADC	CRCXPS
		STA	CRCXPS
		BRA	COCM090
;
;-----< c lnud >----------------------------------------------------
;
COCM050		EQU	$
		LDA	CRCYPS
		CMP	!COINYDT,X
		BEQ	COCM080		; move end ?
;					: no
		LDA	CARDMV
		AND	#001
		TAX
		LDA	!COINADD,X
		CLC
		ADC	CRCYPS
		STA	CRCYPS
;
		LDA	CONXSD
		CLC
		ADC	CRCXPS
		STA	CRCXPS
		BRA	COCM090
;
;-----< tO NA >--------------------------------------------------
;
COCM080		EQU	$
		STZ	CARDMV
;
;------------------------------------------------------------------------
;
COCM090		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINKEY ( WORLD 6 _o key check )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
;	<<  e[uɂ "COINPT"  >>
;
;		  
;		  OPQRS
;		
;		TU  	VW
;		
;		  X`abc
;		  
;
;========================================================================
;
COYNXUP		EQU	$		;  x |WV
		HEX	9,A,B,C,D
		HEX	0,1,3,4
		HEX	5,6,2,7,8
;					;  x |WV
COYNXDN		EQU	$
		HEX	5,6,B,7,8
		HEX	9,A,C,D
		HEX	0,1,2,3,4
;
COYNXUS		EQU	$		;  w Xs[h
		HEX	00,00,00,00,00
		HEX	01,01,FF,FF
		HEX	FF,FF,00,01,01
;					;  w Xs[h
COYNXDS		EQU	$
		HEX	FF,FF,00,01,01
		HEX	01,01,FF,FF
		HEX	00,00,00,00,00
;
ONECONT		EQU	$
		HEX	0FF,001
;
;
;
COINKEY		EQU	$
		LDA	CARDMV
		BEQ	COKY005		; J[\ Ă ?
;					: yes
COKY002		EQU	$
		RTS
;
;
COKY005		EQU	$
		LDA	KEYA2
		AND	#11000000B
		BNE	COKY006		; (B),(Y) key on ?
;					: yes
		LDA	KEYA2L
		AND	#10000000B
		BEQ	COKY010		; (A) key on ?
;					: yes
COKY006		EQU	$
		JMP	COINPSH		; x{^nm
;
;
COKY010		EQU	$
		LDA	KEYA2
		AND	#00001111B
		BEQ	COKY002		; (+) key on ?
;					; yes
		AND	#00000011B
		BEQ	COKY020		; Left or Right ?
;					: yes
;
;-----< EE >---------------------------------------------------------
;
		AND	#00000001B
		TAX
		LDA	COINPT
		CLC
		ADC	!ONECONT,X
		STA	COINPT
;
		CPX	#000
		BNE	COKY015
;
; ----------- [  ] -----------
;
		CMP	#0FFH
		BNE	COKY012		; before "0" ?
;					: yes
		LDA	#00DH
		STA	COINPT
		BRA	COKY050
;
COKY012		EQU	$
		CMP	#004
		BEQ	COKY050		; before "5" ?
		CMP	#008
		BEQ	COKY050		; before "9" ?
		LDX	#000
		BRA	COKY060
;
; ----------- [ E ] -----------
;
COKY015		EQU	$
		CMP	#00EH
		BNE	COKY017		; before "D" ?
;
		LDA	#000
		STA	COINPT
		BRA	COKY050
;
COKY017		EQU	$
		CMP	#005
		BEQ	COKY050		; before "4" ?
		CMP	#009
		BEQ	COKY050		; before "8" ?
		LDX	#001
		BRA	COKY060
;
;
;-----< E >---------------------------------------------------------
;
COKY020		EQU	$
		LDA	KEYA2
		AND	#00001000B
		BEQ	COKY025
;
; ----------- [  ] -----------
;
		LDX	COINPT
		LDA	!COYNXUS,X
		STA	CONXSD		; X speed
		LDA	!COYNXUP,X
		STA	COINPT		; next point
;
		CPX	#005
		BCC	COKY050		; before "0"`"4" ?
;					: no
		LDX	#002
		BRA	COKY060
;
; ----------- [  ] -----------
;
COKY025		EQU	$
		LDX	COINPT
		LDA	!COYNXDS,X
		STA	CONXSD		; X speed
		LDA	!COYNXDN,X
		STA	COINPT		; next point
;
		CPX	#009
		BCS	COKY050		; before "9"`"D" ?
;					: no
		LDX	#003
		BRA	COKY060
;
;-----< |WV Zbg >--------------------------------------------
;
COKY050		EQU	$
		TAX
		LDA	!COINXDT,X
		STA	CRCXPS		; (X) pos reset !!
		LDA	!COINYDT,X
		STA	CRCYPS		; (Y) pos reset !!
		BRA	COKY070
;
;-----< tOZbg >---------------------------------------------------
;
COKY060		EQU	$
		INX
		STX	CARDMV		; move flag set !!
;
;-----<  TEhZbg >----------------------------------------------
;
COKY070		EQU	$
		LDA	#05CH
		JSL	>SOUND_3_ON	; [] TEhZbg
;
;-------------------------------------------------------------------------
;
COKY090		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINPSH ( WORLD 6 _o x{^nm )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINPSH		EQU	$
		LDX	COINPT
		LDY	COINTBL,X
		CPY	#0FFH
		BEQ	COPH005		; A߂ĂH
;					: yes
		LDA	TRCOIN
		AND	#001
		BEQ	COPH010
		CPX	SHINPOS+0
		BNE	COPH010		; Pڂɂ߂H
;					: yes
COPH005		EQU	$
		RTS
;
;
COPH010		EQU	$
		STY	CARDNUM		; J[h̎
;;;;;;;		LDA	#0FFH
;;;;;;;		STA	COINTBL,X
;
		LDA	TRCOIN
		AND	#001
		ASL	A
		TAX
		TYA
		STA	SHINNUM,X	; J[h̎ށiZ[upj
		LDA	COINPT
		STA	SHINPOS,X	; J[ḧʒuiZ[upj
		INC	TRCOIN
;
		LDA	#001
		STA	ENWRK0		; [V [h
		JSR	EGG_KAMAE	;  CjVi܂j
;
		MEM16
		IDX16
;
;;;;;;;;		MI16			; memory index 16bit mode
;
;;;;;;;		JSR	COINRIT		; _o initial set
;
;[1994/09/01]		LDA	#TN01
;[1994/09/01]		STA	PLPATN		; player paturn set !!
;[1994/09/01]		LDA	#00002
;[1994/09/01]		STA	BSPLTP		; player type set !!
;[1994/09/01]		LDA	#00000
;[1994/09/01]		STA	PLWALK		; paturn No. set !!
		MI16
		LDX	#PNAGE
		STX	BSPLTP		; player type set !!
		LDA	!PLTRNAR,X
;?????		STA	PLWALK		; paturn No. set !!
		JSR	PAS050
		MI8
;
		INC	BONSMD		; next mode
;
		MI8			; memory index 8bit mode
;
		RTS
;
;
		MEM16
		IDX16
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINRIT ( WORLD 6 _o initial )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINADR		EQU	$
		WORD	00166H+bg1_adrs+1,0016AH+bg1_adrs+1	; P
		WORD	0016EH+bg1_adrs+1,00172H+bg1_adrs+1
		WORD	00176H+bg1_adrs+1
;
		WORD	001E4H+bg1_adrs+1,001E8H+bg1_adrs+1	; Q
		WORD	001F4H+bg1_adrs+1,001F8H+bg1_adrs+1
;
		WORD	00266H+bg1_adrs+1,0026AH+bg1_adrs+1	; R
		WORD	0026EH+bg1_adrs+1,00272H+bg1_adrs+1
		WORD	00276H+bg1_adrs+1
;
omote_coin	EQU	00012*11+0		; J[h\
;
;[1995/05/04];COINDAT	      EQU     $
;[1995/05/04];		      BYTE    00012*11+1	      ; wCz[
;[1995/05/04];		      BYTE    00012*11+2	      ; ǂڂ
;[1995/05/04];		      BYTE    00012*11+3	      ; 
;[1995/05/04];		      BYTE    00012*11+4	      ; X^[
;[1995/05/04];		      BYTE    00012*11+5	      ; ܂
;[1995/05/04];		      BYTE    00012*11+6	      ; }I
;[1995/05/04];		      BYTE    00012*11+7	      ; RC
;[1995/05/04];		      BYTE    00012*11+8	      ; bV[
;[1995/05/04];;
;[1995/05/04];COINBKD	      EQU     $
;[1995/05/04];		      HEX     11,11,11,11,15,15,15,15
;[1995/05/04];;
;[1995/05/04];card_00	      EQU     00109H+00C00H	      ; wCz[
;[1995/05/04];card_01	      EQU     card_00+9		      ; ǂڂ
;[1995/05/04];card_02	      EQU     card_01+9		      ; 
;[1995/05/04];card_03	      EQU     card_02+9		      ; X^[
;[1995/05/04];card_04	      EQU     card_03+9		      ; ܂
;[1995/05/04];card_05	      EQU     card_04+9		      ; }I
;[1995/05/04];card_06	      EQU     card_05+9		      ; RC
;[1995/05/04];card_07	      EQU     card_06+9		      ; bV[
;[1995/05/04];card_08	      EQU     00100H+00C00H	      ; bV[ij
;[1995/05/04];;
;[1995/05/04];COINBCH	      EQU     $
;[1995/05/04];		      WORD    card_00+0,card_00+1,card_00+2   ; wCz[
;[1995/05/04];		      WORD    card_00+3,card_00+4,card_00+5
;[1995/05/04];		      WORD    card_00+6,card_00+7,card_00+8
;[1995/05/04];;
;[1995/05/04];		      WORD    card_01+0,card_01+1,card_01+2   ; ǂڂ
;[1995/05/04];		      WORD    card_01+3,card_01+4,card_01+5
;[1995/05/04];		      WORD    card_01+6,card_01+7,card_01+8
;[1995/05/04];;
;[1995/05/04];		      WORD    card_02+0,card_02+1,card_02+2   ; 
;[1995/05/04];		      WORD    card_02+3,card_02+4,card_02+5
;[1995/05/04];		      WORD    card_02+6,card_02+7,card_02+8
;[1995/05/04];;
;[1995/05/04];		      WORD    card_03+0,card_03+1,card_03+2   ; X^[
;[1995/05/04];		      WORD    card_03+3,card_03+4,card_03+5
;[1995/05/04];		      WORD    card_03+6,card_03+7,card_03+8
;[1995/05/04];;
;[1995/05/04];		      WORD    card_04+0,card_04+1,card_04+2   ; ܂
;[1995/05/04];		      WORD    card_04+3,card_04+4,card_04+5
;[1995/05/04];		      WORD    card_04+6,card_04+7,card_04+8
;[1995/05/04];;
;[1995/05/04];		      WORD    card_05+0,card_05+1,card_05+2   ; }I
;[1995/05/04];		      WORD    card_05+3,card_05+4,card_05+5
;[1995/05/04];		      WORD    card_05+6,card_05+7,card_05+8
;[1995/05/04];;
;[1995/05/04];		      WORD    card_06+0,card_06+1,card_06+2   ; RC
;[1995/05/04];		      WORD    card_06+3,card_06+4,card_06+5
;[1995/05/04];		      WORD    card_06+6,card_06+7,card_06+8
;[1995/05/04];;
;[1995/05/04];		      WORD    card_07+0,card_07+1,card_07+2   ; bV[
;[1995/05/04];		      WORD    card_07+3,card_07+4,card_07+5
;[1995/05/04];		      WORD    card_07+6,card_07+7,card_07+8
;[1995/05/04];;
;[1995/05/04];		      WORD    card_08+0,card_08+1,card_08+2   ; bV[ij
;[1995/05/04];		      WORD    card_08+3,card_08+4,card_08+5
;[1995/05/04];		      WORD    card_08+6,card_08+7,card_08+8
;
;
COINRIT		EQU	$
		LDA	COINPT
		AND	#000FFH
		ASL	A
		TAX
		LDA	#00003H
		STA	<WORKE
		LDY	!COINADR,X
CORT010		EQU	$
		PHY
		LDA	#BANK CLEARCARD
		STA	<WORK1
		LDX	#CLEARCARD
		LDA	#00006H
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		DEC	<WORKE
		BNE	CORT010
;
		LDA	#COINATR
		STA	<WORK0		; char number, attribute
;
		JSR	COINOST		; OAM set
;
		STZ	OPENCNT
;
		LDA	#omote_coin
		LDX	#00015H
		JMP	CARDOPEN
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINRMV1 ( WORLD 6 _o \ )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
shin_open_sped	WORD	00008H		; Q[
		WORD	00010H		; f
;
COINRMV1	EQU	$
		JSR	EGGMOVE		;  lnud
;
COINRMV10	EQU	$
		LDX	#00000
		LDA	BONSMD
		CMP	#CR10M
		BNE	CORM001		; fEnodmH
;					: Yes
		INX
		INX
CORM001		EQU	$
		LDA	OPENCNT
		CLC
		ADC	!shin_open_sped,X
		STA	OPENCNT
		CMP	#00080H
		BMI	CORM010
;
		INC	BONSMD		; next mode
		RTS
;
CORM010		EQU	$
		LDA	#COINATR
		STA	<WORK0		; char number, attribute
;
		JSR	COINOST		; OAM set
;
		LDA	#omote_coin
		LDX	#00015H
		JMP	CARDOPEN
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINRMV2 ( WORLD 6 _o  )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINRMV2	EQU	$
		JSR	EGGMOVE		;  lnud
;
COINRMV20	EQU	$
		LDX	#00000
		LDA	BONSMD
		CMP	#CR20M
		BNE	CORM2001	; fEnodmH
;					: Yes
		INX
		INX
CORM2001	EQU	$
		LDA	OPENCNT
		SEC
		SBC	!shin_open_sped,X
		STA	OPENCNT
		BPL	CORM2050	; turn end ?
;					: yes
		LDA	COINPT
		AND	#000FFH
		ASL	A
		TAX
		LDY	COINADR,X
		LDA	CARDNUM
		AND	#000FFH
		ASL	A
		STA	<WORK0
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	<WORK0
		CLC
;[1995/05/03]		ADC	#COINBCH
		ADC	#CARDBGCHR
		TAX
		LDA	#00003H
		STA	<WORKE
;[1995/05/03]		LDA	#BANK COINBCH
		LDA	#BANK CARDBGCHR
		STA	<WORK1
CORM2010	EQU	$
		LDA	#0006H
		PHX
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		PLA
		CLC
		ADC	#00006H
		TAX
		DEC	<WORKE
		BNE	CORM2010	; coin clear end ?
;					: Yes
		LDA	BONSMD
		CMP	#CR20M
		BEQ	CORM2020	; Q[vCE[hH
;					: Yes
		LDA	#COINM
		BRA	CORM2030
;
CORM2020	EQU	$
		INC	COINPT		; next point
		LDA	#CRALL		; SJ[h]E[h
;
CORM2030	EQU	$
		STA	BONSMD		; next mode
		RTS
;
;
CORM2050	EQU	$
		LDA	!CARDNUM
		AND	#000FFH
		CLC
		ADC	#CARDATTRDTURA
		STA	<WORK0		; attribute data address
;
		JSR	COINOST		; OAM set
;
		LDA	CARDNUM
		AND	#000FFH
		TAY
;[1995/05/03]		     LDA     !COINBKD,Y
;[1995/05/03]		     AND     #000FFH
;[1995/05/03]		     TAX
;[1995/05/03]		     LDA     COINDAT,Y
		LDX	#00011H
		LDA	!CARDDATA,Y
		AND	#000FFH
		JMP	CARDOPEN
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	COINOST ( WORLD 6 _o n`l  )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COINOXD		EQU	$
		BYTE	030H+4,050H+4,070H+4,090H+4,0B0H+4
		BYTE	020H+4,040H+4,0A0H+4,0C0H+4
		BYTE	030H+4,050H+4,070H+4,090H+4,0B0H+4
;
COINOYD		EQU	$
		BYTE	058H-4,058H-4,058H-4,058H-4,058H-4
		BYTE	078H-4,078H-4,078H-4,078H-4
		BYTE	098H-4,098H-4,098H-4,098H-4,098H-4
;
COINATR		EQU	$
		BYTE	00110010B	; CjV
		BYTE	00110010B	; \
		BYTE	00110010B	; 
;
;
COINOST		EQU	$
		LDA	COINPT
		AND	#000FFH
		TAX
		CLC
		ADC	#COINOXD
		STA	<WORK2		; X position
		TXA
		CLC
		ADC	#COINOYD
		STA	<WORK4		; Y position
;[1995/02/23]		LDA	BONSMD
;[1995/02/23]		SEC
;[1995/02/23]		SBC	#EGGMV
;[1995/02/23]		CLC
;[1995/02/23]		ADC	#COINATR
;[1995/06/07]		STA	<WORK0		; char number, attribute
;
		JSR	CARDOAMSET	; OAM set (by. Mt.T)
;
		RTS
;
;
;========================================================================
;
;;;COINOST		EQU	$
;;;		LDY	OAMIDX
;;;;
;;;		LDA	CRCXPS
;;;		SEC
;;;		SBC	#00004H
;;;		AND	#000FFH
;;;		STA	SOAM_DX,Y
;;;		STA	SOAM_DX+16,Y
;;;		CLC
;;;		ADC	#00010H
;;;		STA	SOAM_DX+8,Y
;;;		STA	SOAM_DX+24,Y
;;;;
;;;		LDA	CRCYPS
;;;		SEC
;;;		SBC	#00004H
;;;		AND	#000FFH
;;;		STA	SOAM_DX+2,Y
;;;		STA	SOAM_DX+8+2,Y
;;;		CLC
;;;		ADC	#00010H
;;;		STA	SOAM_DX+16+2,Y
;;;		STA	SOAM_DX+24+2,Y
;;;;
;;;		LDA	#001E8H
;;;		STA	!SOAM_DX+4,Y
;;;		INC	A
;;;		INC	A
;;;		STA	!SOAM_DX+8+4,Y
;;;		INC	A
;;;		INC	A
;;;		STA	!SOAM_DX+16+4,Y
;;;		INC	A
;;;		INC	A
;;;		STA	!SOAM_DX+24+4,Y
;;;;
;;;		LDA	#00002H
;;;		STA	SOAM_DX+6,Y
;;;		STA	SOAM_DX+8+6,Y
;;;		STA	SOAM_DX+16+6,Y
;;;		STA	SOAM_DX+24+6,Y
;;;;
;;;		TYA
;;;		CLC
;;;		ADC	#00008*4
;;;		STA	OAMIDX
;;;;
;;;		RTS
;;;;
;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	TOTALCS ( WORLD 6 _o total pair set )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
TOTALCS		EQU	$
;
;-----< q`l Zbg >--------------------------------------------------
;
		LDX	#00000
		LDA	SLCOIN
;
		LDY	#00000
;
TOCS010		EQU	$
		CMP	#00010
		BCC	TOCS020		; coin counter >= "10" ?
;					; Yes !!
		SBC	#00010
		INY
		BRA	TOCS010
;
TOCS020		EQU	$
		STA	<WORK0		; P̈
		STY	<WORK2		; PÖ
;
;-----< uq`lc Zbg >---------------------------------------------
;
		LDA	>VRAMD
		TAX
;
		LDA	#0020EH+bg1_adrs
		STA	>VRAMD+2,X
		CLC
		ADC	#00020H
		STA	>VRAMD+10,X
;
		LDA	#00002H*2-1
		STA	>VRAMD+4,X
		STA	>VRAMD+12,X
;
		PHX			; (X) push
;
		LDA	#00002
		STA	<WORK4
;
		LDA	<WORK2
		BNE	TOCS060		; PÖ "O" H
;					: yes
		LDA	#nuki_chr
		STA	>VRAMD+6,X
		BRA	TOCS070
;
TOCS050		EQU	$
		LDA	<WORK0
TOCS060		EQU	$
		ASL	A
		TAY
		LDA	!NUMBERHIGH,Y
		ORA	#00C00H
		STA	>VRAMD+6,X
		LDA	!NUMBERLOW,Y
		ORA	#00C00H
TOCS070		EQU	$
		STA	>VRAMD+14,X
		INX
		INX
		DEC	<WORK4
		DEC	<WORK4
		BPL	TOCS050
;
		PLX			; (X) pull
;
		LDA	#0FFFFH
		STA	>VRAMD+18,X
;
		TXA
		CLC
		ADC	#00016
		STA	>VRAMD
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	YSYORMOV ( WORLD 6 _o bV[ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
YSYORMOV	EQU	$
		LDA	BONSTM
		BEQ	YSYR010		; timer "0" ?
;					: No
		DEC	BONSTM
		BRA	YSYR090
;
YSYR010		EQU	$
		LDA	TUGIYP
		BNE	YSYR020		; ltoIH
;					: Yes
		LDA	CARDNUM
		AND	#000FFH
;[1995/05/04]		     CMP     #00007
		CMP	#card_10up
		BNE	YSYR015		; p[tFNgH
;					: Yes
		LDA	#00080H
		STA	BONSTM		; timer set
		LDA	#BS6MP
		STA	BONSMD		; next mode
		BRA	YSYR090
;
YSYR015		EQU	$
		LDA	PLJUMP
		BNE	YSYR090		; vC[WvnH
;					: Yes
		STZ	TRCOIN
		LDX	#PWALK
		STX	BSPLTP
		LDA	!PLTRNAR,X
		JSR	PAS050
		LDA	#COINM
		STA	BONSMD		; next mode
		BRA	YSYR090
;
YSYR020		EQU	$
;[1995/05/04]		     LDA     CARDNUM
;[1995/05/04]		     AND     #000FFH
;[1995/05/04]		     CMP     #00007
;[1995/05/04]		     BNE     YSYR030	     ; POH
;[1995/05/04];					     : Yes
;[1995/05/04]		     LDA     TUGIYP
;[1995/05/04]		     SEC
;[1995/05/04]		     SBC     #00010
;[1995/05/04]		     STA     TUGIYP
;[1995/05/04]		     LDA     PLCONT
;[1995/05/04]		     CLC
;[1995/05/04]		     ADC     #00010
;[1995/05/04]		     STA     PLCONT
;[1995/05/04]		     BRA     YSYR040
;
YSYR030		EQU	$
		DEC	TUGIYP
		INC	PLCONT
;
YSYR040		EQU	$
		LDA	#00008H
		JSL	>SOUND_3_ON	; [] TEhZbg
;
		JSR	PLCNTST		; lto
		LDA	#00030H
		STA	BONSTM		; timer set
;
YSYR090		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	YSKANMOV ( WORLD 6 _o bV[߂ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
YSKANMOV	EQU	$
		LDA	BONSTM
		BEQ	YSKN010		; timer "0" ?
;					: No
		DEC	BONSTM
		BRA	YSKN090
;
YSKN010		EQU	$
		DEC	TRCOIN
		BMI	YSKN020		; J[hԂIH
;					: No
;
		LDA	#00050H
		JSL	>SOUND_3_ON	; [] TEhZbg
		INC	BONSMD		; next mode
		BRA	YSKN090
;
YSKN020		EQU	$
		STZ	TRCOIN
		LDX	#PWALK
		STX	BSPLTP
		LDA	!PLTRNAR,X
		JSR	PAS050
		LDA	#COINM
		STA	BONSMD		; next mode
;
YSKN090		EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDRTIN ( WORLD 6 _o J[h߂ init )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CARDRTIN	EQU	$
		LDA	TRCOIN
		AND	#000FFH
		ASL	A
		TAX
		LDA	SHINPOS,X
		AND	#000FFH
		ASL	A
		TAX
		LDA	#00003H
		STA	<WORKE
		LDY	!COINADR,X
CARDIN010	EQU	$
		PHY
		LDA	#BANK CLEARCARD
		STA	<WORK1
		LDX	#CLEARCARD
		LDA	#00006H
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		DEC	<WORKE
		BNE	CARDIN010
;
		LDA	TRCOIN
		AND	#000FFH
		ASL	A
		TAX
		LDA	SHINNUM,X
		AND	#000FFH
		CLC
		ADC	#CARDATTRDTURA
		STA	<WORK0		; char number, attribute
;
		JSR	CRRTOST		; OAM set
;
		STZ	OPENCNT
;
		LDA	TRCOIN
		AND	#000FFH
		ASL	A
		TAX
		LDA	SHINNUM,X
		AND	#000FFH
		TAY
;[1995/05/03]		     LDA     !COINBKD,Y
;[1995/05/03]		     AND     #0FFFFH
;[1995/05/03]		     TAX
;[1995/05/03]		     LDA     !COINDAT,Y
		LDX	#00011H
		LDA	!CARDDATA,Y
		AND	#000FFH
		JSR	CARDOPEN
;
		INC	BONSMD		; next mode
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDRTN1 ( WORLD 6 _o J[h߂ \ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
shin_retrn_sped WORD	00018H		; Q[
		WORD	00010H		; f
;
CARDRTN1	EQU	$
		LDX	#00000
		LDA	BONSMD
		CMP	#CRRT1
		BEQ	CRRT1000	; fEnodmH
;					: Yes
		INX
		INX
CRRT1000	EQU	$
		LDA	!OPENCNT
		CLC
		ADC	!shin_retrn_sped,X
		STA	OPENCNT
		CMP	#00080H
		BMI	CRRT1010	; ]H
;					: Yes
;
		INC	!BONSMD		; next mode
		RTS
;
;
CRRT1010	EQU	$
		LDA	TRCOIN
		AND	#000FFH
		ASL	A
		TAX
		LDA	SHINNUM,X
		AND	#000FFH
		CLC
		ADC	#CARDATTRDTURA
		STA	<WORK0		; char number, attribute
;
		JSR	CRRTOST		; OAM set
;
		LDA	TRCOIN
		AND	#000FFH
		ASL	A
		TAX
		LDA	SHINNUM,X
		AND	#000FFH
		TAY
;[1995/05/03]		     LDA     !COINBKD,Y
;[1995/05/03]		     AND     #0FFFFH
;[1995/05/03]		     TAX
;[1995/05/03]		     LDA     !COINDAT,Y
		LDX	#00011H
		LDA	!CARDDATA,Y
		AND	#000FFH
		JMP	CARDOPEN
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDRTN2 ( WORLD 6 _o J[h߂  )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CARDRTN2	EQU	$
		LDX	#00000
		LDA	BONSMD
		CMP	#CRRT2
		BEQ	CRRT2000	; fEnodmH
;					: Yes
		INX
		INX
CRRT2000	EQU	$
		LDA	!OPENCNT
		SEC
		SBC	!shin_retrn_sped,X
		STA	!OPENCNT
		BPL	CRRT2020	; J[h]IH
;					: Yes
		LDA	TRCOIN
		AND	#000FFH
		ASL	A
		TAX
		LDA	SHINPOS,X	; card address number load !!
		AND	#000FFH
		ASL	A
		TAX
		LDY	COINADR,X
;[1995/05/03]		     LDA     #00008*9*2	     ; J[hmDŒmbV[n
		LDA	#0000CH*9*2	 ; J[hmDŒmbV[n
		CLC
;[1995/05/03]		     ADC     #COINBCH
		ADC	#CARDBGCHR
		TAX
		LDA	#00003H
		STA	<WORKE
CRRT2010	EQU	$
;[1995/05/03]		     LDA     #BANK COINBCH
		LDA	#BANK CARDBGCHR
		STA	<WORK1
		LDA	#0006H
		PHX
		PHY
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		PLA
		CLC
		ADC	#00006H
		TAX
		DEC	<WORKE
		BNE	CRRT2010	; card clear end ?
;
		LDA	BONSMD
		CMP	#CRRT2
		BNE	CRRT2015	; J[h߂inYjH
;					: Yes
		LDA	TRCOIN
		AND	#000FFH
		ASL	A
		TAX
		LDA	!URATIME,X
		STA	BONSTM		; timer set
		LDA	#YKANA
		BRA	CRRT2017
;
CRRT2015	EQU	$
;[1995/04/28]		LDA	#change_time
;[1995/04/28]		STA	BONSTM		; timer set
;[1995/04/28]		LDA	#CRINT
		INC	COINPT		; ߂JE^[
		LDA	#CRALR
CRRT2017	EQU	$
		STA	!BONSMD		; next mode
		RTS
;
;
;
CRRT2020	EQU	$
		LDA	#COINATR
		STA	<WORK0		; char number, attribute
;
		JSR	CRRTOST		; OAM set
;
		LDA	#omote_coin
		LDX	#00015H
		JMP	CARDOPEN
;
;
URATIME		EQU	$
		WORD	00040H		; Q
		WORD	00010H		; P
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CRRTOST ( WORLD 6 _o J[h߂ OAM set ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CRRTOST		EQU	$
		LDA	TRCOIN
		AND	#000FFH
		ASL	A
		TAX
		LDA	SHINPOS,X
		AND	#000FFH
		TAX
		CLC
		ADC	#COINOXD
		STA	<WORK2		; X position
		TXA
		CLC
		ADC	#COINOYD
		STA	<WORK4		; Y position
;[1995/02/27]		LDA	BONSMD
;[1995/02/27]		SEC
;[1995/02/27]		SBC	#CRTIN
;[1995/02/23]		CLC
;[1995/02/23]		ADC	#COINATR
;[1995/06/08]		STA	<WORK0		; char number, attribute
;
		JSR	CARDOAMSET	; OAM set (by. Mt.T)
;
		RTS
;
;
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28];x		JSR	CARDCMOV ( WORLD 6 _o ւ move )	x
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28]change_count	EQU	00003H		; ւJEg
;[1995/04/28];
;[1995/04/28]CARDCMOV	EQU	$
;[1995/04/28]		DEC	BONSTM
;[1995/04/28]		BNE	CRCMV090	; timer "0"
;[1995/04/28];					: yes
;[1995/04/28]		LDA	TURNCNT
;[1995/04/28]		CMP	#00014
;[1995/04/28]		BNE	CRCMV010	; PS߂H
;[1995/04/28];					: Yes
;[1995/04/28];
;[1995/04/28]		JSR	COININT		; q`lZbg
;[1995/04/28];
;[1995/04/28]		LDA	#COINM		; _oQ[X^[g
;[1995/04/28]		STA	BONSMD		; next mode
;[1995/04/28]		BRA	CRCMV090
;[1995/04/28];
;[1995/04/28]CRCMV010	EQU	$
;[1995/04/28]		CMP	#00014-1
;[1995/04/28]		BEQ	CRCMV020	; PR߂H
;[1995/04/28];					: No
;[1995/04/28]		LDA	#000FFH
;[1995/04/28]		STA	CHNGPOS+0
;[1995/04/28]		STA	CHNGPOS+2
;[1995/04/28];
;[1995/04/28]		JSR	CARDCINT	; ւ intial
;[1995/04/28];
;[1995/04/28]		INC	CHNGCNT		; J[hւJE^[
;[1995/04/28]		LDA	CHNGCNT
;[1995/04/28]		CMP	#change_count
;[1995/04/28]		BNE	CRCMV090	; JEgH
;[1995/04/28];					: Yes
;[1995/04/28]		STZ	CHNGCNT
;[1995/04/28];
;[1995/04/28]CRCMV020	EQU	$
;[1995/04/28]		INC	TURNCNT		; ԂJE^[
;[1995/04/28]		LDA	#CRTNM		; ԂE[h
;[1995/04/28]		STA	BONSMD		; next mode
;[1995/04/28];
;[1995/04/28]CRCMV090	EQU	$
;[1995/04/28]		RTS
;[1995/04/28];
;[1995/04/28];
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28];x		JSR	CARDCINT ( WORLD 6 _o ւ initial )	x
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28]change_time	EQU	00010H		; ւ^C}[
;[1995/04/28];
;[1995/04/28];
;[1995/04/28]CARDCINT	EQU	$
;[1995/04/28]		MI8			; memory,index 8bit mode
;[1995/04/28];
;[1995/04/28];-----< J[hւmDZbg >-------------------------------------
;[1995/04/28]CRCNG010	EQU	$
;[1995/04/28]		LDA	#014
;[1995/04/28]		SEC
;[1995/04/28]		SBC	TURNCNT
;[1995/04/28]		STA	<WORK0		; 搔
;[1995/04/28];
;[1995/04/28]		LDA	CHNGPOS+0
;[1995/04/28]		CMP	#0FFH
;[1995/04/28]		BEQ	CRCNG020	; Pڌς݁H
;[1995/04/28];					: Yes
;[1995/04/28];
;[1995/04/28]CRCNG015	EQU	$
;[1995/04/28]		DEC	<WORK0		; 搔|P
;[1995/04/28];
;[1995/04/28]CRCNG020	EQU	$
;[1995/04/28]		JSL	>RANDAM		; _
;[1995/04/28]		JSL	>RANDAM		; _i_uj
;[1995/04/28];
;[1995/04/28]		LDA	<WORK0
;[1995/04/28]		STA	4202H
;[1995/04/28]		LDA	RANDM0		; 搔
;[1995/04/28]		STA	4203H
;[1995/04/28]		NOP
;[1995/04/28]		NOP
;[1995/04/28]		NOP
;[1995/04/28]		NOP
;[1995/04/28]		M16			; memory 16bit mode !!
;[1995/04/28]		LDA	4216H
;[1995/04/28]		XBA
;[1995/04/28]		M8			; memory 8bit mode !!
;[1995/04/28]		AND	#00FH
;[1995/04/28]		STA	<WORK2
;[1995/04/28];
;[1995/04/28]		LDX	CHNGPOS+0
;[1995/04/28]		CPX	#0FFH
;[1995/04/28]		BNE	CRCNG030	; Pڌς݁H
;[1995/04/28];					: No
;[1995/04/28];
;[1995/04/28]		JSR	CTBSERCH	; e[uT[`iPځj
;[1995/04/28]		LDA	COINTBL,X
;[1995/04/28]		STA	CHNGNUM+0	; J[hmD
;[1995/04/28]		STX	CHNGPOS+0	; J[h
;[1995/04/28]		BRA	CRCNG010
;[1995/04/28];
;[1995/04/28]CRCNG030	EQU	$
;[1995/04/28]		JSR	CTBSERCH	; e[uT[`iQځj
;[1995/04/28];
;[1995/04/28]		LDA	COINTBL,X
;[1995/04/28]		CMP	CHNGNUM+0
;[1995/04/28];;;;;;		BEQ	CRCNG015	; PڂƈႤGH
;[1995/04/28];;;;;;;					: Yes
;[1995/04/28]		BNE	CRCNG040   ; PڂƓGH
;[1995/04/28];				   : Yes
;[1995/04/28]		NOP		   ;
;[1995/04/28];?????		BRA	CRCNG015   ; fobOp
;[1995/04/28]		BRA	CRCNG020   ; fobOp
;[1995/04/28];
;[1995/04/28];
;[1995/04/28]CRCNG040  EQU	$
;[1995/04/28];
;[1995/04/28]		STA	CHNGNUM+2	; J[hmD
;[1995/04/28]		STX	CHNGPOS+2	; J[h
;[1995/04/28];
;[1995/04/28];-----< J[hւEe[uZbg >---------------------------------
;[1995/04/28]		LDX	CHNGPOS+2
;[1995/04/28]		LDA	CHNGNUM+0
;[1995/04/28]		STA	COINTBL,X
;[1995/04/28]		LDX	CHNGPOS+0
;[1995/04/28]		LDA	CHNGNUM+2
;[1995/04/28]		STA	COINTBL,X
;[1995/04/28];
;[1995/04/28]		MI16			; memory,index 16bit mode !!
;[1995/04/28];
;[1995/04/28];-----< J[hւEafZbg >-------------------------------------
;[1995/04/28]		JSR	CARDCSET
;[1995/04/28];
;[1995/04/28]		LDA	#0001BH		; #00045H
;[1995/04/28]		JSL	>SOUND_3_ON	; [] TEhZbg
;[1995/04/28];
;[1995/04/28];-----< ^C}[Zbg >-------------------------------------------------
;[1995/04/28]		LDA	#change_time
;[1995/04/28]		STA	BONSTM		; timer set
;[1995/04/28];
;[1995/04/28]		RTS
;[1995/04/28];
;[1995/04/28];
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28];x		JSR	CTBSERCH ( WORLD 6 _o ւ search )	x
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28]CTBSERCH	EQU	$
;[1995/04/28]		MI8			; memory,index 8bit mode !!
;[1995/04/28];
;[1995/04/28]		LDX	#000		; e[u
;[1995/04/28]		LDY	#000		; 󂫃GAJE^[
;[1995/04/28]CTSR010		EQU	$
;[1995/04/28]		CPX	CHNGPOS+0
;[1995/04/28]		BEQ	CTSR020		; ւPڃZbgH
;[1995/04/28];					: No
;[1995/04/28]		LDA	CHNGTBL,X
;[1995/04/28]		CMP	#0FFH
;[1995/04/28]		BEQ	CTSR020		; J[hH
;[1995/04/28];					: No
;[1995/04/28]		CPY	<WORK2
;[1995/04/28]		BEQ	CTSR030		; wmDH
;[1995/04/28];					: No
;[1995/04/28]		INY
;[1995/04/28]CTSR020		EQU	$
;[1995/04/28]		INX
;[1995/04/28]		BRA	CTSR010
;[1995/04/28];
;[1995/04/28]CTSR030		EQU	$
;[1995/04/28]		RTS
;[1995/04/28];
;[1995/04/28];
;[1995/04/28]		MEM16
;[1995/04/28]		IDX16
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28];x		JSR	CARDCSET ( WORLD 6 _o ւ BG set )	x
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28]CARDCSET	EQU	$
;[1995/04/28]		LDA	CHNGNUM+0
;[1995/04/28]		STA	<WORK0
;[1995/04/28]		LDA	CHNGPOS+2
;[1995/04/28]		STA	<WORK2
;[1995/04/28]		JSR	CARDCWRT	; Pځ||Q
;[1995/04/28];
;[1995/04/28]		LDA	CHNGNUM+2
;[1995/04/28]		STA	<WORK0
;[1995/04/28]		LDA	CHNGPOS+0
;[1995/04/28]		STA	<WORK2
;[1995/04/28]		JSR	CARDCWRT	; Qځ||P
;[1995/04/28];
;[1995/04/28]		RTS
;[1995/04/28];
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28];x		JSR	CARDCWRT ( WORLD 6 _o ւ BG write ) x
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28]CARDCWRT	EQU	$
;[1995/04/28]		LDA	<WORK2
;[1995/04/28]		AND	#000FFH
;[1995/04/28]		ASL	A
;[1995/04/28]		TAX
;[1995/04/28]		LDY	COINADR,X
;[1995/04/28]		LDA	<WORK0
;[1995/04/28]		AND	#000FFH
;[1995/04/28]		ASL	A
;[1995/04/28]		STA	<WORK0
;[1995/04/28]		ASL	A
;[1995/04/28]		ASL	A
;[1995/04/28]		ASL	A
;[1995/04/28]		CLC
;[1995/04/28]		ADC	<WORK0
;[1995/04/28]		CLC
;[1995/04/28]		ADC	#COINBCH
;[1995/04/28]		TAX
;[1995/04/28]		LDA	#00003H
;[1995/04/28]		STA	<WORKE
;[1995/04/28]		LDA	#BANK COINBCH
;[1995/04/28]		STA	<WORK1
;[1995/04/28]CRST010		EQU	$
;[1995/04/28]		LDA	#0006H
;[1995/04/28]		PHX
;[1995/04/28]		PHY
;[1995/04/28]		JSL	>VRAMDX_ST
;[1995/04/28];
;[1995/04/28]		PLA
;[1995/04/28]		CLC
;[1995/04/28]		ADC	#00020H
;[1995/04/28]		TAY
;[1995/04/28]		PLA
;[1995/04/28]		CLC
;[1995/04/28]		ADC	#00006H
;[1995/04/28]		TAX
;[1995/04/28]		DEC	<WORKE
;[1995/04/28]		BNE	CRST010		; card set end ?
;[1995/04/28];					: Yes
;[1995/04/28]		RTS
;[1995/04/28];
;[1995/04/28];
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDALLT ( WORLD 6 _o SJ[h] main ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CARDALLT	EQU	$
		LDA	COINPT
		CMP	#00014
		BEQ	CRALL010	; SJ[h]H
;					: No
		LDA	COINPT
		AND	#000FFH
		TAX
		LDA	COINTBL,X
		STA	CARDNUM
;
		JSR	CRALLINT	; J[h]CjV
;
		LDA	#00050H
		JSL	>SOUND_3_ON	; [] TEhZbg
		LDA	#CR10M
		BRA	CRALL020
;
CRALL010	EQU	$
		STZ	COINPT
		LDA	#00040H
		STA	BONSTM		; timer set
;[1995/04/28]		LDA	#CRINT
		LDA	#CRALR
CRALL020	EQU	$
		STA	BONSMD		; next mode
;
CRALL090	EQU	$
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CRALLINT ( WORLD 6 _o SJ[h] init ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CRALLINT	EQU	$
		LDA	COINPT
		AND	#000FFH
		ASL	A
		TAX
		LDA	#00003H
		STA	<WORKE
		LDY	!COINADR,X
CRAIN010	EQU	$
		PHY
		LDA	#BANK CLEARCARD
		STA	<WORK1
		LDX	#CLEARCARD
		LDA	#00006H
		JSL	>VRAMDX_ST
;
		PLA
		CLC
		ADC	#00020H
		TAY
		DEC	<WORKE
		BNE	CRAIN010
;
		LDA	#COINATR
		STA	<WORK0		; char number, attribute
;
		JSR	COINOST		; OAM set
;
		STZ	OPENCNT
;
		LDA	#omote_coin
		LDX	#00015H
		JMP	CARDOPEN
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CARDALLR ( WORLD 6 _o SJ[h߂ main ) x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CARDALLR	EQU	$
		LDA	BONSTM
		BEQ	CRALR005	; EFCgnjH
;					: No
		DEC	BONSTM
		BRA	CRALR090
;
CRALR005	EQU	$
		LDA	COINPT
		CMP	#00014
		BEQ	CRALR010	; SJ[h߂H
;					: No
		LDX	COINPT
		STX	SHINPOS+0	; e[u
		LDA	COINTBL,X
		STA	SHINNUM+0
		STZ	TRCOIN		; CfbNXNA[
;
		JSR	CARDRTIN	; J[h߂CjV
;
		LDA	#00050H
		JSL	>SOUND_3_ON	; [] TEhZbg
;[1995/04/28]		LDA	#CR10M
;[1995/04/28]		BRA	CRALR020
		BRA	CRALR090
;
CRALR010	EQU	$
;[1995/04/28]		LDA	#00040H
;[1995/04/28]		STA	BONSTM		; timer set
;[1995/04/28]		LDA	#CRINT
;
		JSR	COININT		; q`lZbg
;
		LDA	#COINM		; _oQ[X^[g
CRALR020	EQU	$
		STA	BONSMD		; next mode
;
CRALR090	EQU	$
		RTS
;
;
;
;
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28];x		JSR	CARDRTNM ( WORLD 6 _o Ԃ main )	x
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28]CARDRTNM	EQU	$
;[1995/04/28]		MI8			; memory,index 8bit mode
;[1995/04/28];
;[1995/04/28];-----< J[hԂmDZbg >---------------------------------------
;[1995/04/28]		JSL	>RANDAM		; _
;[1995/04/28];
;[1995/04/28]		M8			; memory 8bit mode
;[1995/04/28]		LDA	#014
;[1995/04/28]		SEC
;[1995/04/28]		SBC	TURNCNT
;[1995/04/28]		STA	4202H		; 搔
;[1995/04/28]		LDA	RANDM0
;[1995/04/28]		STA	4203H		; 搔
;[1995/04/28]		NOP
;[1995/04/28]		NOP
;[1995/04/28]		NOP
;[1995/04/28]		NOP
;[1995/04/28]		M16			; memory 16bit mode
;[1995/04/28]		LDA	4216H
;[1995/04/28]		XBA
;[1995/04/28]		M8			; memory 8bit mode
;[1995/04/28]		AND	#00FH
;[1995/04/28]		STA	<WORK7		; wmD
;[1995/04/28];
;[1995/04/28]		JSR	CRRTNSRH	; e[uT[`
;[1995/04/28];
;[1995/04/28]CRRTM010	EQU	$
;[1995/04/28]		STX	SHINPOS+0	; e[u
;[1995/04/28]		LDA	COINTBL,X
;[1995/04/28]		STA	SHINNUM+0
;[1995/04/28]		STZ	TRCOIN		; CfbNXNA[
;[1995/04/28]		LDA	#0FFH
;[1995/04/28]		STA	CHNGTBL,X	; ւe[u
;[1995/04/28];
;[1995/04/28];-----< J[hԂ CjV >----------------------------------------
;[1995/04/28]		MI16			; memory,index 16bit mode
;[1995/04/28];
;[1995/04/28]		JSR	CARDRTIN	; J[h߂ init
;[1995/04/28];
;[1995/04/28]		RTS
;[1995/04/28];
;[1995/04/28];
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28];x		JSR	CRRTNSRH ( WORLD 6 _o Ԃ search )	x
;[1995/04/28];xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;[1995/04/28]CRRTNSRH	EQU	$
;[1995/04/28]		MI8			; memory,index 8bit mode !!
;[1995/04/28];
;[1995/04/28]		LDA	TURNCNT
;[1995/04/28]		CMP	#014-3+1
;[1995/04/28]		BEQ	CRSH050		; cRH
;[1995/04/28];					: No
;[1995/04/28];
;[1995/04/28]CRSH005		EQU	$
;[1995/04/28]		LDX	#000		; e[u
;[1995/04/28]		LDY	#000		; 󂫃GAJE^[
;[1995/04/28]CRSH010		EQU	$
;[1995/04/28]		LDA	CHNGTBL,X
;[1995/04/28]		CMP	#0FFH
;[1995/04/28]		BEQ	CRSH020		; J[hH
;[1995/04/28];					: No
;[1995/04/28]		CPY	<WORK7
;[1995/04/28]		BEQ	CRSH030		; wmDH
;[1995/04/28];					: No
;[1995/04/28]		INY
;[1995/04/28]CRSH020		EQU	$
;[1995/04/28]		INX
;[1995/04/28]		BRA	CRSH010
;[1995/04/28];
;[1995/04/28]CRSH030		EQU	$
;[1995/04/28]		RTS
;[1995/04/28];
;[1995/04/28];
;[1995/04/28];-----< cR `FbN >----------------------------------------------
;[1995/04/28]CRSH050		EQU	$
;[1995/04/28]		LDX	#000
;[1995/04/28]		LDY	#000
;[1995/04/28]CRSH055		EQU	$
;[1995/04/28]		LDA	CHNGTBL,X
;[1995/04/28]		CMP	#0FFH
;[1995/04/28]		BEQ	CRSH060		; J[hH
;[1995/04/28];					: No
;[1995/04/28]		LDA	COINTBL,X
;[1995/04/28]		STA	WORK0,Y
;[1995/04/28]		TXA
;[1995/04/28]		STA	WORK3,Y
;[1995/04/28]		INY
;[1995/04/28];
;[1995/04/28]CRSH060		EQU	$
;[1995/04/28]		INX
;[1995/04/28]		CPY	#003
;[1995/04/28]		BNE	CRSH055		; RZbgH
;[1995/04/28];					: Yes
;[1995/04/28];
;[1995/04/28]		LDY	#000
;[1995/04/28]		LDA	WORK0
;[1995/04/28]		CMP	WORK1
;[1995/04/28]		BEQ	CRSH090		; PځQځH
;[1995/04/28];					: No
;[1995/04/28]		CMP	WORK2
;[1995/04/28]		BEQ	CRSH090		; PځRځH
;[1995/04/28];					: No
;[1995/04/28]		INY
;[1995/04/28]		LDA	WORK1
;[1995/04/28]		CMP	WORK2
;[1995/04/28]		BNE	CRSH005		; QځRځH
;[1995/04/28];					: Yes
;[1995/04/28]CRSH090		EQU	$
;[1995/04/28]		LDX	WORK3,Y
;[1995/04/28]		RTS
;
;
;
;
;
;
		END
;
;
;
