;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: demo main					*
;*	file name	: ys_demo					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_presno.h
		include		ys_color.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	DEMO_00_IN,DEMO_00_MV
		GLB	DEMO_01_IN,DEMO_01_MV
		GLB	DM_01_SCRCLR
		GLB	DM_INSR,DM_INSR_X
;
		GLB	DM_MWAND,DM_FUKUR,DM_BABYM,DM_YOSH2,DM_HEIHO
		GLB	DM_HEIH2,DM_FUKR2
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	VRAMCL,VRAMCL2,URAMCLR,OAMDXCLR,RAMCLR
		EXT	SOUND_TR
		EXT	MPIN,HF_STAT,GM_OVR,AGAIN,LNGGSL
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON_RAM_READ,VMADSPL
		EXT	DMCL
;
;-------------< ys_init >------------------------------------------------
		EXT	CHRSET,GMMDST,COLSET,VRAMDX_ST,UNCOMPRES_X,UNCOMPRES
		EXT	DIVDTST,M_DMA_BFST
		EXT	DM_00_CHR,DM_01_CHR
		EXT	DM_00_COL,DM_01_COL
		EXT	GM00,DM01
;
;-------------< ys_title >-----------------------------------------------
		EXT	MODINC,MODINC2
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENCSET_DM,ENRAMCLR,ENCLEAR
;
;-------------< ys_demo_1 >----------------------------------------------
		EXT	DM_YOSHIIN,DM_MWANDIN,DM_FUKURIN,DM_BABYMIN,DM_YOSH2IN
		EXT	DM_KAMECIN,DM_HEIHOIN,DM_YOSH3IN,DM_HEIH2IN,DM_FUKR2IN
;
		EXT	DM_YOSHIMV,DM_MWANDMV,DM_FUKURMV,DM_BABYMMV,DM_YOSH2MV
		EXT	DM_KAMECMV,DM_HEIHOMV,DM_YOSH3MV,DM_HEIH2MV,DM_FUKR2MV
;
;-------------< ys_game >------------------------------------------------
		EXT	MSG_BTMP_CLR
;
;-------------< ys_data >------------------------------------------------
		EXT	COS
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
		MEM8
		IDX8
;
;
Group_F		GROUP	Demo_pro
Demo_pro	SECT	REL
;
;
;************************************************************************
;*		fnaiZbg[`e[u			*		  *
;************************************************************************
DM_INIT_ADR	EQU	$-(DMSTART*2)
DM_DETH0_N	WORD	DM_DETH0IN	;[DM_DETH0]
DM_DETH1_N	WORD	DM_DETH1IN	;[DM_DETH1]
DM_BEBY0_N	WORD	DM_BEBY0IN	;[DM_BEBY0]
;
DM_BIRD0_N	WORD	DM_BIRD0IN	;[DM_BIRD0]
DM_KUMO0_N	WORD	DM_KUMO0IN	;[DM_KUMO0]
DM_KUMO1_N	WORD	DM_KUMO1IN	;[DM_KUMO1]
DM_KUMO2_N	WORD	DM_KUMO2IN	;[DM_KUMO2]
DM_KAMK0_N	WORD	DM_KAMK0IN	;[DM_KAMK0]
DM_KAMK1_N	WORD	DM_KAMK1IN	;[DM_KAMK1]
DM_KOZU0_N	WORD	DM_KOZU0IN	;[DM_KOZU0]
DM_KOZU1_N	WORD	DM_KOZU1IN	;[DM_KOZU1]
DM_TSUE0_N	WORD	DM_TSUE0IN	;[DM_TSUE0]
DM_YOSHI_N	WORD	DM_YOSHIIN	;[DM_YOSHI]
DM_MWAND_N	WORD	DM_MWANDIN	;[DM_MWAND]
DM_FUKUR_N	WORD	DM_FUKURIN	;[DM_FUKUR]
DM_BABYM_N	WORD	DM_BABYMIN	;[DM_BABYM]
DM_YOSH2_N	WORD	DM_YOSH2IN	;[DM_YOSH2]
DM_KAMEC_N	WORD	DM_KAMECIN	;[DM_KAMEC]
DM_HEIHO_N	WORD	DM_HEIHOIN	;[DM_HEIHO]
DM_FUKR2_N	WORD	DM_FUKR2IN	;[DM_FUKR2]
DM_YOSH3_N	WORD	DM_YOSH3IN	;[DM_YOSH3]
DM_HEIH2_N	WORD	DM_HEIH2IN	;[DM_HEIH2]
;
;************************************************************************
;*		fnaiOx					*
;************************************************************************
DM_DETH0	EQU	(DM_DETH0_N-DM_INIT_ADR)/2
DM_DETH1	EQU	(DM_DETH1_N-DM_INIT_ADR)/2
DM_BEBY0	EQU	(DM_BEBY0_N-DM_INIT_ADR)/2
;
DM_BIRD0	EQU	(DM_BIRD0_N-DM_INIT_ADR)/2
DM_KUMO0	EQU	(DM_KUMO0_N-DM_INIT_ADR)/2
DM_KUMO1	EQU	(DM_KUMO1_N-DM_INIT_ADR)/2
DM_KUMO2	EQU	(DM_KUMO2_N-DM_INIT_ADR)/2
DM_KAMK0	EQU	(DM_KAMK0_N-DM_INIT_ADR)/2
DM_KAMK1	EQU	(DM_KAMK1_N-DM_INIT_ADR)/2
DM_KOZU0	EQU	(DM_KOZU0_N-DM_INIT_ADR)/2
DM_KOZU1	EQU	(DM_KOZU1_N-DM_INIT_ADR)/2
DM_TSUE0	EQU	(DM_TSUE0_N-DM_INIT_ADR)/2
DM_YOSHI	EQU	(DM_YOSHI_N-DM_INIT_ADR)/2
DM_MWAND	EQU	(DM_MWAND_N-DM_INIT_ADR)/2
DM_FUKUR	EQU	(DM_FUKUR_N-DM_INIT_ADR)/2
DM_BABYM	EQU	(DM_BABYM_N-DM_INIT_ADR)/2
DM_YOSH2	EQU	(DM_YOSH2_N-DM_INIT_ADR)/2
DM_KAMEC	EQU	(DM_KAMEC_N-DM_INIT_ADR)/2
DM_HEIHO	EQU	(DM_HEIHO_N-DM_INIT_ADR)/2
DM_FUKR2	EQU	(DM_FUKR2_N-DM_INIT_ADR)/2
DM_YOSH3	EQU	(DM_YOSH3_N-DM_INIT_ADR)/2
DM_HEIH2	EQU	(DM_HEIH2_N-DM_INIT_ADR)/2
;
;************************************************************************
;*		fnai[`e[u				*
;************************************************************************
DM_MOVE_ADR	EQU	$-(DMSTART*2)
		WORD	DM_DETH0MV	;[DM_DETH0]
		WORD	DM_DETH1MV	;[DM_DETH1]
		WORD	DM_BEBY0MV	;[DM_BEBY0]
;
		WORD	DM_BIRD0MV	;[DM_BIRD0]
		WORD	DM_KUMO0MV	;[DM_KUMO0]
		WORD	DM_KUMO1MV	;[DM_KUMO1]
		WORD	DM_KUMO2MV	;[DM_KUMO2]
		WORD	DM_KAMK0MV	;[DM_KAMK0]
		WORD	DM_KAMK1MV	;[DM_KAMK1]
		WORD	DM_KOZU0MV	;[DM_KOZU0]
		WORD	DM_KOZU1MV	;[DM_KOZU1]
		WORD	DM_TSUE0MV	;[DM_TSUE0]
		WORD	DM_YOSHIMV	;[DM_YOSHI]
		WORD	DM_MWANDMV	;[DM_MWAND]
		WORD	DM_FUKURMV	;[DM_FUKUR]
		WORD	DM_BABYMMV	;[DM_BABYM]
		WORD	DM_YOSH2MV	;[DM_YOSH2]
		WORD	DM_KAMECMV	;[DM_KAMEC]
		WORD	DM_HEIHOMV	;[DM_HEIHO]
		WORD	DM_FUKR2MV	;[DM_FUKR2]
		WORD	DM_YOSH3MV	;[DM_YOSH3]
		WORD	DM_HEIH2MV	;[DM_HEIH2]
;
;************************************************************************
;*		Xe[^Xf[^					*
;************************************************************************
DM_MODE2	EQU	$-(DMSTART*2)
;			    [ENMOD2]
		WORD	0101100000000001B	;[DM_DETH0]
		WORD	0101100000000001B	;[DM_DETH1]
		WORD	0100100000000001B	;[DM_BEBY0]
;
		WORD	0110000000000001B	;[DM_BIRD0]
		WORD	0011000000000001B	;[DM_KUMO0]
		WORD	0001000000000001B	;[DM_KUMO1]
		WORD	0000100000000000B	;[DM_KUMO2]
		WORD	1000000000000001B	;[DM_KAMK0]
		WORD	0100000000000001B	;[DM_KAMK1]
		WORD	0000100000000100B	;[DM_KOZU0]
		WORD	1000000000000001B	;[DM_KOZU1]
		WORD	0010000000000101B	;[DM_TSUE0]
		WORD	0100000000000001B	;[DM_YOSHI]
		WORD	0000100000000000B	;[DM_MWAND]
		WORD	0010000000000001B	;[DM_FUKUR]
		WORD	0010000000000001B	;[DM_BABYM]
		WORD	0010000000000101B	;[DM_YOSH2]
		WORD	0101000000000001B	;[DM_KAMEC]
		WORD	0010000000000101B	;[DM_HEIHO]
		WORD	0010000000000101B	;[DM_FUKR2]
		WORD	0110000000000101B	;[DM_YOSH3]
		WORD	0010000000000001B	;[DM_HEIH2]
;
DM_DATA0	EQU	$-(DMSTART*2)
;			[ENYUSN]  [ENCLOR]
		BYTE	     000H,00100000B	;[DM_DETH0]
		BYTE	     001H,00100000B	;[DM_DETH1]
		BYTE	     001H,00100000B	;[DM_BEBY0]
;
		BYTE	     005H,00010000B	;[DM_BIRD0]
		BYTE	     004H,00010000B	;[DM_KUMO0]
		BYTE	     006H,00010000B	;[DM_KUMO1]
		BYTE	     007H,00010000B	;[DM_KUMO2]
		BYTE	     0FFH,00010010B	;[DM_KAMK0]
		BYTE	     005H,00010000B	;[DM_KAMK1]
		BYTE	     005H,00010000B	;[DM_KOZU0]
		BYTE	     0FFH,00010100B	;[DM_KOZU1]
		BYTE	     005H,00010000B	;[DM_TSUE0]
		BYTE	     007H,00100000B	;[DM_YOSHI]
		BYTE	     006H,00100010B	;[DM_MWAND]
		BYTE	     006H,00100100B	;[DM_FUKUR]
		BYTE	     0FFH,00101010B	;[DM_BABYM]
		BYTE	     004H,00100000B	;[DM_YOSH2]
		BYTE	     004H,00010000B	;[DM_KAMEC]
		BYTE	     004H,00011110B	;[DM_HEIHO]
		BYTE	     003H,00010000B	;[DM_FUKR2]
		BYTE	     004H,00010000B	;[DM_YOSH3]
		BYTE	     004H,00011110B	;[DM_HEIH2]
;
;
;
;
;
;************************************************************************
;*									*
;*		_fZbg					*
;*									*
;************************************************************************
;
DEMO_00_IN	EQU	$
		JSL	>VRAMCL		;VRAM clear
		JSL	>URAMCLR	;use RAM clear
		JSL	>ENRAMCLR	;enemy RAM clear
;
;------------------------------------------------------------------------
;		LN^[Zbg					-
;------------------------------------------------------------------------
;
		I16
;
		LDY	#DM_00_CHR	;LN^[Zbg
		JSL	>CHRSET
;
		IDX8
;
;------------------------------------------------------------------------
;		J[Zbg						-
;------------------------------------------------------------------------
;
		MI16
;
		LDA	#00		;kLJ[Zbg
		STA	>DATACOL
		LDX	#DM_00_COL	;(X) <-- J[zuf[^|C^[
		JSL	>COLSET
;
		MEM8
		IDX8
;
;------------------------------------------------------------------------
;		ootWX^Zbg					-
;------------------------------------------------------------------------
		LDX	#GM00		;(X) <-- game mode
		JSL	>GMMDST		;game mode set
		LDA	#00010000B	;OBJ only set
		STA	MANSEL
		STA	212CH
;
;------------------------------------------------------------------------
;		R[XC^Cgfrbg}bvNA[		-
;------------------------------------------------------------------------
		JSL	>MSG_BTMP_CLR
;
;------------------------------------------------------------------------
;		fnaiZbg					-
;------------------------------------------------------------------------
;
		M16
;
		LDA	#DM_DETH0
		JSR	DM_INSR
		LDA	#0070H
		STA	ENXPSL,Y	; w|WV@CjVZbgII
		LDA	#0080H
		STA	ENYPSL,Y	; x|WV@CjVZbgII
		LDA	#0020H
		STA	ENTIM0,Y	; CjV^CZbgII
		LDA	#00008H
		STA	ENTIM1,Y	; Lp^[^CZbgII
;
		LDA	#DM_DETH1
		JSR	DM_INSR
		LDA	#DMOVE
		STA	ENMODE,Y
		LDA	#0062H
		STA	ENXPSL,Y
		LDA	#0071H
		STA	ENYPSL,Y
		LDA	#00002H
		STA	ENTIM1,Y
;
		LDA	#DM_DETH1
		JSR	DM_INSR
		LDA	#DMOVE
		STA	ENMODE,Y
		LDA	#0098H
		STA	ENXPSL,Y
		LDA	#006FH
		STA	ENYPSL,Y
		LDA	#0002H
		STA	ENMUKI,Y
		LDA	#00004H
		STA	ENTIM1,Y
;
		LDA	#DM_DETH1
		JSR	DM_INSR
		LDA	#DMOVE
		STA	ENMODE,Y
		LDA	#008AH
		STA	ENXPSL,Y
		LDA	#007EH
		STA	ENYPSL,Y
		LDA	#0002H
		STA	ENMUKI,Y
		LDA	#00006H
		STA	ENTIM1,Y
;
		LDA	#DM_BEBY0
		JSR	DM_INSR
		LDA	#DMOVE
		STA	ENMODE,Y
		LDA	#0080H
		STA	ENXPSL,Y
		LDA	#0060H
		STA	ENYPSL,Y
		LDA	#00006
		STA	ENTIM1,Y
;
		M8
;
		JSL	>DEMO_00_MV_IN
;
		LDA	#0F0H		;[] aflXgbv
		STA	<SOUND_0
;
		JMP	>MODINC2
;
;************************************************************************
;*									*
;*		_f						*
;*									*
;************************************************************************
;
DEMO_00_MV_IN	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
DEMO_00_MV	EQU	$
		JSL	>OAMDXCLR	;OAM clear
;
		JSL	>ENCSET_DM	;fnai n`lZbg
		JSL	>DEMO_OBJ	;     h   
;
		M16
;
		M_CHIP	DX_OAM		;OAM convert
;
		LDA	GMFADE_CT
		BEQ	DEMO_00_MV_020	;bZ[W\H ( no:DEMO_00_MV_020 )
;
;-------------- }bv ------------------------------------------------
		LDA	!PLCONT		; "f`ld@nudq" ?
		BNE	DEMO_00_MV_010	;	NO -> DEMO_00_MV_010
		STZ	!GMFADE_CT
		LDX	#GM_OVR
		BRA	DEMO_00_MV_015
;
DEMO_00_MV_010	EQU	$
		LDX	#AGAIN
		LDA	!MID_POINT	; ԃ|Cg ăX^[g H
		BEQ	DEMO_00_MV_015	;	NO -> DEMO_00_MV_015
		LDX	#HF_STAT
DEMO_00_MV_015	EQU	$
		STX	!MODENO
;
DEMO_00_MV_020	EQU	$
;
		M8
;
		PLB
		RTL
;
;************************************************************************
;*									*
;*		~[WJZbg					*
;*									*
;************************************************************************
;
;------------------------------------------------------------------------
;-		afPCQXN[NA[f[^			-
;------------------------------------------------------------------------
DM_01_SCRCLR	EQU	$
		WORD	6400H,4000H+(0800H-1)
		WORD	03FFH
		WORD	6C00H,4000H+(0800H-1)
		WORD	03FFH
		WORD	7C00H,4000H+(0800H-1)
		WORD	0130H
;
		WORD	3FF0H,4000H+(20H-1)	;ʂLZbg
		WORD	0000H			;
		WORD	0FFFFH
;
;
;
;------------------------------------------------------------------------
;-		g|cl`f[^					-
;------------------------------------------------------------------------
;
;-------------- af[h ----------------------------------------------
DM_01_HDMA_0	EQU	$
		BYTE	00000000B	;DMA control parameter
		BYTE	05H		;    B bus address
		BYTE	LOW  HDMAPR0	;    A	    "     (L)
		BYTE	HIGH HDMAPR0	;	    "     (H)
		BYTE	BANK HDMAPR0	;	    "     (B)
;
DM_01_HDMA_0_PR EQU	$
		BYTE	46H		;line no.
		BYTE	09H
		BYTE	46H		;line no.
		BYTE	09H
		BYTE	01H		;line no.
		WORD	00H
		HEX	00		;end code
;
;-------------- CTu ----------------------------------------
DM_01_HDMA_1	EQU	$
		BYTE	00000001B	;DMA control parameter
		BYTE	2CH		;    B bus address
		BYTE	LOW  HDMAPR1	;    A	    "     (L)
		BYTE	HIGH HDMAPR1	;	    "     (H)
		BYTE	BANK HDMAPR1	;	    "     (B)
;
DM_01_HDMA_1_PR EQU	$
		BYTE	46H		;line no.
		BYTE	00010101B,00000010B
		BYTE	46H		;line no.
		BYTE	00010101B,00000010B
		BYTE	01H
		BYTE	00001000B,00000000B
		HEX	00		;end code
;
;-------------- EBhE ----------------------------------------------
DM_01_HDMA_2	EQU	$
		BYTE	01000100B	;DMA control parameter
		BYTE	26H		;    B bus address
		BYTE	LOW  HDMAPR2	;    A	    "     (L)
		BYTE	HIGH HDMAPR2	;	    "     (H)
		BYTE	BANK HDMAPR2	;	    "     (B)
;
DM_01_HDMA_2_PR EQU	$
		BYTE	12H		;line no.
		WORD	HDMABUF2
		BYTE	70H+80H		;line no.
		WORD	HDMABUF2+8
		BYTE	10H		;line no.
		WORD	HDMABUF2
		BYTE	28H		;line no.
		WORD	HDMABUF2+4
		BYTE	01H		;line no.
		WORD	HDMABUF2
		HEX	00		;end code
;
;-------------- afQX^[XN[iʂj ----------------
DM_01_HDMA_3	EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	0FH		;    B bus address
		BYTE	LOW  HDMAPR3	;    A	    "     (L)
		BYTE	HIGH HDMAPR3	;	    "     (H)
		BYTE	BANK HDMAPR3	;	    "     (B)
;
DM_01_HDMA_3_PR EQU	$
		BYTE	24H		;line no.
		WORD	HDMABUF
		BYTE	3DH		;line no.
		WORD	HDMABUF
		BYTE	18H+80H		;line no.
		WORD	HDMABUF+2
		BYTE	01H		;line no.
		WORD	HDMABUF
		HEX	00		;end code
;
;-------------- afQX^[XN[i攪wij ------------------
DM_01_HDMA_4	EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	0FH		;    B bus address
		BYTE	LOW  HDMAPR4	;    A	    "     (L)
		BYTE	HIGH HDMAPR4	;	    "     (H)
		BYTE	BANK HDMAPR4	;	    "     (B)
;
DM_01_HDMA_4_PR EQU	$
		BYTE	29H		;line no.
		WORD	HDMABUF
		BYTE	40H		;line no.
		WORD	HDMABUF+2
		BYTE	01H		;line no.
		WORD	SCCH2
		HEX	00		;end code
;
;------------------------------------------------------------------------
;-		hhS  naif[^			-
;------------------------------------------------------------------------
BIRD0_IX	EQU	(ENNO-1)*4	;REmg̃CfbNX
;
DM_01_OBJ_00	EQU	$
;			enemy no.  X	 Y
		WORD	DM_BIRD0,0088H,0058H	;[00]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		ꖋnaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_01	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KUMO0,0010H,0050H	;[01]
		WORD	DM_KUMO0,00B0H,0078H	;[02]
		WORD	DM_KUMO0,0050H,0068H	;[03]
		WORD	DM_KUMO0,00E0H,0080H	;[04]
		WORD	DM_KUMO1,0010H,0058H	;[05]
		WORD	DM_KUMO1,0010H,00A8H	;[06]
		WORD	DM_KUMO1,0050H,0078H	;[07]
		WORD	DM_KUMO1,0060H,0048H	;[08]
		WORD	DM_KUMO1,0088H,0068H	;[09]
		WORD	DM_KUMO1,00A8H,0050H	;[0A]
		WORD	DM_KUMO1,00D8H,0030H	;[0B]
		WORD	DM_KUMO1,00E0H,006CH	;[0C]
		WORD	DM_KUMO2,0010H,0068H	;[0D]
		WORD	DM_KUMO2,0018H,0040H	;[0E]
		WORD	DM_KUMO2,0040H,0068H	;[0F]
		WORD	DM_KUMO2,0050H,007CH	;[10]
		WORD	DM_KUMO2,0058H,0038H	;[11]
		WORD	DM_KUMO2,0080H,0076H	;[12]
		WORD	DM_KUMO2,00A8H,0078H	;[13]
		WORD	DM_KUMO2,00D0H,0070H	;[14]
;
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		񖋂naif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_02	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KAMK0,00B8H,0040H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		Onaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_03	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KAMK1,0600H,0038H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		lnaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_04	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KOZU1,0078H,0050H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		ܖnaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_05	EQU	$
;			enemy no.  X	 Y
		WORD	DM_YOSHI,0140H,0070H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		Znaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_06	EQU	$
;			enemy no.  X	 Y
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		掵naif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_07	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KAMEC,0050H,0082H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		攪naif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_08	EQU	$
;			enemy no.  X	 Y
		WORD	DM_YOSH3,0080H,0070H	 ;[01]
		WORD	0000H	;end code
;
;
 IF  PAL  ;**** PAL Ή [1995/08/03] *****************************
PAL_SOUND_DT	EQU	$
		BYTE	005H,002H,004H
;
ALL_TIME_PAL	EQU	$
		WORD	03100H,03100H,03900H
 ENDIF	  ;**** PAL Ή [1995/08/03] *****************************
;
;
DEMO_01_IN	EQU	$
;------------------------------------------------------------------------
;-		Sq`lNA[					-
;------------------------------------------------------------------------
		JSL	>RAMCLR
;
;
		JSL	>VRAMCL		;VRAM clear
		JSL	>URAMCLR	;use RAM clear
		JSL	>ENRAMCLR	;enemy RAM clear
;
;------------------------------------------------------------------------
;-		LN^[Zbg					-
;------------------------------------------------------------------------
;
		I16
;
		LDY	#DM_01_CHR	;(Y) <-- LN^[zuf[^|C^[
		JSL	>CHRSET
;
		IDX8
;
		LDA	#DMCL
		STA	!VRFLG
		JSL	>VMADSPL
;
;------------------------------------------------------------------------
;-		J[Zbg						-
;------------------------------------------------------------------------
;
		MI16
;
		LDX	#DM_01_COL	;(X) <-- J[zuf[^|C^[
		JSL	>COLSET
;
		MEM8
		IDX8
;
;------------------------------------------------------------------------
;-		ootWX^Zbg					-
;------------------------------------------------------------------------
		LDX	#DM01		;(X) <-- game mode
		JSL	>GMMDST		;game mode set
		LDA	#07CH		;BG4 screen base address set ( 7C00H- )
		STA	210AH
;
;
		LDA	!TITL_SND
		BNE	DEMO_SND_PASS
;
 IF  PAL  ;**** PAL Ή [1995/08/03] *****************************
		LDX	!LNGG_SL	;pAtX --> Q
		LDA	PAL_SOUND_DT,X	;     hCc	 ---> S
 ENDIF	  ;**** PAL Ή [1995/08/03] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/08/03] *****************************
		LDA	#002		;[]
 ENDIF	       ;**** { or NES Ή [1995/08/03] *****************************
;
		STA	SOUND_0
;
DEMO_SND_PASS	EQU	$
;
;------------------------------------------------------------------------
;-		g|cl`Zbg					-
;------------------------------------------------------------------------
		LDX	#04
DEMO_01_IN_010	EQU	$
		LDA	!DM_01_HDMA_0,X
		STA	4370H,X
		LDA	!DM_01_HDMA_1,X
		STA	4360H,X
		LDA	!DM_01_HDMA_2,X
		STA	4350H,X
		LDA	!DM_01_HDMA_3,X
		STA	4340H,X
		LDA	!DM_01_HDMA_4,X
		STA	4330H,X
		DEX
		BPL	DEMO_01_IN_010
		LDA	#BANK HDMABUF
		STA	4377H
		STA	4367H
		STA	4357H
		STA	4347H
		STA	4337H
;
		LDX	#20		;
DEMO_01_IN_020	EQU	$
		LDA	!DM_01_HDMA_0_PR,X
		STA	>HDMAPR0,X
		LDA	!DM_01_HDMA_1_PR,X
		STA	>HDMAPR1,X
		LDA	!DM_01_HDMA_2_PR,X
		STA	>HDMAPR2,X
		LDA	!DM_01_HDMA_3_PR,X
		STA	>HDMAPR3,X
		LDA	!DM_01_HDMA_4_PR,X
		STA	>HDMAPR4,X
		DEX
		BPL	DEMO_01_IN_020
;
		M16
;
		LDA	>HDMAPR1+1	;CTuʐݒf[^Zbg
		STA	DM_HDMA_PR
;
		LDA	#00FFH		;EBhEobt@Zbg
		STA	>HDMABUF2
		STA	>HDMABUF2+2
		LDA	#0FF00H
		STA	>HDMABUF2+4
		STA	>HDMABUF2+6
;
		M8
;
		LDA	#11100000B	;g|cl`hnmh
		STA	HD420C
;
;------------------------------------------------------------------------
;-		q`lZbg					-
;------------------------------------------------------------------------
		JSL	>DIVDTST	;div data set
;
;------------------------------------------------------------------------
;		fnaiZbg					-
;------------------------------------------------------------------------
;
		MI16
;
		LDX	#DM_01_OBJ_00
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		JSL	>DEMO_01_MV_IN
;
;-------------- NMI-IRQ "ON" ------------------------------------
		LDA	#02H		;IRQ counter set
		STA	IRQFLG
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0C6H		;V counter set
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
;
;-------------- I[vjO f [v ^C}[ Zbg --------
 IF  NES  ;**** NES Ή [1995/07/31] *****************************
		M16			; memory 16bit mode
		LDA	#03100H
		STA	!OPDMLPTM
		M8			; memory 8bit mode
 ENDIF	  ;**** NES Ή [1995/07/31] *****************************
;
;
 IF  PAL  ;**** PAL Ή [1995/07/31] *****************************
		M16			; memory 16bit mode
		LDA	!LNGG_SL
		ASL	A
		TAX
		LDA	ALL_TIME_PAL,X
		STA	!OPDMLPTM
		M8			; memory 8bit mode
 ENDIF	  ;**** PAL Ή [1995/07/31] *****************************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
		M16			; memory 16bit mode
		LDA	#02800H
		STA	!OPDMLPTM
		M8			; memory 8bit mode
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
		JMP	>MODINC
;
;************************************************************************
;*									*
;*		~[WJ						*
;*									*
;************************************************************************
;
DEMO_01_MV_IN	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JSR	OPMSGINITSET
		BRA	DEMO_01_MV_010
;
DEMO_01_MV	EQU	$
 IF  PAL  ;**** PAL Ή [1995/7/20] *****************************
		LDA	<KEYC1
		AND	#00100000B	; ZNg
		BEQ	DM_01_MV_020	;	NO -> DM_01_MV_020
		LDA	#LNGGSL
		STA	!MODENO
		LDA	#0F1H
		STA	<SOUND_0	; sound set !!
		BRA	DEMO_01_MV_010
;
DM_01_MV_020	EQU	$
 ENDIF	  ;**** PAL Ή [1995/7/20] *****************************
;
		M16			; memory 16bit mode
		DEC	!OPDMLPTM
		M8			; memory 8bit mode
;
		LDA	!OPDMLPTM	;I[vjO f
		ORA	!OPDMLPTM+1	;	[v ^C}[  O ?
		BEQ	DEMO_01_MV_NXT	;	YES -> DEMO_01_MV_NXT
;
DM_01_MV_050	EQU	$
		LDA	<KEYC1L
		AND	#11000000B
		ORA	<KEYC1
		AND	#11010000B
		BEQ	DEMO_01_MV_010	;f~H ( no:DEMO_01_MV_010 )
;
DEMO_01_MV_NXT	EQU	$
		INC	MODENO		;}bvf
		LDA	!TITL_SND
		BNE	DEMO_01_MV_030
		LDA	#0F1H
		STA	SOUND_0
		STA	!TITL_SND
		BRA	DEMO_01_MV_030
;
DEMO_01_MV_010	EQU	$

		JSL	>OAMDXCLR	;OAM clear
;
		JSR	OPMSGSET
;
		JSL	>DEMO_OBJ	;fnai
		JSL	>ENCSET_DM	;fnai n`lZbg
;
		M16
;
		LDA	OBJSEL
		AND	#11100000B
		BEQ	DEMO_01_MV_020	;naiTCYύXH ( no:DEMO_01_MV_020 )
;
		M_CHIP	DM01_OAM_SIZE	;~[WJfpn`lTCY̕ύX
;
DEMO_01_MV_020	EQU	$
		M_CHIP	DX_OAM		;OAM convert
;
		M8
;
DEMO_01_MV_030	EQU	$
		PLB
		RTL
;
;
;
;
;
;************************************************************************
;*		fnaif[^ǂݍ				*
;*			in  : (X) <-- fnaif[^|C^[	*
;************************************************************************
;
		MEM16
		IDX16
;
DEMO_OBJ_READ	EQU	$
		LDA	!0,X		;(A) <-- fnaimD
		BEQ	DEMO_OBJ_RD_010 ;f[^IH ( yes:DEMO_OBJ_RD_010 )
;
		PHX			;(X) save
;
		I8
;
		JSR	DM_INSR_X
;
		I16
;
		PLX			;(X) load
;
		LDA	!2,X		;wWZbg
		STA	ENXPSL,Y
		LDA	!4,X		;x	h
		STA	ENYPSL,Y
		TXA
		CLC
		ADC	#6
		TAX
		BRA	DEMO_OBJ_READ
;
DEMO_OBJ_RD_010 EQU	$
;
		MI8
;
		RTS
;
;************************************************************************
;*		fnaiC					*
;************************************************************************
;
		DPAGE	EN0RAM
;
DEMO_OBJ	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
		PHD			;(D) save
;
		M16
;
		LDA	#EN0RAM		;(D) <-- enemy 0 page
		TCD
;
;-------------- t[JE^[Zbg --------------------------------
		INC	<FRCNT2
;
;-------------- WvZ ------------------------------------------------
;
		M_CHIP	XYMOVE
;
;-------------- fnai[` --------------------------------------
		LDX	#(ENNO-1)*4
DEMO_OBJ_010	EQU	$
		STX	<ENINDX
;
;----------------------------------------------------------------
;-		random set					-
;----------------------------------------------------------------
		LDY	2137H
		LDY	213FH
		LDA	213CH
		CLC
		ADC	RANDM0
		STA	RANDM0
;
;-------------- fnai[hZNg ------------------------
		JSR	DEMO_MDSL
;
		DEX
		DEX
		DEX
		DEX
		BPL	DEMO_OBJ_010
;
		M8
;
		PLD
		PLB
		RTL
;
		MEM16
;
;************************************************************************
;*		fnai[hZNg				*
;************************************************************************
DEMO_MDSL	EQU	$
		LDA	ENMODE,X
		BEQ	RTSSUB
;
		JSR	DM_SUB0
;
		LDY	ENMODE,X
		LDA	!DM_MODE_ADR,Y
		PHA
;
RTSSUB		EQU	$
		RTS
;
DM_MODE_ADR	EQU	$-(CENOK-1)*2
DM_01		WORD	DM_INIT-1
DM_02		WORD	DM_MOVE-1
;
;- - - - - - - - - - - - - - - -
DINIT		EQU	DM_01-DM_MODE_ADR
DMOVE		EQU	DM_02-DM_MODE_ADR
;
;==========================================
DM_SUB0		EQU	$
		LDA	ENTIM0,X
		BEQ	DM_SUB0_010
		DEC	ENTIM0,X
DM_SUB0_010	EQU	$
		LDA	ENTIM1,X
		BEQ	DM_SUB0_020
		DEC	ENTIM1,X
DM_SUB0_020	EQU	$
		LDA	ENTIM2,X
		BEQ	DM_SUB0_030
		DEC	ENTIM2,X
DM_SUB0_030	EQU	$
		LDA	ENTIM3,X
		BEQ	DM_SUB0_040
		DEC	ENTIM3,X
DM_SUB0_040	EQU	$
		RTS
;
;************************************************************************
;*		fnaiZbg[`				*
;************************************************************************
DM_INIT		EQU	$
		LDA	#DMOVE		;next goto move !!
		STA	ENMODE,X
		LDA	ENMYNO,X
		ASL	A
;
		I16
;
		TAY
		LDA	!DM_INIT_ADR,Y
		STA	<EWORK
;
		I8
;
		JMP	(EWORK)
;
;************************************************************************
;*		fnai[`					*
;************************************************************************
DM_MOVE		EQU	$
		LDA	ENMYNO,X
		ASL	A
;
		I16
;
		TAY
		LDA	!DM_MOVE_ADR,Y
		STA	<EWORK
;
		I8
;
		JMP	(EWORK)
;
;************************************************************************
;*		fnaiGAmہiafQ\Zbgj		*
;*			in  : (A) <-- enemy no.				*
;*			out : (C) <-- 0:area nothing			*
;*				1:find (Y) <- index			*
;************************************************************************
DM_INSR_X	EQU	$
		JSR	DM_INSR
		BCC	DM_INSR_X_010
;
		LDA	#02FFH		;[ & LDA #02H	  ]
		STA	ENRETN,Y	;[ & STA ENDORE,Y ]
DM_INSR_X_010	EQU	$
		RTS
;
;************************************************************************
;*		fnaiGAm					*
;*			in  : (A) <-- enemy no.				*
;*			out : (C) <-- 0:area nothing			*
;*				1:find (Y) <- index			*
;************************************************************************
DM_INSR		EQU	$
		PHA			;(A) save
;
		LDY	#(ENNO-1)*4
DM_INSR_010	EQU	$
		LDA	ENMODE,Y
		BEQ	DM_INSR_020	;area find ? ( yes:DM_INSR_020 )
		DEY
		DEY
		DEY
		DEY
		BPL	DM_INSR_010
		PLA
		CLC
		RTS
;
DM_INSR_020	EQU	$
		LDA	#DINIT
		STA	ENMODE,Y
		LDA	#00FFH
		STA	ENRETN,Y	;[ & STA ENDORE,Y ]
		LDA	#0000
		STA	ENCOLD,Y
		STA	ENXSPD,Y
		STA	ENYSPD,Y
		STA	ENCONT,Y
		STA	ENMUKI,Y
		STA	ENEMU0,Y	;[ & STA ENXSDR,Y ]
		STA	ENCHRB,Y	;[ & STA ENYSDR,Y ]
		STA	ECRSFG,Y	;[ & STA ENCRPT,Y ]
		STA	ENWRK0,Y	;[ & STA ENWRK1,Y ]
		STA	ENWRK2,Y	;[ & STA ENWRK3,Y ]
		STA	ENWRK4,Y	;[ & STA ENWRK5,Y ]
		STA	ENWRK6,Y	;[ & STA ENWRK7,Y ]
		STA	ENWRK8,Y	;[ & STA ENWRK9,Y ]
		STA	ENWRKA,Y	;[ & STA ENWRKB,Y ]
		STA	ENWRKC,Y	;[ & STA ENWRKD,Y ]
		STA	ENTIM0,Y
		STA	ENTIM1,Y
		STA	ENTIM2,Y
		STA	ENTIM3,Y
		STA	ENCHPT,Y
		STA	ENCBFG,Y
		STA	ENSLOP,Y	;[ & STA EN_ADD_XSP,Y ]
		STA	ENSHOT,Y
		STA	ENDSXL,Y
		STA	ENDSYL,Y
		STA	ENXPOW,Y
		STA	ENXMAX,Y
		STA	ENWRKX,Y	;[ & STA ENSPTM,Y ]
		STA	ENGPOW,Y
		STA	ENGMAX,Y
		STA	ENMOD0,Y
		STA	ENMOD1,Y
		DEC	A		;[ LDA #0FFFFH ]
		STA	ENTROB,Y
		LDA	#0FFH+(((100H/8)-1)*100H)
		STA	ENWATR,Y
;
		PLA			;(A) load
;
		STA	ENMYNO,Y
;
		PHX			;(X) save
;
		ASL	A
;
		I16
;
		TAX
		LDA	!DM_DATA0+1,X
		AND	#00FFH
		STA	ENCLOR,Y
		LDA	!DM_DATA0,X
		AND	#00FFH
		STA	ENYUSN,Y
		LDA	!DM_MODE2,X
		STA	ENMOD2,Y
;
		I8
;
		PLX			;(X) load
		SEC
		RTS
;
;
;************************************************************************
;*		Zbg						*
;************************************************************************
DM_DETH0IN	EQU	$
DM_DETH1IN	EQU	$
DM_BEBY0IN	EQU	$
		LDA	#00009H
		STA	ENTIM2,Y	; |WV`FW^CZbgII
		RTS
;
;************************************************************************
;*			( e_[u )				*
;************************************************************************
SEQTIMD		EQU	$
		WORD	00030H,00000H
;
;
DM_DETH0MV	EQU	$
		LDA	<ENWRK2,X
		DEC	A		;CMP	 #00001H
		BEQ	DDT0100		; ΂ĂH
;					; No !!
		DEC	A		;CMP	 #00002H
		BEQ	DDT0400		; ΂H
;					; No !!
		DEC	A		;CMP	 #00003H
		BEQ	DDT0300		; ㏸H
;					; No !!
		LDA	ENTIM0,X
		BNE	DDT0050		; ΂H
;					; Yes !!
		LDA	#08H		;[]
		STA	SOUND_0
;
		INC	<ENWRK2,X
		LDA	<ENWRK2,X
		ASL	A
		TAY
		LDA	!SEQTIMD-2,Y
		STA	ENTIM0,X	; ^C}[ZbgII
		LDA	#00003H
		STA	ENCHPT,X	; Lp^[ZbgII
		LDA	#0000AH
		STA	ENTIM1,X	; p^[^CZbgII
		JMP	DDT1100
;
DDT0050		EQU	$
		JMP	DM_DETH1MV
;
DDT0100		EQU	$
		LDA	ENTIM0,X
		BNE	DDT0150		; ΂IH
;					; Yes !!
		INC	<ENWRK2,X
		LDA	#00010H
		STA	ENTIM0,X	; ^C}[ZbgII
		LDA	#00008H
		STA	ENTIM1,X	; p^[^CZbgII
		STZ	ENCHPT,X	; Lp^[ZbgII
		JMP	DM_DETH1MV
;
DDT0150		EQU	$
		LDA	ENTIM1,X
		BNE	DDT0250		; ΂Ăp^[`FWH
;					; Yes !!
		LDA	#00003
		STA	ENTIM1,X
		LDA	ENCHPT,X
		INC	A
		CMP	#00005H
		BCC	DDT0200		; p^[I[o[H
;					; Yes !!
		LDA	#00003H
;
DDT0200		EQU	$
		STA	ENCHPT,X
;
DDT0250		EQU	$
		JMP	DDT1100
;
DDT0300		EQU	$
		LDA	ENYPSL,X
		CMP	#0FFC0H
		BPL	DDT0350		; fGhH
;					; Yes !!
		INC	GMFADE_CT
;
DDT0350		EQU	$
		JMP	DM_DETH1MV
;
DDT0400		EQU	$
		LDA	ENTIM0,X
		BNE	DDT0350		; ㏸H
;					; Yes !!
		INC	<ENWRK2,X
		LDA	#0FC00H
		STA	ENGMAX,X
		STA	ENGMAX+4CH
		STA	ENGMAX+50H
		STA	ENGMAX+54H
		STA	ENGMAX+58H
		LDA	#00040H
		STA	ENGPOW,X
		STA	ENGPOW+4CH
		STA	ENGPOW+50H
		STA	ENGPOW+54H
		STA	ENGPOW+58H
		JMP	DM_DETH1MV
;
;
;************************************************************************
;*			( q_[u )				*
;************************************************************************
YPOSDAT		EQU	$
		WORD	00001H,00001H,00002H,00002H,00003H,00002H,00002H,00001H
		WORD	0FFFFH,0FFFEH,0FFFEH,0FFFDH,0FFFEH,0FFFEH,0FFFFH,0FFFFH
;
PUROPERA_CHNO	EQU	$
		WORD	0CC4H,0CC6H,0CC8H,4CC6H
;
DM_DETH1MV	EQU	$
		LDA	ENTIM1,X
		BNE	DDT1100		; p^[`FWH
;					; Yes !!
		LDA	ENCHPT,X
		INC	A
		CMP	#00003
		BNE	DDT1050		; p^[I[o[H
;					; Yes !!
		LDA	#0000
;
DDT1050		EQU	$
		STA	ENCHPT,X	; Lp^[ZbgII
		LDA	#00008
		STA	ENTIM1,X	; p^[^CZbgII
;
;-------------- vy] --------------------------------------------
DDT1100		EQU	$
		LDA	<FRCNT2
		AND	#03H*2
		TAY
		LDA	!PUROPERA_CHNO,Y
;
		I16
;
		LDY	ENOAML,X
		STA	SOAM_DX+4,Y
;
		I8
;
DDT1110		EQU	$
		LDA	ENTIM2,X
		BNE	DDT1150		; |WV`FWH
;					; Yes !!
		LDA	#00008H
		STA	ENTIM2,X	; |WV`FW^CZbgII
		LDA	<ENWRK0,X
		INC	A
		INC	A
		AND	#0001FH
		STA	<ENWRK0,X	; |WV`FW|C^[ZbgII
		TAY
		LDA	ENYPSL,X
		CLC
		ADC	!YPOSDAT,Y
		STA	ENYPSL,X	; |WVZbgII
;
DDT1150		EQU	$
		RTS
;
;
;************************************************************************
;*			( x[r[[u )				*
;************************************************************************
DM_BEBY0MV	EQU	$
		LDA	ENTIM1,X
		BNE	DBY1050		; p^[`FWH
;					; Yes !!
		LDA	ENCHPT,X
		INC	A
		AND	#00001
		STA	ENCHPT,X	; Lp^[ZbgII
		LDA	#00006H
		STA	ENTIM1,X	; p^[^CZbgII
;
DBY1050		EQU	$
		JMP	DDT1110
;
;
;
;
;
;************************************************************************
;*		Zbgi~[WJ̃REmgj			*
;************************************************************************
;
DM_BIRD0IN	EQU	$
;
		I16
;
		LDX	#200H-2
DM_BIRD0IN_0010 EQU	$
		LDA	>DATACOL,X
		STA	>MOTOCOL,X
		STA	>CHNGCOL,X
		DEX
		DEX
		BPL	DM_BIRD0IN_0010
;
		I8
;
		JSR	COL_FADE_SET	;J[tF[hZbg
		LDA	#MOTOCOL
		STA	>MOTOADR
		LDA	#CHNGCOL
		STA	>CHNGADR
;
		STZ	SCCV1		;afXN[JE^[Zbg
		STZ	SCCV2
		STZ	SCCH1		;fnai\pXN[JE^[Zbg
		STZ	SCCH2
		STZ	ESCCH1
		STZ	ESCCH2
		STZ	ESCCV1
		STZ	ESCCV2
		LDX	#00
		JSR	BG_WAVE_SET
		LDX	#04
		JSR	BG_WAVE_SET
;
; #if !="Debug"
		 LDA	 #0200H		 ;ꖋ܂ł̃^C}[Zbg
		 STA	 ENTIM3,X
; #else
;		LDA	#0CH
;		STA	<ENWRK0,X
;		LDA	#0FFH
;		STA	ENYUSN,X
;		LDX	#CHRDC		;(X) <-- LN^[f[^mD
;		LDA	#4000H		;(A) <-- uq`lAhX
;		JSR	CHAR_CHANGE
;		LDA	#00010000B	;afQX^[XN[Zbg
;		TRB	HD420C
; #endif
		STZ	ENWRKA,X
;
;************************************************************************
;*			  i~[WJ̃REmgj			*
;************************************************************************
DM_BIRD0MV	EQU	$
		LDY	<ENWRK0,X
		TYX
		JMP	(!DEMO_01_SEL,X)
;
;------------------------------------------------------------------------
;-		f̐䏈						-
;------------------------------------------------------------------------
DEMO_01_SEL	EQU	$		;[ENWRK0,X]
		WORD	DEMO_01_MV_0	;[0]
		WORD	DEMO_01_MV_1	;[2]
		WORD	DEMO_01_MV_2	;[4]
		WORD	DEMO_01_MV_3	;[6]
		WORD	DEMO_01_MV_4	;[8]
		WORD	DEMO_01_MV_5	;[A]
		WORD	DEMO_01_MV_6	;[C]
		WORD	DEMO_01_MV_7	;[E]
		WORD	DEMO_01_MV_8	;[10]
;
;------------------------------------------------------------------------
;-		hhS\				-
;------------------------------------------------------------------------
DEMO_01_MV_0	EQU	$
		LDX	<ENINDX
;
		JSR	ROGO_ANIME
;
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_0010 ;H ( no:DEMO_01_MV_0010 )
;
;-------------- ꖋZbg ----------------------------------------
;
		I16
;
		LDX	#DM_01_OBJ_01	;(X) <-- ꖋfnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		M16
;
		LDX	<ENINDX
		LDA	#0500H		;񖋂܂ł̃^C}[Zbg
		STA	ENTIM3,X
;
DEMO_01_MODINC	EQU	$
		INC	<ENWRK0,X	;̃[h
		INC	<ENWRK0,X
DEMO_01_MV_0010 EQU	$
		RTS
;
;================================================================
;-		̖ւ̃`FbN				=
;================================================================
NEXT_CHECK	EQU	$
		LDA	ENTIM3,X	;(Z) <-- 0
		BNE	NEXT_CHECK_010	;^C}[IH ( no:NEXT_CHECK_010 )
;
		LDY	OPNEXTFG
		BNE	NEXT_CHECK_020	;̖ցH ( yes:NEXT_CHECK_020 )
		INC	OPNEXTFG
NEXT_CHECK_010	EQU	$
		RTS
;
NEXT_CHECK_020	EQU	$
		LDY	#00		;(Z) <-- 1
		STY	OPNEXTFG
		RTS
;
;------------------------------------------------------------------------
;-		ꖋf						-
;------------------------------------------------------------------------
DEMO_01_MV_1	EQU	$
		LDX	<ENINDX
;
;-------------- X^[XN[Zbg --------------------------------
		JSR	BG_WAVE_SET
;
;-------------- REmg ------------------------------------------
		JSR	DM_BIRD0_MV
;
;-------------- hhS --------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_1010 ;IH ( yes:DEMO_01_MV_1010 )
;
		CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
;
;-------------- hhS ----------------
ROGO_ANIME	EQU	$
		LDA	<FRCNT2
		AND	#03H
		BNE	ROGO_ANIME_040
;
		LDA	ENWRKA,X
		CLC
		ADC	#050H
		CMP	#050H*3
		BCC	ROGO_ANIME_010
		LDA	#00H
ROGO_ANIME_010	EQU	$
		STA	ENWRKA,X
		ORA	#1900H
		STA	<EWORK0
;
		I16
;
		LDA	>VRAMD
		TAX
		LDA	#05
		STA	<EWORK2
		LDA	#6108H		;VRAM address set
		STA	<EWORK4
ROGO_ANIME_020	EQU	$
		LDA	<EWORK4
		STA	>VRAMD+2,X
		CLC
		ADC	#020H
		STA	<EWORK4
		LDA	#(16*2)-1	;number of byte set
		STA	>VRAMD+4,X
;
		LDY	#16
		LDA	<EWORK0
ROGO_ANIME_030	EQU	$
		STA	>VRAMD+6,X
		INC	A
		INX
		INX
		DEY
		BNE	ROGO_ANIME_030
		STA	<EWORK0
;
		INX
		INX
		INX
		INX
		DEC	<EWORK2
		BNE	ROGO_ANIME_020
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
;
		I8
;
		LDX	<ENINDX
ROGO_ANIME_040	EQU	$
		RTS
;
;-------------- J[tF[h ------------------------------------------
DEMO_01_MV_1010 EQU	$
		LDA	>CLFDCNT
		CMP	#020H
		BCC	DEMO_01_MV_1020 ;̃J[ցH ( no:DEMO_01_MV_1020 )
;
		LDA	<ENCONT,X
		CMP	#(15*2)*15
		BCS	DEMO_01_MV_1030 ;J[tF[hIH ( yes:DEMO_01_MV_1030 )
;
		JSR	COL_FADE_SET	;̃J[tF[hZbg
;
DEMO_01_MV_1020 EQU	$
		LDA	<FRCNT2
		LSR	A
		BCC	DEMO_01_MV_1030 ;J[tF[hZbgH ( no:DEMO_01_MV_1030 )
;
		M_CHIP	COLFADE
;
DEMO_01_MV_1030 EQU	$
		LDX	<ENINDX
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_1050 ;̖ɍsH ( no:DEMO_01_MV_1050 )
;
;-------------- jZbg ----------------------------------------
		LDA	#B1OPDM2	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_1040 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_2_BG,X
		STA	>DATACOL+(41H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_2_BG+(0FH*2),X
		STA	>DATACOL+(51H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_1040
;
		I16
;
		LDX	#DM_01_OBJ_02	;(X) <-- 񖋃fnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		LDA	#00010000B	;afQX^[XN[Zbg
		TRB	HD420C
;
		M16
;
		LDX	<ENINDX
		LDA	#1C0H		;O܂ł̃^C}[Zbg
		STA	ENTIM3,X
		LDA	#02H		;H΂^C}[Zbg
		STA	ENTIM1,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_1050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		jf						-
;------------------------------------------------------------------------
DEMO_01_MV_2	EQU	$
		LDX	<ENINDX
;
;-------------- ꖋ	 ------------------------------------------
		LDA	ESCCH1
		CMP	#0300H
		BCS	DEMO_01_MV_2020 ;IH ( yes:DEMO_01_MV_2020 )
;
;;;;		    CLC
		ADC	#02H
		STA	ESCCH1
		CMP	#0100H
		BCC	DEMO_01_MV_2010
		LDA	#0100H
DEMO_01_MV_2010 EQU	$
		STA	SCCH1
;
;-------------- REmg ------------------------------------------
		JMP	DM_BIRD0_MV
;
DEMO_01_MV_2020 EQU	$
		LDA	#0FFH		;\Zbg
		STA	ENYUSN,X
;
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_2050 ;̖ɍsH ( no:DEMO_01_MV_2050 )
;
;-------------- OZbg ----------------------------------------
		LDA	#B1OPDM1	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		I16
;
		LDX	#DM_01_OBJ_03	;(X) <-- OfnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		M16
;
;-------------- REmg̍ĕ\Zbg ------------------------
		LDX	<ENINDX
		LDA	#088H		;WZbg
		STA	ENXPSL,X
		LDA	#048H
		STA	ENYPSL,X
		STZ	ENXSPD,X	;ړXs[hZbg
		STZ	ENYSPD,X
		STZ	ENGPOW,X
		STZ	ENGMAX,X
		STZ	ENXPOW,X
		STZ	ENXMAX,X
		LDA	#05H		;\Zbg
		STA	ENYUSN,X
		LDA	ENCLOR,X
		EOR	#030H
		STA	ENCLOR,X
		LDA	#02FFH		;[ LDA #02H	]
		STA	ENRETN,X	;[ STA ENDORE,X ]
		LDA	#200H		;l܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_2050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		Of						-
;------------------------------------------------------------------------
 IF  PAL  ;**** PAL Ή [1995/08/03] *****************************
PAL_SCCH_DT	EQU	$
		WORD	0FE24H,0FE7FH,0FE24H
 ENDIF	  ;**** PAL Ή [1995/08/03] *****************************
;
;
DEMO_01_MV_3	EQU	$
		LDX	<ENINDX
;
;-------------- X^[XN[Zbg --------------------------------
		JSR	BG_WAVE_SET
;
;-------------- REmg ------------------------------------------
		JSR	DM_BIRD0_MV
;
;-------------- 	 ------------------------------------------
		LDA	ESCCH1
		CMP	#0300H
		BCS	DEMO_01_MV_3020 ;IH ( yes:DEMO_01_MV_3020 )
;
;;;;		    CLC
		ADC	#02H
		STA	ESCCH1
		CMP	#0100H
		BCC	DEMO_01_MV_3010
		LDA	#0100H
DEMO_01_MV_3010 EQU	$
		STA	SCCH1
		RTS
;
DEMO_01_MV_3020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_3050 ;̖ɍsH ( no:DEMO_01_MV_3050 )
;
;-------------- lZbg ----------------------------------------
		LDX	#CHRD4		;(X) <-- LN^[f[^mD
		LDA	#1000H		;(A) <-- uq`lAhX
		JSR	CHAR_CHANGE
		LDA	#B1OPDM4	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_3030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_4_BG,X
		STA	>DATACOL+(41H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_3030
;
		I16
;
		LDX	#DM_01_OBJ_04	;(X) <-- lfnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		LDA	#00010000B	;afQX^[XN[Zbg
		TRB	HD420C
;
		LDA	#03H		;Pʂ
		TRB	BG2SCF
;
		M16
;
 IF  PAL  ;**** PAL Ή [1995/07/31] *****************************
		LDA	!LNGG_SL
		ASL	A
		TAX
		LDA	PAL_SCCH_DT,X
 ENDIF	  ;**** PAL Ή [1995/07/31] *****************************
;
;
 IF  NES  ;**** NES Ή [1995/07/31] *****************************
		LDA	#0FE24H		;afʒuZbg
 ENDIF	  ;**** NES Ή [1995/07/31] *****************************
;
;
 IF  JPN  ;**** { Ή [1995/07/31] *****************************
		LDA	#0FE7FH		;afʒuZbg
 ENDIF	  ;**** { Ή [1995/07/31] *****************************
;
		STA	SCCH2
		STZ	<FRCNT2
;
		LDX	<ENINDX
		LDA	#300H		;ܖ܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_3050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		lf						-
;------------------------------------------------------------------------
DEMO_01_MV_4	EQU	$
		LDX	<ENINDX
;
		LDA	<FRCNT2
		LSR	A
		BCC	DEMO_01_MV_4010
		INC	SCCH2
		INC	SCCV2
DEMO_01_MV_4010 EQU	$
;
;-------------- O	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_4020 ;IH ( yes:DEMO_01_MV_4020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
;
;-------------- REmg ------------------------------------------
		JMP	DM_BIRD0_MV
;
DEMO_01_MV_4020 EQU	$
		LDA	#0FFH		;\Zbg
		STA	ENYUSN,X
;
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_4050 ;̖ɍsH ( no:DEMO_01_MV_4050 )
;
;-------------- уJ[ZZbg --------------------
		LDA	#00010111B+(00000000B*100H)
		STA	DM_HDMA_PR
		LDY	#00010000B
		STY	WIND30
		LDY	#00000010B	;afQƉZ
		STY	SUBADF
		LDA	#1088H
		STA	NUKCOL
;
;-------------- ܖZbg ----------------------------------------
		LDA	#01H		;Qʂ
		TSB	BG2SCF
;
		LDX	#CHRD5		;(X) <-- LN^[f[^mD
		LDA	#1800H		;(A) <-- uq`lAhX
		JSR	CHAR_CHANGE
		LDA	#B1OPDM5	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_4030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_5_BG,X
		STA	>DATACOL+(51H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_5_BG+(0FH*2),X
		STA	>DATACOL+(61H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_4030
;
		I16
;
		LDX	#DM_01_OBJ_05	;(X) <-- ܖfnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		LDA	#03H		;Pʂ
		TRB	BG2SCF
;
		M16
;
 IF PAL	   ;*** PAL Ή [1995/8/02] ******************
		LDA	>LNGG_SL_BF		;tX ?
		DEC	A	;[ CMP	#00001 ];
		BNE	DEMO_01_MV_4040		;  no: DEMO_01_MV_4040

		LDA	#0200H		;afʒuZbg
		BRA	DEMO_01_MV_4048

DEMO_01_MV_4040 EQU	$
		LDA	#0178H		;afʒuZbg

DEMO_01_MV_4048 EQU	$
		STA	SCCH2
 ELSE	   ;*** JPN/NES Ή [1995/6/30] **************
		LDA	#0178H		;afʒuZbg
		STA	SCCH2
 ENDIF	   ;*** PAL Ή [1995/8/02] ******************
;
		LDX	<ENINDX
		LDA	#400H		;Z܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_4050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		ܖf						-
;------------------------------------------------------------------------
DEMO_01_MV_5	EQU	$
;
;-------------- уEBhEZbg --------------------------------
		LDA	ESCCH2
		JSR	OPDM_KMLB
		LDX	<ENINDX
;
;-------------- l	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_5020 ;IH ( yes:DEMO_01_MV_5020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
;
		LDA	<FRCNT2
		LSR	A
		BCC	DEMO_01_MV_5010
		INC	SCCV1
DEMO_01_MV_5010 EQU	$
		RTS
;
DEMO_01_MV_5020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_5050 ;̖ɍsH ( no:DEMO_01_MV_5050 )
;
;-------------- ZZbg ----------------------------------------
		LDA	#01H		;Qʂ
		TSB	BG2SCF
;
		LDA	#B1OPDM6	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_5030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_6_BG,X
		STA	>DATACOL+(31H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_6_BG+(0FH*2),X
		STA	>DATACOL+(41H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_5030
;
;-------------- уJ[ZύX --------------------------
		LDY	#00000001B	;afPƉZ
		STY	SUBADF
;
		LDX	<ENINDX
		LDA	#100H		;掵܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_5050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		Zf						-
;------------------------------------------------------------------------
DEMO_01_MV_6	EQU	$
		LDX	<ENINDX
;
;-------------- ܖ	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_6020 ;IH ( yes:DEMO_01_MV_6020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1		;(A) <-- EBhEXN[JE^[
;
;-------------- уEBhEZbg --------------------------------
		JSR	OPDM_KMLB
		LDX	<ENINDX
		RTS
;
DEMO_01_MV_6020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_6050 ;̖ɍsH ( no:DEMO_01_MV_6050 )
;
;-------------- 掵Zbg ----------------------------------------
		LDA	#B1OPDM7	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_6030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_7_BG,X
		STA	>DATACOL+(51H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_7_BG+(0FH*2),X
		STA	>DATACOL+(61H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_6030
;
		I16
;
		LDX	#DM_01_OBJ_07	;(X) <-- 掵fnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		M16
;
;-------------- уJ[ZZbg ----------------------
		LDA	#00010101B+(00000010B*100H)
		STA	DM_HDMA_PR
		LDY	#00000010B
		STY	WIND30
		LDY	#00100000B
		STY	SUBADF
		STZ	NUKCOL
;
		LDX	<ENINDX
		LDA	#480H		;攪܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_6050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		掵f						-
;------------------------------------------------------------------------
DEMO_01_MV_7	EQU	$
		LDX	<ENINDX
;
;-------------- Z	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_7020 ;IH ( yes:DEMO_01_MV_7020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
		RTS
;
DEMO_01_MV_7020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_7050 ;̖ɍsH ( no:DEMO_01_MV_7050 )
;
;-------------- 攪Zbg ----------------------------------------
		LDA	#B1OPDM8	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_7030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_8_BG,X
		STA	>DATACOL+(21H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_8_BG+(0FH*2),X
		STA	>DATACOL+(31H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_OBJ_71,X
		STA	>DATACOL+(0F1H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_7030
;
		I16
;
		LDX	#DM_01_OBJ_08	;(X) <-- 攪fnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		LDA	#03H		;Pʂ
		TRB	BG2SCF
;
		M16
;
		LDX	<ENINDX
		LDA	#300H		;̃[hw̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_7050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		攪f						-
;------------------------------------------------------------------------
DEMO_01_MV_8	EQU	$
		LDX	<ENINDX
;
;-------------- dXN[Zbg ------------------------------------
		LDA	SCCH2
		LSR	A
		STA	>HDMABUF+2	;_̃XN[
		LSR	A
		STA	>HDMABUF	;R̃XN[
		LDA	#00001000B	;afQX^[XN[Zbg
		TSB	HD420C
;
;-------------- 掵	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_8020 ;IH ( yes:DEMO_01_MV_8020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
		RTS
;
DEMO_01_MV_8020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_8050 ;̖ɍsH ( no:DEMO_01_MV_8050 )
;
;-------------- ̃[hw --------------------------------------------
;
DEMO_01_MV_8050 EQU	$
		RTS
;
;========================================================================
;=		H΂p^[Zbg					=
;========================================================================
;
;------------------------------------------------------------------------
;-		㉺Xs[hf[^					-
;------------------------------------------------------------------------
BIRD0_GPOW	EQU	$
		WORD	00001H,00002H
BIRD0_GMAX	EQU	$
		WORD	00010H,0FFC0H
;
;------------------------------------------------------------------------
;-		㏸^C}[f[^					-
;------------------------------------------------------------------------
FLYUP_TIM	EQU	$
		WORD	010H,008H,018H,04H
;
;------------------------------------------------------------------------
;-		]Xs[hf[^					-
;------------------------------------------------------------------------
BIRD0_MINSPD	EQU	$
; ENWRK2,X -->		  0   2
		WORD	256/3,040H
BIRD0_ROTSPD	EQU	$-(12*2)
		WORD	256/3,256/3,256/3,08H,256/1
;
DM_BIRD0_MV	EQU	$
		LDA	#256/2		;(A) <-- H΂Xs[h
		LDY	ENTIM1,X
		BNE	DM_BARD0MV_0010 ;㏸H ( no:DM_BARD0MV_0010 )
;
		LDY	<ENWRK2,X	;(Y) <-- 0: 2:]
		LDA	ENWRK8,X
		CMP	!BIRD0_MINSPD,Y
		BMI	DM_BARD0MV_0010
		SEC
		SBC	#02H
DM_BARD0MV_0010 EQU	$
		STA	ENWRK8,X
		CLC
		ADC	ENWRK6,X
		CMP	#12*100H
		BCC	DM_BARD0MV_0050 ;ԃp^[l`wH ( no:DM_BARD0MV_0050 )
;
		LDY	<ENWRK2,X
		BNE	DM_BARD0MV_0020 ;]H ( yes:DM_BARD0MV_0020 )
;
		AND	#00FFH
		BRA	DM_BARD0MV_0050
;
DM_BARD0MV_0020 EQU	$
		PHA			;(A) save
;
		XBA
		AND	#0FFH
		ASL	A
		TAY
		CPY	#17*2
		BCS	DM_BARD0MV_0030 ;]Xs[hZbgH ( no:DM_BARD0MV_0030 )
;
		LDA	ENWRK6+1,X
		AND	#0FFH
		ASL	A
		STA	<EWORK0
;
		CPY	#16*2
		BNE	DM_BARD0MV_0022 ;ƂH ( no:DM_BARD0MV_0022 )
;
		CMP	#15*2
		BNE	DM_BARD0MV_0030 ;łɃZbgH ( yes:DM_BARD0MV_0030 )
;
		PHY			;(Y) save
;
;-------------- ƂZbg ----------------------------------------
		LDA	#DM_KOZU0	;(A) <-- fnaimD
		JSR	DM_INSR_X
		LDA	ENXPSL,X	;wWZbg
		CLC
		ADC	#014H
		STA	ENXPSL,Y
		LDA	ENYPSL,X	;xWZbg
		CLC
		ADC	#0FFE8H
		STA	ENYPSL,Y
;
		LDA	#DM_TSUE0	;(A) <-- fnaimD
		JSR	DM_INSR_X
		LDA	ENXPSL,X	;wWZbg
		CLC
		ADC	#014H
		STA	ENXPSL,Y
		LDA	ENYPSL,X	;xWZbg
		CLC
		ADC	#0FFE8H
		STA	ENYPSL,Y
;
		PLY			;(Y) load
;
DM_BARD0MV_0022 EQU	$
		CPY	<EWORK0
		BEQ	DM_BARD0MV_0030 ;Xs[hύXH ( no:DM_BARD0MV_0030 )
;
		LDA	!BIRD0_ROTSPD,Y
		STA	ENWRK8,X
		PLA
		AND	#0FF00H
		PHA
;
DM_BARD0MV_0030 EQU	$
		PLA			;(A) load
		CMP	#24*100H
		BCC	DM_BARD0MV_0050 ;]p^[l`wH ( no:DM_BARD0MV_0050 )
;
		AND	#00FFH
		ORA	#16*100H
;
DM_BARD0MV_0050 EQU	$
		STA	ENWRK6,X
;
		XBA
		AND	#00FFH
		STA	ENCHPT,X
;
		LDY	<ENWRK2,X
		BEQ	DM_BARD0MV_0100 ;]H ( no:DM_BARD0MV_0100 )
;
;-------------- ]̃u[LOZbg ------------------------------
		LDA	ENXMAX,X
		SEC
		SBC	#01H
		CMP	#010H
		BPL	DM_BARD0MV_0052
		LDA	#010H
DM_BARD0MV_0052 EQU	$
		STA	ENXMAX,X
;
		LDY	#(ENNO-2)*4	;[ -2:REmgȊO ]
DM_BARD0MV_0060 EQU	$
		LDA	ENMODE,Y
		BEQ	DM_BARD0MV_0070 ;fnaiH ( no:DM_BARD0MV_0070 )
		LDA	ENMYNO,Y
		CMP	#DM_KUMO0
		BCC	DM_BARD0MV_0070 ;_H ( no:DM_BARD0MV_0070 )
		CMP	#DM_KUMO2+1
		BCS	DM_BARD0MV_0070 ;_H ( no:DM_BARD0MV_0070 )
;
;-------------- ̃fnai ------------------------------
		LDA	ENXMAX,Y
		EOR	#0FFFFH
		INC	A
;
		M8
;
		STA	211BH
		XBA
		STA	211BH
		LDA	ENXMAX,X
		STA	211CH
		LDA	2134H
		ASL	A		;(C) <-- 0.5
;
		M16
;
		LDA	2135H
		ROL	A		;x2
		EOR	#0FFFFH
		INC	A
		STA	ENXSPD,Y
DM_BARD0MV_0070 EQU	$
		DEY
		DEY
		DEY
		DEY
		BPL	DM_BARD0MV_0060
DM_BARD0MV_0080 EQU	$
		RTS
;
;-------------- ʂ̔ł鎞̏㉺Xs[hZbg --------------------
DM_BARD0MV_0100 EQU	$
		LDA	ENYPSL,X
		CMP	#058H
		BCC	DM_BARD0MV_0110 ;㏸ZbgH ( no:DM_BARD0MV_0110 )
;
		LDA	RANDM0		;㏸^C}[Zbg
		AND	#03H*2
		TAY
		LDA	!FLYUP_TIM,Y
		STA	ENTIM1,X
DM_BARD0MV_0110 EQU	$
		LDY	ENTIM1,X
		BEQ	DM_BARD0MV_0120 ;㏸H ( no:DM_BARD0MV_0120 )
		LDY	#02H
DM_BARD0MV_0120 EQU	$
		LDA	!BIRD0_GPOW,Y	;d̓Zbg
		STA	ENGPOW,X
		STA	ENXPOW,X
		LDA	!BIRD0_GMAX,Y	;ő嗎Xs[hZbg
		STA	ENGMAX,X
		EOR	#0FFFFH
		INC	A
		STA	ENXMAX,X
DM_BARD0MV_0130 EQU	$
		RTS
;
;========================================================================
;=		afLN^[ւ				=
;=			in  : (X) <-- LN^[f[^mD		=
;=			      (A) <-- uq`lAhX			=
;========================================================================
CHAR_CHANGE	EQU	$
		PHA			;uq`lAhX save
;
		I16
;
		TXA			;(A) <-- LN^[f[^mD
		LDX	#WOB7CHR	;(X) <-- 𓀐AhX
		JSL	>UNCOMPRES
		TAY			;(Y) <-- number of byte
;
		LDA	>VRAMDX
		TAX
;
		PLA			;uq`lAhX load
		STA	>(VRAMDX&0FF0000H),X	;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	>(VRAMDX&0FF0000H)+2,X	;inc mode & DMA parameter set
		LDA	#18H+(WOB7CHR*100H)
		STA	>(VRAMDX&0FF0000H)+4,X	;B bus address & A bus address(L) set
		LDA	#WOB7CHR/100H
		STA	>(VRAMDX&0FF0000H)+6,X	;A bus address(H,B) set
		TYA
		STA	>(VRAMDX&0FF0000H)+8,X	;number of byte set
		TXA
		CLC
		ADC	#12
		STA	>(VRAMDX&0FF0000H)+10,X ;next data set address set
		STA	>VRAMDX			;end address set
;
		I8
;
		LDX	<ENINDX
		RTS
;
;========================================================================
;=		fnai  afQ˂afP\֕ύX			=
;=			in  : (A) <-- XN[f[^mD		=
;========================================================================
DORE_CHANGE	EQU	$
;
;-------------- afXN[ ----------------------------------
;
		I16
;
		JSL	>UNCOMPRES_X
		TAY			;(Y) <-- number of byte
;
		LDA	>VRAMDX
		TAX
;
		LDA	SCCV2		;afP̂afQւ
		STA	SCCV1
		STZ	SCCH1
		STZ	ESCCH1
		STZ	SCCV2
		LDA	BG1SCF
		XBA
		STA	BG1SCF
		AND	#0FC00H
		STA	>(VRAMDX&0FF0000H),X	;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	>(VRAMDX&0FF0000H)+2,X	;inc mode & DMA parameter set
		LDA	#18H+((WOB7CHR+1000H)*100H)
		STA	>(VRAMDX&0FF0000H)+4,X	;B bus address & A bus address(L) set
		LDA	#(WOB7CHR+1000H)/100H
		STA	>(VRAMDX&0FF0000H)+6,X	;A bus address(H,B) set
		TYA
		STA	>(VRAMDX&0FF0000H)+8,X	;number of byte set
		TXA
		CLC
		ADC	#12
		STA	>(VRAMDX&0FF0000H)+10,X ;next data set address set
		STA	>VRAMDX			;end address set
;
;-------------- fnai\af؂ւ ------------------------------
;
		I8
;
		LDX	<ENINDX
		LDY	#(ENNO-1)*4
DORE_CHANGE_010 EQU	$
		LDA	ENMODE,Y
		BEQ	DORE_CHANGE_020 ;GZbgH ( no:DORE_CHANGE_020 )
;
		LDA	#00FFH		;[ & LDA #00	  ]
		STA	ENRETN,Y	;[ & STA ENDORE,Y ]
		LDA	ENYUSN,Y
		AND	#0FFFBH
		STA	ENYUSN,Y
		LDA	ENCLOR,Y
		ORA	#030H
		STA	ENCLOR,Y
DORE_CHANGE_020 EQU	$
		DEY
		DEY
		DEY
		DEY
		BPL	DORE_CHANGE_010
		RTS
;
;========================================================================
;=		J[tF[hZbg					=
;========================================================================
COL_FADE_SET	EQU	$
		PHB			;(DBR) save
		LDY	#BANK DATACOL	;(DBR) <-- DATACOL(B)
		PHY
		PLB
;
		LDA	#00		;J[tF[hJE^[Zbg
		STA	>CLFDCNT
;
		LDA	<ENCONT,X
		CLC
		ADC	#15*2
		STA	<ENCONT,X
;
		I16
;
		TAX
;
		LDY	#(15-1)*2
COL_FADE_SET_10 EQU	$
		LDA	DATACOL+(21H*2),Y
		STA	MOTOCOL+(21H*2),Y
		LDA	>COL_ADDRESS+MSCL_COL_1_SKY0+(15-1)*2,X
		STA	CHNGCOL+(21H*2),Y
;
		LDA	DATACOL+(31H*2),Y
		STA	MOTOCOL+(31H*2),Y
		LDA	>COL_ADDRESS+MSCL_COL_1_SEA0+(15-1)*2,X
		STA	CHNGCOL+(31H*2),Y
;
		LDA	DATACOL+(81H*2),Y
		STA	MOTOCOL+(81H*2),Y
		LDA	>COL_ADDRESS+MSCL_COL_1_OBJ0+(15-1)*2,X
		STA	CHNGCOL+(81H*2),Y
;
		DEX
		DEX
		DEY
		DEY
		BPL	COL_FADE_SET_10
;
		I8
;
		LDX	<ENINDX
		PLB
		RTS
;
;========================================================================
;=		afXN[JE^[Zbg			=
;========================================================================
WAVE_X		EQU	$
		WORD	01H,01H,00H,01H,02H,02H,02H,01H
		WORD	02H,03H,01H,02H,03H,03H,02H,03H
		WORD	02H,03H,02H,02H,03H,03H,02H,03H
;
BG_WAVE_SET	EQU	$
		PHB			;(DBR) save
		LDY	#BANK COS	;(DBR) <-- COS(B)
		PHY
		PLB
;
		LDA	SCCH2		;afXN[JE^[Zbg
		STA	>HDMABUF
		LDA	ENWRKC,X
		CLC
		ADC	#02H*2
		AND	#00FFH*2
		STA	ENWRKC,X
;
		I16
;
		TAY
		LDX	#(18H-1)*2
BG_WAVE_SET_10	EQU	$
		LDA	SCCH2
		BNE	BG_WAVE_SET_20	;H ( yes:BG_WAVE_SET_20 )
;
		LDA	!COS,Y
;
		M8
;
		STA	211BH
		XBA
		STA	211BH
		LDA	>WAVE_X,X
		STA	211CH
;
		M16
;
		LDA	SCCH2
		CLC
		ADC	2135H
BG_WAVE_SET_20	EQU	$
		STA	>HDMABUF+2,X
;
		TYA
		SEC
		SBC	#030H*2
		AND	#00FFH*2
		TAY
		DEX
		DEX
		BPL	BG_WAVE_SET_10
;
		I8
;
		LDA	#00010000B	;afQX^[XN[Zbg
		TSB	HD420C
;
		LDX	<ENINDX
		PLB
		RTS
;
;************************************************************************
;*		Zbgi~[WJ̉_ijj			*
;************************************************************************
DM_KUMO1IN	EQU	$
		LDA	#0FEC0H
		BRA	DM_KUMO_INIT
;
;************************************************************************
;*		Zbgi~[WJ̉_ijj			*
;************************************************************************
DM_KUMO2IN	EQU	$
		LDA	#0FFC0H
		BRA	DM_KUMO_INIT
;
;************************************************************************
;*		Zbgi~[WJ̉_ijj			*
;************************************************************************
DM_KUMO0IN	EQU	$
		LDA	#0FC00H
DM_KUMO_INIT	EQU	$
		STA	ENXSPD,X	;_̈ړXs[hZbg
		STA	ENXMAX,X
;
;************************************************************************
;*			  i~[WJ̉_iAAjj		*
;************************************************************************
DM_KUMO0MV	EQU	$
DM_KUMO1MV	EQU	$
DM_KUMO2MV	EQU	$
		LDY	ENDORE,X
		LDA	ESCCH1,Y
		BNE	DM_KUMOMV_000	;[vH ( no:DM_KUMOMV_000 )
		JMP	DM_KUMOMV_020
;
;-------------- _̖̎ւ̕ύX`FbN ------------------------------
DM_KUMOMV_000	EQU	$
		LDA	ENDSXL,X
		BMI	DM_KUMOMV_002	;\H ( no:DM_KUMOMV_002 )
		JMP	DM_KUMOMV_030
;
DM_KUMOMV_002	EQU	$
		LDA	ENXSPD,X
		EOR	#0FFFFH
		LSR	A
		LSR	A
		LSR	A
		ADC	#040H
		TAY
		STY	4202H
		LDY	ENXPSL,X
		STY	4203H
;
;.............. |Z̃EFCg ................................
		LDA	#02FFH		;afQ\
		STA	ENRETN,X
		LDA	ENYUSN,X	;naiD揇ʕύX
		EOR	#04H
		STA	ENYUSN,X
		LDA	ENCHPT,X	;p^[mDύX
		EOR	#01H
		STA	ENCHPT,X
;................................................................
;
		LDA	4216H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		EOR	#0FFFFH
		SEC
		ADC	#0F0H
		STA	ENXPSL,X	;wWăZbg
		INC	<ENWRK0,X
		LDA	<ENWRK0,X
		CMP	#03H
		BCC	DM_KUMOMV_010	;_ ăZbgH ( yes:DM_KUMOMV_010 )
		JSL	>ENCLEAR
		RTS
;
DM_KUMOMV_010	EQU	$
		LSR	A		;(C) <-- ړXs[hύX[h
		BCC	DM_KUMOMV_012
;
		TXA
		AND	#04H
		BEQ	DM_KUMOMV_011	;\ZbgH ( no:DM_KUMOMV_011 )
;
		LDA	ENYUSN,X
		ORA	#0F0H
		STA	ENYUSN,X
DM_KUMOMV_011	EQU	$
		LDA	ENXSPD,X	;ړXs[hύX
		ASR16
		ASR16
		BRA	DM_KUMOMV_014
;
DM_KUMOMV_012	EQU	$
		LDA	ENYUSN,X	;\Zbg
		AND	#0FH
		STA	ENYUSN,X
;
		LDA	ENXSPD,X	;ړXs[hύX
		ASL	A
		ASL	A
DM_KUMOMV_014	EQU	$
		STA	ENXSPD,X
		STA	ENXMAX,X
		LDA	ENCLOR,X	;afD揇ʕύX
		EOR	#030H
		STA	ENCLOR,X
;
DM_KUMOMV_020	EQU	$
		LDA	ENXPSL,X	;[vZbg
		BPL	DM_KUMOMV_030
;
		LDA	#00F0H
		STA	ENXPSL,X
DM_KUMOMV_030	EQU	$
		RTS
;
;
;************************************************************************
;*		Zbgi~[WJ̃JbNiY[jj		*
;************************************************************************
DM_KAMK0IN	EQU	$
		LDA	#1800H		;ŏ{Zbg
		STA	<ENCONT,X
;
;************************************************************************
;*			(~[WJ̃JbNiY[jj		*
;************************************************************************
DM_KAMK0MV	EQU	$
		LDA	SCCH1
		CMP	#0100H
		BCC	DM_KAMEKMV_020	;O̖H ( no:DM_KAMEKMV_020 )
;
		LDA	#0C0H+(10H*100H)
		STA	<EWORK0		;(EWK0,1) <-- ړwCxXs[h
		LDA	#CIPCHD2+1
		STA	R10		;(R10) <-- LN^[AhXikCgj
;
		LDA	<ENCONT,X
		SEC
		SBC	#014H
		CMP	#080H
		BCS	DM_KAMEKMV_010	;ʂ߂H ( no:DM_KAMEKMV_010 )
;
;-------------- fnaiNA[ --------------------------------------
		JSL	>ENCLEAR
;
		LDY	#00000010B	;naiTCYύXiŴPUj
		STY	OBJSEL
;
		LDX	#CHRDA		;(X) <-- LN^[f[^mD
		LDA	#5000H		;(A) <-- uq`lAhX
		JMP	CHAR_CHANGE
;
ZOOM_CHAR_SET	EQU	$
DM_KAMEKMV_010	EQU	$
		STA	<ENCONT,X
		STA	R6		;(R6)  <-- {
;
		CMP	#0480H		;(C) set
;
		LDA	#07H		;\Zbg
		BCS	DM_KAMEKMV_012	 ;naiD揇ʁijH ( no:DM_KAMEKMV_012 )
		LDA	#04H
DM_KAMEKMV_012	EQU	$
		STA	ENYUSN,X
;
		LDA	#BANK CIPCHD2
		STA	R11		;(R11) <-- LN^[AhXiaj
		M_CHIP	C_128_ZOOM_64
;
		LDA	#2000H		;Y[nai]II
		STA	OBM7WF
;
		LDX	<ENINDX
		LDY	#01100010B	;naiTCYύXiPÛRQj
		STY	OBJSEL
;
;-------------- ړXs[hvZ ----------------------------------------
		LDY	R4
		STY	211BH
		LDY	R4+1
		STY	211BH
		LDY	<EWORK0
		STY	211CH
		LDA	2135H
		ASL	A
		STA	ENXSPD,X	;wړXs[hZbg
		LDY	<EWORK1
		STY	211CH
		LDA	2135H
		ASL	A
		STA	ENYSPD,X	;xړXs[hZbg
;
DM_KAMEKMV_020	EQU	$
		RTS
;
;************************************************************************
;*		Zbgi~[WJ̃JbNijj		*
;************************************************************************
DM_KAMK1IN	EQU	$
		LDA	#0F7A0H		;wړXs[hZbg
		STA	ENXSPD,X
;
;************************************************************************
;*			(~[WJ̃JbNijj			*
;************************************************************************
DM_KAMK1MV	EQU	$
		LDA	ENXPSL,X
		BPL	DM_KAMK1MV_010	;fnaiNA[H ( no:DM_KAMK1MV_010 )
;
;-------------- fnaiNA[ --------------------------------------
		JSL	>ENCLEAR
		RTS
;
DM_KAMK1MV_010	EQU	$
		CMP	#0200H
		BPL	DM_KAMK1MV_020	;REmgɓH ( no:DM_KAMK1MV_020 )
;
;-------------- REmg]Zbg ------------------------------------
		LDY	<ENWRK2+BIRD0_IX
		BNE	DM_KAMK1MV_050	;REmg]H ( yes:DM_KAMK1MV_050 )
;
		LDA	#0200H
		STA	ENXPSL,X
		LDY	ENCHPT+BIRD0_IX
		CPY	#12-1
		BNE	DM_KAMK1MV_020	;REmgp^[njH ( no:DM_KAMK1MV_020 )
;
		LDA	#02H		;REmg]tOZbg
		STA	<ENWRK2+BIRD0_IX
		LDA	#080H		;u[LO{Zbg
		STA	ENXMAX+BIRD0_IX
		LDA	#256/1		;]Xs[hZbg
		STA	ENWRK8+BIRD0_IX
		STZ	ENTIM1+BIRD0_IX ;H΂tOZbg
		STZ	ENXSPD+BIRD0_IX ;ړXs[hZbg
		STZ	ENYSPD+BIRD0_IX
		STZ	ENXPOW+BIRD0_IX
		STZ	ENGPOW+BIRD0_IX
;
		LDA	#029H		;p^[؂ւ^C}[Zbg
		STA	ENTIM0,X
DM_KAMK1MV_020	EQU	$
		RTS
;
;-------------- C[WDp^[Zbg ------------------------------
DM_KAMK1MV_050	EQU	$
		LDA	ENTIM0,X
		BNE	DM_KAMK1MV_060	;p^[؂ւH ( no:DM_KAMK1MV_060 )
;
		LDA	#04H
		STA	ENTIM0,X
		LDA	ENCHPT,X
		CMP	#3
		BCS	DM_KAMK1MV_060	;l`wp^[H ( yes:DM_KAMK1MV_060 )
;
		INC	ENCHPT,X
DM_KAMK1MV_060	EQU	$
		RTS
;
;************************************************************************
;*		Zbgi~[WJ̏j				*
;************************************************************************
DM_TSUE0IN	EQU	$
		LDA	#256/2		;]Xs[hZbg
		STA	<ENWRK2,X
		LDA	#080H
		STA	ENXSPD,X
		LDA	#0FC00H		;ړXs[hZbg
		BRA	DM_KOZU0IN_010
;
;************************************************************************
;*		Zbgi~[WJ̏ijj			*
;************************************************************************
DM_KOZU0IN	EQU	$
		LDA	#0FF80H
		STA	ENXSPD,X
		LDA	#0FD00H		;ړXs[hZbg
DM_KOZU0IN_010	EQU	$
		STA	ENYSPD,X
		LDA	#020H		;d̓Zbg
		STA	ENGPOW,X
		LDA	#0300H
		STA	ENGMAX,X
;
;************************************************************************
;*			(~[WJ̏ijj			*
;************************************************************************
DM_KOZU0MV	EQU	$
		RTS
;
;************************************************************************
;*			(~[WJ̏j				*
;************************************************************************
TSUE0_PTN	EQU	$
		WORD	0,   1,	  1,   0,   0,	 1,   1,   0
TSUE0_ATT	EQU	$
		WORD	000H,000H,040H,040H,0C0H,0C0H,080H,080H
;
DM_TSUE0MV	EQU	$
		LDA	<ENWRK4,X
		CLC
		ADC	<ENWRK2,X
		STA	<ENWRK4,X
		XBA
		AND	#07H
		ASL	A
		TAY
		LDA	!TSUE0_PTN,Y	;̃p^[mDZbg
		STA	ENCHPT,X
		LDA	ENCLOR,X
		AND	#003FH
		ORA	!TSUE0_ATT,Y	;̃tbvZbg
		STA	ENCLOR,X
		RTS
;
;************************************************************************
;*		Zbgi~[WJ̏iY[jj		*
;************************************************************************
DM_KOZU1IN	EQU	$
		LDA	#080H		;ő{Zbg
		STA	<ENCONT,X
;
;************************************************************************
;*			(~[WJ̏iY[jj			*
;************************************************************************
DM_KOZU1MV	EQU	$
		LDA	SCCH1
		CMP	#0100H
		BCC	DM_KOZU1MV_020	;O̖H ( no:DM_KOZU1MV_020 )
;
		LDA	#000H+(00H*100H)
		STA	<EWORK0		;(EWK0,1) <-- ړwCxXs[h
		LDA	#CIPCHD2+40H+1
		STA	R10		;(R10) <-- LN^[AhXikCgj
;
		LDA	<ENCONT,X
		CLC
		ADC	#010H
		CMP	#1B00H
		BCC	DM_KOZU1MV_010	;Ă܂H ( no:DM_KOZU1MV_010 )
;
;-------------- fnaiNA[ --------------------------------------
		LDY	ENYUSN,X
		BMI	DM_KOZU1MV_000	;ǉLN^[ZbgH ( yes:DM_KOZU1MV_000 )
;
		DEY			;[ LDA #0FFH ]
		TYA			;
		STA	ENYUSN,X
;
		LDY	#00000010B	;naiTCYύXiŴPUj
		STY	OBJSEL
;
		LDX	#CHRDC		;(X) <-- LN^[f[^mD
		LDA	#4000H		;(A) <-- uq`lAhX
		JMP	CHAR_CHANGE
;
DM_KOZU1MV_000	EQU	$
		JSL	>ENCLEAR
;
		LDX	#CHR09		;(X) <-- LN^[f[^mD
		LDA	#5400H		;(A) <-- uq`lAhX
		JMP	CHAR_CHANGE
;
DM_KOZU1MV_010	EQU	$
		JSR	ZOOM_CHAR_SET
;
DM_KOZU1MV_020	EQU	$
		RTS
;
;
;
;
;
;****************************************************************
;*								*
;*		I[vjO f				*
;*				()			*
;****************************************************************
		MEM16
OPDM_KMLB	EQU	$
		STA	R10
		LDA	#00030H		; px
		STA	R2
		LDA	#00070H
		STA	R3
		LDA	#00090H
		STA	R4
		LDA	#000A0H
		STA	R5
		LDA	#03800H		; EBhE X^[g|Cg
		STA	R6
		LDA	#05800H
		STA	R7
		LDA	#07000H
		STA	R8
		LDA	#08000H
		STA	R9
;
		M_CHIP	OPDM_WINDOW
;
		I16			; index 16bit mode
		JSL	>M_DMA_BFST	; data trans.
		LWORD	HDMABUF2+8	; to address set
		LWORD	HDMABF		; from address set
		WORD	070H*4		; number of byte set
		I8			; index 8bit mode
		RTS
;
		MEM8
;
;
;****************************************************************
;*								*
;*		I[vjO f bZ[W			*
;*					(CjV)		*
;****************************************************************
;
		DPAGE	WORK0
;
OPMSGINITSET	EQU	$
		M16			; memory 16bit mode
		LDX	#000H
		LDA	#01400H
		STA	<WORK0
		LDA	#01800H
		STA	<WORK2
		LDA	#01C00H
		STA	<WORK4
;
OPMSGINITSET_00 EQU	$
		LDA	<WORK0
		STA	!OPMSGBFNK,X
;
		LDA	<WORK2
		STA	!OPMSGBFU0,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU1,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU2,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU3,X
;
		LDA	<WORK4
		STA	!OPMSGBFD0,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD1,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD2,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD3,X
;
		INC	<WORK2
		INC	<WORK4
		INX
		INX
		CPX	#020H
		BCC	OPMSGINITSET_00
;
		LDA	#01840H
		STA	<WORK2
		LDA	#01C40H
		STA	<WORK4
OPMSGINITSET_10 EQU	$
		LDA	<WORK0
		STA	!OPMSGBFNK,X
;
		LDA	<WORK2
		STA	!OPMSGBFU0,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU1,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU2,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU3,X
;
		LDA	<WORK4
		STA	!OPMSGBFD0,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD1,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD2,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD3,X
;
		INC	<WORK2
		INC	<WORK4
		INX
		INX
		CPX	#040H
		BCC	OPMSGINITSET_10
;
		JSR	OPMSGSET_6SB	; kL Zbg!!
;
		LDA	#07E80H
		STA	!OPMSGSCR
		JSR	OPMSGSET_100
;
		INC	!MSGTRF		; cl`]tO nm !!
		LDA	#000A0H
		STA	!OPMSGTIM
		STZ	!OPMSGMOD
		STZ	!OPMSGDTPT
		STZ	!OPMSGSCV
		STZ	!OPMSGBFCT
		STZ	!OPNEXTFG	; V[؂芷tO NA
		LDA	#0FFFFH
		STA	<SCCV4
		LDA	#00000H
		STA	>DATACOL+0E0H+012H
		STA	>DATACOL+0E0H+016H
		STA	>DATACOL+0E0H+01CH
		STA	>DATACOL+0E0H+01EH
;
		M8			; memory 8bit mode
		STZ	!OPMSGMD
;
		RTS
;
;************************************************************************
;*									*
;*		I[vjO f bZ[W				*
;*									*
;************************************************************************
OPMSGSET	EQU	$
		M16			; memory 16bit mode
		LDA	!OPMSGTIM
		BNE	OPMSGSET_PAS0
;
OPMSGSET_SET	EQU	$
		LDA	!OPMSGMOD
		ASL	A
		TAX
		JSR	(OPMSGSET_ADR,X)
		BRA	OPMSGSET_PAS1
;
OPMSGSET_PAS0	EQU	$
		DEC	!OPMSGTIM
OPMSGSET_PAS1	EQU	$
		LDA	!OPMSGMOD
		CMP	#00006H
		BNE	OPMSGSET_PAS2
;
 IF  PAL  ;**** PAL Ή [1995/07/28] *****************************
		LDX	!OPMSGDTPT
		LDA	!LNGG_SL
		BNE	LNGG_PASS_00
		LDA	OPMSGSET_3DT,X
		BRA	LNGG_PASS_90
LNGG_PASS_00	EQU	$
		DEC	A
		BNE	LNGG_PASS_20
		LDA	OPMSGSET_3DT_F,X
		BRA	LNGG_PASS_90
LNGG_PASS_20	EQU	$
		LDA	OPMSGSET_3DT_D,X
LNGG_PASS_90	EQU	$
 ENDIF	  ;**** PAL Ή [1995/07/28] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/07/28] *****************************
		LDX	!OPMSGDTPT
		LDA	OPMSGSET_3DT,X
 ENDIF	       ;**** { or NES Ή [1995/07/28] *****************************
		BEQ	OPMSGSET_END
OPMSGSET_PAS2	EQU	$
		STZ	!OPNEXTFG
OPMSGSET_END	EQU	$
		M8			; memory 8bit mode
		RTS
;
OPMSGSET_ADR	EQU	$
		WORD	OPMSGSET_000,OPMSGSET_100
		WORD	OPMSGSET_200,OPMSGSET_300
		WORD	OPMSGSET_400,OPMSGSET_500
		WORD	OPMSGSET_600
;
		MEM16
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W LN^[ CjVcl`]		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_000	EQU	$
		JSR	OPMSGSET_300
;
		LDA	#07E80H
		STA	!OPMSGSCR
		STZ	!OPMSGBFCT
		LDA	#0FFFFH
		STA	<SCCV4
		STZ	!OPMSGSCV
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W LN^[ (CjVXN[)	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_100	EQU	$
		JSR	OPMSGSET_400
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[h AEg					+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_200	EQU	$
		LDA	>DATACOL+0E0H+012H
		CLC
		ADC	#00421H
		CMP	#08000H
		BCC	OPMSGSET_250
;
 IF  PAL  ;**** PAL Ή [1995/07/28] *****************************
		LDX	!LNGG_SL
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		ADC	OPMSG_TIM_CNT,X
		TAX
		LDA	OPMSGSET_TIM,X
 ENDIF	  ;**** PAL Ή [1995/07/28] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/07/28] *****************************
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		TAX
		LDA	OPMSGSET_TIM,X
 ENDIF	       ;**** { or NES Ή [1995/07/28] *****************************
;
		STA	!OPMSGTIM
		INC	!OPMSGMD
		INC	!OPMSGMOD	; MODE INC.
		LDA	#07FFFH
OPMSGSET_250	EQU	$
		STA	>DATACOL+0E0H+012H
		STA	>DATACOL+0E0H+016H
		STA	>DATACOL+0E0H+01CH
		STA	>DATACOL+0E0H+01EH
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[W LN^[ cl`]		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_300	EQU	$
 IF  PAL  ;**** PAL Ή [1995/07/28] *****************************
		LDX	!OPMSGDTPT
		LDA	!LNGG_SL
		BNE	OPMSGSET_300_00
		LDA	OPMSGSET_3DT,X
		BRA	OPMSGSET_300_90
OPMSGSET_300_00 EQU	$
		DEC	A
		BNE	OPMSGSET_300_20
		LDA	OPMSGSET_3DT_F,X
		BRA	OPMSGSET_300_90
OPMSGSET_300_20 EQU	$
		LDA	OPMSGSET_3DT_D,X
OPMSGSET_300_90 EQU	$
 ENDIF	  ;**** PAL Ή [1995/07/28] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/07/28] *****************************
		LDX	!OPMSGDTPT
		LDA	OPMSGSET_3DT,X
 ENDIF	       ;**** { or NES Ή [1995/07/28] *****************************
;
		BEQ	OPMSGSET_350
		CMP	#0FFFFH
		BEQ	OPMSGSET_390
		STA	!OPMSGADR
		LDA	#BANK OPMSGSET_3DT
		STA	!OPMSGADRB
;
		M8			; memory 8bit mode
		LDA	!CIPSCB
		PHA
		LDA	!CIPSCR
		PHA
		LDA	#DM01_MSGBITMP/400H
		STA	!CIPSCB
		LDA	#00111100B
		STA	!CIPSCR
		M16			; memory 16bit mode
;
		M_CHIP	OPMJSET
;
		M8			; memory 8bit mode
		PLA
		STA	!CIPSCR
		PLA
		STA	!CIPSCB
		M16			; memory 16bit mode
;
		INC	!MSGTRF		; cl`]tO nm !!
		INC	!OPMSGMOD	; MODE INC.
		INC	!OPMSGDTPT
		INC	!OPMSGDTPT
		INC	!OPMSGSCV
		INC	!OPMSGSCV
		BRA	OPMSGSET_390
OPMSGSET_350	EQU	$
		LDA	!OPNEXTFG
		BEQ	OPMSGSET_390
		LDA	#00006H
		STA	!OPMSGMOD
OPMSGSET_390	EQU	$
		RTS
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/20] *****************
OPMSGSET_3DT	EQU	$
		WORD	OPMSG_DT00,OPMSG_DT02,00000H
;
		WORD	OPMSG_DT10,OPMSG_DT12,OPMSG_DT14,OPMSG_DT16,00000H
;
		WORD	OPMSG_DT20,OPMSG_DT22,00000H
;
		WORD	OPMSG_DT30,OPMSG_DT32,OPMSG_DT34,00000H
;
		WORD	OPMSG_DT40,OPMSG_DT42,OPMSG_DT44,00000H
;
		WORD	OPMSG_DT50,OPMSG_DT54,OPMSG_DT56,OPMSG_DT58
		WORD	OPMSG_DT5A,OPMSG_DT5C,OPMSG_DT5E,00000H
;
		WORD	OPMSG_DT60,OPMSG_DT62,OPMSG_DT64,00000H
;
		WORD	OPMSG_DT70,OPMSG_DT72,OPMSG_DT74,OPMSG_DT76
		WORD	00000H
;
		WORD	OPMSG_DT80,OPMSG_DT82,OPMSG_DT84,00000H
;
		WORD	OPMSG_DT90,0FFFFH
 ENDIF	  ;**** NES or PAL Ή [1995/7/20] **********************
;
;
 IF  PAL  ;**** PAL Ή [1995/7/21] *****************************
OPMSGSET_3DT_F	EQU	$
		WORD	OPMSG_DT00_F,00000H
;
		WORD	OPMSG_DT10_F,OPMSG_DT11_F,OPMSG_DT12_F,OPMSG_DT13_F
		WORD	OPMSG_DT14_F,00000H
;
		WORD	OPMSG_DT20_F,OPMSG_DT21_F,00000H
;
		WORD	OPMSG_DT30_F,00000H
;
		WORD	OPMSG_DT40_F,00000H
;
		WORD	OPMSG_DT50_F,OPMSG_DT51_F,OPMSG_DT52_F,OPMSG_DT53_F
		WORD	OPMSG_DT54_F,OPMSG_DT55_F,OPMSG_DT56_F,00000H
;
		WORD	OPMSG_DT60_F,OPMSG_DT61_F,OPMSG_DT62_F,00000H
;
		WORD	OPMSG_DT70_F,OPMSG_DT71_F,OPMSG_DT72_F,OPMSG_DT73_F
		WORD	00000H
;
		WORD	OPMSG_DT80_F,OPMSG_DT81_F,OPMSG_DT82_F,OPMSG_DT83_F
		WORD	00000H
;
		WORD	OPMSG_DT90_F,OPMSG_DT91_F,0FFFFH
;
;
OPMSGSET_3DT_D	EQU	$
		WORD	OPMSG_DT00_D,OPMSG_DT01_D,00000H
;
		WORD	OPMSG_DT10_D,OPMSG_DT11_D,OPMSG_DT12_D
		WORD	OPMSG_DT13_D,00000H
;
		WORD	OPMSG_DT20_D,OPMSG_DT21_D,00000H
;
		WORD	OPMSG_DT30_D,OPMSG_DT31_D,OPMSG_DT32_D
		WORD	OPMSG_DT33_D,00000H
;
		WORD	OPMSG_DT40_D,OPMSG_DT41_D,00000H
;
		WORD	OPMSG_DT50_D,OPMSG_DT51_D,OPMSG_DT52_D
		WORD	OPMSG_DT53_D,OPMSG_DT54_D,OPMSG_DT55_D
		WORD	OPMSG_DT56_D,OPMSG_DT57_D,OPMSG_DT58_D
		WORD	00000H
;
		WORD	OPMSG_DT60_D,OPMSG_DT61_D,OPMSG_DT62_D
		WORD	00000H
;
		WORD	OPMSG_DT70_D,OPMSG_DT71_D,OPMSG_DT72_D
		WORD	OPMSG_DT73_D,OPMSG_DT74_D,OPMSG_DT75_D
		WORD	OPMSG_DT76_D,00000H
;
		WORD	OPMSG_DT80_D,OPMSG_DT81_D,OPMSG_DT82_D
		WORD	00000H
;
		WORD	OPMSG_DT90_D,OPMSG_DT91_D,0FFFFH
;
OPMSGSET_CNT	EQU	$
		BYTE	OPMSGSET_3DT-OPMSGSET_3DT
		BYTE	OPMSGSET_3DT_F-OPMSGSET_3DT
		BYTE	OPMSGSET_3DT_D-OPMSGSET_3DT
 ENDIF	  ;**** PAL Ή [1995/7/21] *****************************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
OPMSGSET_3DT	EQU	$
		WORD	OPMSG_DT00,00000H
;
		WORD	OPMSG_DT10,OPMSG_DT12,OPMSG_DT14,00000H
;
		WORD	OPMSG_DT20,OPMSG_DT22,00000H
;
		WORD	OPMSG_DT30,OPMSG_DT32,00000H
;
		WORD	OPMSG_DT40,OPMSG_DT42,00000H
;
		WORD	OPMSG_DT50,OPMSG_DT52,OPMSG_DT54
		WORD	OPMSG_DT56,OPMSG_DT58,OPMSG_DT5A,00000H
;
		WORD	OPMSG_DT60,OPMSG_DT62,00000H
;
		WORD	OPMSG_DT70,OPMSG_DT72,OPMSG_DT74
		WORD	00000H
;
		WORD	OPMSG_DT80,OPMSG_DT82,00000H
;
		WORD	OPMSG_DT90,0FFFFH
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[W LN^[ (XN[)	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_400	EQU	$
		INC	!OPMSGMOD
		I16			; index 16bit mode
		LDA	#BANK OPMSGBFU0
		STA	<WORK1		; (WK1) <-- ]AhX (a)
		LDA	!OPMSGBIG	; 啶 ?
		BEQ	OPMSGSET_430	;	NO -> OPMSGSET_430
;
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	!OPMSGBFCT
		LDA	OPMSGSET_4DT,X
		TAX			; (X) <-- ]AhX (k,g)
		LDA	#00080H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB0
		JSR	OPMSGSET_4SB1
		BRA	OPMSGSET_450
;
OPMSGSET_430	EQU	$
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	!OPMSGBFCT
		LDA	OPMSGSET_4DT,X
		TAX			; (X) <-- ]AhX (k,g)
		LDA	#00080H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB0
		JSR	OPMSGSET_4SB1
;
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB1
;
OPMSGSET_450	EQU	$
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	!OPMSGBFCT
		LDA	OPMSGSET_4DT,X
		TAX			; (X) <-- ]AhX (k,g)
		LDA	#00080H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB0
		JSR	OPMSGSET_4SB1
;
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB1
;
		LDA	!OPMSGBIG
		BEQ	OPMSGSET_480
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB1
;
OPMSGSET_480	EQU	$
		I8			; index 8bit mode
		RTS
;
OPMSGSET_4DT	EQU	$
		WORD	OPMSGBFU0,OPMSGBFU1
		WORD	OPMSGBFU2,OPMSGBFU3
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		XN[	JE^[ INC	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_4SB0	EQU	$
		LDA	!OPMSGBFCT
		CLC
		ADC	#00002H
		AND	#00007H
		STA	!OPMSGBFCT
;
OPMSGSET_4SB1	EQU	$
		LDA	!OPMSGSCR
		CLC
		ADC	#00020H
		STA	!OPMSGSCR
		AND	#07FF0H
		BNE	OPMSGSET_4SB_PS
		LDA	#07C00H
		STA	!OPMSGSCR
OPMSGSET_4SB_PS EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[W XN[ XN[		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_500	EQU	$
		LDX	!OPMSGSCV
		LDA	<SCCV4
		CLC
		ADC	#00002H
		STA	<SCCV4
		CMP	OPMSGSET_5DT,X
		BCC	OPMSGSET_590
		LDA	OPMSGSET_5DT,X
		STA	<SCCV4
		LDA	#00003
		STA	!OPMSGMOD
;
 IF  PAL  ;**** PAL Ή [1995/07/28] *****************************
		LDX	!LNGG_SL
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		ADC	OPMSG_TIM_CNT,X
		TAX
		LDA	OPMSGSET_TIM,X
 ENDIF	  ;**** PAL Ή [1995/07/28] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/07/28] *****************************
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		TAX
		LDA	OPMSGSET_TIM,X
 ENDIF	       ;**** { or NES Ή [1995/07/28] *****************************
;
		STA	!OPMSGTIM
		INC	!OPMSGMD
OPMSGSET_590	EQU	$
		RTS
;
OPMSGSET_5DT	EQU	$-2
		WORD	0002FH,0005FH,0008FH,000BFH,000EFH,0011FH,0014FH
		WORD	0017FH
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[h C					+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_600	EQU	$
		LDA	>DATACOL+0E0H+012H
		SEC
		SBC	#00421H
		BPL	OPMSGSET_650
		INC	!OPMSGDTPT
		INC	!OPMSGDTPT
		JSR	OPMSGSET_6SB
		STZ	!OPMSGMOD	; MODE INC.
;
 IF  PAL  ;**** PAL Ή [1995/07/28] *****************************
		LDX	!LNGG_SL
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		ADC	OPMSG_TIM_CNT,X
		TAX
		LDA	OPMSGSET_TIM,X
 ENDIF	  ;**** PAL Ή [1995/07/28] *****************************
;
;
 IF  JPN | NES ;**** { or NES Ή [1995/07/28] *****************************
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		TAX
		LDA	OPMSGSET_TIM,X
 ENDIF	       ;**** { or NES Ή [1995/07/28] *****************************
;
		STA	!OPMSGTIM
		INC	!OPMSGMD
		LDA	#00000H
OPMSGSET_650	EQU	$
		STA	>DATACOL+0E0H+012H
		STA	>DATACOL+0E0H+016H
		STA	>DATACOL+0E0H+01CH
		STA	>DATACOL+0E0H+01EH
		RTS
;
BLACK	EQU	00050H
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/20] *****************
OPMSGSET_TIM	EQU	$
		WORD	00180H,00140H,BLACK					;0
		WORD	00180H,001E0H,00100H,00130H,00020H			;1
		WORD	000C0H,00100H,BLACK					;2
		WORD	000A0H,001C0H,00180H,BLACK				;3
		WORD	00170H,00100H,00080H,BLACK				;4
		WORD	00140H,00140H,00080H,00150H,00160H,00160H,00120H,BLACK	;5
		WORD	00180H,00180H,00180H,BLACK				;6
		WORD	00090H,00180H,00180H,00180H,BLACK			;7
		WORD	00180H,00180H,00180H,00050H				;8
		WORD	00000H
 ENDIF	  ;**** NES or PAL Ή [1995/7/20] **********************
;
;
 IF  PAL  ;**** PAL Ή [1995/7/21] *****************************
OPMSGSET_TIM_F	EQU	$
		WORD	00180H,BLACK						;0
		WORD	00160H,00120H,00160H,00160H,00140H,BLACK		;1
		WORD	000C0H,00100H,BLACK					;2
		WORD	00180H,BLACK						;3
		WORD	00180H,BLACK						;4
		WORD	00130H,00140H,000E0H,000B0H,00140H,00180H,00180H,BLACK	;5
		WORD	00180H,00120H,00180H,BLACK				;6
		WORD	000A0H,00180H,00180H,00140H,BLACK			;7
		WORD	00180H,00140H,00180H,00100H,BLACK			;8
		WORD	00180H,00000H
;
;
OPMSGSET_TIM_D	EQU	$
		WORD	00180H,00100H,BLACK					;0
		WORD	00180H,00180H,00180H,00100H,00100H			;1
		WORD	000C0H,00180H,BLACK					;2
		WORD	000A0H,00180H,00140H,000A0H,BLACK			;3
		WORD	00180H,00180H,BLACK					;4
		WORD	00180H,00160H,00180H,00150H,000B0H,00180H,00180H,000F0H
		WORD	00120H,BLACK						;5
		WORD	00180H,00180H,00100H,BLACK				;6
		WORD	00180H,00180H,00180H,000F0H,000A0H,00180H,00100H,BLACK	;7
		WORD	00180H,00180H,00180H,BLACK				;8
		WORD	00160H,00000H
;
OPMSG_TIM_CNT	EQU	$
		BYTE	OPMSGSET_TIM-OPMSGSET_TIM
		BYTE	OPMSGSET_TIM_F-OPMSGSET_TIM
		BYTE	OPMSGSET_TIM_D-OPMSGSET_TIM
 ENDIF	  ;**** PAL Ή [1995/7/21] *****************************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
OPMSGSET_TIM	EQU	$
		WORD	00000H,BLACK					;0
		WORD	00180H,00180H,00100H,BLACK			;1
		WORD	000C0H,00100H,BLACK				;2
		WORD	000A0H,001C0H,BLACK				;3
		WORD	00080H,001C0H,BLACK				;4
		WORD	00110H,00110H,00080H,00180H,00180H,001C0H,BLACK ;5
		WORD	001C0H,001C0H,BLACK				;6
		WORD	000A0H,00180H,00180H,BLACK			;7
		WORD	001C0H,001C0H,00050H				;8
		WORD	00000H
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		kL					+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_6SB	EQU	$
		LDA	#BANK OPMSGBFNK
		STA	<WORK1		; (WK1) <-- ]AhX (a)
		I16			; index 16bit mode
;
		LDY	#07E60H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07E80H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07EA0H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07EC0H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07EE0H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		I8			; index 8bit mode
		RTS
;
		MEM8
;
;;;;;; opdemo.dat
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/20] *****************
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ނAނ̂͂ȂłB		+
;+	}IƃbV[̂͂Ȃł	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	A long, long time ago...		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT00	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,02EH
		BYTE	E___A,M_SPC,E___l,E___o,E___n,E___g,M_Can,M_SPC
		BYTE	E___l,E___o,E___n,E___g,M_SPC,E___t,E___i,E___m
		BYTE	E___e,M_SPC,E___a,E___g,E___o,M_SPC,M_Pir,M_Pir
		BYTE	M_Pir
;
;
		BYTE	0FEH,001H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	This is a story about			+
;+	baby Mario and Yoshi.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT02	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,038H
		BYTE	E___T,E___h,E___i,E___s,M_SPC,E___i,E___s,M_SPC
		BYTE	E___a,M_SPC,E___s,E___t,E___o,E___r,E___y,M_SPC
		BYTE	E___a,E___b,E___o,E___u,E___t
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,03AH
		BYTE	E___b,E___a,E___b,E___y,M_SPC,E___M,E___a,E___r
		BYTE	E___i,E___o,M_SPC,E___a,E___n,E___d,M_SPC,E___Y
		BYTE	E___o,E___s,E___h,E___i,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	悠܂̂炢@REmg	+
;+	ĂŁ@Ƃł䂫܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	A stork hurries across the		+
;+	    dusky, pre-dawn sky.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT10	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,020H
		BYTE	M_SPC,E___A,M_SPC,E___s,E___t,E___o,E___r,E___k,M_SPC,E___h,E___u,E___r,E___r,E___i,E___e,E___s
		BYTE	M_SPC,E___a,E___c,E___r,E___o,E___s,E___s,M_SPC,E___t,E___h,E___e
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,036H
		BYTE	E___d,E___u,E___s,E___k,E___y,M_Can,M_SPC,E___p,E___r,E___e,M__Hi
		BYTE	E___d,E___a,E___w,E___n,M_SPC,E___s,E___k,E___y,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂΂Ɂ@ӂ̂	+
;+	Ƃ킦ā@@I	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	In his bill, he supports		+
;+	    a pair of twins.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT12	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,030H
		BYTE	E___I,E___n,M_SPC,E___h,E___i,E___s,M_SPC,E___b
		BYTE	E___i,E___l,E___l,M_Can,M_SPC,E___h,E___e,M_SPC
		BYTE	E___s,E___u,E___p,E___p,E___o,E___r,E___t,E___s
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,04DH
		BYTE	E___a,M_SPC,E___p,E___a,E___i,E___r,M_SPC,E___o
		BYTE	E___f,M_SPC,E___t,E___w,E___i,E___n,E___s,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂ƂÂ܂Xs[h	+
;+	Ł@ł@ЂƂ̂I	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Suddenly, a shadow appears		+
;+	in a gap between the clouds		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT14	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,020H
		BYTE	E___S,E___u,E___d,E___d,E___e,E___n,E___l,E___y
		BYTE	M_Can,M_SPC,E___a,M_SPC,E___s,E___h,E___a,E___d
		BYTE	E___o,E___w,M_SPC,E___a,E___p,E___p,E___e,E___a
		BYTE	E___r,E___s
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,024H
		BYTE	E___i,E___n,M_SPC,E___a,M_SPC,E___g,E___a,E___p
		BYTE	M_SPC,E___b,E___e,E___t,E___w,E___e,E___e,E___n
		BYTE	M_SPC,E___t,E___h,E___e,M_SPC,E___c,E___l,E___o
		BYTE	E___u,E___d,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	    and races towards the		+
;+	 stork with blinding speed.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT16	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,030H
		BYTE	E___a,E___n,E___d,M_SPC,E___r,E___a,E___c,E___e
		BYTE	E___s,M_SPC,E___t,E___o,E___w,E___a,E___r,E___d
		BYTE	E___s,M_SPC,E___t,E___h,E___e
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,029H
		BYTE	E___s,E___t,E___o,E___r,E___k,M_SPC,E___w,E___i
		BYTE	E___t,E___h,M_SPC,E___b,E___l,E___i,E___n,E___d
		BYTE	E___i,E___n,E___g,M_SPC,E___s,E___p,E___e,E___e
		BYTE	E___d,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	LB[bIEL[I	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	"SCRREEECH!!!"		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT20	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,010H
		BYTE	0FBH
		BYTE	M__DQ,E___S,E___C,E___R,E___R,E___E,E___E,E___E,E___E,E___C,E___H,M___X,M___X,M___X,M__DQ
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂@[I		+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	"THE BABIES ARE MINE!"			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT22	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,037H
		BYTE	M__DQ,E___T,E___H,E___E,M_SPC,E___B,E___A,E___B
		BYTE	E___I,E___E,E___S,M_SPC,E___A,E___R,E___E,M_SPC
		BYTE	E___M,E___I,E___N,E___E,M___X,M__DQ
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	킠I		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	WOW!!!			(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT30	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,054H
		BYTE	0FBH
		BYTE	E___W,E___O,E___W,M___X,M___X,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	́Aꂿ܁@	+
;+	Ђā@䂫܂B		+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Snatching only one baby,		+
;+	   the creature vanishes		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT32	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,030H
		BYTE	E___S,E___n,E___a,E___t,E___c,E___h,E___i,E___n
		BYTE	E___g,M_SPC,E___o,E___n,E___l,E___y,M_SPC,E___o
		BYTE	E___n,E___e,M_SPC,E___b,E___a,E___b,E___y,M_Can
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,039H
		BYTE	E___t,E___h,E___e,M_SPC,E___c,E___r,E___e,E___a
		BYTE	E___t,E___u,E___r,E___e,M_SPC,E___v,E___a,E___n
		BYTE	E___i,E___s,E___h,E___e,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	      into the darkness			+
;+	    from whence it came.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT34	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,047H
		BYTE	E___i,E___n,E___t,E___o,M_SPC,E___t,E___h,E___e
		BYTE	M_SPC,E___d,E___a,E___r,E___k,E___n,E___e,E___s
		BYTE	E___s
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,041H
		BYTE	E___f,E___r,E___o,E___m,M_SPC,E___w,E___h,E___e
		BYTE	E___n,E___c,E___e,M_SPC,E___i,E___t,M_SPC,E___c
		BYTE	E___a,E___m,E___e,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ȂƂƂł傤B	+
;+	ЂƂ肪Aā@܂܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	   The second baby falls		+
;+	    undetected towards			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT40	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,034H
		BYTE	E___T,E___h,E___e,M_SPC,E___s,E___e,E___c,E___o
		BYTE	E___n,E___d,M_SPC,E___b,E___a,E___b,E___y,M_SPC
		BYTE	E___f,E___a,E___l,E___l,E___s
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,03BH
		BYTE	E___u,E___n,E___d,E___e,E___t,E___e,E___c,E___t
		BYTE	E___e,E___d,M_SPC,E___t,E___o,E___w,E___a,E___r
		BYTE	E___d,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		the open sea...			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT42	EQU	$
		BYTE	0FEH,002H
		BYTE	0FEH,003H
		BYTE	0FDH,010H,0FCH,048H
		BYTE	E___t,E___h,E___e,M_SPC,E___o,E___p,E___e,E___n
		BYTE	M_SPC,E___s,E___e,E___a,M_Pir,M_Pir,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	QQQQEEE	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	OH NO...		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT44	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,048H
		BYTE	0FBH
		BYTE	E___O,E___H,M_SPC,E___N,E___O,M_Pir,M_Pir,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ۂ@̓bV[AChB	+
;+	bV[@ςł@܂ł	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	 Meanwhile, here is Yoshi's             +
;+	Island, home to all the Yoshies.	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT50	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,028H
		BYTE	E___M,E___e,E___a,E___n,E___w,E___h,E___i,E___l
		BYTE	E___e,M_Can,M_SPC,E___h,E___e,E___r,E___e,M_SPC
		BYTE	E___i,E___s,M_SPC,E___Y,E___o,E___s,E___h,E___i
		BYTE	M_SIZ,E___s
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,026H
		BYTE	E___I,E___s,E___l,E___a,E___n,E___d,M_Can,M_SPC
		BYTE	E___h,E___o,E___m,E___e,M_SPC,E___t,E___o,M_SPC
		BYTE	E___a,E___l,E___l,M_SPC,E___Y,E___o,E___s,E___h
		BYTE	E___i,E___e,E___s,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	҂̃bV[AۂイB	+
;+	́AƂĂ@悢Ă񂫂łB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		It's a lovely day,              +
;+	 and Yoshi is taking a walk.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT54	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,04AH
		BYTE	E___I,E___t,M_SIZ,E___s,M_SPC,E___a,M_SPC,E___l
		BYTE	E___o,E___v,E___e,E___l,E___y,M_SPC,E___d,E___a,E___y,M_Can
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,02DH
		BYTE	E___a,E___n,E___d,M_SPC,E___Y,E___o,E___s,E___h,E___i,M_SPC,E___i,E___s,M_SPC,E___t,E___a
		BYTE	E___k,E___i,E___n,E___g,M_SPC,E___a,M_SPC,E___w,E___a,E___l,E___k,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	EEEH		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	HUH?!?			(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT56	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,04CH
		BYTE	0FBH
		BYTE	E___H,E___U,E___H,M___Q,M___X,M___Q
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ȂƁ@炩@̂	+
;+	bV[́@ȂɁ@Ă܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	 Suddenly, a baby drops in		+
;+		  onto his back.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT58	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,028H
		BYTE	E___S,E___u,E___d,E___d,E___e,E___n,E___l,E___y,M_Can,M_SPC,E___a,M_SPC,E___b,E___a
		BYTE	E___b,E___y,M_SPC,E___d,E___r,E___o,E___p,E___s,M_SPC,E___i,E___n
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,04CH
		BYTE	E___o,E___n,E___t,E___o,M_SPC
		BYTE	E___h,E___i,E___s,M_SPC,E___b,E___a,E___c,E___k,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ@́AԂȂ悤B	+
;+	悩@悩B			+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	 The baby seems to be fine.		+
;+	   This is very fortunate!		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT5A	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,026H
		BYTE	E___T,E___h,E___e,M_SPC,E___b,E___a,E___b,E___y
		BYTE	M_SPC,E___s,E___e,E___e,E___m,E___s,M_SPC,E___t
		BYTE	E___o,M_SPC,E___b,E___e,M_SPC,E___f,E___i,E___n
		BYTE	E___e,M_Pir
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,030H
		BYTE	E___T,E___h,E___i,E___s,M_SPC,E___i,E___s,M_SPC
		BYTE	E___v,E___e,E___r,E___y,M_SPC,E___f,E___o,E___r
		BYTE	E___t,E___u,E___n,E___a,E___t,E___e,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	HقɂȂɂ@	+
;+	Ɂ@Ă̂EEEB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	 Wha-? Somethihg else fell		+
;+	       with the baby ...		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT5C	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02BH
		BYTE	E___W,E___h,E___a,M__Hi,M___Q,M_SPC,M_SPC,E___S
		BYTE	E___o,E___m,E___e,E___t,E___h,E___i,E___n,E___g
		BYTE	M_SPC,E___e,E___l,E___s,E___e,M_SPC,E___f,E___e
		BYTE	E___l,E___l
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,04EH
		BYTE	E___w,E___i,E___t,E___h,M_SPC,E___t,E___h,E___e
		BYTE	M_SPC,E___b,E___a,E___b,E___y,M_SPC,M_Pir,M_Pir
		BYTE	M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	     Let's take a peek ...              +
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT5E	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,038H
		BYTE	E___L,E___e,E___t,M_SIZ,E___s,M_SPC,E___t,E___a
		BYTE	E___k,E___e,M_SPC,E___a,M_SPC,E___p,E___e,E___e
		BYTE	E___k,M_SPC,M_Pir,M_Pir,M_Pir
;
;
		BYTE	0FEH,001H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ@́hĥ悤łB	+
;+	REmgAĂ̂H	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	It looks like a map. Maybe		+
;+	  the stork was using it?		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT60	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,028H
		BYTE	E___I,E___t,M_SPC,E___l,E___o,E___o,E___k,E___s
		BYTE	M_SPC,E___l,E___i,E___k,E___e,M_SPC,E___a,M_SPC
		BYTE	E___m,E___a,E___p,M_Pir,M_SPC,E___M,E___a,E___y
		BYTE	E___b,E___e
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,030H
		BYTE	E___t,E___h,E___e,M_SPC,E___s,E___t,E___o,E___r
		BYTE	E___k,M_SPC,E___w,E___a,E___s,M_SPC,E___u,E___s
		BYTE	E___i,E___n,E___g,M_SPC,E___i,E___t,M___Q
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǃbV[@Ղ񂩂ՂB	+
;+	Ȃ܂Ɓ@񂷂邱Ƃɂ܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	But Yoshi can't figure it               +
;+			 out.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT62	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,028H
		BYTE	E___B,E___u,E___t,M_SPC,E___Y,E___o,E___s,E___h
		BYTE	E___i,M_SPC,E___c,E___a,E___n,M_SIZ,E___t,M_SPC
		BYTE	E___f,E___i,E___g,E___u,E___r,E___e,M_SPC,E___i
		BYTE	E___t
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,058H
		BYTE	M_SPC,M_SPC,M_SPC,M_SPC,M_SPC,M_SPC,E___o,E___u,E___t,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Yoshi decides to talk to		+
;+		  his friends.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT64	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,02FH
		BYTE	E___Y,E___o,E___s,E___h,E___i,M_SPC,E___d,E___e
		BYTE	E___c,E___i,E___d,E___e,E___s,M_SPC,E___t,E___o
		BYTE	M_SPC,E___t,E___a,E___l,E___k,M_SPC,E___t,E___o
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,05DH
		BYTE	E___h,E___i,E___s,M_SPC,E___f,E___r,E___i,E___e
		BYTE	E___n,E___d,E___s,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ELbAELL[I	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	AAAAAAAAAAKK!		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT70	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,010H
		BYTE	0FBH
		BYTE	E___A,E___A,E___A,E___A,E___A,E___A,E___A,E___A
		BYTE	E___A,E___A,E___K,E___K,M___X,M___X,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	@̂́AJbN	+
;+	Nbp傤ɂށ@܂قB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Kamek, the evil Magikoopa,		+
;+	and kidnapper of the baby,		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT72	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,028H
		BYTE	E___K,E___a,E___m,E___e,E___k,M_Can,M_SPC,E___t
		BYTE	E___h,E___e,M_SPC,E___e,E___v,E___i,E___l,M_SPC
		BYTE	E___M,E___a,E___g,E___i,E___k,E___o,E___o,E___p
		BYTE	E___a,M_Can
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,027H
		BYTE	E___a,E___n,E___d,M_SPC,E___k,E___i,E___d,E___n
		BYTE	E___a,E___p,E___p,E___e,E___r,M_SPC,E___o,E___f
		BYTE	M_SPC,E___t,E___h,E___e,M_SPC,E___b,E___a,E___b
		BYTE	E___y,M_Can
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	@@ЂƂ@ƂĂ̂+
;+	@ā@Ԃɂɂ䂩܂+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	quickly dispatches his			+
;+		    toadies,			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT74	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,034H
		BYTE	E___q,E___u,E___i,E___c,E___k,E___l,E___y,M_SPC
		BYTE	E___d,E___i,E___s,E___p,E___a,E___t,E___c,E___h
		BYTE	E___e,E___s,M_SPC,E___h,E___i,E___s
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,06AH
		BYTE	E___t,E___o,E___a,E___d,E___i,E___e,E___s,M_Can
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	when he discovers that he		+
;+	   missed the other baby!		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT76	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02CH
		BYTE	E___w,E___h,E___e,E___n,M_SPC,E___h,E___e,M_SPC,E___d,E___i,E___s,E___c,E___o,E___v,E___e
		BYTE	E___r,E___s,M_SPC,E___t,E___h,E___a,E___t,M_SPC,E___h,E___e
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,036H
		BYTE	E___m,E___i,E___s,E___s,E___e,E___d,M_SPC,E___t
		BYTE	E___h,E___e,M_SPC,E___o,E___t,E___h,E___e,E___r
		BYTE	M_SPC,E___b,E___a,E___b,E___y,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Ȃ܂̂Ƃւނ@bV[ł	+
;+	ǂɂȂ邳@Ɓ@炭Ȃ悤B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Yoshi hedas leisurely back		+
;+	    to the other Yoshies,		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT80	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,029H
		BYTE	E___Y,E___o,E___s,E___h,E___i,M_SPC,E___h,E___e,E___a,E___d,E___s,M_SPC,E___l,E___e,E___i
		BYTE	E___s,E___u,E___r,E___e,E___l,E___y,M_SPC,E___b,E___a,E___c,E___k
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,037H
		BYTE	E___t,E___o,M_SPC,E___t,E___h,E___e,M_SPC,E___o
		BYTE	E___t,E___h,E___e,E___r,M_SPC,E___Y,E___o,E___s
		BYTE	E___h,E___i,E___e,E___s,M_Can
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;	unaware of the danger			+
;+		   at hand.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT82	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,038H
		BYTE	E___u,E___n,E___a,E___w,E___a,E___r,E___e,M_SPC
		BYTE	E___o,E___f,M_SPC,E___t,E___h,E___e,M_SPC,E___d
		BYTE	E___a,E___n,E___g,E___e,E___r
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,06AH
		BYTE	E___a,E___t,M_SPC,E___h,E___a,E___n,E___d,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	AJbŃ@܂イ	+
;+	́@䂭Ă܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Kamek's forces are actively             +
;+	     searching the island.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT84	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,020H
		BYTE	E___K,E___a,E___m,E___e,E___k,M_SIZ,E___s,M_SPC
		BYTE	E___f,E___o,E___r,E___c,E___e,E___s,M_SPC,E___a
		BYTE	E___r,E___e,M_SPC,E___a,E___c,E___t,E___i,E___v
		BYTE	E___e,E___l,E___y
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,03AH
		BYTE	E___s,E___e,E___a,E___r,E___c,E___h,E___i,E___n
		BYTE	E___g,M_SPC,E___t,E___h,E___e,M_SPC,E___i,E___s
		BYTE	E___l,E___a,E___n,E___d,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	͂ā@ӂ́@́@Ԃ	+
;+	ppƃ}}Ɂ@Ƃǂ̂ł傤	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	 Will these two children ever		+
;+	reach their parents safely?		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT90	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,022H
		BYTE	E___W,E___i,E___l,E___l,M_SPC,E___t,E___h,E___e,E___s,E___e,M_SPC,E___t,E___w,E___o,M_SPC
		BYTE	E___c,E___h,E___i,E___l,E___d,E___r,E___e,E___n,M_SPC,E___e,E___v,E___e,E___r
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,021H
		BYTE	E___r,E___e,E___a,E___c,E___h,M_SPC,E___t,E___h
		BYTE	E___e,E___i,E___r,M_SPC,E___p,E___a,E___r,E___e
		BYTE	E___n,E___t,E___s,M_SPC,E___s,E___a,E___f,E___e
		BYTE	E___l,E___y,M___Q
;
		BYTE	0FFH
 ENDIF	  ;**** NES or PAL Ή [1995/7/20] **********************
;
;
 IF  PAL  ;**** PAL Ή [1995/07/31] *****************************
;
;
;
;---------------------------------------------------------------------- tX
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ނAނ̂͂ȂłB		+
;+	}IƃbV[̂͂Ȃł	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Il tait une fois...			+
;+	... Bb Mario et Yoshi.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT00_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,03FH
		BYTE	E___I,E___l,M_SPC,F__e1,E___t,E___a,E___i,E___t,M_SPC,E___u,E___n,E___e,M_SPC,E___f,E___o,E___i
		BYTE	E___s,M_Pir,M_Pir,M_Pir
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,02EH
		BYTE	M_Pir,M_Pir,M_Pir,M_SPC,E___B,F__e1,E___b,F__e1,M_SPC,E___M,E___a,E___r,E___i,E___o,M_SPC,E___e
		BYTE	E___t,M_SPC,E___Y,E___o,E___s,E___h,E___i,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	悠܂̂炢@REmg	+
;+	ĂŁ@Ƃł䂫܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Peu avant l'aube,                       +
;+	une cigogne se hte			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT10_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,043H
		BYTE	E___P,E___e,E___u,M_SPC,E___a,E___v,E___a,E___n,E___t,M_SPC,E___l,M_SIZ,E___a,E___u,E___b,E___e
		BYTE	M_Can
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,03EH
		BYTE	E___u,E___n,E___e,M_SPC,E___c,E___i,E___g,E___o,E___g,E___n,E___e,M_SPC,E___s,E___e,M_SPC,E___h
		BYTE	F__a1,E___t,E___e
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	dans le ciel encore obscur.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT11_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,025H
		BYTE	E___d,E___a,E___n,E___s,M_SPC,E___l,E___e,M_SPC,E___c,E___i,E___e,E___l,M_SPC,E___e,E___n,E___c
		BYTE	E___o,E___r,E___e,M_SPC,E___o,E___b,E___s,E___c,E___u,E___r,M_Pir
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂΂Ɂ@ӂ̂	+
;+	Ƃ킦ā@@I	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Dans son baluchon,			+
;+	sont nichs deux jumeaux.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT12_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,03EH
		BYTE	E___D,E___a,E___n,E___s,M_SPC,E___s,E___o,E___n,M_SPC,E___b,E___a,E___l,E___u,E___c,E___h,E___o
		BYTE	E___n,M_Can
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,026H
		BYTE	E___s,E___o,E___n,E___t,M_SPC,E___n,E___i,E___c,E___h,F__e1,E___s,M_SPC,E___d,E___e,E___u,E___x
		BYTE	M_SPC,E___j,E___u,E___m,E___e,E___a,E___u,E___x,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂ƂÂ܂Xs[h	+
;+	Ł@ł@ЂƂ̂I	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Soudain, aussi vive que			+
;+	l'clair, une ombre                      +
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT13_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,031H
		BYTE	E___S,E___o,E___u,E___d,E___a,E___i,E___n,M_Can,M_SPC,E___a,E___u,E___s,E___s,E___i,M_SPC,E___v
		BYTE	E___i,E___v,E___e,M_SPC,E___q,E___u,E___e
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,041H
		BYTE	E___l,M_SIZ,F__e1,E___c,E___l,E___a,E___i,E___r,M_Can,M_SPC,E___u,E___n,E___e,M_SPC,E___o,E___m
		BYTE	E___b,E___r,E___e
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	traverse les nuages.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT14_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,039H
		BYTE	E___t,E___r,E___a,E___v,E___e,E___r,E___s,E___e,M_SPC,E___l,E___e,E___s,M_SPC,E___n,E___u,E___a
		BYTE	E___g,E___e,E___s,M_Pir
;
;
		BYTE	0FEH,001H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	LB[bIEL[I	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	KRRR ! KRRR !		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT20_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,024H
		BYTE	0FBH
		BYTE	E___K,E___R,E___R,E___R,M_SPC,M___X,M_SPC,E___K,E___R,E___R,E___R,M_SPC,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂@[I		+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Je veux ces enfants !			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT21_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,036H
		BYTE	E___J,E___e,M_SPC,E___v,E___e,E___u,E___x,M_SPC,E___c,E___e,E___s,M_SPC,E___e,E___n,E___f,E___a
		BYTE	E___n,E___t,E___s,M_SPC,M___X
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	́Aꂿ܁@	+
;+	Ђā@䂫܂B		+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Et hop ! Au passage, elle		+
;+	s'empare du petit colis.                +
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT30_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,02CH
		BYTE	E___E,E___t,M_SPC,E___h,E___o,E___p,M_SPC,M___X,M_SPC,E___A,E___u,M_SPC,E___p,E___a,E___s,E___s
		BYTE	E___a,E___g,E___e,M_Can,M_SPC,E___e,E___l,E___l,E___e
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,02FH
		BYTE	E___s,M_SIZ,E___e,E___m,E___p,E___a,E___r,E___e,M_SPC,E___d,E___u,M_SPC,E___p,E___e,E___t,E___i
		BYTE	E___t,M_SPC,E___c,E___o,E___l,E___i,E___s,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ȂƂƂł傤B	+
;+	ЂƂ肪Aā@܂܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Mais... un des bbs			+
;+	commence  tomber.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT40_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,039H
		BYTE	E___M,E___a,E___i,E___s,M_Pir,M_Pir,M_Pir,M_SPC,E___u,E___n,M_SPC,E___d,E___e,E___s,M_SPC,E___b
		BYTE	F__e1,E___b,F__e1,E___s
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,03EH
		BYTE	E___c,E___o,E___m,E___m,E___e,E___n,E___c,E___e,M_SPC,F__a0,M_SPC,E___t,E___o,E___m,E___b,E___e
		BYTE	E___r,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ۂ@̓bV[AChB	+
;+	bV[@ςł@܂ł	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Pendant ce temps...			+
;+	Sur l'Ile de Yoshi...                   +
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT50_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,039H
		BYTE	E___P,E___e,E___n,E___d,E___a,E___n,E___t,M_SPC,E___c,E___e,M_SPC,E___t,E___e,E___m,E___p,E___s
		BYTE	M_Pir,M_Pir,M_Pir
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,03BH
		BYTE	E___S,E___u,E___r,M_SPC,E___l,M_SIZ,E___I,E___l,E___e,M_SPC,E___d,E___e,M_SPC,E___Y,E___o,E___s
		BYTE	E___h,E___i,M_Pir,M_Pir,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	҂̃bV[AۂイB	+
;+	́AƂĂ@悢Ă񂫂łB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Beaucoup de Yoshis			+
;+	vivent ici et l'un d'eux		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT51_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,03FH
		BYTE	E___B,E___e,E___a,E___u,E___c,E___o,E___u,E___p,M_SPC,E___d,E___e,M_SPC,E___Y,E___o,E___s,E___h
		BYTE	E___i,E___s
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,031H
		BYTE	E___v,E___i,E___v,E___e,E___n,E___t,M_SPC,E___i,E___c,E___i,M_SPC,E___e,E___t,M_SPC,E___l,M_SIZ
		BYTE	E___u,E___n,M_SPC,E___d,M_SIZ,E___e,E___u,E___x
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;	entame une petite balade.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT52_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,029H
		BYTE	E___e,E___n,E___t,E___a,E___m,E___e,M_SPC,E___u,E___n,E___e,M_SPC,E___p,E___e,E___t,E___i,E___t
		BYTE	E___e,M_SPC,E___b,E___a,E___l,E___a,E___d,E___e,M_Pir
;
;
		BYTE	0FEH,001H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	EEEH		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	     QUOI DONC ? !!	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT53_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FEH,003H
		BYTE	0FDH,010H,0FCH,01FH
		BYTE	0FBH
		BYTE	E___Q,E___U,E___O,E___I,M_SPC,E___D,E___O,E___N,E___C,M_SPC,M___Q,M_SPC,M___X,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ȂƁ@炩@̂	+
;+	bV[́@ȂɁ@Ă܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Un bb tombe sur son dos.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT54_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,024H
		BYTE	E___U,E___n,M_SPC,E___b,F__e1,E___b,F__e1,M_SPC,E___t,E___o,E___m,E___b,E___e,M_SPC,E___s,E___u
		BYTE	E___r,M_SPC,E___s,E___o,E___n,M_SPC,E___d,E___o,E___s,M_Pir
;
;
		BYTE	0FEH,001H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ@́AԂȂ悤B	+
;+	悩@悩B			+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Mais tout va bien,			+
;+	il n'est pas bless.                     +
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT55_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,042H
		BYTE	E___M,E___a,E___i,E___s,M_SPC,E___t,E___o,E___u,E___t,M_SPC,E___v,E___a,M_SPC,E___b,E___i,E___e
		BYTE	E___n,M_Can
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,03DH
		BYTE	E___i,E___l,M_SPC,E___n,M_SIZ,E___e,E___s,E___t,M_SPC,E___p,E___a,E___s,M_SPC,E___b,E___l,E___e
		BYTE	E___s,E___s,F__e1,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	HقɂȂɂ@	+
;+	Ɂ@Ă̂EEEB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Et quelque chose			+
;+	choit  ses cts.				+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT56_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,048H
		BYTE	E___E,E___t,M_SPC,E___q,E___u,E___e,E___l,E___q,E___u,E___e,M_SPC,E___c,E___h,E___o,E___s,E___e
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,041H
		BYTE	E___c,E___h,E___o,E___i,E___t,M_SPC,F__a0,M_SPC,E___s,E___e,E___s,M_SPC,E___c,F__o0,E___t,F__e1
		BYTE	E___s,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ@́hĥ悤łB	+
;+	REmgAĂ̂H	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	On dirait une carte !			+
;+	Serait-ce				+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT60_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,03AH
		BYTE	E___O,E___n,M_SPC,E___d,E___i,E___r,E___a,E___i,E___t,M_SPC,E___u,E___n,E___e,M_SPC,E___c,E___a
		BYTE	E___r,E___t,E___e,M_SPC,M___X
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,05FH
		BYTE	E___S,E___e,E___r,E___a,E___i,E___t,M__Hi,E___c,E___e
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	 la cigogne ?				+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT61_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,052H
		BYTE	F__a0,M_SPC,E___l,E___a,M_SPC,E___c,E___i,E___g,E___o,E___g,E___n,E___e,M_SPC,M___Q
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǃbV[@Ղ񂩂ՂB	+
;+	Ȃ܂Ɓ@񂷂邱Ƃɂ܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Yoshi est perplexe et dcide		+
;+	d'en parler  ses amis.                  +
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT62_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,022H
		BYTE	E___Y,E___o,E___s,E___h,E___i,M_SPC,E___e,E___s,E___t,M_SPC,E___p,E___e,E___r,E___p,E___l,E___e
		BYTE	E___x,E___e,M_SPC,E___e,E___t,M_SPC,E___d,F__e1,E___c,E___i,E___d,E___e
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,032H
		BYTE	E___d,M_SIZ,E___e,E___n,M_SPC,E___p,E___a,E___r,E___l,E___e,E___r,M_SPC,F__a0,M_SPC,E___s,E___e
		BYTE	E___s,M_SPC,E___a,E___m,E___i,E___s,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ELbAELL[I	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	     KRRR ! KRRR !	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT70_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,024H
		BYTE	0FBH
		BYTE	E___K,E___R,E___R,E___R,M_SPC,M___X,M_SPC,E___K,E___R,E___R,E___R,M_SPC,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	@̂́AJbN	+
;+	Nbp傤ɂށ@܂قB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	C'est Kamek, le magicien                +
;+	retors du Royaume Koopa.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT71_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02EH
		BYTE	E___C,M_SIZ,E___e,E___s,E___t,M_SPC,E___K,E___a,E___m,E___e,E___k,M_Can,M_SPC,E___l,E___e,M_SPC
		BYTE	E___m,E___a,E___g,E___i,E___c,E___i,E___e,E___n
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,028H
		BYTE	E___r,E___e,E___t,E___o,E___r,E___s,M_SPC,E___d,E___u,M_SPC,E___R,E___o,E___y,E___a,E___u,E___m
		BYTE	E___e,M_SPC,E___K,E___o,E___o,E___p,E___a,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	@@ЂƂ@ƂĂ̂+
;+	@ā@Ԃɂɂ䂩܂+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Il a ralis qu'il manque         +
;+	un bb et ordonne  ses		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT72_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,031H
		BYTE	E___I,E___l,M_SPC,E___a,M_SPC,E___r,F__e1,E___a,E___l,E___i,E___s,F__e1,M_SPC,E___q,E___u,M_SIZ
		BYTE	E___i,E___l,M_SPC,E___m,E___a,E___n,E___q,E___u,E___e
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,02DH
		BYTE	E___u,E___n,M_SPC,E___b,F__e1,E___b,F__e1,M_SPC,E___e,E___t,M_SPC,E___o,E___r,E___d,E___o,E___n
		BYTE	E___n,E___e,M_SPC,F__a0,M_SPC,E___s,E___e,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	acolytes de le retrouver.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT73_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02AH
		BYTE	E___a,E___c,E___o,E___l,E___y,E___t,E___e,E___s,M_SPC,E___d,E___e,M_SPC,E___l,E___e,M_SPC,E___r
		BYTE	E___e,E___t,E___r,E___o,E___u,E___v,E___e,E___r,M_Pir
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Ȃ܂̂Ƃւނ@bV[ł	+
;+	ǂɂȂ邳@Ɓ@炭Ȃ悤B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Quant  Yoshi, il rejoint		+
;+	ses amis, inconscient			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT80_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,02DH
		BYTE	E___Q,E___u,E___a,E___n,E___t,M_SPC,F__a0,M_SPC,E___Y,E___o,E___s,E___h,E___i,M_Can,M_SPC,E___i
		BYTE	E___l,M_SPC,E___r,E___e,E___j,E___o,E___i,E___n,E___t
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,037H
		BYTE	E___s,E___e,E___s,M_SPC,E___a,E___m,E___i,E___s,M_Can,M_SPC,E___i,E___n,E___c,E___o,E___n,E___s
		BYTE	E___c,E___i,E___e,E___n,E___t
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	du drame qui se prpare.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT81_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02EH
		BYTE	E___d,E___u,M_SPC,E___d,E___r,E___a,E___m,E___e,M_SPC,E___q,E___u,E___i,M_SPC,E___s,E___e,M_SPC
		BYTE	E___p,E___r,F__e1,E___p,E___a,E___r,E___e,M_Pir
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	AJbŃ@܂イ	+
;+	́@䂭Ă܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Les acolytes eux,			+
;+	ratissent l'ile et                      +
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT82_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,044H
		BYTE	E___L,E___e,E___s,M_SPC,E___a,E___c,E___o,E___l,E___y,E___t,E___e,E___s,M_SPC,E___e,E___u,E___x
		BYTE	M_Can
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,046H
		BYTE	E___r,E___a,E___t,E___i,E___s,E___s,E___e,E___n,E___t,M_SPC,E___l,M_SIZ,E___i,E___l,E___e,M_SPC
		BYTE	E___e,E___t
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	recherchent l'autre bb.                 +
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT83_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FEH,003H
		BYTE	0FDH,010H,0FCH,026H
		BYTE	E___r,E___e,E___c,E___h,E___e,E___r,E___c,E___h,E___e,E___n,E___t,M_SPC,E___l,M_SIZ,E___a,E___u
		BYTE	E___t,E___r,E___e,M_SPC,E___b,F__e1,E___b,F__e1,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	͂ā@ӂ́@́@Ԃ	+
;+	ppƃ}}Ɂ@Ƃǂ̂ł傤	+
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Est-ce que les jumeaux			+
;+	pourront enfin dcouvrir			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT90_F	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,033H
		BYTE	E___E,E___s,E___t,M__Hi,E___c,E___e,M_SPC,E___q,E___u,E___e,M_SPC,E___l,E___e,E___s,M_SPC,E___j
		BYTE	E___u,E___m,E___e,E___a,E___u,E___x
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,02DH
		BYTE	E___p,E___o,E___u,E___r,E___r,E___o,E___n,E___t,M_SPC,E___e,E___n,E___f,E___i,E___n,M_SPC,E___d
		BYTE	F__e1,E___c,E___o,E___u,E___v,E___r,E___i,E___r
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	le visage de leurs parents ?		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT91_F	EQU	$
		BYTE	0FEH,002H
		BYTE	0FEH,003H
		BYTE	0FDH,010H,0FCH,024H
		BYTE	E___l,E___e,M_SPC,E___v,E___i,E___s,E___a,E___g,E___e,M_SPC,E___d,E___e,M_SPC,E___l,E___e,E___u
		BYTE	E___r,E___s,M_SPC,E___p,E___a,E___r,E___e,E___n,E___t,E___s,M_SPC,M___Q
;
		BYTE	0FFH
;
;---------------------------------------------------------------------- hCc 
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Diese Geschichte von Super		+
;+	Mario und den Yoshis			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT00_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,020H
		BYTE	E___D,E___i,E___e,E___s,E___e,M_SPC,E___G,E___e,E___s,E___c,E___h,E___i,E___c,E___h,E___t,E___e
		BYTE	M_SPC,E___v,E___o,E___n,M_SPC,E___S,E___u,E___p,E___e,E___r
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,03BH
		BYTE	E___M,E___a,E___r,E___i,E___o,M_SPC,E___u,E___n,E___d,M_SPC,E___d,E___e,E___n,M_SPC,E___Y,E___o
		BYTE	E___s,E___h,E___i,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	begann vor langer, langer		+
;+	Zeit...					+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT01_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02AH
		BYTE	E___b,E___e,E___g,E___a,E___n,E___n,M_SPC,E___v,E___o,E___r,M_SPC,E___l,E___a,E___n,E___g,E___e
		BYTE	E___r,M_Can,M_SPC,E___l,E___a,E___n,E___g,E___e,E___r
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,067H
		BYTE	E___Z,E___e,E___i,E___t,M_Pir,M_Pir,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Ein Kurier-Storch, Guter-		+
;+	klasse 1, fliegt in einer		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT10_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,028H
		BYTE	E___E,E___i,E___n,M_SPC,E___K,E___u,E___r,E___i,E___e,E___r,M__Hi,E___S,E___t,E___o,E___r,E___c
		BYTE	E___h,M_Can,M_SPC,E___G,G__u0,E___t,E___e,E___r,M__Hi
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,032H
		BYTE	E___k,E___l,E___a,E___s,E___s,E___e,M_SPC,N___1,M_Can,M_SPC,E___f,E___l,E___i,E___e,E___g,E___t
		BYTE	M_SPC,E___i,E___n,M_SPC,E___e,E___i,E___n,E___e,E___r
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	dunklen Nacht, ohne Radar-		+
;+	system, dem Sonnenaufgang		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT11_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,021H
		BYTE	E___d,E___u,E___n,E___k,E___l,E___e,E___n,M_SPC,E___N,E___a,E___c,E___h,E___t,M_Can,M_SPC,E___o
		BYTE	E___h,E___n,E___e,M_SPC,E___R,E___a,E___d,E___a,E___r,M__Hi
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,022H
		BYTE	E___s,E___y,E___s,E___t,E___e,E___m,M_Can,M_SPC,E___d,E___e,E___m,M_SPC,E___S,E___o,E___n,E___n
		BYTE	E___e,E___n,E___a,E___u,E___f,E___g,E___a,E___n,E___g
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	entgegen. In seinem			+
;+	Schnabel transportiert er		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT12_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,03EH
		BYTE	E___e,E___n,E___t,E___g,E___e,E___g,E___e,E___n,M_Pir,M_SPC,E___I,E___n,M_SPC,E___s,E___e,E___i
		BYTE	E___n,E___e,E___m
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,027H
		BYTE	E___S,E___c,E___h,E___n,E___a,E___b,E___e,E___l,M_SPC,E___t,E___r,E___a,E___n,E___s,E___p,E___o
		BYTE	E___r,E___t,E___i,E___e,E___r,E___t,M_SPC,E___e,E___r
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	zwei zappelnde Bundel.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT13_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,034H
		BYTE	E___z,E___w,E___e,E___i,M_SPC,E___z,E___a,E___p,E___p,E___e,E___l,E___n,E___d,E___e,M_SPC,E___B
		BYTE	G__u0,E___n,E___d,E___e,E___l,M_Pir
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ZOOOOOOM!!!		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT20_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,028H
		BYTE	0FBH
		BYTE	E___Z,E___O,E___O,E___O,E___O,E___O,E___O,E___M,M___X,M___X,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Ein groBer Schatten knallt		+
;+	durch die Wolkendecke.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT21_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,026H
		BYTE	E___E,E___i,E___n,M_SPC,E___g,E___r,E___o,G__ss,E___e,E___r,M_SPC,E___S,E___c,E___h,E___a,E___t
		BYTE	E___t,E___e,E___n,M_SPC,E___k,E___n,E___a,E___l,E___l,E___t
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,032H
		BYTE	E___d,E___u,E___r,E___c,E___h,M_SPC,E___d,E___i,E___e,M_SPC,E___W,E___o,E___l,E___k,E___e,E___n
		BYTE	E___d,E___e,E___c,E___k,E___e,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	KAWUMM!!!		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT30_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,038H
		BYTE	0FBH
		BYTE	E___K,E___A,E___W,E___U,E___M,E___M,M___X,M___X,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Im Vorbeiflug erhascht die		+
;+	seltsame Kreatur ein Baby		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT31_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,028H
		BYTE	E___I,E___m,M_SPC,E___V,E___o,E___r,E___b,E___e,E___i,E___f,E___l,E___u,E___g,M_SPC,E___e,E___r
		BYTE	E___h,E___a,E___s,E___c,E___h,E___t,M_SPC,E___d,E___i,E___e
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,029H
		BYTE	E___s,E___e,E___l,E___t,E___s,E___a,E___m,E___e,M_SPC,E___K,E___r,E___e,E___a,E___t,E___u,E___r
		BYTE	M_SPC,E___e,E___i,E___n,M_SPC,E___B,E___a,E___b,E___y
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	und zischt damit ab.			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT32_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,03AH
		BYTE	E___u,E___n,E___d,M_SPC,E___z,E___i,E___s,E___c,E___h,E___t,M_SPC,E___d,E___a,E___m,E___i,E___t
		BYTE	M_SPC,E___a,E___b,M_Pir
;
;
		BYTE	0FEH,001H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	AHHHHH!!!		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT33_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FEH,003H
		BYTE	0FDH,010H,0FCH,038H
		BYTE	0FBH
		BYTE	E___A,E___H,E___H,E___H,E___H,E___H,M___X,M___X,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Oje! Das andere Kind ist		+
;+	abgestuzt und fallt mit			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT40_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,02EH
		BYTE	E___O,E___j,E___e,M___X,M_SPC,E___D,E___a,E___s,M_SPC,E___a,E___n,E___d,E___e,E___r,E___e,M_SPC
		BYTE	E___K,E___i,E___n,E___d,M_SPC,E___i,E___s,E___t
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,02EH
		BYTE	E___a,E___b,E___g,E___e,E___s,E___t,G__u0,E___r,E___z,E___t,M_SPC,E___u,E___n,E___d,M_SPC,E___f
		BYTE	G__a0,E___l,E___l,E___t,M_SPC,E___m,E___i,E___t
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	berauschendem Tempo auf			+
;+	das Meer zu...				+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT41_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02BH
		BYTE	E___b,E___e,E___r,E___a,E___u,E___s,E___c,E___h,E___e,E___n,E___d,E___e,E___m,M_SPC,E___T,E___e
		BYTE	E___m,E___p,E___o,M_SPC,E___a,E___u,E___f
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,04EH
		BYTE	E___d,E___a,E___s,M_SPC,E___M,E___e,E___e,E___r,M_SPC,E___z,E___u,M_Pir,M_Pir,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Diese idyllische Insel nennt		+
;+	man "Yoshis Island".			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT50_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,026H
		BYTE	E___D,E___i,E___e,E___s,E___e,M_SPC,E___i,E___d,E___y,E___l,E___l,E___i,E___s,E___c,E___h,E___e
		BYTE	M_SPC,E___I,E___n,E___s,E___e,E___l,M_SPC,E___n,E___e,E___n,E___n,E___t
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,036H
		BYTE	E___m,E___a,E___n,M_SPC,M__DQ,E___Y,E___o,E___s,E___h,E___i,M_SIZ,E___s,M_SPC,E___I,E___s,E___l
		BYTE	E___a,E___n,E___d,M__DQ,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Auf dieser Insel leben die		+
;+	Yoshis.					+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT51_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02DH
		BYTE	E___A,E___u,E___f,M_SPC,E___d,E___i,E___e,E___s,E___e,E___r,M_SPC,E___I,E___n,E___s,E___e,E___l
		BYTE	M_SPC,E___l,E___e,E___b,E___e,E___n,M_SPC,E___d,E___i,E___e
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,066H
		BYTE	E___Y,E___o,E___s,E___h,E___i,E___s,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Einer der Yoshis unternimmt		+
;+	gerade einen Spaziergang		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT52_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,023H
		BYTE	E___E,E___i,E___n,E___e,E___r,M_SPC,E___d,E___e,E___r,M_SPC,E___Y,E___o,E___s,E___h,E___i,E___s
		BYTE	M_SPC,E___u,E___n,E___t,E___e,E___r,E___n,E___i,E___m,E___m,E___t
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,02BH
		BYTE	E___g,E___e,E___r,E___a,E___d,E___e,M_SPC,E___e,E___i,E___n,E___e,E___n,M_SPC,E___S,E___p,E___a
		BYTE	E___z,E___i,E___e,E___r,E___g,E___a,E___n,E___g
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	und fiept vergnugt vor sich		+
;+	her.					+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT53_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,022H
		BYTE	E___u,E___n,E___d,M_SPC,E___f,E___i,E___e,E___p,E___t,M_SPC,E___v,E___e,E___r,E___g,E___n,G__u0
		BYTE	E___g,E___t,M_SPC,E___v,E___o,E___r,M_SPC,E___s,E___i,E___c,E___h
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,071H
		BYTE	E___h,E___e,E___r,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Ho?			(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT54_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,068H
		BYTE	0FBH
		BYTE	E___H,G__O0,M___Q
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Das Baby ist auf Yoshis			+
;+	Rucken gelandet und hat,		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT55_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,030H
		BYTE	E___D,E___a,E___s,M_SPC,E___B,E___a,E___b,E___y,M_SPC,E___i,E___s,E___t,M_SPC,E___a,E___u,E___f
		BYTE	M_SPC,E___Y,E___o,E___s,E___h,E___i,E___s
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,02AH
		BYTE	E___R,G__u0,E___c,E___k,E___e,E___n,M_SPC,E___g,E___e,E___l,E___a,E___n,E___d,E___e,E___t,M_SPC
		BYTE	E___u,E___n,E___d,M_SPC,E___h,E___a,E___t,M_Can
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	auf wundersame Weise, den		+
;+	Aufprall ohne Verletzungen		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT56_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,027H
		BYTE	E___a,E___u,E___f,M_SPC,E___w,E___u,E___n,E___d,E___e,E___r,E___s,E___a,E___m,E___e,M_SPC,E___W
		BYTE	E___e,E___i,E___s,E___e,M_Can,M_SPC,E___d,E___e,E___n
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,025H
		BYTE	E___A,E___u,E___f,E___p,E___r,E___a,E___l,E___l,M_SPC,E___o,E___h,E___n,E___e,M_SPC,E___V,E___e
		BYTE	E___r,E___l,E___e,E___t,E___z,E___u,E___n,E___g,E___e,E___n
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	uerstanden.				+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT57_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,052H
		BYTE	G__u0,E___b,E___e,E___r,E___s,E___t,E___a,E___n,E___d,E___e,E___n,M_Pir
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Doch es ist noch etwas vom		+
;+	Himmel gefallen...			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT58_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,025H
		BYTE	E___D,E___o,E___c,E___h,M_SPC,E___e,E___s,M_SPC,E___i,E___s,E___t,M_SPC,E___n,E___o,E___c,E___h
		BYTE	M_SPC,E___e,E___t,E___w,E___a,E___s,M_SPC,E___v,E___o,E___m
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,044H
		BYTE	E___H,E___i,E___m,E___m,E___e,E___l,M_SPC,E___g,E___e,E___f,E___a,E___l,E___l,E___e,E___n,M_Pir
		BYTE	M_Pir,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	"Das sieht ja wie eine Karte            +
;+	aus. Wo kommt denn die auf		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT60_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,023H
		BYTE	M__DQ,E___D,E___a,E___s,M_SPC,E___s,E___i,E___e,E___h,E___t,M_SPC,E___j,E___a,M_SPC,E___w,E___i
		BYTE	E___e,M_SPC,E___e,E___i,E___n,E___e,M_SPC,E___K,E___a,E___r,E___t,E___e
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,025H
		BYTE	E___a,E___u,E___s,M_Pir,M_SPC,E___W,E___o,M_SPC,E___k,E___o,E___m,E___m,E___t,M_SPC,E___d,E___e
		BYTE	E___n,E___n,M_SPC,E___d,E___i,E___e,M_SPC,E___a,E___u,E___f
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	einmal her?". Yoshi rennt               +
;+	sofort los, um seine Kumpels		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT61_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,02AH
		BYTE	E___e,E___i,E___n,E___m,E___a,E___l,M_SPC,E___h,E___e,E___r,M___Q,M__DQ,M_Pir,M_SPC,E___Y,E___o
		BYTE	E___s,E___h,E___i,M_SPC,E___r,E___e,E___n,E___n,E___t
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,024H
		BYTE	E___s,E___o,E___f,E___o,E___r,E___t,M_SPC,E___l,E___o,E___s,M_Can,M_SPC,E___u,E___m,M_SPC,E___s
		BYTE	E___e,E___i,E___n,038H,M_SPC,E___K,E___u,E___m,E___p,E___e,E___l,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	uer alles zu informieren.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT62_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,02BH
		BYTE	G__u0,E___b,E___e,E___r,M_SPC,E___a,E___l,E___l,E___e,E___s,M_SPC,E___z,E___u,M_SPC,E___i,E___n
		BYTE	E___f,E___o,E___r,E___m,E___i,E___e,E___r,E___e,E___n,M_Pir
;
;
		BYTE	0FEH,001H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Kamek, der Magikoopa,			+
;+	wohnt in Bowsers Schlo zur		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT70_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,033H
		BYTE	E___K,E___a,E___m,E___e,E___k,M_Can,M_SPC,E___d,E___e,E___r,M_SPC,E___M,E___a,E___g,E___i,E___k
		BYTE	E___o,E___o,E___p,E___a,M_Can
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,021H
		BYTE	E___w,E___o,E___h,E___n,E___t,M_SPC,E___i,E___n,M_SPC,E___B,E___o,E___w,E___s,E___e,E___r,E___s
		BYTE	M_SPC,E___S,E___c,E___h,E___l,E___o,G__ss,M_SPC,E___z,E___u,E___r
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Untermiete. Er war der-			+
;+	jenige, der dem Storch das		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT71_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,030H
		BYTE	E___U,E___n,E___t,E___e,E___r,E___m,E___i,E___e,E___t,E___e,M_Pir,M_SPC,E___E,E___r,M_SPC,E___w
		BYTE	E___a,E___r,M_SPC,E___d,E___e,E___r,M__Hi
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,025H
		BYTE	E___j,E___e,E___n,E___i,E___g,E___e,M_Can,M_SPC,E___d,E___e,E___r,M_SPC,E___d,E___e,E___m,M_SPC
		BYTE	E___S,E___t,E___o,E___r,E___c,E___h,M_SPC,E___d,E___a,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Kind geraubt hat. Kamek ist		+
;+	stinksauer, da er nur ein		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT72_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,021H
		BYTE	E___K,E___i,E___n,E___d,M_SPC,E___g,E___e,E___r,E___a,E___u,E___b,E___t,M_SPC,E___h,E___a,E___t
		BYTE	M_Pir,M_SPC,E___K,E___a,E___m,E___e,E___k,M_SPC,E___i,E___s,E___t
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,027H
		BYTE	E___s,E___t,E___i,E___n,E___k,E___s,E___a,E___u,E___e,E___r,M_Can,M_SPC,E___d,E___a,G__ss,M_SPC
		BYTE	E___e,E___r,M_SPC,E___n,E___u,E___r,M_SPC,E___e,E___i,E___n
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Baby erwischt hat...			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT73_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,037H
		BYTE	E___B,E___a,E___b,E___y,M_SPC,E___e,E___r,E___w,E___i,E___s,E___c,E___h,E___t,M_SPC,E___h,E___a
		BYTE	E___t,M_Pir,M_Pir,M_Pir
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	WHAAAAA!!!		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT74_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,030H
		BYTE	0FBH
		BYTE	E___W,E___H,E___A,E___A,E___A,E___A,E___A,M___X,M___X,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Er schickt sofort seine			+
;+	Diener los, um auch das			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT75_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,031H
		BYTE	E___E,E___r,M_SPC,E___s,E___c,E___h,E___i,E___c,E___k,E___t,M_SPC,E___s,E___o,E___f,E___o,E___r
		BYTE	E___t,M_SPC,E___s,E___e,E___i,E___n,E___e
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,031H
		BYTE	E___D,E___i,E___e,E___n,E___e,E___r,M_SPC,E___l,E___o,E___s,M_Can,M_SPC,E___u,E___m,M_SPC,E___a
		BYTE	E___u,E___c,E___h,M_SPC,E___d,E___a,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	zweite Baby zu entfuren.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT76_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,027H
		BYTE	E___z,E___w,E___e,E___i,E___t,E___e,M_SPC,E___B,E___a,E___b,E___y,M_SPC,E___z,E___u,M_SPC,E___e
		BYTE	E___n,E___t,E___f,G__u0,E___h,E___r,E___e,E___n,M_Pir
;
;
		BYTE	0FEH,001H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Ahnungslos begibt sich			+
;+	Yoshi zu seinen Freunden.		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT80_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,032H
		BYTE	E___A,E___h,E___n,E___u,E___n,E___g,E___s,E___l,E___o,E___s,M_SPC,E___b,E___e,E___g,E___i,E___b
		BYTE	E___t,M_SPC,E___s,E___i,E___c,E___h
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,029H
		BYTE	E___Y,E___o,E___s,E___h,E___i,M_SPC,E___z,E___u,M_SPC,E___s,E___e,E___i,E___n,E___e,E___n,M_SPC
		BYTE	E___F,E___r,E___e,E___u,E___n,E___d,E___e,E___n,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Doch Kameks Horde hat sich		+
;+	bereits aufgemacht, um das		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT81_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,023H
		BYTE	E___D,E___o,E___c,E___h,M_SPC,E___K,E___a,E___m,E___e,E___k,E___s,M_SPC,E___H,E___o,E___r,E___d
		BYTE	E___e,M_SPC,E___h,E___a,E___t,M_SPC,E___s,E___i,E___c,E___h
;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,022H
		BYTE	E___b,E___e,E___r,E___e,E___i,E___t,E___s,M_SPC,E___a,E___u,E___f,E___g,E___e,E___m,E___a,E___c
		BYTE	E___h,E___t,M_Can,M_SPC,E___u,E___m,M_SPC,E___d,E___a,E___s
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Budel auf Yoshis Ruken zu		+
;+	rauben.					+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT82_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,023H
		BYTE	E___B,G__u0,E___n,E___d,E___e,E___l,M_SPC,E___a,E___u,E___f,M_SPC,E___Y,E___o,E___s,E___h,E___i
		BYTE	E___s,M_SPC,E___R,G__u0,E___c,E___k,E___e,E___n,M_SPC,E___z,E___u
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,065H
		BYTE	E___r,E___a,E___u,E___b,E___e,E___n,M_Pir
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Werden die Yoshis das Baby		+
;+	heil zu seinen Eltern			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT90_D	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,026H
		BYTE	E___W,E___e,E___r,E___d,E___e,E___n,M_SPC,E___d,E___i,E___e,M_SPC,E___Y,E___o,E___s,E___h,E___i
		BYTE	E___s,M_SPC,E___d,E___a,E___s,M_SPC,E___B,E___a,E___b,E___y
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,03EH
		BYTE	E___h,E___e,E___i,E___l,M_SPC,E___z,E___u,M_SPC,E___s,E___e,E___i,E___n,E___e,E___n,M_SPC,E___E
		BYTE	E___l,E___t,E___e,E___r,E___n
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	zurukbringen konen?			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT91_D	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,032H
		BYTE	E___z,E___u,E___r,G__u0,E___c,E___k,E___b,E___r,E___i,E___n,E___g,E___e,E___n,M_SPC,E___k,G__o0
		BYTE	E___n,E___n,E___e,E___n,M___Q
;
;
		BYTE	0FEH,003H
;
		BYTE	0FFH
;
 ENDIF	  ;**** PAL Ή [1995/07/31] *****************************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ނAނ̂͂ȂłB		+
;+	}IƃbV[̂͂Ȃł	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT00	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Mu,H__Ka,H__Si,M_TEN,H__Mu,H__Ka,H__Si,H__No,H___O,H__Ha,H__Na,H__Si,H__De,H__Su,M_MAR
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,K__Ma,K__Ri,K___O,H__To,K__Yo,K__tu,K__Si,M__Hi,H__No,H__Ha,H__Na,H__Si,H__De,H__Su
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	悠܂̂炢@REmg	+
;+	ĂŁ@Ƃł䂫܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT10	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Yo,H___A,H__Ke,H__Ma,H___E,H__No,H__Ku,H__Ra,H___I,H__So,H__Ra,H__Wo,M_SPC,K__Ko,K___U,K__No,K__To,K__Ri,H__Ga
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H___O,H___O,H___A,H__Wa,H__Te,H__De,M_SPC,H__Su,H__tu,H__To,H___N,H__De,H__Yu,H__Ki,H__Ma,H__Su,M_MAR
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂΂Ɂ@ӂ̂	+
;+	Ƃ킦ā@@I	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT12	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__So,H__No,H__Ku,H__Ti,H__Ba,H__Si,H__Ni,M_SPC,H__Hu,H__Ta,H__Go,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Si,H__tu,H__Ka,H__Ri,H__To,H__Ku,H__Wa,H___E,H__Te,M_SPC,H___I,H__So,H__Gu,M_SPC,H___I,H__So,H__Gu,M___X,M_SPC
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂ƂÂ܂Xs[h	+
;+	Ł@ł@ЂƂ̂I	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT14	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__So,H__No,H__To,H__Ki,M_TEN,H__Ku,H__Mo,H__No,H___A,H___I,H__Ma,H__Ka,H__Ra,H__Mo,H___U,K__Su,K__Pi,M__Hi,K__Do
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H__De,M_SPC,H__Tu,H__tu,H__Ko,H___N,H__De,H__Ku,H__Ru,M_SPC,H__Hi,H__To,H__Tu,H__No,H__Ka,H__Ge,H__Ga,M___X,M_SPC
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	LB[bIEL[I	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT20	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,028H
		BYTE	0FBH
;
		BYTE	K__Ki,K___i,M__Hi,K__tu,M___X,K___U,K__Ki,M__Hi,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂@[I		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT22	EQU	$
		BYTE	0FEH,002H
		BYTE	0FEH,003H
		BYTE	0FDH,010H,0FCH,02EH
;
		BYTE	H__So,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,M_SPC,H___I,H__Ta,H__Da,H__Ku,H__Ze,M__Hi,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	킠I		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT30	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,038H
		BYTE	0FBH
;
		BYTE	H___U,H__Wa,H___A,H___a,H___a,H__tu,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	́Aꂿ܁@	+
;+	Ђā@䂫܂B		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT32	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__So,H___I,H__Tu,H__Ha,M_TEN,H__Su,H__Re,H__Ti,H__Ga,H___I,H__Za,H__Ma,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Hi,H__tu,H__Ta,H__Ku,H__tu,H__Te,M_SPC,H__Yu,H__Ki,H__Ma,H__Si,H__Ta,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	QQQQEEE	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT40	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,050H
		BYTE	0FBH
;
		BYTE	H___A,H__tu,0D3H,0D3H,0D3H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ȂƂƂł傤B	+
;+	ЂƂ肪Aā@܂܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT42	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__Na,H___N,H__To,H___I,H___U,H__Ko,H__To,H__De,H__Si,H__yo,H___U,M_MAR,H___A,H__Ka,H__Ti,H__ya,H___N,H__No
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Hi,H__To,H__Ri,H__Ga,M_TEN,H___O,H__tu,H__Ko,H__Ti,H__Te,M_SPC,H__Si,H__Ma,H___I,H__Ma,H__Si,H__Ta,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ۂ@̓bV[AChB	+
;+	bV[@ςł@܂ł	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT50	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H___I,H__tu,H__Po,H___U,M_SPC,H__Ko,H__Ko,H__Ha,K__Yo,K__tu,K__Si,M__Hi,K___A,K___I,K__Ra,K___N,K__Do,M_MAR
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	K__Yo,K__tu,K__Si,M__Hi,H__Ga,M_SPC,H___I,H__tu,H__Pa,H___I,H__Su,H___N,H__De,H__Ru,M_SPC,H__Si,H__Ma,H__De,H__Su
;
		BYTE	0FFH
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	҂̃bV[AۂイB	+
;+	́AƂĂ@悢Ă񂫂łB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT52	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H___I,H__tu,H__Pi,H__Ki,H__No,K__Yo,K__tu,K__Si,M__Hi,H__Ga,M_TEN,H___O,H__Sa,H___N,H__Po,H__Ti,H__yu,H___U,M_MAR
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Ke,H__Sa,H__Ha,M_TEN,H__To,H__tu,H__Te,H__Mo,M_SPC,H__Yo,H___I,H__Te,H___N,H__Ki,H__De,H__Su,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	EEEH				+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT54	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,040H
		BYTE	0FBH
;
		BYTE	M_SPC,H___N,H__tu,M___Q
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ȂƁ@炩@̂	+
;+	bV[́@ȂɁ@Ă܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT56	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__Na,H___N,H__To,M_SPC,H__So,H__Ra,H__Ka,H__Ra,M_SPC,H__Sa,H__tu,H__Ki,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ga
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	K__Yo,K__tu,K__Si,M__Hi,H__No,M_SPC,H__Se,H__Na,H__Ka,H__Ni,M_SPC,H___O,H__Ti,H__Te,H__Ki,H__Ma,H__Si,H__Ta,M_MAR
;
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ@́AԂȂ悤B	+
;+	悩@悩B			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT58	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Do,H___U,H__Ya,H__Ra,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ha,M_TEN,H__Bu,H__Zi,H__Na,H__Yo,H___U,H__Su,M_MAR
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H__Yo,H__Ka,H__tu,H__Ta,M_SPC,H__Yo,H__Ka,H__tu,H__Ta,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	HقɂȂɂ@	+
;+	Ɂ@Ă̂EEEB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT5A	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H___O,H__Ya,H__tu,M___Q,H__Ho,H__Ka,H__Ni,H__Mo,H__Na,H__Ni,H__Ya,H__Ra,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__To
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H___I,H__tu,H__Si,H__yo,H__Ni,M_SPC,H___O,H__Ti,H__Te,H__Ki,H__Ta,H__Mo,H__No,H__Ga,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ@́hĥ悤łB	+
;+	REmgAĂ̂H	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT60	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Do,H___U,H__Ya,H__Ra,M_SPC,H__Ko,H__Re,H__Ha,M__DQ,H__Ti,H__Zu,M__DQ,H__No,H__Yo,H___U,H__De,H__Su,M_MAR
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	K__Ko,K___U,K__No,K__To,K__Ri,H__Ga,M_TEN,H__Tu,H__Ka,H__tu,H__Te,H___I,H__Ta,H__Mo,H__No,H__Ka,H__Mo,M___Q
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǃbV[@Ղ񂩂ՂB	+
;+	Ȃ܂Ɓ@񂷂邱Ƃɂ܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT62	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__Da,H__Ke,H__Do,K__Yo,K__tu,K__Si,M__Hi,M_SPC,H__Ti,H___N,H__Pu,H___N,H__Ka,H___N,H__Pu,H___N,M_MAR
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Na,H__Ka,H__Ma,H__To,M_SPC,H__So,H___U,H__Da,H___N,H__Su,H__Ru,H__Ko,H__To,H__Ni,H__Si,H__Ma,H__Si,H__Ta,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ELbAELL[I	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT70	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,030H
		BYTE	0FBH
;
		BYTE	K___U,K__Ki,K__tu,M_TEN,K___U,K__Ki,K__Ki,M__Hi,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	@̂́AJbN	+
;+	Nbp傤ɂށ@܂قB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT72	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC,H__Sa,H__Ra,H__tu,H__Ta,H__No,H__Ha,M_TEN,K__Ka,K__Me,K__tu,K__Ku,H__To
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H___I,H___U,K__Ku,K__tu,K__Pa,H__Zi,H__yo,H___U,H__Ni,H__Su,H__Mu,M_SPC,H__Ma,H__Ho,H___U,H__Tu,H__Ka,H___I,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	@@ЂƂ@ƂĂ̂+
;+	@ā@Ԃɂɂ䂩܂+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT74	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC,H__Hi,H__To,H__Ri,M_SPC,H___O,H__To,H__Si,H__Te,H__Ki,H__Ta,H__No,H__Ni
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H__Ki,H__Ga,H__Tu,H___I,H__Te,M_SPC,H__Ko,H__Bu,H___N,H__Ni,H__Sa,H__Ga,H__Si,H__Ni,H__Yu,H__Ka,H__Se,H__Ma,H__Su
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Ȃ܂̂Ƃւނ@bV[ł	+
;+	ǂɂȂ邳@Ɓ@炭Ȃ悤B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT80	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Na,H__Ka,H__Ma,H__No,H__To,H__Ko,H__Ro,H__He,H__Mu,H__Ka,H___U,M_SPC,K__Yo,K__tu,K__Si,M__Hi,H__De,H__Su,H__Ga
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H__Do,H___U,H__Ni,H__Ka,H__Na,H__Ru,H__Sa,M_SPC,H__To,M_SPC,H__Ki,H__Ra,H__Ku,H__Na,H__Yo,H___U,H__Su,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	AJbŃ@܂イ	+
;+	́@䂭Ă܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT82	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__Si,H__Ka,H__Si,M_TEN,K__Ka,K__Me,K__tu,K__Ku,H__Ta,H__Ti,H__Ha,M_SPC,H__Si,H__Ma,H__Zi,H__yu,H___U,H__De
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,H__No,M_SPC,H__Yu,H__Ku,H___E,H__Wo,H___O,H__tu,H__Te,H___I,H__Ma,H__Su,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	͂ā@ӂ́@́@Ԃ	+
;+	ppƃ}}Ɂ@Ƃǂ̂ł傤	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT90	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Ha,H__Ta,H__Si,H__Te,M_SPC,H__Hu,H__Ta,H__Ri,H__No,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ha,M_SPC,H__Bu,H__Zi
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	K__Pa,K__Pa,H__To,K__Ma,K__Ma,H__Ni,M_SPC,H__To,H__Do,H__Ke,H__Ra,H__Re,H__Ru,H__No,H__De,H__Si,H__yo,H___U,H__Ka
;
		BYTE	0FFH
;
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
;
;
;;;;;; opdemo.dat END
;
		END
