;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mini game 2					*
;*	file name	: ys_mini1					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_color.h
		include		../union/ys_mapobj.h
		include		../union/ys_bgcheck.h
		include		ys_presno.h
		include		ys_pld.h
;
		XALL
;
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
;
		GLB	MINIINT1_2,MINIMOV1_2,MINIINT1_4,MINIMOV1_4
		GLB	MINIINT1_5,MINIMOV1_5,MINIINT1_6,MINIMOV1_6
		GLB	MINIINT1_7,MINIMOV1_7
;
		GLB	M_THOIN,M_TAMIN,M_DR0IN,M_TH1IN,M_HEIIN,M_DR1IN
		GLB	M_BAKIN,M_MISIN,M_BBYIN,M_DR3IN,M_DR4IN,M_SUIIN
		GLB	M_DR5IN,M_ITMIN
		GLB	M_THOMV,M_TAMMV,M_DR0MV,M_TH1MV,M_HEIMV,M_DR1MV
		GLB	M_BAKMV,M_MISMV,M_BBYMV,M_DR3MV,M_DR4MV,M_SUIMV
		GLB	M_DR5MV,M_ITMMV
;
		GLB	WINVRMD,LOSVRMD
;
		GLB	ITST1,ITST2,IT1UP
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;-------------< ys_main >------------------------------------------------
		EXT	OAMDXCLR,RANDAM
;
		EXT	MINIT
;
		EXT	SOUND_3_ON
;
;-------------< ys_init >------------------------------------------------
		EXT	VRAMDX_ST
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON_RAM_READ
;
		EXT	MWIN,MLOS
;
;-------------< ys_play >------------------------------------------------
		EXT	PLAYER,PLCSET,PSCRL_INIT,PLSCRL,BERO_CANCEL
		EXT	HERI_INITL,CAR_INITL
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENEMY_IN,ENCSET_DM,ENRAMCLR,ENINSR_I,TROBJ_SR_4x4
		EXT	TROBJ_OAM_4x4_I,ENCLEAR,BEAT_P_SET_2,ENMDCK,PLFLST
		EXT	SHOT_EN_KILL,ENINSR,ENINSR2_I,PDON0ST_2
		EXT	TROBJ_OAM_4x4
		EXT	TROBJ_SR_4x4_CL
;
		EXT	TROBJ_PLOT_X,TROBJ_PLOT_Y
;
		EXT	EFIRE,EMOVE,EFAIL
;
		EXT	EGG00,SUIKA,FIRE0,SUIKT,FIREX
;
		EXT	M_THO,M_TAM,M_DR0,M_TH1,M_HEI,M_DR1,M_BAK,M_MIS
		EXT	M_BBY,M_DR3,M_DR4,M_SUI,M_DR5,M_ITM
;
;-------------< ys_enmy3 >-----------------------------------------------
		EXT	BSCLR_KIRA_SET,FUSNB_SET_2
;
;-------------< ys_exst >------------------------------------------------
		EXT	EXINSR
;
		EXT	SMK05,M_SM0
;
;-------------< ys_bgsc >------------------------------------------------
		EXT	UNITST_SUB,MINI_INT_BG,BGSET
;
;-------------< ys_mini >------------------------------------------------
		EXT	MHDPLY_JSL
		EXT	BACK_GAME
;
;-------------< ys_bgdt5 >-----------------------------------------------
		EXT	MINICORS00,MINICORS01
;
;-------------< ys_data >------------------------------------------------
		EXT	COS,SIN
;
;-------------< ys_bonus >-----------------------------------------------
		EXT	ITEMINPUT_L
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_11	GROUP	Mini1_pro
Mini1_pro	SECT	REL
;
;----------------------------------------------------------------
;
;
;****************************************************************
;*								*
;*		~j Q[ CjV Zbg			*
;*								*
;****************************************************************
;
;
MINIINT1_2	EQU	$
;-------------- XN[l NA -----------------------------
		M16			; memory 16 bit mode !!
;
		STZ	<SCCH1
		STZ	<SCCV1
		STZ	<SCCH2
		STZ	<SCCV2
		STZ	<SCCH3
		STZ	<SCCV3
		M8			; memory 8bit mode !!
;
		LDA	#069H
		STA	!BG1SCF
		STA	2107H
		LDA	#039H
		STA	!BG2SCF
		STA	2108H
		LDA	#009H
		STA	BGMODE
		STA	2105H
		STZ	HD420C
		STZ	SUBADF
;
;-------------- Q[ CjV ---------------------------------------
		MI16			; memory,index 8 bit mode !!
;
		LDA	#000B0H
		STA	PLYPSL		; player Y initial set !!
		LDA	#00030H
		STA	PLXPSL		; player X initial set !!
		STZ	UNBUFAD
		STA	TIMER
;
		LDA	#00030H
		STA	MNTIME		; ~jQ[^C}[Zbg
		LDA	#00001
		STA	MNTMCT		; ~jQ[^C}[JE^[Zbg
		STZ	PLTMCT
		STZ	ENTMCT
;
;;;;;;;;		LDA	#0FFFFH
;;;;;;;;		STA	OBJCHR_BNK
;;;;;;;;		STA	OBJCHR_BNK+2
;;;;;;;;		STA	OBJCHR_BNK+4
;;;;;;;;;
		LDX	#001FEH
		LDA	#00000
;
INT1_2_050	EQU	$
		STA	>BGUNIT,X
		DEX
		DEX
		BPL	INT1_2_050	; BG unit buffer clear end ?
;					; Yes !!
		LDX	#00FH*2
		LDA	#00100H
;
INT1_2_100	EQU	$
		STA	>BGUNIT,X
		STA	>BGUNIT+1A0H,X
		DEX
		DEX
		BPL	INT1_2_100
;
		LDX	#00160H
;
INT1_2_150	EQU	$
		LDA	#00100H
		STA	>BGUNIT,X
		STA	>BGUNIT+01EH,X
		TXA
		SEC
		SBC	#00020H
		TAX
		BNE	INT1_2_150
;
;;;;K;;;;		JSR	METERST_200
;
		I8			; index 8 bit mode !!
;
		LDA	#M_THO
		JSL	>ENINSR_I
		LDA	#M_DR0
		JSL	>ENINSR_I
;
		MI8			; memory,index 8 bit mode !!
;
		JSL	>ENEMY_IN
;
		RTS
;
;
;****************************************************************
;*								*
;*		~j Q[					*
;*								*
;****************************************************************
MINIMOV1_2	EQU	$
		JSL	>OAMDXCLR	; OAM clear sub !!
		JSL	>ENCSET_DM	; enemy char set sub !!
		JSL	>PLCSET		; player char set sub !!
;
		STZ	SPECIAL_P
;
		LDA	MNMODE
		ASL	A
		TAX
		JSR	(!MIN2TBL,X)
;
		M16			; memory 16 bit mode !!
;
		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;
		M8			; memory 8 bit mode !!
;
		RTS
;
;
MIN2TBL		EQU	$
		WORD	MIN2NOM		; ~jQ[vC
		WORD	MIN2PWN		; ~jQ[vC[
		WORD	MIN2EWN		; ~jQ[G
;
;
;;;;;;;;MINIMOV1_2	EQU	$
;;;;;;;;		JSL	>OAMDXCLR	; OAM clear sub !!
;;;;;;;;		JSL	>ENCSET_DM	; enemy char set sub !!
;;;;;;;;		JSL	>PLCSET		; player char set sub !!
;;;;;;;;;
;;;;;;;;		STZ	SPECIAL_P
;;;;;;;;		LDA	MNTIME
;;;;;;;;		BNE	MINIMOV1_2_050	; ~jQ[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JSL	>MHDPLY_JSL
;;;;;;;;		JMP	MINIMOV1_2_100
;;;;;;;;;
;;;;;;;;MINIMOV1_2_050	EQU	$
;;;;;;;;		JSL	>PLAYER		; player move sub !!
;;;;;;;;;
;;;;;;;;		MEM8
;;;;;;;;		IDX8
;;;;;;;;		LDA	!MSGMOD		; bZ[W EBhD nm ?
;;;;;;;;		BNE	MINIMOV1_2_100	;	YES -> MINIMOV1_2_100
;;;;;;;;;
;;;;;;;;		JSL	>ENEMY_IN	; enemy move sub !!
;;;;;;;;;
;;;;;;;;		MI16			; memory,index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		JSR	METERST		; meter set sub !!
;;;;;;;;;
;;;;;;;;MINIMOV1_2_100	EQU	$
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;;;;;;;;;
;;;;;;;;		M8			; memory 8 bit mode !!
;;;;;;;;;
;;;;;;;;		RTS
;;;;;;;;;
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MIN2NOM ( ~jQ[vC )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ITMDATA		EQU	$
		BYTE	ITHAT,ITTMG
;
;
MIN2NOM		EQU	$
		JSR	>PLAYER		; player move sub !!
;
		LDA	MSGMOD
		BNE	MIN2NOM_END	; bZ[W EBhD nm ?
;					; No !!
		JSL	>ENEMY_IN	; enemy move sub !!
;
		MI16
;
		JSR	METERST		; meter set sub !!
;
		I8
;
		LDA	MNMODE
		BEQ	MIN2NOM_END	; ~jQ[I@H
;					; Yes !!
		LDX	#(ENNO-1)*4
;
MIN2NOM_050	EQU	$
		LDA	ENMODE,X
		BEQ	MIN2NOM_100	; GĂ@H
;					; Yes !!
		STZ	ENXSPD,X
		STZ	ENYSPD,X
		STZ	ENGPOW,X
		STZ	ENXPOW,X
;
MIN2NOM_100	EQU	$
		DEX
		DEX
		DEX
		DEX
		BPL	MIN2NOM_050	; `FbNI@H
;					; Yes !!
		LDA	MNTIME
		BNE	MIN2NOM_END	; Q[I@H
;					; Yes !!
		LDA	WINFLG
		BNE	MIN2NOM_END	; vC[@H
;					; Yes !!
		LDA	#M_ITM
		JSL	>ENINSR_I
		BCC	MIN2NOM_END
;
		JSL	>RANDAM
		AND	#00001H
		TAX
		LDA	!ITMDATA,X
		AND	#000FFH
		STA	ENWRK0,Y	; ACemDZbg
;
		LDA	#00080H
		STA	ENYPSL,Y
		LDA	#00070H
		STA	ENXPSL,Y
;
MIN2NOM_END	EQU	$
		M8
;
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MIN2PWN ( ~jQ[vC[ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MIN2PWN		EQU	$
		JSR	>PLAYER		; player move sub !!
		JSL	>ENEMY_IN	; enemy move sub !!
;
		LDA	ITGTFG
		BEQ	MIN2PWN_END	; ACe@H
;					; Yes !!
		LDA	PLJUMP
		BNE	MIN2PWN_END	; vC[Wv@H
;					; No !!
;;;;;;;;		M16
;;;;;;;;;
;;;;;;;;		LDA	#080H
;;;;;;;;		STA	WAITTM
;;;;;;;;;
;;;;;;;;		M8
;;;;;;;;;
		INC	MNMODE
		INC	PLSTFG
;
MIN2PWN_END	EQU	$
		JSL	>MHDPLY_JSL
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MIN2EWN ( ~jQ[G )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MIN2EWN		EQU	$
		JSR	>PLAYER		; player move sub !!
		JSL	>ENEMY_IN	; enemy move sub !!
;
		LDA	#001H
		STA	PLSTFG
		STA	ITGTFG
		JMP	MIN2PWN_END
;
;
;------------------------------------------------------------------------
		MEM16
		IDX16
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	METERST ( meter set sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
METERST		EQU	$
		CLC
		SED
		LDA	PLTMCT
		ADC	SPECIAL_P
		STA	PLTMCT		; vC[ʃJEgAbv
		CLD
;
		DEC	MNTMCT
		BNE	METERST_200	; ^C}[JEg_E@H
;					; Yes !!
		SEC
		SED
		LDA	MNTIME
		SBC	#00001
		STA	MNTIME		; ~jQ[^C}[Zbg
		CLD
		BNE	METERST_150	; ~jQ[^C}[@O@H
;					; Yes !!
		LDY	#00000
		LDA	PLTMCT
		CMP	ENTMCT
		BCS	METERST_100	; vC[̏@H
;					; No !!
		INY
;
METERST_100	EQU	$
		STY	WINFLG
		INY
		STY	MNMODE
		LDA	#00001
		STA	HDMMOD
		BRA	METERST_200
;
METERST_150	EQU	$
		LDA	MNTIME
		CMP	#00006H
		BCS	METERST_170	; TEh炷@H
;					; Yes !!
		LDA	#0007FH
		JSL	>SOUND_3_ON	; []
;
METERST_170	EQU	$
		LDA	#00063
		STA	MNTMCT		; ~jQ[^C}[JEgZbg
;
METERST_200	EQU	$
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
;
		LDX	VRAMDX
		LDA	#03484H
		STA	0,X
		CLC
		ADC	#00020H
		STA	16,X
		LDA	#0348FH
		STA	32,X
		ADC	#00020H
		STA	48,X
		LDA	#0349AH
		STA	64,X
		ADC	#00020H
		STA	80,X
;
		LDA	#00180H
		STA	2,X
		STA	18,X
		STA	34,X
		STA	50,X
		STA	66,X
		STA	82,X
;
		LDA	#00018H
		STA	4,X
		STA	20,X
		STA	36,X
		STA	52,X
		STA	68,X
		STA	84,X
;
		TXA
		ADC	#00012
		STA	5,X
		ADC	#00016
		STA	21,X
		ADC	#00016
		STA	37,X
		ADC	#00016
		STA	53,X
		ADC	#00016
		STA	69,X
		ADC	#00016
		STA	85,X
;
		LDA	#BANK VRAMDX
		STA	7,X
		STA	23,X
		STA	39,X
		STA	55,X
		STA	71,X
		STA	87,X
;
		LDA	#00004
		STA	8,X
		STA	24,X
		STA	40,X
		STA	56,X
		STA	72,X
		STA	88,X
;
		TXA
		ADC	#00016
		STA	10,X
		ADC	#00016
		STA	26,X
		ADC	#00016
		STA	42,X
		ADC	#00016
		STA	58,X
		ADC	#00016
		STA	74,X
		ADC	#00016
		STA	90,X
		STA	VRAMDX
;
		PLB
		PLB
;
		TXA
		SEC
		SBC	#VRAMDX+2
		TAX
;
		LDA	PLTMCT
		TAY
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#02900H
		STA	>VRAMDX+14,X
		ORA	#00010H
		STA	>VRAMDX+30,X
;
		TYA
		AND	#0000FH
		ORA	#02900H
		STA	>VRAMDX+16,X
		ORA	#00010H
		STA	>VRAMDX+32,X
;
		LDA	MNTIME
		TAY
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#02900H
		STA	>VRAMDX+46,X
		ORA	#00010H
		STA	>VRAMDX+62,X
;
		TYA
		AND	#0000FH
		ORA	#02900H
		STA	>VRAMDX+48,X
		ORA	#00010H
		STA	>VRAMDX+64,X
;
		LDA	ENTMCT
		TAY
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#02900H
		STA	>VRAMDX+78,X
		ORA	#00010H
		STA	>VRAMDX+94,X
;
		TYA
		AND	#0000FH
		ORA	#02900H
		STA	>VRAMDX+80,X
		ORA	#00010H
		STA	>VRAMDX+96,X
;
		RTS
;
;------------------------------------------------------------------------
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_THO_IN	( ~jQ[CCjVZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
XSPEDDT		EQU	$
		WORD	0FF00H,00100H
;
;
M_THOIN		EQU	$
		LDA	#00038H
		STA	ENYPSL,X	; CwWCjVZbg
		LDA	#00070H
		STA	ENXPSL,X	; CxWCjVZbg
		STZ	ENWRKC,X	; CCjVZbg
		LDY	ENWRKC,X
		LDA	!XSPEDDT,Y
		STA	ENXSPD,X	; CwXs[hCjVZbg
		LDA	#00040H
		STA	ENTIM0,X	; ʔ˃^C}[Zbg
		STZ	<ENWRK4,X	; ]NA[
		STZ	ENWRK6,X	; ]pZbg
		LDA	#00100H
		STA	ENWRK8,X	; w{Zbg
		LDA	#00100H
		STA	ENWRKA,X	; x{Zbg
		STZ	<ENCONT,X	; t[JE^[NA[
;
		STZ	ENTROB,X
;
KAITEN_ST	EQU	$
		LDA	#CIPCHD3+0080H
		STA	R12		;(R12) <-- LN^[AhXikCgj
		LDA	#BANK CIPCHD3
		STA	R13		;(R13) <--	   h		(aj
		LDA	ENWRK6,X
		STA	R5		;(R5)  <-- px
		LDA	ENWRK8,X
		STA	R6		;(R6)  <-- w{
		LDA	ENWRKA,X
		STA	R11		;(R11) <-- x{
;
		LDY	ENTROB,X
		TYX
		LDA	>TROBJ_PLOT_X,X
		STA	R3		;(R3)  <-- rbg}bvWQw
		LDA	>TROBJ_PLOT_Y,X
		STA	R2		;(R2)  <--	  h	   Qx
		M_CHIP	C_32_RTZ_32_XY
;
		INC	OBM7WF		;]LN^[]tOhnmh
;
		LDX	<ENINDX
;
M_THOIN_END	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_THO_MV	( ~jQ[C[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KAKUCMP		EQU	$
		WORD	00020H,000E0H
;
XPSDCMP		EQU	$
		WORD	00018H,000C8H
;
KAKUDOD		EQU	$
		WORD	00002H,0FFFEH
;
XBAIDAT		EQU	$
		WORD	00133H,0014DH,00166H,00133H,00100H
;
YBAIDAT		EQU	$
		WORD	000CDH,000B3H,0009AH,00100H,00100H
;
BAITMDT		EQU	$
		WORD	0000AH,0000AH,00010H,00004H,00000H
;
;
M_THOMV		EQU	$
		LDA	MNMODE
		BNE	M_THOIN_END	; ~jQ[I@H
;					; No !!
		LDA	ENTIM0,X
		BEQ	M_THO_MV_050	; ʔˁ@H
;					; No !!
		INC	<ENCONT,X
		LDA	<ENCONT,X
		AND	#00003
		BEQ	M_THO_MV_020	; Cgpx`FW@H
;					; No !!
M_THO_MV_010	EQU	$
		JMP	M_THO_MV_200
;
M_THO_MV_020	EQU	$
		LDY	<ENWRK4,X
		LDA	ENWRK6,X
		CLC
		ADC	!KAKUDOD,Y
		AND	#000FFH
		STA	ENWRK6,X	; CgpxZbg
		CMP	!KAKUCMP,Y
		BNE	M_THO_MV_040	; pxI[o[@H
;					; Yes !!
		TYA
		AND	#000FFH
		EOR	#00002H
		STA	<ENWRK4,X	; ]]
;
M_THO_MV_040	EQU	$
		JMP	M_THO_MV_150
;
M_THO_MV_050	EQU	$
		LDA	ENTIM2,X
		BNE	M_THO_MV_010	; CgLN^[`FW@H
;					; Yes !!
		INC	<ENWRK0,X	; CgLN^[|C^[CN
		LDA	<ENWRK0,X
		ASL	A
		TAY
		CPY	#(YBAIDAT-XBAIDAT)-2
		BEQ	M_THO_MV_060	; ʃZbg@H
;					; No !!
M_THO_MV_055	EQU	$
		JMP	M_THO_MV_100
;
M_THO_MV_060	EQU	$
		PHY
		LDA	#M_TAM
		JSL	>ENINSR_I	; ʃCjVZbg
		BCC	M_THO_MV_055	; ʃZbg@H
;					; Yes !!
		LDA	ENXPSL,X
		CLC
		ADC	#00008H
		STA	ENXPSL,Y	; ʁ@wWCjVZbg
		LDA	ENYPSL,X
		CLC
		ADC	#00008H
		STA	ENYPSL,Y	; ʁ@xWCjVZbg
;
		LDA	ENWRK6,X
		CLC
		ADC	#00040H
		AND	#000FFH
		ASL	A
		TAX
		LDA	>SIN,X
		ASL	A
		ASL	A
		STA	ENYSPD,Y	; ʁ@xXs[hZbg
		LDA	>COS,X
		ASL	A
		STA	ENXSPD,Y	; ʁ@wXs[hZbg
;
		LDX	<ENINDX
		LDA	#M_SM0		; CˉmD
		JSL	>EXINSR
		LDA	ENWRK6,X
		STA	EXWRK4,Y	; CgpxZbg
		LDA	ENXPSL,X
		CLC
		ADC	#00008
		STA	EXXPSL,Y	; wWZbg
		LDA	ENYPSL,X
		STA	EXYPSL,Y	; xWZbg
		LDA	#0000BH*4
		STA	EXWRKA,Y	; waZbg
		LDA	#00003H*4
		STA	EXWRKC,Y	; xaZbg
		LDA	#00000H
		STA	EXCHPT,Y	; p^[mDZbg
		LDA	#00003
		STA	EXTIM0,Y	; p^[^C}[Zbg
		LDA	#00004
		STA	EXTIM1,Y
		LDA	#00024H
		STA	EXCLOR,Y	; vCIeBZbg
;
		LDA	#00047H
		JSL	>SOUND_3_ON	; []
		PLY
;
M_THO_MV_100	EQU	$
		LDA	!XBAIDAT,Y
		STA	ENWRK8,X	; w{Zbg
		LDA	!YBAIDAT,Y
		STA	ENWRKA,X	; x{Zbg
		LDA	!BAITMDT,Y
		STA	ENTIM2,X	; ^C}[Zbg
		BNE	M_THO_MV_150	; CgLN^[`FWI@H
;					; Yes !!
		STZ	<ENWRK0,X	; CgLN^[|C^[NA[
		LDA	<RANDM0
		AND	#0003FH
		ADC	#00040H
		STA	ENTIM0,X	; ʔ˃^C}[Zbg
;
M_THO_MV_150	EQU	$
		JSL	>KAITEN_ST	; Cg]
;
M_THO_MV_200	EQU	$
		LDY	ENWRKC,X
		LDA	ENDSXL,X
		CMP	!XPSDCMP,Y
		BNE	M_THO_MV_250	; Cړ]@H
;					; Yes !!
		STZ	ENXSDR,X
		LDA	!XPSDCMP,Y
		STA	ENXPSL,X	; wWZbg
		TYA
		EOR	#00002
		TAY
		STA	ENWRKC,X	; Cړ]
		LDA	!XSPEDDT,Y
		STA	ENXSPD,X	; CړXs[hZbg
;
M_THO_MV_250	EQU	$
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_TAMIN		( ʃCjV )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_TAMIN		EQU	$
		LDY	#000
		LDA	ENXSPD,X
		BPL	M_TAMIN_050	; ʁ@wXs[hvX@H
;					; No !!
		INY
		INY
;
M_TAMIN_050	EQU	$
		TYA
		STA	ENMUKI,X	; ʁ@Zbg
;
M_TAMIN_END	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_TAMMV		( ʃ[u )				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PINTCOL		EQU	$
		WORD	00006H,00000H
;
;
M_TAMMV		EQU	$
		LDA	MNMODE
		BEQ	M_TAMIN_010	; ~jQ[I@H
;					; No !!
		JMP	M_TAMMV_250
;
M_TAMIN_010	EQU	$
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		CMP	#00100H
;;;;;;;;		BCS	M_TAMMV_090	; ʊO@H
;;;;;;;;;					; No !!
		LDY	ECRSFG,X
		BEQ	M_TAMMV_100
		BMI	M_TAMMV_050	; vC[Ɠ@H
;					; No !!
		DEY
;;;;;;;;		LDA	ENMYNO,Y
;;;;;;;;		CMP	#M_DR0
;;;;;;;;		BNE	M_TAMMV_100
;;;;;;;;;
		LDA	ENWRK6,Y
		BNE	M_TAMMV_100	; GĂ@H
;					; No !!
		CLC
		SED
		LDA	ENTMCT
		ADC	#00001
		STA	ENTMCT		; D_NʃJEgAbv
		CLD
;
		STZ	ENWRKC,X
		DEC	SPECIAL_P
		LDA	ENXPSL,X
		STA	<EWORK0		;(EWK0,1) <-- X pos set
		LDA	ENYPSL,X
		SEC
		SBC	#04H
		STA	<EWORK2		;(EWK2,3) <-- Y pos set
		BRA	M_TAMMV_080
;
M_TAMMV_050	EQU	$
		LDA	PLFLSH
		CMP	#00081H
		BCS	M_TAMMV_100	; vC[Ă@H
;					; No !!
		LDA	#00002
		STA	ENWRKC,X
		LDA	PLXPSL
		STA	<EWORK0		;(EWK0,1) <-- X pos set
		LDA	PLYPSL
		SEC
		SBC	#04H
		STA	<EWORK2		;(EWK2,3) <-- Y pos set
;
M_TAMMV_080	EQU	$
		LDA	#00003		;(A) <-- pattern no.
		JSL	>BEAT_P_SET_2	;[ * (Y) <-- ʃ|C^[ ]
		LDA	ENWRKC,X
		TAX
		LDA	EXCLOR,Y
		AND	#0FFF0H
		ORA	!PINTCOL,X
		STA	EXCLOR,Y	; _J[Zbg
		LDX	<ENINDX
;
M_TAMMV_090	EQU	$
		LDA	#00009H
		JSL	>SOUND_3_ON	; []
		JMP	>ENCLEAR	; GNA[
;
M_TAMMV_100	EQU	$
		LDA	ENCBFG,X
		LSR	A
		BCC	M_TAMMV_200	; nʂɓ@H
;					; Yes !!
		LDA	ENYSPD,X
		BMI	M_TAMMV_200
;
		LSR	A
		EOR	#0FFFFH
		INC	A
		STA	ENYSPD,X	; ʁ@xXs[hZbg
		CMP	#0FFF0H
		BCS	M_TAMMV_120	; ʁ@˂@H
;					; Yes !!
		LDA	#0002CH
		JSL	>SOUND_3_ON	; []
		BRA	M_TAMMV_200
;
M_TAMMV_120	EQU	$
		STZ	ENYSPD,X	; ʁ@xXs[hNA[
		LDA	ENXSPD,X
		BPL	M_TAMMV_150	; ʂwXs[hvX@H
;					; No !!
		EOR	#0FFFFH
		INC	A
;
M_TAMMV_150	EQU	$
		CMP	#00010H
		BCS	M_TAMMV_200	; ʂwXs[hNA[@H
;					; Yes !!
		STZ	ENXSPD,X	; ʂwXs[hNA[
;
M_TAMMV_200	EQU	$
		LDA	ENYSPD,X
		BMI	M_TAMMV_250	; vCIeB[グ@H
;					; Yes !!
		LDA	#00034H
		STA	ENCLOR,X	; vCIeB[グ
		LDA	#00003H
		STA	ENYUSN,X	; D揇ʃZbg
;
M_TAMMV_250	EQU	$
		LDA	FRCNT
		LSR	A
		LSR	A
		LSR	A
		AND	#00003H
		STA	ENCHPT,X
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		T_DR0IN		( D_NCjV )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_DR0IN		EQU	$
		LDA	#000C0H
		STA	ENYPSL,X	; xWCjVZbg
		LDA	#000C0H
		STA	ENXPSL,X	; wWCjVZbg
		LDA	#00009H
		STA	ENCHPT,X	; p^[mDZbg
;
M_DR0IN_END	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		T_DR0MV		( D_N[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_DR0MV		EQU	$
		LDA	MNMODE
		BNE	M_DR0IN_END	; ~jQ[I@H
;					; Yes !!
		LDA	PLFLSH
		CMP	#00081H
		BCS	M_DR0MV_050	; vC[C⒆@H
;					; Yes !!
		STZ	PLFLSH		; vC[CtONA[
;
M_DR0MV_050	EQU	$
		LDA	ENDSXL,X
		CMP	#00010H
		BCS	M_DR0MV_100	; ʍ[I[o[@H
;					; Yes !!
		LDA	#00010H
		SEC
		SBC	ENDSXL,X
		CLC
		ADC	ENXPSL,X
		STA	ENXPSL,X	; wW␳
		BRA	M_DR0MV_150
;
M_DR0MV_100	EQU	$
		LDA	ENDSXL,X
		SEC
		SBC	#000E0H
		BMI	M_DR0MV_200
;
		CMP	#00020H
		BCC	M_DR0MV_150	; ʉE[I[o[@H
;					; Yes !!
		STA	<EWORK0
		LDA	ENXPSL,X
		SEC
		SBC	<EWORK0
		STA	ENXPSL,X	; wW␳
;
M_DR0MV_150	EQU	$
		STZ	<ENWRK0,X
		LDA	ENWRK6,X
		BEQ	M_DR0MV_200
;
		STZ	ENWRK6,X
;
M_DR0MV_200	EQU	$
		LDA	<ENWRK0,X
		ASL	A
		TAY
		LDA	!M_DR0MV_ADR,Y
		STA	<EWORK0
		JMP	(EWORK0)
;
;
M_DR0MV_ADR	EQU	$
		WORD	SEARCHK		; ʃT[``FbN
		WORD	SEARCMV		; ʃT[`[u
		WORD	PLSEARC		; vC[T[`[u
EJUMP		WORD	JUMPMOV		; D_NWv[u
		WORD	CYAKUTI		; n|[Y[u
;
;
EJMP		EQU	(EJUMP-M_DR0MV_ADR)/2
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SEARCHK ( ʃT[``FbN )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SEARCHK		EQU	$
		LDA	PLFLSH
		BNE	SEARCHK_030	; vC[C@H
;					; No !!
		LDA	<RANDM0
		AND	#000FFH
		CMP	#000A0H
		BCC	SEARCHK_050	; ʃT[`@H
;					; Yes !!
SEARCHK_030	EQU	$
		TXA
		AND	#000FFH
		STA	R1		; GCfbNXZbg
		M_CHIP	M_ITEM_SEARCH
;
		LDX	<ENINDX
		LDA	R1
		BMI	SEARCHK_050	; ʂ@H
;					; Yes !!
		STA	<ENWRK2,X	; ʃCfbNXZbg
		TAY
;
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCS	SEARCHK_200	; Wv@H
;;;;;;;;;					; No !!
		LDA	ENXPSL,Y
		STA	<EWORK0		; ڕWwW
		LDA	#00200H
		STA	<EWORK2		; ړXs[h
;
		INC	<ENWRK0,X	; ʃT[`[hZbg
		BRA	SEARCHK_100
;
SEARCHK_050	EQU	$
		LDA	PLXPSL
		STA	<EWORK0		; ڕWwW
		LDA	#00200H
		STA	<EWORK2		; ړXs[h
;
		LDA	#00002
		STA	<ENWRK0,X	; vC[T[`[hZbg
		LDA	#00050H
		STA	ENTIM0,X	; ^C}[Zbg
;;;;;;;;		STA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCS	SEARCHK_200	; Wv@H
;
SEARCHK_100	EQU	$
		LDA	<EWORK0
		STA	R1		; ڕWwW
		LDA	ENYPSL,X
		STA	R2		; ڕWxW
		STA	R4		; ݂xW
		LDA	ENXPSL,X
		STA	R3		; ݂wW
		LDA	<EWORK2
		STA	R6		; ړXs[h
;
		M_CHIP	SEARCH_SPEED
;
		LDX	<ENINDX
		LDY	#002
		LDA	R1
		STA	ENXSPD,X	; wXs[hZbg
		BPL	SEARCHK_150	; wXs[hvX@H
;					; No !!
		DEY
		DEY
;
SEARCHK_150	EQU	$
		TYA
		STA	ENMUKI,X	; Zbg
		LDA	#00001
		STA	ENCHPT,X	; p^[mDZbg
		LDA	#00003
		STA	ENTIM1,X	; p^[`FW^C}[Zbg
		STZ	<ENWRK4,X	; p^[`FW|C^[Zbg
;
SEARCHK_200	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SEARCMV ( ʃT[`[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SEARCMV		EQU	$
		LDY	<ENWRK2,X
		LDA	ENXPSL,Y
		STA	R1		; ڕWwW
		LDA	ENYPSL,X
		STA	R2		; ڕWxW
		STA	R4		; ݂xW
		LDA	ENXPSL,X
		STA	R3		; ݂wW
		LDA	#00300H
		STA	R6		; ړXs[h
;
		M_CHIP	SEARCH_SPEED
;
		LDX	<ENINDX
		LDA	R1
		STA	ENXSPD,X	; wXs[hZbg
		LDY	<ENWRK2,X	; ʃCfbNX[h
		LDA	ENXPSL,X
		SEC
		SBC	ENXPSL,Y
		BEQ	SEARCMV_040	; ڕWwWI[o[@H
;					; No !!
		EOR	R1
		BMI	SEARCMV_050	; w@|C^[I[o[@H
;					; Yes !!
SEARCMV_040	EQU	$
		LDA	ENXPSL,Y
		STA	ENXPSL,X	; ڕWwWZbg
;
SEARCMV_050	EQU	$
		LDA	ENCBFG,Y
		LSR	A
		BCS	SEARCMV_070	; ʍ~@H
;					; Yes !!
		LDA	ENYPSL,Y
		CMP	#000A0H
		BCS	SEARCMV_070	; Wv@H
;					; Yes !!
		LDA	ENCBFG,X
		LSR	A
		BCC	SEARCMV_070	; Wv@H
;					; No !!
		LDA	ENXPSL,Y
		SEC
		SBC	ENXPSL,X
		CLC
		ADC	#00038H
		CMP	#00070H
		BCS	SEARCMV_070	; Wv@H
;					; Yes !!
		LDA	ENCBFG,X
		LSR	A
		BCC	SEARCMV_070	; Wv@H
;					; Yes !!
		LDA	#0FA00H
		STA	ENYSPD,X	; D_NxXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
SEARCMV_070	EQU	$
		LDY	<ENWRK2,X
		LDA	ENMODE,Y
		BNE	SEARCMV_100	; ʃNA[@H
;					; Yes !!
		STZ	ENXSPD,X	; wXs[hNA[
		STZ	<ENWRK0,X	; [hNA[
		STZ	ENWRK6,X
;
SEARCMV_100	EQU	$
		LDY	#00009
		LDA	ENXSPD,X
		BEQ	SEARCMV_150	; wXs[hNA[@H
;					; No !!
		LDA	ENTIM1,X
		BNE	SEARCMV_200	; p^[`FW^C}[NA[@H
;					; Yes !!
		LDA	#00003
		STA	ENTIM1,X	; p^[`FW^C}[Zbg
		LDY	ENCHPT,X
		DEY
		BPL	SEARCMV_150	; p^[`FWmDI[o[@H
;					; Yes !!
		LDY	#00001
;
SEARCMV_150	EQU	$
		TYA
		STA	ENCHPT,X	; p^[`FWmDZbg
;
SEARCMV_200	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PLSEARC ( vC[T[`[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PLXSPDT		EQU	$
		WORD	0FD00H,00300H
;
ENXSPDT		EQU	$
		WORD	00300H,0FD00H
;
;
PLSEARC		EQU	$
		LDY	ECRSFG,X
		BPL	PLSEARC_030	; vC[ƏՓˁ@H
;					; Yes !!
		JMP	PLENCRS
;
PLSEARC_030	EQU	$
		LDA	ENCBFG,X
		LSR	A
		BCC	PLSEARC_050	; Wv@H
;					; No !!
		LDA	PLXPSL
		SEC
		SBC	ENXPSL,X
		CLC
		ADC	#00038H
		CMP	#00070H
		BCS	PLSEARC_050	; Wv@H
;					; Yes !!
		LDA	#0FC00H
		STA	ENYSPD,X	; D_NxXs[hZbg
		LDA	#00017H
		STA	ENCHPT,X	; p^[`FWmDZbg
		LDA	#EJMP
		STA	<ENWRK0,X
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
		RTL
;
PLSEARC_050	EQU	$
		LDA	PLXPSL
		STA	R1		; ڕWwW
		LDA	ENYPSL,X
		STA	R2		; ڕWxW
		STA	R4		; ݂xW
		LDA	ENXPSL,X
		STA	R3		; ݂wW
		LDA	#00200H
		STA	R6		; ړXs[h
;
		M_CHIP	SEARCH_SPEED
;
		LDX	<ENINDX
		LDA	R1
		STA	ENXSPD,X	; wXs[hZbg
		LDA	ENXPSL,X
		SEC
		SBC	PLXPSL
		BEQ	PLSEARC_090	; ڕWwWI[o[@H
;					; No !!
		EOR	R1
		BMI	PLSEARC_100	; w@|C^[I[o[@H
;					; Yes !!
PLSEARC_090	EQU	$
		LDA	PLXPSL
		STA	ENXPSL,X	; ڕWwWZbg
;
PLSEARC_100	EQU	$
		LDA	ENTIM0,X
		BEQ	PLSEARC_200	; vC[T[`^C}[@O@H
;					; No !!
		LDY	#00009
		LDA	ENXSPD,X
		BEQ	PLSEARC_150	; wXs[hNA[@H
;					; No !!
		LDA	ENTIM1,X
		BNE	PLSEARC_END	; p^[`FW^C}[NA[@H
;					; Yes !!
		LDA	#00003
		STA	ENTIM1,X	; p^[`FW^C}[Zbg
		LDY	ENCHPT,X
		DEY
		BPL	PLSEARC_150	; p^[`FWmDI[o[@H
;					; Yes !!
		LDY	#00001
;
PLSEARC_150	EQU	$
		TYA
		STA	ENCHPT,X	; p^[`FWmDZbg
		BRA	PLSEARC_END
;
PLSEARC_200	EQU	$
		LDA	#00009
		STA	ENCHPT,X	; p^[`FWmDZbg
		STZ	<ENWRK0,X	; [hNA[
;
PLSEARC_END	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	PLENCRS ( vC[ƓG̏Փ˃`FbN )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PLENCRS		EQU	$
		LDA	EPWIDY,X
		SEC
		SBC	PWIDEY
		SEC
		SBC	EWIDEY,X
		CMP	#0FFF8H
		BCC	PLENCRS_150	; vC[񂾁@H
;					; Yes !!
		LDY	#03AH
		JSL	>PDON0ST_2
		LDA	#0001CH
		JSL	>SOUND_3_ON	; []
;
		LDA	#00001
		STA	ENWRK6,X	; GCtOZbg
;
		LDA	<ENWRK0,X
		CMP	#EJMP
		BNE	PLENCRS_100	; GWv@H
;					; Yes !!
		LDA	ENYSPD,X
		BPL	PLENCRS_050	; ㏸@H
;					; Yes !!
		EOR	#0FFFFH
		INC	A
		STA	ENYSPD,X	; WvXs[h]
		BRA	PLENCRS_100
;
PLENCRS_050	EQU	$
		LDA	#0FC00H
		STA	ENYSPD,X	; D_NxXs[hZbg
		LDY	EPXMUK,X
		LDA	!ENXSPDT,Y
		STA	ENXSPD,X	; D_NwXs[hZbg
		LDA	#00017H
		STA	ENCHPT,X	; p^[`FWmDZbg
;
PLENCRS_100	EQU	$
		LDA	#P008
		STA	PLJUMP		; vC[WvtOZbg
		LDA	#0FA00H
		STA	PLYSPD		; vC[xXs[hZbg
		LDY	EPXMUK,X
		LDA	!PLXSPDT,Y
		STA	PLXSPD		; vC[wXs[hZbg
		STA	PLMVSP		; vC[ړXs[hZbg
		BRA	PLENCRS_250
;
PLENCRS_150	EQU	$
		LDA	EPWIDY,X
		CLC
		ADC	PWIDEY
		CLC
		ADC	EWIDEY,X
		CMP	#00008H
		BCC	PLENCRS_170	; vC[𓥂񂾁@H
;					; No !!
		LDA	#00034H
		JSL	>SOUND_3_ON	; []
		BRA	PLENCRS_050
;
PLENCRS_170	EQU	$
		LDA	#00017H
		JSL	>SOUND_3_ON	; []
;
		JSL	>BERO_CANCEL
		LDA	#000C0H
		STA	PLFLSH		; vC[CtOZbg
		STZ	PLDOSN
;
		LDA	PLJUMP
		BNE	PLENCRS_200	; vC[Wv@H
;					; Yes !!
		LDA	PLYSPD
		BPL	PLENCRS_050	; ㏸@H
;					; Yes !!
		EOR	#0FFFFH
		INC	A
		STA	PLYSPD		; WvXs[h]
		BRA	PLENCRS_200
;
PLENCRS_200	EQU	$
		LDA	#0FC00H
		STA	ENYSPD,X	; D_NxXs[hZbg
		LDY	EPXMUK,X
		LDA	!ENXSPDT,Y
		STA	ENXSPD,X	; D_NwXs[hZbg
		LDA	#00017H
		STA	ENCHPT,X	; p^[`FWmDZbg
;
PLENCRS_250	EQU	$
		LDA	#EJMP
		STA	<ENWRK0,X
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	JUMPMOV ( D_NWv[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
JUMPMOV		EQU	$
		LDA	ENWRK6,X
		BNE	JUMPMOV_050	; vC[ɓ܂ꂽ@H
;					; No !!
		LDY	ECRSFG,X
		BPL	JUMPMOV_050	; vC[ƏՓˁ@H
;					; Yes !!
		JSL	>PLENCRS
;
JUMPMOV_050	EQU	$
		LDY	#00018H
		LDA	ENYSPD,X
		BPL	JUMPMOV_100	; ㏸@H
;					; No !!
		DEY
;
JUMPMOV_100	EQU	$
		TYA
		STA	ENCHPT,X	; D_NWv|[YmDZbg
		LDA	ENCBFG,X
		LSR	A
		BCC	JUMPMOV_150	; n@H
;					; Yes !!
;;;;;;;;		STZ	ENYSPD,X	; D_NxXs[hNA[
		STZ	ENXSPD,X	; D_NwXs[hNA[
		INC	<ENWRK0,X	; [hCN
		LDA	#00019H
		STA	ENCHPT,X	; D_Nn|[YmDZbg
		STZ	<ENWRK4,X	; D_Nn|[Y|C^[NA[
		LDA	#00004H
		STA	ENTIM1,X	; D_Nn|[Y^C}[Zbg
;
		STZ	ENYSDR,X
		LDA	#000C0H
		STA	ENYPSL,X	; D_NxWZbg
;
		LDA	ENWRK6,X
		BEQ	JUMPMOV_150	; vC[ɓ܂ꂽ@H
;					; Yes !!
		LDA	#(YARAPTD-CYAKPTD)/2
		STA	<ENWRK4,X	; GC⃂[h
;
JUMPMOV_150	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CYAKUTI ( n|[Y[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CYAKPTD		EQU	$
		WORD	00019H,0001AH,0001BH,0001CH,0001DH,00009H
;
YARAPTD		EQU	$
		WORD	00012H,00013H,00014H,00015H,00016H,00015H,00016H,00015H
		WORD	00016H,00015H,00009H
;
CYAKTMD		EQU	$
		WORD	00004H,00004H,00008H,00002H,00002H,00000H
;
YARATMD		EQU	$
		WORD	00004H,00004H,00004H,00014H,00002H,00002H,00002H,00002H
		WORD	00002H,00014H,00000H
;
;
CYAKUTI		EQU	$
		LDA	ENTIM1,X
		BNE	CYAKUTI_050	; D_Nn|[Y`FW@H
;					; Yes !!
		INC	<ENWRK4,X
		LDA	<ENWRK4,X
		ASL	A
		TAY
		LDA	!CYAKPTD,Y
		STA	ENCHPT,X	; D_Nn|[YmDZbg
		LDA	!CYAKTMD,Y
		STA	ENTIM1,X	; D_Nn|[Y^C}[Zbg
		BNE	CYAKUTI_050	; D_Nn|[YI@H
;					; Yes !!
		STZ	<ENWRK0,X
		STZ	ENWRK6,X
;
CYAKUTI_050	EQU	$
		RTL
;
;
;========================================================================
		MEM8
		IDX8
;
		DPAGE	WORK0
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		MINIINT1_4	( ~jQ[rSCjVZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MINIINT1_4	EQU	$
;;;;;;;;;-------------- XN[l NA -----------------------------
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;		STZ	<SCCH1
;;;;;;;;		STZ	<SCCV1
;;;;;;;;		STZ	<SCCH2
;;;;;;;;		LDA	#00100H
;;;;;;;;		STA	<SCCV2
;;;;;;;;		STZ	<SCCH3
;;;;;;;;		STZ	<SCCV3
;;;;;;;;		M8			; memory 8bit mode
;;;;;;;;;
;;;;;;;;		LDA	#069H
;;;;;;;;		STA	!BG1SCF
;;;;;;;;		STA	2107H
;;;;;;;;		LDA	#038H
;;;;;;;;		STA	!BG2SCF
;;;;;;;;		STA	2108H
;;;;;;;;		LDA	#029H
;;;;;;;;		STA	BGMODE
;;;;;;;;		STA	2105H
;;;;;;;;		STZ	HD420C
;;;;;;;;		LDA	#020H
;;;;;;;;		STA	!SUBADF
;;;;;;;;		STZ	!WIND25
;;;;;;;;;
;;;;;;;;;-------------- Q[ CjV -----------------------------------
;;;;;;;;		MI16			; memory,index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	#000A0H
;;;;;;;;		STA	PLYPSL		; player Y initial set !!
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	PLXPSL		; player X initial set !!
;;;;;;;;		STZ	UNBUFAD
;;;;;;;;		STA	TIMER
;;;;;;;;		LDA	#P_CAR		;N}bV[
;;;;;;;;		STA	PLTYPE		;
;;;;;;;;		JSL	>CAR_INITL	;
;;;;;;;;;
;;;;;;;;;;NOM;;		LDA	#00099H
;;;;;;;;		LDA	#00031H
;;;;;;;;		STA	MNTIME		; ~jQ[^C}[Zbg
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	MNTMCT		; ~jQ[^C}[JE^[Zbg
;;;;;;;;		STZ	PLTMCT
;;;;;;;;		STZ	ENTMCT
;;;;;;;;;
;;;;;;;;;;;;;;;;		LDA	#0FFFFH
;;;;;;;;;;;;;;;;		STA	OBJCHR_BNK
;;;;;;;;;;;;;;;;		STA	OBJCHR_BNK+2
;;;;;;;;;;;;;;;;		STA	OBJCHR_BNK+4
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;K;;;;		JSR	METERST_200
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	#M_HEI
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#M_HEI
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#M_TH1
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#M_DR1
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;;
;;;;;;;;		LDA	#MINICORS00
;;;;;;;;		STA	<BGDTADR
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	BG1TYP
;;;;;;;;;
;;;;;;;;		MI8			; memory,index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	#BANK MINICORS00
;;;;;;;;		STA	<BGDTADR+2
;;;;;;;;		JSL	>UNITST_SUB
;;;;;;;;;
;;;;;;;;		JSL	>MINI_INT_BG
;;;;;;;;;
;;;;;;;;		JSL	>ENEMY_IN
;;;;;;;;;
		RTS
;
;
;****************************************************************
;*								*
;*		~j Q[					*
;*								*
;****************************************************************
MINIMOV1_4	EQU	$
;;;;;;;;		LDA	!MSGMOD		; bZ[W EBhD nm ?
;;;;;;;;		BNE	MINIMOV1_4_250	;	YES -> MINIMOV1_4_250
;;;;;;;;;
;;;;;;;;		MI16			; memory,index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	ENXPSL+054H
;;;;;;;;		SEC
;;;;;;;;		SBC	#000B0H
;;;;;;;;		BMI	MINIMOV1_4_250	; XN[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		CMP	#00400H
;;;;;;;;		BCC	MINIMOV1_4_200	; XN[͈̓I[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		SEC
;;;;;;;;		SBC	#00400H
;;;;;;;;;
;;;;;;;;		PHA
;;;;;;;;;
;;;;;;;;		LDA	!PLXPSL
;;;;;;;;		SEC
;;;;;;;;		SBC	#0400H
;;;;;;;;		STA	!PLXPSL		; player possition ␳
;;;;;;;;;
;;;;;;;;		LDA	BG2LOP
;;;;;;;;		CLC
;;;;;;;;		ADC	#00400H
;;;;;;;;		STA	BG2LOP
;;;;;;;;;
;;;;;;;;		LDX	#(ENNO-1)*4
;;;;;;;;MINIMOV1_4_050	EQU	$
;;;;;;;;		LDA	!ENMODE,X
;;;;;;;;		BEQ	MINIMOV1_4_100	; move enmy ?
;;;;;;;;;					; yes
;;;;;;;;		LDA	!ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	#00400H
;;;;;;;;		STA	!ENXPSL,X	; ␳
;;;;;;;;MINIMOV1_4_100	EQU	$
;;;;;;;;		DEX
;;;;;;;;		DEX
;;;;;;;;		DEX
;;;;;;;;		DEX
;;;;;;;;		BPL	MINIMOV1_4_050	; all check ok ?
;;;;;;;;;					; yes
;;;;;;;;		PLA
;;;;;;;;;
;;;;;;;;MINIMOV1_4_200	EQU	$
;;;;;;;;		STA	<SCCH1		; BG1 scroll counter move
;;;;;;;;		STA	!ESCCH1		; enmy use BG1 scroll counter move
;;;;;;;;		ORA	BG2LOP
;;;;;;;;		LSR	A
;;;;;;;;		STA	<SCCH2		; BG2 scroll counter move
;;;;;;;;;
;;;;;;;;MINIMOV1_4_250	EQU	$
;;;;;;;;		MI8			; memory,index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		JSL	>OAMDXCLR	; OAM clear sub !!
;;;;;;;;		JSL	>ENCSET_DM	; enemy char set sub !!
;;;;;;;;		JSL	>PLCSET		; player char set sub !!
;;;;;;;;;
;;;;;;;;		STZ	SPECIAL_P
;;;;;;;;		LDA	MNTIME
;;;;;;;;		BNE	MINIMOV1_4_350	; ~jQ[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;		DEC	ENDTIM
;;;;;;;;		BNE	MINIMOV1_4_400	; sI@H
;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		LDA	WINFLG
;;;;;;;;;;;;;;;;		BNE	MINIMOV1_4_290	; vC[@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;K;;;;		LDY	#MINIT
;;;;;;;;;;;;K;;;;		INC	MINIMD
;;;;;;;;;;;;K;;;;		LDA	MINIMD
;;;;;;;;;;;;K;;;;		CMP	#003H
;;;;;;;;;;;;K;;;;		BNE	MINIMOV1_4_300	; ~jQ[@RI@H
;;;;;;;;;					; Yes !!
;;;;;;;;MINIMOV1_4_290	EQU	$
;;;;;;;;		JSL	>BACK_GAME
;;;;;;;;		BRA	MINIMOV1_4_450
;;;;;;;;;;;;K;;;;		LDY	#HMPIN
;;;;;;;;;
;;;;;;;;MINIMOV1_4_300	EQU	$
;;;;;;;;;;;;K;;;;		STY	MODENO		; C[hZbg
;;;;;;;;;;;;K;;;;		BRA	MINIMOV1_4_450
;;;;;;;;;
;;;;;;;;		MEM8
;;;;;;;;;
;;;;;;;;MINIMOV1_4_350	EQU	$
;;;;;;;;		JSL	>PLAYER		; player move sub !!
;;;;;;;;;
;;;;;;;;		LDA	!MSGMOD		; bZ[W EBhD nm ?
;;;;;;;;		BNE	MINIMOV1_4_400	;	YES -> MINIMOV1_4_400
;;;;;;;;		JSL	>ENEMY_IN	; enemy move sub !!
;;;;;;;;		JSR	METERS1		; [^[Zbg[`
;;;;;;;;;
;;;;;;;;MINIMOV1_4_400	EQU	$
;;;;;;;;		MI16			; memory,index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		STZ	BG2_SP_SCR
;;;;;;;;;
;;;;;;;;		MI8			; memory,index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		JSL	>BGSET		; af@P@[`
;;;;;;;;;
;;;;;;;;MINIMOV1_4_450	EQU	$
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;;;;;;;;;
;;;;;;;;		M8			; memory 8 bit mode !!
;;;;;;;;;
		RTS
;
;
;------------------------------------------------------------------------
;;;;;;;;		MEM16
;;;;;;;;		IDX16
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	METERS1 ( meter set sub )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
YOUWIN0		EQU	$
		WORD	02520H,02521H,02522H,0257FH,02523H,02524H,0E532H,0A530H
YOUWIN1		EQU	$
		WORD	02530H,0A521H,0A521H,0257FH,02533H,02534H,02532H,02529H
;
YOULOS0		EQU	$
		WORD	02D20H,02D21H,02D22H,02D7FH,02D25H,02D21H,0ED31H,02D26H,0AD30H
YOULOS1		EQU	$
		WORD	02D30H,0AD21H,0AD21H,02D7FH,02D35H,0AD21H,02D31H,02D35H,02D29H
;
DATADRS		EQU	$
		WORD	MWIN,MLOS
;
SOUNDNO		EQU	$
		WORD	00005H,00007H
;
WINVRMD		EQU	$
		WORD	WINVRME
;
		WORD	035ACH
		HEX	080,001,018
		LWORD	YOUWIN0
		WORD	YOUWIN1-YOUWIN0
		WORD	WINVRM0
;
WINVRM0		EQU	$
		WORD	035CCH
		HEX	080,001,018
		LWORD	YOUWIN1
		WORD	YOUWIN1-YOUWIN0
		WORD	WINVRME
WINVRME		EQU	$
;
LOSVRMD		EQU	$
		WORD	LOSVRME
;
		WORD	035ACH
		HEX	080,001,018
		LWORD	YOULOS0
		WORD	YOULOS1-YOULOS0
		WORD	LOSVRM0
;
LOSVRM0		EQU	$
		WORD	035CCH
		HEX	080,001,018
		LWORD	YOULOS1
		WORD	YOULOS1-YOULOS0
		WORD	LOSVRME
LOSVRME		EQU	$
;
;
;;;;;;;;METERS1		EQU	$
;;;;;;;;		MI16			; memory,index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		JSR	METERST
;;;;;;;;		LDA	MNTIME
;;;;;;;;		BNE	METERS1_050	; ~jQ[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00200H
;;;;;;;;		STA	ENDTIM
;;;;;;;;		LDA	WINFLG
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		LDA	!DATADRS,Y
;;;;;;;;		STA	VRFLG2
;;;;;;;;		LDA	!SOUNDNO,Y
;;;;;;;;		STA	<SOUND_0	; []
;;;;;;;;;
;;;;;;;;METERS1_050	EQU	$
;;;;;;;;		MI8			; memory,index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		RTS
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;------------------------------------------------------------------------
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_TH1IN		( ~jQ[CCjVZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_TH1IN		EQU	$
;;;;;;;;		LDA	#0009EH
;;;;;;;;		STA	ENYPSL,X	; CwWCjVZbg
;;;;;;;;		LDA	#00078H
;;;;;;;;		STA	ENXPSL,X	; CxWCjVZbg
;;;;;;;;		STZ	<ENWRK4,X	; ]NA[
;;;;;;;;		STZ	ENWRK6,X	; Cg]pZbg
;;;;;;;;		STZ	ENWRKC,X	; C]pZbg
;;;;;;;;		LDA	#00100H
;;;;;;;;		STA	ENWRK8,X	; w{Zbg
;;;;;;;;		LDA	#00100H
;;;;;;;;		STA	ENWRKA,X	; x{Zbg
;;;;;;;;		STZ	<ENCONT,X	; t[JE^[NA[
;;;;;;;;		LDA	#00040H
;;;;;;;;		STA	ENTIM0,X	; ʔ˃^C}[Zbg
;;;;;;;;;;;;;;;;		STX	TAIHNO		; CCfbNXmDZbg
;;;;;;;;;
;;;;;;;;KAITEN_ST_1	EQU	$
;;;;;;;;		LDA	#CIPCHD3+0080H
;;;;;;;;		STA	R12		;(R12) <-- LN^[AhXikCgj
;;;;;;;;		LDA	#BANK CIPCHD3
;;;;;;;;		STA	R13		;(R13) <--	   h		(aj
;;;;;;;;		LDA	ENWRK6,X
;;;;;;;;		STA	R5		;(R5)  <-- Cgpx
;;;;;;;;		LDA	ENWRK8,X
;;;;;;;;		STA	R6		;(R6)  <-- Cgw{
;;;;;;;;		LDA	ENWRKA,X
;;;;;;;;		STA	R11		;(R11) <-- Cgx{
;;;;;;;;;
;;;;;;;;		LDA	>TROBJ_PLOT_X
;;;;;;;;		STA	R3		;(R3)  <-- rbg}bvWQw
;;;;;;;;		LDA	>TROBJ_PLOT_Y
;;;;;;;;		STA	R2		;(R2)  <--	  h	   Qx
;;;;;;;;		M_CHIP	C_32_RTZ_32_XY
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDA	#CIPCHD3+00E0H
;;;;;;;;		STA	R12		;(R12) <-- LN^[AhXikCgj
;;;;;;;;		LDA	#BANK CIPCHD3
;;;;;;;;		STA	R13		;(R13) <--	   h		(aj
;;;;;;;;		LDA	ENWRKC,X
;;;;;;;;		STA	R5		;(R5)  <-- Cpx
;;;;;;;;		LDA	#00100H
;;;;;;;;		STA	R6		;(R6)  <-- Cw{
;;;;;;;;		LDA	#00100H
;;;;;;;;		STA	R11		;(R11) <-- Cx{
;;;;;;;;;
;;;;;;;;		LDA	>TROBJ_PLOT_X+8
;;;;;;;;		STA	R3		;(R3)  <-- rbg}bvWQw
;;;;;;;;		LDA	>TROBJ_PLOT_Y+8
;;;;;;;;		STA	R2		;(R2)  <--	  h	   Qx
;;;;;;;;		M_CHIP	C_32_RTZ_32_XY
;;;;;;;;;
;;;;;;;;		INC	OBM7WF		;]LN^[]tOhnmh
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_TH1MV		( ~jQ[C[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;KAK1CMP		EQU	$
;;;;;;;;		WORD	00020H,000E0H
;;;;;;;;;
;;;;;;;;YHOSEDT		EQU	$
;;;;;;;;		WORD	00004H,00003H,00002H,00004H
;;;;;;;;;;;;;;;;		WORD	00000H,00000H
;;;;;;;;;;;;;;;;;;;;;;;;		WORD	00000H
;;;;;;;;;;;;;;;;		WORD	00000H
;;;;;;;;;;;;;;;;		WORD	0000CH,0000CH,0000CH,00008H,00004H
;;;;;;;;;
;;;;;;;;;
M_TH1MV		EQU	$
		RTL
;;;;;;;;;;;;;;;;		JMP	M_TH1MV_100
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		LDA	TAIONF
;;;;;;;;;;;;;;;;		BNE	M_TH1MV_150	; wCzEグĂ@H
;;;;;;;;;;;;;;;;;					; No !!
;;;;;;;;;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		PHX
;;;;;;;;;;;;;;;;		LDY	ENOAML,X
;;;;;;;;;;;;;;;;		LDA	ENWRKC,X
;;;;;;;;;;;;;;;;		ASL	A
;;;;;;;;;;;;;;;;		TAX
;;;;;;;;;;;;;;;;		LDA	>COS,X
;;;;;;;;;;;;;;;;		STA	<EWORK2		; bnr@f[^[Zbg
;;;;;;;;;;;;;;;;		LDA	>SIN,X
;;;;;;;;;;;;;;;;		STA	<EWORK0		; rhm@f[^[Zbg
;;;;;;;;;;;;;;;;		PLX
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		ASL	A
;;;;;;;;l;;;;;;;;		 ASL	 A
;;;;;;;;;;;;;;;;		STA	<EWORK0
;;;;;;;;;;;;;;;;		ASL	A
;;;;;;;;;;;;;;;;		CLC
;;;;;;;;;;;;;;;;		ADC	<EWORK0
;;;;;;;;;;;;;;;;		CLC
;;;;;;;;;;;;;;;;		ADC	#00080H
;;;;;;;;;;;;;;;;		AND	#0FF00H
;;;;;;;;;;;;;;;;		BPL	M_TH1MV_140	; @H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		ORA	#000FFH
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_TH1MV_140	EQU	$
;;;;;;;;;;;;;;;;		XBA
;;;;;;;;;;;;;;;;		STA	<EWORK0		; w␳f[^[Zbg
;;;;;;;;;;;;;;;;		JMP	M_TH1MV_390
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		IDX8
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_TH1MV_150	EQU	$
;;;;;;;;;;;;;;;;		LDY	ECRSFG,X
;;;;;;;;;;;;;;;;		BEQ	M_TH1MV_200
;;;;;;;;;;;;;;;;		BMI	M_TH1MV_200	; Gɓ@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		DEY
;;;;;;;;;;;;;;;;		LDA	ENSHOT,Y
;;;;;;;;;;;;;;;;		BEQ	M_TH1MV_200	; ɓ@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		STZ	TAIONF		; CグtONA[
;;;;;;;;;;;;;;;;		LDA	#0FC00H
;;;;;;;;;;;;;;;;		STA	ENYSPD+058H	; wCzEQ@WvXs[hZbg
;;;;;;;;;;;;;;;;		STA	ENYSPD+05CH	; wCzEP@WvXs[hZbg
;;;;;;;;;;;;;;;;		LDA	#00100H
;;;;;;;;;;;;;;;;		STA	ENXSPD+05CH	; wCzEP@wXs[hZbg
;;;;;;;;;;;;;;;;		LDA	#0FF00H
;;;;;;;;;;;;;;;;		STA	ENXSPD+058H	; wCzEQ@xXs[hZbg
;;;;;;;;;;;;;;;;		LDA	#00002
;;;;;;;;;;;;;;;;		STA	ENMUKI+05CH	; wCzEP@]
;;;;;;;;;;;;;;;;		LDA	#00040H
;;;;;;;;;;;;;;;;		STA	ENTIM1+058H
;;;;;;;;;;;;;;;;		STA	ENTIM1+05CH
;;;;;;;;;;;;;;;;		STZ	ENTIM0+058H
;;;;;;;;;;;;;;;;		STZ	ENTIM0+05CH
;;;;;;;;;;;;;;;;		LDA	#00002
;;;;;;;;;;;;;;;;		STA	<ENWRK0+05CH
;;;;;;;;;;;;;;;;		STA	<ENWRK0+058H
;;;;;;;;;;;;;;;;		STZ	<ENCONT+058H
;;;;;;;;;;;;;;;;		STZ	<ENCONT+05CH
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_TH1MV_200	EQU	$
;;;;;;;;		LDY	<ENCONT+05CH
;;;;;;;;		LDA	ENYPSL+058H
;;;;;;;;		SEC
;;;;;;;;		SBC	ENYPSL+05CH
;;;;;;;;		STA	R2		; xZbg
;;;;;;;;		CLC
;;;;;;;;		BPL	M_TH1MV_250	; @H
;;;;;;;;;					; Yes !!
;;;;;;;;		SEC
;;;;;;;;;
;;;;;;;;M_TH1MV_250	EQU	$
;;;;;;;;		ROR	A
;;;;;;;;		STA	<EWORK0
;;;;;;;;		LDA	ENYPSL+05CH
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK0
;;;;;;;;		SEC
;;;;;;;;		SBC	#0000CH
;;;;;;;;		CLC
;;;;;;;;		ADC	!YHOSEDT,Y
;;;;;;;;		STA	ENYPSL,X	; CxWZbg
;;;;;;;;;
;;;;;;;;		LDA	ENXPSL+058H
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL+05CH
;;;;;;;;		STA	R1		; wZbg
;;;;;;;;		EOR	#0FFFFH
;;;;;;;;		INC	A
;;;;;;;;		LSR	A
;;;;;;;;		STA	<EWORK0
;;;;;;;;		LDA	ENXPSL+05CH
;;;;;;;;		SEC
;;;;;;;;		SBC	<EWORK0
;;;;;;;;		STA	ENXPSL,X	; CwWZbg
;;;;;;;;;
;;;;;;;;		M_CHIP	M_RAD_GET
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDA	R1
;;;;;;;;		STA	ENWRKC,X	; CpxZbg
;;;;;;;;;
;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		PHX
;;;;;;;;		LDY	ENOAML,X
;;;;;;;;		LDA	ENWRKC,X
;;;;;;;;		ASL	A
;;;;;;;;		TAX
;;;;;;;;		LDA	>COS,X
;;;;;;;;		STA	<EWORK2		; bnr@f[^[Zbg
;;;;;;;;		LDA	>SIN,X
;;;;;;;;		STA	<EWORK0		; rhm@f[^[Zbg
;;;;;;;;		PLX
;;;;;;;;;
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		STA	<EWORK0
;;;;;;;;		ASL	A
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK0
;;;;;;;;		CLC
;;;;;;;;		ADC	#00080H
;;;;;;;;		AND	#0FF00H
;;;;;;;;		BPL	M_TH1MV_300	; @H
;;;;;;;;;					; Yes !!
;;;;;;;;		ORA	#000FFH
;;;;;;;;;
;;;;;;;;M_TH1MV_300	EQU	$
;;;;;;;;		XBA
;;;;;;;;		STA	<EWORK0		; w␳f[^[Zbg
;;;;;;;;		CLC
;;;;;;;;		ADC	ENXPSL,X
;;;;;;;;		STA	ENXPSL,X
;;;;;;;;;
;;;;;;;;		LDA	<EWORK2
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		STA	<EWORK2
;;;;;;;;		ASL	A
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK2
;;;;;;;;		CLC
;;;;;;;;		ADC	#00080H
;;;;;;;;		AND	#0FF00H
;;;;;;;;		BPL	M_TH1MV_350	; @H
;;;;;;;;;					; Yes !!
;;;;;;;;		ORA	#000FFH
;;;;;;;;;
;;;;;;;;M_TH1MV_350	EQU	$
;;;;;;;;		XBA
;;;;;;;;		STA	<EWORK2		; x␳f[^[Zbg
;;;;;;;;		LDA	#0000CH
;;;;;;;;		SEC
;;;;;;;;		SBC	<EWORK2
;;;;;;;;		STA	<EWORK2
;;;;;;;;		CLC
;;;;;;;;		ADC	ENYPSL,X
;;;;;;;;		STA	ENYPSL,X
;;;;;;;;;
;;;;;;;;M_TH1MV_390	EQU	$
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	<EWORK4		; [vJE^[Zbg
;;;;;;;;;
;;;;;;;;M_TH1MV_400	EQU	$
;;;;;;;;		LDA	SOAM_DX+32,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK0
;;;;;;;;		STA	SOAM_DX+32,Y	; Cgw␳
;;;;;;;;		LDA	SOAM_DX+32+2,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK2
;;;;;;;;		STA	SOAM_DX+32+2,Y	; Cgx␳
;;;;;;;;		TYA
;;;;;;;;		CLC
;;;;;;;;		ADC	#00008
;;;;;;;;		TAY
;;;;;;;;		DEC	<EWORK4
;;;;;;;;		BNE	M_TH1MV_400
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	ENTIM0,X
;;;;;;;;		BEQ	M_TH1MV_450	; ʔˁ@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	<ENCONT,X
;;;;;;;;		INC	A
;;;;;;;;		AND	#00003
;;;;;;;;		STA	<ENCONT,X
;;;;;;;;		BNE	M_TH1MV_440	; Cgpx`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDY	<ENWRK4,X
;;;;;;;;		LDA	ENWRK6,X
;;;;;;;;		CLC
;;;;;;;;		ADC	!KAKUDOD,Y
;;;;;;;;		AND	#000FFH
;;;;;;;;		STA	ENWRK6,X	; CgpxZbg
;;;;;;;;		CMP	!KAK1CMP,Y
;;;;;;;;		BNE	M_TH1MV_440	; pxI[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		TYA
;;;;;;;;		AND	#000FFH
;;;;;;;;		EOR	#00002
;;;;;;;;		STA	<ENWRK4,X	; ]]
;;;;;;;;;
;;;;;;;;M_TH1MV_440	EQU	$
;;;;;;;;		JMP	M_TH1MV_100
;;;;;;;;;
;;;;;;;;M_TH1MV_450	EQU	$
;;;;;;;;		LDA	ENTIM2,X
;;;;;;;;		BNE	M_TH1MV_440	; CgLN^[`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		INC	<ENWRK0,X	; CgLN^[|C^[CN
;;;;;;;;		LDA	<ENWRK0,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		CPY	#(YBAIDAT-XBAIDAT)-2
;;;;;;;;		BEQ	M_TH1MV_460	; ʃZbg@H
;;;;;;;;;					; No !!
;;;;;;;;M_TH1MV_455	EQU	$
;;;;;;;;		JMP	M_TH1MV_050
;;;;;;;;;
;;;;;;;;M_TH1MV_460	EQU	$
;;;;;;;;		PHY
;;;;;;;;		LDA	#M_TAM
;;;;;;;;		JSL	>ENINSR_I	; ʃCjVZbg
;;;;;;;;		BCC	M_TH1MV_455	; No !!
;;;;;;;;;
;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	ENWRK6,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00040H
;;;;;;;;		AND	#000FFH
;;;;;;;;		STA	<EWORK0
;;;;;;;;		LDA	ENOAML,X
;;;;;;;;		TAX
;;;;;;;;		LDA	SOAM_DX+32,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00008H
;;;;;;;;		CLC
;;;;;;;;		ADC	SCCH1
;;;;;;;;		STA	ENXPSL,Y	; ʁ@wWZbg
;;;;;;;;		LDA	SOAM_DX+32+2,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00008H
;;;;;;;;		STA	ENYPSL,Y	; ʁ@xWZbg
;;;;;;;;		LDA	<EWORK0
;;;;;;;;		ASL	A
;;;;;;;;		TAX
;;;;;;;;		LDA	>SIN,X
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		STA	ENYSPD,Y	; ʁ@xXs[hZbg
;;;;;;;;		LDA	>COS,X
;;;;;;;;		ASL	A
;;;;;;;;		BMI	M_TH1MV_500	; ʁ@wXs[hvX@H
;;;;;;;;;					; Yes !!
;;;;;;;;		ASL	A
;;;;;;;;;
;;;;;;;;M_TH1MV_500	EQU	$
;;;;;;;;		STA	ENXSPD,Y	; ʁ@wXs[hZbg
;;;;;;;;		LDA	#00047H
;;;;;;;;		JSL	>SOUND_3_ON	; []
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDA	#M_SM0		; CˉmD
;;;;;;;;		JSL	>EXINSR
;;;;;;;;		LDA	ENWRK6,X
;;;;;;;;		STA	EXWRK4,Y	; CgpxZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00008
;;;;;;;;		STA	EXXPSL,Y	; wWZbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	#00010H
;;;;;;;;		STA	EXYPSL,Y	; xWZbg
;;;;;;;;		LDA	#0000BH*4
;;;;;;;;		STA	EXWRKA,Y	; waZbg
;;;;;;;;		LDA	#00003H*4
;;;;;;;;		STA	EXWRKC,Y	; xaZbg
;;;;;;;;		LDA	#00000H
;;;;;;;;		STA	EXCHPT,Y	; p^[mDZbg
;;;;;;;;		LDA	#00003
;;;;;;;;		STA	EXTIM0,Y	; p^[^C}[Zbg
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	EXTIM1,Y
;;;;;;;;		LDA	#00024H
;;;;;;;;		STA	EXCLOR,Y	; vCIeBZbg
;;;;;;;;;
;;;;;;;;;;;;;;;;		LDX	<ENINDX
;;;;;;;;;;;;;;;;;
;;;;;;;;		LDA	#00047H
;;;;;;;;		JSL	>SOUND_3_ON	; []
;;;;;;;;		PLY
;;;;;;;;;
;;;;;;;;M_TH1MV_050	EQU	$
;;;;;;;;		LDA	!XBAIDAT,Y
;;;;;;;;		STA	ENWRK8,X	; w{Zbg
;;;;;;;;		LDA	!YBAIDAT,Y
;;;;;;;;		STA	ENWRKA,X	; x{Zbg
;;;;;;;;		LDA	!BAITMDT,Y
;;;;;;;;		STA	ENTIM2,X	; ^C}[Zbg
;;;;;;;;		BNE	M_TH1MV_100	; CgLN^[`FWI@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	<ENWRK0,X	; CgLN^[|C^[NA[
;;;;;;;;		LDA	#00080H
;;;;;;;;		STA	ENTIM0,X	; ʔ˃^C}[Zbg
;;;;;;;;;
;;;;;;;;M_TH1MV_100	EQU	$
;;;;;;;;		JMP	KAITEN_ST_1
;;;;;;;;;
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_HEIIN		( ~jQ[wCzECjVZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;HEIXPSD		EQU	$
;;;;;;;;		WORD	00081H,0006FH
;;;;;;;;;
;;;;;;;;;
M_HEIIN		EQU	$
;;;;;;;;		LDY	#000
;;;;;;;;		CPX	#05CH
;;;;;;;;		BEQ	M_HEIIN_050	; wCzEPCځ@H
;;;;;;;;;					; No !!
;;;;;;;;		INY
;;;;;;;;		INY
;;;;;;;;;
;;;;;;;;M_HEIIN_050	EQU	$
;;;;;;;;		LDA	!HEIXPSD,Y
;;;;;;;;		STA	ENXPSL,X	; wCzE@wWCjVZbg
;;;;;;;;		LDA	#000A0H
;;;;;;;;		STA	ENYPSL,X	; wCzE@xWCjVZbg
;;;;;;;;;;;;;;;;		LDA	#00001
;;;;;;;;;;;;;;;;		STA	TAIONF		; CStOZbg
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	ENTIM0,X	; p^[^C}[Zbg
;;;;;;;;		STZ	<ENCONT,X
;;;;;;;;		LDY	#000
;;;;;;;;		LDA	!HEIPTDT,Y
;;;;;;;;		STA	ENCHPT,X
;;;;;;;;		LDA	!HEITMDT,Y
;;;;;;;;		STA	ENTIM0,X
;;;;;;;;		LDA	#00200H
;;;;;;;;		STA	ENXSPD,X	; wCzE@wXs[hZbg
;;;;;;;;		STA	SCRL_XSPD	;XN[wXs[h
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_HEIMV		( ~jQ[wCzE[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;HEIPTDT		EQU	$
;;;;;;;;		WORD	00000H,00001H,00001H,00000H
;;;;;;;;;
;;;;;;;;;;;;;;;;HEIPTDW		EQU	$
;;;;;;;;;;;;;;;;HEIPTD0		EQU	$
;;;;;;;;;;;;;;;;		WORD	00001H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;HEIPTD1		EQU	$
;;;;;;;;;;;;;;;;		WORD	00000H,00001H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;HEIPTD2		EQU	$
;;;;;;;;;;;;;;;;		WORD	00002H,00003H,00004H,00005H,00006H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;HEITMDT		EQU	$
;;;;;;;;;;;;;;;;		WORD	00004H,00004H,00004H,00004H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;HEITMD0		EQU	$
;;;;;;;;;;;;;;;;		WORD	00000H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;HEITMD1		EQU	$
;;;;;;;;;;;;;;;;		WORD	00004H,00004H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;HEITMD2		EQU	$
;;;;;;;;;;;;;;;;		WORD	00010H,00004H,00020H,00002H,00004H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;PATNADR		EQU	$
;;;;;;;;;;;;;;;;		WORD	HEIPTDT-HEIPTDT
;;;;;;;;;;;;;;;;		WORD	HEIPTDW-HEIPTDT
;;;;;;;;;;;;;;;;		WORD	HEIPTD0-HEIPTDT
;;;;;;;;;;;;;;;;		WORD	HEIPTD1-HEIPTDT
;;;;;;;;;;;;;;;;		WORD	HEIPTD2-HEIPTDT
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;PATNCMP		EQU	$
;;;;;;;;;;;;;;;;		WORD	HEIPTD0-HEIPTDT
;;;;;;;;;;;;;;;;		WORD	HEIPTD1-HEIPTDT
;;;;;;;;;;;;;;;;		WORD	HEIPTD1-HEIPTDT
;;;;;;;;;;;;;;;;		WORD	HEIPTD2-HEIPTDT
;;;;;;;;;;;;;;;;		WORD	HEITMDT-HEIPTDT
;;;;;;;;;
;;;;;;;;;
M_HEIMV		EQU	$
;;;;;;;;;;;;;;;;		PEA	M_HEIMV_030
;;;;;;;;;;;;;;;;		LDY	<ENWRK0,X
;;;;;;;;;;;;;;;;		LDA	!M_HEIAD,Y
;;;;;;;;;;;;;;;;		STA	<EWORK0
;;;;;;;;;;;;;;;;		JMP	(EWORK0)
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_HEIMV_030	EQU	$-1
;;;;;;;;		LDA	ENTIM0,X
;;;;;;;;		BNE	M_HEIMV_100	; p^[`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	<ENCONT,X
;;;;;;;;		INC	A
;;;;;;;;		INC	A
;;;;;;;;		AND	#00007H
;;;;;;;;;;;;;;;;		CMP	!PATNCMP,Y
;;;;;;;;;;;;;;;;		BNE	M_HEIMV_050	; p^[|C^[I[o[@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		LDA	!PATNADR,Y
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_HEIMV_050	EQU	$
;;;;;;;;		STA	<ENCONT,X
;;;;;;;;		TAY
;;;;;;;;		LDA	!HEIPTDT,Y
;;;;;;;;		STA	ENCHPT,X
;;;;;;;;		LDA	!HEITMDT,Y
;;;;;;;;		STA	ENTIM0,X
;;;;;;;;;
;;;;;;;;M_HEIMV_100	EQU	$
		RTL
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;;;;;;;;M_HEIAD		EQU	$
;;;;;;;;;;;;;;;;		WORD	NOMARLS		; Cグĕ
;;;;;;;;;;;;;;;;		WORD	JUMPSUB		; wCzEWv
;;;;;;;;;;;;;;;;		WORD	WAITSUB		; wCzEƂĂ
;;;;;;;;;;;;;;;;		WORD	WALKSUB		; C̏܂ŕ
;;;;;;;;;;;;;;;;		WORD	TAIHSUB		; Cグ
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;;x		NOMARLS		( Cグĕ )			x
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;NOMARLS		EQU	$
;;;;;;;;;;;;;;;;		RTS
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;;x		JUMPSUB		( wCzEWv )			x
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;JUMPSUB		EQU	$
;;;;;;;;;;;;;;;;		LDA	ENYSPD,X
;;;;;;;;;;;;;;;;		BNE	JUMPSUB_050	; wCzEn@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		STZ	ENXSPD,X	; w@Xs[hNA[
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		LDA	ENYSPD+05CH
;;;;;;;;;;;;;;;;		ORA	ENYSPD+058H
;;;;;;;;;;;;;;;;		BNE	JUMPSUB_050	; QCƂn@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		INC	<ENWRK0,X
;;;;;;;;;;;;;;;;		INC	<ENWRK0,X	; [hCN
;;;;;;;;;;;;;;;;		LDA	#00040H
;;;;;;;;;;;;;;;;		STA	ENTIM1,X	; ^C}[Zbg
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;JUMPSUB_050	EQU	$
;;;;;;;;;;;;;;;;		RTS
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;;x		WAITSUB		( wCzEƂĂ )		x
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;WALKSPD		EQU	$
;;;;;;;;;;;;;;;;		WORD	00100H,0FF00H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;WAITSUB		EQU	$
;;;;;;;;;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;;;;;;;;;		BNE	WAITSUB_100	; ^C}[O@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		LDY	ENMUKI,X
;;;;;;;;;;;;;;;;		LDA	!WALKSPD,Y
;;;;;;;;;;;;;;;;		STA	ENXSPD,X	; w@Xs[hZbg
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;WAITSUB_050	EQU	$
;;;;;;;;;;;;;;;;		INC	<ENWRK0,X
;;;;;;;;;;;;;;;;		INC	<ENWRK0,X
;;;;;;;;;;;;;;;;		LDY	<ENWRK0,X
;;;;;;;;;;;;;;;;		LDA	!PATNADR,Y
;;;;;;;;;;;;;;;;		STA	<ENCONT,X
;;;;;;;;;;;;;;;;		TAY
;;;;;;;;;;;;;;;;		LDA	!HEIPTDT,Y
;;;;;;;;;;;;;;;;		STA	ENCHPT,X
;;;;;;;;;;;;;;;;		LDA	!HEITMDT,Y
;;;;;;;;;;;;;;;;		STA	ENTIM0,X
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;WAITSUB_100	EQU	$
;;;;;;;;;;;;;;;;		RTS
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;;x		WALKSUB		( C̏܂ŕ )			x
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;CRSPOSD		EQU	$
;;;;;;;;;;;;;;;;		WORD	0FFF8H,00008H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;WALKSUB		EQU	$
;;;;;;;;;;;;;;;;		LDA	ENXPSL+054H
;;;;;;;;;;;;;;;;		CLC
;;;;;;;;;;;;;;;;		ADC	#00008H
;;;;;;;;;;;;;;;;		SEC
;;;;;;;;;;;;;;;;		SBC	ENXPSL+05CH
;;;;;;;;;;;;;;;;		CMP	#00001H
;;;;;;;;;;;;;;;;		BNE	WALKSUB_050
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		STZ	ENXSPD+05CH
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;WALKSUB_050	EQU	$
;;;;;;;;;;;;;;;;		LDA	ENXPSL+054H
;;;;;;;;;;;;;;;;		SEC
;;;;;;;;;;;;;;;;		SBC	#00008H
;;;;;;;;;;;;;;;;		SEC
;;;;;;;;;;;;;;;;		SBC	ENXPSL+058H
;;;;;;;;;;;;;;;;		CMP	#00001H
;;;;;;;;;;;;;;;;		BNE	WALKSUB_100
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		STZ	ENXSPD+058H
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;WALKSUB_100	EQU	$
;;;;;;;;;;;;;;;;		LDA	ENXSPD+05CH
;;;;;;;;;;;;;;;;		ORA	ENXSPD+058H
;;;;;;;;;;;;;;;;		BNE	WALKSUB_150
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		LDA	#00001
;;;;;;;;;;;;;;;;		STA	TAIONF
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		JMP	WAITSUB_050
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;WALKSUB_150	EQU	$
;;;;;;;;;;;;;;;;		RTS
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;;x		TAIHSUB		( Cグ )			x
;;;;;;;;;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;;;;;;;;TAIHSUB		EQU	$
;;;;;;;;;;;;;;;;		LDA	ENTIM0,X
;;;;;;;;;;;;;;;;		BNE	TAIHSUB_050
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		LDA	<ENCONT,X
;;;;;;;;;;;;;;;;		CMP	#(HEITMDT-HEIPTDT)-2
;;;;;;;;;;;;;;;;		BNE	TAIHSUB_050
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		LDA	#0FFFEH
;;;;;;;;;;;;;;;;		STA	<ENWRK0,X
;;;;;;;;;;;;;;;;		STZ	ENMUKI,X
;;;;;;;;;;;;;;;;		LDA	#00200H
;;;;;;;;;;;;;;;;		STA	ENXSPD,X
;;;;;;;;;;;;;;;;		JMP	WAITSUB_050
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;TAIHSUB_050	EQU	$
;;;;;;;;;;;;;;;;		RTS
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_DR1IN		( D_N@rSQ[CjV )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_DR1IN		EQU	$
;;;;;;;;		LDA	#00040H
;;;;;;;;		STA	ENXPSL,X	; wWCjVZbg
;;;;;;;;		LDA	#000A0H
;;;;;;;;		STA	ENYPSL,X	; xWCjVZbg
;;;;;;;;		LDA	#00200H
;;;;;;;;		STA	ENXSPD,X	; wXs[hCjVZbg
;;;;;;;;		LDA	#00009H
;;;;;;;;		STA	ENCHPT,X	; p^[mDZbg
;;;;;;;;		LDA	#00002
;;;;;;;;		STA	ENMUKI,X	; Zbg
		RTL
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_DR1MV		( D_N@rSQ[[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_DR1MV		EQU	$
		RTL
;;;;;;;;		LDA	PLFLSH
;;;;;;;;		CMP	#00081H
;;;;;;;;		BCS	M_DR1MV_050	; vC[C⒆@H
;;;;;;;;;					; No !!
;;;;;;;;		STZ	PLFLSH		; vC[CtONA[
;;;;;;;;;
;;;;;;;;M_DR1MV_050	EQU	$
;;;;;;;;		LDA	ENDSXL,X
;;;;;;;;		CMP	#00010H
;;;;;;;;		BCS	M_DR1MV_100	; ʍ[I[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00010H
;;;;;;;;		SEC
;;;;;;;;		SBC	ENDSXL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	ENXPSL,X
;;;;;;;;		STA	ENXPSL,X	; wW␳
;;;;;;;;		BRA	M_DR1MV_150
;;;;;;;;;
;;;;;;;;M_DR1MV_100	EQU	$
;;;;;;;;		LDA	ENDSXL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	#000E0H
;;;;;;;;		BMI	M_DR1MV_150	; ʉE[I[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		CMP	#00020H
;;;;;;;;;;;;;;;;		BCC	M_DR1MV_150	; ʉE[I[o[@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;		STA	<EWORK0
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	<EWORK0
;;;;;;;;		STA	ENXPSL,X	; wW␳
;;;;;;;;;
;;;;;;;;M_DR1MV_150	EQU	$
;;;;;;;;		LDA	<ENWRK0,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		LDA	!M_DR1MV_ADR,Y
;;;;;;;;		STA	<EWORK0
;;;;;;;;		JMP	(EWORK0)
;;;;;;;;;
;;;;;;;;;
;;;;;;;;M_DR1MV_ADR	EQU	$
;;;;;;;;		WORD	DR1SEAR		; ʃT[``FbN
;;;;;;;;		WORD	DR1TMSH		; ʃT[`[u
;;;;;;;;		WORD	DR1PLSH		; vC[T[`[u
;;;;;;;;		WORD	DR1JUMP		; D_NWv[u
;;;;;;;;		WORD	DR1CYAK		; n|[Y[u
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	DR1SEAR ( ʃT[``FbN )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;DR1SEAR		EQU	$
;;;;;;;;;;;;;;;;		LDA	PLFLSH
;;;;;;;;;;;;;;;;		BNE	DR1SEAR_050	; vC[C@H
;;;;;;;;;;;;;;;;;					; No !!
;;;;;;;;;;;;;;;;		LDA	<RANDM0
;;;;;;;;;;;;;;;;		AND	#000FFH
;;;;;;;;;;;;;;;;		CMP	#000A0H
;;;;;;;;;;;;;;;;		BCC	DR1SEAR_100	; ʃT[`@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;DR1SEAR_050	EQU	$
;;;;;;;;		TXA
;;;;;;;;		AND	#000FFH
;;;;;;;;		STA	R1		; GCfbNXZbg
;;;;;;;;		M_CHIP	M_ITEM_SEARCH
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDA	R1
;;;;;;;;		BMI	DR1SEAR_100	; ʂ@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STA	<ENWRK2,X	; ʃCfbNXZbg
;;;;;;;;		TAY
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCC	DR1SEAR_250	; Wv@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENXPSL,Y
;;;;;;;;		STA	<EWORK0		; ڕWwWZbg
;;;;;;;;		LDA	#00300H
;;;;;;;;		STA	<EWORK2		; ړXs[hZbg
;;;;;;;;		INC	<ENWRK0,X	; ʃT[`[hZbg
;;;;;;;;		BRA	DR1SEAR_150
;;;;;;;;;
;;;;;;;;DR1SEAR_100	EQU	$
;;;;;;;;		JMP	DR1PLSH
;;;;;;;;;;;;;;;;		LDA	ENXPSL+054H
;;;;;;;;;;;;;;;;		STA	<EWORK0		; CwWZbg
;;;;;;;;;;;;;;;;		LDA	#00200H
;;;;;;;;;;;;;;;;		STA	<EWORK2		; ړXs[hZbg
;;;;;;;;;;;;;;;;		LDA	#00002
;;;;;;;;;;;;;;;;		STA	<ENWRK0,X	; vC[T[`[hZbg
;;;;;;;;;
;;;;;;;;DR1SEAR_150	EQU	$
;;;;;;;;		LDA	<EWORK0
;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;		LDA	<EWORK2
;;;;;;;;		STA	R6		; ړXs[hZbg
;;;;;;;;;
;;;;;;;;		M_CHIP	SEARCH_SPEED
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDY	#002
;;;;;;;;		LDA	R1
;;;;;;;;		BPL	DR1SEAR_200	; wXs[hvX@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	#000
;;;;;;;;		LDA	#0FE00H		; WvXs[hZbg
;;;;;;;;;
;;;;;;;;DR1SEAR_200	EQU	$
;;;;;;;;		STA	ENXSPD,X	; wXs[hZbg
;;;;;;;;		TYA
;;;;;;;;		STA	ENMUKI,X	; Zbg
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	ENCHPT,X	; p^[mDZbg
;;;;;;;;		LDA	#00003
;;;;;;;;		STA	ENTIM1,X	; p^[`FW^C}[Zbg
;;;;;;;;		STZ	<ENWRK4,X	; p^[`FW|C^[Zbg
;;;;;;;;;
;;;;;;;;DR1SEAR_250	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	DR1TMSH ( ʃT[`[u )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;DR1TMSH		EQU	$
;;;;;;;;		LDA	ENTIM2,X
;;;;;;;;		ORA	PLFLSH
;;;;;;;;		BNE	DR1TMSH_030	; vC[Ă@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	ECRSFG,X
;;;;;;;;		BPL	DR1TMSH_030	; vC[ƏՓˁ@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JMP	PLENCRS
;;;;;;;;;
;;;;;;;;DR1TMSH_030	EQU	$
;;;;;;;;		LDY	<ENWRK2,X
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCC	DR1TMSH_100	; Wv@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENXPSL,Y
;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;		LDA	#00300H
;;;;;;;;		STA	R6		; ړXs[h
;;;;;;;;;
;;;;;;;;		M_CHIP	SEARCH_SPEED
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDA	R1
;;;;;;;;		BPL	DR1TMSH_040	; Xs[hE@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	#0FE00H
;;;;;;;;;
;;;;;;;;DR1TMSH_040	EQU	$
;;;;;;;;		STA	ENXSPD,X	; wXs[hZbg
;;;;;;;;		LDY	<ENWRK2,X	; ʃCfbNX[h
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL,Y
;;;;;;;;		BEQ	DR1TMSH_045	; ڕWwWI[o[@H
;;;;;;;;;					; No !!
;;;;;;;;		EOR	R1
;;;;;;;;		BMI	DR1TMSH_050	; w@|C^[I[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;DR1TMSH_045	EQU	$
;;;;;;;;		LDA	ENXPSL,Y
;;;;;;;;		STA	ENXPSL,X	; ڕWwWZbg
;;;;;;;;;
;;;;;;;;DR1TMSH_050	EQU	$
;;;;;;;;		LDA	ENCBFG,Y
;;;;;;;;		LSR	A
;;;;;;;;		BCS	DR1TMSH_100	; ʍ~@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	ENYPSL,Y
;;;;;;;;		BMI	DR1TMSH_100	; ʂ̈ʒuD_N艺Ă@H
;;;;;;;;;					; No !!
;;;;;;;;		CMP	#00020H
;;;;;;;;		BCC	DR1TMSH_100	; Wv@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCC	DR1TMSH_100	; Wv@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENXPSL,Y
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00038H
;;;;;;;;		CMP	#00070H
;;;;;;;;		BCS	DR1TMSH_100	; Wv@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#0FA00H
;;;;;;;;		STA	ENYSPD,X	; D_NxXs[hZbg
;;;;;;;;		LDA	#00049H
;;;;;;;;		JSL	>SOUND_3_ON	; []
;;;;;;;;;
;;;;;;;;DR1TMSH_100	EQU	$
;;;;;;;;		LDY	<ENWRK2,X
;;;;;;;;		LDA	ENMODE,Y
;;;;;;;;		BNE	DR1TMSH_150	; ʃNA[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	ENXSPD,X	; wXs[hNA[
;;;;;;;;		STZ	<ENWRK0,X	; [hNA[
;;;;;;;;;
;;;;;;;;DR1TMSH_150	EQU	$
;;;;;;;;		LDY	#00009
;;;;;;;;		LDA	ENXSPD,X
;;;;;;;;		BEQ	DR1TMSH_200	; wXs[hNA[@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;		BNE	DR1TMSH_250	; p^[`FW^C}[NA[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00003H
;;;;;;;;		STA	ENTIM1,X	; p^[`FW^C}[Zbg
;;;;;;;;		LDY	ENCHPT,X
;;;;;;;;		DEY
;;;;;;;;		BPL	DR1TMSH_200	; p^[`FWmDI[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDY	#001H
;;;;;;;;;
;;;;;;;;DR1TMSH_200	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENCHPT,X	; p^[`FWmDZbg
;;;;;;;;;
;;;;;;;;DR1TMSH_250	EQU	$
;;;;;;;;		LDY	#002
;;;;;;;;		LDA	ENXSPD,X
;;;;;;;;		BPL	DR1TMSH_300	; E@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	#000
;;;;;;;;;
;;;;;;;;DR1TMSH_300	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENMUKI,X	; Zbg
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	DR1PLSH ( vC[T[`[u )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;DR1PLSH		EQU	$
;;;;;;;;		LDA	ENTIM2,X
;;;;;;;;		ORA	PLFLSH
;;;;;;;;		BNE	DR1PLSH_050	; vC[Ă@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	ECRSFG,X
;;;;;;;;		BPL	DR1PLSH_050	; vC[ƏՓˁ@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JMP	PLENCRS
;;;;;;;;;
;;;;;;;;DR1PLSH_050	EQU	$
;;;;;;;;;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;;;;;;;;;		LSR	A
;;;;;;;;;;;;;;;;		BCC	DR1PLSH_100	; Wv@H
;;;;;;;;;;;;;;;;;					; No !!
;;;;;;;;;;;;;;;;		LDA	PLXPSL
;;;;;;;;;;;;;;;;		SEC
;;;;;;;;;;;;;;;;		SBC	ENXPSL,X
;;;;;;;;;;;;;;;;		CLC
;;;;;;;;;;;;;;;;		ADC	#00038H
;;;;;;;;;;;;;;;;		CMP	#00070H
;;;;;;;;;;;;;;;;		BCS	DR1PLSH_100	; Wv@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		LDA	#0FC00H
;;;;;;;;;;;;;;;;		STA	ENYSPD,X	; D_NxXs[hZbg
;;;;;;;;;;;;;;;;		LDA	#00017H
;;;;;;;;;;;;;;;;		STA	ENCHPT,X	; p^[`FWmDZbg
;;;;;;;;;;;;;;;;		LDA	#EJMP
;;;;;;;;;;;;;;;;		STA	<ENWRK0,X
;;;;;;;;;;;;;;;;		LDA	#00001
;;;;;;;;;;;;;;;;		STA	SOUND1	; []
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		RTL
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;DR1PLSH_100	EQU	$
;;;;;;;;		LDA	ENXPSL+054H
;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;		LDA	#00200H
;;;;;;;;		STA	R6		; ړXs[hZbg
;;;;;;;;;
;;;;;;;;		M_CHIP	SEARCH_SPEED
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDA	R1
;;;;;;;;		STA	ENXSPD,X	; wXs[hZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL+054H
;;;;;;;;		BEQ	DR1PLSH_140	; ڕWwWI[o[@H
;;;;;;;;;					; No !!
;;;;;;;;		EOR	R1
;;;;;;;;		BMI	DR1PLSH_150	; w@|C^[I[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;DR1PLSH_140	EQU	$
;;;;;;;;		LDA	ENXPSL+054H
;;;;;;;;		STA	ENXPSL,X	; ڕWwWZbg
;;;;;;;;;
;;;;;;;;DR1PLSH_150	EQU	$
;;;;;;;;		LDY	#009H
;;;;;;;;		LDA	ENXSPD,X
;;;;;;;;		BEQ	DR1PLSH_200	; wXs[hNA[@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;		BNE	DR1PLSH_250	; p^[`FW^C}[NA[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00003H
;;;;;;;;		STA	ENTIM1,X	; p^[`FW^C}[Zbg
;;;;;;;;		LDY	ENCHPT,X
;;;;;;;;		DEY
;;;;;;;;		BPL	DR1PLSH_200	; p^[`FWmDI[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDY	#001H
;;;;;;;;;
;;;;;;;;DR1PLSH_200	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENCHPT,X	; p^[`FWmDZbg
;;;;;;;;;
;;;;;;;;DR1PLSH_250	EQU	$
;;;;;;;;		LDY	#002
;;;;;;;;		LDA	ENXSPD,X
;;;;;;;;		BPL	DR1PLSH_300	; E@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	#000
;;;;;;;;;
;;;;;;;;DR1PLSH_300	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENMUKI,X	; Zbg
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	DR1JUMP ( D_NWv[u )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;DR1JUMP		EQU	$
;;;;;;;;		LDA	ENTIM2,X
;;;;;;;;		ORA	PLFLSH
;;;;;;;;		BNE	DR1JUMP_050	; vC[Ă@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENWRK6,X
;;;;;;;;		BNE	DR1JUMP_050	; vC[ɓ܂ꂽ@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	ECRSFG,X
;;;;;;;;		BPL	DR1JUMP_050	; vC[ƏՓˁ@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JSL	>PLENCRS
;;;;;;;;;
;;;;;;;;DR1JUMP_050	EQU	$
;;;;;;;;		LDY	#018H
;;;;;;;;		LDA	ENYSPD,X
;;;;;;;;		BPL	DR1JUMP_100	; ㏸@H
;;;;;;;;;					; No !!
;;;;;;;;		DEY
;;;;;;;;;
;;;;;;;;DR1JUMP_100	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENCHPT,X	; D_NWv|[YmDZbg
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCC	DR1JUMP_250	; n@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDY	<ENWRK0,X
;;;;;;;;		INY
;;;;;;;;		LDA	ENWRK6,X
;;;;;;;;		BNE	DR1JUMP_150	; vC[ɓ܂ꂽ@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	#000
;;;;;;;;		LDA	#00009H
;;;;;;;;		STA	ENCHPT,X	; D_Nn|[YmDZbg
;;;;;;;;		STZ	<ENWRK4,X	; D_Nn|[Y|C^[NA[
;;;;;;;;		BRA	DR1JUMP_200
;;;;;;;;;
;;;;;;;;DR1JUMP_150	EQU	$
;;;;;;;;		LDA	#00019H
;;;;;;;;		STA	ENCHPT,X	; D_Nn|[YmDZbg
;;;;;;;;		LDA	#(YARAPTD-CYAKPTD)/2
;;;;;;;;		STA	<ENWRK4,X	; D_Nn|[Y|C^[NA[
;;;;;;;;;
;;;;;;;;DR1JUMP_200	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	<ENWRK0,X	; [hZbg
;;;;;;;;		STZ	ENXSPD,X	; D_NwXs[hNA[
;;;;;;;;		LDA	#00004H
;;;;;;;;		STA	ENTIM1,X	; D_Nn|[Y^C}[Zbg
;;;;;;;;;
;;;;;;;;DR1JUMP_250	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	DR1CYAK ( n|[Y[u )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;DR1CYAK		EQU	$
;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;		BNE	DR1CYAK_050	; D_Nn|[Y`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		INC	<ENWRK4,X
;;;;;;;;		LDA	<ENWRK4,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		LDA	!CYAKPTD,Y
;;;;;;;;		STA	ENCHPT,X	; D_Nn|[YmDZbg
;;;;;;;;		LDA	!CYAKTMD,Y
;;;;;;;;		STA	ENTIM1,X	; D_Nn|[Y^C}[Zbg
;;;;;;;;		BNE	DR1CYAK_050	; D_Nn|[YI@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	<ENWRK0,X
;;;;;;;;		STZ	ENWRK6,X
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	ENTIM2,X
;;;;;;;;;
;;;;;;;;DR1CYAK_050	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;========================================================================
		MEM8
		IDX8
;
		DPAGE	WORK0
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		MINIINT1_5	( ~jQ[eCjVZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MINIINT1_5	EQU	$
;;;;;;;;;-------------- XN[l NA -----------------------------
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;		STZ	<SCCH1
;;;;;;;;		STZ	<SCCV1
;;;;;;;;		STZ	<SCCH2
;;;;;;;;		STZ	<SCCV2
;;;;;;;;		STZ	<SCCH3
;;;;;;;;		STZ	<SCCV3
;;;;;;;;		M8			; memory 8bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	#069H
;;;;;;;;		STA	!BG1SCF
;;;;;;;;		STA	2107H
;;;;;;;;		LDA	#039H
;;;;;;;;		STA	!BG2SCF
;;;;;;;;		STA	2108H
;;;;;;;;		LDA	#029H
;;;;;;;;		STA	BGMODE
;;;;;;;;		STA	2105H
;;;;;;;;		STZ	HD420C
;;;;;;;;		STZ	SUBADF
;;;;;;;;;
;;;;;;;;;-------------- Q[ CjV -----------------------------------
;;;;;;;;		MI16			; memory,index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	#00040H
;;;;;;;;		STA	PLYPSL		; player Y initial set !!
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	PLXPSL		; player X initial set !!
;;;;;;;;		STZ	UNBUFAD
;;;;;;;;		STA	TIMER
;;;;;;;;		LDA	#P_HERI
;;;;;;;;		STA	PLTYPE		; wRv^[[hZbg
;;;;;;;;		JSL	>HERI_INITL	; wRv^[[hCjV
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	#0000EH
;;;;;;;;		STA	SCRLNO
;;;;;;;;		STZ	NUKINO
;;;;;;;;		STZ	BG3TYP
;;;;;;;;		STZ	BG1TYP
;;;;;;;;		STZ	ATSCRL_SCCV1
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	ATSCRL_V
;;;;;;;;		JSL	>PSCRL_INIT
;;;;;;;;;
;;;;;;;;		MI16			; memory,index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		STZ	PLSCRL_MINX
;;;;;;;;		LDA	#00100H
;;;;;;;;		STA	PLSCRL_MAXX
;;;;;;;;;
;;;;;;;;		LDA	#00099H
;;;;;;;;		STA	MNTIME		; ~jQ[^C}[Zbg
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	MNTMCT		; ~jQ[^C}[JE^[Zbg
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	ENTMCT		; ~TCˑJEgZbg
;;;;;;;;;
;;;;;;;;;;;;;;;;		LDA	#0FFFFH
;;;;;;;;;;;;;;;;		STA	OBJCHR_BNK
;;;;;;;;;;;;;;;;		STA	OBJCHR_BNK+2
;;;;;;;;;;;;;;;;		STA	OBJCHR_BNK+4
;;;;;;;;;;;;;;;;;
;;;;;;;;		LDX	#001FEH
;;;;;;;;		LDA	#00000
;;;;;;;;;
;;;;;;;;MINIINT1_5_050	EQU	$
;;;;;;;;		STA	>BGUNIT,X
;;;;;;;;		STA	>BGUNIT+200H,X
;;;;;;;;		DEX
;;;;;;;;		DEX
;;;;;;;;		BPL	MINIINT1_5_050	; BG unit buffer clear end ?
;;;;;;;;;					; Yes !!
;;;;;;;;		LDX	#0000FH*2
;;;;;;;;		LDA	#00100H
;;;;;;;;;
;;;;;;;;MINIINT1_5_100	EQU	$
;;;;;;;;		STA	>BGUNIT,X
;;;;;;;;		STA	>BGUNIT+200H,X
;;;;;;;;		STA	>BGUNIT+180H,X
;;;;;;;;		STA	>BGUNIT+380H,X
;;;;;;;;		DEX
;;;;;;;;		DEX
;;;;;;;;		BPL	MINIINT1_5_100
;;;;;;;;;
;;;;;;;;		LDA	#00100H
;;;;;;;;		STA	UNBUFAD
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	#M_BBY
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#00044H
;;;;;;;;		STA	ENWRK2,Y	; ẽCfbNXmDZbg
;;;;;;;;;
;;;;;;;;		LDA	#M_DR3
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;;
;;;;;;;;		LDA	#M_MIS
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#00080H
;;;;;;;;		STA	ENXPSL,Y	; ~TCCjVwWZbg
;;;;;;;;		LDA	#M_MIS
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#000E0H
;;;;;;;;		STA	ENXPSL,Y	; ~TCCjVwWZbg
;;;;;;;;		LDA	#M_MIS
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#00140H
;;;;;;;;		STA	ENXPSL,Y	; ~TCCjVwWZbg
;;;;;;;;		LDA	#M_MIS
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#001A0H
;;;;;;;;		STA	ENXPSL,Y	; ~TCCjVwWZbg
;;;;;;;;;;;;;;;;		LDA	#M_MIS
;;;;;;;;;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;;;;;;;;;		LDA	#00180H
;;;;;;;;;;;;;;;;		STA	ENXPSL,Y	; ~TCCjVwWZbg
;;;;;;;;;;;;;;;;		LDA	#M_MIS
;;;;;;;;;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;;;;;;;;;		LDA	#001C0H
;;;;;;;;;;;;;;;;		STA	ENXPSL,Y	; ~TCCjVwWZbg
;;;;;;;;;
;;;;;;;;		LDA	#M_BAK
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#00070H
;;;;;;;;		STA	ENYPSL,Y	; eCjVxWZbg
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	ENXPSL,Y	; eCjVwWZbg
;;;;;;;;;
;;;;;;;;		JSL	>ENEMY_IN
;;;;;;;;;
;;;;;;;;		M8			; memory 8 bit mode !!
;;;;;;;;;
		RTS
;
;
;****************************************************************
;*								*
;*		~j Q[					*
;*								*
;****************************************************************
MINIMOV1_5	EQU	$
;;;;;;;;		JSL	>OAMDXCLR	; OAM clear sub !!
;;;;;;;;		JSL	>PLSCRL		; player scroll set sub !!
;;;;;;;;		LDA	#030H
;;;;;;;;		STA	PLPRIO		; player priority set !!
;;;;;;;;		JSL	>ENCSET_DM	; enemy char set sub !!
;;;;;;;;		JSL	>PLCSET		; player char set sub !!
;;;;;;;;;
;;;;;;;;		STZ	SPECIAL_P
;;;;;;;;;
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	ENTMCT
;;;;;;;;		BEQ	MINIMOV1_5_050	; ~TCˑSĉ󂵂@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	MNTIME
;;;;;;;;		BNE	MINIMOV1_5_150	; ~jQ[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;MINIMOV1_5_050	EQU	$
;;;;;;;;		JSL	>ENEMY_IN	; enemy move sub !!
;;;;;;;;;
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;		DEC	ENDTIM
;;;;;;;;		BNE	MINIMOV1_5_200	; sI@H
;;;;;;;;;					; Yes !!
;;;;;;;;;;;;K;;;;		LDY	#MINIT
;;;;;;;;;;;;K;;;;		INC	MINIMD
;;;;;;;;;;;;K;;;;		LDA	MINIMD
;;;;;;;;;;;;K;;;;		CMP	#00003
;;;;;;;;;;;;K;;;;		BNE	MINIMOV1_5_100	; ~jQ[@RI@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JSL	>BACK_GAME
;;;;;;;;		BRA	MINIMOV1_5_200
;;;;;;;;;;;;K;;;;		LDY	#HMPIN
;;;;;;;;;
;;;;;;;;MINIMOV1_5_100	EQU	$
;;;;;;;;;;;;K;;;;		STY	MODENO		; C[hZbg
;;;;;;;;;;;;K;;;;		BRA	MINIMOV1_5_200
;;;;;;;;;
;;;;;;;;MINIMOV1_5_150	EQU	$
;;;;;;;;		M8			; memory 8 bit mode !!
;;;;;;;;;
;;;;;;;;		JSL	>PLAYER		; player move sub !!
;;;;;;;;		LDA	!MSGMOD		; bZ[W EBhD nm ?
;;;;;;;;		BNE	MINIMOV1_5_200	;	YES -> MINIMOV1_5_200
;;;;;;;;		JSL	>ENEMY_IN	; enemy move sub !!
;;;;;;;;;
;;;;;;;;		JSR	METERS2		; [^[Zbg[`
;;;;;;;;;
;;;;;;;;MINIMOV1_5_200	EQU	$
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;;;;;;;;;
;;;;;;;;		M8			; memory 8 bit mode !!
;;;;;;;;;
		RTS
;
;
;------------------------------------------------------------------------
;;;;;;;;		MEM8
;;;;;;;;		IDX8
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	METERS2 ( [^[Zbg[` )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;METERS2		EQU	$
;;;;;;;;		MI16			; memory,index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDY	#00000
;;;;;;;;		LDA	ENTMCT
;;;;;;;;		BEQ	METERS2_050	; ~TCˑSĉ󂵂@H
;;;;;;;;;					; No !!
;;;;;;;;		DEC	MNTMCT
;;;;;;;;		BNE	METERS2_150	; ^C}[JEg_E@H
;;;;;;;;;					; Yes !!
;;;;;;;;		SEC
;;;;;;;;		SED
;;;;;;;;		LDA	MNTIME
;;;;;;;;		SBC	#00001
;;;;;;;;		STA	MNTIME		; ~jQ[^C}[Zbg
;;;;;;;;		CLD
;;;;;;;;		BNE	METERS2_100	; ~jQ[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;		INY
;;;;;;;;		INY
;;;;;;;;;
;;;;;;;;METERS2_050	EQU	$
;;;;;;;;		LDA	#00200H
;;;;;;;;		STA	ENDTIM
;;;;;;;;		TYA
;;;;;;;;		LSR	A
;;;;;;;;		STA	WINFLG
;;;;;;;;		LDA	!DATADRS,Y
;;;;;;;;		STA	VRFLG2
;;;;;;;;		LDA	!SOUNDNO,Y
;;;;;;;;		STA	<SOUND_0	; []
;;;;;;;;;
;;;;;;;;METERS2_100	EQU	$
;;;;;;;;		LDA	#00063
;;;;;;;;		STA	MNTMCT		; ~jQ[^C}[JEgZbg
;;;;;;;;;
;;;;;;;;METERS2_150	EQU	$
;;;;;;;;		PHB
;;;;;;;;		LDA	#BANK VRAMDX
;;;;;;;;		PHA
;;;;;;;;		PLB
;;;;;;;;;
;;;;;;;;		LDX	VRAMDX
;;;;;;;;		LDA	#03485H
;;;;;;;;		STA	0,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00020H
;;;;;;;;		STA	16,X
;;;;;;;;		LDA	#03499H
;;;;;;;;		STA	32,X
;;;;;;;;		ADC	#00020H
;;;;;;;;		STA	48,X
;;;;;;;;;
;;;;;;;;		LDA	#00180H
;;;;;;;;		STA	2,X
;;;;;;;;		STA	18,X
;;;;;;;;		STA	34,X
;;;;;;;;		STA	50,X
;;;;;;;;;
;;;;;;;;		LDA	#00018H
;;;;;;;;		STA	4,X
;;;;;;;;		STA	20,X
;;;;;;;;		STA	36,X
;;;;;;;;		STA	52,X
;;;;;;;;;
;;;;;;;;		TXA
;;;;;;;;		ADC	#00012
;;;;;;;;		STA	5,X
;;;;;;;;		ADC	#00016
;;;;;;;;		STA	21,X
;;;;;;;;		ADC	#00016
;;;;;;;;		STA	37,X
;;;;;;;;		ADC	#00016
;;;;;;;;		STA	53,X
;;;;;;;;;
;;;;;;;;		LDA	#BANK VRAMDX
;;;;;;;;		STA	7,X
;;;;;;;;		STA	23,X
;;;;;;;;		STA	39,X
;;;;;;;;		STA	55,X
;;;;;;;;;
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	8,X
;;;;;;;;		STA	24,X
;;;;;;;;		STA	40,X
;;;;;;;;		STA	56,X
;;;;;;;;;
;;;;;;;;		TXA
;;;;;;;;		ADC	#00016
;;;;;;;;		STA	10,X
;;;;;;;;		ADC	#00016
;;;;;;;;		STA	26,X
;;;;;;;;		ADC	#00016
;;;;;;;;		STA	42,X
;;;;;;;;		ADC	#00016
;;;;;;;;		STA	58,X
;;;;;;;;		STA	VRAMDX
;;;;;;;;;
;;;;;;;;		PLB
;;;;;;;;		PLB
;;;;;;;;;
;;;;;;;;		TXA
;;;;;;;;		SEC
;;;;;;;;		SBC	#VRAMDX+2
;;;;;;;;		TAX
;;;;;;;;;
;;;;;;;;		LDA	MNTIME
;;;;;;;;		TAY
;;;;;;;;		AND	#000F0H
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		ORA	#02900H
;;;;;;;;		STA	>VRAMDX+14,X
;;;;;;;;		ORA	#00010H
;;;;;;;;		STA	>VRAMDX+30,X
;;;;;;;;;
;;;;;;;;		TYA
;;;;;;;;		AND	#0000FH
;;;;;;;;		ORA	#02900H
;;;;;;;;		STA	>VRAMDX+16,X
;;;;;;;;		ORA	#00010H
;;;;;;;;		STA	>VRAMDX+32,X
;;;;;;;;;
;;;;;;;;		LDA	ENTMCT
;;;;;;;;		TAY
;;;;;;;;		AND	#000F0H
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		ORA	#02900H
;;;;;;;;		STA	>VRAMDX+46,X
;;;;;;;;		ORA	#00010H
;;;;;;;;		STA	>VRAMDX+62,X
;;;;;;;;;
;;;;;;;;		TYA
;;;;;;;;		AND	#0000FH
;;;;;;;;		ORA	#02900H
;;;;;;;;		STA	>VRAMDX+48,X
;;;;;;;;		ORA	#00010H
;;;;;;;;		STA	>VRAMDX+64,X
;;;;;;;;;
;;;;;;;;		MI8			; memory,index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		RTS
;;;;;;;;;
;;;;;;;;;
;------------------------------------------------------------------------
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_BAKIN		( eCjVZbg )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_BAKIN		EQU	$
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	ENCLOR,X
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_BAKMV		( e[u )				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_BAKMV		EQU	$
;;;;;;;;;;;;;;;;		JSL	>ENMDCK
;;;;;;;;;;;;;;;;;
;;;;;;;;		LDA	ENTMCT
;;;;;;;;		BEQ	M_BAKMV_050	; Sĉ󂵂@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	MNTIME
;;;;;;;;		BNE	M_BAKMV_100	; Q[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;M_BAKMV_050	EQU	$
		RTL
;;;;;;;;;
;;;;;;;;M_BAKMV_100	EQU	$
;;;;;;;;		LDA	<ENWRK0,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		LDA	M_BAKMV_ADR,Y
;;;;;;;;		STA	<EWORK0
;;;;;;;;		JMP	(EWORK0)
;;;;;;;;;
;;;;;;;;;
;;;;;;;;M_BAKMV_ADR	EQU	$
;;;;;;;;		WORD	BABYMOV		; Ԃ񂪉^ł鏈
;;;;;;;;		WORD	BAKUMOV		; e
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	BABYMOV ( Ԃ񂪉^ł鏈 )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;BABYMOV		EQU	$
;;;;;;;;		LDA	ENMODE,X
;;;;;;;;;;;;		    CMP	    #EMGNT
;;;;;;;;		BNE	BABYMOV_050	; }Olbg@H
;;;;;;;;;					; Yes !!
;;;;;;;;		INC	<ENWRK0,X
;;;;;;;;		LDA	ENMOD1,X
;;;;;;;;		EOR	#00001
;;;;;;;;		STA	ENMOD1,X
;;;;;;;;		LDA	#00020H
;;;;;;;;		STA	ENGPOW,X
;;;;;;;;		LDA	#00200H
;;;;;;;;		STA	ENGMAX,X
;;;;;;;;		STZ	<ENWRK2,X
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;BABYMOV_050	EQU	$
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		BMI	BABYMOV_100	; ʊO@H
;;;;;;;;;					; No !!
;;;;;;;;		CMP	#00030H
;;;;;;;;		BCS	BABYMOV_150	; ^яI@H
;;;;;;;;;					; Yes !!
;;;;;;;;BABYMOV_100	EQU	$
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	ENMOVX+05CH
;;;;;;;;		STA	ENXPSL,X	; [uWZbg
;;;;;;;;		BRA	BABYMOV_200
;;;;;;;;;
;;;;;;;;BABYMOV_150	EQU	$
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	ENXPSL,X	; wWZbg
;;;;;;;;;
;;;;;;;;BABYMOV_200	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	BAKUMOV ( e )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;MISXPSD		EQU	$
;;;;;;;;		WORD	000B0H,00110H,00170H,001D0H
;;;;;;;;;
;;;;;;;;;
;;;;;;;;BAKUMOV		EQU	$
;;;;;;;;		LDA	ENMODE,X
;;;;;;;;;;;;		    CMP	    #EMGNT
;;;;;;;;		BEQ	BABYMOV_200	; }Olbg@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	<ENWRK2,X
;;;;;;;;		BNE	BAKUMOV_020	; wXs[hZbg@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	PLXSPD
;;;;;;;;		AND	#08000H
;;;;;;;;		STA	<EWORK0
;;;;;;;;		LDA	PLXSPD
;;;;;;;;		LSR	A
;;;;;;;;		ORA	<EWORK0
;;;;;;;;;;;;;;;;		LSR	A
;;;;;;;;;;;;;;;;		ORA	<EWORK0
;;;;;;;;		STA	ENXSPD,X	; CjVwXs[hZbg
;;;;;;;;		INC	<ENWRK2,X
;;;;;;;;;
;;;;;;;;BAKUMOV_020	EQU	$
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCC	BABYMOV_200	; nʂɓ@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDY	#(BAKUMOV-MISXPSD)-2
;;;;;;;;;
;;;;;;;;BAKUMOV_050	EQU	$
;;;;;;;;		LDA	!MISXPSD,Y
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#0000CH
;;;;;;;;		CMP	#00019H
;;;;;;;;		BCC	BAKUMOV_100	; ~TCˌ@H
;;;;;;;;;					; Yes !!
;;;;;;;;		DEY
;;;;;;;;		DEY
;;;;;;;;		BPL	BAKUMOV_050	; ~TCˌ@H
;;;;;;;;;					; No !!
;;;;;;;;		BRA	BAKUMOV_150
;;;;;;;;;
;;;;;;;;BAKUMOV_100	EQU	$
;;;;;;;;		LDA	KICIOT,Y
;;;;;;;;		BNE	BAKUMOV_150	; nĂ@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	KICIOT,Y
;;;;;;;;;
;;;;;;;;		SED
;;;;;;;;		SEC
;;;;;;;;		LDA	ENTMCT
;;;;;;;;		SBC	#00001
;;;;;;;;		STA	ENTMCT		; nJEg_E
;;;;;;;;		CLD
;;;;;;;;;
;;;;;;;;		JSR	BGCHENG		; ~TCˌ
;;;;;;;;;
;;;;;;;;BAKUMOV_150	EQU	$
;;;;;;;;		TXA
;;;;;;;;		AND	#000FFH
;;;;;;;;		STA	R1
;;;;;;;;		LDA	#M_DR3
;;;;;;;;		STA	R14
;;;;;;;;		M_CHIP	TARGET_SEARCH
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDY	R1
;;;;;;;;		BMI	BAKUMOV_200	; G@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	ENXPSL,Y
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		CMP	#00021H
;;;;;;;;		BCS	BAKUMOV_200	; D_N@wW͈͓@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	ENYPSL,Y
;;;;;;;;		SEC
;;;;;;;;		SBC	ENYPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		CMP	#00021H
;;;;;;;;		BCS	BAKUMOV_200	; D_N@xW͈͓@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#0FC00H
;;;;;;;;		STA	ENYSPD,Y	; D_NWvXs[hZbg
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	ENWRK0,Y
;;;;;;;;		DEC	A
;;;;;;;;		STA	ENXSPD,Y
;;;;;;;;		LDA	#(YARAPTD-CYAKPTD)/2-1
;;;;;;;;		STA	ENWRK4,Y
;;;;;;;;;
;;;;;;;;BAKUMOV_200	EQU	$
;;;;;;;;		LDA	#SMK05		; mD
;;;;;;;;		JSL	>EXINSR
;;;;;;;;		LDA	ECENTX,X
;;;;;;;;		STA	EXXPSL,Y	; wWZbg
;;;;;;;;		LDA	ECENTY,X
;;;;;;;;		STA	EXYPSL,Y	; xWZbg
;;;;;;;;		LDA	#0000DH
;;;;;;;;		STA	EXCHPT,Y	; p^[mDZbg
;;;;;;;;		LDA	#00003
;;;;;;;;		STA	EXTIM0,Y	; p^[^C}[Zbg
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	EXCLOR,Y	; vCIeBZbg
;;;;;;;;;
;;;;;;;;		PHY
;;;;;;;;		LDA	#00047H
;;;;;;;;		JSL	>SOUND_3_ON	; []
;;;;;;;;		PLY
;;;;;;;;		JMP	>ENCLEAR
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	BGCHENG ( ~TCˌ )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;HASYAD0		EQU	$
;;;;;;;;;;;;;;;;		WORD	03524H,03525H
;;;;;;;;		WORD	000FFH,000FFH,02D4AH,0354BH
;;;;;;;;;
;;;;;;;;HASYAD1		EQU	$
;;;;;;;;;;;;;;;;		WORD	03526H,03527H
;;;;;;;;		WORD	03558H,03559H,02D5AH,0355BH
;;;;;;;;;
;;;;;;;;HASYAD2		EQU	$
;;;;;;;;		WORD	03568H,03569H,0356AH,0356BH
;;;;;;;;;
;;;;;;;;HASYAD3		EQU	$
;;;;;;;;		WORD	03578H,03579H,0357AH,0357BH
;;;;;;;;;
;;;;;;;;;
;;;;;;;;BGCHENG		EQU	$
;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDA	!MISXPSD,Y
;;;;;;;;		SEC
;;;;;;;;		SBC	#00008H
;;;;;;;;		TAY
;;;;;;;;		AND	#000F8H
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		STA	<EWORK2
;;;;;;;;		TYA
;;;;;;;;		AND	#00F00H
;;;;;;;;		ASL	A
;;;;;;;;		ASL	A
;;;;;;;;		ORA	<EWORK2
;;;;;;;;		CLC
;;;;;;;;		ADC	#06AA0H
;;;;;;;;;
;;;;;;;;		PHB
;;;;;;;;		LDY	#BANK VRAMDX
;;;;;;;;		PHY
;;;;;;;;		PLB
;;;;;;;;;
;;;;;;;;		LDY	VRAMDX
;;;;;;;;		STA	0,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	#00020H
;;;;;;;;		STA	12,Y
;;;;;;;;		ADC	#00020H
;;;;;;;;		STA	24,Y
;;;;;;;;		ADC	#00020H
;;;;;;;;		STA	36,Y
;;;;;;;;;
;;;;;;;;		LDA	#00180H
;;;;;;;;		STA	2,Y
;;;;;;;;		STA	14,Y
;;;;;;;;		STA	26,Y
;;;;;;;;		STA	38,Y
;;;;;;;;;
;;;;;;;;		LDA	#00018H
;;;;;;;;		STA	4,Y
;;;;;;;;		STA	16,Y
;;;;;;;;		STA	28,Y
;;;;;;;;		STA	40,Y
;;;;;;;;;
;;;;;;;;		LDA	#HASYAD0
;;;;;;;;		STA	5,Y
;;;;;;;;		LDA	#HASYAD1
;;;;;;;;		STA	17,Y
;;;;;;;;		LDA	#HASYAD2
;;;;;;;;		STA	29,Y
;;;;;;;;		LDA	#HASYAD3
;;;;;;;;		STA	41,Y
;;;;;;;;;
;;;;;;;;		LDA	#BANK HASYAD0
;;;;;;;;		STA	7,Y
;;;;;;;;		STA	19,Y
;;;;;;;;		STA	31,Y
;;;;;;;;		STA	43,Y
;;;;;;;;;
;;;;;;;;		LDA	#00008
;;;;;;;;		STA	8,Y
;;;;;;;;		STA	20,Y
;;;;;;;;		STA	32,Y
;;;;;;;;		STA	44,Y
;;;;;;;;;
;;;;;;;;		TYA
;;;;;;;;		CLC
;;;;;;;;		ADC	#00012
;;;;;;;;		STA	10,Y
;;;;;;;;		ADC	#00012
;;;;;;;;		STA	22,Y
;;;;;;;;		ADC	#00012
;;;;;;;;		STA	34,Y
;;;;;;;;		ADC	#00012
;;;;;;;;		STA	46,Y
;;;;;;;;		STA	VRAMDX
;;;;;;;;;
;;;;;;;;		PLB
;;;;;;;;		PLB
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		RTS
;;;;;;;;;
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_MISIN		( ~TCCjVZbg )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_MISIN		EQU	$
;;;;;;;;		LDY	2137H
;;;;;;;;		LDY	213FH
;;;;;;;;		LDA	213CH
;;;;;;;;		CLC
;;;;;;;;		ADC	<RANDM0
;;;;;;;;		STA	<RANDM0
;;;;;;;;		AND	#0000FH
;;;;;;;;		ORA	#000B0H
;;;;;;;;		STA	ENYPSL,X	; ~TCCjVxWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	<ENWRK2,X	; wWޔ
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_MISMV		( ~TC[u )			x
;x									x
;x		use	ENWRK0	[hCfbNX			x
;x			ENWRK2	CjVwW			x
;x			ENWRK4	ˑtO			x
;x									x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;MODEDAT		EQU	$
;;;;;;;;		WORD	00000H,MKIJ,MKIJ,0FFFFH,0FFFFH,00000H,MKIJ
;;;;;;;;;
;;;;;;;;;
M_MISMV		EQU	$
;;;;;;;;		LDA	ENTMCT
;;;;;;;;		BEQ	M_MISMV_050	; Sĉ󂵂@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	MNTIME
;;;;;;;;		BNE	M_MISMV_100	; Q[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;M_MISMV_050	EQU	$
;;;;;;;;		LDA	ENWRK0,X
;;;;;;;;		CMP	#MMOK
;;;;;;;;		BEQ	M_MISMV_100	; [u@H
;;;;;;;;;					; No !!
		RTL
;;;;;;;;;
;;;;;;;;M_MISMV_100	EQU	$
;;;;;;;;;;;;;;;;		LDY	#005*2
;;;;;;;;;;;;;;;;		LDA	<ENWRK2,X
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_MISMV_050	EQU	$
;;;;;;;;;;;;;;;;		CMP	!MISXPSD,Y
;;;;;;;;;;;;;;;;		BEQ	M_MISMV_100	; wW@H
;;;;;;;;;;;;;;;;;					; No !!
;;;;;;;;;;;;;;;;		DEY
;;;;;;;;;;;;;;;;		DEY
;;;;;;;;;;;;;;;;		BNE	M_MISMV_050
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_MISMV_100	EQU	$
;;;;;;;;;;;;;;;;		LDA	KICIOT,Y
;;;;;;;;;;;;;;;;		BEQ	M_MISMV_150	; nĂ@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		LDA	#00001
;;;;;;;;;;;;;;;;		STA	<ENWRK4,X	; tOhnmh
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_MISMV_150	EQU	$
;;;;;;;;		LDA	<ENWRK0,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;;;;;;;;;		LDA	<ENWRK4,X
;;;;;;;;;;;;;;;;		BEQ	M_MISMV_250	; tOhnmh@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		LDA	!MODEDAT,Y
;;;;;;;;;;;;;;;;		BNE	M_MISMV_200	; G@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		JMP	>ENCLEAR
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_MISMV_200	EQU	$
;;;;;;;;;;;;;;;;		BMI	M_MISMV_250
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;		LDY	#MKIJ
;;;;;;;;;;;;;;;;		TAY
;;;;;;;;;;;;;;;;		LSR	A
;;;;;;;;;;;;;;;;		STA	<ENWRK0,X	; vC[T[`[hZbg
;;;;;;;;;;;;;;;;		LDA	#000B8H
;;;;;;;;;;;;;;;;		STA	ENYPSL,X
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;M_MISMV_250	EQU	$
;;;;;;;;		LDA	!M_MISMV_ADR,Y
;;;;;;;;		STA	<EWORK0
;;;;;;;;		JMP	(EWORK0)
;;;;;;;;;
;;;;;;;;;
;;;;;;;;M_MISMV_ADR	EQU	$
;;;;;;;;		WORD	MSETMOV		; ~TCˌ܂ňړ
;;;;;;;;MISAC		WORD	PLSHMOV		; vC[T[`
;;;;;;;;MISLK		WORD	LOCKMOV		; ~TCbNԏ
;;;;;;;;MISYA		WORD	HASYMOV		; ~TCˏ
;;;;;;;;MIMOK		WORD	MOKUMOV		; ڕW菈
;;;;;;;;		WORD	MISAWAI		; ~TCZbg^C}[
;;;;;;;;MISKA		WORD	KAIJMOV		; vC[T[`
;;;;;;;;;
;;;;;;;;;
;;;;;;;;MSAC		EQU	MISAC-M_MISMV_ADR
;;;;;;;;MLOK		EQU	MISLK-M_MISMV_ADR
;;;;;;;;MSYA		EQU	MISYA-M_MISMV_ADR
;;;;;;;;MMOK		EQU	(MIMOK-M_MISMV_ADR)/2
;;;;;;;;MKIJ		EQU	MISKA-M_MISMV_ADR
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	MSETMOV ( ~TCˌ܂ňړ )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;MSETMOV		EQU	$
;;;;;;;;		LDA	ENTIM0,X
;;;;;;;;		BNE	MSETMOV_040	; ~TCړ@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		CMP	#000B0H
;;;;;;;;		BEQ	MSETMOV_050	; ~TCˌ܂ňړ@H
;;;;;;;;;					; No !!
;;;;;;;;		DEC	ENYPSL,X
;;;;;;;;		LDA	#00004H
;;;;;;;;		STA	ENTIM0,X	; ~TCړ^C}[Zbg
;;;;;;;;;
;;;;;;;;MSETMOV_040	EQU	$
;;;;;;;;		JMP	MSETMOV_150
;;;;;;;;;
;;;;;;;;MSETMOV_050	EQU	$
;;;;;;;;		LDA	LOCKCT
;;;;;;;;		CMP	#00004H
;;;;;;;;		BEQ	MSETMOV_040
;;;;;;;;;
;;;;;;;;		INC	LOCKCT
;;;;;;;;		INC	<ENWRK0,X
;;;;;;;;;
;;;;;;;;MSETMOV_060	EQU	$
;;;;;;;;;;;;;;;;		LDA	#00100H
;;;;;;;;;;;;;;;;		STA	ENTIM1,X	; ^[QbgT[`^C}[Zbg
;;;;;;;;		STZ	ENWRK6,X
;;;;;;;;		STZ	ENWRK8,X
;;;;;;;;		STZ	ENWRKA,X
;;;;;;;;		STZ	ENWRKC,X
;;;;;;;;;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		LDA	<RANDM0
;;;;;;;;		AND	#0007FH
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		STA	ENWRK7,X	; ^[QbgJ[\wWZbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;;;;;;;;;		SEC
;;;;;;;;;;;;;;;;		SBC	#00008H
;;;;;;;;		STA	ENWRKB,X	; ^[QbgJ[\xWZbg
;;;;;;;;;
;;;;;;;;MSETMOV_100	EQU	$
;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDY	ENOAML,X
;;;;;;;;;;;;;;;;		LDA	ENWRK7,X
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	#00004H
;;;;;;;;		SEC
;;;;;;;;		SBC	ESCCH1
;;;;;;;;		STA	SOAM_DX+008H,Y
;;;;;;;;		STA	SOAM_DX+018H,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		STA	SOAM_DX+010H,Y
;;;;;;;;		STA	SOAM_DX+020H,Y
;;;;;;;;;
;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00008H
;;;;;;;;		STA	SOAM_DX+00AH,Y
;;;;;;;;		STA	SOAM_DX+012H,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		STA	SOAM_DX+01AH,Y
;;;;;;;;		STA	SOAM_DX+022H,Y
;;;;;;;;;
;;;;;;;;		LDA	#0309FH
;;;;;;;;		STA	SOAM_DX+00CH,Y
;;;;;;;;		LDA	#0709FH
;;;;;;;;		STA	SOAM_DX+014H,Y
;;;;;;;;		LDA	#0B09FH
;;;;;;;;		STA	SOAM_DX+01CH,Y
;;;;;;;;		LDA	#0F09FH
;;;;;;;;		STA	SOAM_DX+024H,Y
;;;;;;;;;
;;;;;;;;		LDA	#00000
;;;;;;;;		STA	SOAM_DX+00EH,Y
;;;;;;;;		STA	SOAM_DX+016H,Y
;;;;;;;;		STA	SOAM_DX+01EH,Y
;;;;;;;;		STA	SOAM_DX+026H,Y
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;MSETMOV_150	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	PLSHMOV ( vC[T[` )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;PLSHMOV		EQU	$
;;;;;;;;;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;;;;;;;;;		BNE	PLSHMOV_020	; ^[QbgT[`^C}[@O@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		LDA	#MKIJ/2
;;;;;;;;;;;;;;;;		STA	<ENWRK0,X
;;;;;;;;;;;;;;;;		JMP	KAIJMOV_050
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;PLSHMOV_020	EQU	$
;;;;;;;;;;;;;;;;		LDA	PLXPSL
;;;;;;;;;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;;;;;;;;;		LDA	PLYPSL
;;;;;;;;;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;;;;;;;;;		LDA	ENWRK7,X
;;;;;;;;;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;		LDA	ENWRK7,X
;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	#00200H
;;;;;;;;		STA	R6		; ړXs[hZbg
;;;;;;;;;
;;;;;;;;		M_CHIP	SEARCH_SPEED
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;;
;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;
;;;;;;;;;;;;;;;;		LDY	#00000H
;;;;;;;;;;;;;;;;		LDA	R1
;;;;;;;;;;;;;;;;		BPL	PLSHMOV_050	; wXs[hvX@H
;;;;;;;;;;;;;;;;;					; No !!
;;;;;;;;;;;;;;;;		DEY
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;PLSHMOV_050	EQU	$
;;;;;;;;;;;;;;;;		CLC
;;;;;;;;;;;;;;;;		ADC	ENWRK6,X
;;;;;;;;;;;;;;;;		STA	<EWORK0
;;;;;;;;;;;;;;;;		STA	<EWORK0
;;;;;;;;;;;;;;;;		TYA
;;;;;;;;;;;;;;;;		ADC	ENWRK8,X
;;;;;;;;;;;;;;;;		STA	<EWORK2
;;;;;;;;;;;;;;;;;
;;;;;;;;		LDY	#00000
;;;;;;;;		LDA	R2
;;;;;;;;		BPL	PLSHMOV_100	; xXs[hvX@H
;;;;;;;;;					; No !!
;;;;;;;;		DEY
;;;;;;;;;
;;;;;;;;PLSHMOV_100	EQU	$
;;;;;;;;		CLC
;;;;;;;;		ADC	ENWRKA,X
;;;;;;;;		STA	<EWORK4
;;;;;;;;		TYA
;;;;;;;;		ADC	ENWRKC,X
;;;;;;;;		STA	<EWORK6
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;;;;;;;;;		LDY	#000
;;;;;;;;;;;;;;;;		LDA	<EWORK1
;;;;;;;;;;;;;;;;		SEC
;;;;;;;;;;;;;;;;		SBC	PLXPSL
;;;;;;;;;;;;;;;;		BEQ	PLSHMOV_140	; ڕWxWI[o[@H
;;;;;;;;;;;;;;;;;					; No !!
;;;;;;;;;;;;;;;;		EOR	R1
;;;;;;;;;;;;;;;;		BMI	PLSHMOV_150	; wWI[o[@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;PLSHMOV_140	EQU	$
;;;;;;;;;;;;;;;;		STZ	<EWORK0
;;;;;;;;;;;;;;;;		LDA	PLXPSL
;;;;;;;;;;;;;;;;		STA	<EWORK1
;;;;;;;;;;;;;;;;		INY
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;PLSHMOV_150	EQU	$
;;;;;;;;;;;;;;;;		LDA	<EWORK0
;;;;;;;;;;;;;;;;		STA	ENWRK6,X
;;;;;;;;;;;;;;;;		LDA	<EWORK2
;;;;;;;;;;;;;;;;		STA	ENWRK8,X
;;;;;;;;;;;;;;;;;
;;;;;;;;		LDA	<EWORK5
;;;;;;;;		SEC
;;;;;;;;;;;;;;;;		SBC	PLYPSL
;;;;;;;;		SBC	ENWRK7,X
;;;;;;;;		BEQ	PLSHMOV_190	; ڕWxWI[o[@H
;;;;;;;;;					; No !!
;;;;;;;;		EOR	R2
;;;;;;;;		BMI	PLSHMOV_200	; xWI[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;PLSHMOV_190	EQU	$
;;;;;;;;		STZ	<EWORK4
;;;;;;;;;;;;;;;;		LDA	PLYPSL
;;;;;;;;		LDA	ENWRK7,X
;;;;;;;;		STA	<EWORK5
;;;;;;;;		INY
;;;;;;;;;
;;;;;;;;PLSHMOV_200	EQU	$
;;;;;;;;		LDA	<EWORK4
;;;;;;;;		STA	ENWRKA,X
;;;;;;;;		LDA	<EWORK6
;;;;;;;;		STA	ENWRKC,X
;;;;;;;;;
;;;;;;;;;;;;;;;;		CPY	#002
;;;;;;;;		CPY	#001
;;;;;;;;		BNE	PLSHMOV_250	; ڕWWZbghnmh@H
;;;;;;;;;					; Yes !!
;;;;;;;;		INC	<ENWRK0,X	; [hCN
;;;;;;;;		DEC	LOCKCT
;;;;;;;;		LDA	#00020H
;;;;;;;;		STA	ENTIM1,X
;;;;;;;;		TAY
;;;;;;;;		JMP	LOCKMOV_050
;;;;;;;;;
;;;;;;;;PLSHMOV_250	EQU	$
;;;;;;;;		JMP	MSETMOV_100
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	LOCKMOV ( ~TCbNԏ )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;LOCKMOV		EQU	$
;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;		BNE	LOCKMOV_050	; ~TCˁ@H
;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;;;;;;;;;		CLC
;;;;;;;;;;;;;;;;		ADC	#00010H
;;;;;;;;;;;;;;;;		STA	ENWRKB,X	; ڕWxWZbg
;;;;;;;;		LDA	#00005
;;;;;;;;		STA	ENTIM3,X
;;;;;;;;		INC	<ENWRK0,X
;;;;;;;;		JMP	HASYMOV_150
;;;;;;;;;
;;;;;;;;LOCKMOV_050	EQU	$
;;;;;;;;		TAY
;;;;;;;;		AND	#00004H
;;;;;;;;		STA	<EWORK4
;;;;;;;;		LSR	A
;;;;;;;;		STA	<EWORK0
;;;;;;;;		TYA
;;;;;;;;		AND	#00018H
;;;;;;;;		LSR	A
;;;;;;;;		LSR	A
;;;;;;;;		XBA
;;;;;;;;		STA	<EWORK2
;;;;;;;;;
;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDY	ENOAML,X
;;;;;;;;;;;;;;;;		LDA	ENWRK7,X
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	#00004H
;;;;;;;;		SEC
;;;;;;;;		SBC	ESCCH1
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK0
;;;;;;;;		STA	SOAM_DX+008H,Y
;;;;;;;;		STA	SOAM_DX+018H,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		SEC
;;;;;;;;		SBC	<EWORK4
;;;;;;;;		STA	SOAM_DX+010H,Y
;;;;;;;;		STA	SOAM_DX+020H,Y
;;;;;;;;;
;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;;;;;;;;;		CLC
;;;;;;;;;;;;;;;;		ADC	#00008H
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK0
;;;;;;;;		STA	SOAM_DX+00AH,Y
;;;;;;;;		STA	SOAM_DX+012H,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		SEC
;;;;;;;;		SBC	<EWORK4
;;;;;;;;		STA	SOAM_DX+01AH,Y
;;;;;;;;		STA	SOAM_DX+022H,Y
;;;;;;;;;
;;;;;;;;		LDA	#0309FH
;;;;;;;;		ORA	<EWORK2
;;;;;;;;		STA	SOAM_DX+00CH,Y
;;;;;;;;		LDA	#0709FH
;;;;;;;;		ORA	<EWORK2
;;;;;;;;		STA	SOAM_DX+014H,Y
;;;;;;;;		LDA	#0B09FH
;;;;;;;;		ORA	<EWORK2
;;;;;;;;		STA	SOAM_DX+01CH,Y
;;;;;;;;		LDA	#0F09FH
;;;;;;;;		ORA	<EWORK2
;;;;;;;;		STA	SOAM_DX+024H,Y
;;;;;;;;;
;;;;;;;;		LDA	#00000
;;;;;;;;		STA	SOAM_DX+00EH,Y
;;;;;;;;		STA	SOAM_DX+016H,Y
;;;;;;;;		STA	SOAM_DX+01EH,Y
;;;;;;;;		STA	SOAM_DX+026H,Y
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	HASYMOV ( ~TCˏ )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;HASYMOV		EQU	$
;;;;;;;;		LDY	#000
;;;;;;;;;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;;;;;;;;;		SEC
;;;;;;;;;;;;;;;;		SBC	ENWRK7,X
;;;;;;;;;;;;;;;;		BEQ	HASYMOV_040	; ڕWwWI[o[@H
;;;;;;;;;;;;;;;;;					; No !!
;;;;;;;;;;;;;;;;		EOR	ENXSPD,X
;;;;;;;;;;;;;;;;		BMI	HASYMOV_050	; wWI[o[@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;;;;;;;;;HASYMOV_040	EQU	$
;;;;;;;;;;;;;;;;		LDA	ENWRK7,X
;;;;;;;;;;;;;;;;		STA	ENXPSL,X	; wWZbg
;;;;;;;;;;;;;;;;		STZ	ENXSPD,X	; wXs[hNA[
;;;;;;;;;;;;;;;;		INY
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;HASYMOV_050	EQU	$
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	ENWRKB,X
;;;;;;;;		BEQ	HASYMOV_090	; ڕWxWI[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		EOR	ENYSPD,X
;;;;;;;;		BMI	HASYMOV_100	; xWI[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;HASYMOV_090	EQU	$
;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;		STA	ENYPSL,X	; xWZbg
;;;;;;;;		STZ	ENYSPD,X	; xXs[hNA[
;;;;;;;;		INY
;;;;;;;;;
;;;;;;;;HASYMOV_100	EQU	$
;;;;;;;;;;;;;;;;		CPY	#002
;;;;;;;;		CPY	#001
;;;;;;;;		BNE	HASYMOV_150	; ڕWWɓB@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	ENTIM1,X
;;;;;;;;		STZ	<ENCONT,X
;;;;;;;;		LDA	#00006
;;;;;;;;		STA	ENCHPT,X
;;;;;;;;		INC	<ENWRK0,X
;;;;;;;;		LDA	#00048H
;;;;;;;;		JSL	>SOUND_3_ON	; []
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;HASYMOV_150	EQU	$
;;;;;;;;		LDA	ENTIM3,X
;;;;;;;;		BNE	HASYMOV_200	; p^[`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	ENTIM3,X
;;;;;;;;		LDA	ENCHPT,X
;;;;;;;;		INC	A
;;;;;;;;		CMP	#00006
;;;;;;;;		BNE	HASYMOV_190
;;;;;;;;;
;;;;;;;;		LDA	#00000
;;;;;;;;;
;;;;;;;;HASYMOV_190	EQU	$
;;;;;;;;		STA	ENCHPT,X
;;;;;;;;;
;;;;;;;;HASYMOV_200	EQU	$
;;;;;;;;;;;;;;;;		LDA	ENWRK7,X
;;;;;;;;;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	#00400H
;;;;;;;;		STA	R6		; ړXs[hZbg
;;;;;;;;;
;;;;;;;;		M_CHIP	SEARCH_SPEED
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;;
;;;;;;;;		LDY	#00000H
;;;;;;;;		LDA	R1
;;;;;;;;		STA	ENXSPD,X	; wXs[hZbg
;;;;;;;;		LDA	R2
;;;;;;;;		STA	ENYSPD,X	; xXs[hZbg
;;;;;;;;;
;;;;;;;;		INC	<ENCONT,X
;;;;;;;;		LDA	<ENCONT,X
;;;;;;;;		JMP	LOCKMOV_050
;;;;;;;;;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	MOKUMOV ( ڕW菈 )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;BAKTIMD		EQU	$
;;;;;;;;		WORD	00001H,00001H,00001H,00001H,00002H,00002H,00002H,00003H
;;;;;;;;		WORD	00003H,00008H
;;;;;;;;;
;;;;;;;;BAKTIM1		EQU	$
;;;;;;;;		WORD	0000AH,0000CH,0000EH,00010H,0000CH,00004H,00000H
;;;;;;;;;
;;;;;;;;;;;;;;;;BAKTIM1		EQU	$
;;;;;;;;;;;;;;;;;;;;;;;;		WORD	0002FH,00004H,00006H,00006H,00006H,00006H,00006H,00006H
;;;;;;;;;;;;;;;;		WORD	00001H,00004H,00006H,00006H,00006H,00006H,00006H,00006H
;;;;;;;;;;;;;;;;		WORD	00000H
;;;;;;;;;;;;;;;;;
;;;;;;;;CRSXDT0		EQU	$
;;;;;;;;		WORD	00012H,00014H,00016H,00018H,0001AH,0001CH,0001EH,00020H
;;;;;;;;		WORD	00021H,00022H,00022H,00022H,00022H,00022H,00022H,00022H
;;;;;;;;;;;;;;;;		WORD	00010H,00010H,00010H,00018H,00019H,0001AH
;;;;;;;;;;;;;;;;		WORD	00020H,00020H,00024H,00025H,00026H,00027H,00028H,00029H
;;;;;;;;;
;;;;;;;;CRSXDT1		EQU	$
;;;;;;;;		WORD	00024H,00028H,0002CH,00030H,00034H,00038H,0003CH,00040H
;;;;;;;;		WORD	00042H,00044H,00044H,00044H,00044H,00044H,00044H,00044H
;;;;;;;;;;;;;;;;		WORD	00020H,00020H,00020H,00030H,00032H,00034H
;;;;;;;;;;;;;;;;		WORD	00040H,00040H,00048H,0004AH,0004CH,0004EH,00050H,00052H
;;;;;;;;;
;;;;;;;;;
;;;;;;;;MOKUMOV		EQU	$
;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;		BNE	MOKUMOV_100	; p^[`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		INC	ENCHPT,X
;;;;;;;;		INC	<ENCONT,X
;;;;;;;;		LDA	<ENCONT,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		CPY	#(CRSXDT0-BAKTIMD)-2
;;;;;;;;		BEQ	MOKUMOV_050
;;;;;;;;		CPY	#BAKTIM1-BAKTIMD
;;;;;;;;		BCS	MOKUMOV_050	; vC[`FbN@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	PLXPSL
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	!CRSXDT0,Y
;;;;;;;;		CMP	!CRSXDT1,Y
;;;;;;;;;;;;;;;;		ADC	#00010H
;;;;;;;;;;;;;;;;		CMP	#00030H
;;;;;;;;		BCS	MOKUMOV_050	; vC[@wW͈͓@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	PLYPSL
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		SEC
;;;;;;;;		SBC	ENYPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	!CRSXDT0,Y
;;;;;;;;		CMP	!CRSXDT1,Y
;;;;;;;;;;;;;;;;		ADC	#00020H
;;;;;;;;;;;;;;;;		CMP	#00030H
;;;;;;;;		BCS	MOKUMOV_050	; vC[@xW͈͓@H
;;;;;;;;;					; Yes !!
;;;;;;;;		PHY
;;;;;;;;		JSL	>PLFLST		; vC[CjVZbg[`
;;;;;;;;		PLY
;;;;;;;;;
;;;;;;;;MOKUMOV_050	EQU	$
;;;;;;;;		LDA	!BAKTIMD,Y
;;;;;;;;		STA	ENTIM1,X
;;;;;;;;		BNE	MOKUMOV_100	; p^[`FW^C}[@O@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	ENCHPT,X	; ~TCLN^[Zbg
;;;;;;;;		LDA	#00040H
;;;;;;;;		STA	ENTIM0,X	; o^C}[Zbg
;;;;;;;;		STZ	<ENCONT,X
;;;;;;;;		LDA	#000B8H
;;;;;;;;		STA	ENYPSL,X	; xWZbg
;;;;;;;;		LDA	<ENWRK2,X
;;;;;;;;		STA	ENXPSL,X	; wWZbg
;;;;;;;;		INC	<ENWRK0,X	; [hCN
;;;;;;;;		LDA	<ENWRK4,X
;;;;;;;;		BEQ	MOKUMOV_100	; tOhnmh@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JMP	>ENCLEAR
;;;;;;;;;
;;;;;;;;MOKUMOV_100	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	MISAWAI ( ~TCZbg^C}[ )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;MISAWAI		EQU	$
;;;;;;;;		LDA	ENTIM0,X
;;;;;;;;		BNE	MISAWAI_050	; ݂o^C}[@O@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	ENTIM0,X
;;;;;;;;		STZ	<ENWRK0,X	; [hNA[
;;;;;;;;;
;;;;;;;;MISAWAI_050	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	KAIJMOV ( vC[T[` )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;KAIJMOV		EQU	$
;;;;;;;;		INC	<ENCONT,X
;;;;;;;;		LDA	<ENCONT,X
;;;;;;;;		AND	#0000EH
;;;;;;;;;;;;;;;;		LSR	A
;;;;;;;;;;;;;;;;		LSR	A
;;;;;;;;		STA	<EWORK4
;;;;;;;;		LSR	A
;;;;;;;;		STA	<EWORK0
;;;;;;;;		CMP	#00007
;;;;;;;;		BNE	KAIJMOV_050	; vC[T[`I@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	<ENCONT,X
;;;;;;;;		STZ	<ENWRK0,X
;;;;;;;;		DEC	LOCKCT
;;;;;;;;		LDA	<ENWRK4,X
;;;;;;;;		BEQ	KAIJMOV_050	; ~TCˑĂ@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JSL	>ENCLEAR
;;;;;;;;;
;;;;;;;;KAIJMOV_050	EQU	$
;;;;;;;;		I16			; index 16 bit mode !!
;;;;;;;;;
;;;;;;;;		LDY	ENOAML,X
;;;;;;;;		LDA	ENWRK7,X
;;;;;;;;		SEC
;;;;;;;;		SBC	#00008H
;;;;;;;;		SEC
;;;;;;;;		SBC	ESCCH1
;;;;;;;;		SEC
;;;;;;;;		SBC	<EWORK0
;;;;;;;;		STA	SOAM_DX+008H,Y
;;;;;;;;		STA	SOAM_DX+018H,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK4
;;;;;;;;		STA	SOAM_DX+010H,Y
;;;;;;;;		STA	SOAM_DX+020H,Y
;;;;;;;;;
;;;;;;;;		LDA	ENWRKB,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00008H
;;;;;;;;		SEC
;;;;;;;;		SBC	<EWORK0
;;;;;;;;		STA	SOAM_DX+00AH,Y
;;;;;;;;		STA	SOAM_DX+012H,Y
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		CLC
;;;;;;;;		ADC	<EWORK4
;;;;;;;;		STA	SOAM_DX+01AH,Y
;;;;;;;;		STA	SOAM_DX+022H,Y
;;;;;;;;;
;;;;;;;;		LDA	#0309FH
;;;;;;;;		STA	SOAM_DX+00CH,Y
;;;;;;;;		LDA	#0709FH
;;;;;;;;		STA	SOAM_DX+014H,Y
;;;;;;;;		LDA	#0B09FH
;;;;;;;;		STA	SOAM_DX+01CH,Y
;;;;;;;;		LDA	#0F09FH
;;;;;;;;		STA	SOAM_DX+024H,Y
;;;;;;;;;
;;;;;;;;		LDA	#00000
;;;;;;;;		STA	SOAM_DX+00EH,Y
;;;;;;;;		STA	SOAM_DX+016H,Y
;;;;;;;;		STA	SOAM_DX+01EH,Y
;;;;;;;;		STA	SOAM_DX+026H,Y
;;;;;;;;;
;;;;;;;;		I8			; index 8 bit mode !!
;;;;;;;;;
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_BBYIN		( ԂCjVZbg )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_BBYIN		EQU	$
;;;;;;;;		LDA	#00020H
;;;;;;;;		STA	ENXPSL,X	; CjVwWZbg
;;;;;;;;		LDA	#0006FH
;;;;;;;;		STA	ENYPSL,X	; CjVxWZbg
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_BBYMV		( Ԃ񃀁[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_BBYMV		EQU	$
;;;;;;;;		LDA	ENTMCT
;;;;;;;;		BEQ	M_BBYMV_050	; Sĉ󂵂@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	MNTIME
;;;;;;;;		BNE	M_BBYMV_100	; Q[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;M_BBYMV_050	EQU	$
;;;;;;;;		STZ	ENXSPD,X
		RTL
;;;;;;;;;
;;;;;;;;M_BBYMV_100	EQU	$
;;;;;;;;		LDA	<ENWRK0,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		LDA	!M_BBYMV_ADR,Y
;;;;;;;;		STA	<EWORK0
;;;;;;;;		JMP	(EWORK0)
;;;;;;;;;
;;;;;;;;;
;;;;;;;;M_BBYMV_ADR	EQU	$
;;;;;;;;		WORD	WAITMOV		; ƂĂ鏈
;;;;;;;;		WORD	WALTMOV		; eɍs
;;;;;;;;		WORD	BKWKMOV		; e^ԏ
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	WAITMOV ( ƂĂ鏈 )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;WAITMOV		EQU	$
;;;;;;;;;;;;;;;;		TXA
;;;;;;;;;;;;;;;;		AND	#000FFH
;;;;;;;;;;;;;;;;		STA	R1		; CfbNXZbg
;;;;;;;;;;;;;;;;		LDA	#M_BAK
;;;;;;;;;;;;;;;;		STA	R14		; T[`GmDZbg
;;;;;;;;;;;;;;;;		M_CHIP	TARGET_SEARCH
;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;		LDX	<ENINDX
;;;;;;;;;;;;;;;;		LDY	R1
;;;;;;;;;;;;;;;;		BMI	WAITMOV_050	; G@H
;;;;;;;;;;;;;;;;;					; Yes !!
;;;;;;;;		LDY	<ENWRK2,X
;;;;;;;;		LDA	ENMODE,Y
;;;;;;;;;;;;		    CMP	    #EMGNT
;;;;;;;;		BEQ	WAITMOV_050	; ΂ɂtĂ@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENXPSL,Y
;;;;;;;;		SEC
;;;;;;;;		SBC	#00010H
;;;;;;;;		CMP	ENXPSL,X
;;;;;;;;		BNE	WAITMOV_050	; wW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	ENYPSL,Y
;;;;;;;;		DEC	A
;;;;;;;;		CMP	ENYPSL,X
;;;;;;;;		BEQ	WAITMOV_100	; xW@H
;;;;;;;;;					; No !!
;;;;;;;;WAITMOV_050	EQU	$
;;;;;;;;		LDA	#00002H
;;;;;;;;		STA	ENMUKI,X	; ]
;;;;;;;;		LDA	#0FF00H
;;;;;;;;		STA	ENXSPD,X	; wXs[hZbg
;;;;;;;;		INC	<ENWRK0,X	; [hCN
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	ENTIM0,X	; p^[`FW^C}[Zbg
;;;;;;;;;
;;;;;;;;WAITMOV_100	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	WALTMOV ( eɍs )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;WALTMOV		EQU	$
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		BPL	WALTMOV_050
;;;;;;;;;
;;;;;;;;		CMP	#0FFE8H
;;;;;;;;		BCS	WALTMOV_050	; [uXgbv@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#0FFE8H
;;;;;;;;		STA	ENXPSL,X	; wWZbg
;;;;;;;;		LDA	#00100H
;;;;;;;;		STA	ENXSPD,X	; wXs[hZbg
;;;;;;;;		STZ	ENMUKI,X	; ]
;;;;;;;;;
;;;;;;;;		LDA	#M_BAK
;;;;;;;;		JSL	>ENINSR_I
;;;;;;;;		LDA	#0FFF8H
;;;;;;;;		STA	ENXPSL,Y	; ewWCjVZbg
;;;;;;;;		LDA	#00070H
;;;;;;;;		STA	ENYPSL,Y	; exWCjVZbg
;;;;;;;;		TYA
;;;;;;;;		STA	<ENWRK2,X
;;;;;;;;		INC	<ENWRK0,X	; [hCN
;;;;;;;;;
;;;;;;;;WALTMOV_050	EQU	$
;;;;;;;;		LDA	ENTIM0,X
;;;;;;;;		BNE	WALTMOV_100	; p^[`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	ENCHPT,X
;;;;;;;;		EOR	#00001
;;;;;;;;		STA	ENCHPT,X	; p^[mDZbg
;;;;;;;;		LDA	#00004
;;;;;;;;		STA	ENTIM0,X	; p^[`FW^C}[Zbg
;;;;;;;;;
;;;;;;;;WALTMOV_100	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	BKWKMOV ( e^ԏ )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;BKWKMOV		EQU	$
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		CMP	#00020H
;;;;;;;;		BNE	BKWKMOV_050	; [uXgbv@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	ENXSPD,X
;;;;;;;;		STZ	<ENWRK0,X
;;;;;;;;;
;;;;;;;;BKWKMOV_050	EQU	$
;;;;;;;;		JMP	WALTMOV_050
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_DR3IN		( D_NCjV )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_DR3IN		EQU	$
;;;;;;;;		LDA	#000A0H
;;;;;;;;		STA	ENYPSL,X
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	ENXPSL,X
		RTL
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_DR3MV		( D_N[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_DR3MV		EQU	$
;;;;;;;;		LDA	ENTMCT
;;;;;;;;		BEQ	M_DR3MV_050	; Sĉ󂵂@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	MNTIME
;;;;;;;;		BNE	M_DR3MV_100	; Q[I@H
;;;;;;;;;					; Yes !!
;;;;;;;;M_DR3MV_050	EQU	$
;;;;;;;;		STZ	ENXSPD,X
;;;;;;;;		STZ	ENYSPD,X
;;;;;;;;		STZ	ENGPOW,X
;;;;;;;;		STZ	ENGMAX,X
		RTL
;;;;;;;;;
;;;;;;;;M_DR3MV_100	EQU	$
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		CMP	#00010H
;;;;;;;;		BCS	M_DR3MV_150	; ʍ[I[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#00010H
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	ENXPSL,X
;;;;;;;;		STA	ENXPSL,X	; wW␳
;;;;;;;;		BRA	M_DR3MV_200
;;;;;;;;;
;;;;;;;;M_DR3MV_150	EQU	$
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	#001E0H
;;;;;;;;		BMI	M_DR3MV_200	; ʉE[I[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STA	<EWORK0
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	<EWORK0
;;;;;;;;		STA	ENXPSL,X	; wW␳
;;;;;;;;;
;;;;;;;;M_DR3MV_200	EQU	$
;;;;;;;;		LDA	<ENWRK0,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		LDA	!M_DR3MV_ADR,Y
;;;;;;;;		STA	<EWORK0
;;;;;;;;		JMP	(EWORK0)
;;;;;;;;;
;;;;;;;;;
;;;;;;;;M_DR3MV_ADR	EQU	$
;;;;;;;;		WORD	DRPLMOV		; D_NvC[T[`
;;;;;;;;		WORD	DRKZMOV		; D_NC⏈
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	DRPLMOV ( D_NvC[T[` )		x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;DRPLMOV		EQU	$
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCS	DRPLMOV_020	; Wv@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDY	#018H
;;;;;;;;		LDA	ENYSPD,X
;;;;;;;;		BPL	DRPLMOV_400	; ㏸@H
;;;;;;;;;					; No !!
;;;;;;;;		DEY
;;;;;;;;;
;;;;;;;;DRPLMOV_400	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENCHPT,X
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;DRPLMOV_020	EQU	$
;;;;;;;;		LDA	ENCHPT,X
;;;;;;;;		CMP	#00017H
;;;;;;;;		BCC	DRPLMOV_030
;;;;;;;;;
;;;;;;;;		LDA	#00000
;;;;;;;;		STA	ENCHPT,X
;;;;;;;;;
;;;;;;;;DRPLMOV_030	EQU	$
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	PLYPSL
;;;;;;;;		CMP	#00050H
;;;;;;;;		BCS	DRPLMOV_050	; Wv@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#0FB00H
;;;;;;;;		STA	ENYSPD,X	; WvXs[hZbg
;;;;;;;;;;;;;;;;		BRA	DRPLMOV_350
;;;;;;;;;
;;;;;;;;DRPLMOV_050	EQU	$
;;;;;;;;		LDA	PLXPSL
;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;		LDA	PLYPSL
;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	#00180H
;;;;;;;;		STA	R6		; ړXs[hZbg
;;;;;;;;;
;;;;;;;;		M_CHIP	SEARCH_SPEED
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;;
;;;;;;;;		LDY	#000H
;;;;;;;;		LDA	R1
;;;;;;;;		STA	ENXSPD,X	; wXs[hZbg
;;;;;;;;		BMI	DRPLMOV_150
;;;;;;;;;
;;;;;;;;		INY
;;;;;;;;		INY
;;;;;;;;;
;;;;;;;;DRPLMOV_150	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENMUKI,X
;;;;;;;;;
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	PLXPSL
;;;;;;;;		BEQ	DRPLMOV_200	; ڕWwWI[o[@H
;;;;;;;;;					; No !!
;;;;;;;;		EOR	ENXSPD,X
;;;;;;;;		BMI	DRPLMOV_250	; wWI[o[@H
;;;;;;;;;					; Yes !!
;;;;;;;;DRPLMOV_200	EQU	$
;;;;;;;;		LDA	PLXPSL
;;;;;;;;		STA	ENXPSL,X	; wWZbg
;;;;;;;;;
;;;;;;;;DRPLMOV_250	EQU	$
;;;;;;;;		LDA	ENTIM0,X
;;;;;;;;		BNE	DRPLMOV_300	; p^[`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	ENCHPT,X
;;;;;;;;		EOR	#00001
;;;;;;;;		STA	ENCHPT,X	; p^[mDZbg
;;;;;;;;		LDA	#00003
;;;;;;;;		STA	ENTIM0,X
;;;;;;;;;
;;;;;;;;DRPLMOV_300	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	DRKZMOV ( D_NC⏈ )			x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;DRKZMOV		EQU	$
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCC	DRKZMOV_100	; Wv@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;		BNE	DRKZMOV_100	; D_Nn|[Y`FW@H
;;;;;;;;;					; Yes !!
;;;;;;;;		INC	<ENWRK4,X
;;;;;;;;		LDA	<ENWRK4,X
;;;;;;;;		ASL	A
;;;;;;;;		TAY
;;;;;;;;		LDA	!CYAKPTD,Y
;;;;;;;;		STA	ENCHPT,X	; D_Nn|[YmDZbg
;;;;;;;;		LDA	!CYAKTMD,Y
;;;;;;;;		STA	ENTIM1,X	; D_Nn|[Y^C}[Zbg
;;;;;;;;		BNE	DRKZMOV_100	; D_Nn|[YI@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	<ENWRK0,X
;;;;;;;;		STZ	<ENWRK4,X
;;;;;;;;		LDA	#00003
;;;;;;;;		STA	ENTIM0,X
;;;;;;;;		STZ	ENCHPT,X
;;;;;;;;;
;;;;;;;;DRKZMOV_100	EQU	$
;;;;;;;;		RTL
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;;;;;;;;;
;========================================================================
		MEM8
		IDX8
;
		DPAGE	WORK0
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		MINIINT1_6	( ~jQ[ΓfCjVZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MINIINT1_6	EQU	$
;-------------- XN[l NA -----------------------------
		M16			; memory 16 bit mode !!
;
		STZ	<SCCH1
		STZ	<SCCV1
		STZ	<SCCH2
		STZ	<SCCV2
		STZ	<SCCH3
		STZ	<SCCV3
;
		LDY	#069H
		STY	!BG1SCF
		STY	2107H
		LDY	#039H
		STY	!BG2SCF
		STY	2108H
		LDY	#009H
		STY	BGMODE
		STY	2105H
		LDY	#000
		STY	HD420C
		STY	SUBADF
;
;-------------- Q[ CjV -----------------------------------
		M16			; memory 16 bit mode !!
;
		LDA	#000B0H
		STA	PLYPSL		; player Y initial set !!
		LDA	#00030H
		STA	PLXPSL		; player X initial set !!
		STZ	UNBUFAD
		STA	TIMER
		STZ	MISS_P		; ~X|CgNA[
;
		LDA	#00008H
		STA	PLLIFE		; vC[@Ct[^[Zbg
		STA	ENLIFE		; D_N@Ct[^[Zbg
		LDA	#0FFFFH
		STA	OBJCHR_BNK
		STA	OBJCHR_BNK+2
		STA	OBJCHR_BNK+4
		STZ	UNBUFAD
;
		LDA	#MINICORS01
		STA	<BGDTADR
		LDA	#00001
		STA	BG1TYP
;
		LDA	#M_DR4
		JSL	>ENINSR_I
;
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#00030H
		STA	ENXPSL,Y
		LDA	#00050H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#000B0H
		STA	ENXPSL,Y
		LDA	#00040H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#00020H
		STA	ENXPSL,Y
		LDA	#00090H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#000A0H
		STA	ENXPSL,Y
		LDA	#00080H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#00090H
		STA	ENXPSL,Y
		LDA	#000C0H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#000E0H
		STA	ENXPSL,Y
		LDA	#000C0H
		STA	ENYPSL,Y
;
		JSL	>ENEMY_IN
;
		MEM8
		IDX8
;
		LDA	#BANK MINICORS01
		STA	<BGDTADR+2
		JSL	>UNITST_SUB
;
		RTS
;
;
;****************************************************************
;*								*
;*		~j Q[					*
;*								*
;****************************************************************
MINIMOV1_6	EQU	$
		JSL	>OAMDXCLR	; OAM clear sub !!
		LDA	#00030H
		STA	PLPRIO		; vC[vCIeB[Zbg
		JSL	>ENCSET_DM	; enemy char set sub !!
		JSL	>PLCSET		; player char set sub !!
;
		STZ	SPECIAL_P
;
		LDA	MNMODE
		ASL	A
		TAX
		JSR	(!MIN6TBL,X)
;
		M16
;
		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;
		M8
;
		RTS
;
;
MIN6TBL		EQU	$
		WORD	MIN6NOM		; ~jQ[vC
		WORD	MIN6PWN		; ~jQ[vC[
		WORD	MIN6EWN		; ~jQ[G
;
;
		MEM16
;
;;;;;;;;MINIMOV1_6	EQU	$
;;;;;;;;		JSL	>OAMDXCLR	; OAM clear sub !!
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	PLPRIO		; vC[vCIeB[Zbg
;;;;;;;;		JSL	>ENCSET_DM	; enemy char set sub !!
;;;;;;;;		JSL	>PLCSET		; player char set sub !!
;;;;;;;;;
;;;;;;;;		STZ	SPECIAL_P
;;;;;;;;;
;;;;;;;;		LDA	PLLIFE
;;;;;;;;		BEQ	MINIMOV1_6_050	; vC[̕@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENLIFE
;;;;;;;;		BNE	MINIMOV1_6_200	; D_N̕@H
;;;;;;;;;					; Yes !!
;;;;;;;;MINIMOV1_6_050	EQU	$
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;		DEC	ENDTIM
;;;;;;;;		BNE	MINIMOV1_6_250	; sI@H
;;;;;;;;;					; Yes !!
;;;;;;;;;;;;K;;;;		LDY	#MINIT
;;;;;;;;;;;;K;;;;		INC	MINIMD
;;;;;;;;;;;;K;;;;		LDA	MINIMD
;;;;;;;;;;;;K;;;;		CMP	#003
;;;;;;;;;;;;K;;;;		BNE	MINIMOV1_6_150	; ~jQ[@RI@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JSL	>BACK_GAME
;;;;;;;;		BRA	MINIMOV1_6_250
;;;;;;;;;;;;K;;;;		LDY	#HMPIN
;;;;;;;;;
;;;;;;;;MINIMOV1_6_150	EQU	$
;;;;;;;;;;;;K;;;;		STY	MODENO		; C[hZbg
;;;;;;;;;;;;K;;;;		BRA	MINIMOV1_6_250
;;;;;;;;;
;;;;;;;;MINIMOV1_6_200	EQU	$
;;;;;;;;		JSL	>PLAYER		; player move sub !!
;;;;;;;;		LDA	!MSGMOD		; bZ[W EBhD nm ?
;;;;;;;;		BNE	MINIMOV1_6_230	;	YES -> MINIMOV1_6_230
;;;;;;;;		JSL	>ENEMY_IN	; enemy move sub !!
;;;;;;;;;
;;;;;;;;		JSR	METERS3		; [^[Zbg[`
;;;;;;;;;
;;;;;;;;MINIMOV1_6_230	EQU	$
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;MINIMOV1_6_250	EQU	$
;;;;;;;;		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;;;;;;;;;
;;;;;;;;		M8			; memory 8 bit mode !!
;;;;;;;;;
;;;;;;;;		RTS
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MIN6NOM ( ~jQ[vC )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MIN6NOM		EQU	$
		JSL	>PLAYER		; player move sub !!
		LDA	MSGMOD		; bZ[W EBhD nm ?
		BNE	MIN6NOM_END	;	YES -> MIN6NOM_END
;
		JSL	>ENEMY_IN	; enemy move sub !!
		JSR	METERS3		; [^[Zbg[`
;
MIN6NOM_END	EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MIN6PWN ( ~jQ[vC[ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MIN6PWN		EQU	$
		JSL	>PLAYER		; player move sub !!
		JSL	>ENEMY_IN	; enemy move sub !!
;
		LDA	ITGTFG
		BEQ	MIN6PWN_END	; ACe@H
;					; Yes !!
		LDA	PLJUMP
		BNE	MIN6PWN_END	; vC[Wv@H
;					; Yes !!
		M16
;
		LDA	#00080H
		STA	ENDTIM		; I^C}[Zbg
;
		M8
;
		INC	MNMODE
		INC	PLSTFG
;
MIN6PWN_END	EQU	$
		JMP	MIN2PWN_END
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MIN6EWN ( ~jQ[G )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MIN6EWN		EQU	$
		JSL	>PLAYER		; player move sub !!
		JSL	>ENEMY_IN	; enemy move sub !!
;
		M16
;
		DEC	ENDTIM
		BNE	MIN6EWN_END	; ~jQ[I@H
;					; Yes !!
		JSL	>BACK_GAME
;
MIN6EWN_END	EQU	$
		LDA	#001H
		STA	PLSTFG
		JMP	MIN2PWN_END
;
;
;
;------------------------------------------------------------------------
		MEM8
		IDX8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	METERS3 ( [^[Zbg[` )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PLYMODT		EQU	$
		WORD	00001H,00002H
;
;
METERS3		EQU	$
		LDA	MISS_P
		BEQ	METERS3_050	; vC[tOhnmh@H
;					; Yes !!
		LDA	MISS_P
		ASL	A
		STA	<WORK4
		LDA	PLLIFE
		SEC
		SBC	<WORK4
		BPL	METERS3_040
;
		LDA	#000
;
METERS3_040	EQU	$
		STA	PLLIFE		; vC[Ct[^[Zbg
		STZ	MISS_P		; vC[tONA[
;
METERS3_050	EQU	$
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
;
		MI16			; memory,index 16 bit mode !!
;
		LDX	VRAMDX
		LDA	#03483H
		STA	0,X
		LDA	#03495H
		STA	28,X
;
		LDA	#00180H
		STA	2,X
		STA	30,X
;
		LDA	#00018H
		STA	4,X
		STA	32,X
;
		TXA
		CLC
		ADC	#00012
		STA	5,X
		ADC	#00028
		STA	33,X
;
		LDA	#BANK VRAMDX
		STA	7,X
		STA	35,X
;
		LDA	#00016
		STA	8,X
		STA	36,X
;
		TXA
		ADC	#00028
		STA	10,X
		ADC	#00028
		STA	38,X
		STA	VRAMDX
;
		PLB
;
		TXA
		SEC
		SBC	#VRAMDX+2
		STA	<WORK4
		TAX
;
		LDY	PLLIFE
;;;;;;;;		TAY
;;;;;;;;		AND	#00001
;;;;;;;;		STA	<WORK0
;;;;;;;;		TYA
;;;;;;;;		INC	A
;;;;;;;;		LSR	A
;;;;;;;;		STA	<WORK2
;;;;;;;;		TAY
		LDA	#00008
		SEC
		SBC	PLLIFE
		STA	<WORK6
		CMP	#00008
		BEQ	METERS3_150	; vC[Ct[^[hOh@H
;					; No !!
		LDA	#02948H
;
METERS3_100	EQU	$
		STA	>VRAMDX+14,X
		INX
		INX
		DEY
		BNE	METERS3_100	; Ct[^[ZbgI@H
;					; Yes !!
		LDA	#02949H
;;;;;;;;		CLC
;;;;;;;;		ADC	<WORK0
		STA	>VRAMDX+12,X
;
		LDA	<WORK6
		BEQ	METERS3_250	; vC[Ct[^[hOh@H
;					; No !!
METERS3_150	EQU	$
		LDA	#02946H
;
METERS3_200	EQU	$
		STA	>VRAMDX+14,X
		INX
		INX
		DEC	<WORK6
		BNE	METERS3_200
;
METERS3_250	EQU	$
		LDX	<WORK4
		LDY	ENLIFE
;;;;;;;;		TAY
;;;;;;;;		AND	#00001
;;;;;;;;		STA	<WORK0
;;;;;;;;		TYA
;;;;;;;;		INC	A
;;;;;;;;		LSR	A
;;;;;;;;		STA	<WORK2
;;;;;;;;		TAY
		LDA	#00008
		SEC
		SBC	ENLIFE
		STA	<WORK6
		CMP	#00008
		BEQ	METERS3_350
;
		LDA	#02948H
;
METERS3_300	EQU	$
		STA	>VRAMDX+42,X
		INX
		INX
		DEY
		BNE	METERS3_300
;
		LDA	#02949H
;;;;;;;;		CLC
;;;;;;;;		ADC	<WORK0
		STA	>VRAMDX+40,X
;
		LDA	<WORK6
		BEQ	METERS3_450
;
METERS3_350	EQU	$
		LDA	#02946H
;
METERS3_400	EQU	$
		STA	>VRAMDX+42,X
		INX
		INX
		DEC	<WORK6
		BNE	METERS3_400
;
METERS3_450	EQU	$
		LDY	#00002
		LDA	PLLIFE
		BEQ	METERS3_500
;
		LDA	ENLIFE
		BNE	METERS3_550
;
		LDY	#00000
;
METERS3_500	EQU	$
		TYA
		LSR	A
		STA	WINFLG
;;;;;;;;		LDA	!DATADRS,Y
;;;;;;;;		STA	VRFLG2
		LDA	!SOUNDNO,Y
		STA	<SOUND_0	; []
		LDA	!PLYMODT,Y
		STA	MNMODE		; [h`FW
		LDA	#00200H
		STA	ENDTIM
		JSR	ENRMCLR
		LDA	#00001H
		STA	HDMMOD
;
METERS3_550	EQU	$
		MI8			; memory,index 8 bit mode !!
;
		RTS
;
		MEM16
		IDX16
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSL	ENRMCLR ( Gq`lNA[ )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ENRMCLR		EQU	$
		LDX	#(ENNO-1)*4
;
ENRMCLR_050	EQU	$
		LDA	ENMODE,X
		BEQ	ENRMCLR_100	; GĂ@H
;					; Yes !!
		LDA	ENMYNO,X
		CMP	#M_DR4
		BNE	ENRMCLR_060	; D_N@H
;					; Yes !!
		CPY	#00000H
		BNE	ENRMCLR_060	; vC[@H
;					; Yes !!
		LDA	#EFAIL
		STA	ENMODE,X
;
ENRMCLR_060	EQU	$
		LDA	ENMOD1,X
		AND	#0110000000000000B
		BNE	ENRMCLR_100	; NA[@H
;					; Yes !!
		STZ	ENXSPD,X
;;;;;;;;		STZ	ENYSPD,X
		STZ	ENGPOW,X
		STZ	ENXPOW,X
;
ENRMCLR_100	EQU	$
		STZ	ENWRK8,X
		DEX
		DEX
		DEX
		DEX
		BPL	ENRMCLR_050	; `FbNI@H
;					; Yes !!
		CPY	#00000H
		BNE	ENRMCLR_END
;
		LDA	MN2PLY
		BNE	ENRMCLR_END	; lp@H
;					; No !!
		I8
;
		LDA	#M_ITM
		LDY	#004H
		JSL	>ENINSR2_I
;
		JSL	>RANDAM
		AND	#00003H
		CMP	#00003H
		BNE	ENRMCLR_150	; |C^[I[o[@H
;					; Yes !!
		LDA	#00000H
;
ENRMCLR_150	EQU	$
		CLC
		ADC	#00007H
		STA	ENWRK0,Y
		LDA	#00098H
		STA	ENYPSL,Y
		LDA	#00078H
		STA	ENXPSL,Y
;
ENRMCLR_END	EQU	$
		RTS
;
;
;
;
;------------------------------------------------------------------------
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_DR4IN		( D_P@Ń{b@CjV )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_DR4IN		EQU	$
		LDA	#000C0H
		STA	ENYPSL,X	; D_NxWCjVZbg
		LDA	#000C0H
		STA	ENXPSL,X	; D_NWCjVZbg
		LDA	#00004H
		STA	ENTIM0,X	; D_Np^[^C}[Zbg
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_DR4MV		( D_P@Ń{b@[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DR4WLKD		EQU	$
		WORD	00002H,00003H,00004H,00005H,00006H,00007H
;
DR4FIRD		EQU	$
		WORD	00000H,00001H
;
DR4RUND		EQU	$
		WORD	00008H,00009H
;
DR4KYOD		EQU	$
		WORD	0000AH,0000BH
;
DR4JMPD		EQU	$
		WORD	0000CH,0000DH,0000EH,0000FH,00010H,00011H,00012H
;
DR4NIJD		EQU	$
		WORD	00013H,00014H,00015H,00016H,00017H,00018H
;
DR4SYAD		EQU	$
		WORD	00019H,0001AH,0001BH,0001AH
;
;
DR4TIME		EQU	$
		WORD	00004H,00004H,00004H,00004H,00004H,00004H
		WORD	00000H,00000H
		WORD	00002H,00002H
		WORD	00008H,00008H
		WORD	00000H,00000H,00000H,00000H,00000H,00002H,00002H
		WORD	00002H,00002H,00002H,00002H,00002H,00002H
		WORD	00000H,00000H,00000H,00000H
;
;
PAUSED0		EQU	$
		WORD	(DR4WLKD-DR4WLKD)/2
		WORD	(DR4FIRD-DR4WLKD)/2
		WORD	(DR4RUND-DR4WLKD)/2
		WORD	(DR4KYOD-DR4WLKD)/2
		WORD	(DR4JMPD-DR4WLKD)/2
		WORD	(DR4NIJD-DR4WLKD)/2
		WORD	(DR4SYAD-DR4WLKD)/2
;
PAUSED1		EQU	$
		WORD	(DR4FIRD-DR4WLKD)/2
		WORD	(DR4RUND-DR4WLKD)/2
		WORD	(DR4KYOD-DR4WLKD)/2
		WORD	(DR4JMPD-DR4WLKD)/2
		WORD	(DR4NIJD-DR4WLKD)/2
		WORD	(DR4SYAD-DR4WLKD)/2
		WORD	(DR4TIME-DR4WLKD)/2
;
;
M_DRXPS		EQU	$
		WORD	00008H,00000H
;
;
M_DR4MV		EQU	$
		LDA	MNMODE
		BEQ	M_DR4MV_010	; @H
;					; Yes !!
		LDA	#D4NO
		STA	ENWRK0,X
		JMP	M_DR4MV_350
;
M_DR4MV_010	EQU	$
		LDY	ENMUKI,X
		LDA	ENXPSL,X
		CLC
		ADC	!M_DRXPS,Y
		STA	R8
		LDA	ENYPSL,X
		STA	R0
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
;
		I16			; index 16 bit mode !!
;
		LDA	#0000000000010000B
		STA	<EWORK0
		LDA	#0000011000000000B
		LDY	R6
		BEQ	M_DR4MV_050	; BĂ@H
;					; No !!
		LDY	R5
		BNE	M_DR4MV_050	;
;
		STZ	<EWORK0
		LDA	#0000000000000000B
;
M_DR4MV_050	EQU	$
		STA	<EWORK2
;
		I8			; index 8 bit mode !!
;
		LDA	ENMOD0,X
		AND	#1111100111111111B
		ORA	<EWORK2
		STA	ENMOD0,X
		LDA	ENMOD2,X
		AND	#1111111111101111B
		ORA	<EWORK0
		STA	ENMOD2,X
;
		LDA	ENMODE,X
		CMP	#EMOVE
		BNE	M_DR4MV_100	; D_NRĂ@H
;					; No !!
		LDY	ECRSFG,X
		BEQ	M_DR4MV_200	; Փ˂@H( no:M_DR4MV_050 )
		BMI	M_DR4MV_200	; vC[ƏՓ˂@H
;					; No !!
		DEY
		LDA	ENMYNO,Y
		CMP	#SUIKT
		BNE	M_DR4MV_200	; G͐Z̎@H
;					; Yes !!
		LDA	ENWRK8,Y
		BNE	M_DR4MV_200	; Z̎̓vC[f@H
;					; Yes !!
		LDA	ENTIM2,X
		BNE	M_DR4MV_200	; D_NĂ@H
;					; No !!
		TYX
		JSL	>SHOT_EN_KILL
		BRA	M_DR4MV_150
;
M_DR4MV_100	EQU	$
		PLA
		PLY
		LDA	#EMOVE
		STA	ENMODE,X	; D_N[u[hZbg
		LDA	ENTIM2,X
		BNE	M_DR4MV_200	; D_NĂ@H
;					; No !!
		LDA	ENLIFE
		BEQ	M_DR4MV_150	; D_NCt[^[hOh@H
;					; No !!
		DEC	ENLIFE
		DEC	ENLIFE
;
M_DR4MV_150	EQU	$
		LDA	#0FD00H
		STA	ENYSPD,X	; xXs[hZbg
		LDA	#D4YR
		STA	<ENWRK0,X	; D_Nꃂ[hZbg
		LDA	#00080H
		STA	ENTIM2,X	; D_N^C}[Zbg
		LDA	#00020H
		STA	ENCLOR,X	; D_NvCIeB[Zbg
		LDA	#00075H
		JSL	>SOUND_3_ON	; []
		LDA	ENLIFE
		BEQ	M_DR4MV_200	; D_NCt[^[hOh@H
;					; No !!
		DEC	ENLIFE
		DEC	ENLIFE
;
M_DR4MV_200	EQU	$
;;;;;;;;		LDA	ENLIFE
;;;;;;;;		BEQ	M_DR4MV_210
;;;;;;;;;
;;;;;;;;		LDA	ENMOD1,X
;;;;;;;;		ORA	#00001H
;;;;;;;;		STA	ENMOD1,X
;;;;;;;;;
;;;;;;;;M_DR4MV_210	EQU	$
		M8			; memory 8 bit mode !!
;
		LDY	#004
		LDA	ENTIM2,X
		AND	#004
		BEQ	M_DR4MV_220	; D_NtbVO@H
;					; Yes !!
		LDY	#0FFH
;
M_DR4MV_220	EQU	$
		TYA
		STA	ENYUSN,X	; D_ND揇ʃZbg
;
		M16			; memory 16 bit mode !!
;
		LDA	ENDSXL,X
		CMP	#00010H
		BCS	M_DR4MV_250	; ʍ[I[o[@H
;					; Yes !!
		LDA	#00010H
		SEC
		SBC	ENDSXL,X
		CLC
		ADC	ENXPSL,X
		STA	ENXPSL,X	; wW␳
		BRA	M_DR4MV_300
;
M_DR4MV_250	EQU	$
		LDA	ENDSXL,X
		SEC
		SBC	#000E0H
		BMI	M_DR4MV_350	; ʉE[I[o[@H
;					; Yes !!
		STA	<EWORK0
		LDA	ENXPSL,X
		SEC
		SBC	<EWORK0
		STA	ENXPSL,X	; wW␳
;
M_DR4MV_300	EQU	$
		STZ	ENXSPD,X
;
M_DR4MV_350	EQU	$
		PEA	M_DR4MV_400-1
		LDA	<ENWRK0,X
		ASL	A
		TAY
		LDA	!M_DR4MV_ADR,Y
		STA	<EWORK0
		JMP	(EWORK0)
;
M_DR4MV_400	EQU	$
		LDA	DRSHOT
		BEQ	M_DR4MV_500	; D_NfĂ@H
;					; Yes !!
M_DR4MV_450	EQU	$
		RTL
;
M_DR4MV_500	EQU	$
		LDA	ENTIM1,X
		BNE	M_DR4MV_450	; p^[`FW@H
;					; Yes !!
		LDA	ENXSPD,X
		BNE	M_DR4MV_550	; D_NwXs[hNA[@H
;					; Yes !!
		LDA	#00013H
		STA	ENCHPT,X	; p^[mDZbg
		RTL
;
M_DR4MV_550	EQU	$
		BPL	M_DR4MV_560	; D_NwXs[h@H
;					; Yes !!
		EOR	#0FFFFH
		INC	A
;
M_DR4MV_560	EQU	$
		CMP	#00100H
		BCS	M_DR4MV_600	; ɂ@H
;					; Yes !!
		LDA	#00005
		CMP	DRPUSE
		BEQ	M_DR4MV_650	; ɂp^[tO@H
;					; Yes !!
		STA	DRPUSE		; ɂp^[tOZbg
		ASL	A
		TAY
		BRA	PAUSE_090
;
M_DR4MV_600	EQU	$
		LDA	DRPUSE
		BEQ	M_DR4MV_650	; p^[tO@H
;					; Yes !!
		STZ	DRPUSE
		LDY	#000
		BRA	PAUSE_090
;
M_DR4MV_650	EQU	$
		LDA	ENCBFG,X
		LSR	A
		BCS	PAUSE_050	; Wv@H
;					; Yes !!
		LDA	#00001
		STA	DRJUMP		; WvtOhnmh
;
PAUSE_050	EQU	$
		LDA	DRPUSE
		ASL	A
		TAY
		LDA	<ENCONT,X
		INC	A
		CMP	!PAUSED1,Y
		BNE	PAUSE_100	; p^[|C^[I[o[@H
;					; Yes !!
		STZ	DRJUMP
;
PAUSE_090	EQU	$
		LDA	!PAUSED0,Y
;
PAUSE_100	EQU	$
		STA	<ENCONT,X
		ASL	A
		TAY
		LDA	!DR4WLKD,Y
		STA	ENCHPT,X	; p^[mDZbg
		LDA	!DR4TIME,Y
		STA	ENTIM1,X	; p^[^C}[Zbg
;
		LDA	DRJUMP
		BEQ	PAUSE_250	; WvtOhnmh@H
;					; Yes !!
		LDA	ENCBFG,X
		LSR	A
		BCC	PAUSE_150	; Wv@H
;					; No !!
		STZ	DRJUMP
		STZ	DRPUSE
		LDY	#000
		LDA	!PAUSED0,Y
		STA	<ENCONT,X
		LDA	!DR4WLKD,Y
		STA	ENCHPT,X	; p^[mDZbg
		LDA	!DR4TIME,Y
		STA	ENTIM1,X	; p^[^C}[Zbg
		BRA	PAUSE_250
;
PAUSE_150	EQU	$
		LDY	#00000
		LDA	ENYPSL,X
		CMP	#0FD00H
		BCC	PAUSE_200	; Wvp^[P@H
;					; No !!
		INY
		CMP	#0FF00H
		BCC	PAUSE_200	; Wvp^[Q@H
;					; No !!
		INY
		CMP	#00000H
		BCC	PAUSE_200	; Wvp^[R@H
;					; No !!
		CMP	#00100H
		BCC	PAUSE_200	; Wvp^[R@H
;					; No !!
		INY
		CMP	#00300H
		BCC	PAUSE_200	; Wvp^[S@H
;					; No !!
		INY
;
PAUSE_200	EQU	$
		TYA
		CLC
		ADC	#0000CH
		STA	ENCHPT,X	; Wvp^[mDZbg
;
PAUSE_250	EQU	$
		RTL
;
;
M_DR4MV_ADR	EQU	$
		WORD	D4CHKMV		; D_NڕW`FbN
		WORD	D4SUIMV		; D_NڕWZ
D4PSR		WORD	D4PLSMV		; D_NvC[T[`
D4FIR		WORD	D4FIAMV		; D_Nf
D4YAR		WORD	D4YARMV		; D_Nꏈ
D4NOP		WORD	D4ONPMV		; D_N~܂Ă鏈
;
;
D4PS		EQU	(D4PSR-M_DR4MV_ADR)/2
D4FI		EQU	(D4FIR-M_DR4MV_ADR)/2
D4YR		EQU	(D4YAR-M_DR4MV_ADR)/2
D4NO		EQU	(D4NOP-M_DR4MV_ADR)/2
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	D4CHKMV ( D_NڕW`FbN )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
D4CHKMV		EQU	$
		LDA	DRBEAT
		BEQ	D4CHKMV_050	; D_NZHׂĂ@H
;					; Yes !!
		LDA	#D4PS
		STA	<ENWRK0,X	; vC[T[`[hZbg
;
D4ONPMV		EQU	$
		RTS
;
D4CHKMV_050	EQU	$
		TXA
		STA	R1
		M_CHIP	M_ITEM_SEARCH
;
		LDX	<ENINDX
		LDA	R1
		BMI	D4CHKMV_250	; ZoĂ@H
;					; Yes !!
		STA	<ENWRK2,X	; ZCfbNXmDZbg
		TAY
		LDA	ENCBFG,X
		LSR	A
		BCC	D4CHKMV_250	; D_NWv@H
;					; No !!
		LDA	ENXPSL,Y
		STA	R1		; ڕWwWZbg
		LDA	ENYPSL,Y
		STA	R2		; ڕWxWZbg
		LDA	ENXPSL,X
		STA	R3		; ݂wWZbg
		LDA	ENYPSL,X
		STA	R4		; ݂xWZbg
		LDA	#00200H
		STA	R6		; ړXs[hZbg
;
		M_CHIP	SEARCH_SPEED
;
		LDX	<ENINDX
		LDA	R2
		BPL	D4CHKMV_150	; Wv@H
;					; Yes !!
		LDY	<ENWRK2,X
		LDA	ENYPSL,X
		SEC
		SBC	ENYPSL,Y
		CMP	#00020H
		BCS	D4CHKMV_100	; hʂ̉@H
;					; Yes !!
		LDA	#0FC00H
		BRA	D4CHKMV_140
;
D4CHKMV_100	EQU	$
		LDA	#0FA80H
;
D4CHKMV_140	EQU	$
		STA	ENYSPD,X	; CjVWvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
D4CHKMV_150	EQU	$
		LDY	#002
		LDA	R1
		STA	ENXSPD,X
		BPL	D4CHKMV_200	; ZE@H
;					; No !!
		LDY	#000
;
D4CHKMV_200	EQU	$
		TYA
		STA	ENMUKI,X	; D_NZbg
		INC	<ENWRK0,X
;
D4CHKMV_250	EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	D4SUIMV ( D_NڕWZ )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
D4SUIMV		EQU	$
		LDA	BERFLG
		BEQ	D4SUIMV_050	; vC[oĂ@H
;					; Yes !!
		LDA	EATSPF
		BEQ	D4SUIMV_050	; 킩fĂ@H
;					; Yes !!
		LDA	<EWORK2
		BEQ	D4SUIMV_050	; D_NBĂ@H
;					; No !!
		LDA	ENCBFG,X
		LSR	A
		BCC	D4SUIMV_050	; Wv@H
;					; No !!
		LDA	ENYPSL,X
		SEC
		SBC	PLYPSL
		CLC
		ADC	#00010H
		CMP	#00031H
		BCS	D4SUIMV_050	; vC[ƗĂ@H
;					; Yes !!
		LDA	#0FA80H
		STA	ENYSPD,X	; xXs[hZbg`
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
		RTS
;
D4SUIMV_050	EQU	$
		LDY	ECRSFG,X
		BEQ	D4SUIMV_150	; Փ˂@H ( No:D4SUIMV_100 )
		BMI	D4SUIMV_150	; vC[ƏՓ˂@H
;					; Yes !!
		DEY
;;;;;;;;		TYA
;;;;;;;;		CMP	<ENWRK2,X
;;;;;;;;		BNE	D4SUIMV_150	; Z@H
;;;;;;;;;					; Yes !!
		LDA	ENMODE,Y
		CMP	#EMOVE
		BNE	D4SUIMV_150	; ʏ폈@H
;					; Yes !!
		LDA	ENMYNO,Y
		CMP	#SUIKA
		BEQ	D4SUIMV_080	; Z̎@H
;					; No !!
		CMP	#FIRE0
		BNE	D4SUIMV_150	; ̐Z@H
;					; Yes !!
D4SUIMV_080	EQU	$
		STA	DRBEAT		; ZmDZbg
		LDA	#00003
		STA	DRBCNT		; fo񐔃Zbg
		TYX
		JSL	>ENCLEAR	; ZNA[
		LDX	<ENINDX
		INC	<ENWRK0,X
		RTS
;
D4SUIMV_100	EQU	$
		LDA	FRCNT
		AND	#00008
		LSR	A
		LSR	A
		LSR	A
		ORA	#0000AH
		STA	ENCHPT,X	; LLp^[mDZbg
		RTS
;
D4SUIMV_150	EQU	$
		TXA
		STA	R1
		M_CHIP	M_ITEM_SEARCH
;
		LDX	<ENINDX
		LDA	R1
		BMI	D4SUIMV_100	; ZoĂ@H
;					; Yes !!
		STA	<ENWRK2,X	; ZCfbNXmDZbg
;
;;;;;;;;		LDY	<ENWRK2,X
;;;;;;;;		LDA	ENMODE,Y
;;;;;;;;		BNE	D4SUIMV_180	; ZoĂ@H
;;;;;;;;;					; No !!
;;;;;;;;		STZ	<ENWRK0,X
;;;;;;;;		BRA	D4SUIMV_100
;;;;;;;;;
;;;;;;;;D4SUIMV_180	EQU	$
		LDA	<ENWRK4,X
		BEQ	D4SUIMV_200	; D_NƐZقڂwW@H
;					; Yes !!
		LDY	ENWRKA,X
		BNE	D4SUIMV_170	; @H
;					; Yes !!
		LDA	ENXPSL,X
		CMP	#00010H
		BCS	D4SUIMV_190	; [ɂ@H
;					; Yes !!
		LDA	#00002H
		STA	ENWRKA,X
		STA	ENMUKI,X
		BRA	D4SUIMV_190
;
D4SUIMV_170	EQU	$
		LDA	ENXPSL,X
		CMP	#000E0H
		BCC	D4SUIMV_190
;
		STZ	ENWRKA,X
		STZ	ENMUKI,X
;
D4SUIMV_190	EQU	$
		JMP	D4SUIMV_450
;
D4SUIMV_200	EQU	$
		LDA	ENCBFG,X
		LSR	A
		BCS	D4SUIMV_250	; Wv@H
;					; Yes !!
		JMP	D4SUIMV_500
;
D4SUIMV_250	EQU	$
		LDY	#000
		LDA	ENXPSL,X
		SEC
		SBC	#00080H
		BPL	D4SUIMV_300
;
		LDY	#002
;
D4SUIMV_300	EQU	$
		TYA
		STA	ENWRKA,X
		STA	ENMUKI,X
;
		LDY	<ENWRK2,X
		LDA	ENXPSL,X
		SEC
		SBC	ENXPSL,Y
		CLC
		ADC	#00010H
		CMP	#00021H
		BCS	D4SUIMV_500	; wWقړ@H
;					; Yes !!
		LDA	ENYPSL,X
		STA	ENWRKC,X
		SEC
		SBC	ENYPSL,Y
		CLC
		ADC	#00020H
		LDY	#001
		CMP	#00031H
		BCC	D4SUIMV_500	; xWقړ@H
;					; No !!
		BMI	D4SUIMV_400	; Zɂ@H
;					; Yes !!
		CMP	#000A1H
		BCS	D4SUIMV_500
;
		LDA	#0FE00H
		LDY	ENXPSL,X
		CPY	#031H
		BCS	D4SUIMV_350	; D_P̕@H
;					; Yes !!
		LDA	#00200H
;
D4SUIMV_350	EQU	$
		STA	ENWRKC,X
		LDA	ENXPSL,X
		SEC
		SBC	#00010H
		CLC
		ADC	#00008H
		STA	R8		; af`FbNwWZbg
		LDA	ENYPSL,X
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDY	#002
		LDA	R5
		BEQ	D4SUIMV_400	; Ƀhʂ@H
;					; Yes !!
		LDA	#0FC00H
		STA	ENYSPD,X	; WvXs[hZbg
		PHY
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
		PLY
;
D4SUIMV_400	EQU	$
		TYA
		STA	<ENWRK4,X
;
D4SUIMV_450	EQU	$
		LDA	<ENWRK4,X
		ASL	A
		TAY
		LDA	!D4SUIMV_ADR-2,Y
		STA	<EWORK0
		JMP	(EWORK0)
;
D4SUIMV_500	EQU	$
		LDY	<ENWRK2,X
		LDA	ENXPSL,Y
		STA	R1		; ڕWwWZbg
		LDA	ENYPSL,Y
		STA	R2		; ڕWxWZbg
		LDA	ENXPSL,X
		STA	R3		; ݂wWZbg
		LDA	ENYPSL,X
		STA	R4		; ݂xWZbg
		LDA	#00200H
		STA	R6		; ړXs[hZbg
;
		M_CHIP	SEARCH_SPEED
;
		LDX	<ENINDX
		LDY	#002
		LDA	R1
		STA	ENXSPD,X
		BPL	D4SUIMV_550	; E@H
;					; Yes !!
		LDY	#000
;
D4SUIMV_550	EQU	$
		TYA
		STA	ENMUKI,X	; D_NZbg
;
		LDA	ENCBFG,X
		LSR	A
		BCC	D4SUIMV_650	; D_NWv@H
;					; No !!
		LDA	ENCBFG,X
		AND	!BITDATA,Y
		BEQ	D4SUIMV_600	; ɓĂ@H
;					; Yes !!
		LDA	#0FC00H
		STA	ENYSPD,X	; CjVWvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
D4SUIMV_600	EQU	$
		LDA	R2
		BPL	D4SUIMV_650	; Zɂ@H
;					; No !!
		LDY	<ENWRK2,X
		LDA	ENYPSL,X
		SEC
		SBC	ENYPSL,Y
		CMP	#00020H
		BCC	D4SUIMV_650	; hʂ̉@H
;					; Yes !!
		LDA	#0FA80H
		STA	ENYSPD,X	; CjVWvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
D4SUIMV_650	EQU	$
		RTS
;
;
D4SUIMV_ADR	EQU	$
		WORD	M4DWCHK		; ZɂƂ̏
		WORD	M4UPCHK		; ZɂƂ̏
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	M4DWCHK ( ZɂƂ̏ )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M4DWXSP		EQU	$
		WORD	0FE00H,00200H
;
M4BGXPS		EQU	$
		WORD	0FFF0H,00010H
;
;
M4DWCHK		EQU	$
		LDY	ENWRKA,X
		LDA	!M4DWXSP,Y
		STA	ENXSPD,X	; wXs[hZbg
		LDA	ENCBFG,X
		LSR	A
		BCC	M4DWCHK_050	; Wv@H
;					; yes !!
		LDA	ENXPSL,X
		CLC
		ADC	!M4BGXPS,Y
		STA	R8		; af`FbNwWZbg
		LDA	ENYPSL,X
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDA	R5
		BEQ	M4DWCHK_050	; hʂ@H
;					; Yes !!
		LDA	#0FC00H
		STA	ENYSPD,X	; WvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
M4DWCHK_050	EQU	$
		LDA	ENYPSL,X
		SEC
		SBC	ENWRKC,X
		CMP	#00028H
		BCC	M4DWCHK_100	; xW͈͂z@H
;					; Yes !!
		STZ	<ENWRK4,X
;
M4DWCHK_100	EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	M4UPCHK ( ZɂƂ̏ )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M4UPCHK		EQU	$
		LDA	ENWRKC,X
		STA	ENXSPD,X	; wXs[hZbg
		STZ	ENMUKI,X	; D_NZbg
		LDY	ENMUKI,X
		LDA	ENCBFG,X
		LSR	A
		BCC	M4UPCHK_050	; Wv@H
;					; yes !!
		LDA	ENXPSL,X
		CLC
		ADC	!M4BGXPS,Y
		STA	R8		; af`FbNwWZbg
		LDA	ENYPSL,X
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDA	R5
		BEQ	M4UPCHK_050	; hʂ@H
;					; Yes !!
		LDA	#0FA80H
		STA	ENYSPD,X	; WvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
M4UPCHK_050	EQU	$
		LDY	<ENWRK2,X
		LDA	ENXPSL,X
		SEC
		SBC	ENXPSL,Y
		CLC
		ADC	#00010H
		CMP	#00021H
		BCC	M4UPCHK_100	; wW͈͂z@H
;					; Yes !!
		STZ	ENXSPD,X	; wXs[hNA[
		LDA	#00002
		STA	ENMUKI,X	; D_NZbg
		STZ	<ENWRK4,X
;
M4UPCHK_100	EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	D4PLSMV ( D_NvC[T[` )		x
;x									x
;x		initial ENWRK4 <-- Z̎				x
;x									x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
HONOOPS		EQU	$
		WORD	0FFECH,00014H,0FFF7H,00009H
;
NEXTPOS		EQU	$
		WORD	0FFF0H,00010H,00000H,00000H
;
BITDATA		EQU	$
		WORD	0000000000001000B,0000000000000100B
;
PLSHXSP		EQU	$
		WORD	0FF00H,00100H
;
;
D4PLSMV		EQU	$
		LDA	ENWRK6,X
		BNE	D4PLSMV_150	; vC[Ƃ̈ʒu֌W`FbN@H
;					; Yes !!
		LDY	#002
		LDA	ENYPSL,X
		SEC
		SBC	PLYPSL
		CLC
		ADC	#00010H
		BMI	D4PLSMV_050	; vC[@H
;					; No !!
		LDY	#004
		CMP	#00031H
		BCS	D4PLSMV_050	; vC[艺@H
;					; No !!
		LDY	#006
;
D4PLSMV_050	EQU	$
		TYA
		STA	ENWRK6,X
		LDY	#002
		LDA	ENXPSL,X
		CMP	#00020H
		BCC	D4PLSMV_100	; D_P̕@H
;					; No !!
		LDY	#000
		CMP	#000D0H
		BCS	D4PLSMV_100	; D_PE̕@H
;					; No !!
		LDY	PLCMKI
;;;;;;;;		LDA	PLCMKI
;;;;;;;;		EOR	#00002
;;;;;;;;		TAY
;
D4PLSMV_100	EQU	$
		TYA
		STA	ENWRK8,X	; vC[̌Zbg
		BRA	D4PLSMV_250
;
D4PLSMV_150	EQU	$
		LDA	ENXPSL,X
		CMP	#000E0H
		BCS	D4PLSMV_200	; D_NE[@H
;					; No !!
		CMP	#00012H
		BCS	D4PLSMV_250	; D_N[@H
;					; Yes !!
D4PLSMV_200	EQU	$
		LDA	ENWRK8,X
		EOR	#00002
		STA	ENWRK8,X
;
D4PLSMV_250	EQU	$
		PEA	D4PLSMV_300-1
		LDY	ENWRK6,X
		LDA	!D4PLSMV_ADR,Y
		STA	<EWORK0
		JMP	(EWORK0)
;
D4PLSMV_300	EQU	$
		LDA	ENWRK6,X
		BEQ	D4PLSMV_400
;
		LDY	#000
		LDA	ENXSPD,X
		BMI	D4PLSMV_350	; D_NE@H
;					; Yes !!
		LDY	#002
;
D4PLSMV_350	EQU	$
		TYA
		STA	ENMUKI,X	; D_NZbg
;
D4PLSMV_400	EQU	$
		RTS
;
;
D4PLSMV_ADR	EQU	$-2
		WORD	D4PLSUP		; vC[ɂ鎞̏
		WORD	D4PLSDW		; vC[艺ɂ鎞̏
		WORD	D4PLSON		;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	D4PLSUP ( vC[ɂ鎞̏ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
D4PLSUP		EQU	$
		LDY	ENWRK8,X
		LDA	ENCBFG,X
		AND	!BITDATA,Y
		BNE	D4PLSUP_050	; Ƀhʂ@H
;					; No !!
		LDA	!PLSHXSP,Y
		STA	ENXSPD,X	; wXs[hZbg
;
D4PLSUP_050	EQU	$
		LDA	ENCBFG,X
		LSR	A
		BCC	D4PLSUP_200	; Wv@H
;					; Yes !!
		LDA	ENXPSL,X
		CLC
		ADC	!M4BGXPS,Y
		CLC
		ADC	#00008
		STA	R8		; af`FbNwWZbg
		LDA	ENYPSL,X
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDA	R5
		BEQ	D4PLSUP_100	; Ƀhʂ@H
;					; Yes !!
		LDA	#0FC00H
		STA	ENYSPD,X	; WvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
D4PLSUP_100	EQU	$
		LDA	ENYPSL,X
		SEC
		SBC	PLYPSL
		CLC
		ADC	#00010H
		CMP	#00031H
		BCC	D4PLSUP_150	; vC[ƍ@H
;					; Yes !!
		BMI	D4PLSUP_200
;
D4PLSUP_150	EQU	$
		STZ	ENWRK6,X
		STZ	ENYSPD,X
		STZ	ENXSPD,X
;
D4PLSUP_200	EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	D4PLSDW ( vC[艺ɂ鎞̏ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
D4PLSDW		EQU	$
		LDY	ENWRK8,X
		LDA	ENCBFG,X
		AND	!BITDATA,Y
		BNE	D4PLSDW_050	; Ƀhʂ@H
;					; No !!
		LDA	!PLSHXSP,Y
		STA	ENXSPD,X	; wXs[hZbg
;
D4PLSDW_050	EQU	$
		LDA	ENCBFG,X
		LSR	A
		BCC	D4PLSDW_150	; Wv@H
;					; No !!
		LDA	ENYPSL,X
		SEC
		SBC	PLYPSL
		CLC
		ADC	#00010H
		BMI	D4PLSDW_100	; vC[@H
;					; No !!
		CMP	#00031H
		BCS	D4PLSDW_200	; vC[ƍ@H
;					; Yes !!
D4PLSDW_100	EQU	$
		STZ	ENWRK6,X
		STZ	ENYSPD,X
		STZ	ENXSPD,X
;
D4PLSDW_150	EQU	$
		RTS
;
D4PLSDW_200	EQU	$
		LDA	ENXPSL,X
		CLC
		ADC	#00008
		STA	<EWORK4
		STA	R8		; af`FbNwWZbg
		LDA	ENYPSL,X
		SEC
		SBC	#00040H
		STA	<EWORK6
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDA	R5
		BNE	D4PLSDW_300	; Ƀhʂ@H
;					; No !!
		LDA	<EWORK4
		STA	R8		; af`FbNwWZbg
		LDA	<EWORK6
		CLC
		ADC	#00010H
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDA	R7
		AND	#MD
		BNE	D4PLSDW_250	; ɏ@H
;					; No !!
		LDA	<EWORK4
		STA	R8		; af`FbNwWZbg
		LDA	<EWORK6
		CLC
		ADC	#00020H
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDA	R7
		AND	#MD
		BEQ	D4PLSDW_300	; ɏ@H
;					; Yes !!
D4PLSDW_250	EQU	$
		LDA	#0FA80H
		STA	ENYSPD,X	; WvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
		STZ	ENXSPD,X
		RTS
;
D4PLSDW_300	EQU	$
		LDY	ENWRK8,X
		LDA	ENXPSL,X
		CLC
		ADC	!M4BGXPS,Y
		CLC
		ADC	#00008
		STA	R8		; af`FbNwWZbg
		LDA	ENYPSL,X
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDA	R5
		BEQ	D4PLSDW_350	; Ƀhʂ@H
;					; Yes !!
		LDA	#0FC00H
		STA	ENYSPD,X	; WvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
D4PLSDW_350	EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	D4PLSON ( vC[Ɠɂ鎞̏ )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
D4PLSON		EQU	$
		LDA	ENTIM0,X
		BNE	D4PLSON_050	; ~܂Ă@H
;					; No !!
		LDY	ENWRK8,X
		LDA	ENCBFG,X
		AND	!BITDATA,Y
		BNE	D4PLSON_030	; Ƀhʂ@H
;					; No !!
		LDA	!PLSHXSP,Y
		STA	ENXSPD,X	; wXs[hZbg
;
D4PLSON_030	EQU	$
		LDA	ENCBFG,X
		LSR	A
		BCC	D4PLSON_050	; Wv@H
;					; No !!
		LDA	ENXPSL,X
		CLC
		ADC	!M4BGXPS,Y
		CLC
		ADC	#00008
		STA	R8		; af`FbNwWZbg
		LDA	ENYPSL,X
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
;
		LDX	<ENINDX
		LDA	R5
		BEQ	D4PLSON_100	; Ƀhʂ@H
;					; Yes !!
		LDA	#0FC00H
		STA	ENYSPD,X	; WvXs[hZbg
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
;
D4PLSON_050	EQU	$
		RTS
;
D4PLSON_100	EQU	$
		LDA	ENYPSL,X
		SEC
		SBC	PLYPSL
		CLC
		ADC	#00010H
		CMP	#00031H
		BCS	D4PLSON_250	; x˒@H
;					; Yes !!
		LDA	PLFLSH
		BNE	D4PLSON_050	; vC[Ă@H
;					; No !!
		STZ	ENYSPD,X	; WvXs[hNA[
		LDA	PLXPSL
		SEC
		SBC	ENXPSL,X
		CLC
		ADC	#00060H
		CMP	#000C1H
		BCS	D4PLSON_050	; w˒@H
;					; Yes !!
		STZ	ENXSPD,X	; wXs[hNA[
		LDA	<EWORK2
		BEQ	D4PLSON_300	; D_NBĂ@H
;					; Yes !!
		INC	<ENWRK0,X	; D_N[u[hZbg
		LDY	#002
		LDA	PLXPSL
		CMP	ENXPSL,X
		BCS	D4PLSON_150	; vC[E@H
;					; No !!
		LDY	#000
;
D4PLSON_150	EQU	$
		TYA
		STA	ENMUKI,X	; D_NZbg
		LDA	#00030
		STA	ENTIM0,X	; D_Nfp^[^C}[Zbg
;
SHOTINT		EQU	$
		STZ	ENCHPT,X	; D_Nfp^[mDZbg
		LDA	ENYPSL,X
		CLC
		ADC	#00002H
		STA	ENWRKA,X	; CjVwWZbg
		LDY	#000
		LDA	DRBEAT
		CMP	#FIRE0
		BEQ	D4PLSON_200	; f@H
;					; No !!
		LDY	#004
;
D4PLSON_200	EQU	$
		TYA
		ORA	ENMUKI,X
		TAY
		LDA	ENXPSL,X
		CLC
		ADC	!HONOOPS,Y
		STA	ENWRKC,X	; CjVxWZbg
		LDA	!NEXTPOS,Y
		STA	ENWRK8,X	; WJEgf[^[Zbg
		LDA	#00030H
		STA	ENCLOR,X	; D_NvCIeB[Zbg
		LDY	#006
		STY	HAKCNT		; VbgJE^[Zbg
		LDA	#00001
		STA	DRSHOT		; D_NVbgtOZbg
		STZ	ENWRK6,X
		RTS
;
D4PLSON_250	EQU	$
		STZ	ENWRK6,X
		STZ	ENYSPD,X
		STZ	ENXSPD,X
		RTS
;
D4PLSON_300	EQU	$
		LDY	PLCMKI
		LDA	!PLSHXSP,Y
		STA	ENXSPD,X	; wXs[hZbg
		LDA	<RANDM0
		TAY
		CPY	#0F8H
		BCC	D4PLSON_350	; ~܂@H
;					; Yes !!
		TYA
		AND	#0003FH
		STA	ENTIM0,X	; ~܂Ă鎞ԃZbg
		STZ	ENXSPD,X	; wXs[hNA[
;
D4PLSON_350	EQU	$
		RTS
;
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;;x		JSR	D4PLSMV ( D_NvC[T[` )		x
;;;;;;;;;x									x
;;;;;;;;;x		initial ENWRK4 <-- Z̎				x
;;;;;;;;;x									x
;;;;;;;;;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;;;;;;HONOOPS		EQU	$
;;;;;;;;		WORD	0FFE5H,00012H,0FFF7H,0000EH
;;;;;;;;;
;;;;;;;;NEXTPOS		EQU	$
;;;;;;;;		WORD	0FFF0H,00010H,00000H,00000H
;;;;;;;;;
;;;;;;;;BITDATA		EQU	$
;;;;;;;;		WORD	0000000000001000B,0000000000000100B
;;;;;;;;;
;;;;;;;;;
;;;;;;;;D4PLSMV		EQU	$
;;;;;;;;		LDA	<EWORK2
;;;;;;;;		BEQ	D4PLSMV_200	; D_NBĂ@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	PLXPSL
;;;;;;;;		SEC
;;;;;;;;		SBC	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00050H
;;;;;;;;		CMP	#000A1H
;;;;;;;;		BCS	D4PLSMV_200	; w˒@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	ENXSPD,X
;;;;;;;;;
;;;;;;;;		LDA	PLYPSL
;;;;;;;;		SEC
;;;;;;;;		SBC	ENYPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00010H
;;;;;;;;		CMP	#00021H
;;;;;;;;		BCS	D4PLSMV_200	; x˒@H
;;;;;;;;;					; Yes !!
;;;;;;;;		STZ	ENXSPD,X
;;;;;;;;		INC	<ENWRK0,X
;;;;;;;;		LDY	#002
;;;;;;;;		LDA	PLXPSL
;;;;;;;;		CMP	ENXPSL,X
;;;;;;;;		BCS	D4PLSMV_050	; vC[E@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	#000
;;;;;;;;;
;;;;;;;;D4PLSMV_050	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENMUKI,X	; D_NZbg
;;;;;;;;		STZ	ENCHPT,X	; D_Nfp^[mDZbg
;;;;;;;;		LDA	#00004H
;;;;;;;;		STA	ENTIM0,X	; D_Nfp^[^C}[Zbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00002H
;;;;;;;;		STA	ENWRKA,X	; CjVwWZbg
;;;;;;;;		LDY	#000
;;;;;;;;		LDA	DRBEAT
;;;;;;;;		CMP	#FIRE0
;;;;;;;;		BEQ	D4PLSMV_100	; f@H
;;;;;;;;;					; No !!
;;;;;;;;		LDY	#004
;;;;;;;;;
;;;;;;;;D4PLSMV_100	EQU	$
;;;;;;;;		TYA
;;;;;;;;		ORA	ENMUKI,X
;;;;;;;;		TAY
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		CLC
;;;;;;;;		ADC	!HONOOPS,Y
;;;;;;;;		STA	ENWRKC,X	; CjVxWZbg
;;;;;;;;		LDA	!NEXTPOS,Y
;;;;;;;;		STA	ENWRK8,X	; WJEgf[^[Zbg
;;;;;;;;		LDA	#00030H
;;;;;;;;		STA	ENCLOR,X	; D_NvCIeB[Zbg
;;;;;;;;		LDY	#006
;;;;;;;;		STY	HAKCNT
;;;;;;;;		LDA	#00001
;;;;;;;;		STA	DRSHOT
;;;;;;;;;
;;;;;;;;D4PLSMV_150	EQU	$
;;;;;;;;		RTS
;;;;;;;;;
;;;;;;;;D4PLSMV_200	EQU	$
;;;;;;;;		LDA	PLXPSL
;;;;;;;;		STA	R1		; ڕWwWZbg
;;;;;;;;		LDA	PLYPSL
;;;;;;;;		STA	R2		; ڕWxWZbg
;;;;;;;;		LDA	ENXPSL,X
;;;;;;;;		STA	R3		; ݂wWZbg
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		STA	R4		; ݂xWZbg
;;;;;;;;		LDA	#00200H
;;;;;;;;		STA	R6		; ړXs[hZbg
;;;;;;;;;
;;;;;;;;		M_CHIP	SEARCH_SPEED
;;;;;;;;;
;;;;;;;;		LDX	<ENINDX
;;;;;;;;		LDY	#002
;;;;;;;;		LDA	R1
;;;;;;;;		STA	ENXSPD,X
;;;;;;;;		BEQ	D4PLSMV_300
;;;;;;;;		BPL	D4PLSMV_250
;;;;;;;;;
;;;;;;;;		LDY	#000
;;;;;;;;;
;;;;;;;;D4PLSMV_250	EQU	$
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		LSR	A
;;;;;;;;		BCC	D4PLSMV_350	; D_NWv@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENCBFG,X
;;;;;;;;		AND	!BITDATA,Y
;;;;;;;;		BEQ	D4PLSMV_300	; Ă@H
;;;;;;;;;					; Yes !!
;;;;;;;;		LDA	#0FC00H
;;;;;;;;		STA	ENYSPD,X	; CjVWvXs[hZbg
;;;;;;;;		BRA	D4PLSMV_350
;;;;;;;;;
;;;;;;;;D4PLSMV_300	EQU	$
;;;;;;;;		LDA	R2
;;;;;;;;		BPL	D4PLSMV_350	; vC[ɂ@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	ENYPSL,X
;;;;;;;;		SEC
;;;;;;;;		SBC	PLYPSL
;;;;;;;;		CMP	#00020H
;;;;;;;;		BCC	D4PLSMV_350	; vC[Ƃقړʒu@H
;;;;;;;;;					; No !!
;;;;;;;;		LDA	#0FA80H
;;;;;;;;		STA	ENYSPD,X	; CjVWvXs[hZbg
;;;;;;;;;
;;;;;;;;D4PLSMV_350	EQU	$
;;;;;;;;		TYA
;;;;;;;;		STA	ENMUKI,X	; D_NZbg
;;;;;;;;		RTS
;;;;;;;;;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	D4FIAMV ( D_Nf )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
D4FIAMV		EQU	$
		LDA	ENTIM0,X
		BNE	D4FIAMV_050	; fo@H
;					; Yes !!
		LDA	HAKCNT
		BNE	D4FIAMV_100	; fo@H
;					; No !!
		LDA	#D4PS
		DEC	DRBCNT
		BNE	D4FIAMV_030	; ̒ɂ܂@H
;					; No !!
		STZ	DRBEAT
		LDA	#00000
;
D4FIAMV_030	EQU	$
		STA	<ENWRK0,X
		STZ	DRPUSE
		LDY	#000
		LDA	!PAUSED0,Y
		STA	<ENCONT,X
		LDA	!DR4WLKD,Y
		STA	ENCHPT,X	; p^[mDZbg
		LDA	!DR4TIME,Y
		STA	ENTIM1,X	; p^[^C}[Zbg
		LDA	#00020H
		STA	ENCLOR,X	; D_NvCIeB[Zbg
		STZ	DRSHOT
;
D4FIAMV_050	EQU	$
		RTS
;
D4FIAMV_100	EQU	$
		LDA	#00001
		STA	ENCHPT,X
		LDA	DRBEAT
		CMP	#SUIKA
		BNE	D4FIAMV_200	; Z̎@H
;					; Yes !!
		LDY	ENMUKI,X
		LDA	ENYPSL,X
		CLC
		ADC	#00002
		STA	ENWRKA,X
		LDA	ENXPSL,X
		CLC
		ADC	!HONOOPS+4,Y
		STA	ENWRKC,X
		LDA	#00006
		STA	ENTIM0,X	; ɏo^C}[Zbg
		LDA	#SUIKT
		JSL	>ENINSR_I
		BCC	D4FIAMV_190	; Zbg@H
;					; Yes !!
		LDA	ENWRKA,X
		STA	ENYPSL,Y	; xWZbg
		LDA	ENWRKC,X
		STA	ENXPSL,Y	; wWZbg
		LDA	#00001
		STA	ENSHOT,Y	; VbgtOZbg
		STA	ENWRK8,Y	; GłtOhnmh
		LDA	ENMUKI,X
		STA	ENMUKI,Y	; Zbg
		TAX
		LDA	#0FC00H
		CPX	#000
		BEQ	D4FIAMV_150	; E@H
;					; Yes !!
		LDA	#00400H
;
D4FIAMV_150	EQU	$
		STA	ENXSPD,Y	; wXs[hZbg
		LDA	#00045H
		JSL	>SOUND_3_ON	; []
		LDX	<ENINDX
;
D4FIAMV_190	EQU	$
		BRA	D4FIAMV_300
;
D4FIAMV_200	EQU	$
		LDA	#FIREX
		JSL	>ENINSR_I
		BCC	D4FIAMV_300	; Zbg@H
;					; Yes !!
		LDA	ENWRKA,X
		STA	ENYPSL,Y	; xWZbg
		LDA	ENWRKC,X
		STA	ENXPSL,Y	; wWZbg
		LDA	#00001
		STA	ENWRK8,Y	; GłtOhnmh
		LDA	ENMUKI,X
		STA	ENMUKI,Y	; Zbg
		LDA	#00004*4
		STA	ENTIM0,Y	; ̏^C}[Zbg
		LDA	ENCLOR,Y
		AND	#000F1H
		ORA	#00006H
		STA	ENCLOR,Y	; ̃J[Zbg
;
		M8			; memory 8 bit mode !!
;
		LDA	#029H
		STA	ENCHRB,Y	; LN^[mDoNZbg
;
		M16			; memory 16 bit mode !!
;
;;;;;;;;		LDA	#0001AH
;;;;;;;;		STA	SOUND0		; []
		LDA	#00002
		STA	ENTIM0,X	; ɏo^C}[Zbg
		LDA	ENWRKC,X
		STA	R8		; af`FbNwWZbg
		LDA	ENWRKA,X
;;;;;;;;		CLC
;;;;;;;;		ADC	#00008H
		STA	R0		; af`FbNxWZbg
		M_CHIPR M_BGUNIT_READ
		LDX	<ENINDX
		LDA	R5
		BEQ	D4FIAMV_250	; afƂĂ@H
;					; Yes !!
		STZ	HAKCNT		; foJEgNA[
		RTS
;
D4FIAMV_250	EQU	$
		LDA	ENWRKC,X
		CLC
		ADC	ENWRK8,X
		STA	ENWRKC,X	; ɏowWZbg
;
D4FIAMV_300	EQU	$
		DEC	HAKCNT		; foJEg_E
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	D4YARMV ( D_Nꏈ )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
D4YARMV		EQU	$
		LDA	ENCBFG,X
		LSR	A
		BCC	D4YARMV_150	; Wv@H
;					; Yes !!
		LDA	ENTIM3,X
		BNE	D4YARMV_050	; ^C}[CjV@H
;					; Yes !!
		STZ	ENXSPD,X
		LDA	#00020H
		STA	ENTIM3,X	; ^C}[Zbg
;
D4YARMV_050	EQU	$
		AND	#00008
		LSR	A
		LSR	A
		LSR	A
		ORA	#00008
		STA	ENCHPT,X	; p^[mDZbg
		LDA	ENTIM3,X
		CMP	#00001
		BNE	D4YARMV_150	; ꏈI@H
;					; Yes !!
		STZ	<ENWRK0,X
		LDA	#00002
		STA	ENCHPT,X	; p^[mDZbg
		LDA	DRSHOT
		BEQ	D4YARMV_150	; D_NfĂ@H
;					; Yes !!
		LDA	HAKCNT
		BEQ	D4YARMV_100	; cʂ@H
;					; Yes !!
		CMP	#00006
		BEQ	D4YARMV_090
;
		LDA	DRBEAT
		CMP	#FIRE0
		BEQ	D4YARMV_100	; fĂ@H
;					; No !!
D4YARMV_090	EQU	$
		LDA	#D4FI
		STA	<ENWRK0,X
		LDA	#00030H
		STA	ENCLOR,X	; D_NvCIeB[Zbg
		LDA	#00001
		STA	ENCHPT,X	; p^[mDZbg
		RTS
;
D4YARMV_100	EQU	$
		STZ	DRSHOT
		LDA	DRBCNT
		BEQ	D4YARMV_150	; f񐔎cĂ@H
;					; Yes !!
		DEC	DRBCNT
		BNE	D4YARMV_150	; f񐔁@O@H
;					; Yes !!
		STZ	DRBEAT
;
D4YARMV_150	EQU	$
		RTS
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_SUIIN		( ~jQ[ZoCjV )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_SUIIN		EQU	$
		LDY	2137H
		LDY	213FH
		LDA	213CH
		CLC
		ADC	<RANDM0
		STA	<RANDM0
		AND	#000FFH
		STA	ENTIM0,X
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_SU0MV		( ~jQ[Zo[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_SUIMV		EQU	$
		LDA	<ENWRK0,X
		ASL	A
		TAY
		LDA	!M_SUIMV_ADR,Y
		STA	<EWORK0
		JMP	(EWORK0)
;
;
M_SUIMV_ADR	EQU	$
		WORD	SYOTCHK		; Zo`FbN
		WORD	SUIKMOV		; Zo
		WORD	SUIKCHK		; ZȂ`FbN
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SYOTCHK ( Zo`FbN )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SUIKADT		EQU	$
		WORD	SUIKA,SUIKA,FIRE0,SUIKA,SUIKA,FIRE0,SUIKA,SUIKA
;
;
SYOTCHK		EQU	$
		LDA	ENTIM0,X
		BNE	SYOTCHK_100	; Zo@H
;					; Yes !!
		LDA	SUIKCT
		CMP	#00002
		BEQ	SYOTCHK_050	; ZQoĂ@H
;					; No !!
		INC	TANECT
		LDA	RANDM0
;;;;;;;;		AND	#0000EH
		AND	#00007H
		ASL	A
		TAY
		LDA	!SUIKADT,Y
		TAY
		CMP	#SUIKA
		BEQ	SYOTCHK_030	; Z̎̕@H
;					; No !!
		LDA	TANECT
		CMP	#00004
		BCC	SYOTCHK_020	; Z̉o@H
;					; Yes !!
		STZ	TANECT
		BRA	SYOTCHK_030
;
SYOTCHK_020	EQU	$
		LDY	#SUIKA
;
SYOTCHK_030	EQU	$
		TYA
		JSL	>ENINSR		; ZZbg
;
		LDA	ENMOD0,Y
		AND	#1111100111111111B
		ORA	#0000001000000000B
		STA	ENMOD0,Y
		LDA	ENXPSL,X
		STA	ENXPSL,Y	; ZCjVwWZbg
		LDA	ENYPSL,X
		STA	ENYPSL,Y	; ZCjVxWZbg
		TYA
		STA	<ENWRK2,X	; ZCfbNXmDZbg
		LDA	#00010H
		STA	<ENCONT,X	; Zړ^C}[Zbg
		INC	SUIKCT		; ZJE^[CN
		INC	<ENWRK0,X
;
SYOTCHK_050	EQU	$
		LDA	#00100H
		STA	ENTIM0,X	; Zo^C}[Zbg
;
SYOTCHK_100	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SUIKMOV ( Zo )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SUIKMOV		EQU	$
		LDY	<ENWRK2,X
		LDA	ENYPSL,Y
		DEC	A
		STA	ENYPSL,Y
		DEC	<ENCONT,X
		BNE	SUIKMOV_050	; ZړI@H
;					; Yes !!
		INC	<ENWRK0,X
;
SUIKMOV_050	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SUIKCHK ( ZȂ`FbN )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SUIKCHK		EQU	$
		LDY	<ENWRK2,X
		LDA	ENMODE,Y
		BNE	SUIKCHK_050	; Z@H
;					; No !!
		STZ	<ENWRK0,X
		LDA	#00100H
		STA	ENTIM0,X	; Zo^C}[Zbg
		DEC	SUIKCT
;
SUIKCHK_050	EQU	$
		RTL
;
;
;
;========================================================================
		MEM8
		IDX8
;
		DPAGE	WORK0
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		MINIINT1_7	( ~jQ[ΓfCjVZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MINIINT1_7	EQU	$
;-------------- XN[l NA -----------------------------
		M16			; memory 16 bit mode !!
;
		STZ	<SCCH1
		STZ	<SCCV1
		STZ	<SCCH2
		STZ	<SCCV2
		STZ	<SCCH3
		STZ	<SCCV3
;
		LDY	#069H
		STY	!BG1SCF
		STY	2107H
		LDY	#039H
		STY	!BG2SCF
		STY	2108H
		LDY	#009H
		STY	BGMODE
		STY	2105H
		LDY	#000
		STY	HD420C
		STY	SUBADF
;
;-------------- Q[ CjV -----------------------------------
		M16			; memory 16 bit mode !!
;
		LDA	#000B0H
		STA	PLYPSL		; player Y initial set !!
		LDA	#00030H
		STA	PLXPSL		; player X initial set !!
		STZ	UNBUFAD
		STA	TIMER
		STZ	MISS_P		; ~X|CgNA[
;
		LDA	#00008H
		STA	PLLIFE		; vC[@Ct[^[Zbg
		STA	ENLIFE		; D_N@Ct[^[Zbg
		LDA	#00001H
		STA	MN2PLY		; lvCtOZbg
		LDA	#0FFFFH
		STA	OBJCHR_BNK
		STA	OBJCHR_BNK+2
		STA	OBJCHR_BNK+4
		STZ	UNBUFAD
;
		LDA	#MINICORS01
		STA	<BGDTADR
		LDA	#00001
		STA	BG1TYP
;
		LDA	#M_DR5
		JSL	>ENINSR_I
;
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#00030H
		STA	ENXPSL,Y
		LDA	#00050H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#000B0H
		STA	ENXPSL,Y
		LDA	#00040H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#00020H
		STA	ENXPSL,Y
		LDA	#00090H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#000A0H
		STA	ENXPSL,Y
		LDA	#00080H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#00090H
		STA	ENXPSL,Y
		LDA	#000C0H
		STA	ENYPSL,Y
		LDA	#M_SUI
		JSL	>ENINSR_I
		LDA	#000E0H
		STA	ENXPSL,Y
		LDA	#000C0H
		STA	ENYPSL,Y
;
		JSL	>ENEMY_IN
;
		MEM8
		IDX8
;
		LDA	#BANK MINICORS01
		STA	<BGDTADR+2
		JSL	>UNITST_SUB
;
		RTS
;
;
;****************************************************************
;*								*
;*		~j Q[					*
;*								*
;****************************************************************
MINIMOV1_7	EQU	$
		JSL	>OAMDXCLR	; OAM clear sub !!
		LDA	#00030H
		STA	PLPRIO		; vC[vCIeB[Zbg
		JSL	>ENCSET_DM	; enemy char set sub !!
		JSL	>PLCSET		; player char set sub !!
;
		STZ	SPECIAL_P
;
		LDA	PLLIFE
		BEQ	MINIMOV1_7_050	; vC[̕@H
;					; No !!
		LDA	ENLIFE
		BNE	MINIMOV1_7_200	; D_N̕@H
;					; Yes !!
MINIMOV1_7_050	EQU	$
;;;;;;;;		M16			; memory 16 bit mode !!
;;;;;;;;;
;;;;;;;;		DEC	ENDTIM
;;;;;;;;		BNE	MINIMOV1_7_250	; sI@H
;;;;;;;;;					; Yes !!
;;;;K;;;;		LDY	#MINIT
;;;;K;;;;		INC	MINIMD
;;;;K;;;;		LDA	MINIMD
;;;;K;;;;		CMP	#003
;;;;K;;;;		BNE	MINIMOV1_7_150	; ~jQ[@RI@H
;;;;;;;;;					; Yes !!
;;;;;;;;		JSL	>BACK_GAME
		LDA	#001H
		STA	ITGTFG
		JSR	MIN2PWN_END
		BRA	MINIMOV1_7_250
;;;;K;;;;		LDY	#HMPIN
;
MINIMOV1_7_150	EQU	$
;;;;K;;;;		STY	MODENO		; C[hZbg
;;;;K;;;;		BRA	MINIMOV1_7_250
;
		MEM8
MINIMOV1_7_200	EQU	$
		JSL	>PLAYER		; player move sub !!
;
		LDA	!MSGMOD
		BNE	MINIMOV1_7_250
		JSL	>ENEMY_IN	; enemy move sub !!
		JSR	METERS3		; [^[Zbg[`
;
MINIMOV1_7_250	EQU	$
		M16			; memory 16 bit mode !!
;
		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;
		M8			; memory 8 bit mode !!
;
		RTS
;
;
;
;------------------------------------------------------------------------
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_DR5IN		( D_P@Ń{b@CjV )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_DR5IN		EQU	$
		LDA	#000C0H
		STA	ENYPSL,X	; D_NxWCjVZbg
		LDA	#000C0H
		STA	ENXPSL,X	; D_NWCjVZbg
		LDA	#00004H
		STA	ENTIM0,X	; D_Np^[^C}[Zbg
		LDA	#00030H
		STA	ENCLOR,X	; vCIeB[Zbg
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_DR5MV		( D_P@Ń{b@[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
XSPDATA		EQU	$
		WORD	0FFF0H,00010H,0FF00H,00100H
;
XSPDGEN		EQU	$
		WORD	00040H,0FFC0H
;
XSPDMXD		EQU	$
		WORD	0FDC0H,00240H,0FDC0H,00240H
;
XPOSDAT		EQU	$
		WORD	00010H,000E0H,00010H,000E0H
;
CHAKUPT		EQU	$-4
		WORD	00011H,00012H
;
;
M_DR5MV		EQU	$
		LDA	ENMODE,X
		CMP	#EMOVE
		BNE	M_DR5MV_100	; D_NRĂ@H
;					; No !!
		LDY	ECRSFG,X
		BEQ	M_DR5MV_200	; Փ˂@H( no:M_DR4MV_050 )
		BMI	M_DR5MV_200	; vC[ƏՓ˂@H
;					; No !!
		DEY
		LDA	ENTIM2,X
		BNE	M_DR5MV_200	; D_NĂ@H
;					; No !!
		LDA	ENMYNO,Y
		CMP	#SUIKT
		BNE	M_DR5MV_200	; G͐Z̎@H
;					; Yes !!
		LDA	ENWRK8,Y
		BNE	M_DR5MV_200	; Z̎̓vC[f@H
;					; Yes !!
		TYX
		JSL	>SHOT_EN_KILL
		BRA	M_DR5MV_150
;
M_DR5MV_100	EQU	$
		PLA
		PLY
		LDA	#EMOVE
		STA	ENMODE,X	; D_N[u[hZbg
		LDA	ENTIM2,X
		BNE	M_DR5MV_200	; D_NĂ@H
;					; No !!
		LDA	ENLIFE
		BEQ	M_DR5MV_150	; D_NCt[^[hOh@H
;					; No !!
		DEC	ENLIFE
		DEC	ENLIFE
;
M_DR5MV_150	EQU	$
		LDA	#0FD00H
		STA	ENYSPD,X	; xXs[hZbg
		LDA	#00080H
		STA	ENTIM2,X	; D_N^C}[Zbg
		LDA	#00075H
		JSL	>SOUND_3_ON	; []
		LDA	ENLIFE
		BEQ	M_DR5MV_200	; D_NCt[^[hOh@H
;					; No !!
		DEC	ENLIFE
		DEC	ENLIFE
;
M_DR5MV_200	EQU	$
		LDA	#0000000000010000B
		LDY	ENTIM2,X
		BEQ	M_DR5MV_210
;
		LDA	#0000000000000000B
;
M_DR5MV_210	EQU	$
		STA	<EWORK0
;
		LDA	ENMOD2,X
		AND	#1111111111101111B
		ORA	<EWORK0
		STA	ENMOD2,X
;
;;;;;;;;		LDA	ENLIFE
;;;;;;;;		BEQ	M_DR5MV_210
;;;;;;;;;
;;;;;;;;		LDA	ENMOD1,X
;;;;;;;;		ORA	#00001H
;;;;;;;;		STA	ENMOD1,X
;;;;;;;;;
;;;;;;;;M_DR5MV_210	EQU	$
		M8			; memory 8 bit mode !!
;
		LDY	#004
		LDA	ENTIM2,X
		AND	#004
		BEQ	M_DR5MV_220	; D_NtbVO@H
;					; Yes !!
		LDY	#0FFH
;
M_DR5MV_220	EQU	$
		TYA
		STA	ENYUSN,X	; D_ND揇ʃZbg
;
		M16			; memory 16 bit mode !!
;
		LDY	ENMUKI,X
		BNE	M_DR5MV_250	; @H
;					; Yes !!
		LDA	ENDSXL,X
		CMP	#00010H
		BCS	SUIKCRS		; ʍ[I[o[@H
;					; Yes !!
		LDA	#00010H
		SEC
		SBC	ENDSXL,X
		CLC
		ADC	ENXPSL,X
		STA	ENXPSL,X	; wW␳
		BRA	M_DR5MV_300
;
M_DR5MV_250	EQU	$
		LDA	ENDSXL,X
		SEC
		SBC	#000E0H
		BMI	SUIKCRS		; ʉE[I[o[@H
;					; Yes !!
		STA	<EWORK0
		LDA	ENXPSL,X
		SEC
		SBC	<EWORK0
		STA	ENXPSL,X	; wW␳
;
M_DR5MV_300	EQU	$
		STZ	ENXSPD,X
;;;;;;;;		JMP	M_DR5MV_550
;
;-------------- ZƂ̏Փ˃`FbN --------------
SUIKCRS		EQU	$
		LDA	DRBEAT
		BNE	SHOTMOV		; ̒ɓĂ@H
;					; No !!
		LDY	ECRSFG,X
		BEQ	FYSEMOV		; Փ˂ĂȂ@H ( Yes:M_DR5MV_350 )
		BMI	FYSEMOV		; vC[ƏՓ˂Ă@H
;					; No !!
		DEY
		LDA	ENMODE,Y
		CMP	#EMOVE
		BNE	SHOTMOV		; ʏ폈@H
;					; Yes !!
		LDA	ENMYNO,Y
		CMP	#SUIKA
		BEQ	SUIKCRS_050	; ̐Z@H
;					; No !!
		CMP	#FIRE0
		BNE	FYSEMOV		; ̐Z@H
;					; Yes !!
SUIKCRS_050	EQU	$
		STA	DRBEAT		; ZmDZbg
		LDA	#00003
		STA	DRBCNT
		TYX
		JSL	>ENCLEAR	; ZNA[
;
;-------------- Vbg --------------
SHOTMOV		EQU	$
		LDA	DRSHOT
		BNE	SHOTMOV_050	; D_NfĂ@H
;					; No !!
		LDA	KEYB2-1
		ASL	A
		BPL	FYSEMOV		; x{^@H
;					; Yes !!
		JSR	SHOTINT		; VbgCjVZbg
;
SHOTMOV_050	EQU	$
		JSR	D4FIAMV		; Vbg[u
		LDA	#00030H
		STA	ENCLOR,X	; vCIeB[Zbg
		BRA	DR5JUMP
;
;-------------- Ă邩`FbN --------------
FYSEMOV		EQU	$
		LDA	DRJUMP
		BNE	DR5JUMP		; Wv@H
;					; No !!
		LDA	KEYB1
		AND	#00004H
		BEQ	DR5JUMP		; L[Ă@H
;					; Yes !!
		LDA	DRFUSE
		BNE	FYSEMOV_050	; Ă邩@H
;					; No !!
		LDA	#00004
		STA	EWIDEY,X	; x`FbNZbg
		STA	DRFUSE		; tOZbg
;
FYSEMOV_050	EQU	$
		JMP	M_DR5MV_600
;
;-------------- WṽCjVXs[hZbg --------------
DR5JUMP		EQU	$
		LDA	#00006
		STA	EWIDEY,X	; x`FbNZbg
		STZ	DRFUSE		; tONA[
		LDY	#000C0H
		LDA	KEYB1-1
		BPL	DR5JUMP_050	; a{^Ă@H
;					; Yes !!
		LDY	#00020H
		LDA	DRJUMP
		BNE	DR5JUMP_050	; D_NWv@H
;					; No !!
		LDA	ENCBFG,X
		LSR	A
		BCC	DR5JUMP_050	; nʂɂĂ@H
;					; Yes !!
		LDA	KEYB2-1
		BPL	DR5JUMP_050	; a{^@H
;					; Yes !!
		LDA	#0FC00H
		STA	ENYSPD,X	; WvXs[hZbg
		PHY
		LDA	#00038H
		JSL	>SOUND_3_ON	; []
		PLY
		LDA	#00001
		STA	DRJUMP		; D_NWvtOZbg
		STA	ENTIM0,X
;
DR5JUMP_050	EQU	$
		TYA
		STA	ENGPOW,X	; d͉Zf[^[Zbg
;
;-------------- wXs[hZbg --------------
DR5XSPD		EQU	$
		LDA	KEYB1
		AND	#00003H
		BEQ	M_DR5MV_600	; EL[Ă@H
;					; Yes !!
		AND	#00001
		ASL	A
		TAY
		EOR	ENMUKI,X
		BEQ	DR5XSPD_100	; ɃL[Ă@H
;					; No !!
		LDA	ENXSPD,X
		CPY	#002
		BEQ	DR5XSPD_050
;
		EOR	#0FFFFH
		INC	A
;
DR5XSPD_050	EQU	$
		CMP	#000C0H
		BPL	DR5XSPD_100	; wXs[h@O@H
;					; Yes !!
		TYA
		ORA	#00004
		TAY
;
DR5XSPD_100	EQU	$
		LDA	ENXPSL,X
		CMP	!XPOSDAT,Y
		BEQ	M_DR5MV_600	; [@H
;					; No !!
		LDA	ENXSPD,X
		CLC
		ADC	!XSPDATA,Y
		CMP	!XSPDMXD,Y
		BEQ	DR5XSPD_150	; wXs[hI[o[@H
;					; No !!
		STA	ENXSPD,X	; wXs[h
;
DR5XSPD_150	EQU	$
		LDY	#000
		LDA	ENXSPD,X
		BEQ	M_DR5MV_650
		BMI	DR5XSPD_200	; @H
;					; No !!
		LDY	#002
;
DR5XSPD_200	EQU	$
		TYA
		STA	ENMUKI,X	; D_NZbg
		BRA	M_DR5MV_650
;
;-------------- wXs[hZbg --------------
M_DR5MV_600	EQU	$
		LDA	DRJUMP
		BNE	M_DR5MV_650	; D_NWv@H
;					; No !!
		LDY	ENMUKI,X
		LDA	ENXSPD,X
		BEQ	M_DR5MV_650	; wXs[h@O@H
;					; No !!
		CLC
		ADC	!XSPDGEN,Y
		STA	<EWORK0
		EOR	ENXSPD,X
		BPL	M_DR5MV_630	; wXs[hI[o[@H
;					; Yes !!
		STZ	<EWORK0
;
M_DR5MV_630	EQU	$
		LDA	<EWORK0
		STA	ENXSPD,X	; wXs[h
;
;-------------- p^[mDZbg --------------
M_DR5MV_650	EQU	$
		LDA	DRSHOT
		BNE	M_DR5MV_END	; D_NfĂ@H
;					; No !!
		LDA	DRJUMP
		BEQ	M_DR5MV_800	; D_NWv@H
;					; Yes !!
		LDA	ENCBFG,X
		LSR	A
		BCC	M_DR5MV_700	; nʂɂĂ@H
;					; Yes !!
		LDA	ENTIM0,X
		BNE	M_DR5MV_END	; p^[^C}[@O@H
;					; Yes !!
		LDY	#000
		LDA	DRJUMP
		INC	A
		AND	#00003H
		STA	DRJUMP
		BEQ	M_DR5MV_750	; np^[mDZbgI@H
;					; No !!
		ASL	A
		TAY
		LDA	!CHAKUPT,Y
		TAY
		BRA	M_DR5MV_900
;
M_DR5MV_700	EQU	$
		LDY	#0000EH
		LDA	ENYSPD,X
		CLC
		ADC	#00100H
		CMP	#00200H
		BCC	M_DR5MV_750	; Wvt߁@H
;					; No !!
		LDY	#0000CH
		LDA	ENYSPD,X
		BMI	M_DR5MV_750	; Wv㏸@H
;					; No !!
		LDY	#00010H
;
M_DR5MV_750	EQU	$
		BRA	M_DR5MV_900
;
M_DR5MV_800	EQU	$
		LDA	DRFUSE
		BEQ	M_DR5MV_820	; Ă@H
;					; Yes !!
		LDY	#0001BH		; Ăp^[mDZbg
		BRA	M_DR5MV_900
;
M_DR5MV_820	EQU	$
		LDY	#000
		LDA	ENXSPD,X
		BEQ	M_DR5MV_900	; D_NĂ@H
;					; Yes !!
		LDA	ENTIM0,X
		BNE	M_DR5MV_END	; p^[^C}[@O@H
;					; Yes !!
		LDA	#00004
		STA	ENTIM0,X	; p^[^C}[Zbg
		INC	<ENCONT,X
		LDA	<ENCONT,X
		ASL	A
		TAY
		CPY	#DR4FIRD-DR4WLKD
		BNE	M_DR5MV_850	; p^[|C^[I[o[@H
;					; Yes !!
		LDY	#000
		STZ	<ENCONT,X	; p^[|C^[NA[
;
M_DR5MV_850	EQU	$
		LDA	!DR4WLKD,Y
		TAY
;
M_DR5MV_900	EQU	$
		TYA
		STA	ENCHPT,X	; p^[mDZbg
;
M_DR5MV_END	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_ITMIN		( lACeCjV )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

 IF  PAL  ;**** PAL Ή [1995/08/02] *****************************
EG_M_ITM_CHRADR EQU	$		;[LNGG_SL]
		WORD	CHR88+0054H	;[0]
		WORD	CHRPAL3+2054H	;[1]
		WORD	CHRPAL3+2070H	;[2]
 ENDIF	  ;**** PAL Ή [1995/08/02] *****************************

;
M_ITM_CHRADR	EQU	$-2		;[ENWRK0,X]
ITST10		WORD	CHR88+0070H	;[1] X^[PO
ITST20		WORD	CHR88+2070H	;[2] X^[QO
		WORD	CHR88+008CH	;[3] onvubN
ITTMGO		WORD	CHR88+0054H	;[4] ^}S
		WORD	CHR88+00A8H	;[5] ዾ
ITHATE		WORD	CHR88+001CH	;[6] H_
ITKNM0		WORD	CHR88+208CH	;[7] ؂̂݁i΁j
ITKNM1		WORD	CHR88+208CH	;[8] ؂̂݁ij
ITKNM2		WORD	CHR88+20A8H	;[9] ؂̂݁iԁj
;
IT1UP0		WORD	CHR88+2000H	;[A] Pto
		WORD	CHR88+201CH	;[B] Qto
		WORD	CHR88+2038H	;[C] POto
;
;
ITST1		EQU	(ITST10-M_ITM_CHRADR)/2
ITST2		EQU	(ITST20-M_ITM_CHRADR)/2
ITTMG		EQU	(ITTMGO-M_ITM_CHRADR)/2
ITHAT		EQU	(ITHATE-M_ITM_CHRADR)/2
ITKN0		EQU	(ITKNM0-M_ITM_CHRADR)/2
ITKN1		EQU	(ITKNM1-M_ITM_CHRADR)/2
ITKN2		EQU	(ITKNM2-M_ITM_CHRADR)/2
IT1UP		EQU	(IT1UP0-M_ITM_CHRADR)/2
;
;
M_ITEM_COLDT	EQU	$-2
		WORD	COL_ADDRESS+MAP_AICON_COL
		WORD	COL_ADDRESS+BNS_ICN_COLSB
		WORD	COL_ADDRESS+MAP_AICON_COL
		WORD	COL_ADDRESS+MAP_AICON_COL
		WORD	COL_ADDRESS+MAP_AICON_COL
		WORD	COL_ADDRESS+MAP_AICON_COL
		WORD	COL_ADDRESS+MAP_AICON_COL+((1*0FH)*2)
		WORD	COL_ADDRESS+MAP_AICON_COL
		WORD	COL_ADDRESS+BNS_ICN_COLSB
;
		WORD	COL_ADDRESS+MAP_AICON_COL
		WORD	COL_ADDRESS+MAP_AICON_COL
		WORD	COL_ADDRESS+MAP_AICON_COL
;
M_ITMIN		EQU	$
		JSL	>TROBJ_SR_4x4_CL
;
		LDA	<ENWRK0,X
		ASL	A
		TAY
		LDA	!M_ITEM_COLDT,Y
		STA	<EWORK0
;
		PHB
		LDY	#BANK COL_ADDRESS
		PHY
		PLB
;
		LDX	#01CH
		TXY
;
M_ITMIN_050	EQU	$
		LDA	(<EWORK0),Y
		STA	>DATACOL+(0E1H*2),X
		DEY
		DEY
		DEX
		DEX
		BPL	M_ITMIN_050
;
		PLB
;
		LDX	ENINDX
		LDA	#00020H		;{Zbg
		STA	<ENWRK2,X
;
;------------------------------------------------------------------------
;-		lACeLN^[Zbg				-
;------------------------------------------------------------------------
M_ITM_CHRSET	EQU	$
;;		BRA	SKP_X0
		LDA	<ENWRK2,X
		STA	R3		;(R3) <-- {
		LDA	<ENWRK4,X
		STA	R2		;(R2) <-- ]pxiO`eej
		LDA	<ENWRK0,X
		ASL	A
		TAY
		LDA	!M_ITM_CHRADR,Y
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] **********************
		STA	R14		;(R14) <-- LN^[AhXikCgj
		LDA	#BANK CHR88

 ELSE	  ;**** PAL Ή [1995/08/02] *****************************
		CMP	#CHR88+0054H
		BNE	SKP_XF0		;^}SetkkH ( no:SKP_XF0 )
		LDY	LNGG_SL
		BEQ	SKP_XF0		;pH ( yes:SKP_XF0 )
		TYA
		ASL	A
		TAY
		LDA	!EG_M_ITM_CHRADR,Y
		STA	R14		;(R14) <-- LN^[AhXikCgj
		LDA	#BANK CHRPAL3
		BRA	SKP_XF1
;
SKP_XF0		EQU	$
		STA	R14		;(R14) <-- LN^[AhXikCgj
		LDA	#BANK CHR88
SKP_XF1		EQU	$

 ENDIF
		STA	R13		;(R13) <--	   h		(aj
		LDY	ENTROB,X
		TYX
		LDA	>TROBJ_PLOT_X,X
		STA	R0		;(R0)  <-- rbg}bvWQw
		LDA	>TROBJ_PLOT_Y,X
		STA	R1		;(R1)  <--	  h	   Qx
		M_CHIP	C_32_X_ROTE
;
		INC	OBM7WF		;]LN^[]tOhnmh
;
		BRA	SKP_XXX
;
SKP_X0
		LDA	<ENWRK2,X
		LDA	#0100H						;
		STA	R11		;(R11) <-- {
		LDA	<ENWRK4,X
		LDA	#0000H						;
		STA	R14		;(R14) <-- ]pxiO`eej
		LDA	<ENWRK0,X
		ASL	A
		TAY
		LDA	!M_ITM_CHRADR,Y
 IF  JPN | NES ;**** { or NES Ή [1995/08/02] **********************
		STA	R14		;(R14) <-- LN^[AhXikCgj
		LDA	#BANK CHR88

 ELSE	  ;**** PAL Ή [1995/08/02] *****************************
		CMP	#CHR88+0054H
		BNE	SKP_X10		;^}SetkkH ( no:SKP_X10 )
		LDY	LNGG_SL
		BEQ	SKP_X10		;pH ( yes:SKP_X10 )
		TYA
		ASL	A
		TAY
		LDA	!EG_M_ITM_CHRADR,Y
		STA	R14		;(R14) <-- LN^[AhXikCgj
		LDA	#BANK CHRPAL3
		BRA	SKP_X11
;
SKP_X10		EQU	$
		STA	R14		;(R14) <-- LN^[AhXikCgj
		LDA	#BANK CHR88
SKP_X11		EQU	$

 ENDIF
		STA	R12		;(R12) <-- LN^[AhXikCgj
		LDA	#BANK CHR88
		STA	R13		;(R13) <--	   h		(aj
		LDY	ENTROB,X
		TYX
		LDA	>TROBJ_PLOT_X,X
		STA	R3		;(R3)  <-- rbg}bvWQw
		LDA	>TROBJ_PLOT_Y,X
		STA	R2		;(R2)  <--	  h	   Qw
		LDA	#010H
		STA	R8		;(R8)  <-- SQw
		STA	R9		;(R9)  <--   hQx
		M_CHIP	C_32_X_ROTE_X
;
		INC	OBM7WF		;]LN^[]tOhnmh
;
		LDX	<ENINDX
;
SKP_XXX
		LDX	<ENINDX
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_ITMMV		( lACe[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_ITMMV		EQU	$
		PEA	M_ITMMV_050
		LDA	ENCONT,X
		ASL	A
		TAY
		LDA	!M_ITMMV_TBL,Y
		STA	<EWORK0
		JMP	(EWORK0)
;
M_ITMMV_050	EQU	$-1
		JSL	>M_ITM_CHRSET
		JSL	>BSCLR_KIRA_SET ; 炫ʃZbg
;
;------------------------------------------------------------------------
;-		n`lZbg						-
;------------------------------------------------------------------------
		JSL	>TROBJ_OAM_4x4
;
		RTL
;
;
M_ITMMV_TBL	EQU	$
		WORD	ITMZOOM		; ACeY[Abv
		WORD	ITMCROS		; ACeՓˏ
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ITMZOOM ( ACeY[Abv )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ITMZOOM		EQU	$
		LDA	<ENWRK2,X
		CLC
		ADC	#00002H
		STA	<ENWRK2,X	; {Zbg
		CMP	#00100H
		BNE	ITMZOOM_050	; gI@H
;					; Yes !!
		INC	ENCONT,X
;
ITMZOOM_050	EQU	$
		LDA	<ENWRK4,X
		CLC
		ADC	#00003H
		AND	#000FFH
		STA	<ENWRK4,X	; pxZbg
;
ITMZOOM_END	EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	ITMCROS ( ACeՓˏ )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ITMCROS		EQU	$
		LDY	ECRSFG,X
		BEQ	ITMCROS_END
		BPL	ITMCROS_END	; vC[Ɠ@H
;					; Yes !!
		LDA	#00036H
		JSL	>SOUND_3_ON	; [S]
		JSL	>FUSNB_SET_2	; LLeʃZbg
		JSL	>ENCLEAR	; GNA[Tu[`
		INC	ITGTFG
		LDA	ENWRK0,X
		CMP	#IT1UP
		BCS	ITMCROS_END2	; vC[to@H
;					; No !!
		JSL	>ITEMINPUT_L	; ACeZbgTu[`
		LDX	<ENINDX
;;;;;;;;		JSL	>ENRAMCLR	; GNA[Tu[`
;
ITMCROS_END	EQU	$
		JMP	ITMZOOM_050
;
ITMCROS_END2	EQU	$
		SBC	#IT1UP
		INC	A
		CLC
		ADC	!PLCONT
		STA	!PLCONT
		JMP	ITMZOOM_050
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
		END
;
;
;
;
