;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: BG data file					*
;*	file name	: ys_w58.asm					*
;*									*
;************************************************************************
;
;
		include		ys_ename.h
;
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_play >------------------------------------------------
		EXT	PO_NORMAL,PO_DK_O_R,PO_DK_O_L,PO_DK_O_D,PO_DK_O_U
		EXT	PO_DK_I_R,PO_DK_I_L,PO_DK_I_D,PO_DK_I_U,PO_BSQ_M7
;
;-------------< ys_mapdt >-----------------------------------------------
		EXT	CORS_57_00,CORS_57_01,CORS_57_02,CORS_57_03
		EXT	CORS_57_04,CORS_57_05,CORS_57_06
;
		EXT	CORS_MIN0,CORS_MIN1,CORS_MIN2,CORS_MIN3
		EXT	CORS_MIN4,CORS_MIN5,CORS_MIN6,CORS_MIN7
		EXT	CORS_MIN8,CORS_MIN9
;
;
;************************************************************************
;*									*
;*		data							*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_16	GROUP	W58_data
W58_data	SECT	REL
;
;************************************************************************
;*		BG course data						*
;************************************************************************
;
;------------------------------------------------------------------------
;-		"58qca00.dat" (1995/06/24 00:24:27)						-
;------------------------------------------------------------------------
		GLB	BGDT_57_00
BGDT_57_00	EQU	$
		HEX	0E,B6,54,A4,58,68,00,00,91,00,E2,56,9D,06,E2,55
		HEX	D3,04,00,55,93,C2,00,56,66,C2,00,56,8E,C1,00,56
		HEX	4D,C3,00,54,C8,85,E2,56,A6,05,E2,55,BA,06,E2,56
		HEX	80,08,00,55,7A,C2,00,56,40,C2,00,65,00,FF,00,66
		HEX	00,FF,CD,17,EC,09,F3,CC,27,09,F7,FA,CC,28,06,FB
		HEX	FD,CD,28,08,07,FA,46,18,C3,05,00,00,58,91,84,00
		HEX	67,00,FF,00,59,F0,FF,00,46,00,FD,00,45,FF,FD,00
		HEX	44,FF,FD,00,43,FF,FD,00,57,91,87,D1,48,60,16,00
		HEX	58,D0,9D,D1,37,DB,07,D1,38,A3,06,D1,37,3E,06,00
		HEX	48,13,9D,00,47,5B,9D,00,37,AE,9D,00,38,13,9D,00
		HEX	27,CF,9D,79,18,93,FB,CB,18,C3,02,00,44,18,C5,01
		HEX	00,CD,27,0A,01,FA,D1,27,4F,07,D1,28,C3,04,48,17
		HEX	00,1F,01,48,17,B7,01,00,48,18,B7,01,00,48,17,2C
		HEX	01,00,48,18,22,01,00,48,17,3B,01,00,44,17,9B,01
		HEX	01,53,17,7B,06,15,48,86,02,15,47,87,02,6C,17,C8
		HEX	00,2C,6C,18,C7,00,2C,48,18,24,0B,06,48,18,95,0A
		HEX	00,48,18,33,01,00,48,17,20,0B,06,48,17,90,0A,00
		HEX	48,17,A6,02,00,48,18,A7,02,00,D9,53,B0,18,68,46
		HEX	FE,01,00,68,56,17,01,00,68,56,01,01,00,68,55,4B
		HEX	01,00,68,55,84,01,00,FF
;-------------- next go to data -----------------------------------------
		HEX	17		;door pos
		BYTE	CORS_57_01	;corse data table pointer
		HEX	04,56		;player X,Y pos
		BYTE	PO_NORMAL	;player mode
		HEX	FF
;
;
 IF  BUG01 & PAL ;**** oO Ή [1995/8/02] ****************************
;------------------------------------------------------------------------
;-		"581a-pal.dat" (1995/08/02 16:24:18)			-
;------------------------------------------------------------------------
		GLB	BGDT_57_01
BGDT_57_01	EQU	$
		HEX	0B,66,54,A4,58,70,00,00,91,20,46,50,8A,02,01,CC
		HEX	51,A0,F6,F5,46,41,66,02,00,CC,41,6A,FC,FC,45,41
		HEX	10,05,05,44,51,71,09,03,CC,41,80,FE,FA,45,40,76
		HEX	07,07,44,50,0F,08,06,CD,42,D0,05,F5,CD,42,BA,01
		HEX	F7,CC,42,B9,FD,F7,53,41,8F,03,53,42,73,02,53,42
		HEX	99,02,53,42,76,02,54,42,74,FD,02,44,41,2B,04,05
		HEX	CC,42,BD,FF,F7,CD,42,BE,03,F7,CC,43,B9,FF,F7,CD
		HEX	43,B6,01,F7,CC,43,B5,FD,F7,CD,43,BA,03,F7,CC,54
		HEX	4A,F4,EE,53,42,9C,02,53,42,7F,02,53,43,72,02,53
		HEX	43,7B,02,53,43,7E,02,48,44,26,0A,06,48,44,75,01
		HEX	00,48,44,64,01,00,48,44,53,03,00,48,44,42,03,00
		HEX	44,45,53,07,08,45,45,8B,04,07,CD,45,8B,06,F6,48
		HEX	44,31,05,00,48,44,20,05,00,48,44,97,03,00,CD,54
		HEX	7E,03,FA,CD,55,65,05,F8,CC,55,64,FE,F8,46,46,75
		HEX	02,02,CD,55,4F,03,FD,CD,56,12,03,FD,CD,46,E5,03
		HEX	FB,48,45,21,06,06,54,43,7F,04,02,53,44,A1,02,54
		HEX	44,A2,04,02,53,44,D4,02,54,44,D5,04,02,CC,54,7D
		HEX	FE,FA,48,45,68,01,00,48,45,58,02,00,48,45,77,01
		HEX	00,45,44,DB,03,04,46,54,0F,03,00,48,44,99,0B,02
		HEX	48,44,CA,09,00,48,45,95,01,00,48,45,A4,01,00,53
		HEX	54,07,02,54,54,08,04,02,A7,43,EE,00,00,44,16,11
		HEX	07,04,44,14,1A,16,04,44,13,0D,0C,0B,45,01,35,05
		HEX	05,CC,01,84,FB,FA,46,10,F1,07,00,54,10,C8,FD,01
		HEX	53,10,C8,03,CC,10,B7,FB,FA,46,10,9B,07,03,44,11
		HEX	26,2A,0A,48,42,0E,07,01,48,43,0A,15,01,44,43,06
		HEX	03,01,44,42,0A,03,01,48,42,0A,03,00,48,43,06,03
		HEX	00,53,43,95,02,55,43,73,03,03,53,43,98,02,55,43
		HEX	7C,FD,03,55,42,77,03,02,55,43,70,FD,02,44,26,C0
		HEX	02,00,46,35,39,01,00,44,26,D0,02,07,45,35,2B,01
		HEX	02,CC,25,CA,FE,FC,45,35,27,01,02,44,35,57,11,08
		HEX	48,40,06,23,01,45,50,56,03,04,44,50,6D,01,03,44
		HEX	50,8F,01,01,44,41,49,01,01,44,41,96,03,07,44,40
		HEX	FF,05,01,CC,40,F5,FD,F3,48,40,02,04,01,48,51,24
		HEX	05,00,48,51,02,07,00,44,40,26,03,03,53,50,08,03
		HEX	55,40,E6,03,03,53,50,2A,02,48,41,F1,08,00,48,51
		HEX	13,06,00,CC,50,F8,FA,FA,CD,51,F7,07,F9,48,41,8A
		HEX	05,0E,CD,50,DF,02,FD,CC,50,DE,FF,FD,45,50,23,02
		HEX	06,48,50,30,02,04,54,50,86,03,02,48,50,80,05,00
		HEX	53,50,85,02,CD,50,F9,03,FB,CC,51,F6,FC,FA,48,40
		HEX	C0,05,06,48,40,11,01,00,48,40,00,01,09,48,40,91
		HEX	01,00,48,40,A0,01,01,53,51,63,02,48,51,35,04,03
		HEX	CB,51,7A,04,00,44,51,79,02,00,CC,55,4E,FD,FB,46
		HEX	46,C0,01,02,46,46,A2,02,03,53,46,D3,02,53,54,3A
		HEX	02,48,40,22,01,00,48,40,31,01,00,53,40,C5,03,54
		HEX	40,C7,03,01,48,44,A8,01,00,CC,46,66,FC,FB,44,36
		HEX	E2,03,02,44,46,57,00,01,53,46,85,03,55,46,86,FD
		HEX	03,53,45,B9,05,55,45,BA,FC,04,53,35,FF,03,44,36
		HEX	E6,01,06,53,25,CF,04,53,35,DB,04,53,45,1B,02,53
		HEX	35,FD,02,6C,35,DF,00,06,53,45,3B,04,44,16,64,0B
		HEX	11,44,15,67,0C,15,48,35,48,07,04,48,35,98,06,00
		HEX	6C,35,47,08,00,49,14,38,08,48,35,50,08,0C,6C,25
		HEX	D6,00,07,48,25,C0,05,08,46,35,3D,02,00,CC,35,1F
		HEX	FC,FC,CD,25,E7,01,FF,6C,25,C6,09,00,45,26,B4,03
		HEX	09,6C,26,C3,00,0B,48,13,0F,28,01,CD,26,B4,03,FD
		HEX	44,15,D8,00,03,48,25,28,07,02,48,25,08,02,01,48
		HEX	26,28,07,3D,CC,26,97,FF,FF,53,26,36,02,54,26,24
		HEX	03,01,53,16,E6,02,54,16,D4,03,01,48,25,58,03,06
		HEX	48,25,5B,01,00,44,25,00,0B,01,44,14,AA,0E,01,6C
		HEX	15,BF,00,00,6C,16,B8,00,00,6C,26,18,00,00,6C,25
		HEX	1F,00,00,6C,14,B3,00,00,53,13,6A,04,48,16,C8,07
		HEX	03,48,16,08,07,09,48,15,C8,07,03,48,13,CC,14,03
		HEX	48,12,00,1E,01,54,16,F0,03,01,54,26,40,03,01,44
		HEX	40,66,02,03,CD,40,A9,04,FB,48,40,68,13,00,44,40
		HEX	2A,03,02,48,40,2C,03,00,48,40,93,01,00,55,40,4A
		HEX	FE,02,55,14,66,FC,04,48,14,84,01,00,48,14,93,02
		HEX	00,49,13,52,08,49,12,5D,08,54,13,6A,FD,01,6C,13
		HEX	6A,00,00,49,15,32,08,48,15,C1,06,03,49,14,3D,08
		HEX	48,14,66,0A,03,48,14,75,01,00,48,11,02,0E,01,6C
		HEX	12,7B,0F,00,6C,13,2E,00,05,48,13,2F,04,00,48,13
		HEX	3F,03,00,48,13,4F,02,00,48,13,5F,01,00,48,13,6F
		HEX	00,00,48,25,20,08,09,48,01,82,0D,07,53,36,00,03
		HEX	53,36,20,03,53,35,4F,04,53,26,E0,03,53,26,66,02
		HEX	54,26,67,FD,01,55,26,75,FD,02,54,26,93,FD,01,A4
		HEX	00,EE,01,01,A4,00,EA,01,01,A4,00,E6,01,01,A4,00
		HEX	C4,01,01,A4,00,C8,01,01,A4,00,CC,01,01,A4,01,C0
		HEX	01,01,44,11,92,03,02,45,10,78,02,03,00,10,93,C4
		HEX	A4,10,04,01,01,A4,10,08,01,01,A4,10,0C,01,01,A4
		HEX	10,2A,01,01,45,10,34,03,03,44,10,B9,01,00,A4,10
		HEX	48,01,01,A4,10,4C,01,01,A4,11,00,01,01,A3,10,2E
		HEX	01,01,A3,10,26,01,01,CD,00,7B,03,FD,CC,00,7A,FD
		HEX	FD,CD,00,64,02,FE,53,45,1D,02,53,35,FB,02,48,45
		HEX	28,03,02,48,35,D9,02,04,6C,35,DB,00,06,48,35,A9
		HEX	01,02,53,15,9F,02,48,01,4E,01,03,48,00,00,1A,03
		HEX	48,01,0D,02,03,3C,01,4B,FC,53,11,50,02,46,10,79
		HEX	01,03,45,10,6B,01,04,55,11,51,FA,06,48,11,22,04
		HEX	06,48,11,27,02,04,48,11,2A,01,06,48,11,2C,02,04
		HEX	48,11,2F,05,05,48,12,27,03,01,48,12,2A,01,00,A3
		HEX	00,84,0D,01,A3,00,AE,01,01,A3,00,AA,01,01,A3,00
		HEX	A6,01,01,53,10,53,02,55,10,54,06,05,54,36,F1,03
		HEX	01,53,46,24,04,55,26,D4,03,03,48,25,BB,03,00,F4
		HEX	25,9C,01,53,36,D1,02,54,36,C5,FD,01,6C,13,25,00
		HEX	00,6C,12,3B,0A,00,6C,13,15,09,00,48,12,2C,08,00
		HEX	53,45,F9,03,44,45,FF,02,01,53,55,2D,03,53,15,5D
		HEX	04,55,15,5E,FC,03,55,15,67,03,02,48,15,61,06,03
		HEX	53,16,84,04,55,16,50,04,04,48,15,77,01,00,48,16
		HEX	26,01,00,48,16,37,01,00,55,16,91,03,02,48,15,88
		HEX	08,01,55,50,9D,FD,03,55,51,64,FA,06,53,50,6E,02
		HEX	55,51,42,FD,03,6C,46,80,00,00,53,55,43,03,53,55
		HEX	20,03,55,55,21,FC,03,55,45,FA,FA,05,55,54,3B,03
		HEX	02,55,45,FB,02,02,55,46,D4,FA,05,C4,25,FC,00,44
		HEX	10,A7,01,01,48,10,C8,34,03,48,00,40,03,11,48,10
		HEX	60,01,09,48,10,D2,06,02,48,12,64,01,00,48,12,25
		HEX	02,02,48,12,55,01,00,48,11,8F,04,00,48,40,3D,01
		HEX	00,46,40,EE,06,00,F4,41,D2,01,53,50,4C,02,55,51
		HEX	20,FD,03,48,41,84,06,06,48,40,8E,06,00,48,40,9F
		HEX	05,00,48,41,A0,03,00,48,40,7D,0F,00,55,40,FF,FC
		HEX	04,48,40,FF,01,00,FF
;-------------- next go to data -----------------------------------------
		HEX	01		;door pos
		BYTE	CORS_57_02	;corse data table pointer
		HEX	07,5E		;player X,Y pos
		BYTE	PO_DK_I_U	;player mode
		HEX	FF
;
;
 ELSE      ;**** { Ή [1995/6/30] ****************************
;
;------------------------------------------------------------------------
;-		"58qca01a.dat" (1995/06/26 18:37:27)			-
;------------------------------------------------------------------------
		GLB	BGDT_57_01
BGDT_57_01	EQU	$
		HEX	0B,66,54,A4,58,70,00,00,91,20,46,50,8A,02,01,CC
		HEX	51,A0,F6,F5,46,41,66,02,00,CC,41,6A,FC,FC,45,41
		HEX	10,05,05,44,51,71,09,03,CC,41,80,FE,FA,45,40,76
		HEX	07,07,44,50,0F,08,06,CD,42,D0,05,F5,CD,42,BA,01
		HEX	F7,CC,42,B9,FD,F7,53,41,8F,03,53,42,73,02,53,42
		HEX	99,02,53,42,76,02,54,42,74,FD,02,44,41,2B,04,05
		HEX	CC,42,BD,FF,F7,CD,42,BE,03,F7,CC,43,B9,FF,F7,CD
		HEX	43,B6,01,F7,CC,43,B5,FD,F7,CD,43,BA,03,F7,CC,54
		HEX	4A,F4,EE,53,42,9C,02,53,42,7F,02,53,43,72,02,53
		HEX	43,7B,02,53,43,7E,02,48,44,26,0A,06,48,44,75,01
		HEX	00,48,44,64,01,00,48,44,53,03,00,48,44,42,03,00
		HEX	44,45,53,07,08,45,45,8B,04,07,CD,45,8B,06,F6,48
		HEX	44,31,05,00,48,44,20,05,00,48,44,97,03,00,CD,54
		HEX	7E,03,FA,CD,55,65,05,F8,CC,55,64,FE,F8,46,46,75
		HEX	02,02,CD,55,4F,03,FD,CD,56,12,03,FD,CD,46,E5,03
		HEX	FB,48,45,21,06,06,54,43,7F,04,02,53,44,A1,02,54
		HEX	44,A2,04,02,53,44,D4,02,54,44,D5,04,02,CC,54,7D
		HEX	FE,FA,48,45,68,01,00,48,45,58,02,00,48,45,77,01
		HEX	00,45,44,DB,03,04,46,54,0F,03,00,48,44,99,0B,02
		HEX	48,44,CA,09,00,48,45,95,01,00,48,45,A4,01,00,53
		HEX	54,07,02,54,54,08,04,02,A7,43,EE,00,00,44,16,11
		HEX	07,04,44,14,1A,16,04,44,13,0D,0C,0B,45,01,35,05
		HEX	05,CC,01,84,FB,FA,46,10,F1,07,00,54,10,C8,FD,01
		HEX	53,10,C8,03,CC,10,B7,FB,FA,46,10,9B,07,03,44,11
		HEX	26,2A,0A,48,42,0E,07,01,48,43,0A,15,01,44,43,06
		HEX	03,01,44,42,0A,03,01,48,42,0A,03,00,48,43,06,03
		HEX	00,53,43,95,02,55,43,73,03,03,53,43,98,02,55,43
		HEX	7C,FD,03,55,42,77,03,02,55,43,70,FD,02,44,26,C0
		HEX	02,00,46,35,39,01,00,44,26,D0,02,07,45,35,2B,01
		HEX	02,CC,25,CA,FE,FC,45,35,27,01,02,44,35,57,11,08
		HEX	48,40,06,23,01,45,50,56,03,04,44,50,6D,01,03,44
		HEX	50,8F,01,01,44,41,49,01,01,44,41,96,03,07,44,40
		HEX	FF,05,01,CC,40,F5,FD,F3,48,40,02,04,01,48,51,24
		HEX	05,00,48,51,02,07,00,44,40,26,03,03,53,50,08,03
		HEX	55,40,E6,03,03,53,50,2A,02,48,41,F1,08,00,48,51
		HEX	13,06,00,CC,50,F8,FA,FA,CD,51,F7,07,F9,48,41,8A
		HEX	05,0E,CD,50,DF,02,FD,CC,50,DE,FF,FD,45,50,23,02
		HEX	06,48,50,30,02,04,54,50,86,03,02,48,50,80,05,00
		HEX	53,50,85,02,CD,50,F9,03,FB,CC,51,F6,FC,FA,48,40
		HEX	C0,05,06,48,40,11,01,00,48,40,00,01,09,48,40,91
		HEX	01,00,48,40,A0,01,01,53,51,63,02,48,51,35,04,03
		HEX	CB,51,7A,04,00,44,51,79,02,00,CC,55,4E,FD,FB,46
		HEX	46,C0,01,02,46,46,A2,02,03,53,46,D3,02,53,54,3A
		HEX	02,48,40,22,01,00,48,40,31,01,00,53,40,C5,03,54
		HEX	40,C7,03,01,48,44,A8,01,00,CC,46,66,FC,FB,44,36
		HEX	E2,03,02,44,46,57,00,01,53,46,85,03,55,46,86,FD
		HEX	03,53,45,B9,05,55,45,BA,FC,04,53,35,FF,03,44,36
		HEX	E6,01,06,53,25,CF,04,53,35,DB,04,53,45,1B,02,53
		HEX	35,FD,02,6C,35,DF,00,06,53,45,3B,04,44,16,64,0B
		HEX	11,44,15,67,0C,15,48,35,48,07,04,48,35,98,06,00
		HEX	6C,35,47,08,00,49,14,38,08,48,35,50,08,0C,6C,25
		HEX	D6,00,07,48,25,C0,05,08,46,35,3D,02,00,CC,35,1F
		HEX	FC,FC,CD,25,E7,01,FF,6C,25,C6,09,00,45,26,B4,03
		HEX	09,6C,26,C3,00,0B,48,13,0F,28,01,CD,26,B4,03,FD
		HEX	44,15,D8,00,03,48,25,28,07,02,48,25,08,02,01,48
		HEX	26,28,07,3D,CC,26,97,FF,FF,53,26,36,02,54,26,24
		HEX	03,01,53,16,E6,02,54,16,D4,03,01,48,25,58,03,06
		HEX	48,25,5B,01,00,44,25,00,0B,01,44,14,AA,0E,01,6C
		HEX	15,BF,00,00,6C,16,B8,00,00,6C,26,18,00,00,6C,25
		HEX	1F,00,00,6C,14,B3,00,00,53,13,6A,04,48,16,C8,07
		HEX	03,48,16,08,07,09,48,15,C8,07,03,48,13,CC,14,03
		HEX	48,12,00,1E,01,54,16,F0,03,01,54,26,40,03,01,44
		HEX	40,66,02,03,CD,40,A9,04,FB,48,40,68,13,00,44,40
		HEX	2A,03,02,48,40,2C,03,00,48,40,93,01,00,55,40,4A
		HEX	FE,02,55,14,66,FC,04,48,14,84,01,00,48,14,93,02
		HEX	00,49,13,52,08,49,12,5D,08,54,13,6A,FD,01,6C,13
		HEX	6A,00,00,49,15,32,08,48,15,C1,06,03,49,14,3D,08
		HEX	48,14,66,0A,03,48,14,75,01,00,48,11,02,0E,01,6C
		HEX	12,7B,0F,00,6C,13,2E,00,05,48,13,2F,04,00,48,13
		HEX	3F,03,00,48,13,4F,02,00,48,13,5F,01,00,48,13,6F
		HEX	00,00,48,25,20,08,09,48,01,82,0D,07,53,36,00,03
		HEX	53,36,20,03,53,35,4F,04,53,26,E0,03,53,26,66,02
		HEX	54,26,67,FD,01,55,26,75,FD,02,54,26,93,FD,01,A4
		HEX	00,EE,01,01,A4,00,EA,01,01,A4,00,E6,01,01,A4,00
		HEX	C4,01,01,A4,00,C8,01,01,A4,00,CC,01,01,A4,01,C0
		HEX	01,01,44,11,92,03,02,45,10,78,02,03,00,10,93,C4
		HEX	A4,10,04,01,01,A4,10,08,01,01,A4,10,0C,01,01,A4
		HEX	10,2A,01,01,45,10,34,03,03,44,10,B9,01,00,A4,10
		HEX	48,01,01,A4,10,4C,01,01,A4,11,00,01,01,A3,10,2E
		HEX	01,01,A3,10,26,01,01,CD,00,7B,03,FD,CC,00,7A,FD
		HEX	FD,CD,00,64,02,FE,53,45,1D,02,53,35,FB,02,48,45
		HEX	28,03,02,48,35,D9,02,04,6C,35,DB,00,06,48,35,A9
		HEX	01,02,53,15,9F,02,48,01,4E,01,03,48,00,00,1A,03
		HEX	48,01,0D,02,03,3C,01,4B,FC,53,11,50,02,46,10,79
		HEX	01,03,45,10,6B,01,04,55,11,51,FA,06,48,11,22,04
		HEX	06,48,11,27,02,04,48,11,2A,01,06,48,11,2C,02,04
		HEX	48,11,2F,05,05,48,12,27,03,01,48,12,2A,01,00,A3
		HEX	00,84,0D,01,A3,00,AE,01,01,A3,00,AA,01,01,A3,00
		HEX	A6,01,01,53,10,53,02,55,10,54,06,05,54,36,F1,03
		HEX	01,53,46,24,04,55,26,D4,03,03,48,25,BB,03,00,F4
		HEX	25,9C,01,53,36,D1,02,54,36,C5,FD,01,6C,13,25,00
		HEX	00,6C,12,3B,0A,00,6C,13,15,09,00,48,12,2C,08,00
		HEX	53,45,F9,03,44,45,FF,02,01,53,55,2D,03,53,15,5D
		HEX	04,55,15,5E,FC,03,55,15,67,03,02,48,15,61,06,03
		HEX	53,16,84,04,55,16,50,04,04,48,15,77,01,00,48,16
		HEX	26,01,00,48,16,37,01,00,55,16,91,03,02,48,15,88
		HEX	08,01,55,50,9D,FD,03,55,51,64,FA,06,53,50,6E,02
		HEX	55,51,42,FD,03,6C,46,80,00,00,53,55,43,03,53,55
		HEX	20,03,55,55,21,FC,03,55,45,FA,FA,05,55,54,3B,03
		HEX	02,55,45,FB,02,02,55,46,D4,FA,05,C4,25,FC,00,C4
		HEX	35,0B,02,44,10,A7,01,01,48,10,C8,34,03,48,00,40
		HEX	03,11,48,10,60,01,09,48,10,D2,06,02,48,12,64,01
		HEX	00,48,12,25,02,02,48,12,55,01,00,48,11,8F,04,00
		HEX	48,40,3D,01,00,46,40,EE,06,00,F4,41,D2,01,53,50
		HEX	4C,02,55,51,20,FD,03,48,41,84,06,06,48,40,8E,06
		HEX	00,48,40,9F,05,00,48,41,A0,03,00,48,40,7D,0F,00
		HEX	55,40,FF,FC,04,48,40,FF,01,00,FF
;-------------- next go to data -----------------------------------------
		HEX	01		;door pos
		BYTE	CORS_57_02	;corse data table pointer
		HEX	07,5E		;player X,Y pos
		BYTE	PO_DK_I_U	;player mode
		HEX	FF
;

 ENDIF	   ;**** { Ή [1995/6/30] ****************************
;
;
;------------------------------------------------------------------------
;-		"58qca02a.dat" (1995/06/26 17:09:58)			-
;------------------------------------------------------------------------
		GLB	BGDT_57_02
BGDT_57_02	EQU	$
		HEX	07,A9,B4,00,00,60,58,00,91,40,9D,50,90,01,03,0D
		HEX	50,81,03,9D,50,50,01,03,9D,40,90,01,03,9D,40,50
		HEX	01,03,9D,40,5E,01,03,9D,40,9E,01,03,9D,50,9E,01
		HEX	03,9D,50,D0,03,02,9D,50,DC,03,02,9D,50,D4,02,02
		HEX	9D,50,D9,02,02,9D,30,00,01,04,9D,30,0E,01,04,9D
		HEX	30,02,04,01,9D,30,09,04,01,3C,30,27,FE,9D,30,50
		HEX	01,03,9D,30,90,01,03,9D,30,D0,01,03,9D,40,10,01
		HEX	03,9D,40,1E,01,03,9D,30,DE,01,03,9D,30,9E,01,03
		HEX	9D,30,5E,01,03,9F,30,53,01,9F,30,5B,01,9F,30,B7
		HEX	01,0D,50,4C,02,0D,50,0D,01,0D,50,01,01,C4,40,12
		HEX	0B,C4,40,05,00,C4,40,09,00,9D,40,D0,01,03,9D,40
		HEX	DE,01,03,9D,50,1E,01,03,0D,50,41,02,9D,50,10,01
		HEX	03,0D,50,8B,03,9D,50,5E,01,03,0D,50,B5,05,9D,50
		HEX	B2,03,01,9D,50,BA,03,01,FF
;-------------- next go to data -----------------------------------------
		HEX	30		;door pos
		BYTE	CORS_57_03	;corse data table pointer
		HEX	03,7A		;player X,Y pos
		BYTE	PO_DK_O_U	;player mode
		HEX	FF
;
;------------------------------------------------------------------------
;-		"58qca03.dat" (1995/06/28 18:51:55)			-
;------------------------------------------------------------------------
		GLB	BGDT_57_03
BGDT_57_03	EQU	$
		HEX	03,65,B4,0A,00,60,28,00,01,60,48,70,00,05,05,46
		HEX	70,C4,05,00,48,70,C0,02,03,4A,71,8F,05,00,62,FF
		HEX	FD,00,63,F0,FD,00,61,FF,FD,48,70,06,07,06,44,70
		HEX	8A,02,03,F4,70,A3,05,CD,70,82,02,FE,48,70,60,01
		HEX	05,CD,71,C3,04,FC,48,70,C5,1F,03,48,71,BB,09,00
		HEX	48,71,AC,07,00,00,71,BD,52,00,72,B0,52,48,55,9B
		HEX	04,00,48,55,FB,04,00,4A,72,4F,0B,46,73,85,06,00
		HEX	CC,73,3A,FB,FA,48,55,90,04,00,48,55,F0,04,00,48
		HEX	65,0D,02,0C,53,63,E7,03,54,63,DD,FD,02,48,64,EB
		HEX	14,06,44,25,30,0F,11,CD,15,CB,04,F5,CC,15,CA,FD
		HEX	F7,CD,15,A5,01,F9,CC,15,A4,FF,F9,CD,35,9A,03,FC
		HEX	46,25,38,07,01,4A,55,87,13,6C,55,F5,00,04,6C,55
		HEX	FA,00,04,48,55,A0,05,04,48,55,AA,05,04,6C,45,00
		HEX	00,19,6C,45,0F,00,19,63,35,E2,05,6C,35,F0,00,00
		HEX	6C,35,FF,00,00,48,25,FF,00,0D,48,35,8E,01,01,48
		HEX	25,BE,01,03,48,25,AF,00,00,48,25,8E,01,01,48,25
		HEX	4E,01,02,48,25,0F,00,03,48,15,90,00,1C,48,35,10
		HEX	02,03,48,25,D0,01,02,48,25,50,01,01,48,25,30,06
		HEX	00,48,25,00,00,00,48,15,D0,01,02,48,15,A0,05,01
		HEX	48,15,FD,02,00,48,15,EA,05,00,48,15,9E,01,04,48
		HEX	15,7E,01,01,CB,35,89,02,04,CC,35,D8,FC,FC,48,35
		HEX	D8,07,01,CD,35,C2,02,F9,44,35,51,00,00,44,35,90
		HEX	01,00,44,35,55,04,03,44,35,99,01,03,48,35,60,01
		HEX	02,53,35,81,06,55,35,86,04,04,55,35,46,FD,03,53
		HEX	35,57,03,54,35,3E,FB,02,48,35,0E,01,06,53,35,15
		HEX	04,55,35,18,02,02,55,35,16,FE,01,53,25,D1,03,55
		HEX	25,D3,03,03,53,25,CC,02,54,25,CD,FB,02,53,25,8B
		HEX	03,54,25,8C,F9,03,54,25,63,05,02,54,25,4D,FB,02
		HEX	79,15,E9,FC,79,15,A6,04,48,15,00,02,08,48,15,0E
		HEX	01,05,48,15,03,0A,02,44,25,38,01,01,48,25,20,09
		HEX	00,53,15,87,07,48,15,33,01,00,48,15,42,01,00,48
		HEX	15,3D,01,00,CD,72,13,08,EF,CC,72,12,FB,EF,45,71
		HEX	44,03,03,CD,71,44,08,EC,44,70,7D,01,04,44,70,BF
		HEX	03,00,48,70,77,05,00,CB,71,72,05,00,44,71,61,02
		HEX	02,46,70,6E,05,00,CC,71,13,FB,EF,44,70,7F,03,03
		HEX	48,60,00,0D,0F,CD,63,F3,01,FC,CC,63,F2,FA,F8,45
		HEX	63,63,06,06,46,63,B9,03,01,CC,63,8C,F8,F8,44,63
		HEX	0D,00,0C,45,62,0D,05,06,00,52,FE,FF,44,62,0C,00
		HEX	06,53,71,75,02,55,71,76,FB,04,45,65,60,06,06,46
		HEX	65,C9,03,00,48,65,C4,07,00,CD,63,DD,04,FB,46,64
		HEX	BA,05,01,48,35,BE,01,00,48,35,90,00,00,48,35,A0
		HEX	01,02,48,35,E0,01,00,CD,35,E0,01,FF,CC,73,D9,FC
		HEX	FC,CB,73,85,03,00,44,73,4C,0B,09,44,73,87,02,00
		HEX	48,64,DB,09,00,48,65,DB,04,00,CC,74,1A,FE,FC,53
		HEX	64,D7,04,00,65,D5,52,00,65,D8,52,00,65,F8,52,00
		HEX	65,F5,52,48,74,5B,14,0A,CC,64,D6,FC,FB,45,64,97
		HEX	02,03,45,64,64,02,03,45,63,0E,05,07,00,53,FE,FF
		HEX	00,64,B1,50,48,63,DD,0A,07,48,63,EA,03,06,C4,55
		HEX	46,00,C4,55,0A,00,C4,45,C4,00,C4,45,8C,00,C4,45
		HEX	42,00,68,45,83,00,00,68,45,4D,00,00,68,55,49,00
		HEX	00,68,55,05,00,00,68,45,CB,00,00,48,74,A0,01,00
		HEX	48,74,53,04,00,48,74,64,03,00,48,74,75,02,00,48
		HEX	74,86,01,00,48,73,9F,01,00,48,73,DA,11,02,54,73
		HEX	8A,FD,01,48,73,8A,05,04,48,74,C0,03,00,45,74,28
		HEX	02,0A,48,74,B0,02,00,48,25,7F,00,00,48,15,6F,00
		HEX	00,48,35,D0,00,00,FF
;-------------- next go to data -----------------------------------------
;;;;;		HEX	70		;door pos
;;;;;		BYTE	CORS_57_02	;corse data table pointer
;;;;;		HEX	07,31		;player X,Y pos
;;;;;		BYTE	PO_DK_O_D	;player mode
;
		HEX	15		;door pos
		BYTE	CORS_57_04	;corse data table pointer
		HEX	03,4B		;player X,Y pos
		BYTE	PO_DK_O_U	;player mode
;
		HEX	74		;door pos
		BYTE	CORS_57_06	;corse data table pointer
		HEX	CA,1A		;player X,Y pos
		BYTE	PO_NORMAL	;player mode
		HEX	FF
;
;------------------------------------------------------------------------
;		Tv|Wi{XEL[yJbNozj		-
;------------------------------------------------------------------------
;-		"qb0ss04a.dat" (1995/06/24 00:25:08)						-
;------------------------------------------------------------------------
		GLB	BGDT_57_04
BGDT_57_04	EQU	$
		HEX	03,65,B4,3E,58,8C,28,80,24,00,CC,40,84,FE,FD,48
		HEX	40,00,01,0A,48,40,B0,02,04,A5,40,B3,04,46,40,B7
		HEX	02,00,CC,40,99,FE,FC,44,40,7A,01,04,CD,40,BC,03
		HEX	FC,48,40,B5,0A,04,45,40,25,01,02,46,40,42,02,00
		HEX	46,40,37,02,01,45,40,1D,02,05,CD,40,85,01,FD,44
		HEX	40,0A,02,06,49,40,44,02,49,40,48,02,48,40,0E,01
		HEX	0A,FF
;-------------- next go to data -----------------------------------------
		HEX	30		;door pos
		BYTE	CORS_57_05	;corse data table pointer
		HEX	14,18		;player X,Y pos
		BYTE	PO_BSQ_M7	;player mode
		HEX	FF
;
;------------------------------------------------------------------------
;		Tv|Wi{XEL[y[hVzj		-
;------------------------------------------------------------------------
;-		"77777777.dat" (1995/06/01 10:22:54)			-
;------------------------------------------------------------------------
		GLB	BGDT_57_05
BGDT_57_05	EQU	$
;;;???;;;		HEX	00,00,00,00,13,E2,48,3E,A0,01,00,F0,3C,00,0C,00
		HEX	00,00,00,00,02,7C,48,81,7C,00,01,00,F0,3C,00,0C
		HEX	00,E5,00,0C,01,E4,00,0C,01,E9,00,0C,02,E8,00,0C
		HEX	02,ED,00,0C,03,EC,00,FF
;-------------- next go to data -----------------------------------------
		HEX	FF
;
;------------------------------------------------------------------------
;-		"kisya00.dat" (1995/06/26 04:31:45)			-
;------------------------------------------------------------------------
		GLB	BGDT_57_06
BGDT_57_06	EQU	$
		HEX	03,65,B4,00,05,20,58,00,05,E0,CD,2C,48,09,F7,46
		HEX	2C,30,03,00,CC,2C,47,F7,F7,46,1B,AE,09,00,45,1C
		HEX	18,09,09,CB,1B,AE,13,00,53,1C,C2,0A,45,2C,62,04
		HEX	04,45,2C,7B,04,04,CD,3C,56,09,F7,CC,3C,55,F7,F6
		HEX	46,2C,A7,03,02,44,2C,B6,00,01,CC,2B,BB,FD,FB,CD
		HEX	2C,62,02,FE,CD,2C,44,02,FE,44,2C,04,01,01,45,1B
		HEX	EA,05,08,44,2C,40,01,02,44,2B,7C,05,03,00,1C,C5
		HEX	32,52,1C,F5,FB,06,00,2B,5F,33,50,2B,6F,02,51,2B
		HEX	9C,05,00,2B,9F,37,52,2C,92,02,02,CB,2C,BB,04,00
		HEX	00,2B,9B,35,50,2B,6B,02,00,2C,E4,35,00,2C,E7,34
		HEX	51,2C,E5,01,50,1C,D5,02,6C,1C,6B,00,00,6C,1C,72
		HEX	01,00,6C,1C,7B,01,00,6C,1C,8C,00,04,6C,1C,82,00
		HEX	04,6C,1C,63,00,00,6C,1C,57,00,02,45,0C,E3,03,04
		HEX	CC,1C,43,FE,FD,CD,1B,4E,02,FC,CD,1B,7B,02,FC,45
		HEX	1B,B7,02,0A,CD,1B,B7,03,FA,CB,1C,43,01,00,44,1C
		HEX	34,01,01,CC,2B,77,FB,F9,46,2B,12,02,00,CC,1B,F4
		HEX	FC,FC,46,1B,A0,06,00,CB,2B,12,04,00,46,1B,37,03
		HEX	02,46,0B,FB,02,04,45,0C,B0,02,05,46,0B,CE,01,03
		HEX	CB,1B,A0,06,00,44,1B,95,01,08,00,2B,5B,36,52,2B
		HEX	06,04,05,00,2B,05,35,51,0B,FF,02,51,1C,25,02,45
		HEX	0D,F7,05,06,CB,1D,47,05,17,CC,1D,67,FC,FC,45,0D
		HEX	B3,03,06,45,0C,7F,03,05,CC,1D,23,FD,FB,CC,0C,EF
		HEX	FD,FB,CC,0C,BC,FC,FB,45,0C,4C,02,04,45,0C,19,02
		HEX	04,00,1D,5A,36,46,0C,45,03,01,52,0C,49,10,11,CD
		HEX	0C,A4,03,FC,46,0C,63,01,02,CC,0C,A3,00,FF,CB,0C
		HEX	63,01,03,CD,0C,A4,00,FC,51,0C,47,01,52,0C,46,FF
		HEX	02,50,0C,65,01,52,0C,F2,02,03,52,1C,28,01,02,50
		HEX	1C,49,01,00,3B,0F,FD,44,2C,BB,00,00,53,2C,B5,0A
		HEX	00,2C,B7,32,46,3C,0F,08,04,46,3C,78,06,00,CC,3C
		HEX	FD,FB,F9,CD,3C,FE,09,F6,CB,3C,78,05,02,44,3C,7D
		HEX	00,02,53,3C,7B,0A,6C,2C,85,00,03,46,2D,C3,04,05
		HEX	CB,2D,77,05,00,CD,3D,58,04,F7,CB,2D,C9,03,04,44
		HEX	2D,C9,00,04,50,1D,6A,17,00,2D,EA,34,51,2D,E6,03
		HEX	52,2D,E5,FE,03,50,3D,13,05,00,2D,E7,3A,53,3D,34
		HEX	05,50,2D,F7,03,6C,3D,19,00,03,6C,3D,55,00,03,6C
		HEX	3C,5B,00,03,00,0C,7D,40,00,0D,B2,40,00,1D,78,40
		HEX	00,1C,E8,40,00,2C,9A,40,00,3C,AD,40,00,2C,C0,42
		HEX	00,2B,7D,42,00,2B,0A,42,00,1B,B4,42,00,0C,D0,42
		HEX	00,1C,FA,3F,00,1D,29,3F,00,0C,28,3F,00,3D,81,3F
		HEX	00,2C,E2,3F,00,2B,35,3F,00,1B,D7,3F,00,1B,1A,3F
		HEX	00,2B,CF,41,00,2B,09,41,00,1B,B3,41,00,0B,DF,41
		HEX	00,2B,7C,41,00,2D,B7,41,00,2D,B8,42,53,1B,73,07
		HEX	52,0B,FE,FB,06,50,1B,59,01,50,1B,85,07,00,1B,75
		HEX	32,6C,1B,53,00,03,6C,1B,5A,00,03,50,2C,C4,01,50
		HEX	2C,C7,01,00,3C,15,41,00,3C,16,42,FF
;-------------- next go to data -----------------------------------------
		HEX	1C		;door pos
		BYTE	CORS_57_03	;corse data table pointer
		HEX	46,7B		;player X,Y pos
		BYTE	PO_NORMAL	;player mode
		HEX	FF
;
;
;
;
;
;************************************************************************
;*		enemy data						*
;************************************************************************
;
;		LWORD	[enemy no.]+([X pos]<<16)+([Y pos]<<9)
;		LWORD	[x] : [y]
;
;------------------------------------------------------------------------
;-		"58qca00.end" (1995/06/26 02:27:26)			-
;------------------------------------------------------------------------
		GLB	ENDT_57_00
ENDT_57_00	EQU	$
		LWORD	SRLF0+(080H<<16)+(05CH<<9)
		LWORD	CH_06+(07FH<<16)+(02CH<<9)
		LWORD	CH_06+(080H<<16)+(02CH<<9)
		LWORD	CH_0D+(07FH<<16)+(040H<<9)
		LWORD	CH_0D+(080H<<16)+(040H<<9)
		LWORD	SRLF0+(07BH<<16)+(044H<<9)
		LWORD	SRLF0+(083H<<16)+(040H<<9)
		LWORD	SRLF0+(07EH<<16)+(039H<<9)
		LWORD	SRLF0+(083H<<16)+(030H<<9)
		LWORD	SRLF0+(07FH<<16)+(02BH<<9)
		LWORD	ZSAB2+(07AH<<16)+(01AH<<9)
		LWORD	ZSAB2+(085H<<16)+(01AH<<9)
		LWORD	ZDOOR+(07EH<<16)+(016H<<9)
		LWORD	AHOBD+(065H<<16)+(05DH<<9)
		LWORD	AHOBD+(086H<<16)+(043H<<9)
		LWORD	AHOBD+(085H<<16)+(028H<<9)
		LWORD	AHOBD+(069H<<16)+(052H<<9)
		LWORD	AHOBD+(059H<<16)+(059H<<9)
		LWORD	AHOBD+(07FH<<16)+(034H<<9)
		WORD	0FFFFH
;
;
 IF  BUG01 & PAL ;**** oO Ή [1995/8/02] ****************************
;------------------------------------------------------------------------
;-		"581a-pal.end" (1995/08/02 16:24:12)			-
;------------------------------------------------------------------------
		GLB	ENDT_57_01
ENDT_57_01	EQU	$
		LWORD	ZSABO+(03EH<<16)+(04DH<<9)
		LWORD	ZSAB2+(02CH<<16)+(041H<<9)
		LWORD	ZSAB2+(038H<<16)+(041H<<9)
		LWORD	GABN2+(003H<<16)+(04BH<<9)
		LWORD	GABN2+(00DH<<16)+(045H<<9)
		LWORD	HEIH0+(012H<<16)+(04DH<<9)
		LWORD	DAI01+(060H<<16)+(047H<<9)
		LWORD	ZFLW2+(05DH<<16)+(03EH<<9)
		LWORD	NLFUD+(063H<<16)+(044H<<9)
		LWORD	ZFLW2+(058H<<16)+(02FH<<9)
		LWORD	QKM09+(006H<<16)+(00BH<<9)
		LWORD	YAJI0+(060H<<16)+(036H<<9)
		LWORD	YAJI0+(05CH<<16)+(044H<<9)
		LWORD	DAI02+(05CH<<16)+(021H<<9)
		LWORD	DAI02+(06BH<<16)+(01BH<<9)
		LWORD	YAJI0+(03CH<<16)+(018H<<9)
		LWORD	FLIPH+(02BH<<16)+(015H<<9)
		LWORD	COINR+(030H<<16)+(015H<<9)
		LWORD	COINR+(032H<<16)+(015H<<9)
		LWORD	COINR+(034H<<16)+(015H<<9)
		LWORD	COINR+(05AH<<16)+(02FH<<9)
		LWORD	COINR+(05EH<<16)+(02FH<<9)
		LWORD	ZFLW2+(02DH<<16)+(015H<<9)
		LWORD	RLTLF+(01DH<<16)+(018H<<9)
		LWORD	TAIH0+(010H<<16)+(00BH<<9)
		LWORD	TAIH0+(005H<<16)+(00FH<<9)
		LWORD	TAIH0+(00CH<<16)+(013H<<9)
		LWORD	TAIH0+(031H<<16)+(01BH<<9)
		LWORD	TAIH0+(033H<<16)+(01BH<<9)
		LWORD	YAJI0+(00BH<<16)+(004H<<9)
		LWORD	YAJI0+(015H<<16)+(006H<<9)
		LWORD	GABN2+(05FH<<16)+(017H<<9)
		LWORD	HEIH0+(056H<<16)+(051H<<9)
		LWORD	HEIH0+(058H<<16)+(04FH<<9)
		LWORD	YAJI0+(00AH<<16)+(016H<<9)
		LWORD	YAJI0+(00AH<<16)+(018H<<9)
		LWORD	JBLKL+(066H<<16)+(041H<<9)
		LWORD	HEIH0+(05CH<<16)+(029H<<9)
		LWORD	CDOOR+(004H<<16)+(057H<<9)
		LWORD	GATE0+(037H<<16)+(014H<<9)
		LWORD	QKM0C+(018H<<16)+(005H<<9)
		LWORD	QKM0C+(04DH<<16)+(04EH<<9)
		LWORD	YAJI0+(064H<<16)+(015H<<9)
		LWORD	FLIPH+(023H<<16)+(01AH<<9)
		LWORD	MSGBX+(018H<<16)+(018H<<9)
		LWORD	YAJI1+(028H<<16)+(017H<<9)
		LWORD	COLD0+(017H<<16)+(042H<<9)
		LWORD	COLD0+(05EH<<16)+(025H<<9)
		WORD	0FFFFH
;
;
 ELSE      ;**** { Ή [1995/6/30] ****************************
;
;------------------------------------------------------------------------
;-		"58qca01a.end" (1995/06/26 04:19:04)			-
;------------------------------------------------------------------------
		GLB	ENDT_57_01
ENDT_57_01	EQU	$
		LWORD	ZSABO+(03EH<<16)+(04DH<<9)
		LWORD	ZSAB2+(02CH<<16)+(041H<<9)
		LWORD	ZSAB2+(038H<<16)+(041H<<9)
		LWORD	GABN2+(003H<<16)+(04BH<<9)
		LWORD	GABN2+(00DH<<16)+(045H<<9)
		LWORD	HEIH0+(012H<<16)+(04DH<<9)
		LWORD	DAI01+(060H<<16)+(047H<<9)
		LWORD	ZFLW2+(05DH<<16)+(03EH<<9)
		LWORD	NLFUD+(063H<<16)+(044H<<9)
		LWORD	ZFLW2+(058H<<16)+(02FH<<9)
		LWORD	QKM09+(006H<<16)+(00BH<<9)
		LWORD	YAJI0+(060H<<16)+(036H<<9)
		LWORD	YAJI0+(05CH<<16)+(044H<<9)
		LWORD	DAI02+(05CH<<16)+(021H<<9)
		LWORD	DAI02+(06BH<<16)+(01BH<<9)
		LWORD	YAJI0+(03CH<<16)+(018H<<9)
		LWORD	FLIPH+(02BH<<16)+(015H<<9)
		LWORD	COINR+(030H<<16)+(015H<<9)
		LWORD	COINR+(032H<<16)+(015H<<9)
		LWORD	COINR+(034H<<16)+(015H<<9)
		LWORD	COINR+(05AH<<16)+(02FH<<9)
		LWORD	COINR+(05EH<<16)+(02FH<<9)
		LWORD	ZFLW2+(02DH<<16)+(015H<<9)
		LWORD	RLTLF+(01DH<<16)+(018H<<9)
		LWORD	TAIH0+(010H<<16)+(00BH<<9)
		LWORD	TAIH0+(005H<<16)+(00FH<<9)
		LWORD	TAIH0+(00CH<<16)+(013H<<9)
		LWORD	TAIH0+(031H<<16)+(01BH<<9)
		LWORD	TAIH0+(033H<<16)+(01BH<<9)
		LWORD	YAJI0+(00BH<<16)+(004H<<9)
		LWORD	YAJI0+(015H<<16)+(006H<<9)
		LWORD	GABN2+(05FH<<16)+(017H<<9)
		LWORD	HEIH0+(056H<<16)+(051H<<9)
		LWORD	HEIH0+(058H<<16)+(04FH<<9)
		LWORD	YAJI0+(00AH<<16)+(016H<<9)
		LWORD	YAJI0+(00AH<<16)+(018H<<9)
		LWORD	JBLKL+(066H<<16)+(041H<<9)
		LWORD	HEIH0+(05CH<<16)+(029H<<9)
		LWORD	CDOOR+(004H<<16)+(057H<<9)
		LWORD	GATE0+(037H<<16)+(014H<<9)
		LWORD	QKM0C+(018H<<16)+(005H<<9)
		LWORD	QKM0C+(04DH<<16)+(04EH<<9)
		LWORD	YAJI0+(064H<<16)+(015H<<9)
		LWORD	FLIPH+(023H<<16)+(01AH<<9)
		LWORD	MSGBX+(018H<<16)+(018H<<9)
		LWORD	YAJI1+(028H<<16)+(017H<<9)
		LWORD	COLD0+(017H<<16)+(042H<<9)
		LWORD	COLD0+(05EH<<16)+(025H<<9)
		WORD	0FFFFH
;
 ENDIF	   ;**** { Ή [1995/6/30] ****************************
;
;
;------------------------------------------------------------------------
;-		"58qca02a.end" (1995/06/26 04:19:35)			-
;------------------------------------------------------------------------
		GLB	ENDT_57_02
ENDT_57_02	EQU	$
		LWORD	RLTLF+(007H<<16)+(059H<<9)
		LWORD	AHOBD+(003H<<16)+(04BH<<9)
		LWORD	AHOBD+(00CH<<16)+(046H<<9)
		LWORD	AHOBD+(003H<<16)+(041H<<9)
		LWORD	ZFLW2+(008H<<16)+(035H<<9)
		LWORD	COINR+(003H<<16)+(040H<<9)
		LWORD	COINR+(00BH<<16)+(040H<<9)
		LWORD	COINR+(007H<<16)+(040H<<9)
		LWORD	QCHN2+(008H<<16)+(03CH<<9)
		LWORD	QCHN2+(00CH<<16)+(036H<<9)
		LWORD	QCHN2+(004H<<16)+(036H<<9)
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;-		"58qca03.end" (1995/06/19 13:28:19)			-
;------------------------------------------------------------------------
		GLB	ENDT_57_03
ENDT_57_03	EQU	$
		LWORD	POLY1+(01FH<<16)+(075H<<9)
		LWORD	POLY1+(02FH<<16)+(071H<<9)
		LWORD	GHEIH+(01EH<<16)+(07CH<<9)
		LWORD	GHEIH+(021H<<16)+(07CH<<9)
		LWORD	JBLKL+(058H<<16)+(06BH<<9)
		LWORD	POLY1+(057H<<16)+(055H<<9)
		LWORD	POLY1+(057H<<16)+(051H<<9)
		LWORD	POLY1+(057H<<16)+(04DH<<9)
		LWORD	POLY1+(057H<<16)+(049H<<9)
		LWORD	GHEIH+(056H<<16)+(06EH<<9)
		LWORD	GHEIH+(059H<<16)+(06EH<<9)
		LWORD	GHEIH+(059H<<16)+(070H<<9)
		LWORD	GHEIH+(056H<<16)+(070H<<9)
		LWORD	OTAMH+(05EH<<16)+(054H<<9)
		LWORD	OTAMH+(055H<<16)+(050H<<9)
		LWORD	OTAMH+(05CH<<16)+(04CH<<9)
		LWORD	OTAMH+(054H<<16)+(048H<<9)
		LWORD	POLY1+(057H<<16)+(045H<<9)
		LWORD	POLY1+(057H<<16)+(041H<<9)
		LWORD	OTAMH+(05AH<<16)+(044H<<9)
		LWORD	AHOB2+(051H<<16)+(035H<<9)
		LWORD	AHOB2+(051H<<16)+(02CH<<9)
		LWORD	AHOB2+(051H<<16)+(020H<<9)
		LWORD	DBAH2+(05CH<<16)+(031H<<9)
		LWORD	DBAH2+(05CH<<16)+(02AH<<9)
		LWORD	DBAH2+(05CH<<16)+(022H<<9)
		LWORD	BOSDR+(059H<<16)+(017H<<9)
		LWORD	COINR+(018H<<16)+(06FH<<9)
		LWORD	COINR+(027H<<16)+(06FH<<9)
		LWORD	JBLKL+(049H<<16)+(07CH<<9)
		LWORD	COIN2+(039H<<16)+(06BH<<9)
		LWORD	COIN2+(035H<<16)+(06CH<<9)
		LWORD	COIN2+(034H<<16)+(06EH<<9)
		LWORD	COIN2+(03BH<<16)+(06BH<<9)
		LWORD	QKM0C+(05CH<<16)+(01AH<<9)
		LWORD	GATE0+(04FH<<16)+(06AH<<9)
		LWORD	COINR+(025H<<16)+(071H<<9)
		LWORD	COINR+(01AH<<16)+(071H<<9)
		LWORD	COINR+(037H<<16)+(06BH<<9)
		LWORD	ZDOOR+(046H<<16)+(07CH<<9)
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;		Tv|Wi{XEL[yJbNoC[hVzj-
;------------------------------------------------------------------------
;-		"qboss04a.end" (1995/03/09 11:26:25)			-
;------------------------------------------------------------------------
		GLB	ENDT_57_04
		GLB	ENDT_57_05
ENDT_57_04	EQU	$
		LWORD	BOSSQ+(00DH<<16)+(03FH<<9)
		LWORD	KAMC2+(00DH<<16)+(044H<<9)
ENDT_57_05	EQU	$
		WORD	0FFFFH
;
;------------------------------------------------------------------------
;-		"kisya00.end" (1995/06/26 04:30:58)			-
;------------------------------------------------------------------------
		GLB	ENDT_57_06
ENDT_57_06	EQU	$
		LWORD	ZDOOR+(0CAH<<16)+(01BH<<9)
		LWORD	CHG03+(0C7H<<16)+(018H<<9)
		LWORD	FLIPP+(0C9H<<16)+(016H<<9)
		LWORD	ZFLW2+(0C5H<<16)+(014H<<9)
		LWORD	YAJI0+(0C5H<<16)+(01BH<<9)
		LWORD	FLIPP+(0C5H<<16)+(016H<<9)
		LWORD	COIN2+(0B7H<<16)+(021H<<9)
		LWORD	COIN2+(0B9H<<16)+(023H<<9)
		LWORD	COIN2+(0BBH<<16)+(025H<<9)
		LWORD	COIN2+(0C9H<<16)+(015H<<9)
		LWORD	COIN2+(0C8H<<16)+(012H<<9)
		LWORD	COIN2+(0C8H<<16)+(029H<<9)
		LWORD	COIN2+(0CAH<<16)+(029H<<9)
		LWORD	COIN2+(0CCH<<16)+(029H<<9)
		LWORD	COIN2+(0CEH<<16)+(029H<<9)
		LWORD	COIN2+(0C9H<<16)+(02AH<<9)
		LWORD	COIN2+(0CBH<<16)+(02AH<<9)
		LWORD	COIN2+(0CDH<<16)+(02AH<<9)
		LWORD	COINR+(0CFH<<16)+(00AH<<9)
		LWORD	COINR+(0C5H<<16)+(007H<<9)
		LWORD	COINR+(0D5H<<16)+(02EH<<9)
		LWORD	COINR+(0DAH<<16)+(01BH<<9)
		LWORD	COINR+(0D4H<<16)+(00FH<<9)
		LWORD	COINR+(0DAH<<16)+(020H<<9)
		LWORD	COINR+(0D9H<<16)+(014H<<9)
		LWORD	CHG03+(0D5H<<16)+(032H<<9)
		LWORD	CHG03+(0B7H<<16)+(016H<<9)
		LWORD	RAKUG+(0CFH<<16)+(039H<<9)
		LWORD	RAKUG+(0B1H<<16)+(01AH<<9)
		LWORD	RAKUG+(0BDH<<16)+(023H<<9)
		LWORD	RAKUG+(0CEH<<16)+(01AH<<9)
		LWORD	RAKUG+(0C6H<<16)+(033H<<9)
		LWORD	COIN2+(0D3H<<16)+(030H<<9)
		WORD	0FFFFH
;
;
;
;
;
;
		END
;
;
