;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mchip ram name				*
;*	file name	: ys_mram.asm					*
;*									*
;************************************************************************
;
;
;
;
;-------------- G`FbNpf[^錾 ----------------------------------
CENNO		EQU	24
CEXNO		EQU	16
;
CEINIT		EQU	2
CERINT		EQU	CEINIT+2
CECHNG		EQU	CERINT+2
CEEATM		EQU	CECHNG+2
CENOSE		EQU	CEEATM+2
CEFALL		EQU	CENOSE+2
CEFAIL		EQU	CEFALL+2
CEMOVE		EQU	CEFAIL+2
CEFIRE		EQU	CEMOVE+2
;
CENOK		EQU	CEFAIL
;
;-------------- ʃ`FbNpf[^錾 --------------------------------
EXSTART		EQU	01BAH
;
;-------------- fnaipf[^錾 ----------------------------------
DMSTART		EQU	022FH
;;;;K;;;;;
;;;;K;;;;;-------------- }bvnaipf[^[錾 ------------------------------
;;;;K;;;;MAPSTART	EQU	024FH
;
;
;-------------< LN^[f[^AhX >-----------------------------
NO_PRES		EQU	20		;񈳏koN
;
CHR50		EQU	520000H		;[ vC[]pLN^[		    ]
CHR64		EQU	528000H		;[		 h			    ]
CHR64P		EQU	CHR64+3000H	;[ ACegp֎~LN^[		    ]
CHR34		EQU	52C000H		;[ af]pSrbgLN^[	    ]
CHR80		EQU	530000H		;[ }bvpACRrbg}bvLN^[ ]
CHR88		EQU	538000H		;[		      h		    ]
CHRE0		EQU	53C000H		;[ ~[WJf]LN^[	    ]
CHR28		EQU	540000H		;[ rbg}bvLN^[		    ]
CHR68		EQU	548000H		;[	      h			    ]
CHR98		EQU	550000H		;[	      h			    ]
CHR11A		EQU	558000H		;[ GfBOprbg}bvLN^[   ]
CHR90		EQU	560000H		;[ }bvprbg}bvLN^[	    ]
CHR8C		EQU	566000H		;[ rbg}bvLN^[		    ]
CHR3F		EQU	568000H		;[ af]pQrbgLN^[	    ]
CHR70		EQU	569000H		;[		h			    ]
CHR71		EQU	56A000H		;[		h			    ]
CHR72		EQU	56B000H		;[		h			    ]
CHR73		EQU	56C000H		;[		h			    ]
CHR74		EQU	56D000H		;[ XRA[{[h]pLN^[	    ]
CHR32		EQU	56E800H		;[ [^[ϐg^CvLN^[	    ]
CHR119		EQU	56EC00H		;[nR[X]pLN^[		    ]
;
CIPCHD		EQU	CHR28
CIPCHD2		EQU	CHR68
CIPCHD3		EQU	CHR98
CIPCHD4		EQU	CHR8C
CIPCHD5		EQU	CHR11A
;
;
;-------------< J[ f[^ AhX >---------------------------------
COL_ADDRESS	EQU	5FA000H
;
;-------------< }bv XN[ f[^ AhX >----------------------
MAPSCR_ADR	EQU	5F9800H
;
;-------------< }bv afRXN[ f[^ AhX >----------------
MPB3SCR_ADR	EQU	0FF800H
MPB36W_ADR	EQU	5F9380H
;
;-------------< }bv afRSXN[ f[^ AhX >------------
MPB3RG_ADR	EQU	0FFC80H
;
;
;-------------< l|̂rebvOďo[`mD>--
COIN_BG_W	EQU	2		;RC
EATBLK_BG_W	EQU	COIN_BG_W+2	;Hׂaf
KUI_BG_W	EQU	EATBLK_BG_W+2	;Yaf
EGG_KILL	EQU	KUI_BG_W+2	;^}SIvV
CLR_BG_W	EQU	EGG_KILL+2	;ʂaf
CLR_BG_W_4	EQU	CLR_BG_W+2	;ʂafiSjbgj
UNIT_BG_W	EQU	CLR_BG_W_4+2	;w胆jbgaf
TN_INOUT_IN	EQU	UNIT_BG_W+2	;glhm^ntsfX^[gZbg
PLDOWNST	EQU	TN_INOUT_IN+2	;vC[_EZbg
PLFAILST	EQU	PLDOWNST+2	;vC[_[WZbg
GOTO_W1_1	EQU	PLFAILST+2	;Pv|PփZbg
TOGEBLK_BG_W	EQU	GOTO_W1_1+2	;gQubNaf
YOGAN_IN	EQU	TOGEBLK_BG_W+2	;vC[n◎
GET_POINT	EQU	YOGAN_IN+2	;IuWFRCAY[t[
;
;
;-------------< x錾 >---------------------------------------------
WUP0P		EQU	1AH		;Ԃʂ̃JE^[Zbgf[^
WUP1P		EQU	13H		;hs`s`hʂ̃^C}[Zbgf[^
;
LEFT_X		EQU	008H		;vC[\GA[wʒu
RIGHT_X		EQU	0E8H		;	   h	     E[   h
UP_Y		EQU	010H		;	   h	     [x h
LOW_Y		EQU	0B0H		;	   h	     [   h
;
NAGE_P		EQU	0AH		;vC[p^[ZbgmD
;
;;;;NAGPOW_MAX	    EQU	    0800H	    ;p[l`wl
;
;-------------- vC[^CvmD --------------------------
P_CAR		EQU	2		;N}bV[
P_MOGURA	EQU	P_CAR+2		;ObV[
P_HERI		EQU	P_MOGURA+2	;wRv^[bV[
P_TRAIN		EQU	P_HERI+2	;DԃbV[
P_SUBMARIN	EQU	P_TRAIN+2+2	;̓bV[
P_SKI		EQU	P_SUBMARIN+2	;XL[bV[
P_MARIO		EQU	P_SKI+2		;}I
P_EGG		EQU	P_MARIO+2	;^}S
;
;
;************************************************************************
;*									*
;*		mario chip == SFC RAM					*
;*									*
;************************************************************************
;
;************************************************************************
;*		mario chip						*
;************************************************************************
;
;========================================================================
;=		0 page RAM						=
;========================================================================
;
;-------------< work RAM >-----------------------------------------------
CWORK		EQU	00H
CWORK0		EQU	CWORK
CWORK1		EQU	CWORK0+2
CWORK2		EQU	CWORK1+2
CWORK3		EQU	CWORK2+2
CWORK4		EQU	CWORK3+2
CWORK5		EQU	CWORK4+2
CWORK6		EQU	CWORK5+2
CWORK7		EQU	CWORK6+2
CWORK8		EQU	CWORK7+2
CWORK9		EQU	CWORK8+2
CWORKA		EQU	CWORK9+2
CWORKB		EQU	CWORKA+2
CWORKC		EQU	CWORKB+2
CWORKD		EQU	CWORKC+2
CWORKE		EQU	CWORKD+2
CWORKF		EQU	CWORKE+2
;
CWORK10		EQU	CWORKF+2
CWORK11		EQU	CWORK10+2
CWORK12		EQU	CWORK11+2
CWORK13		EQU	CWORK12+2
CWORK14		EQU	CWORK13+2
CWORK15		EQU	CWORK14+2
CWORK16		EQU	CWORK15+2
CWORK17		EQU	CWORK16+2
CWORK18		EQU	CWORK17+2
CWORK19		EQU	CWORK18+2
CWORK1A		EQU	CWORK19+2
CWORK1B		EQU	CWORK1A+2
CWORK1C		EQU	CWORK1B+2
CWORK1D		EQU	CWORK1C+2
CWORK1E		EQU	CWORK1D+2
CWORK1F		EQU	CWORK1E+2
;
;-------------< register save RAM >--------------------------------------
REG0		EQU	CWORK1F+2
REG1		EQU	REG0+2
REG2		EQU	REG1+2
REG3		EQU	REG2+2
REG4		EQU	REG3+2
REG5		EQU	REG4+2
REG6		EQU	REG5+2
REG7		EQU	REG6+2
REG8		EQU	REG7+2
REG9		EQU	REG8+2
REG10		EQU	REG9+2
REG11		EQU	REG10+2
REG12		EQU	REG11+2
REG13		EQU	REG12+2
REG14		EQU	REG13+2
REG15		EQU	REG14+2
;
;-------------< R11 ( return address ) save RAM >------------------------
RTS0		EQU	REG15+2
RTS1		EQU	RTS0+2
RTS2		EQU	RTS1+2
RTS3		EQU	RTS2+2
RTS4		EQU	RTS3+2
RTS5		EQU	RTS4+2
RTS6		EQU	RTS5+2
RTS7		EQU	RTS6+2
;
;
;-------------< free work RAM >------------------------------------------
CFREE_WORK	EQU	RTS7+2
;
;
;........................................................................
;.		free work RAM ( game )					.
;........................................................................
;
;-------------< Rg[[ >-------------------------------------
CMKEYC1L	EQU	CFREE_WORK
CMKEYC1		EQU	CMKEYC1L+1
CMKEYC2L	EQU	CMKEYC1+1
CMKEYC2		EQU	CMKEYC2L+1
;
;-------------< TEhtO >-----------------------------------------
CMSOUND0	EQU	CMKEYC2+1	;l|pTEhtO
CMSOUND1	EQU	CMSOUND0+2	;	      h
CMSOUND2	EQU	CMSOUND1+2	;	      h
CMSOUND3	EQU	CMSOUND2+2	;	      h
;
;-------------< tO >---------------------------------------------
CMBG1TYP	EQU	CMSOUND3+2	;afP^Cv
;
;
;........................................................................
;.		extern RAM						.
;........................................................................
CMSTATIC0	EQU	82H
;
;
;-------------< RtBO >----------------------------------------------
CCONFIGFG	EQU	CMSTATIC0	;RtBO ^CvmD
;
;-------------< vC[{^ >--------------------------------
CP_KEY_JUMP	EQU	CCONFIGFG+2	;Wv{^
CP_KEY_MNAG	EQU	CP_KEY_JUMP+2	;l`w{^
CP_KEY_BERO	EQU	CP_KEY_MNAG+2	;Vbg{^
;
;-------------< vC[W >-----------------------------------------
CPLXSDR		EQU	CP_KEY_BERO+2
;;;;		EQU	CPLXSDR+1	;[ dummy ]
CPLXPSL		EQU	CPLXSDR+2
CPLXPSH		EQU	CPLXPSL+1
CPLYSDR		EQU	CPLXPSH+1
;;;;		EQU	CPLYSDR+1	;[ dummy ]
CPLYPSL		EQU	CPLYSDR+2
CPLYPSH		EQU	CPLYPSL+1
;
;
;------------------------------------------------------------------------
;-		clear RAM.0						-
;------------------------------------------------------------------------
;
CMCLRRM0_S	EQU	CPLYPSH+1
;
;
;........................................................................
;.		static RAM ( game )					.
;........................................................................
;
;-------------< spacial OAM index >--------------------------------------
COAMIDX		EQU	CMCLRRM0_S
;
;-------------< OAM set scroll counter >---------------------------------
CESCCH1		EQU	COAMIDX+2	;BG1_H
CESCCH2		EQU	CESCCH1+2	;" 2 "
CESCCH3		EQU	CESCCH2+2	;" 3 "
CESCCH4		EQU	CESCCH3+2	;" 4 "
CESCCV1		EQU	CESCCH4+2	;BG1_V
CESCCV2		EQU	CESCCV1+2	;" 2 "
CESCCV3		EQU	CESCCV2+2	;" 3 "
CESCCV4		EQU	CESCCV3+2	;" 3 "
;
;-------------< R[Xf[^aff[^pq`l >-----------------
CWRSCH1		EQU	CESCCV4+2	;BG write timming check BG1_H scroll counter
CWRSCV1		EQU	CWRSCH1+2	;	     "             _V        "
;
;-------------< vC[q`l >---------------------------------------
CPLAYER_RAM	EQU	CWRSCV1+2
;
CPLXSPD		EQU	CPLAYER_RAM	;vC[wXs[h
CPLYSPD		EQU	CPLXSPD+2	;     h   x	h
;
CPLMODE		EQU	CPLYSPD+2	;vC[[h
CPLTYPE		EQU	CPLMODE+2	;     h   ^Cv
;
CPLDSXL		EQU	CPLTYPE+2	;display X pos (L)
CPLDSXH		EQU	CPLDSXL+1	;  "     "  "  (H)
CPLDSYL		EQU	CPLDSXH+1	;  "     Y  "  (L)
CPLDSYH		EQU	CPLDSYL+1	;  "     "  "  (H)
;
CPLMVSP		EQU	CPLDSYH+1
CPLANGL		EQU	CPLMVSP+2
;
CPLSKCL		EQU	CPLANGL+2
CPLSKCC		EQU	CPLSKCL+2
CPLSKCR		EQU	CPLSKCC+2
;
CPLPATN		EQU	CPLSKCR+2	;player pattern no.
;
CPLJUMP		EQU	CPLPATN+2	;   "   jump flag
CPLSITD		EQU	CPLJUMP+2	;   "   sit down flag
CPLCMKI		EQU	CPLSITD+2	;   "   muki
;
CPLSWIM		EQU	CPLCMKI+2	;   "   swimming mode flag
CPLSWLK		EQU	CPLSWIM+2	;   "   water walk flag
CPLSWPK		EQU	CPLSWLK+2	;   "   "pula puka" flag
;
CPLSTOP		EQU	CPLSWPK+2	;   "   move stop flag
CPLUPFG		EQU	CPLSTOP+2	;   "   up muki flag
CPLDWFG		EQU	CPLUPFG+2	;   "   down muki flag
CPLSPJP		EQU	CPLDWFG+2	;   "   spacial jump flag
CPLDOSN		EQU	CPLSPJP+2	;   "   hhX[IIhtO
CPLDSNC		EQU	CPLDOSN+2	;	   "            EFCgJE^[
CPLDASH		EQU	CPLDSNC+2	;   "   ߃_bV flag
CPLKAID		EQU	CPLDASH+2	;   "   KitO
CPSPUSH		EQU	CPLKAID+2	;   "   side cross push counter
CPLNAGE		EQU	CPSPUSH+2	;   "   ^}StO
CPLNAGP		EQU	CPLNAGE+2	;	 "        p[JE^[
CPLNAGC		EQU	CPLNAGP+2	;	 "        ^[QbgJE^[
CPLNAGX		EQU	CPLNAGC+2	;	      "             wW
CPLNAGY		EQU	CPLNAGX+2	;	      "             x h
CPLNAGR		EQU	CPLNAGY+2	;	 "        LZJE^[
CPLNAGL		EQU	CPLNAGR+2	;	 "        bNItO
CPLNAGE_EGG	EQU	CPLNAGL+2	;	 "        UtO
CPLNAGE_ANG	EQU	CPLNAGE_EGG+2	;	 "        ^[Qbgpx
CPLNAGE_AMK	EQU	CPLNAGE_ANG+2	;	 "        ^[Qbgpx]
CPLFRCT		EQU	CPLNAGE_AMK+2	;   "   htthJE^[
CPLFRMK		EQU	CPLFRCT+2	;	 "          
;
CPSTPNO		EQU	CPLFRMK+2	;   "   stop move type no.
CPLWALK		EQU	CPSTPNO+2	;   "   walk flag
;
CPLBGNO		EQU	CPLWALK+2	;   "   cross BG no.
CPLBGCR		EQU	CPLBGNO+2	;   "   BG check cross flag
CPLWATR		EQU	CPLBGCR+2	;   "            "
CPLTNEL		EQU	CPLWATR+2	;   "   gl     "
CPLHARI		EQU	CPLTNEL+2	;   "   hari         "
CPLDOOR		EQU	CPLHARI+2	;   "   door         "
CDOKNMK		EQU	CPLDOOR+2	;hJ
CDOKNCT		EQU	CDOKNMK+2	;  h  fړJE^[
CDOKNPT		EQU	CDOKNCT+2	;    h	   p^[JE^[
CDOKNGP		EQU	CDOKNPT+2	;    h	   d̓JE^[
CDOKNCX		EQU	CDOKNGP+2	;    h	   ␳pSwW
;
CTIMING_CNT	EQU	CDOKNCX+2	;^C~O`FbNJE^[
;
CPLFTLN		EQU	CTIMING_CNT+2	;player foot revise value
;
CPCHTRF		EQU	CPLFTLN+2	;player spacial chara DMA flag
CPCOLTR		EQU	CPCHTRF+2	;   "   color transfer no.
;
CPLOAML		EQU	CPCOLTR+2	;player OAM index
CPLYUSN		EQU	CPLOAML+2	;     "     pri.
CPCENTX		EQU	CPLYUSN+2	;	  "         center X pos
CPCENTY		EQU	CPCENTX+2	;	     "             Y  "
CPWIDEX		EQU	CPCENTY+2	;	  "         X wide
CPWIDEY		EQU	CPWIDEX+2	;	  "         Y  "
;
CPLCLOR		EQU	CPWIDEY+2	;   "   color flag
CPLPRIO		EQU	CPLCLOR+2	;   "   BG pri.
;
CPCHNO0		EQU	CPLPRIO+2	;player chara DMA address(L,H,B,H2)
;
CPROTCT		EQU	CPCHNO0+(8*4)	;player ]JE^[
CPROTSP		EQU	CPROTCT+2	;     "     Xs[h
CPROTDW		EQU	CPROTSP+2	;     "     _EtO
;
CCCHGFG		EQU	CPROTDW+2	;ϐgftO
;
;-------------< Vbgq`l >---------------------------------------
CBERFLG		EQU	CCCHGFG+2	; flag
CBERXPS		EQU	CBERFLG+2	; " X pos
CBERYPS		EQU	CBERXPS+2	; "  Y  "
CBRDSXL		EQU	CBERYPS+2	; "  display X pos(L)
CBRDSXH		EQU	CBRDSXL+1	;	"         (H)
CBRDSYL		EQU	CBRDSXH+1	;     "      Y  " (L)
CBRDSYH		EQU	CBRDSYL+1	;	"         (H)
CBRCNTX		EQU	CBRDSYH+1	; "  center X pos
CBRCNTY		EQU	CBRCNTX+2	;     "     Y  "
;
CBERO_GUNYA	EQU	CBRCNTY+2	;rrtO
CBERO_BIRI	EQU	CBERO_GUNYA+2	;rrtO
;
CEATFLG		EQU	CBERO_BIRI+2   ;eat falg
CEATOFX		EQU	CEATFLG+2	; "  offset X
CEATOFY		EQU	CEATOFX+2	;     "     Y
CEATSTP		EQU	CEATOFY+2	; "  stop flag
;
CEATSPF		EQU	CEATSTP+2	;eat spacial flag
CEATSPC		EQU	CEATSPF+2	;     "      counter
CEATSPT		EQU	CEATSPC+2	;     "      number of shot
;
CSUIKA_NO	EQU	CEATSPT+2	;XCJ̎̐
;
;........................................................................
CFIRSHX		EQU	CSUIKA_NO+2	  ;  "  shot X pos
CFIRSHY		EQU	CFIRSHX+2	;    "     Y  "
;........................................................................
CSUIKA_PT	EQU	CSUIKA_NO+2	;    h	   VbgJE^[
;
CEATWK0		EQU	CFIRSHY+2	;eat work RAM
CEATWK1		EQU	CEATWK0+2	;     "
;
;-------------< vC[fpRg[[ >---------------------
CP_KEYC1L	EQU	CEATWK1+2
CP_KEYC2L	EQU	CP_KEYC1L+2
;
;-------------< vC[^Cvʋʂq`l >---------------------------
CPLTYPE_RAM	EQU	CP_KEYC2L+2
;
;.............< bV[q`l >.................................
CPYS_WORK0	EQU	CPLTYPE_RAM	;[Nq`lDP
CPYS_WORK1	EQU	CPYS_WORK0+2	;      h    DQ
CPYS_WORK2	EQU	CPYS_WORK1+2	;      h    DR
CPYS_WORK3	EQU	CPYS_WORK2+2	;      h    DS
;
;.............< ΂񂭂q`l >.............................
CPLBANG		EQU	CPLTYPE_RAM	;[`CfbNX
CPLCCNT		EQU	CPLBANG+2
CPLCNT0		EQU	CPLCCNT+2	;ϐg^C}[
CPLZOOM		EQU	CPLCNT0+2	;{
CPLBMSW		EQU	CPLZOOM+2	;XCb`
CPLBMJP		EQU	CPLBMSW+2	;WvtO
CPLDMGF		EQU	CPLBMJP+2	;_[WtO
;
;.............< wRv^[q`l >.............................
CPHR_ANGL	EQU	CPLTYPE_RAM	;LN^[]px
CPHR_ANSP	EQU	CPHR_ANGL+2	;	h	 Xs[h
CPHR_MKCG	EQU	CPHR_ANSP+2	;UtO
CPHR_FMKF	EQU	CPHR_MKCG+2	;OtO
;
;.............< ͂q`l >...................................
CPSB_ANGL	EQU	CPLTYPE_RAM	;LN^[]px
CPSB_FLCT	EQU	CPSB_ANGL+2	;_[WJE^[
;
;.............< Oq`l >...................................
CPMG_ANGL	EQU	CPLTYPE_RAM	;LN^[]px
CPMG_KEYF	EQU	CPMG_ANGL+2	;ړL[bNtO
CPMG_MVMK	EQU	CPMG_KEYF+2	;ړtO
CPMG_TOAN	EQU	CPMG_MVMK+2	;[Nq`l
CPMG_PTNO	EQU	CPMG_TOAN+2	;p^[mD
CPMG_WALK	EQU	CPMG_PTNO+2	;p^[؂ւobt@
CPMG_CNVKEY	EQU	CPMG_WALK+2	;ړϊRg[[iAj
CPMG_MKANGL	EQU	CPMG_CNVKEY+2	;O]px
CPMG_MKANGL_OLD EQU	CPMG_MKANGL+2	;Ot[O]px
CPMG_BRBGCT	EQU	CPMG_MKANGL_OLD+2 ;afJE^[
CPMG_WRK0	EQU	CPMG_BRBGCT+2	;[Nq`l
CPMG_FLCT	EQU	CPMG_WRK0+2	;_[WJE^[
;
;.............< ܂q`l >...................................
CPLLFTX		EQU	CPLTYPE_RAM	;^CwW
CPLCFTX		EQU	CPLLFTX+2	;	h
CPLRFTX		EQU	CPLCFTX+2	;E	h
CPLLFTY		EQU	CPLRFTX+2	;^CxW
CPLCFTY		EQU	CPLLFTY+2	;	h
CPLRFTY		EQU	CPLCFTY+2	;E	h
CCARYSW		EQU	CPLRFTY+2	;Lтx	h
CCARZOM		EQU	CCARYSW+2	;c{
CCARANG		EQU	CCARZOM+2	;]p
CCARCT0		EQU	CCARANG+2	;Lp^[`FWJE^[
CPLBGSV		EQU	CCARCT0+2	;Ȏ
CCARFTF		EQU	CPLBGSV+2	;L΂tO
CPLANSV		EQU	CCARFTF+2	;Ỏ]p
CPLYPSV		EQU	CPLANSV+2	;ÔxW
CCARWK0		EQU	CPLYPSV+2	;
CCARWK1		EQU	CCARWK0+2	;
CCARBGF		EQU	CCARWK1+2	;aftO
CCARSKV		EQU	CCARBGF+2	;px
CCARBDY		EQU	CCARSKV+2	;{fB[LtO
CRAMCK0		EQU	CCARBDY+2
CRAMCK1		EQU	CRAMCK0+2
CRAMCK2		EQU	CRAMCK1+2
CRAMCK3		EQU	CRAMCK2+2
CRAMCK4		EQU	CRAMCK3+2
;
;.............< DԂq`l >.....................................
CPTR_ANGL	EQU	CPLTYPE_RAM	;]p
CPTR_MODE	EQU	CPTR_ANGL+2	;[[htO
CPTR_ZOOM	EQU	CPTR_MODE+2	;g嗦
CPTR_PTNO	EQU	CPTR_ZOOM+2	;p^[mD
CPTR_WALK	EQU	CPTR_PTNO+2	;p^[؂ւobt@
CPTR_MUKI	EQU	CPTR_WALK+2	;[[h؂ւ
CPTR_MANG	EQU	CPTR_MUKI+2	;ړ]p
CPTR_BACK	EQU	CPTR_MANG+2	;obNtO
CPTR_FLCT	EQU	CPTR_BACK+2	;_[WJE^[
CPTR_SDR	EQU	CPTR_FLCT+2	;WvZpq`l
;
;.............< }Iq`l >...................................
CPMR_ANGL	EQU	CPLTYPE_RAM	;LN^[]px
CPMR_BGCF	EQU	CPMR_ANGL+2	;\jbN[htO
CPMR_WALK	EQU	CPMR_BGCF+2	;p^[؂ւobt@
CPMR_SBCT	EQU	CPMR_WALK+2	;afRh{`hJE^[
CPMR_SBSP	EQU	CPMR_SBCT+2	;	     h		     Xs[h
CPMR_HBCT	EQU	CPMR_SBSP+2	;afh{`hJE^[
CPMR_HBSP	EQU	CPMR_HBCT+2	;	     h		   Xs[h
CPMR_FBCT	EQU	CPMR_HBSP+2	;afh{`hJE^[
CPMR_FBSP	EQU	CPMR_FBCT+2	;	     h		   Xs[h
CPMR_MANT	EQU	CPMR_FBSP+2	;}gp^[JE^[
CPMR_CTYP	EQU	CPMR_MANT+2	;LN^[^Cv
CPMR_CADR	EQU	CPMR_CTYP+2	;      h    AhX
CPMR_CXZM	EQU	CPMR_CADR+2	;      h    w{
CPMR_CYZM	EQU	CPMR_CXZM+2	;      h    x{
CPMR_CNTX	EQU	CPMR_CYZM+2	;      h    Sw
CPMR_CNTY	EQU	CPMR_CNTX+2	;      h    Sx
CPMR_ANSP	EQU	CPMR_CNTY+2	;zoOpLN^[]Xs[h
CPMR_ANBF	EQU	CPMR_ANSP+2	;		  h		     obt@
;
;.............< XL[q`l >...................................
CPSK_ANGL	EQU	CPLTYPE_RAM	;LN^[]px
CPSK_FAIL	EQU	CPSK_ANGL+2	;]уtO
CPSK_WRK0	EQU	CPSK_FAIL+2	;[Nq`lDP
CPSK_WRK1	EQU	CPSK_WRK0+2	;      h      Q
CPSK_WALK	EQU	CPSK_WRK1+2	;ʃZbg`FbNJE^[
;
;
CPLTYPE_RAM_E	EQU	CRAMCK4+2
;
;-------------< naiRg[q`l >-------------------------------
CPLSTFG		EQU	CPLTYPE_RAM_E	;player stop flag
CENSTFG		EQU	CPLSTFG+2	;enemy	    "
;
CBABYNO		EQU	CENSTFG+2	;ԂĂ邩tO
CONLFFG		EQU	CBABYNO+2	;player lift "ON" flag
CPONLFFG	EQU	CONLFFG+2	;	  "
COLD_ONLFFG	EQU	CPONLFFG+2	;	  "           ( old )
CONLFXS		EQU	COLD_ONLFFG+2	;	"         X speed
;
CWATER_Y	EQU	CONLFXS+2	;afRʈʒu
;
CONCHNG		EQU	CWATER_Y+2	;ւݏZbgtO
CONFALL		EQU	CONCHNG+2	;痎鏰ZbgtO
CPUSHFG		EQU	CONFALL+2	;vC[tO
CMISILE		EQU	CPUSHFG+2	;͂̋˒tO
;
CTILTCT		EQU	CMISILE+2	;tilt counter
CTILTCT2	EQU	CTILTCT+2	;tilt counter 2
;
;-------------< ItZbg[htO >---------------------------------
CBG2OF_FG	EQU	CTILTCT2+2
;
;-------------< Ԃ񎀐_čstO >-------------------------
CDEATHCT0	EQU	CBG2OF_FG+2	;death ghost counter 0
;
;-------------< Nbp{XtO >---------------------------------------
CKOOPA_FG	EQU	CDEATHCT0+2
;
;-------------< ^C}[ >-----------------------------------------------
CMTIMST		EQU	CKOOPA_FG+2
;
CPLSLIP		EQU	CMTIMST		;player slip flag
CPLWKTM		EQU	CPLSLIP+2	;   "   walk timer
CPLJPTM		EQU	CPLWKTM+2	;   "   jump   "
CPLFLSH		EQU	CPLJPTM+2	;   "   safty timer
CPSTPTM		EQU	CPLFLSH+2	;   "   stop move timer
CPSBOYO		EQU	CPSTPTM+2	;   "   side "Boyo-n" timer
CPHBOYO		EQU	CPSBOYO+2	;   "   hed         "
CPDSNTM		EQU	CPHBOYO+2	;   "   hhX[IIhtimer
CPSHOTM		EQU	CPDSNTM+2	;   "   shot timer
CPNAGTM		EQU	CPSHOTM+2	;   "   ^}Sp^C}[
CPLTIM0		EQU	CPNAGTM+2	;   "   ܂̂̂тĂĂ^C}[
CPSPJTM		EQU	CPLTIM0+2	;   "   W^o^WvmdwsEFCg^C}[
CPTIMNG		EQU	CPSPJTM+2	;   "   ^C~O`FbN^C}[
CPICHTM		EQU	CPTIMNG+2	;   "   ꏰhs`s`hZbg^C}[
CPLKEYFG	EQU	CPICHTM+2	;vC[L[f[^]tO
CEAT_WAIT	EQU	CPLKEYFG+2	;ݍ݃EFCg^C}[
CPBURAN		EQU	CEAT_WAIT+2	;   "   hu`htO
;
CSOUND_ON	EQU	CPBURAN+2	;TEhZbgtO
;
CPCHNG_TM	EQU	CSOUND_ON+2	;   "   ϐg^C}[
;
;-------------< vC[^Cvʋʃ^C}[ >-----------------
;
;.............< ʂ̃bV[q`l >...........................
CPLWORKTM	EQU	CPCHNG_TM+2
;
;.............< wRv^[q`l >.............................
CPHR_MCTM	EQU	CPLWORKTM
;
;.............< }Iq`l >...................................
CPMR_MNTM	EQU	CPLWORKTM
;
;.............< XL[q`l >...................................
CPSK_TIM0	EQU	CPLWORKTM
;
;
CMTIMEN		EQU	CPLWORKTM+2
;
;
;-------------- static RAM ( ~[WJ ) -----------------------------
;----------- AADA USED RAM ----------------------
COPMSGADR	EQU	CPLAYER_RAM
COPMSGADRB	EQU	COPMSGADR+2
COPMSGYPOS	EQU	COPMSGADRB+2
COPMSGXPOS	EQU	COPMSGYPOS+2
COPMSGBIG	EQU	COPMSGXPOS+2
;;;;;		EQU	COPMSGBIG+2
;
;
;========================================================================
;=		!=0 page RAM						=
;========================================================================
;
;-------------< spacial OAM >--------------------------------------------
COAM_DX		EQU	200H
;
;-------------< OAM >----------------------------------------------------
COAM		EQU	COAM_DX+800H
COAMSUB		EQU	COAM+200H
COAMSB		EQU	COAMSUB+20H
;
;-------------< map extern RAM >-----------------------------------------
CMPANGLE	EQU	COAMSB+80H		;map angle
;
CMPLMODE	EQU	CMPANGLE+2		;map player mode
CMPPLXPOS	EQU	CMPLMODE+2		;     "     long X pos
CMPPLZPOS	EQU	CMPPLXPOS+2		;	"        Z  "
CMPPLYPOS	EQU	CMPPLZPOS+2		;	"        Y  "
;
;
;........................................................................
;.		static RAM ( game )					.
;........................................................................
CMSTATIC1	EQU	CMPPLYPOS+2
;
;-------------< course BG data write RAM >-------------------------------
CUNBUFAD	EQU	CMSTATIC1		;world screen status buffer
;
CBGHSCRBF	EQU	CUNBUFAD+((16*8)*2)	;H_scroll write buffer
CBGVSCRBF	EQU	CBGHSCRBF+20H*2*2	;V	    "
;
;-------------< TEhZbgW >-------------------------------------
CSOUND_X	EQU	CBGVSCRBF+22H*2*2	;TEhZbgwW
CSOUND_Y	EQU	CSOUND_X+2		;	h     x h
;
;-------------< naiLoN >---------------------------------
COBJCHR_BNK	EQU	CSOUND_Y+2
;
;-------------< Gƌʋʂq`l >-------------------------------------
CENXP2L		EQU	COBJCHR_BNK+6
CENXP2H		EQU	CENXP2L+1
CENYP2L		EQU	CENXP2H+1
CENYP2H		EQU	CENYP2L+1
;
CEXMODE		EQU	CENYP2H+1	 ;[ex]
CEXSLOP		EQU	CEXMODE+2
CEX_ADD_XSP	EQU	CEXSLOP+1
CENMODE		EQU	CEXMODE+CEXNO*4
CENSLOP		EQU	CENMODE+2
CEN_ADD_XSP	EQU	CENSLOP+1
CEXMOD0		EQU	CENMODE+CENNO*4	 ;[ex]
CEXMOD1		EQU	CEXMOD0+2
CENMOD0		EQU	CEXMOD0+CEXNO*4
CENMOD1		EQU	CENMOD0+2
CEXMOD2		EQU	CENMOD0+CENNO*4	 ;[ex]
CEXCLOR		EQU	CEXMOD2+2
CENMOD2		EQU	CEXMOD2+CEXNO*4
CENCLOR		EQU	CENMOD2+2
CEXEMU0		EQU	CENMOD2+CENNO*4	 ;[ex]
CEXXSDR		EQU	CEXEMU0+1
CEXXPSL		EQU	CEXXSDR+1
CEXXPSH		EQU	CEXXPSL+1
CENEMU0		EQU	CEXEMU0+CEXNO*4	 ;[ex]
CENXSDR		EQU	CENEMU0+1
CENXPSL		EQU	CENXSDR+1
CENXPSH		EQU	CENXPSL+1
CEXCHRB		EQU	CENEMU0+CENNO*4	 ;[ex]
CEXYSDR		EQU	CEXCHRB+1
CEXYPSL		EQU	CEXYSDR+1
CEXYPSH		EQU	CEXYPSL+1
CENCHRB		EQU	CEXCHRB+CEXNO*4
CENYSDR		EQU	CENCHRB+1
CENYPSL		EQU	CENYSDR+1
CENYPSH		EQU	CENYPSL+1
CEXXSPD		EQU	CENCHRB+CENNO*4	 ;[ex]
CEXXSPH		EQU	CEXXSPD+1
CEXYSPD		EQU	CEXXSPH+1
CEXYSPH		EQU	CEXYSPD+1
CENXSPD		EQU	CEXXSPD+CEXNO*4
CENXSPH		EQU	CENXSPD+1
CENYSPD		EQU	CENXSPH+1
CENYSPH		EQU	CENYSPD+1
CEXMOVX		EQU	CENXSPD+CENNO*4	 ;[ex]
CEXMOVY		EQU	CEXMOVX+2
CENMOVX		EQU	CEXMOVX+CEXNO*4
CENMOVY		EQU	CENMOVX+2
CEXSTNO		EQU	CENMOVX+CENNO*4	 ;[ex]
CEXOAML		EQU	CEXSTNO+2
CENMYNO		EQU	CEXSTNO+CEXNO*4
CENOAML		EQU	CENMYNO+2
CEXMUKI		EQU	CENMYNO+CENNO*4	 ;[ex]
CEXCHPT		EQU	CEXMUKI+2
CENMUKI		EQU	CEXMUKI+CEXNO*4
CENCHPT		EQU	CENMUKI+2
CEXRETN		EQU	CENMUKI+CENNO*4	 ;[ex]
CEXDORE		EQU	CEXRETN+1
CEXYUSN		EQU	CEXDORE+1
CENRETN		EQU	CEXRETN+CEXNO*4
CENDORE		EQU	CENRETN+1
CENYUSN		EQU	CENDORE+1
CEXXPOW		EQU	CENRETN+CENNO*4	 ;[ex]
CEXGPOW		EQU	CEXXPOW+2
CENXPOW		EQU	CEXXPOW+CEXNO*4	 ;[ex]
CENGPOW		EQU	CENXPOW+2
CEXXMAX		EQU	CENXPOW+CENNO*4	 ;[ex]
CEXGMAX		EQU	CEXXMAX+2
CENXMAX		EQU	CEXXMAX+CEXNO*4	 ;[ex]
CENGMAX		EQU	CENXMAX+2
CEXDSXL		EQU	CENXMAX+CENNO*4	 ;[ex]
CEXDSXH		EQU	CEXDSXL+1
CEXDSYL		EQU	CEXDSXH+1
CEXDSYH		EQU	CEXDSYL+1
CENDSXL		EQU	CEXDSXL+CEXNO*4
CENDSXH		EQU	CENDSXL+1
CENDSYL		EQU	CENDSXH+1
CENDSYH		EQU	CENDSYL+1
CEXBGYP		EQU	CENDSXL+CENNO*4	 ;[ex]
CEXTROB		EQU	CEXBGYP+2
CENBGYP		EQU	CEXBGYP+CEXNO*4
CENTROB		EQU	CENBGYP+2
CEXWRKX		EQU	CENBGYP+CENNO*4	 ;[ex]
CEXSPTM		EQU	CEXWRKX+1
CEXTIM0		EQU	CEXSPTM+1
CENWRKX		EQU	CEXWRKX+CEXNO*4
CENSPTM		EQU	CENWRKX+1
CEPXMUK		EQU	CENSPTM+1
CEPYMUK		EQU	CEPXMUK+1
CEXCBFG		EQU	CENWRKX+CENNO*4	 ;[ex] BG cross flag
CEXWATR		EQU	CEXCBFG+2	 ;     water in flag
CEXWTSP		EQU	CEXWATR+1	 ;     water in speed
CENCBFG		EQU	CEXCBFG+CEXNO*4
CENWATR		EQU	CENCBFG+2
CENWTSP		EQU	CENWATR+1
CEXWRKA		EQU	CENCBFG+CENNO*4	 ;enemy work RAM.A
CEXWRKB		EQU	CEXWRKA+1	 ;	 "      .B
CEXWRKC		EQU	CEXWRKB+1	 ;	 "      .C
CEXWRKD		EQU	CEXWRKC+1	 ;	 "      .D
CENWRKA		EQU	CEXWRKA+CEXNO*4	 ;	 "      .A
CENWRKB		EQU	CENWRKA+1	 ;	 "      .B
CENWRKC		EQU	CENWRKB+1	 ;	 "      .C
CENWRKD		EQU	CENWRKC+1	 ;	 "      .D
;
;-------------< Ĝq`l >---------------------------------------------
;
;-------------< ĜOy[Wq`l >-----------------------------
CEN0RAM		EQU	CENWRKA+CENNO*4
;
CEWORK		EQU	CEN0RAM		;work RAM
CEWORK0		EQU	CEN0RAM
CEWORK1		EQU	CEWORK+1
CEWORK2		EQU	CEWORK1+1
CEWORK3		EQU	CEWORK2+1
CEWORK4		EQU	CEWORK3+1
CEWORK5		EQU	CEWORK4+1
CEWORK6		EQU	CEWORK5+1
CEWORK7		EQU	CEWORK6+1
CEWORK8		EQU	CEWORK7+1
CEWORK9		EQU	CEWORK8+1
CEWORKA		EQU	CEWORK9+1
CEWORKB		EQU	CEWORKA+1
CEWORKC		EQU	CEWORKB+1
CEWORKD		EQU	CEWORKC+1
CEWORKE		EQU	CEWORKD+1
CEWORKF		EQU	CEWORKE+1
;
CRANDM0		EQU	CEWORKF+1	;random buffer
CENINDX		EQU	CRANDM0+2	;enemy index
CFRCNT2		EQU	CENINDX+2	;freme counter
;
CENCONT		EQU	CFRCNT2+2	;enemy work counter
CENWRK0		EQU	CENCONT+2	;     "     RAM.0
CENWRK1		EQU	CENWRK0+1	;	"      .1
CENWRK2		EQU	CENCONT+CENNO*4 ;	"      .2
CENWRK3		EQU	CENWRK2+1	;	"      .3
CENWRK4		EQU	CENWRK3+1	;	"      .4
CENWRK5		EQU	CENWRK4+1	;	"      .5
;
;-------------< ĜOy[WȊÔq`l >-------------------------------
CENWRK6		EQU	CENWRK2+CENNO*4 ;enemy work RAM.6	iړ炠ł`IIj
CENWRK7		EQU	CENWRK6+1	;	"      .7       iړ炠ł`IIj
CENWRK8		EQU	CENWRK7+1	;	"      .8       iړ炠ł`IIj
CENWRK9		EQU	CENWRK8+1	;	"      .9       iړ炠ł`IIj
CENTIM0		EQU	CENWRK6+CENNO*4 ;  "   timer.0
CENTIM1		EQU	CENTIM0+2	;     "     .1
CENTIM2		EQU	CENTIM0+CENNO*4 ;     "     .2
CENTIM3		EQU	CENTIM2+2	;     "     .3
;
CECNTXW		EQU	CENTIM2+CENNO*4
CECNTYW		EQU	CECNTXW+2
CEWIDEX		EQU	CECNTXW+CENNO*4
CEWIDEY		EQU	CEWIDEX+2
CEPWIDX		EQU	CEWIDEX+CENNO*4
CEPWIDY		EQU	CEPWIDX+2
CECROSX		EQU	CEPWIDX+CENNO*4
CECROSY		EQU	CECROSX+2
CECENTX		EQU	CECROSX+CENNO*4
CECENTY		EQU	CECENTX+2
CECRSFG		EQU	CECENTX+CENNO*4
CENCRPT		EQU	CECRSFG+1
CENSHOT		EQU	CENCRPT+1
CENCOLD		EQU	CECRSFG+CENNO*4
;;;;		EQU	CENCOLD+2	;󂫁II
;
;-------------< ^}SIvVpq`l >-------------------------------
CEGGPNT		EQU	CENCOLD+CENNO*4
CEGGLNK		EQU	CEGGPNT+2
;
;-------------< GtO >---------------------------------------------
CSUPER_FLAG	EQU	CEGGLNK+(6*2)
;
;-------------< ዾnm^neeXCb` >-----------------------------
CGRASS_ON	EQU	CSUPER_FLAG+2
;
;
;------------------------------------------------------------------------
;-		clear RAM.1						-
;------------------------------------------------------------------------
CMCLRRM1_S	EQU	CGRASS_ON+2
;
;
;-------------< _ubNRCnm^neeXCb` >---------------
CSWITCH_1	EQU	CMCLRRM1_S
;
;-------------< XN[pq`l >-------------------------------------
CSCRONF		EQU	CSWITCH_1+2
;
CESCCH1L	EQU	CSCRONF+2
CESCCV1L	EQU	CESCCH1L+2
;
CPLXSDR_OLD	EQU	CESCCV1L+2
CPLXPSL_OLD	EQU	CPLXSDR_OLD+2
CPLXPSH_OLD	EQU	CPLXPSL_OLD+1
CPLYSDR_OLD	EQU	CPLXPSH_OLD+1
CPLYPSL_OLD	EQU	CPLYSDR_OLD+2
CPLYPSH_OLD	EQU	CPLYPSL_OLD+1
;
CPLSCRL_MINX	EQU	CPLYPSH_OLD+1
CPLSCRL_MAXX	EQU	CPLSCRL_MINX+2
CPLSCRL_MINY	EQU	CPLSCRL_MAXX+2
CPLSCRL_MAXY	EQU	CPLSCRL_MINY+2
CPLSCRL_CX	EQU	CPLSCRL_MAXY+2
CPLSCRL_CY	EQU	CPLSCRL_CX+2
CPLSCRL_TM	EQU	CPLSCRL_CY+2
;
CSCRL_XSDR	EQU	CPLSCRL_TM+2
CSCRL_XSPD	EQU	CSCRL_XSDR+2
;
CSP_SCRL_FG	EQU	CSCRL_XSPD+2	;XN[tO
CSP_SCRL_USER	EQU	CSP_SCRL_FG+2	;	  h	   gp[U[tO
CSP_SCRL_XPS	EQU	CSP_SCRL_USER+2 ;	  h	   wW
CSP_SCRL_YPS	EQU	CSP_SCRL_XPS+2	;	  h	   x h
CSP_SCRL_XSDR	EQU	CSP_SCRL_YPS+2	;	  h	   w h ikj
CSP_SCRL_YSDR	EQU	CSP_SCRL_XSDR+2 ;	  h	   x	h
CSP_SCRL_XSP	EQU	CSP_SCRL_YSDR+2 ;	  h	   wXs[h
CSP_SCRL_YSP	EQU	CSP_SCRL_XSP+2	;	  h	   x	h
;
;-------------< vC[q`l >---------------------------------------
CPL_ADD_XSP	EQU	CSP_SCRL_YSP+2	;vC[w
CPL_ANGL_YSP	EQU	CPL_ADD_XSP+2	;    h	   ړpxxXs[h
;
;-------------< BG3 polygon RAM >----------------------------------------
CPOLYONFG	EQU	CPL_ANGL_YSP+2	;BG3 polygon on flag ( Y loop )
CPOLYANG	EQU	CPOLYONFG+2	;     "      rotation angle
CPOLYXPS	EQU	CPOLYANG+2	;     "      center X pos
;
CPOLYPLXD	EQU	CPOLYXPS+2	;     "      player "Gusha" !! X pos
;;;;		EQU	CPOLYPLXD+1	;		    "
CPOLYPLXL	EQU	CPOLYPLXD+2	;		    "
CPOLYPLXH	EQU	CPOLYPLXL+1	;		    "
;
;-------------< vC[ɏĂGCfbNX >---------------------
CNOSEIDX	EQU	CPOLYPLXH+1	;[ OFĂȂ ]
;
;-------------< ʂ̂q`l >-------------------------------------------
CEXSTCT		EQU	CNOSEIDX+2	;kouka set pointer
;
CEXWRK0		EQU	CEXSTCT+2	;kouka work RAM.0
CEXWRK1		EQU	CEXWRK0+1	;	"      .1
CEXWRK2		EQU	CEXWRK1+1	;	"      .2
CEXWRK3		EQU	CEXWRK2+1	;	"      .3
CEXWRK4		EQU	CEXWRK0+CEXNO*4 ;	"      .4
CEXWRK5		EQU	CEXWRK4+1	;	"      .5
CEXTIM1		EQU	CEXWRK5+1	;  "   timer.1
;
;-------------< ]GA >-----------------------------------------
CTROBJ_ARIA	EQU	CEXWRK4+CEXNO*4
CTROBJ_SIZE	EQU	CTROBJ_ARIA+2
;
;-------------< BG mode 2 ( offset ) RAM >-------------------------------
CBG2OFH		EQU	CTROBJ_SIZE+(16*2)
CBG2OFV		EQU	CBG2OFH+2
CBG2OFF		EQU	CBG2OFV+2
CBG2OFST_CP	EQU	CBG2OFF+(40H*2)
CBG2OFTBL	EQU	CBG2OFST_CP+80
CBG2SCR_CNT	EQU	CBG2OFTBL+33+1
CBG2V_CNT	EQU	CBG2SCR_CNT+2
;
;-------------< htth[htO >-------------------------------
CFURA_FG	EQU	CBG2V_CNT+2
;
;-------------< glhm^ntsptO >---------------------------
CCCHGTN		EQU	CFURA_FG+2
CCCHGTK		EQU	CCCHGTN+2
;
;-------------< ~jQ[tO >---------------------------------------
CMINI_GAME_FG	EQU	CCCHGTK+2
;
;
CMCLRRM1_E	EQU	CMINI_GAME_FG+2
CMCLR1SE	EQU	CMCLRRM1_E-CMCLRRM1_S
;
;
;-------------< TATUMAKI >-----------------------------------------------
CTAT_XPOS	EQU	CMCLRRM1_E
CTAT_YPOS	EQU	CTAT_XPOS + 2
CTAT_MODE	EQU	CTAT_YPOS + 2
;;;;;;;;	EQU	CTAT_MODE + 2
;
;------------------------------------------------------------------------
;-		clear RAM.1 end						-
;------------------------------------------------------------------------
;
;
;........................................................................
;.		static RAM ( map )					.
;........................................................................
;
;-------------< H-DMA buffer >-------------------------------------------
CMPHDMAB0	EQU	CMSTATIC1	;H-DMA buffer.0 ( X  cos )
CMPHDMAB1	EQU	CMPHDMAB0+70H*2 ;	"    .1 ( X  sin )
CMPHDMAB2	EQU	CMPHDMAB1+70H*2 ;	"    .2 ( Y -sin )
CMPHDMAB3	EQU	CMPHDMAB2+70H*2 ;	"    .3 ( Y  cos )
;
;
;-------------< map OBJ RAM >--------------------------------------------
;
MPOBJN		EQU	150			;map OBJ max no
;
;-------------- map clear RAM -----------------------------------
CMMPCLRRM_S	EQU	CMPHDMAB3+70H*2
;
CMPOBJSTN	EQU	CMMPCLRRM_S		;map OBJ set no
;
CMPOBJTYP	EQU	CMPOBJSTN+2		;    "   type no.
CMPOBJXPS	EQU	CMPOBJTYP+1		;    "   X pos
CMPOBJZPS	EQU	CMPOBJXPS+1		;    "   Z  "
CMPOBJYPS	EQU	CMPOBJZPS+1		;    "   Y  "
;
CMPWOBJXPS	EQU	CMPOBJTYP+MPOBJN*4	;map work OBJ X pos
CMPWOBJYPS	EQU	CMPWOBJXPS+1		;      "      Y  "
CMPWOBJSIZ	EQU	CMPWOBJYPS+1		;      "      zoom size
;
CMPWOBJZPS	EQU	CMPWOBJXPS+MPOBJN*4	;      "      Z pos
CMPSORTIDX	EQU	CMPWOBJZPS+1		;	  "         sort index buffer
;
CMMPCLRRM_E	EQU	CMPWOBJZPS+MPOBJN*2
;
CMPWORK		EQU	CMMPCLRRM_E
;;;;		EQU	CMPWORK+(MPOBJN/2)*4
;
;-------------- map player RAM define -------------------
CMPPLTYP	EQU	CMPOBJTYP		;player type no.
CMPPLXPS	EQU	CMPOBJXPS		;   "   X pos
CMPPLZPS	EQU	CMPOBJZPS		;   "   Z  "
CMPPLYPS	EQU	CMPOBJYPS		;   "   Y  "
CMPPLSIZ	EQU	CMPWOBJSIZ		;   "   zoom size
;
;-------------- move OBJ RAM define ---------------------
CMPMVTYP	EQU	CMPOBJTYP+4		;move OBJ type no.
CMPMVXPS	EQU	CMPOBJXPS+4		;    "    X pos
CMPMVZPS	EQU	CMPOBJZPS+4		;    "    Z  "
CMPMVYPS	EQU	CMPOBJYPS+4		;    "    Y  "
CMPWMVYPS	EQU	CMPWOBJYPS+4		;    "    work Y pos
CMPMVSIZ	EQU	CMPWOBJSIZ+4		;    "    zoom size
;
;
;
;************************************************************************
;*		SFC							*
;************************************************************************
;
;========================================================================
;=		0 page RAM						=
;========================================================================
;
;-------------< work RAM >-----------------------------------------------
CCWORK		EQU	6000H
CCWORK0		EQU	CCWORK
CCWORK1		EQU	CCWORK0+2
CCWORK2		EQU	CCWORK1+2
CCWORK3		EQU	CCWORK2+2
CCWORK4		EQU	CCWORK3+2
CCWORK5		EQU	CCWORK4+2
CCWORK6		EQU	CCWORK5+2
CCWORK7		EQU	CCWORK6+2
CCWORK8		EQU	CCWORK7+2
CCWORK9		EQU	CCWORK8+2
CCWORKA		EQU	CCWORK9+2
CCWORKB		EQU	CCWORKA+2
CCWORKC		EQU	CCWORKB+2
CCWORKD		EQU	CCWORKC+2
CCWORKE		EQU	CCWORKD+2
CCWORKF		EQU	CCWORKE+2
;
CCWORK10	EQU	CCWORKF+2
CCWORK11	EQU	CCWORK10+2
CCWORK12	EQU	CCWORK11+2
CCWORK13	EQU	CCWORK12+2
CCWORK14	EQU	CCWORK13+2
CCWORK15	EQU	CCWORK14+2
CCWORK16	EQU	CCWORK15+2
CCWORK17	EQU	CCWORK16+2
CCWORK18	EQU	CCWORK17+2
CCWORK19	EQU	CCWORK18+2
CCWORK1A	EQU	CCWORK19+2
CCWORK1B	EQU	CCWORK1A+2
CCWORK1C	EQU	CCWORK1B+2
CCWORK1D	EQU	CCWORK1C+2
CCWORK1E	EQU	CCWORK1D+2
CCWORK1F	EQU	CCWORK1E+2
;
;-------------< register save RAM >--------------------------------------
CREG0		EQU	CCWORK1F+2
CREG1		EQU	CREG0+2
CREG2		EQU	CREG1+2
CREG3		EQU	CREG2+2
CREG4		EQU	CREG3+2
CREG5		EQU	CREG4+2
CREG6		EQU	CREG5+2
CREG7		EQU	CREG6+2
CREG8		EQU	CREG7+2
CREG9		EQU	CREG8+2
CREG10		EQU	CREG9+2
CREG11		EQU	CREG10+2
CREG12		EQU	CREG11+2
CREG13		EQU	CREG12+2
CREG14		EQU	CREG13+2
CREG15		EQU	CREG14+2
;
;-------------< R11 ( return address ) save RAM >------------------------
CRTS0		EQU	CREG15+2
CRTS1		EQU	CRTS0+2
CRTS2		EQU	CRTS1+2
CRTS3		EQU	CRTS2+2
CRTS4		EQU	CRTS3+2
CRTS5		EQU	CRTS4+2
CRTS6		EQU	CRTS5+2
CRTS7		EQU	CRTS6+2
;
;
;-------------< free work RAM >------------------------------------------
FREE_WORK	EQU	CRTS7+2
;
;
;........................................................................
;.		free work RAM ( game )					.
;........................................................................
;
;-------------< Rg[[ >-------------------------------------
MKEYC1L		EQU	FREE_WORK
MKEYC1		EQU	MKEYC1L+1
MKEYC2L		EQU	MKEYC1+1
MKEYC2		EQU	MKEYC2L+1
;
;-------------< TEhtO >-----------------------------------------
MSOUND0		EQU	MKEYC2+1	;l|pTEhtO
MSOUND1		EQU	MSOUND0+2	;	      h
MSOUND2		EQU	MSOUND1+2	;	      h
MSOUND3		EQU	MSOUND2+2	;	      h
;
;-------------< tO >---------------------------------------------
MBG1TYP		EQU	MSOUND3+2	;afP^Cv
;
;
;........................................................................
;.		extern RAM						.
;........................................................................
MSTATIC0	EQU	6082H
;
;
;-------------< RtBO >----------------------------------------------
CONFIGFG	EQU	MSTATIC0	;RtBO ^CvmD
;
;-------------< vC[{^ >--------------------------------
P_KEY_JUMP	EQU	CONFIGFG+2	;Wv{^
P_KEY_MNAG	EQU	P_KEY_JUMP+2	;l`w{^
P_KEY_BERO	EQU	P_KEY_MNAG+2	;Vbg{^
;
;-------------< vC[W >-----------------------------------------
PLXSDR		EQU	P_KEY_BERO+2
;;;;		EQU	PLXSDR+1	;[ dummy ]
PLXPSL		EQU	PLXSDR+2
PLXPSH		EQU	PLXPSL+1
PLYSDR		EQU	PLXPSH+1
;;;;		EQU	PLYSDR+1	;[ dummy ]
PLYPSL		EQU	PLYSDR+2
PLYPSH		EQU	PLYPSL+1
;
;
;------------------------------------------------------------------------
;-		clear RAM.0						-
;------------------------------------------------------------------------
;
MCLRRM0_S	EQU	PLYPSH+1
;
;
;........................................................................
;.		static RAM ( game )					.
;........................................................................
;
;-------------< spacial OAM index >--------------------------------------
OAMIDX		EQU	MCLRRM0_S
;
;-------------< OAM set scroll counter >---------------------------------
ESCCH1		EQU	OAMIDX+2	;BG1_H
ESCCH2		EQU	ESCCH1+2	;" 2 "
ESCCH3		EQU	ESCCH2+2	;" 3 "
ESCCH4		EQU	ESCCH3+2	;" 4 "
ESCCV1		EQU	ESCCH4+2	;BG1_V
ESCCV2		EQU	ESCCV1+2	;" 2 "
ESCCV3		EQU	ESCCV2+2	;" 3 "
ESCCV4		EQU	ESCCV3+2	;" 4 "
;
;-------------< R[Xf[^aff[^pq`l >-----------------
WRSCH1		EQU	ESCCV4+2	;BG write timming check BG1_H scroll counter
WRSCV1		EQU	WRSCH1+2	;	     "             _V        "

;-------------< vC[q`l >---------------------------------------
PLAYER_RAM	EQU	WRSCV1+2
;
PLXSPD		EQU	PLAYER_RAM	;vC[wXs[h
PLYSPD		EQU	PLXSPD+2	;     h   x	h
;
PLMODE		EQU	PLYSPD+2	;vC[[h
PLTYPE		EQU	PLMODE+2	;     h   ^Cv
;
PLDSXL		EQU	PLTYPE+2	;display X pos (L)
PLDSXH		EQU	PLDSXL+1	;  "     "  "  (H)
PLDSYL		EQU	PLDSXH+1	;  "     Y  "  (L)
PLDSYH		EQU	PLDSYL+1	;  "     "  "  (H)
;
PLMVSP		EQU	PLDSYH+1
PLANGL		EQU	PLMVSP+2
;
PLSKCL		EQU	PLANGL+2
PLSKCC		EQU	PLSKCL+2
PLSKCR		EQU	PLSKCC+2
;
PLPATN		EQU	PLSKCR+2	;player pattern no.
;
PLJUMP		EQU	PLPATN+2	;   "   jump flag
PLSITD		EQU	PLJUMP+2	;   "   sit down flag
PLCMKI		EQU	PLSITD+2	;   "   muki
;
PLSWIM		EQU	PLCMKI+2	;   "   swimming mode flag
PLSWLK		EQU	PLSWIM+2	;   "   water walk flag
PLSWPK		EQU	PLSWLK+2	;   "   "pula puka" flag
;
PLSTOP		EQU	PLSWPK+2	;   "   move stop flag
PLUPFG		EQU	PLSTOP+2	;   "   up muki flag
PLDWFG		EQU	PLUPFG+2	;   "   down muki flag
PLSPJP		EQU	PLDWFG+2	;   "   spacial jump flag
PLDOSN		EQU	PLSPJP+2	;   "   hhX[IIhtO
PLDSNC		EQU	PLDOSN+2	;	   "            EFCgJE^[
PLDASH		EQU	PLDSNC+2	;   "   ߃_bV flag
PLKAID		EQU	PLDASH+2	;   "   KitO
PSPUSH		EQU	PLKAID+2	;   "   side cross push counter
PLNAGE		EQU	PSPUSH+2	;   "   ^}StO
PLNAGP		EQU	PLNAGE+2	;	 "        p[JE^[
PLNAGC		EQU	PLNAGP+2	;	 "        ^[QbgJE^[
PLNAGX		EQU	PLNAGC+2	;	      "             wW
PLNAGY		EQU	PLNAGX+2	;	      "             x h
PLNAGR		EQU	PLNAGY+2	;	 "        LZJE^[
PLNAGL		EQU	PLNAGR+2	;	 "        bNItO
PLNAGE_EGG	EQU	PLNAGL+2	;	 "        UtO
PLNAGE_ANG	EQU	PLNAGE_EGG+2	;	 "        ^[Qbgpx
PLNAGE_AMK	EQU	PLNAGE_ANG+2	;	 "        ^[Qbgpx]
PLFRCT		EQU	PLNAGE_AMK+2	;   "   htthJE^[
PLFRMK		EQU	PLFRCT+2	;	 "          
;
PSTPNO		EQU	PLFRMK+2	;   "   stop move type no.
PLWALK		EQU	PSTPNO+2	;   "   walk flag
;
PLBGNO		EQU	PLWALK+2	;   "   cross BG no.
PLBGCR		EQU	PLBGNO+2	;   "   BG check cross flag
PLWATR		EQU	PLBGCR+2	;   "            "
PLTNEL		EQU	PLWATR+2	;   "   gl     "
PLHARI		EQU	PLTNEL+2	;   "   hari         "
PLDOOR		EQU	PLHARI+2	;   "   door         "
DOKNMK		EQU	PLDOOR+2	;hJ
DOKNCT		EQU	DOKNMK+2	;  h  fړJE^[
DOKNPT		EQU	DOKNCT+2	;    h	   p^[JE^[
DOKNGP		EQU	DOKNPT+2	;    h	   d̓JE^[
DOKNCX		EQU	DOKNGP+2	;    h	   ␳pSwW
;
TIMING_CNT	EQU	DOKNCX+2	;^C~O`FbNJE^[
;
PLFTLN		EQU	TIMING_CNT+2	;player foot revise value
;
PCHTRF		EQU	PLFTLN+2	;player spacial chara DMA flag
PCOLTR		EQU	PCHTRF+2	;   "   color transfer no.
;
PLOAML		EQU	PCOLTR+2	;player OAM index
PLYUSN		EQU	PLOAML+2	;     "     pri.
PCENTX		EQU	PLYUSN+2	;	  "         center X pos
PCENTY		EQU	PCENTX+2	;	     "             Y  "
PWIDEX		EQU	PCENTY+2	;	  "         X wide
PWIDEY		EQU	PWIDEX+2	;	  "         Y  "
;
PLCLOR		EQU	PWIDEY+2	;   "   color flag
PLPRIO		EQU	PLCLOR+2	;   "   BG pri.
;
PCHNO0		EQU	PLPRIO+2	;player chara DMA address(L,H,B,H2)
;
PROTCT		EQU	PCHNO0+(8*4)	;player ]JE^[
PROTSP		EQU	PROTCT+2	;     "     Xs[h
PROTDW		EQU	PROTSP+2	;     "     _EtO
;
CCHGFG		EQU	PROTDW+2	;ϐgftO
;
;-------------< Vbgq`l >---------------------------------------
BERFLG		EQU	CCHGFG+2	; flag
BERXPS		EQU	BERFLG+2	; " X pos
BERYPS		EQU	BERXPS+2	; "  Y  "
BRDSXL		EQU	BERYPS+2	; "  display X pos(L)
BRDSXH		EQU	BRDSXL+1	;	"         (H)
BRDSYL		EQU	BRDSXH+1	;     "      Y  " (L)
BRDSYH		EQU	BRDSYL+1	;	"         (H)
BRCNTX		EQU	BRDSYH+1	; "  center X pos
BRCNTY		EQU	BRCNTX+2	;     "     Y  "
;
BERO_GUNYA	EQU	BRCNTY+2	;rrtO
BERO_BIRI	EQU	BERO_GUNYA+2	;rrtO
;
EATFLG		EQU	BERO_BIRI+2	;eat falg
EATOFX		EQU	EATFLG+2	; "  offset X
EATOFY		EQU	EATOFX+2	;     "     Y
EATSTP		EQU	EATOFY+2	; "  stop flag
;
EATSPF		EQU	EATSTP+2	;eat spacial flag
EATSPC		EQU	EATSPF+2	;     "      counter
EATSPT		EQU	EATSPC+2	;     "      number of shot
;
SUIKA_NO	EQU	EATSPT+2	;XCJ̎̐
;
;........................................................................
FIRSHX		EQU	SUIKA_NO+2	;  "  shot X pos
FIRSHY		EQU	FIRSHX+2	;    "     Y  "
;........................................................................
SUIKA_PT	EQU	SUIKA_NO+2	;    h	   VbgJE^[
;
EATWK0		EQU	FIRSHY+2	;eat work RAM
EATWK1		EQU	EATWK0+2	;     "
;
;-------------< vC[fpRg[[ >---------------------
P_KEYC1L	EQU	EATWK1+2
P_KEYC2L	EQU	P_KEYC1L+2
;
;-------------< vC[^Cvʋʂq`l >---------------------------
PLTYPE_RAM	EQU	P_KEYC2L+2
;
;.............< bV[q`l >...................................
PYS_WORK0	EQU	PLTYPE_RAM	;[Nq`lDP
PYS_WORK1	EQU	PYS_WORK0+2	;      h    DQ
PYS_WORK2	EQU	PYS_WORK1+2	;      h    DR
PYS_WORK3	EQU	PYS_WORK2+2	;      h    DS
;
;.............< ΂񂭂q`l >...............................
PLBANG		EQU	PLTYPE_RAM
PLCCNT		EQU	PLBANG+2
PLCNT0		EQU	PLCCNT+2
PLZOOM		EQU	PLCNT0+2
PLBMSW		EQU	PLZOOM+2
PLBMJP		EQU	PLBMSW+2
PLDMGF		EQU	PLBMJP+2
;
;.............< wRv^[q`l >.............................
PHR_ANGL	EQU	PLTYPE_RAM	;LN^[]px
PHR_ANSP	EQU	PHR_ANGL+2	;	h	 Xs[h
PHR_MKCG	EQU	PHR_ANSP+2	;UtO
PHR_FMKF	EQU	PHR_MKCG+2	;OtO
;
;.............< ͂q`l >...............................
PSB_ANGL	EQU	PLTYPE_RAM	;LN^[]px
PSB_FLCT	EQU	PSB_ANGL+2	;_[WJE^[
;
;.............< Oq`l >...............................
PMG_ANGL	EQU	PLTYPE_RAM	;LN^[]px
PMG_KEYF	EQU	PMG_ANGL+2	;ړL[bNtO
PMG_MVMK	EQU	PMG_KEYF+2	;ړtO
PMG_TOAN	EQU	PMG_MVMK+2	;[Nq`l
PMG_PTNO	EQU	PMG_TOAN+2	;p^[mD
PMG_WALK	EQU	PMG_PTNO+2	;p^[؂ւobt@
PMG_CNVKEY	EQU	PMG_WALK+2	;ړϊRg[[iAj
PMG_MKANGL	EQU	PMG_CNVKEY+2	;O]px
PMG_MKANGL_OLD	EQU	PMG_MKANGL+2	;Ot[O]px
PMG_BRBGCT	EQU	PMG_MKANGL_OLD+2 ;afJE^[
PMG_WRK0	EQU	PMG_BRBGCT+2	;[Nq`l
PMG_FLCT	EQU	PMG_WRK0+2	;_[WJE^[
;
;.............< ܂q`l >...............................
PLLFTX		EQU	PLTYPE_RAM	;^CwW
PLCFTX		EQU	PLLFTX+2	;	h
PLRFTX		EQU	PLCFTX+2	;E	h
PLLFTY		EQU	PLRFTX+2	;^CxW
PLCFTY		EQU	PLLFTY+2	;	h
PLRFTY		EQU	PLCFTY+2	;E	h
CARYSW		EQU	PLRFTY+2	;Lтx	h
CARZOM		EQU	CARYSW+2
CARANG		EQU	CARZOM+2
CARCT0		EQU	CARANG+2
PLBGSV		EQU	CARCT0+2	;Ȏ
CARFTF		EQU	PLBGSV+2	;L΂tO
PLANSV		EQU	CARFTF+2	;Ỏ]p
PLYPSV		EQU	PLANSV+2	;ÔxW
CARWK0		EQU	PLYPSV+2	;
CARWK1		EQU	CARWK0+2
CARBGF		EQU	CARWK1+2
CARSKV		EQU	CARBGF+2
CARBDY		EQU	CARSKV+2
RAMCK0		EQU	CARBDY+2
RAMCK1		EQU	RAMCK0+2
RAMCK2		EQU	RAMCK1+2
RAMCK3		EQU	RAMCK2+2
RAMCK4		EQU	RAMCK3+2
;
;.............< DԂq`l >.................................
PTR_ANGL	EQU	PLTYPE_RAM	;]p
PTR_MODE	EQU	PTR_ANGL+2	;[[htO
PTR_ZOOM	EQU	PTR_MODE+2	;g嗦
PTR_PTNO	EQU	PTR_ZOOM+2	;p^[mD
PTR_WALK	EQU	PTR_PTNO+2	;p^[؂ւobt@
PTR_MUKI	EQU	PTR_WALK+2	;[[h؂ւ
PTR_MANG	EQU	PTR_MUKI+2	;ړ]p
PTR_BACK	EQU	PTR_MANG+2	;obNtO
PTR_FLCT	EQU	PTR_BACK+2	;_[WJE^[
PTR_SDR		EQU	PTR_FLCT+2	;WvZpq`l
;
;.............< }Iq`l >...............................
PMR_ANGL	EQU	PLTYPE_RAM	;LN^[]px
PMR_BGCF	EQU	PMR_ANGL+2	;\jbN[htO
PMR_WALK	EQU	PMR_BGCF+2	;p^[؂ւobt@
PMR_SBCT	EQU	PMR_WALK+2	;afRh{`hJE^[
PMR_SBSP	EQU	PMR_SBCT+2	;	     h		     Xs[h
PMR_HBCT	EQU	PMR_SBSP+2	;afh{`hJE^[
PMR_HBSP	EQU	PMR_HBCT+2	;	     h		   Xs[h
PMR_FBCT	EQU	PMR_HBSP+2	;afh{`hJE^[
PMR_FBSP	EQU	PMR_FBCT+2	;	     h		   Xs[h
PMR_MANT	EQU	PMR_FBSP+2	;}gp^[JE^[
PMR_CTYP	EQU	PMR_MANT+2	;LN^[^Cv
PMR_CADR	EQU	PMR_CTYP+2	;      h    AhX
PMR_CXZM	EQU	PMR_CADR+2	;      h    w{
PMR_CYZM	EQU	PMR_CXZM+2	;      h    x{
PMR_CNTX	EQU	PMR_CYZM+2	;      h    Sw
PMR_CNTY	EQU	PMR_CNTX+2	;      h    Sx
PMR_ANSP	EQU	PMR_CNTY+2	;zoOpLN^[]Xs[h
PMR_ANBF	EQU	PMR_ANSP+2	;		  h		     obt@
;
;.............< XL[q`l >...................................
PSK_ANGL	EQU	PLTYPE_RAM	;LN^[]px
PSK_FAIL	EQU	PSK_ANGL+2	;]уtO
PSK_WRK0	EQU	PSK_FAIL+2	;[Nq`lDP
PSK_WRK1	EQU	PSK_WRK0+2	;      h      Q
PSK_WALK	EQU	PSK_WRK1+2	;ʃZbg`FbNJE^[
;
;
PLTYPE_RAM_E	EQU	RAMCK4+2
;
;-------------< naiRg[q`l >-------------------------------
PLSTFG		EQU	PLTYPE_RAM_E	;player stop flag
ENSTFG		EQU	PLSTFG+2	;enemy	    "
;
BABYNO		EQU	ENSTFG+2	;ԂĂ邩tO
ONLFFG		EQU	BABYNO+2	;player lift "ON" flag
PONLFFG		EQU	ONLFFG+2	;	  "
OLD_ONLFFG	EQU	PONLFFG+2	;	  "           ( old )
ONLFXS		EQU	OLD_ONLFFG+2	;	"         X speed
;
WATER_Y		EQU	ONLFXS+2	;afRʈʒu
;
ONCHNG		EQU	WATER_Y+2	;ւݏZbgtO
ONFALL		EQU	ONCHNG+2	;痎鏰ZbgtO
PUSHFG		EQU	ONFALL+2	;vC[tO
MISILE		EQU	PUSHFG+2	;͂̋˒tO
;
TILTCT		EQU	MISILE+2	;tilt counter
TILTCT2		EQU	TILTCT+2	;tilt counter 2
;
;-------------< ItZbg[htO >---------------------------------
BG2OF_FG	EQU	TILTCT2+2
;
;-------------< Ԃ񎀐_čstO >-------------------------
DEATHCT0	EQU	BG2OF_FG+2	;death ghost counter 0
;
;-------------< Nbp{XtO >---------------------------------------
KOOPA_FG	EQU	DEATHCT0+2
;
;-------------< ^C}[ >-----------------------------------------------
MTIMST		EQU	KOOPA_FG+2
;
PLSLIP		EQU	MTIMST		;player slip flag
PLWKTM		EQU	PLSLIP+2	;   "   walk timer
PLJPTM		EQU	PLWKTM+2	;   "   jump   "
PLFLSH		EQU	PLJPTM+2	;   "   safty timer
PSTPTM		EQU	PLFLSH+2	;   "   stop move timer
PSBOYO		EQU	PSTPTM+2	;   "   side "Boyo-n" timer
PHBOYO		EQU	PSBOYO+2	;   "   hed         "
PDSNTM		EQU	PHBOYO+2	;   "   ߃_bVtimer
PSHOTM		EQU	PDSNTM+2	;   "   shot timer
PNAGTM		EQU	PSHOTM+2	;   "   ^}Sp^C}[
PLTIM0		EQU	PNAGTM+2	;   "   ΂񂭂J[`FW^C}[
PSPJTM		EQU	PLTIM0+2	;   "   W^o^WvmdwsEFCg^C}[
PTIMNG		EQU	PSPJTM+2	;   "   ^C~O`FbN^C}[
PICHTM		EQU	PTIMNG+2	;   "   ꏰhs`s`hZbg^C}[
PLKEYFG		EQU	PICHTM+2	;vC[L[f[^]tO
EAT_WAIT	EQU	PLKEYFG+2	;ݍ݃EFCg^C}[
PBURAN		EQU	EAT_WAIT+2	;   "   hu`htO
;
SOUND_ON	EQU	PBURAN+2	;TEhZbgtO
;
PCHNG_TM	EQU	SOUND_ON+2	;   "   ϐg^C}[
;
;-------------< vC[^Cvʋʃ^C}[ >-----------------
;
;.............< ʂ̃bV[q`l >...........................
PLWORKTM	EQU	PCHNG_TM+2
;
;.............< wRv^[q`l >.............................
PHR_MCTM	EQU	PLWORKTM
;
;.............< }Iq`l >...................................
PMR_MNTM	EQU	PLWORKTM
;
;.............< XL[q`l >...................................
PSK_TIM0	EQU	PLWORKTM
;
;
MTIMEN		EQU	PLWORKTM+2
MTIMNO		EQU	MTIMEN-MTIMST
;
MCLRRM0_E	EQU	MTIMEN
MCLR0SE		EQU	MCLRRM0_E-MCLRRM0_S
;
;
;-------------- static RAM ( ~[WJ ) -----------------------------
;----------- AADA USED RAM ----------------------
OPMSGADR	EQU	PLAYER_RAM
OPMSGADRB	EQU	OPMSGADR+2
OPMSGYPOS	EQU	OPMSGADRB+2
OPMSGXPOS	EQU	OPMSGYPOS+2
OPMSGBIG	EQU	OPMSGXPOS+2
;;;;;		EQU	OPMSGBIG+2
;
;
;========================================================================
;=		!=0 page RAM						=
;========================================================================
;
;-------------< spacial OAM >--------------------------------------------
SOAM_DX		EQU	6000H
OAM_DX		EQU	6200H
;
;-------------< OAM >----------------------------------------------------
OAM		EQU	OAM_DX+800H
OAMSUB		EQU	OAM+200H
OAMSB		EQU	OAMSUB+20H
;
;-------------< map extern RAM >-----------------------------------------
MPANGLE		EQU	OAMSB+80H		;map angle
;
MPLMODE		EQU	MPANGLE+2		;map player mode
MPPLXPOS	EQU	MPLMODE+2		;     "     long X pos
MPPLZPOS	EQU	MPPLXPOS+2		;	"        Z  "
MPPLYPOS	EQU	MPPLZPOS+2		;	"        Y  "
;
;
;........................................................................
;.		static RAM ( game )					.
;........................................................................
MSTATIC1	EQU	MPPLYPOS+2
;
;-------------< course BG data write RAM >-------------------------------
UNBUFAD		EQU	MSTATIC1		;world screen status buffer
;
BGHSCRBF	EQU	UNBUFAD+((16*8)*2)	;H_scroll write buffer
BGVSCRBF	EQU	BGHSCRBF+20H*2*2	;V	    "
;
;-------------< TEhZbgW >-------------------------------------
SOUND_X		EQU	BGVSCRBF+22H*2*2	;TEhZbgwW
SOUND_Y		EQU	SOUND_X+2		;	h     x h
;
;-------------< naiLoN >---------------------------------
OBJCHR_BNK	EQU	SOUND_Y+2
;
;-------------< Gƌʋʂq`l >-------------------------------------
ENXP2L		EQU	OBJCHR_BNK+6
ENXP2H		EQU	ENXP2L+1
ENYP2L		EQU	ENXP2H+1
ENYP2H		EQU	ENYP2L+1
;
EXMODE		EQU	ENYP2H+1	 ;[ex]
EXSLOP		EQU	EXMODE+2
EX_ADD_XSP	EQU	EXSLOP+1
ENMODE		EQU	EXMODE+CEXNO*4
ENSLOP		EQU	ENMODE+2
EN_ADD_XSP	EQU	ENSLOP+1
EXMOD0		EQU	ENMODE+CENNO*4	 ;[ex]
EXMOD1		EQU	EXMOD0+2
ENMOD0		EQU	EXMOD0+CEXNO*4
ENMOD1		EQU	ENMOD0+2
EXMOD2		EQU	ENMOD0+CENNO*4	 ;[ex]
EXCLOR		EQU	EXMOD2+2
ENMOD2		EQU	EXMOD2+CEXNO*4
ENCLOR		EQU	ENMOD2+2
EXEMU0		EQU	ENMOD2+CENNO*4	 ;[ex]
EXXSDR		EQU	EXEMU0+1
EXXPSL		EQU	EXXSDR+1
EXXPSH		EQU	EXXPSL+1
ENEMU0		EQU	EXEMU0+CEXNO*4	 ;[ex]
ENXSDR		EQU	ENEMU0+1
ENXPSL		EQU	ENXSDR+1
ENXPSH		EQU	ENXPSL+1
EXCHRB		EQU	ENEMU0+CENNO*4	;[ex]
EXYSDR		EQU	EXCHRB+1
EXYPSL		EQU	EXYSDR+1
EXYPSH		EQU	EXYPSL+1
ENCHRB		EQU	EXCHRB+CEXNO*4
ENYSDR		EQU	ENCHRB+1
ENYPSL		EQU	ENYSDR+1
ENYPSH		EQU	ENYPSL+1
EXXSPD		EQU	ENCHRB+CENNO*4	 ;[ex]
EXXSPH		EQU	EXXSPD+1
EXYSPD		EQU	EXXSPH+1
EXYSPH		EQU	EXYSPD+1
ENXSPD		EQU	EXXSPD+CEXNO*4
ENXSPH		EQU	ENXSPD+1
ENYSPD		EQU	ENXSPH+1
ENYSPH		EQU	ENYSPD+1
EXMOVX		EQU	ENXSPD+CENNO*4	 ;[ex]
EXMOVY		EQU	EXMOVX+2
ENMOVX		EQU	EXMOVX+CEXNO*4
ENMOVY		EQU	ENMOVX+2
EXSTNO		EQU	ENMOVX+CENNO*4	 ;[ex]
EXOAML		EQU	EXSTNO+2
ENMYNO		EQU	EXSTNO+CEXNO*4
ENOAML		EQU	ENMYNO+2
EXMUKI		EQU	ENMYNO+CENNO*4	 ;[ex]
EXCHPT		EQU	EXMUKI+2
ENMUKI		EQU	EXMUKI+CEXNO*4
ENCHPT		EQU	ENMUKI+2
EXRETN		EQU	ENMUKI+CENNO*4	 ;[ex]
EXDORE		EQU	EXRETN+1
EXYUSN		EQU	EXDORE+1
ENRETN		EQU	EXRETN+CEXNO*4
ENDORE		EQU	ENRETN+1
ENYUSN		EQU	ENDORE+1
EXXPOW		EQU	ENRETN+CENNO*4	 ;[ex]
EXGPOW		EQU	EXXPOW+2
ENXPOW		EQU	EXXPOW+CEXNO*4	 ;[ex]
ENGPOW		EQU	ENXPOW+2
EXXMAX		EQU	ENXPOW+CENNO*4	 ;[ex]
EXGMAX		EQU	EXXMAX+2
ENXMAX		EQU	EXXMAX+CEXNO*4	 ;[ex]
ENGMAX		EQU	ENXMAX+2
EXDSXL		EQU	ENXMAX+CENNO*4	 ;[ex]
EXDSXH		EQU	EXDSXL+1
EXDSYL		EQU	EXDSXH+1
EXDSYH		EQU	EXDSYL+1
ENDSXL		EQU	EXDSXL+CEXNO*4
ENDSXH		EQU	ENDSXL+1
ENDSYL		EQU	ENDSXH+1
ENDSYH		EQU	ENDSYL+1
EXBGYP		EQU	ENDSXL+CENNO*4	 ;[ex]
EXTROB		EQU	EXBGYP+2
ENBGYP		EQU	EXBGYP+CEXNO*4
ENTROB		EQU	ENBGYP+2
EXWRKX		EQU	ENBGYP+CENNO*4	 ;[ex]
EXSPTM		EQU	EXWRKX+1
EXTIM0		EQU	EXSPTM+1
ENWRKX		EQU	EXWRKX+CEXNO*4
ENSPTM		EQU	ENWRKX+1
EPXMUK		EQU	ENSPTM+1
EPYMUK		EQU	EPXMUK+1
EXCBFG		EQU	ENWRKX+CENNO*4	 ;[ex] BG cross flag
EXWATR		EQU	EXCBFG+2	 ;     water in flag
EXWTSP		EQU	EXWATR+1	 ;     water in speed
ENCBFG		EQU	EXCBFG+CEXNO*4
ENWATR		EQU	ENCBFG+2
ENWTSP		EQU	ENWATR+1
EXWRKA		EQU	ENCBFG+CENNO*4	 ;enemy work RAM.A
EXWRKB		EQU	EXWRKA+1	 ;	 "      .B
EXWRKC		EQU	EXWRKB+1	 ;	 "      .C
EXWRKD		EQU	EXWRKC+1	 ;	 "      .D
ENWRKA		EQU	EXWRKA+CEXNO*4	 ;	 "      .A
ENWRKB		EQU	ENWRKA+1	 ;	 "      .B
ENWRKC		EQU	ENWRKB+1	 ;	 "      .C
ENWRKD		EQU	ENWRKC+1	 ;	 "      .D
;
;-------------< Ĝq`l >---------------------------------------------
;
;-------------< ĜOy[Wq`l >-----------------------------
EN0RAM		EQU	ENWRKA+CENNO*4
;
EWORK		EQU	EN0RAM		;work RAM
EWORK0		EQU	EN0RAM
EWORK1		EQU	EWORK+1
EWORK2		EQU	EWORK1+1
EWORK3		EQU	EWORK2+1
EWORK4		EQU	EWORK3+1
EWORK5		EQU	EWORK4+1
EWORK6		EQU	EWORK5+1
EWORK7		EQU	EWORK6+1
EWORK8		EQU	EWORK7+1
EWORK9		EQU	EWORK8+1
EWORKA		EQU	EWORK9+1
EWORKB		EQU	EWORKA+1
EWORKC		EQU	EWORKB+1
EWORKD		EQU	EWORKC+1
EWORKE		EQU	EWORKD+1
EWORKF		EQU	EWORKE+1
;
RANDM0		EQU	EWORKF+1	;random buffer
ENINDX		EQU	RANDM0+2	;enemy index
FRCNT2		EQU	ENINDX+2	;freme counter
;
ENCONT		EQU	FRCNT2+2	;enemy work counter
ENWRK0		EQU	ENCONT+2	;     "     RAM.0
ENWRK1		EQU	ENWRK0+1	;	"      .1
ENWRK2		EQU	ENCONT+CENNO*4	;	"      .2
ENWRK3		EQU	ENWRK2+1	;	"      .3
ENWRK4		EQU	ENWRK3+1	;	"      .4
ENWRK5		EQU	ENWRK4+1	;	"      .5
;
;-------------< ĜOy[WȊÔq`l >-------------------------------
ENWRK6		EQU	ENWRK2+CENNO*4	;enemy work RAM.6
ENWRK7		EQU	ENWRK6+1	;	"      .7
ENWRK8		EQU	ENWRK7+1	;	"      .8
ENWRK9		EQU	ENWRK8+1	;	"      .9
ENTIM0		EQU	ENWRK6+CENNO*4	;  "   timer.0
ENTIM1		EQU	ENTIM0+2	;     "     .1
ENTIM2		EQU	ENTIM0+CENNO*4	;     "     .2
ENTIM3		EQU	ENTIM2+2	;     "     .3
;
ECNTXW		EQU	ENTIM2+CENNO*4
ECNTYW		EQU	ECNTXW+2
EWIDEX		EQU	ECNTXW+CENNO*4
EWIDEY		EQU	EWIDEX+2
EPWIDX		EQU	EWIDEX+CENNO*4
EPWIDY		EQU	EPWIDX+2
ECROSX		EQU	EPWIDX+CENNO*4
ECROSY		EQU	ECROSX+2
ECENTX		EQU	ECROSX+CENNO*4
ECENTY		EQU	ECENTX+2
ECRSFG		EQU	ECENTX+CENNO*4
ENCRPT		EQU	ECRSFG+1
ENSHOT		EQU	ENCRPT+1
ENCOLD		EQU	ECRSFG+CENNO*4
;;;;		EQU	ENCOLD+2	;󂫁II
;
;-------------< ^}SIvVpq`l >-------------------------------
EGGPNT		EQU	ENCOLD+CENNO*4
EGGLNK		EQU	EGGPNT+2
;
;-------------< GtO >---------------------------------------------
SUPER_FLAG	EQU	EGGLNK+(6*2)
;
;-------------< ዾnm^neeXCb` >-----------------------------
GRASS_ON	EQU	SUPER_FLAG+2
;
;
;------------------------------------------------------------------------
;-		clear RAM.1						-
;------------------------------------------------------------------------
MCLRRM1_S	EQU	GRASS_ON+2
;
;
;-------------< _ubNRCnm^neeXCb` >---------------
SWITCH_1	EQU	MCLRRM1_S
;
;-------------< XN[pq`l >-------------------------------------
SCRONF		EQU	SWITCH_1+2
;
ESCCH1L		EQU	SCRONF+2
ESCCV1L		EQU	ESCCH1L+2
;
PLXSDR_OLD	EQU	ESCCV1L+2
PLXPSL_OLD	EQU	PLXSDR_OLD+2
PLXPSH_OLD	EQU	PLXPSL_OLD+1
PLYSDR_OLD	EQU	PLXPSH_OLD+1
PLYPSL_OLD	EQU	PLYSDR_OLD+2
PLYPSH_OLD	EQU	PLYPSL_OLD+1
;
PLSCRL_MINX	EQU	PLYPSH_OLD+1
PLSCRL_MAXX	EQU	PLSCRL_MINX+2
PLSCRL_MINY	EQU	PLSCRL_MAXX+2
PLSCRL_MAXY	EQU	PLSCRL_MINY+2
PLSCRL_CX	EQU	PLSCRL_MAXY+2
PLSCRL_CY	EQU	PLSCRL_CX+2
PLSCRL_TM	EQU	PLSCRL_CY+2
;
SCRL_XSDR	EQU	PLSCRL_TM+2
SCRL_XSPD	EQU	SCRL_XSDR+2
;
SP_SCRL_FG	EQU	SCRL_XSPD+2	;XN[tO
SP_SCRL_USER	EQU	SP_SCRL_FG+2	;	  h	   gp[U[tO
SP_SCRL_XPS	EQU	SP_SCRL_USER+2	;	  h	   wW
SP_SCRL_YPS	EQU	SP_SCRL_XPS+2	;	  h	   x h
SP_SCRL_XSDR	EQU	SP_SCRL_YPS+2	;	  h	   w h ikj
SP_SCRL_YSDR	EQU	SP_SCRL_XSDR+2	;	  h	   x	h
SP_SCRL_XSP	EQU	SP_SCRL_YSDR+2	;	  h	   wXs[h
SP_SCRL_YSP	EQU	SP_SCRL_XSP+2	;	  h	   x	h
;
;-------------< vC[q`l >---------------------------------------
PL_ADD_XSP	EQU	SP_SCRL_YSP+2	;vC[w
PL_ANGL_YSP	EQU	PL_ADD_XSP+2	;    h	   ړpxxXs[h
;
;-------------< BG3 polygon RAM >----------------------------------------
POLYONFG	EQU	PL_ANGL_YSP+2	;BG3 polygon on flag ( Y loop )
POLYANG		EQU	POLYONFG+2	;     "      rotation angle
POLYXPS		EQU	POLYANG+2	;     "      center X pos
;
POLYPLXD	EQU	POLYXPS+2	;     "      player "Gusha" !! X pos
;;;;		EQU	POLYPLXD+1	;		    "
POLYPLXL	EQU	POLYPLXD+2	;		    "
POLYPLXH	EQU	POLYPLXL+1	;		    "
;
;-------------< vC[ɏĂGCfbNX >---------------------
NOSEIDX		EQU	POLYPLXH+1	;[ OFĂȂ ]
;
;-------------< ʂ̂q`l >-------------------------------------------
EXSTCT		EQU	NOSEIDX+2	; kouka set pointer
;
EXWRK0		EQU	EXSTCT+2	;kouka work RAM.0
EXWRK1		EQU	EXWRK0+1	;	"      .1
EXWRK2		EQU	EXWRK1+1	;	"      .2
EXWRK3		EQU	EXWRK2+1	;	"      .3
EXWRK4		EQU	EXWRK0+CEXNO*4	;	"      .4
EXWRK5		EQU	EXWRK4+1	;	"      .5
EXTIM1		EQU	EXWRK5+1	;  "   timer.1
;
;-------------< ]GA >-----------------------------------------
TROBJ_ARIA	EQU	EXWRK4+CEXNO*4
TROBJ_SIZE	EQU	TROBJ_ARIA+2
;
;-------------< BG mode 2 ( offset ) RAM >-------------------------------
BG2OFH		EQU	TROBJ_SIZE+(16*2)
BG2OFV		EQU	BG2OFH+2
BG2OFF		EQU	BG2OFV+2
BG2OFST_CP	EQU	BG2OFF+(40H*2)
BG2OFTBL	EQU	BG2OFST_CP+80
BG2SCR_CNT	EQU	BG2OFTBL+33+1
BG2V_CNT	EQU	BG2SCR_CNT+2
;
;-------------< htth[htO >-------------------------------
FURA_FG		EQU	BG2V_CNT+2
;
;-------------< glhm^ntsptO >---------------------------
CCHGTN		EQU	FURA_FG+2
CCHGTK		EQU	CCHGTN+2
;
;-------------< ~jQ[tO >---------------------------------------
MINI_GAME_FG	EQU	CCHGTK+2
;
;
MCLRRM1_E	EQU	MINI_GAME_FG+2
MCLR1SE		EQU	MCLRRM1_E-MCLRRM1_S
;
;-------------< TATUMAKI >-----------------------------------------------
TAT_XPOS	EQU	MCLRRM1_E
TAT_YPOS	EQU	TAT_XPOS + 2
TAT_MODE	EQU	TAT_YPOS + 2
;;;;;;;;	EQU	CTAT_MODE + 2
;
;------------------------------------------------------------------------
;-		clear RAM.1 end						-
;------------------------------------------------------------------------
;
;
;........................................................................
;.		static RAM ( map )					.
;........................................................................
;
;-------------< H-DMA buffer >-------------------------------------------
MPHDMAB0	EQU	MSTATIC1	;H-DMA buffer.0 ( X  cos )
MPHDMAB1	EQU	MPHDMAB0+70H*2	;	"    .1 ( X  sin )
MPHDMAB2	EQU	MPHDMAB1+70H*2	;	"    .2 ( Y -sin )
MPHDMAB3	EQU	MPHDMAB2+70H*2	;	"    .3 ( Y  cos )
;
;
;-------------< map OBJ RAM >--------------------------------------------
;
;-------------- map clear RAM -----------------------------------
MMPCLRRM_S	EQU	MPHDMAB3+70H*2
;
MPOBJSTN	EQU	MMPCLRRM_S		;map OBJ set no
;
MPOBJTYP	EQU	MPOBJSTN+2		;    "   type no.
MPOBJXPS	EQU	MPOBJTYP+1		;    "   X pos
MPOBJZPS	EQU	MPOBJXPS+1		;    "   Z  "
MPOBJYPS	EQU	MPOBJZPS+1		;    "   Y  "
;
MPWOBJXPS	EQU	MPOBJTYP+MPOBJN*4	;map work OBJ X pos
MPWOBJYPS	EQU	MPWOBJXPS+1		;      "      Y  "
MPWOBJSIZ	EQU	MPWOBJYPS+1		;      "      zoom size
;
MPWOBJZPS	EQU	MPWOBJXPS+MPOBJN*4	;      "      Z pos
MPSORTIDX	EQU	MPWOBJZPS+1		;	  "         sort index buffer
;
MMPCLRRM_E	EQU	MPWOBJZPS+MPOBJN*2
MMPCLRSE	EQU	MMPCLRRM_E-MMPCLRRM_S
;
MPWORK		EQU	MMPCLRRM_E
;;;;		EQU	MPWORK+(MPOBJN/2)*4
;
;-------------- map player RAM define -------------------
MPPLTYP		EQU	MPOBJTYP		;player type no.
MPPLXPS		EQU	MPOBJXPS		;   "   X pos
MPPLZPS		EQU	MPOBJZPS		;   "   Z  "
MPPLYPS		EQU	MPOBJYPS		;   "   Y  "
MPPLSIZ		EQU	MPWOBJSIZ		;   "   zoom size
;
;-------------- move OBJ RAM define ---------------------
MPMVTYP		EQU	MPOBJTYP+4		;move OBJ type no.
MPMVXPS		EQU	MPOBJXPS+4		;    "    X pos
MPMVZPS		EQU	MPOBJZPS+4		;    "    Z  "
MPMVYPS		EQU	MPOBJYPS+4		;    "    Y  "
MPWMVYPS	EQU	MPWOBJYPS+4		;    "    work Y pos
MPMVSIZ		EQU	MPWOBJSIZ+4		;    "    zoom size
;
;
;
;************************************************************************
;*									*
;*		only mario chip RAM					*
;*									*
;************************************************************************
;
;........................................................................
;.		extern RAM						.
;........................................................................
;
;-------------< color data buffer >--------------------------------------
DATACOL		EQU	702000H		;now color data
;
;-------------< div data RAM >-------------------------------------------
DIVBUF		EQU	DATACOL+200H
;
;
;........................................................................
;.		static RAM ( game )					.
;........................................................................
;
;------------------------------------------------------------------------
;-		clear RAM.2						-
;------------------------------------------------------------------------
EDTADR		EQU	DIVBUF+200H*2	;enemy data address
;
;
MCLRRM2_S	EQU	EDTADR+4
;
;
MSTATIC2	EQU	MCLRRM2_S
;
;-------------< BG3 screen scroll write buffer >-------------------------
BG3HSCRBF	EQU	MSTATIC2		;BG3 H_scroll write buffer
BG3VSCRBF	EQU	BG3HSCRBF+20H*2		; "  V          "
;
;-------------< OAM KAITEN DATA RAM >------------------------------------
OBJKAKU		EQU	BG3VSCRBF+20H*2		;KAITEN KAKU
OBJXPOS		EQU	OBJKAKU+2		;SENTER X
OBJYPOS		EQU	OBJXPOS+2		;SENTER Y
OBJXZUM		EQU	OBJYPOS+2		;ZOOM X
OBJYZUM		EQU	OBJXZUM+2		;ZOOM Y
;
;-------------< Gƌʋʂq`l >-------------------------------------
EXSKCR		EQU	OBJYZUM+2
;;;;		EQU	EXSKCR+2
ENSKCR		EQU	EXSKCR+CEXNO*4
;;;;		EQU	ENSKCR+2
;
;-------------< Ĝq`l >---------------------------------------------
XBGOXP		EQU	ENSKCR+CENNO*4
XBGOYP		EQU	XBGOXP+2
EBGOXP		EQU	XBGOXP+CEXNO*4
EBGOYP		EQU	EBGOXP+2
;
;-------------< GZbgf[^obt@ >---------------------------------
EDSRBF		EQU	EBGOXP+CENNO*4	;enemy data search result buffer
EDSWBF		EQU	EDSRBF+(6*42)	;     "     "ON/OFF" flag
;
;-------------< Gƌʂ̂af`FbNf[^Zbgobt@ >---------
ENBGCK_DATA_P	EQU	EDSWBF+100H	;BG check point data buffer pointer
ENBGCK_DATA	EQU	ENBGCK_DATA_P+2 ;	      "
; {
ENBGCK_X_C	EQU	ENBGCK_DATA&0FF0000H  ;BG check center point X pos
ENBGCK_Y_C	EQU	ENBGCK_X_C+2	;	   "           Y  "
ENBGCK_TYPE_C	EQU	ENBGCK_Y_C+2	;	   "           unit no. type
ENBGCK_UNIT_C	EQU	ENBGCK_TYPE_C+2 ;	   "           unit no.
ENBGCK_X_L	EQU	ENBGCK_UNIT_C+2 ;BG check left point   X pos
ENBGCK_Y_L	EQU	ENBGCK_X_L+2	;	   "           Y  "
ENBGCK_TYPE_L	EQU	ENBGCK_Y_L+2	;	   "           unit no. type
ENBGCK_UNIT_L	EQU	ENBGCK_TYPE_L+2 ;	   "           unit no.
ENBGCK_X_R	EQU	ENBGCK_UNIT_L+2 ;BG check left point   X pos
ENBGCK_Y_R	EQU	ENBGCK_X_R+2	;	   "           Y  "
ENBGCK_TYPE_R	EQU	ENBGCK_Y_R+2	;	   "           unit no. type
ENBGCK_UNIT_R	EQU	ENBGCK_TYPE_R+2 ;	   "           unit no.
ENBGCK_X_H	EQU	ENBGCK_UNIT_R+2 ;BG check left point   X pos
ENBGCK_Y_H	EQU	ENBGCK_X_H+2	;	   "           Y  "
ENBGCK_TYPE_H	EQU	ENBGCK_Y_H+2	;	   "           unit no. type
ENBGCK_UNIT_H	EQU	ENBGCK_TYPE_H+2 ;	   "           unit no.
ENBGCK_X_F	EQU	ENBGCK_UNIT_H+2 ;BG check left point   X pos
ENBGCK_Y_F	EQU	ENBGCK_X_F+2	;	   "           Y  "
ENBGCK_TYPE_F	EQU	ENBGCK_Y_F+2	;	   "           unit no. type
ENBGCK_UNIT_F	EQU	ENBGCK_TYPE_F+2 ;	   "           unit no.
; }
;
;-------------< software sprite RAM >------------------------------------
OSCCH		EQU	ENBGCK_DATA+100H
OSCCV		EQU	OSCCH+2
OCENTX		EQU	OSCCV+2
OCENTY		EQU	OCENTX+2
OMATA		EQU	OCENTY+2
OMATB		EQU	OMATA+2
OMATC		EQU	OMATB+2
OMATD		EQU	OMATC+2
OCHRADR		EQU	OMATD+2
OBUFXPS		EQU	OCHRADR+4
OBUFYPS		EQU	OBUFXPS+2
OBM7CNT		EQU	OBUFYPS+2
OBM7R01		EQU	OBM7CNT+2
OBM7R02		EQU	OBM7R01+2
OBM7R03		EQU	OBM7R02+2
OBM7R05		EQU	OBM7R03+2
OBM7R07		EQU	OBM7R05+2
OBM7R08		EQU	OBM7R07+2
OBM7R09		EQU	OBM7R08+2
OBM7R10		EQU	OBM7R09+2
;
;
;-------------< moji polygon RAM >---------------------------------------
MJP2DPS		EQU	OBM7R10+2	;2D pos buffer
MJPBTBL		EQU	MJP2DPS+(100*2) ;polygon block table buffer
MJPFACE		EQU	MJPBTBL+(20*4)	;    "   face data buffer
MJPFACF		EQU	MJPFACE+300	;      "      status data buffer
;
;
;-------------< color data buffer >--------------------------------------
MOTOCOL		EQU	MJPFACF+50	;from color data
CHNGCOL		EQU	MOTOCOL+200H	;to	   "
WORKCOL		EQU	CHNGCOL+200H	;work	   "
;
;-------------< color fade RAM >-----------------------------------------
CLFDCNT		EQU	WORKCOL+200H	;color fade counter
MOTOADR		EQU	CLFDCNT+2	;from color data address
CHNGADR		EQU	MOTOADR+2	;to		"
;
;-------------< H-DMA buffer >-------------------------------------------
HDMABF		EQU	CHNGADR+2	;H-DMA buffer.1
HDMABF1		EQU	HDMABF+0D2H*2	;      "     .2
HDMABF2		EQU	HDMABF1+0D2H*2	;      "     .3
HDMABF0		EQU	HDMABF2+0D2H*2	;      "     .4
;
;-------------< window buffer >------------------------------------------
WINDBF		EQU	HDMABF0+0D2H*2
;
;.............< }bv@ECh[@q`l >.............................
MPWIND0		EQU	HDMABF		; map window H-DMA buffer
;;;;;;;		EQU	MPWIND0+76H*4
;
;-------------< BG3 spacial screen dada buffer >-------------------------
BG3SCBF		EQU	WINDBF+(0D2H*4)
;
;-------------< BG3 polygon color buffer >-------------------------------
POLYCOL		EQU	BG3SCBF+(080H*6)
;;;;		EQU	POLYCOL+(4*9)
;
;-------------< trans. obake >------------------------------
HDMABF_WK	EQU	POLYCOL+(4*9)	;H-DMA buffer.0 work
HDMABF1_WK	EQU	HDMABF_WK+1C0H	;	"    .1 work
OBAKE_DAT	EQU	HDMABF1_WK+1C0H ;obake data work area
OPOI2DXL	EQU	OBAKE_DAT+0C0H	;  L line data	2DX
OPOI2DYL	EQU	OPOI2DXL+2	;	"       2DY
OPOIRL		EQU	OPOI2DYL+2	;	"       R
OPOIXPSL	EQU	OPOIRL+2	;	"       X POS.
OPOIXADL	EQU	OPOIXPSL+2	;	"       X ADD DATA
OPOICNDL	EQU	OPOIXADL+2	;	"       LINE COND.
OPOI2DXR	EQU	OPOICNDL+2	;  R line data	2DX
OPOI2DYR	EQU	OPOI2DXR+2	;	"       2DY
OPOIRR		EQU	OPOI2DYR+2	;	"       R
OPOIXPSR	EQU	OPOIRR+2	;	"       X POS.
OPOIXADR	EQU	OPOIXPSR+2	;	"       X ADD DATA
OPOICNDR	EQU	OPOIXADR+2	;	"       LINE COND.
;
;
;
;.............< rotate bg3 >...........................................
BG3POI_WK	EQU	POLYCOL+(4*9)
;
BPOI2DXL	EQU	BG3POI_WK+100H	;  L line data	2DX
BPOI2DYL	EQU	BPOI2DXL+2	;	"       2DY
BPOIRL		EQU	BPOI2DYL+2	;	"       R
BPOIXPSL	EQU	BPOIRL+2	;	"       X POS.
BPOIXADL	EQU	BPOIXPSL+2	;	"       X ADD DATA
BPOICNDL	EQU	BPOIXADL+2	;	"       LINE COND.
BPOI2DXR	EQU	BPOICNDL+2	;  R line data	2DX
BPOI2DYR	EQU	BPOI2DXR+2	;	"       2DY
BPOIRR		EQU	BPOI2DYR+2	;	"       R
BPOIXPSR	EQU	BPOIRR+2	;	"       X POS.
BPOIXADR	EQU	BPOIXPSR+2	;	"       X ADD DATA
BPOICNDR	EQU	BPOIXADR+2	;	"       LINE COND.
;
BPOIYPS1	EQU	BPOICNDR+2	;select point save work
BPOIXPS1	EQU	BPOIYPS1+2	;	    "
BPOIYPS2	EQU	BPOIXPS1+2	;	    "
BPOIXPS2	EQU	BPOIYPS2+2	;	    "
BPOIYPS3	EQU	BPOIXPS2+2	;	    "
BPOIXPS3	EQU	BPOIYPS3+2	;	    "
BPOIYPS4	EQU	BPOIXPS3+2	;	    "
BPOIXPS4	EQU	BPOIYPS4+2	;	    "
BPOIYPS5	EQU	BPOIXPS4+2	;	    "
BPOIXPS5	EQU	BPOIYPS5+2	;	    "
BPOIYPS6	EQU	BPOIXPS5+2	;	    "
BPOIXPS6	EQU	BPOIYPS6+2	;	    "
BPOIYPS7	EQU	BPOIXPS6+2	;	    "
BPOIXPS7	EQU	BPOIYPS7+2	;	    "
BPOIYPS8	EQU	BPOIXPS7+2	;	    "
BPOIXPS8	EQU	BPOIYPS8+2	;	    "
BPOIYPS9	EQU	BPOIXPS8+2	;	    "
BPOIXPS9	EQU	BPOIYPS9+2	;	    "
BPOIYPSA	EQU	BPOIXPS9+2	;	    "
BPOIXPSA	EQU	BPOIYPSA+2	;	    "
BPOIYPSB	EQU	BPOIXPSA+2	;	    "
BPOIXPSB	EQU	BPOIYPSB+2	;	    "
BPOIYPSC	EQU	BPOIXPSB+2	;	    "
BPOIXPSC	EQU	BPOIYPSC+2	;	    "
BPOIYPSD	EQU	BPOIXPSC+2	;	    "
BPOIXPSD	EQU	BPOIYPSD+2	;	    "
BPOIYPSE	EQU	BPOIXPSD+2	;	    "
BPOIXPSE	EQU	BPOIYPSE+2	;	    "
BPOIYPSF	EQU	BPOIXPSE+2	;	    "
BPOIXPSF	EQU	BPOIYPSF+2	;	    "
BPOIYPS10	EQU	BPOIXPSF+2	;	    "
BPOIXPS10	EQU	BPOIYPS10+2	;	    "
BPOIYPS11	EQU	BPOIXPS10+2	;select point save work
BPOIXPS11	EQU	BPOIYPS11+2	;	    "
BPOIYPS12	EQU	BPOIXPS11+2	;	    "
BPOIXPS12	EQU	BPOIYPS12+2	;	    "
BPOIYPS13	EQU	BPOIXPS12+2	;	    "
BPOIXPS13	EQU	BPOIYPS13+2	;	    "
BPOIYPS14	EQU	BPOIXPS13+2	;	    "
BPOIXPS14	EQU	BPOIYPS14+2	;	    "
BPOIYPS15	EQU	BPOIXPS14+2	;	    "
BPOIXPS15	EQU	BPOIYPS15+2	;	    "
BPOIYPS16	EQU	BPOIXPS15+2	;	    "
BPOIXPS16	EQU	BPOIYPS16+2	;	    "
BPOIYPS17	EQU	BPOIXPS16+2	;	    "
BPOIXPS17	EQU	BPOIYPS17+2	;	    "
BPOIYPS18	EQU	BPOIXPS17+2	;	    "
BPOIXPS18	EQU	BPOIYPS18+2	;	    "
BPOIYPS19	EQU	BPOIXPS18+2	;	    "
BPOIXPS19	EQU	BPOIYPS19+2	;	    "
BPOIYPS1A	EQU	BPOIXPS19+2	;	    "
BPOIXPS1A	EQU	BPOIYPS1A+2	;	    "
BPOIYPS1B	EQU	BPOIXPS1A+2	;	    "
BPOIXPS1B	EQU	BPOIYPS1B+2	;	    "
BPOIYPS1C	EQU	BPOIXPS1B+2	;	    "
BPOIXPS1C	EQU	BPOIYPS1C+2	;	    "
BPOIYPS1D	EQU	BPOIXPS1C+2	;	    "
BPOIXPS1D	EQU	BPOIYPS1D+2	;	    "
BPOIYPS1E	EQU	BPOIXPS1D+2	;	    "
BPOIXPS1E	EQU	BPOIYPS1E+2	;	    "
BPOIYPS1F	EQU	BPOIXPS1E+2	;	    "
BPOIXPS1F	EQU	BPOIYPS1F+2	;	    "
BPOIYPS20	EQU	BPOIXPS1F+2	;	    "
BPOIXPS20	EQU	BPOIYPS20+2	;	    "
;
;
;.............< bit map block >.........................................
DATACMP		EQU	HDMABF_WK	;display check data
;
;.............< TATUMAKI >...............................................
CTAT_POS	EQU	HDMABF_WK	;
CTAT_SPD	EQU	CTAT_POS + 070H * 2
CTAT_UPOS	EQU	CTAT_SPD + 070H * 2
CTAT_USPD	EQU	CTAT_UPOS + 2
CHDMAH		EQU	CTAT_USPD + 2
CHDMAV		EQU	CHDMAH + 1C0H
;;;;;		EQU	CHDMAV + 1C0H
;
;.............< massage >................................................
MSG_RAM		EQU	HDMABF_WK
MSG_NO		EQU	MSG_RAM+2
MSG_ANS		EQU	MSG_RAM+38
MSG_ADR		EQU	MSG_ANS+2
MSG_BNK		EQU	MSG_ADR+2
MSG_PLCT	EQU	MSG_BNK+2
MSG_PLCT_BF	EQU	MSG_PLCT+2
;
;.............< af`FbNpobt@ >.................................
BGCHECK_BUF	EQU	MSG_PLCT_BF+2
;
;............< [hQ ch `FbNp e[u f[^ >..............
BG2FKN_CP	EQU	BGCHECK_BUF+(200H*2)
;				; gpoCg
;				;	(Pf[^ UoCg) ~ (QO)
;
;.BAKABON............< afR|S >...................................
BG3_POLYGON_DT	EQU	BG2FKN_CP
;.BAKABON............< afR|Spobt@ >.........................
BG3_POLY_DMABUF EQU	BG3_POLYGON_DT+(018H*5)*4
;.............< aXvC >...................................
BSPL_B_POINT	EQU	BG3_POLY_DMABUF+(0D2H*2)*2
;
;.............< [tBO >...................................
MORP_S_POINT	EQU	BSPL_B_POINT+(018H)*2
MORP_D_POINT	EQU	MORP_S_POINT+050H*4
;
;-------------< aXvCa|f[^ >-----------------------
BSPL_B_POINT_B	EQU	MORP_D_POINT+050H*4
BSPL_MV_BUFF	EQU	BSPL_B_POINT_B+(010H*2)
BKBON_E		EQU	BSPL_MV_BUFF+(010H*2)
;
;
;.............< JbNJ[e >...............................
KIRAKIRA_V_VSP	EQU	BG2FKN_CP		;cXN[Jnʒu					;NON RESET
KIRAKIRA_V_VS	EQU	KIRAKIRA_V_VSP+2	;cXN[						;    RESET
KIRAKIRA_V_VSL	EQU	KIRAKIRA_V_VS+2		;cXN[ʏ					;    RESET
KIRAKIRA_V_VSS	EQU	KIRAKIRA_V_VSL+2	;cXN[x					;    RESET
KIRAKIRA_V_VSA	EQU	KIRAKIRA_V_VSS+2	;cXN[x					;NON RESET
KIRAKIRA_V_ST	EQU	KIRAKIRA_V_VSA+2	;cXN[L΂C				;    RESET
KIRAKIRA_V_STS	EQU	KIRAKIRA_V_ST+2		;cXN[L΂Cx			;    RESET
KIRAKIRA_V_STA	EQU	KIRAKIRA_V_STS+2	;cXN[L΂Cx			;NON RESET
KIRAKIRA_V_STSS EQU	KIRAKIRA_V_STA+2	;cXN[L΂Cxt[x	;    RESET
KIRAKIRA_V_STSA EQU	KIRAKIRA_V_STSS+2	;cXN[L΂Cxt[x	;NON RESET
KIRAKIRA_CTBL	EQU	KIRAKIRA_V_STSA+2	;J[epFωe[u
KIRAKIRA_CTBL_E EQU	KIRAKIRA_CTBL+020H*2-2	;last data address
KIRAKIRA_C_SP	EQU	KIRAKIRA_CTBL_E+2	;J[J[eX^[gCio[			      XXXX.
KIRAKIRA_C_SPS	EQU	KIRAKIRA_C_SP+2		;J[J[eX^[gCio[				XX.XX
KIRAKIRA_C_SPA	EQU	KIRAKIRA_C_SPS+2	;J[J[eX^[gCt[ʂ̃t[ XX.XX
KIRAKIRA_C_TW	EQU	KIRAKIRA_C_SPA+2	;J[J[eŏ㕔C					XX.XX
KIRAKIRA_C_TWS	EQU	KIRAKIRA_C_TW+2		;J[J[eŏ㕔Ct[			XX.XX
KIRAKIRA_C_TWA	EQU	KIRAKIRA_C_TWS+2	;J[J[eŏ㕔Ct[ʂ̑		XX.XX
KIRAKIRA_C_TWBS EQU	KIRAKIRA_C_TWA+2	;ubNƂ̃Cʂ̕ω					XX.XX
KIRAKIRA_C_TWBA EQU	KIRAKIRA_C_TWBS+2	;ubNƂ̃Cʂ̕ωʂ̕ω				XX.XX
KIRAKIRA_C_TC	EQU	KIRAKIRA_C_TWBA+2		;J[J[eŏ㕔J[e[uio[		XX.XX
KIRAKIRA_C_TCS	EQU	KIRAKIRA_C_TC+2		;J[J[eŏ㕔J[e[ut[ω		XX.XX
KIRAKIRA_C_TCA	EQU	KIRAKIRA_C_TCS+2	;J[J[eŏ㕔J[e[ut[ωʂ̑	XX.XX
KIRAKIRA_C_CC	EQU	KIRAKIRA_C_TCA+2	;ubNƂ̃J[e[uio[̑			XX.XX
KIRAKIRA_C_CCS	EQU	KIRAKIRA_C_CC+2		;ubNƂ̃J[e[uio[̑ʂ̃ubNω XX.XX
;
;-------------< massage bitmap chara buffer >----------------------------
MSGBITMP	EQU	704E00H		;massage bitmap DMA buffer
;;;;		EQU	MSGBITMP+800H+200H
;
;-------------< software sprite chara buffer >---------------------------
WOB7CHR		EQU	705800H
;			   |
;			   V
;			7077FFH
;
;
;
MCLRRM2_E	EQU	707800H
MCLR2SE		EQU	MCLRRM2_E-MCLRRM2_S
;
;
;------------------------------------------------------------------------
;-		clear RAM.2 end						-
;------------------------------------------------------------------------
;
;
;
;
;-------------< map bitmap buffer >--------------------------------------
MPBITMAP	EQU	702800H
;
;-------------< map bitmap buffer convert work buffer >------------------
MPCNVBF		EQU	MPBITMAP+4600H		;[ 28 x 20 ]
;;;;		EQU	MPCNVBF+0E00H		;[ 3800H/4 ]
;
;
;
;-------------< ~[WJ  rbg}bvobt@ >---------------------
DM01_MSGBITMP	EQU	704C00H		;bZ[W
DM01_OBJBITMP	EQU	705800H		;nai
;			   |
;			   V
;			7077FFH
;
;
;------------------------------------------------------------------------
;-		GfBOrbg}bv				-
;------------------------------------------------------------------------
CBITMAP_OBJDT	EQU	CMSTATIC1	;rbg}bvnaif[^obt@
CBTMP_COL_CNT	EQU	CBITMAP_OBJDT+500H
;;;;;		EQU	CBTMP_COL_CNT+2
;
BITMAP_OBJDT	EQU	MSTATIC1	;rbg}bvnaif[^obt@
BITMAP_OBJ_Z	EQU	BITMAP_OBJDT	;	    h		 yW
BITMAP_OBJ_X	EQU	BITMAP_OBJ_Z+2	;	    h		 wW
BITMAP_OBJ_Y	EQU	BITMAP_OBJ_X+1	;	    h		 xW
BITMAP_OBJ_S	EQU	BITMAP_OBJ_Y+1	;	    "            LN^[{{
BITMAP_OBJ_C	EQU	BITMAP_OBJ_S+1	;	    h		 nai^CvpbgmD
BTMP_COL_CNT	EQU	BITMAP_OBJDT+500H
;;;;;		EQU	BTMP_COL_CNT+2
;
BITMAP_DIV	EQU	701200H		;rbg}bvpP^f[^
BITMAP_COL	EQU	BITMAP_DIV+400H
BTMP_MOTO_COL	EQU	BITMAP_COL+200H
BTMP_CHG_COL	EQU	BTMP_MOTO_COL+200H
BITMAP_BF	EQU	BTMP_CHG_COL+200H	;rbg}bvobt@
;;;;;		EQU	BITMAP_BF+6000H
;
;;;;K;;;;BITMAP_DIV	EQU	701600H		;rbg}bvpP^f[^
;;;;K;;;;BITMAP_BF	EQU	701C00H		;rbg}bvobt@
;;;;K;;;;;;;;		EQU	BITMAP_BF+6000H
;
;
;----------------------------------------------------------------
;-		Z[u q`l					-
;----------------------------------------------------------------
SAVERAM0	EQU	707C00H
SAVERAM1	EQU	SAVERAM0+2+1+(12*6)+27+2
SAVERAM2	EQU	SAVERAM1+2+1+(12*6)+27+2
SAVERAM0_BAK	EQU	SAVERAM2+2+1+(12*6)+27+2
SAVERAM1_BAK	EQU	SAVERAM0_BAK+2+1+(12*6)+27+2
SAVERAM2_BAK	EQU	SAVERAM1_BAK+2+1+(12*6)+27+2
RAMCHK0		EQU	SAVERAM2_BAK+2+1+(12*6)+27+2
RAMCHK1		EQU	RAMCHK0+2
RAMCHK2		EQU	RAMCHK1+2
RAMCHK0_BAK	EQU	RAMCHK2+2
RAMCHK1_BAK	EQU	RAMCHK0_BAK+2
RAMCHK2_BAK	EQU	RAMCHK1_BAK+2
SLCT_FILE_NO	EQU	RAMCHK2_BAK+2
;;;;;		EQU	SLCT_FILE_NO+2
;
;
;
;
;
