﻿use strict;
use utf8;

use reverse;

my $DOWN_DIR = "../../../../downloader/ARM9/src";
my @DOWN = (
	"main.c",
	"gui.c"
);

#***********************************************************
# パッケージdownloader
#***********************************************************
package downloader;

#===========================================================
# 逆変換処理。
#===========================================================
sub reverseConv {
	my ($fname, $msg_id_list, $data, $lang_mark) = @_;
	my ($num, %code_list);

	$num = get_data($data, 0, 'S');
	for my $i ( 0 .. $num - 1 ) {
		my ($ofs, $len, @code, $str, $str_len);

		$ofs = get_data($data, $i * 8 + 4, "L");
		$len = get_data($data, $i * 8 + 8, "L");
		@code = get_data($data, $ofs, "S$len");
		for my $j (@code) {
			my $code;

			if (0x401 <= $j && $j <= 0xd61) {
				$code = sprintf("0x%02x", $j);
			} else {
				$code = $reverse::CONV{sprintf("0x%02x", $j)};
				if (!defined($code)) {
					print errata::out("逆無", $i, $j);
					next;
				}
			}
			$str .= $code . ",";
			$str_len += length($code) + 1;
			if ($code eq "CR_CODE_" || 100 <= $str_len) {
				$str .= "\n";
				$str_len = 0;
			}
		}
		$code_list{$msg_id_list->[$i]} = $str;
	}

	# ファイルに反映。
	{
		my ($path, $out, $mode);

		$path = sprintf("$DOWN_DIR/msg_%s.h", $lang_mark);
		if (!open(DOWN, $path)) {
			die "${path}が開けません。\n";
		}
		binmode(DOWN, "encoding(shiftjis)");

		$mode = 0;
		while (<DOWN>) {
			if ($mode == 1) {
				if (/^$/) {
					$mode = 0;
					$out .= $_;
				}
			} elsif (/^#define\tDOWNLOADER_(\d{3}) \\$/) {
				my $msg_id = "downloader_$1";
				my ($str);

				$mode = 1;
				$out .= $_;
				if (!exists $code_list{$msg_id}) {
					die "${msg_id}はgmmにありません。\n";
				}
				$str = $code_list{$msg_id};
				$str =~ s/^/\t\t\t/mg;
				$str =~ s/$/\\/mg;
				$out .= $str . "\n";
			} else {
				$out .= $_;
			}
		}
		close DOWN;

		$path = sprintf("$DOWN_DIR/msg_%s.h", $lang_mark);
		if (!open(DOWN, ">$path")) {
			die "${path}が開けません。\n";
		}
		binmode(DOWN, "encoding(shiftjis)");
		print DOWN $out;
		close DOWN;
	}
}

#---------------------------------------------------------------
# private
#---------------------------------------------------------------

#===============================================================
# バイナリデータ取得。
#===============================================================
sub get_data {
	my ($data, $ofs, $temp) = @_;

	return unpack($temp, substr($data, $ofs));
}

1;
