﻿use strict;
use utf8;

#***********************************************************
# パッケージerrata
#***********************************************************
package errata;

my %KIND = (
	"元使用"   => { disp => 1, type => "none",    msg => "元テキスト採用: %s\n" },
	"未使用"   => { disp => 1, type => "warning", msg => "(%s)韓国語版で使用予定のない文字です。\n" },
	"ムラムラ" => { disp => 0, type => "warning", msg => "(%s)ゴミです。ムラムラ挿入。\n" },
	"日本短い" => { disp => 0, type => "warning", msg => "(%s)ゴミメッセージが日本語長をオーバーします。\n" },
	"変換不可" => { disp => 1, type => "error",   msg => "(%s)変換できません。\n" },
	"_無"      => { disp => 1, type => "error",   msg => "_XXX_の終端がありません。\n" },
	"_未定義"  => { disp => 1, type => "error",   msg => "_%s_は定義がありません。\n" },
	"タグ終無" => { disp => 1, type => "error",   msg => "タグの終端がありません。\n" },
	"タグ要少" => { disp => 1, type => "error",   msg => "タグの要素数が少ないです。\n" },
	"タグ無"   => { disp => 1, type => "error",   msg => "定義されていないタグです。\n" },
	"不正タグ" => { disp => 1, type => "error",   msg => "[%s]は想定外のタグです。\n" },
	"使いすぎ" => { disp => 1, type => "error",   msg => "[%s]タグは使いすぎです。\n" },
	"未タグ"   => { disp => 1, type => "error",   msg => "[%s]タグは使ってないです。\n" },
	"タグ異常" => { disp => 1, type => "error",   msg => "タグの構造がおかしいです。\n" },
	"ウェイト" => { disp => 1, type => "error",   msg => "スクロール属性でありません(WC=%s)。\n" },
	"終待ち"   => { disp => 1, type => "error",   msg => "ウェイトの終わり方がよくないです(%s)。\n" },
	"文字数超" => { disp => 1, type => "error",   msg => "文字数がオーバーです(%d < %d)。\n" },
	"逆無"     => { disp => 1, type => "error",   msg => "逆変換の文字定義がないです(%s: 0x%02x)。\n" },
	"行数超"   => { disp => 1, type => "error",   msg => "行数オーバーです(limit: %d, win_con: %s)。\n" },
	"スペース" => { disp => 1, type => "error",   msg => "文頭か文末にスペースがあるか、改行があります。\n" },
	"不通信"   => { disp => 1, type => "error",   msg => "(%s)通信される文字列には使えません。\n" },
	"未ダブり" => { disp => 1, type => "error",   msg => "ダブり情報がない, カテゴリ[%s], %s\n" },
	"タグパラ" => { disp => 1, type => "error",   msg => "タググループ1のパラメータ異常です。\n" },
	"助詞"     => { disp => 1, type => "error",   msg => "定義されていない助詞(%s)です。\n" },
);
my %TYPE = (
	"none"    => { disp => 1, msg => "" },
	"warning" => { disp => 1, msg => "warning: " },
	"error"   => { disp => 1, msg => "error: " }
);

#===========================================================
# 出力。
#===========================================================
sub out {
	my ($kind, @arg) = @_;
	my ($str, $val, $t_val);

	$val = $KIND{$kind};
	$t_val = $TYPE{$val->{type}};
	if ($val->{disp} && $t_val->{disp}) {
		$str = $t_val->{msg} . sprintf($val->{msg}, @arg);
	}
	return $str;
}

1;
