﻿#	※ このファイルは、UTF8が扱えるエディタで編集して下さい。
#

use strict;
use utf8;

#***********************************************************
# パッケージletter
#***********************************************************
package letter;

our $LETTER =
	"　ぁあぃいぅうぇえぉおかがきぎく" .	# 0x001
	"ぐけげこごさざしじすずせぜそぞた" .	# 0x011
	"だちぢっつづてでとどなにぬねのは" .	# 0x021
	"ばぱひびぴふぶぷへべぺほぼぽまみ" .	# 0x031
	"むめもゃやゅゆょよらりるれろわを" .	# 0x041
	"んァアィイゥウェエォオカガキギク" .	# 0x051
	"グケゲコゴサザシジスズセゼソゾタ" .	# 0x061
	"ダチヂッツヅテデトドナニヌネノハ" .	# 0x071
	"バパヒビピフブプヘベペホボポマミ" .	# 0x081
	"ムメモャヤュユョヨラリルレロワヲ" .	# 0x091
	"ン０１２３４５６７８９ＡＢＣＤＥ" .	# 0x0a1
	"ＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵ" .	# 0x0b1
	"ＶＷＸＹＺａｂｃｄｅｆｇｈｉｊｋ" .	# 0x0c1
	"ｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ_" .	# 0x0d1
	"！？、。…・／「」『』（）♂♀＋" .	# 0x0e1
	"ー×÷＝～：；．，_____◎○" .		# 0x0f1
	"□△◇＠_％☀☁☂☃______" .		# 0x101
	"_円_____________＆" .			# 0x111
	"0123456789ABCDEF" .			# 0x121
	"GHIJKLMNOPQRSTUV" .			# 0x131
	"WXYZabcdefghijkl" .			# 0x141
	"mnopqrstuvwxyzÀÁ" .			# 0x151
	"ÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑ" .			# 0x161
	"ÒÓÔÕÖ_ØÙÚÛÜÝÞßàá" .			# 0x171
	"âãäåæçèéêëìíîïðñ" .			# 0x181
	"òóôõö_øùúûüýþÿŒœ" .			# 0x191
	"Şşªº___\$¡¿!?,.__" .			# 0x1a1
	"/_'_\"„__()__+-*#" .			# 0x1b1
	"=&~:;__________@" .			# 0x1c1
	"_%___________ __" .			# 0x1d1
	"_______°";				# 0x1e1

our $KOR_ONLY =
	"♂♀" .
	"0123456789ABCDEF" .
	"GHIJKLMNOPQRSTUV" .
	"WXYZabcdefghijkl" .
	"mnopqrstuvwxyz!?" .
	"ÄÈÓÖßàáâäçèéíñóòôöùüœ" .
	",./'\"()+-=&:% ";

our $LETTER_KOR =
	"가각간갇갈갉갊감갑값갓갔강갖갗같" .	# 0x401
	"갚갛개객갠갤갬갭갯갰갱갸갹갼걀걋" .	# 0x411
	"걍걔걘걜거걱건걷걸걺검겁것겄겅겆" .	# 0x421
	"겉겊겋게겐겔겜겝겟겠겡겨격겪견겯" .	# 0x431
	"결겸겹겻겼경곁계곈곌곕곗고곡곤곧" .	# 0x441
	"골곪곬곯곰곱곳공곶과곽관괄괆괌괍" .	# 0x451
	"괏광괘괜괠괩괬괭괴괵괸괼굄굅굇굉" .	# 0x461
	"교굔굘굡굣구국군굳굴굵굶굻굼굽굿" .	# 0x471
	"궁궂궈궉권궐궜궝궤궷귀귁귄귈귐귑" .	# 0x481
	"귓규균귤그극근귿글긁금급긋긍긔기" .	# 0x491
	"긱긴긷길긺김깁깃깅깆깊까깍깎깐깔" .	# 0x4a1
	"깖깜깝깟깠깡깥깨깩깬깰깸깹깻깼깽" .	# 0x4b1
	"꺄꺅꺌꺼꺽꺾껀껄껌껍껏껐껑께껙껜" .	# 0x4c1
	"껨껫껭껴껸껼꼇꼈꼍꼐꼬꼭꼰꼲꼴꼼" .	# 0x4d1
	"꼽꼿꽁꽂꽃꽈꽉꽐꽜꽝꽤꽥꽹꾀꾄꾈" .	# 0x4e1
	"꾐꾑꾕꾜꾸꾹꾼꿀꿇꿈꿉꿋꿍꿎꿔꿜" .	# 0x4f1
	"꿨꿩꿰꿱꿴꿸뀀뀁뀄뀌뀐뀔뀜뀝뀨끄" .	# 0x501
	"끅끈끊끌끎끓끔끕끗끙끝끼끽낀낄낌" .	# 0x511
	"낍낏낑나낙낚난낟날낡낢남납낫났낭" .	# 0x521
	"낮낯낱낳내낵낸낼냄냅냇냈냉냐냑냔" .	# 0x531
	"냘냠냥너넉넋넌널넒넓넘넙넛넜넝넣" .	# 0x541
	"네넥넨넬넴넵넷넸넹녀녁년녈념녑녔" .	# 0x551
	"녕녘녜녠노녹논놀놂놈놉놋농높놓놔" .	# 0x561
	"놘놜놨뇌뇐뇔뇜뇝뇟뇨뇩뇬뇰뇹뇻뇽" .	# 0x571
	"누눅눈눋눌눔눕눗눙눠눴눼뉘뉜뉠뉨" .	# 0x581
	"뉩뉴뉵뉼늄늅늉느늑는늘늙늚늠늡늣" .	# 0x591
	"능늦늪늬늰늴니닉닌닐닒님닙닛닝닢" .	# 0x5a1
	"다닥닦단닫달닭닮닯닳담답닷닸당닺" .	# 0x5b1
	"닻닿대댁댄댈댐댑댓댔댕댜더덕덖던" .	# 0x5c1
	"덛덜덞덟덤덥덧덩덫덮데덱덴델뎀뎁" .	# 0x5d1
	"뎃뎄뎅뎌뎐뎔뎠뎡뎨뎬도독돈돋돌돎" .	# 0x5e1
	"돐돔돕돗동돛돝돠돤돨돼됐되된될됨" .	# 0x5f1
	"됩됫됴두둑둔둘둠둡둣둥둬뒀뒈뒝뒤" .	# 0x601
	"뒨뒬뒵뒷뒹듀듄듈듐듕드득든듣들듦" .	# 0x611
	"듬듭듯등듸디딕딘딛딜딤딥딧딨딩딪" .	# 0x621
	"따딱딴딸땀땁땃땄땅땋때땍땐땔땜땝" .	# 0x631
	"땟땠땡떠떡떤떨떪떫떰떱떳떴떵떻떼" .	# 0x641
	"떽뗀뗄뗌뗍뗏뗐뗑뗘뗬또똑똔똘똥똬" .	# 0x651
	"똴뙈뙤뙨뚜뚝뚠뚤뚫뚬뚱뛔뛰뛴뛸뜀" .	# 0x661
	"뜁뜅뜨뜩뜬뜯뜰뜸뜹뜻띄띈띌띔띕띠" .	# 0x671
	"띤띨띰띱띳띵라락란랄람랍랏랐랑랒" .	# 0x681
	"랖랗래랙랜랠램랩랫랬랭랴략랸럇량" .	# 0x691
	"러럭런럴럼럽럿렀렁렇레렉렌렐렘렙" .	# 0x6a1
	"렛렝려력련렬렴렵렷렸령례롄롑롓로" .	# 0x6b1
	"록론롤롬롭롯롱롸롼뢍뢨뢰뢴뢸룀룁" .	# 0x6c1
	"룃룅료룐룔룝룟룡루룩룬룰룸룹룻룽" .	# 0x6d1
	"뤄뤘뤠뤼뤽륀륄륌륏륑류륙륜률륨륩" .	# 0x6e1
	"륫륭르륵른를름릅릇릉릊릍릎리릭린" .	# 0x6f1
	"릴림립릿링마막만많맏말맑맒맘맙맛" .	# 0x701
	"망맞맡맣매맥맨맬맴맵맷맸맹맺먀먁" .	# 0x711
	"먈먕머먹먼멀멂멈멉멋멍멎멓메멕멘" .	# 0x721
	"멜멤멥멧멨멩며멱면멸몃몄명몇몌모" .	# 0x731
	"목몫몬몰몲몸몹못몽뫄뫈뫘뫙뫼묀묄" .	# 0x741
	"묍묏묑묘묜묠묩묫무묵묶문묻물묽묾" .	# 0x751
	"뭄뭅뭇뭉뭍뭏뭐뭔뭘뭡뭣뭬뮈뮌뮐뮤" .	# 0x761
	"뮨뮬뮴뮷므믄믈믐믓미믹민믿밀밂밈" .	# 0x771
	"밉밋밌밍및밑바박밖밗반받발밝밞밟" .	# 0x781
	"밤밥밧방밭배백밴밸뱀뱁뱃뱄뱅뱉뱌" .	# 0x791
	"뱍뱐뱝버벅번벋벌벎범법벗벙벚베벡" .	# 0x7a1
	"벤벧벨벰벱벳벴벵벼벽변별볍볏볐병" .	# 0x7b1
	"볕볘볜보복볶본볼봄봅봇봉봐봔봤봬" .	# 0x7c1
	"뵀뵈뵉뵌뵐뵘뵙뵤뵨부북분붇불붉붊" .	# 0x7d1
	"붐붑붓붕붙붚붜붤붰붸뷔뷕뷘뷜뷩뷰" .	# 0x7e1
	"뷴뷸븀븃븅브븍븐블븜븝븟비빅빈빌" .	# 0x7f1
	"빎빔빕빗빙빚빛빠빡빤빨빪빰빱빳빴" .	# 0x801
	"빵빻빼빽뺀뺄뺌뺍뺏뺐뺑뺘뺙뺨뻐뻑" .	# 0x811
	"뻔뻗뻘뻠뻣뻤뻥뻬뼁뼈뼉뼘뼙뼛뼜뼝" .	# 0x821
	"뽀뽁뽄뽈뽐뽑뽕뾔뾰뿅뿌뿍뿐뿔뿜뿟" .	# 0x831
	"뿡쀼쁑쁘쁜쁠쁨쁩삐삑삔삘삠삡삣삥" .	# 0x841
	"사삭삯산삳살삵삶삼삽삿샀상샅새색" .	# 0x851
	"샌샐샘샙샛샜생샤샥샨샬샴샵샷샹섀" .	# 0x861
	"섄섈섐섕서석섞섟선섣설섦섧섬섭섯" .	# 0x871
	"섰성섶세섹센셀셈셉셋셌셍셔셕션셜" .	# 0x881
	"셤셥셧셨셩셰셴셸솅소속솎손솔솖솜" .	# 0x891
	"솝솟송솥솨솩솬솰솽쇄쇈쇌쇔쇗쇘쇠" .	# 0x8a1
	"쇤쇨쇰쇱쇳쇼쇽숀숄숌숍숏숑수숙순" .	# 0x8b1
	"숟술숨숩숫숭숯숱숲숴쉈쉐쉑쉔쉘쉠" .	# 0x8c1
	"쉥쉬쉭쉰쉴쉼쉽쉿슁슈슉슐슘슛슝스" .	# 0x8d1
	"슥슨슬슭슴습슷승시식신싣실싫심십" .	# 0x8e1
	"싯싱싶싸싹싻싼쌀쌈쌉쌌쌍쌓쌔쌕쌘" .	# 0x8f1
	"쌜쌤쌥쌨쌩썅써썩썬썰썲썸썹썼썽쎄" .	# 0x901
	"쎈쎌쏀쏘쏙쏜쏟쏠쏢쏨쏩쏭쏴쏵쏸쐈" .	# 0x911
	"쐐쐤쐬쐰쐴쐼쐽쑈쑤쑥쑨쑬쑴쑵쑹쒀" .	# 0x921
	"쒔쒜쒸쒼쓩쓰쓱쓴쓸쓺쓿씀씁씌씐씔" .	# 0x931
	"씜씨씩씬씰씸씹씻씽아악안앉않알앍" .	# 0x941
	"앎앓암압앗았앙앝앞애액앤앨앰앱앳" .	# 0x951
	"앴앵야약얀얄얇얌얍얏양얕얗얘얜얠" .	# 0x961
	"얩어억언얹얻얼얽얾엄업없엇었엉엊" .	# 0x971
	"엌엎에엑엔엘엠엡엣엥여역엮연열엶" .	# 0x981
	"엷염엽엾엿였영옅옆옇예옌옐옘옙옛" .	# 0x991
	"옜오옥온올옭옮옰옳옴옵옷옹옻와왁" .	# 0x9a1
	"완왈왐왑왓왔왕왜왝왠왬왯왱외왹왼" .	# 0x9b1
	"욀욈욉욋욍요욕욘욜욤욥욧용우욱운" .	# 0x9c1
	"울욹욺움웁웃웅워웍원월웜웝웠웡웨" .	# 0x9d1
	"웩웬웰웸웹웽위윅윈윌윔윕윗윙유육" .	# 0x9e1
	"윤율윰윱윳융윷으윽은을읊음읍읏응" .	# 0x9f1
	"읒읓읔읕읖읗의읜읠읨읫이익인일읽" .	# 0xa01
	"읾잃임입잇있잉잊잎자작잔잖잗잘잚" .	# 0xa11
	"잠잡잣잤장잦재잭잰잴잼잽잿쟀쟁쟈" .	# 0xa21
	"쟉쟌쟎쟐쟘쟝쟤쟨쟬저적전절젊점접" .	# 0xa31
	"젓정젖제젝젠젤젬젭젯젱져젼졀졈졉" .	# 0xa41
	"졌졍졔조족존졸졺좀좁좃종좆좇좋좌" .	# 0xa51
	"좍좔좝좟좡좨좼좽죄죈죌죔죕죗죙죠" .	# 0xa61
	"죡죤죵주죽준줄줅줆줌줍줏중줘줬줴" .	# 0xa71
	"쥐쥑쥔쥘쥠쥡쥣쥬쥰쥴쥼즈즉즌즐즘" .	# 0xa81
	"즙즛증지직진짇질짊짐집짓징짖짙짚" .	# 0xa91
	"짜짝짠짢짤짧짬짭짯짰짱째짹짼쨀쨈" .	# 0xaa1
	"쨉쨋쨌쨍쨔쨘쨩쩌쩍쩐쩔쩜쩝쩟쩠쩡" .	# 0xab1
	"쩨쩽쪄쪘쪼쪽쫀쫄쫌쫍쫏쫑쫓쫘쫙쫠" .	# 0xac1
	"쫬쫴쬈쬐쬔쬘쬠쬡쭁쭈쭉쭌쭐쭘쭙쭝" .	# 0xad1
	"쭤쭸쭹쮜쮸쯔쯤쯧쯩찌찍찐찔찜찝찡" .	# 0xae1
	"찢찧차착찬찮찰참찹찻찼창찾채책챈" .	# 0xaf1
	"챌챔챕챗챘챙챠챤챦챨챰챵처척천철" .	# 0xb01
	"첨첩첫첬청체첵첸첼쳄쳅쳇쳉쳐쳔쳤" .	# 0xb11
	"쳬쳰촁초촉촌촐촘촙촛총촤촨촬촹최" .	# 0xb21
	"쵠쵤쵬쵭쵯쵱쵸춈추축춘출춤춥춧충" .	# 0xb31
	"춰췄췌췐취췬췰췸췹췻췽츄츈츌츔츙" .	# 0xb41
	"츠측츤츨츰츱츳층치칙친칟칠칡침칩" .	# 0xb51
	"칫칭카칵칸칼캄캅캇캉캐캑캔캘캠캡" .	# 0xb61
	"캣캤캥캬캭컁커컥컨컫컬컴컵컷컸컹" .	# 0xb71
	"케켁켄켈켐켑켓켕켜켠켤켬켭켯켰켱" .	# 0xb81
	"켸코콕콘콜콤콥콧콩콰콱콴콸쾀쾅쾌" .	# 0xb91
	"쾡쾨쾰쿄쿠쿡쿤쿨쿰쿱쿳쿵쿼퀀퀄퀑" .	# 0xba1
	"퀘퀭퀴퀵퀸퀼큄큅큇큉큐큔큘큠크큭" .	# 0xbb1
	"큰클큼큽킁키킥킨킬킴킵킷킹타탁탄" .	# 0xbc1
	"탈탉탐탑탓탔탕태택탠탤탬탭탯탰탱" .	# 0xbd1
	"탸턍터턱턴털턺텀텁텃텄텅테텍텐텔" .	# 0xbe1
	"템텝텟텡텨텬텼톄톈토톡톤톨톰톱톳" .	# 0xbf1
	"통톺톼퇀퇘퇴퇸툇툉툐투툭툰툴툼툽" .	# 0xc01
	"툿퉁퉈퉜퉤튀튁튄튈튐튑튕튜튠튤튬" .	# 0xc11
	"튱트특튼튿틀틂틈틉틋틔틘틜틤틥티" .	# 0xc21
	"틱틴틸팀팁팃팅파팍팎판팔팖팜팝팟" .	# 0xc31
	"팠팡팥패팩팬팰팸팹팻팼팽퍄퍅퍼퍽" .	# 0xc41
	"펀펄펌펍펏펐펑페펙펜펠펨펩펫펭펴" .	# 0xc51
	"편펼폄폅폈평폐폘폡폣포폭폰폴폼폽" .	# 0xc61
	"폿퐁퐈퐝푀푄표푠푤푭푯푸푹푼푿풀" .	# 0xc71
	"풂품풉풋풍풔풩퓌퓐퓔퓜퓟퓨퓬퓰퓸" .	# 0xc81
	"퓻퓽프픈플픔픕픗피픽핀필핌핍핏핑" .	# 0xc91
	"하학한할핥함합핫항해핵핸핼햄햅햇" .	# 0xca1
	"했행햐향허헉헌헐헒험헙헛헝헤헥헨" .	# 0xcb1
	"헬헴헵헷헹혀혁현혈혐협혓혔형혜혠" .	# 0xcc1
	"혤혭호혹혼홀홅홈홉홋홍홑화확환활" .	# 0xcd1
	"홧황홰홱홴횃횅회획횐횔횝횟횡효횬" .	# 0xce1
	"횰횹횻후훅훈훌훑훔훗훙훠훤훨훰훵" .	# 0xcf1
	"훼훽휀휄휑휘휙휜휠휨휩휫휭휴휵휸" .	# 0xd01
	"휼흄흇흉흐흑흔흖흗흘흙흠흡흣흥흩" .	# 0xd11
	"희흰흴흼흽힁히힉힌힐힘힙힛힝__" .	# 0xd21
	"ㄱㄲㄴㄷㄸㄹㅁㅂㅃㅅㅆㅇㅈㅉㅊㅋ" .	# 0xd31
	"ㅌㅍㅎㅏㅐㅑㅒㅓㅔㅕㅖㅗㅛㅜㅠㅡ" .	# 0xd41
	"ㅣ_______________" .			# 0xd51
	"뢔쌰쎼쓔쬬";				# 0xd61

our %UNDERSCORE = (
	"NULL"     => "",               "SPADE"   => pack('S', 0xfa),  "CLUB"   => pack('S', 0xfb),
	"HEART"    => pack('S', 0xfc),  "DIAMOND" => pack('S', 0xfd),  "STAR"   => pack('S', 0xfe),
	"MUSIC"    => pack('S', 0x105), "NORMAL"  => pack('S', 0x10b), "SMILE"  => pack('S', 0x10c),
	"CRY"      => pack('S', 0x10d), "ANGRY"   => pack('S', 0x10e), "UPPER"  => pack('S', 0x10f),
	"DOWNER"   => pack('S', 0x110), "SLEEP"   => pack('S', 0x111), "ITEM"   => pack('S', 0x113),
	"KEYITEM"  => pack('S', 0x114), "MACHINE" => pack('S', 0x115), "SEAL"   => pack('S', 0x116),
	"MEDICINE" => pack('S', 0x117), "NUT"     => pack('S', 0x118), "BALL"   => pack('S', 0x119),
	"BATTLE"   => pack('S', 0x11a), "LEFT"    => pack('S', 0x11b), "UP"     => pack('S', 0x11c),
	"DOWN"     => pack('S', 0x11d), "RIGHT"   => pack('S', 0x11e), "CURSOR" => pack('S', 0x11f),
	"TIMES"    => pack('S', 0x176), "DIVIDES" => pack('S', 0x196), "er"     => pack('S', 0x1a5),
	"re"       => pack('S', 0x1a6), "r"       => pack('S', 0x1a7), "LEADER" => pack('S', 0x1af),
	"CDOT"     => pack('S', 0x1b0), "SQUOTE"  => pack('S', 0x1b2), "DQUOTE" => pack('S', 0x1b4),
	"MALE"     => pack('S', 0x1bb), "FEMALE"  => pack('S', 0x1bc), "e"      => pack('S', 0x1df),
	"PKMN"     => pack('S', 0x1e0) . pack('S', 0x1e1),             "SPCNUM" => pack('S', 0x1e2)
);

our %TAG = (
	"[3:00:" => "HEART_",
	"[3:01:" => "MUSIC_",
	"[3:02:" => "ITEM_",
	"[3:03:" => "KEYITEM_",
	"[3:04:" => "MACHINE_",
	"[3:05:" => "SEAL_",
	"[3:06:" => "MEDICINE_",
	"[3:07:" => "NUT_",
	"[3:08:" => "BALL_",
	"[3:09:" => "BATTLE_",
	"[3:0A:" => "LEFT_",
	"[3:0B:" => "UP_",
	"[3:0C:" => "RIGHT_",
	"[3:0D:" => "MALE_",
	"[3:0E:" => "FEMALE_",
	"[4:00:" => "er_",
	"[4:01:" => "re_",
	"[4:02:" => "r_",
	"[4:03:" => "e_",
	"[4:04:" => "LEADER_",
	"[4:05:" => "CDOT_",
	"[4:06:" => "SQUOTE_",
	"[4:07:" => "DQUOTE_",
	"[4:08:" => "PKMN_",
	"[4:09:" => "NULL_"
);

our @POKE_EACH = ( "ㄱㄴ", "ㄷㄹ", "ㅁㅂ", "ㅅㅇ",
	"ㅈㅊ", "ㅋㅌ", "ㅍㅎ" );

our @REP_TABLE = (
	{ reg => qr/_NULL_/,	rep => "" },
	{ reg => qr/_er_/,	rep => "一" },
	{ reg => qr/_re_/,	rep => "二" },
	{ reg => qr/_r_/,	rep => "三" },
	{ reg => qr/_e_/,	rep => "四" },
	{ reg => qr/_LEADER_/,	rep => "..." },
	{ reg => qr/_CDOT_/,	rep => "・" },
	{ reg => qr/_SQUOTE_/,	rep => "‘" },
	{ reg => qr/_DQUOTE_/,	rep => "“" },
	{ reg => qr/_MALE_/,	rep => "♂" },
	{ reg => qr/_FEMALE_/,	rep => "♀" },
	{ reg => qr/_PKMN_/,	rep => "PKMN" },
	{ reg => qr/Æ/,		rep => "AE" },
	{ reg => qr/Œ/,		rep => "OE" },
);

our @PHASE1_TABLE = (
	{ trans => "一",	phase1 => "ER" },
	{ trans => "二",	phase1 => "RE" },
	{ trans => "三",	phase1 => "R" },
	{ trans => "四",	phase1 => "E" },
	{ trans => " ‘'“\"„@#\$%&()*+,-./:;=¡!¿?~・♀♂°",
				phase1 => "" },
	{ trans => "ÀÁÂÃÄÅª",	phase1 => "A" },
	{ trans => "Ç",		phase1 => "C" },
	{ trans => "Ð",		phase1 => "D" },
	{ trans => "ÈÉÊË",	phase1 => "E" },
	{ trans => "ÌÍÎÏ",	phase1 => "I" },
	{ trans => "ÒÓÔÕÖØº",	phase1 => "O" },
	{ trans => "ßŞ",	phase1 => "S" },
	{ trans => "ÙÚÛÜ",	phase1 => "U" },
	{ trans => "ÝÞ",	phase1 => "Y" },
);

our $PHASE2_1 =
	"0123456789" .
	" ‘'“\"„@#\$%&()*+,-./:;=¡!¿?~・♀♂°";

our $PHASE2_2 =
	"AaÁáÀàÂâÄäÃãÅåªBbCcÇçDdÐðEeÉéÈèÊêËë四一" .
	"FfGgHhIiÍíÌìÎîÏïJjKkLlMmNnÑñ" .
	"OoÓóÒòÔôÖöÕõØøºPpQqRr三二SsßÿŞşTt" .
	"UuÚúÙùÛûÜüVvWwXxYyÝýÞþZz" .
	"ぁあぃいぅうぇえぉおかがきぎくぐ" .
	"けげこごさざしじすずせぜそぞただ" .
	"ちぢっつづてでとどなにぬねのはば" .
	"ぱひびぴふぶぷへべぺほぼぽまみむ" .
	"めもゃやゅゆょよらりるれろわをん" .
	"ァアィイゥウェエォオカガキギクグ" .
	"ケゲコゴサザシジスズセゼソゾタダ" .
	"チヂッツヅテデトドナニヌネノハバ" .
	"パヒビピフブプヘベペホボポマミム" .
	"メモャヤュユョヨラリルレロワヲン";

our $PHASE2_HUNGEUL =
	"ㄱ가각간갇갈갉갊감갑값갓갔강갖갗같" .
	"갚갛개객갠갤갬갭갯갰갱갸갹갼걀걋" .
	"걍걔걘걜거걱건걷걸걺검겁것겄겅겆" .
	"겉겊겋게겐겔겜겝겟겠겡겨격겪견겯" .
	"결겸겹겻겼경곁계곈곌곕곗고곡곤곧" .
	"골곪곬곯곰곱곳공곶과곽관괄괆괌괍" .
	"괏광괘괜괠괩괬괭괴괵괸괼굄굅굇굉" .
	"교굔굘굡굣구국군굳굴굵굶굻굼굽굿" .
	"궁궂궈궉권궐궜궝궤궷귀귁귄귈귐귑" .
	"귓규균귤그극근귿글긁금급긋긍긔기" .
	"긱긴긷길긺김깁깃깅깆깊ㄲ까깍깎깐깔" .
	"깖깜깝깟깠깡깥깨깩깬깰깸깹깻깼깽" .
	"꺄꺅꺌꺼꺽꺾껀껄껌껍껏껐껑께껙껜" .
	"껨껫껭껴껸껼꼇꼈꼍꼐꼬꼭꼰꼲꼴꼼" .
	"꼽꼿꽁꽂꽃꽈꽉꽐꽜꽝꽤꽥꽹꾀꾄꾈" .
	"꾐꾑꾕꾜꾸꾹꾼꿀꿇꿈꿉꿋꿍꿎꿔꿜" .
	"꿨꿩꿰꿱꿴꿸뀀뀁뀄뀌뀐뀔뀜뀝뀨끄" .
	"끅끈끊끌끎끓끔끕끗끙끝끼끽낀낄낌" .
	"낍낏낑ㄴ나낙낚난낟날낡낢남납낫났낭" .
	"낮낯낱낳내낵낸낼냄냅냇냈냉냐냑냔" .
	"냘냠냥너넉넋넌널넒넓넘넙넛넜넝넣" .
	"네넥넨넬넴넵넷넸넹녀녁년녈념녑녔" .
	"녕녘녜녠노녹논놀놂놈놉놋농높놓놔" .
	"놘놜놨뇌뇐뇔뇜뇝뇟뇨뇩뇬뇰뇹뇻뇽" .
	"누눅눈눋눌눔눕눗눙눠눴눼뉘뉜뉠뉨" .
	"뉩뉴뉵뉼늄늅늉느늑는늘늙늚늠늡늣" .
	"능늦늪늬늰늴니닉닌닐닒님닙닛닝닢" .
	"ㄷ다닥닦단닫달닭닮닯닳담답닷닸당닺" .
	"닻닿대댁댄댈댐댑댓댔댕댜더덕덖던" .
	"덛덜덞덟덤덥덧덩덫덮데덱덴델뎀뎁" .
	"뎃뎄뎅뎌뎐뎔뎠뎡뎨뎬도독돈돋돌돎" .
	"돐돔돕돗동돛돝돠돤돨돼됐되된될됨" .
	"됩됫됴두둑둔둘둠둡둣둥둬뒀뒈뒝뒤" .
	"뒨뒬뒵뒷뒹듀듄듈듐듕드득든듣들듦" .
	"듬듭듯등듸디딕딘딛딜딤딥딧딨딩딪" .
	"ㄸ따딱딴딸땀땁땃땄땅땋때땍땐땔땜땝" .
	"땟땠땡떠떡떤떨떪떫떰떱떳떴떵떻떼" .
	"떽뗀뗄뗌뗍뗏뗐뗑뗘뗬또똑똔똘똥똬" .
	"똴뙈뙤뙨뚜뚝뚠뚤뚫뚬뚱뛔뛰뛴뛸뜀" .
	"뜁뜅뜨뜩뜬뜯뜰뜸뜹뜻띄띈띌띔띕띠" .
	"띤띨띰띱띳띵ㄹ라락란랄람랍랏랐랑랒" .
	"랖랗래랙랜랠램랩랫랬랭랴략랸럇량" .
	"러럭런럴럼럽럿렀렁렇레렉렌렐렘렙" .
	"렛렝려력련렬렴렵렷렸령례롄롑롓로" .
	"록론롤롬롭롯롱롸롼뢍뢔뢨뢰뢴뢸룀" .
	"룁룃룅료룐룔룝룟룡루룩룬룰룸룹룻" .
	"룽뤄뤘뤠뤼뤽륀륄륌륏륑류륙륜률륨" .
	"륩륫륭르륵른를름릅릇릉릊릍릎리릭" .
	"린릴림립릿링ㅁ마막만많맏말맑맒맘맙" .
	"맛망맞맡맣매맥맨맬맴맵맷맸맹맺먀" .
	"먁먈먕머먹먼멀멂멈멉멋멍멎멓메멕" .
	"멘멜멤멥멧멨멩며멱면멸몃몄명몇몌" .
	"모목몫몬몰몲몸몹못몽뫄뫈뫘뫙뫼묀" .
	"묄묍묏묑묘묜묠묩묫무묵묶문묻물묽" .
	"묾뭄뭅뭇뭉뭍뭏뭐뭔뭘뭡뭣뭬뮈뮌뮐" .
	"뮤뮨뮬뮴뮷므믄믈믐믓미믹민믿밀밂" .
	"밈밉밋밌밍및밑ㅂ바박밖밗반받발밝밞" .
	"밟밤밥밧방밭배백밴밸뱀뱁뱃뱄뱅뱉" .
	"뱌뱍뱐뱝버벅번벋벌벎범법벗벙벚베" .
	"벡벤벧벨벰벱벳벴벵벼벽변별볍볏볐" .
	"병볕볘볜보복볶본볼봄봅봇봉봐봔봤" .
	"봬뵀뵈뵉뵌뵐뵘뵙뵤뵨부북분붇불붉" .
	"붊붐붑붓붕붙붚붜붤붰붸뷔뷕뷘뷜뷩" .
	"뷰뷴뷸븀븃븅브븍븐블븜븝븟비빅빈" .
	"빌빎빔빕빗빙빚빛ㅃ빠빡빤빨빪빰빱빳" .
	"빴빵빻빼빽뺀뺄뺌뺍뺏뺐뺑뺘뺙뺨뻐" .
	"뻑뻔뻗뻘뻠뻣뻤뻥뻬뼁뼈뼉뼘뼙뼛뼜" .
	"뼝뽀뽁뽄뽈뽐뽑뽕뾔뾰뿅뿌뿍뿐뿔뿜" .
	"뿟뿡쀼쁑쁘쁜쁠쁨쁩삐삑삔삘삠삡삣" .
	"삥ㅅ사삭삯산삳살삵삶삼삽삿샀상샅새" .
	"색샌샐샘샙샛샜생샤샥샨샬샴샵샷샹" .
	"섀섄섈섐섕서석섞섟선섣설섦섧섬섭" .
	"섯섰성섶세섹센셀셈셉셋셌셍셔셕션" .
	"셜셤셥셧셨셩셰셴셸솅소속솎손솔솖" .
	"솜솝솟송솥솨솩솬솰솽쇄쇈쇌쇔쇗쇘" .
	"쇠쇤쇨쇰쇱쇳쇼쇽숀숄숌숍숏숑수숙" .
	"순숟술숨숩숫숭숯숱숲숴쉈쉐쉑쉔쉘" .
	"쉠쉥쉬쉭쉰쉴쉼쉽쉿슁슈슉슐슘슛슝" .
	"스슥슨슬슭슴습슷승시식신싣실싫심" .
	"십싯싱싶ㅆ싸싹싻싼쌀쌈쌉쌌쌍쌓쌔쌕" .
	"쌘쌜쌤쌥쌨쌩쌰썅써썩썬썰썲썸썹썼" .
	"썽쎄쎈쎌쎼쏀쏘쏙쏜쏟쏠쏢쏨쏩쏭쏴" .
	"쏵쏸쐈쐐쐤쐬쐰쐴쐼쐽쑈쑤쑥쑨쑬쑴" .
	"쑵쑹쒀쒔쒜쒸쒼쓔쓩쓰쓱쓴쓸쓺쓿씀" .
	"씁씌씐씔씜씨씩씬씰씸씹씻씽ㅇ아악안" .
	"앉않알앍앎앓암압앗았앙앝앞애액앤" .
	"앨앰앱앳앴앵야약얀얄얇얌얍얏양얕" .
	"얗얘얜얠얩어억언얹얻얼얽얾엄업없" .
	"엇었엉엊엌엎에엑엔엘엠엡엣엥여역" .
	"엮연열엶엷염엽엾엿였영옅옆옇예옌" .
	"옐옘옙옛옜오옥온올옭옮옰옳옴옵옷" .
	"옹옻와왁완왈왐왑왓왔왕왜왝왠왬왯" .
	"왱외왹왼욀욈욉욋욍요욕욘욜욤욥욧" .
	"용우욱운울욹욺움웁웃웅워웍원월웜" .
	"웝웠웡웨웩웬웰웸웹웽위윅윈윌윔윕" .
	"윗윙유육윤율윰윱윳융윷으윽은을읊" .
	"음읍읏응읒읓읔읕읖읗의읜읠읨읫이" .
	"익인일읽읾잃임입잇있잉잊잎ㅈ자작잔" .
	"잖잗잘잚잠잡잣잤장잦재잭잰잴잼잽" .
	"잿쟀쟁쟈쟉쟌쟎쟐쟘쟝쟤쟨쟬저적전" .
	"절젊점접젓정젖제젝젠젤젬젭젯젱져" .
	"젼졀졈졉졌졍졔조족존졸졺좀좁좃종" .
	"좆좇좋좌좍좔좝좟좡좨좼좽죄죈죌죔" .
	"죕죗죙죠죡죤죵주죽준줄줅줆줌줍줏" .
	"중줘줬줴쥐쥑쥔쥘쥠쥡쥣쥬쥰쥴쥼즈" .
	"즉즌즐즘즙즛증지직진짇질짊짐집짓" .
	"징짖짙짚ㅉ짜짝짠짢짤짧짬짭짯짰짱째" .
	"짹짼쨀쨈쨉쨋쨌쨍쨔쨘쨩쩌쩍쩐쩔쩜" .
	"쩝쩟쩠쩡쩨쩽쪄쪘쪼쪽쫀쫄쫌쫍쫏쫑" .
	"쫓쫘쫙쫠쫬쫴쬈쬐쬔쬘쬠쬡쬬쭁쭈쭉" .
	"쭌쭐쭘쭙쭝쭤쭸쭹쮜쮸쯔쯤쯧쯩찌찍" .
	"찐찔찜찝찡찢찧ㅊ차착찬찮찰참찹찻찼" .
	"창찾채책챈챌챔챕챗챘챙챠챤챦챨챰" .
	"챵처척천철첨첩첫첬청체첵첸첼쳄쳅" .
	"쳇쳉쳐쳔쳤쳬쳰촁초촉촌촐촘촙촛총" .
	"촤촨촬촹최쵠쵤쵬쵭쵯쵱쵸춈추축춘" .
	"출춤춥춧충춰췄췌췐취췬췰췸췹췻췽" .
	"츄츈츌츔츙츠측츤츨츰츱츳층치칙친" .
	"칟칠칡침칩칫칭ㅋ카칵칸칼캄캅캇캉캐" .
	"캑캔캘캠캡캣캤캥캬캭컁커컥컨컫컬" .
	"컴컵컷컸컹케켁켄켈켐켑켓켕켜켠켤" .
	"켬켭켯켰켱켸코콕콘콜콤콥콧콩콰콱" .
	"콴콸쾀쾅쾌쾡쾨쾰쿄쿠쿡쿤쿨쿰쿱쿳" .
	"쿵쿼퀀퀄퀑퀘퀭퀴퀵퀸퀼큄큅큇큉큐" .
	"큔큘큠크큭큰클큼큽킁키킥킨킬킴킵" .
	"킷킹ㅌ타탁탄탈탉탐탑탓탔탕태택탠탤" .
	"탬탭탯탰탱탸턍터턱턴털턺텀텁텃텄" .
	"텅테텍텐텔템텝텟텡텨텬텼톄톈토톡" .
	"톤톨톰톱톳통톺톼퇀퇘퇴퇸툇툉툐투" .
	"툭툰툴툼툽툿퉁퉈퉜퉤튀튁튄튈튐튑" .
	"튕튜튠튤튬튱트특튼튿틀틂틈틉틋틔" .
	"틘틜틤틥티틱틴틸팀팁팃팅ㅍ파팍팎판" .
	"팔팖팜팝팟팠팡팥패팩팬팰팸팹팻팼" .
	"팽퍄퍅퍼퍽펀펄펌펍펏펐펑페펙펜펠" .
	"펨펩펫펭펴편펼폄폅폈평폐폘폡폣포" .
	"폭폰폴폼폽폿퐁퐈퐝푀푄표푠푤푭푯" .
	"푸푹푼푿풀풂품풉풋풍풔풩퓌퓐퓔퓜" .
	"퓟퓨퓬퓰퓸퓻퓽프픈플픔픕픗피픽핀" .
	"필핌핍핏핑ㅎ하학한할핥함합핫항해핵" .
	"핸핼햄햅햇했행햐향허헉헌헐헒험헙" .
	"헛헝헤헥헨헬헴헵헷헹혀혁현혈혐협" .
	"혓혔형혜혠혤혭호혹혼홀홅홈홉홋홍" .
	"홑화확환활홧황홰홱홴횃횅회획횐횔" .
	"횝횟횡효횬횰횹횻후훅훈훌훑훔훗훙" .
	"훠훤훨훰훵훼훽휀휄휑휘휙휜휠휨휩" .
	"휫휭휴휵휸휼흄흇흉흐흑흔흖흗흘흙" .
	"흠흡흣흥흩희흰흴흼흽힁히힉힌힐힘" .
	"힙힛힝";

our $PHASE2_HUNGEUL_HEAD =
	"ㄱㄴㄷㄹㅁㅂㅅㅇㅈㅊㅋㅌㅍㅎ";

our %SIMPLE_DUP = (
	"LANG_ENGLISH" => {
		"I" => [
			{ no => 1145, use => 0 },
			{ no => 1176, use => 0 },
			{ no => 1179, use => 0 },
			{ no => 1180, use => 1 }
		], "YOU" => [
			{ no => 1146, use => 1 },
			{ no => 1165, use => 0 }
		], "KIDS" => [
			{ no => 1167, use => 1 },
			{ no => 1175, use => 0 }
		], "HEY" => [
			{ no => 1216, use => 1 },
			{ no => 1264, use => 0 }
		], "HUH?" => [
			{ no => 1191, use => 0 },
			{ no => 1249, use => 1 }
		], "WELCOME" => [
			{ no => 1200, use => 0 },
			{ no => 1279, use => 1 }
		], "WOW" => [
			{ no => 1206, use => 1 },
			{ no => 1285, use => 0 }
		], "OK" => [
			{ no => 1211, use => 1 },
			{ no => 1280, use => 0 }
		]
	}, "LANG_FRANCE" => {
	}, "LANG_GERMANY" => {
	}, "LANG_ITALY" => {
	}, "LANG_SPAIN" => {
	}, "LANG_KOREA" => {
	}
);
