﻿use strict;
use utf8;

#***********************************************************
# パッケージreverse
#***********************************************************
package reverse;

our %CONV = (
	"0xe000" => "CR_CODE_",				# 改行コード
	"0xffff" => "EOM_",
	"0x01" => "spc_",					# "　"
	"0x02" => "aa_",					# "ぁ"
	"0x03" => "a_",						# "あ"
	"0x04" => "ii_",					# "ぃ"
	"0x05" => "i_",						# "い"
	"0x06" => "uu_",					# "ぅ"
	"0x07" => "u_",						# "う"
	"0x08" => "ee_",					# "ぇ"
	"0x09" => "e_",						# "え"
	"0x0a" => "oo_",					# "ぉ"
	"0x0b" => "o_",						# "お"
	"0x0c" => "ka_",					# "か"
	"0x0d" => "ga_",					# "が"
	"0x0e" => "ki_",					# "き"
	"0x0f" => "gi_",					# "ぎ"
	"0x10" => "ku_",					# "く"
	"0x11" => "gu_",					# "ぐ"
	"0x12" => "ke_",					# "け"
	"0x13" => "ge_",					# "げ"
	"0x14" => "ko_",					# "こ"
	"0x15" => "go_",					# "ご"
	"0x16" => "sa_",					# "さ"
	"0x17" => "za_",					# "ざ"
	"0x18" => "si_",					# "し"
	"0x19" => "zi_",					# "じ"
	"0x1a" => "su_",					# "す"
	"0x1b" => "zu_",					# "ず"
	"0x1c" => "se_",					# "せ"
	"0x1d" => "ze_",					# "ぜ"
	"0x1e" => "so_",					# "そ"
	"0x1f" => "zo_",					# "ぞ"
	"0x20" => "ta_",					# "た"
	"0x21" => "da_",					# "だ"
	"0x22" => "ti_",					# "ち"
	"0x23" => "di_",					# "ぢ"
	"0x24" => "ttu_",					# "っ"
	"0x25" => "tu_",					# "つ"
	"0x26" => "du_",					# "づ"
	"0x27" => "te_",					# "て"
	"0x28" => "de_",					# "で"
	"0x29" => "to_",					# "と"
	"0x2a" => "do_",					# "ど"
	"0x2b" => "na_",					# "な"
	"0x2c" => "ni_",					# "に"
	"0x2d" => "nu_",					# "ぬ"
	"0x2e" => "ne_",					# "ね"
	"0x2f" => "no_",					# "の"
	"0x30" => "ha_",					# "は"
	"0x31" => "ba_",					# "ば"
	"0x32" => "pa_",					# "ぱ"
	"0x33" => "hi_",					# "ひ"
	"0x34" => "bi_",					# "び"
	"0x35" => "pi_",					# "ぴ"
	"0x36" => "hu_",					# "ふ"
	"0x37" => "bu_",					# "ぶ"
	"0x38" => "pu_",					# "ぷ"
	"0x39" => "he_",					# "へ"
	"0x3a" => "be_",					# "べ"
	"0x3b" => "pe_",					# "ぺ"
	"0x3c" => "ho_",					# "ほ"
	"0x3d" => "bo_",					# "ぼ"
	"0x3e" => "po_",					# "ぽ"
	"0x3f" => "ma_",					# "ま"
	"0x40" => "mi_",					# "み"
	"0x41" => "mu_",					# "む"
	"0x42" => "me_",					# "め"
	"0x43" => "mo_",					# "も"
	"0x44" => "yya_",					# "ゃ"
	"0x45" => "ya_",					# "や"
	"0x46" => "yyu_",					# "ゅ"
	"0x47" => "yu_",					# "ゆ"
	"0x48" => "yyo_",					# "ょ"
	"0x49" => "yo_",					# "よ"
	"0x4a" => "ra_",					# "ら"
	"0x4b" => "ri_",					# "り"
	"0x4c" => "ru_",					# "る"
	"0x4d" => "re_",					# "れ"
	"0x4e" => "ro_",					# "ろ"
	"0x4f" => "wa_",					# "わ"
	"0x50" => "wo_",					# "を"
	"0x51" => "n_",						# "ん"
	"0x52" => "AA_",					# "ァ"
	"0x53" => "A_",						# "ア"
	"0x54" => "II_",					# "ィ"
	"0x55" => "I_",						# "イ"
	"0x56" => "UU_",					# "ゥ"
	"0x57" => "U_",						# "ウ"
	"0x58" => "EE_",					# "ェ"
	"0x59" => "E_",						# "エ"
	"0x5a" => "OO_",					# "ォ"
	"0x5b" => "O_",						# "オ"
	"0x5c" => "KA_",					# "カ"
	"0x5d" => "GA_",					# "ガ"
	"0x5e" => "KI_",					# "キ"
	"0x5f" => "GI_",					# "ギ"
	"0x60" => "KU_",					# "ク"
	"0x61" => "GU_",					# "グ"
	"0x62" => "KE_",					# "ケ"
	"0x63" => "GE_",					# "ゲ"
	"0x64" => "KO_",					# "コ"
	"0x65" => "GO_",					# "ゴ"
	"0x66" => "SA_",					# "サ"
	"0x67" => "ZA_",					# "ザ"
	"0x68" => "SI_",					# "シ"
	"0x69" => "ZI_",					# "ジ"
	"0x6a" => "SU_",					# "ス"
	"0x6b" => "ZU_",					# "ズ"
	"0x6c" => "SE_",					# "セ"
	"0x6d" => "ZE_",					# "ゼ"
	"0x6e" => "SO_",					# "ソ"
	"0x6f" => "ZO_",					# "ゾ"
	"0x70" => "TA_",					# "タ"
	"0x71" => "DA_",					# "ダ"
	"0x72" => "TI_",					# "チ"
	"0x73" => "DI_",					# "ヂ"
	"0x74" => "TTU_",					# "ッ"
	"0x75" => "TU_",					# "ツ"
	"0x76" => "DU_",					# "ヅ"
	"0x77" => "TE_",					# "テ"
	"0x78" => "DE_",					# "デ"
	"0x79" => "TO_",					# "ト"
	"0x7a" => "DO_",					# "ド"
	"0x7b" => "NA_",					# "ナ"
	"0x7c" => "NI_",					# "ニ"
	"0x7d" => "NU_",					# "ヌ"
	"0x7e" => "NE_",					# "ネ"
	"0x7f" => "NO_",					# "ノ"
	"0x80" => "HA_",					# "ハ"
	"0x81" => "BA_",					# "バ"
	"0x82" => "PA_",					# "パ"
	"0x83" => "HI_",					# "ヒ"
	"0x84" => "BI_",					# "ビ"
	"0x85" => "PI_",					# "ピ"
	"0x86" => "HU_",					# "フ"
	"0x87" => "BU_",					# "ブ"
	"0x88" => "PU_",					# "プ"
	"0x89" => "HE_",					# "ヘ"
	"0x8a" => "BE_",					# "ベ"
	"0x8b" => "PE_",					# "ペ"
	"0x8c" => "HO_",					# "ホ"
	"0x8d" => "BO_",					# "ボ"
	"0x8e" => "PO_",					# "ポ"
	"0x8f" => "MA_",					# "マ"
	"0x90" => "MI_",					# "ミ"
	"0x91" => "MU_",					# "ム"
	"0x92" => "ME_",					# "メ"
	"0x93" => "MO_",					# "モ"
	"0x94" => "YYA_",					# "ャ"
	"0x95" => "YA_",					# "ヤ"
	"0x96" => "YYU_",					# "ュ"
	"0x97" => "YU_",					# "ユ"
	"0x98" => "YYO_",					# "ョ"
	"0x99" => "YO_",					# "ヨ"
	"0x9a" => "RA_",					# "ラ"
	"0x9b" => "RI_",					# "リ"
	"0x9c" => "RU_",					# "ル"
	"0x9d" => "RE_",					# "レ"
	"0x9e" => "RO_",					# "ロ"
	"0x9f" => "WA_",					# "ワ"
	"0xa0" => "WO_",					# "ヲ"
	"0xa1" => "N_",						# "ン"
	"0xa2" => "n0_",					# "０"
	"0xa3" => "n1_",					# "１"
	"0xa4" => "n2_",					# "２"
	"0xa5" => "n3_",					# "３"
	"0xa6" => "n4_",					# "４"
	"0xa7" => "n5_",					# "５"
	"0xa8" => "n6_",					# "６"
	"0xa9" => "n7_",					# "７"
	"0xaa" => "n8_",					# "８"
	"0xab" => "n9_",					# "９"
	"0xac" => "A__",					# "Ａ"
	"0xad" => "B__",					# "Ｂ"
	"0xae" => "C__",					# "Ｃ"
	"0xaf" => "D__",					# "Ｄ"
	"0xb0" => "E__",					# "Ｅ"
	"0xb1" => "F__",					# "Ｆ"
	"0xb2" => "G__",					# "Ｇ"
	"0xb3" => "H__",					# "Ｈ"
	"0xb4" => "I__",					# "Ｉ"
	"0xb5" => "J__",					# "Ｊ"
	"0xb6" => "K__",					# "Ｋ"
	"0xb7" => "L__",					# "Ｌ"
	"0xb8" => "M__",					# "Ｍ"
	"0xb9" => "N__",					# "Ｎ"
	"0xba" => "O__",					# "Ｏ"
	"0xbb" => "P__",					# "Ｐ"
	"0xbc" => "Q__",					# "Ｑ"
	"0xbd" => "R__",					# "Ｒ"
	"0xbe" => "S__",					# "Ｓ"
	"0xbf" => "T__",					# "Ｔ"
	"0xc0" => "U__",					# "Ｕ"
	"0xc1" => "V__",					# "Ｖ"
	"0xc2" => "W__",					# "Ｗ"
	"0xc3" => "X__",					# "Ｘ"
	"0xc4" => "Y__",					# "Ｙ"
	"0xc5" => "Z__",					# "Ｚ"
	"0xc6" => "a__",					# "ａ"
	"0xc7" => "b__",					# "ｂ"
	"0xc8" => "c__",					# "ｃ"
	"0xc9" => "d__",					# "ｄ"
	"0xca" => "e__",					# "ｅ"
	"0xcb" => "f__",					# "ｆ"
	"0xcc" => "g__",					# "ｇ"
	"0xcd" => "h__",					# "ｈ"
	"0xce" => "i__",					# "ｉ"
	"0xcf" => "j__",					# "ｊ"
	"0xd0" => "k__",					# "ｋ"
	"0xd1" => "l__",					# "ｌ"
	"0xd2" => "m__",					# "ｍ"
	"0xd3" => "n__",					# "ｎ"
	"0xd4" => "o__",					# "ｏ"
	"0xd5" => "p__",					# "ｐ"
	"0xd6" => "q__",					# "ｑ"
	"0xd7" => "r__",					# "ｒ"
	"0xd8" => "s__",					# "ｓ"
	"0xd9" => "t__",					# "ｔ"
	"0xda" => "u__",					# "ｕ"
	"0xdb" => "v__",					# "ｖ"
	"0xdc" => "w__",					# "ｗ"
	"0xdd" => "x__",					# "ｘ"
	"0xde" => "y__",					# "ｙ"
	"0xdf" => "z__",					# "ｚ"
	"0xe1" => "gyoe_",					# "！"
	"0xe2" => "hate_",					# "？"
	"0xe3" => "ten_",					# "、"
	"0xe4" => "kten_",					# "。"
	"0xe5" => "tenten_",				# "…"
	"0xe6" => "nakag_",					# "・"
	"0xe7" => "sura_",					# "／"
	"0xe8" => "kako_",					# "「"
	"0xe9" => "kakot_",					# "」"
	"0xea" => "kako2_",					# "『"
	"0xeb" => "kakot2_",				# "』"
	"0xec" => "MaruKako__",				# "（"
	"0xed" => "MaruKakot__",			# "）"
	"0xee" => "osu_",					# "♂"
	"0xef" => "mesu_",					# "♀"
	"0xf0" => "Plus__",					# "＋"
	"0xf1" => "bou_",					# "ー"
	"0xf2" => "times_",					# "×"
	"0xf3" => "divide_",				# "÷"
	"0xf4" => "equal_",					# "＝"
	"0xf5" => "wave_",					# 波線
	"0xf6" => "colon_",					# "："
	"0xf7" => "semicolon_",				# "；"
	"0xf8" => "period_",				# "．"
	"0xf9" => "comma_",					# "，"
	"0xfa" => "spade_",					# トランプのスペード
	"0xfb" => "club_",					# トランプのクラブ
	"0xfc" => "heart_",					# トランプのハート
	"0xfd" => "diamond_",				# トランプのダイヤ
	"0xfe" => "star_",					# 星形
	"0xff" => "double_circle_",			# "◎"
	"0x100" => "circle_",				# "○"
	"0x101" => "square_",				# "□"
	"0x102" => "triangle_",				# "△"
	"0x103" => "lozenge__",				# "◇"
	"0x104" => "atmark_",				# "＠"
	"0x105" => "note_",					# "♪"
	"0x106" => "percent_",				# "％"
	"0x107" => "sun_",					# 晴れマーク
	"0x108" => "cloud_",				# くもりマーク
	"0x109" => "rain_",					# 雨マーク
	"0x10a" => "snow_",					# 雪マーク
	"0x10b" => "org_face_normal_",		# 顔マーク：すまし
	"0x10c" => "org_face_smile_",		# 顔マーク：えがお
	"0x10d" => "org_face_cry_",			# 顔マーク：泣き
	"0x10e" => "org_face_angry_",		# 顔マーク：怒り
	"0x10f" => "org_upper_",			# 上カーブやじるし
	"0x110" => "org_downer_",			# 下カーブやじるし
	"0x111" => "org_sleep_",			# 熟睡マーク
	"0x112" => "yen_",					# "円"
	"0x113" => "pocket_item",			# ポケットアイコン：どうぐ
	"0x114" => "pocket_keyitem",		# ポケットアイコン：だいじなもの
	"0x115" => "pocket_wazamachine",	# ポケットアイコン：わざマシン
	"0x116" => "pocket_seal",			# ポケットアイコン：シール
	"0x117" => "pocket_medicine",		# ポケットアイコン：くすり
	"0x118" => "pocket_nut",			# ポケットアイコン：きのみ
	"0x119" => "pocket_ball",			# ポケットアイコン：モンスターボール
	"0x11a" => "pocket_battle",			# ポケットアイコン：戦闘用
	"0x11b" => "ArrowL__",				# "←"
	"0x11c" => "ArrowU__",				# "↑"
	"0x11d" => "ArrowD__",				# "↓"
	"0x11e" => "ArrowR__",				# "→"
	"0x11f" => "cursor_",				# カーソル
	"0x120" => "anpersand_",			# &
	"0x121" => "h_n0_",					# "0"
	"0x122" => "h_n1_",					# "1"
	"0x123" => "h_n2_",					# "2"
	"0x124" => "h_n3_",					# "3"
	"0x125" => "h_n4_",					# "4"
	"0x126" => "h_n5_",					# "5"
	"0x127" => "h_n6_",					# "6"
	"0x128" => "h_n7_",					# "7"
	"0x129" => "h_n8_",					# "8"
	"0x12a" => "h_n9_",					# "9"
	"0x12b" => "h_A__",					# "A"
	"0x12c" => "h_B__",					# "B"
	"0x12d" => "h_C__",					# "C"
	"0x12e" => "h_D__",					# "D"
	"0x12f" => "h_E__",					# "E"
	"0x130" => "h_F__",					# "F"
	"0x131" => "h_G__",					# "G"
	"0x132" => "h_H__",					# "H"
	"0x133" => "h_I__",					# "I"
	"0x134" => "h_J__",					# "J"
	"0x135" => "h_K__",					# "K"
	"0x136" => "h_L__",					# "L"
	"0x137" => "h_M__",					# "M"
	"0x138" => "h_N__",					# "N"
	"0x139" => "h_O__",					# "O"
	"0x13a" => "h_P__",					# "P"
	"0x13b" => "h_Q__",					# "Q"
	"0x13c" => "h_R__",					# "R"
	"0x13d" => "h_S__",					# "S"
	"0x13e" => "h_T__",					# "T"
	"0x13f" => "h_U__",					# "U"
	"0x140" => "h_V__",					# "V"
	"0x141" => "h_W__",					# "W"
	"0x142" => "h_X__",					# "X"
	"0x143" => "h_Y__",					# "Y"
	"0x144" => "h_Z__",					# "Z"
	"0x145" => "h_a__",					# "a"
	"0x146" => "h_b__",					# "b"
	"0x147" => "h_c__",					# "c"
	"0x148" => "h_d__",					# "d"
	"0x149" => "h_e__",					# "e"
	"0x14a" => "h_f__",					# "f"
	"0x14b" => "h_g__",					# "g"
	"0x14c" => "h_h__",					# "h"
	"0x14d" => "h_i__",					# "i"
	"0x14e" => "h_j__",					# "j"
	"0x14f" => "h_k__",					# "k"
	"0x150" => "h_l__",					# "l"
	"0x151" => "h_m__",					# "m"
	"0x152" => "h_n__",					# "n"
	"0x153" => "h_o__",					# "o"
	"0x154" => "h_p__",					# "p"
	"0x155" => "h_q__",					# "q"
	"0x156" => "h_r__",					# "r"
	"0x157" => "h_s__",					# "s"
	"0x158" => "h_t__",					# "t"
	"0x159" => "h_u__",					# "u"
	"0x15a" => "h_v__",					# "v"
	"0x15b" => "h_w__",					# "w"
	"0x15c" => "h_x__",					# "x"
	"0x15d" => "h_y__",					# "y"
	"0x15e" => "h_z__",					# "z"
	"0x15f" => "Agrave_",				# Aアクサングラーブ	
	"0x160" => "Aacute_",				# Aアクサンテギュ	
	"0x161" => "Acirc_",				# Aサーカムフレックス	
	"0x162" => "Atilde_",				# Aティルド	
	"0x163" => "Auml_",					# Aウムラウト	
	"0x164" => "Aring_",				# Aリング	
	"0x165" => "AElig_",				# AE合字	
	"0x166" => "Ccedil_",				# Cセディラ	
	"0x167" => "Egrave_",				# Eアクサングラーブ	
	"0x168" => "Eacute_",				# Eアクサンテギュ	
	"0x169" => "Ecirc_",				# Eサーカムフレックス	
	"0x16a" => "Euml_",					# Eウムラウト	
	"0x16b" => "Igrave_",				# Iアクサングラーブ	
	"0x16c" => "Iacute_",				# Iアクサンテギュ	
	"0x16d" => "Icirc_",				# Iサーカムフレックス	
	"0x16e" => "Iuml_",					# Iウムラウト	
	"0x16f" => "ETH_",					# 音声記号eth	
	"0x170" => "Ntilde_",				# Nティルド	
	"0x171" => "Ograve_",				# Oアクサングラーブ	
	"0x172" => "Oacute_",				# Oアクサンテギュ	
	"0x173" => "Ocirc_",				# Oサーカムフレックス	
	"0x174" => "Otilde_",				# Oティルド	
	"0x175" => "Ouml_",					# Oウムラウト	
	"0x176" => "h_times_",				# "["
	"0x177" => "Oslash_",				# Oスラッシュ	
	"0x178" => "Ugrave_",				# Uアクサングラーブ	
	"0x179" => "Uacute_",				# Uアクサンテギュ	
	"0x17a" => "Ucirc_",				# Uサーカムフレックス	
	"0x17b" => "Uuml_",					# Uウムラウト	
	"0x17c" => "Yacute_",				# Yアクサンテギュ	
	"0x17d" => "THORN_",				# 音声記号th	
	"0x17e" => "szlig_",				# sz合字	
	"0x17f" => "agrave_",				# aアクサングラーブ	
	"0x180" => "aacute_",				# aアクサンテギュ	
	"0x181" => "acirc_",				# aサーカムフレックス	
	"0x182" => "atiled_",				# aティルド	
	"0x183" => "auml_",					# aウムラウト	
	"0x184" => "aring_",				# aリング	
	"0x185" => "aelig_",				# ae合字	
	"0x186" => "ccedil_",				# cセディラ	
	"0x187" => "egrave_",				# eアクサングラーブ	
	"0x188" => "eacute_",				# eアクサンテギュ	
	"0x189" => "ecirc_",				# eサーカムフレックス	
	"0x18a" => "euml_",					# eウムラウト	
	"0x18b" => "igrave_",				# iアクサングラーブ	
	"0x18c" => "iacute_",				# iアクサンテギュ	
	"0x18d" => "icirc_",				# iサーカムフレックス	
	"0x18e" => "iuml_",					# iウムラウト	
	"0x18f" => "eth_",					# eth合字	
	"0x190" => "ntiled_",				# nティルド	
	"0x191" => "ograve_",				# oアクサングラーブ	
	"0x192" => "oacute_",				# oアクサンテギュ	
	"0x193" => "ocirc_",				# oサーカムフレックス	
	"0x194" => "otilde_",				# oティルド	
	"0x195" => "ouml_",					# oウムラウト	
	"0x196" => "h_divide_",				# "]"
	"0x197" => "oslash_",				# oスラッシュ	
	"0x198" => "ugrave_",				# uアクサングラーブ	
	"0x199" => "uacute_",				# uアクサンテギュ	
	"0x19a" => "ucirc_",				# uサーカムフレックス	
	"0x19b" => "uuml_",					# uウムラウト	
	"0x19c" => "yacute_",				# yアクサンテギュ	
	"0x19d" => "thorn_",				# 音声記号th	
	"0x19e" => "yuml_",					# yウムラウト	
	"0x19f" => "OElig_",				# OE合字	
	"0x1a0" => "oelig_",				# oe合字	
	"0x1a1" => "Scedil_",				# Sセディラ	
	"0x1a2" => "scedil_",				# sセディラ	
	"0x1a3" => "sup_a_",				# "?"
	"0x1a4" => "sup_o_",				# "?"
	"0x1a5" => "sup_er_",				# "?"
	"0x1a6" => "sup_re_",				# "?"
	"0x1a7" => "sup_r_",				# "?"
	"0x1a8" => "pokedoru_",				# ポケドル
	"0x1a9" => "rgyoe_",				# 反転！
	"0x1aa" => "rhate_",				# 反転？
	"0x1ab" => "h_gyoe_",				# "!"
	"0x1ac" => "h_hate_",				# "?"
	"0x1ad" => "h_comma_",				# ","
	"0x1ae" => "h_period_",				# "."
	"0x1af" => "h_tenten_",				# "|"
	"0x1b0" => "h_nakag_",				# "･"
	"0x1b1" => "h_sura_",				# "/"
	"0x1b2" => "us_quote1_",			# 英語全角引用符（開き）／独語引用符（閉じ）
	"0x1b3" => "us_h_quote1_",			# 英語半角引用符／アポストロフィー
	"0x1b4" => "us_quote2_",			# 英語全角２重引用符（開き）／独語２重引用符（閉じ）
	"0x1b5" => "us_quote2d_",			# 英語全角２重引用符（閉じ）
	"0x1b6" => "ger_quote2_",			# 独語２重引用符（開き）
	"0x1b7" => "fre_quote_",			# 仏語引用符（開き）
	"0x1b8" => "fre_quoted_",			# 仏語引用符（閉じ）
	"0x1b9" => "h_MaruKako__",			# "("
	"0x1ba" => "h_MaruKakot__",			# ")"
	"0x1bb" => "h_osu_",				# 海外版♂記号
	"0x1bc" => "h_mesu_",				# 海外版♀記号
	"0x1bd" => "h_plus_",				# "+"
	"0x1be" => "h_bou_",				# "-"
	"0x1bf" => "h_asterisk_",			# "*"
	"0x1c0" => "h_sharp_",				# "#"
	"0x1c1" => "h_equal_",				# "="
	"0x1c2" => "h_ampersand_",			# "&"
	"0x1c3" => "h_tilda_",				# "~"
	"0x1c4" => "h_colon_",				# ":"
	"0x1c5" => "h_semicolon_",			# ";"
	"0x1c6" => "h_spade_",				# "?"
	"0x1c7" => "h_club_",				# "?"
	"0x1c8" => "h_heart_",				# "?"
	"0x1c9" => "h_diamond_",			# "?"
	"0x1ca" => "h_star_",				# "?"
	"0x1cb" => "h_double_circle_",		# "?"
	"0x1cc" => "h_circle_",				# "?"
	"0x1cd" => "h_square_",				# "?"
	"0x1ce" => "h_triangle_",			# "?"
	"0x1cf" => "h_lozenge__",			# "?"
	"0x1d0" => "h_atmark_",				# "@"
	"0x1d1" => "h_note_",				# "?"
	"0x1d2" => "h_percent_",			# "%"
	"0x1d3" => "h_sun_",				# "?"
	"0x1d4" => "h_cloud_",				# "?"
	"0x1d5" => "h_rain_",				# "?"
	"0x1d6" => "h_snow_",				# "?"
	"0x1d7" => "h_org_face_normal_",	# "?"
	"0x1d8" => "h_org_face_smile_",		# "?"
	"0x1d9" => "h_org_face_cry_",		# "?"
	"0x1da" => "h_org_face_angry_",		# "?"
	"0x1db" => "h_org_upper_",			# "?"
	"0x1dc" => "h_org_downer_",			# "?"
	"0x1dd" => "h_org_sleep_",			# "?"
	"0x1de" => "h_spc_",				# " "
	"0x1df" => "sup_e_",				# "?"
	"0x1e0" => "pkmn_pk_",				# "PK"
	"0x1e1" => "pkmn_mn_",				# "MN"
	"0x1e2" => "spcnum_",				# "?"
	"0x1fe" => "charcode_reserve1_",	# "■"
	"0x1ff" => "charcode_reserve2_",	# "▼"
	"0x200" => "charcode_reserve3_"		# "▽"
);
