﻿use strict;
use utf8;
use Win32::OLE qw(in with CP_UTF8);
use Win32::OLE::Const 'Microsoft Excel';
use Cwd;

$Win32::OLE::CP = CP_UTF8;

#***********************************************************
# パッケージxls
#***********************************************************
package xls;

my $excel;

#===========================================================
# パッケージ初期化。
#===========================================================
{
	$excel = Win32::OLE->new('Excel.Application');
	if (!defined($excel)) {
		die "excelが開始できません。\n";
	}
}

#===========================================================
# パッケージ終了。
#===========================================================
END {
	$excel->Quit();
	$excel = undef;
}

#===========================================================
# オブジェクト生成。
#===========================================================
sub new {
	my ($class, $fname) = @_;

	bless {
		fname => $fname,
		data => []
	}, $class;
}

#===========================================================
# データ取得。
#===========================================================
sub getData {
	my ($self, $sheet_no, $end_col) = @_;
	my ($book, $sheet, $range, $data, $path);

	if (!defined($sheet_no)) {
		$sheet_no = 1;
	}
	if (defined($self->{data}[$sheet_no])) {
		return $self->{data}[$sheet_no];
	}

	$path = ::getcwd();
	$book = $excel->Workbooks->Open("$path/$self->{fname}");
	if (!defined($book)) {
		print "$path/$self->{fname}\n";
		die "bookが開けません。\n";
	}
	$sheet = $book->Worksheets($sheet_no);
	if (!defined($sheet)) {
		die "sheetが取れません。\n";
	}

	$range = $sheet->Range("A65536")->End(::xlUp);
	$data = $sheet->Range("A2:$end_col$range->{Row}")->{Value};
	for my $i (@{$data}) {
		for my $j (@{$i}) {
			$j = substr($j . 'あ', 0, length($j));
		}
	}

	$book->Close();

	$self->{data}[$sheet_no] = $data;

	return $data;
}

1;
