﻿use strict;
use utf8;
use File::Find;
use Cwd;

binmode STDOUT, "encoding(shift-jis)";
binmode STDERR, "encoding(shift-jis)";

my @INFO = (
	{ lang => "韓国", mark => "kor",  gmm_mark => "KOR" }
);

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my ($add, $src, $dst, $cmd, $list);

	if (@ARGV != 4) {
		die "add src dst MessageEditor.exeです。\n";
	}
	($add, $src, $dst, $cmd) = @ARGV;

	# addのgmmファイルを保存し直し。
	resave_gmm($cmd, $add);

	# エクセルのための前処理。
	$list = get_file_list($add, "xls");
	for my $i (@{$list}) {
		my ($s, $d);

		$s = $d = $i;
		$s =~ s/^(.*[\\\/])_?([^\\\/]+)$/$1$2/;
		$d =~ s/^(.*[\\\/])_?([^\\\/]+)$/$1_$2/;
		rename $s, $d;
	}

	# マージ処理。
	for my $i (@INFO) {
		my ($cmd);

		print "$i->{lang}語のgmmをマージ...";
		$cmd = "gmm_merge.pl $add $src $dst MSG_$i->{gmm_mark} > $i->{mark}_gmm.txt";
		`$cmd`;
		print "結果を$i->{mark}_gmm.txtへ。\n";

		print "$i->{lang}語のxlsをマージ...";
		`xlsdiff.pl $add $src $dst > $i->{mark}_xls.txt`;
		print "結果を$i->{mark}_xls.txtへ。\n";
	}

	# エクセルのための後処理。
	for my $i (@{$list}) {
		my ($s, $d);

		$s = $d = $i;
		$s =~ s/^(.*[\\\/])_?([^\\\/]+)$/$1_$2/;
		$d =~ s/^(.*[\\\/])_?([^\\\/]+)$/$1$2/;
		rename $s, $d;
	}

	# dstのgmmファイルを保存し直し。
	resave_gmm($cmd, $dst);
}

#===========================================================
# gmmファイルをMessageEditorで保存し直す。
#===========================================================
sub resave_gmm {
	my ($cmd, $dir) = @_;
	my ($list);

	print "gmmファイルをMessageEditorで保存し直しています...";
	$list = get_file_list($dir, "gmm");
	for my $i (@{$list}) {
		my ($path);

		$path = ::getcwd();
		`$cmd -nw -s $path/$i $path/$i`;
	}
	print "終了\n";
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir, $ext) = @_;
	my ($sub, @list, $reg);

	$reg = qr/\.$ext$/;
	$sub = sub {
		if ($File::Find::name =~ /$reg/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, $dir);
	return \@list;
}
