#####################################################################
# gmm_checker.pl
# フォーマットが正しいかチェックします。
#####################################################################
require "util.pm";
require "log.pm";
use strict;
use gmm;

&main();

sub main()
{
	# 引数
	my ( $new_dir, $old_dir ) = &check_arg();

	# ディレクトリ以下のファイルのリストを取得します。
	my @file_list = ();
	util::getFileList(\@file_list,$new_dir);
	
	# 各ファイルに対して処理を行う
	foreach my $new_file (@file_list)
	{
		# ファイルが gmm でない場合は次へ
		next unless ($new_file =~ /^\Q$new_dir\E(.+\.gmm)$/);
		
		log::setFileName($1);
		my $old_file = $old_dir.$1;
		
		my $new_gmm = gmm->new($new_file);
		my $old_gmm = gmm->new($old_file);
	
		gmm::diff($new_gmm,$old_gmm);
	}
}
#####################################################################
# 引数のチェック
#####################################################################
sub check_arg()
{
	if (@ARGV == 2)
	{
		# 絶対パスに変換
		return
		(
			$ARGV[0].'/',
			$ARGV[1].'/'
		);
	}
	else
	{
		&help();
		exit;
	}
}
#-------------------------------------------------------------------
# ヘルプ表示
#-------------------------------------------------------------------
sub help()
{
	print "gmm_checker.pl <new dir> <old dir> \n";

}
