#####################################################################
# gmm_format.pl
# 日本語版gmmを海外用のフォーマットに変更します。
#####################################################################
use strict;
use Cwd;

require 'pm/util/file.pm';
require 'pm/util/log.pm';
require 'pm/gmm/gmm.pm';

&main();

# main
#####################################################################
sub main()
{
	# 引数
	my ($fmt_file,$org_dir,$out_dir) = check_arg();

	# ディレクトリ以下のファイルのリストを取得します。
	my @file_list = ();
	util::file::getFileList(\@file_list,$org_dir);

	# フォーマットgmm ファイルの読み込み
	my $fmt_gmm = gmm->new($fmt_file);
	
	# 各ファイルに対して処理を行う
	foreach my $org_file (@file_list)
	{
		# ファイルが gmm でない場合は次へ
		next unless ($org_file =~ /^\Q$org_dir\E(.+\.gmm)$/);
		my $file_name = $1;
		util::log::setFileName($file_name);# ログ用
		my $out_file = $out_dir.$file_name;

		my $gmm = gmm->new($org_file);# gmm を読込

#		$gmm->set($fmt_gmm,'head');
#		$gmm->set($fmt_gmm,'color');
		$gmm->set($fmt_gmm,'tag-table');
#		$gmm->set($fmt_gmm,'columns');
#		$gmm->set($fmt_gmm,'dialog');
#		$gmm->set($fmt_gmm,'output');
#		$gmm->set($fmt_gmm,'lock');
	
		$gmm->print($out_file);	      # gmm の保存	
	}
}
#-------------------------------------------------------------------
# 引数のチェック
#-------------------------------------------------------------------
sub check_arg()
{
	if (@ARGV == 3)
	{
		my $cwd = Cwd::getcwd();
		return
		(
			$ARGV[0],
			$cwd .'/'.$ARGV[1].'/',
			$cwd .'/'.$ARGV[2].'/'
		);
	}
	else
	{
		&help();
		exit();
	}
}
#-------------------------------------------------------------------
# ヘルプ表示
#-------------------------------------------------------------------
sub help()
{
	print "gmm_format.pl <gmm> <org dir> <out dir> \n";

}
#-------------------------------------------------------------------
