﻿#####################################################################
# gmm_set_agb_msg.pl
# エクセルファイルのAGB版の翻訳をgmmにはりつけます。
#####################################################################
use strict;
use utf8;

require 'pm/util/log.pm';
require 'pm/util/file.pm';
require 'pm/xls/xls.pm';
require 'pm/gmm/gmm.pm';
require 'pm/gmm/row.pm';

&main();

# main
#####################################################################
sub main()
{
	# 引数
	my ($org_dir,$out_dir,$xls_file) = check_arg();

	# Pokemon -> POKEMON 変換テーブルの取得
	my $hash = getHash($xls_file);

	# ディレクトリ以下のファイルのリストを取得します。
	my @file_list = ();
	util::file::getFileList( \@file_list,$org_dir );

	# 各ファイルに対して処理を行う
	foreach my $org_file (@file_list)
	{
		# ファイルが gmm でない場合は次へ
		next unless ($org_file =~ /^\Q$org_dir\E(.+\.gmm)$/);
		my $file_name = $1;
		util::log::setFileName($file_name);# ログ用

		# 出力ファイル名の設定
		my $out_file = $out_dir.$file_name;
		
		# ウインドウ情報をに設定する。
		my $gmm = gmm->new($org_file);
		setMsg($gmm,$hash);

		# 変換した gmm をファイルに保存
		$gmm->print($out_file);
	}
}

####################################################################
# エクセルからAGBのメッセージを取得する。
####################################################################
sub getHash()
{
	my ($xls_file) = @_; 

	my %hash;

	# エクセルからのデータの読み込み
	my $xls = xls->new($xls_file);
	
	my $data_list = $xls->getData('Pokedex');
	my $title = shift(@$data_list);

	shift(@$data_list);	# 2行目も必要ないのでとばします。
		
	my $idx_Pokemon = getIdx($title,'Name (English)');
	my $idx_POKEMON = getIdx($title,'capital');

	foreach my $data (@$data_list)
	{
		my $Pokemon	= getData($data,$idx_Pokemon);
		my $POKEMON = getData($data,$idx_POKEMON);					
		$hash{$Pokemon} = $POKEMON;
	}
	return \%hash;
}

# タイトル行から列のインデックスを取得する。
# 取得できなかった場合は-1を返す。
sub getIdx()
{
	my ($title,$val) = @_;

	my $i = 0;
	foreach my $data (@$title)
	{
		return $i if ($data eq $val);
		$i++;
	}

	return -1;
}
# 取得できなかった場合は""を返す。
sub getData()
{
	my ($data,$idx) = @_;
	return '' if ($idx < 0);
	return $data->[$idx];
}
####################################################################
# ＡＧＢのメッセージを反映させる。
####################################################################
sub setMsg
{
	my ($gmm,$hash) = @_;

	while ( my ($id,$row) = each(%{$gmm->{'row'}}) )
	{
		util::log::setID($id);#ログ用

		my $before = $row->get('EnglishMessage');
		my $after = replacePokeName($before,$hash);

		if ($before ne $after)
		{
			# ログ出力
			$row->set('EnglishMessage',$after);
			util::log::msg($before, $after);	
		}
	}
}
#-------------------------------------------------------------------
# #XXXを適切な形に変換する。（#varを除く)
#-------------------------------------------------------------------
sub replacePokeName()
{
	my ($msg,$hash) = @_;

	while ( my ($key,$val) = each(%$hash) )
	{
		$msg =~ s/\b\Q$key\E\b/$val/ig;
	}

	return $msg;
}
#####################################################################
# 引数のチェック
#####################################################################
sub check_arg()
{
	if (@ARGV == 3)
	{
		return
		(
			shift(@ARGV).'/',
			shift(@ARGV).'/',
			shift(@ARGV)	
		);
	}
	else
	{
		&help();
		exit;
	}
}
#-------------------------------------------------------------------
# ヘルプ表示
#-------------------------------------------------------------------
sub help()
{
	print STDERR "gmm_poke_name_convert.pl <base dir> <out dir> <xls> \n";
}
