
package dom::util;

use strict;
use XML::DOM;

use open ":utf8";

#-------------------------------------------------------------------
# xmlを出力する。
#-------------------------------------------------------------------
sub print
{
	my ($doc,$file) = @_;

	open(OUT,">$file") or die "error! can't open $file";
	$doc->printToFileHandle(\*OUT);
	close(OUT);
}
#-------------------------------------------------------------------
# 子ノードの中のテキストノードの値を取得します。
# テキストノードが存在しない場合は空文字を返します。
#-------------------------------------------------------------------
sub getText
{
	my ($parent) = @_;

	my @node_list = $parent->getChildNodes;
	foreach my $node (@node_list)
	{
		if ($node->getNodeType() == TEXT_NODE)
		{
			return $node->getData;
		}
	}
	return '';
}
#-------------------------------------------------------------------
# 子ノードの中のテキストノードの値をセットします。
#-------------------------------------------------------------------
sub setText
{
	my ($parent,$text) = @_;

	my @node_list = $parent->getChildNodes;
	foreach my $node (@node_list)
	{
		# テキストノードが存在する場合は値を上書き
		if ($node->getNodeType() == TEXT_NODE)
		{
			$node->setData($text);
			return;
		}
	}
	# テキストノードが存在しない場合はテキストノードを追加
	$parent->addText($text);
}
#-------------------------------------------------------------------
1;
