
package gmm::diff;

use strict;
use utf8;
use XML::DOM;

#-------------------------------------------------------------------
# 新しいファイルと古いファイルを比較して
# 変更が入っている項目を出力する。
#-------------------------------------------------------------------
sub diff
{
	my ($new_gmm,$old_gmm) = @_;

	diff_row( $new_gmm->{'row'},$old_gmm->{'row'} );
}
#-------------------------------------------------------------------
sub diff_row
{
	my ($new,$old) = @_;
	
	# 全てのID
	while ( my ($id,$new_data) = each %{$new} )
	{
		log::setMsgId($id);

		# 既存IDの場合
		if (exists($old->{$id}))
		{
			diff_row_id( $new_data,$old->{$id} );
		}
		# 新規IDの場合
		else
		{
			log::msg('new','Msg ID');
		}
	}

	# 削除されたIDのチェック
	foreach my $id ( keys(%{$old}) )
	{
		unless (exists($new->{$id}))
		{
			log::setMsgId($id);
			log::msg('delete','Msg ID');
		}
	}
}
#-------------------------------------------------------------------
sub diff_row_id
{
	my ($new_data,$old_data) = @_;
	
	while ( my ($key,$new_val) = each %{$new_data} )
	{
		# 既存データ項目の場合
		if (exists($old_data->{$key}))
		{
			my $old_val = $old_data->{$key};
			if ($new_val ne $old_val)
			{
				if ($new_val eq '')
				{	# 値が削除されていた場合
					log::msg('delete', $key, $old_val);
				}
				elsif ($old_val eq '')
				{	# 値が追加されていた場合
					log::msg('new', $key, $new_val);
				}
				else
				{	# 値に変更があった場合
					log::msg('update',$key,$new_val,$old_val);
				}
			}
		}
	}
}

1;
