
package gmm::format;

use strict;
use utf8;
use XML::DOM;

#-------------------------------------------------------------------
# フォーマットをセットする。
#-------------------------------------------------------------------
sub setFormat
{
	my ($this,$format) = @_;

	$this->set($format,'head');
	$this->set($format,'color');
	$this->set($format,'tag-table');
	$this->set($format,'columns');
	$this->set($format,'dialog');
	$this->set($format,'output');
	$this->set($format,'lock');
}
#-------------------------------------------------------------------
# 各メッセージを英語版用に変換
# ・'キャラ'を'キャラ指定'に変更
# ・バッグのポケット名タグを変更
#-------------------------------------------------------------------
sub jpn2usa
{
	my $ref = shift;

	foreach my $row (@{$ref->{rows}})
	{
		my @language_list = $row->getElementsByTagName('language');
		foreach my $language (@language_list)
		{
			next if ($language->getAttribute('name') ne $ref->{str}->{JPN});
			convertFont($language);
			convertTag($language);
		}
		convertKyara($row);		
	}
}
#-------------------------------------------------------------------
# tag を適切な形にコンバート
#-------------------------------------------------------------------
sub convertTag
{
	my $language = shift;

	my $text = getText($language);

	#テキストが空なら処理する必要なし
	next if ($text eq '');

	#タグを変更
	$text =~ s/\[1:1F:バッグのポケット名（アイコン）:(.+?)\]/'[1:3C:バッグのポケット名（アイコン）:'.$1.']'/eg;

	#変更を更新
	setText($language,$text);
}
#-------------------------------------------------------------------
# font を適切な形にコンバート
#-------------------------------------------------------------------
sub convertFont
{
	my $language = shift;
	my $dft_fnt_name = shift;

	my $font = $language->getAttribute('font');
	
	# フォントが設定されていない場合
	if ( (!defined($font)) or ($font eq '') )
	{
		# デフォルトフォントが設定されている場合
		if ($dft_fnt_name ne '')
		{
			$font = getFont($dft_fnt_name);
			$language->setAttribute('font',$font);
		}
	}
	# フォントが設定されている場合
	else
	{
		my $font_name = gmm_re::getFontName($font);
		$font = getFont($font_name);
		$language->setAttribute('font',$font);
	}
} 
#-------------------------------------------------------------------
# 'キャラ'を'キャラ指定'に変更
#-------------------------------------------------------------------
sub convertKyara
{
	my $row = shift;
	
	my @attribute_list = $row->getElementsByTagName('attribute');
	foreach my $attribute (@attribute_list)
	{
		my $name = $attribute->getAttribute('name');
		next if ($name ne 'キャラ');
		$attribute->setAttribute('name','キャラ指定');
	}
}
#-------------------------------------------------------------------
# デフォルトフォント名を取得する。
# 設定なしの場合は''を返す。
#-------------------------------------------------------------------
sub getDefaultFontName
{
	my ($this,$lang) = @_;

	my @language_list = $this->{'columns'}->getElementsByTagName('language');
	foreach my $language (@language_list)
	{
		# 指定された言語のenglish属性を取得して当該言語かチェック
		next if ($language->getAttribute('japanese') ne $lang);
		my $font = $language->getElementsByTagName('font')->item(0);
		my $default = $font->getAttribute('default');
		return '' unless (defined($default));	#デフォルト属性がない場合
		return '' if ($default eq '');			#デフォルトが空の場合
		return gmm_re::getFontName($default);
	}
	return '';
}
#-------------------------------------------------------------------
# フォント名からfontデータを取得する。
# font　=  フォントエントリ:フォント名
#-------------------------------------------------------------------
sub getFont
{
	my $font = shift;

	# 想定したフォントでない場合はエラー
	exists($FNT_TBL->{$font}) or print "error!$font\n";
	return ' '.$FNT_TBL->{$font}.':'.$font;	
}
1;
