
package gmm;

use strict;
use XML::DOM;
use utf8;

require 'pm/util/file.pm';
require 'pm/util/log.pm';
require 'pm/dom/util.pm';
require 'pm/gmm/row.pm';

my $parser = new XML::DOM::Parser;

####################################################################
# NEW
####################################################################
sub new
{
	my ($pkg,$gmm) = @_;

	my $member =
	{
		'doc'		=> undef,
		'version'	=> undef,
		'language'	=> undef,
	
		'head'		=> undef,
		'color'		=> undef,
		'tag-table'	=> undef,
		'columns'	=> undef,
		'dialog'	=> undef,
		'output'	=> undef,
		'lock'		=> undef,

		'row'		=> undef,
	};
	
	init_member( $gmm,$member );
	bless $member,$pkg;
}
#-------------------------------------------------------------------
# gmm を出力する。
#-------------------------------------------------------------------
sub print
{
	my ($this,$file) = @_;
	dom::util::print($this->{'doc'},$file);
}
#-------------------------------------------------------------------
# version をチェックする。
#-------------------------------------------------------------------
sub checkVersion
{
	my ($gmm1,$gmm2) = @_;
	
	if ($gmm1->{'version'} ne $gmm2->{'version'})
	{
		print "version error\n";
		print $gmm1->{'version'}."\n";
		print $gmm2->{'version'}."\n";
	}
}
#-------------------------------------------------------------------
# フォーマットをセットする。
#-------------------------------------------------------------------
sub set
{
	my ($this,$format,$tag) = @_;

	my $tmp = $format->{$tag}->cloneNode(1);
	$tmp->setOwnerDocument($this->{'doc'});
	my $parent = $this->{$tag}->getParentNode();
	$parent->replaceChild($tmp,$this->{$tag});
	$this->{$tag} = $parent->getElementsByTagName($tag)->item(0);
}
# 以下は内部関数
####################################################################
sub init_member
{
	my ($gmm,$member) = @_;

	my $doc			= $parser->parsefile($gmm);
	my $gmml		= $doc->getElementsByTagName('gmml',0)->item(0);
	my $body		= $gmml->getElementsByTagName('body',0)->item(0);
	
	# gmm
	$member->{'doc'}		= $doc;
	$member->{'version'}	= $gmml->getAttribute('version');
	$member->{'language'}	= $body->getAttribute('language');

	# tag		
	$member->{'head'}		= $gmml->getElementsByTagName('head',0)->item(0);
	$member->{'color'}		= $body->getElementsByTagName('color',0)->item(0);
	$member->{'tag-table'}	= $body->getElementsByTagName('tag-table',0)->item(0);
	$member->{'columns'}	= $body->getElementsByTagName('columns',0)->item(0);
	$member->{'dialog'}		= $body->getElementsByTagName('dialog',0)->item(0);
	$member->{'output'}		= $body->getElementsByTagName('output',0)->item(0);
	$member->{'lock'}		= $body->getElementsByTagName('lock',0)->item(0);

	# row
	$member->{'row'}		= get_member_row($body,$member->{'language'});
}
#-------------------------------------------------------------------
# row ノードをidをkeyにしたハッシュとして取得する 。
sub get_member_row
{
	my ($body,$language) = @_;

	my @row_list = $body->getElementsByTagName('row',0);

	my %res;
	foreach my $row (@row_list)
	{
		my $id = $row->getAttribute('id');
	
		# ID の重複確認
		if ( exists($res{$id}) )
		{
			util::log::setMsgId($id);
			util::log::msg('メッセージIDに重複があります。');
			next;
		}
		
		$res{$id} = gmm::row->new($row,$language);
	}

	return \%res;
}


1;
