
package gmm::merge;

use strict;

require 'pm/gmm/gmm.pm';
require 'pm/gmm/row.pm';
require 'pm/util/log.pm';

my $TBL=
{
	'WindowContext'		=> 1,
	'JapaneseMessage'	=> 1,
	'JapaneseComment'	=> 1,
	'EnglishMessage'	=> 1,	
	'EnglishComment'	=> 1,
	'FrenchMessage'		=> 1,
	'FrenchComment'		=> 1,
	'GermanMessage'		=> 1,	
	'GermanComment'		=> 1,
	'ItalianMessage'	=> 1,
	'ItalianComment'	=> 1,
	'SpanishMessage'	=> 1,	
	'SpanishComment'	=> 1,
	'KoreanMessage'		=> 1
};
####################################################################
# テキストをマージする。
####################################################################
sub text
{
	my ($key,$append,$base) = @_;

	# キーのチェック
	unless (defined($TBL->{$key}))
	{
		util::log::msg("merge:".$key."には対応しておりません");
	}

	my $append_text = $append->get($key);
	my $base_text = $base->get($key);

	# 更新なし
	return if ($append_text eq $base_text);

	# 更新あり
	$base->set($key,$append_text);

	# ログ
	{
		# 追加
		if ($base_text eq '')
		{
			util::log::msg('NEW',$key,$append_text);
		}
		# 削除
		elsif ($append_text eq '')
		{
			util::log::msg('DEL',$key,$base_text);
		}
		# 更新
		else
		{
			util::log::msg('UP',$key,$base_text,'->',$append_text);
		}
	}
}
#-------------------------------------------------------------------

1;
