
package gmm::row;

use strict;
use Switch;
use utf8;
use XML::DOM;

require 'pm/util/log.pm';
require 'pm/dom/util.pm';

#... 本当はcolumnsから自動生成したいところ
my $NAME2ID =
{
	'japanese'	=>
	{
		'日本語'					=> 'JapaneseMessage',
		'English'					=> 'EnglishMessage',
		'コメント（英語）'			=> 'EnglishComment',		
		'French'					=> 'FrenchMessage',
		'Comment(French)'			=> 'FrenchComment',		
		'German'					=> 'GermanMessage',
		'Comment(German)'			=> 'GermanComment',			
		'Italian'					=> 'ItalianMessage',
		'Comment(Italian)'			=> 'ItalianComment',			
		'Spanish'					=> 'SpanishMessage',
		'Comment(Spanish)'			=> 'SpanishComment',			
		'Korean'					=> 'KoreanMessage',
		'キャラ指定'				=> 'Character',
		'スクロール'				=> 'Scroll',
		'ウィンドウコンテキスト名'	=> 'WindowContext',
		'org_file'					=> 'OriginalFile'
	},
	'english'	=>
	{
		'Japanese'					=> 'JapaneseMessage',
		'English'					=> 'EnglishMessage',
		'Comment(English)'			=> 'EnglishComment',
		'French'					=> 'FrenchMessage',
		'Comment(French)'			=> 'FrenchComment',		
		'German'					=> 'GermanMessage',
		'Comment(German)'			=> 'GermanComment',			
		'Italian'					=> 'ItalianMessage',
		'Comment(Italian)'			=> 'ItalianComment',			
		'Spanish'					=> 'SpanishMessage',
		'Comment(Spanish)'			=> 'SpanishComment',
		'Korean'					=> 'KoreanMessage',
		'Character'					=> 'Character',
		'Scroll'					=> 'Scroll',
		'WindowContextName'			=> 'WindowContext',
		'org_file'					=> 'OriginalFile'		
	}
};

my $ID2NAME =
{
	'japanese'	=>
	{
		'JapaneseMessage'	=> '日本語',
		'EnglishMessage'	=> 'English',
		'EnglishComment'	=> 'コメント（英語）',
		'FrenchMessage'		=> 'French',
		'FrenchComment'		=> 'Comment(French)',
		'GermanMessage'		=> 'German',
		'GermanComment'		=> 'Comment(German)',
		'ItalianMessage'	=> 'Italian',
		'ItalianComment'	=> 'Comment(Italian)',
		'SpanishMessage'	=> 'Spanish',
		'SpanishComment'	=> 'Comment(Spanish)',
		'KoreanMessage'		=> 'Korean',
		'Character'			=> 'キャラ指定',
		'Scroll'			=> 'スクロール',
		'WindowContext'		=> 'ウィンドウコンテキスト名',
		'OriginalFile'		=> 'org_file'
		
	},
	'english'	=>
	{
		'JapaneseMessage'	=> "Japanese",
		'EnglishMessage'	=> 'English',
		'EnglishComment'	=> 'Comment(English)',
		'FrenchMessage'		=> 'French',
		'FrenchComment'		=> 'Comment(French)',
		'GermanMessage'		=> 'German',
		'GermanComment'		=> 'Comment(German)',
		'ItalianMessage'	=> 'Italian',
		'ItalianComment'	=> 'Comment(Italian)',
		'SpanishMessage'	=> 'Spanish',
		'SpanishComment'	=> 'Comment(Spanish)',
		'KoreanMessage'		=> 'Korean',
		'Character'			=> 'Character',
		'Scroll'			=> 'Scroll',
		'WindowContext'		=> 'WindowContextName',
		'OriginalFile'		=> 'org_file'
	}
};



####################################################################
# NEW
####################################################################
sub new
{
	my ($pkg,$row,$language) = @_;

	my $member =
	{
		'row'				=> undef,

		'JapaneseMessage'	=> undef,	# メッセージ(日本語)
		'JapaneseComment'	=> undef,	# コメント(日本語)
		'EnglishMessage'	=> undef,	# メッセージ(English)
		'EnglishComment'	=> undef,	# コメント(English)	
		'FrenchMessage'		=> undef,	# メッセージ(French)
		'FrenchComment'		=> undef,	# コメント(French)	
		'GermanMessage'		=> undef,	# メッセージ(German)
		'GermanComment'		=> undef,	# コメント(German)	
		'ItalianMessage'	=> undef,	# メッセージ(Italian)
		'ItalianComment'	=> undef,	# コメント(Italian)	
		'SpanishMessage'	=> undef,	# メッセージ(Spanish)
		'SpanishComment'	=> undef,	# コメント(Spanish)			
		'KoreanMessage'		=> undef,	# メッセージ(Korean)
		'Character'			=> undef,	# キャラ指定
		'Scroll'			=> undef,	# スクロール設定値
		'WindowContext'		=> undef,	# ウインドウコンテキスト名
		'OriginalFile'		=> undef,	# 元gmmファイル
		
		'name2id'			=> undef,	# 名前から名前IDへの変換テーブル
		'id2name'			=> undef	# 名前IDから名前への変換テーブル
	};

	init_member( $row,$member,$language );
	bless $member,$pkg;
}
#-------------------------------------------------------------------
sub get
{
	my ($this,$key) = @_;
	switch ($key)
	{
		case 'JapaneseMessage'	{ return $this->get_($key)}
		case 'JapaneseComment'	{ return $this->get_($key)}
		case 'EnglishMessage'	{ return $this->get_($key)}
		case 'EnglishComment'	{ return $this->get_($key)}
		case 'FrenchMessage'	{ return $this->get_($key)}
		case 'FrenchComment'	{ return $this->get_($key)}
		case 'GermanMessage'	{ return $this->get_($key)}
		case 'GermanComment'	{ return $this->get_($key)}
		case 'ItalianMessage'	{ return $this->get_($key)}
		case 'ItalianComment'	{ return $this->get_($key)}
		case 'SpanishMessage'	{ return $this->get_($key)}
		case 'SpanishComment'	{ return $this->get_($key)}
		case 'KoreanMessage'	{ return $this->get_($key)}
		case 'Character'		{ return $this->get_($key)}	
		case 'Scroll'			{ return $this->get_($key)}		
		case 'WindowContext'	{ return $this->get_($key)}	
		case 'OriginalFile'		{ return $this->get_($key)}	
		else {util::log::msg('get:'.$key.'には対応しておりません。');}
	}
	return '';
}
#-------------------------------------------------------------------
sub set
{
	my ($this,$key,@arg) = @_;
	switch ($key)
	{
		case 'JapaneseMessage'	{ $this->setJapaneseMessage(@arg) }
		case 'JapaneseComment'	{ $this->setJapaneseComment(@arg) }		
		case 'EnglishMessage'	{ $this->setEnglishMessage(@arg)  }		
		case 'EnglishComment'	{ $this->setEnglishComment(@arg)  }
		case 'FrenchMessage'	{ $this->setFrenchMessage(@arg)  }		
		case 'FrenchComment'	{ $this->setFrenchComment(@arg)  }
		case 'GermanMessage'	{ $this->setGermanMessage(@arg)  }		
		case 'GermanComment'	{ $this->setGermanComment(@arg)  }
		case 'ItalianMessage'	{ $this->setItalianMessage(@arg)  }		
		case 'ItalianComment'	{ $this->setItalianComment(@arg)  }
		case 'SpanishMessage'	{ $this->setSpanishMessage(@arg)  }		
		case 'SpanishComment'	{ $this->setSpanishComment(@arg)  }		
		case 'KoreanMessage'	{ $this->setKoreanMessage(@arg)  }		
		case 'Character'		{ $this->setCharacter(@arg)       }
		case 'Scroll'			{ $this->setScroll(@arg)          }		
		case 'WindowContext'	{ $this->setWindowContext(@arg)   }
		case 'OriginalFile'		{ $this->getOriginalFile(@arg)    }
		else {utli::log::msg('set:'.$key.'には対応しておりません。')}
	}
}
#-------------------------------------------------------------------
# メッセージ（日本語）を取得する。
sub getJapaneseMessage
{
	my ($this) = @_;
	return $this->get_( 'JapaneseMessage' );
}
# メッセージ（日本語）を設定する。
sub setJapaneseMessage
{
	my ($this,$data) = @_;
	$this->set_language( 'JapaneseMessage',$data );
}
#-------------------------------------------------------------------
# コメント（日本語）を取得します。
sub getJapaneseComment
{
	 my ($this) = @_;
	 return $this->get_( 'JapaneseComment' );
}
# コメント（日本語）を設定する。
sub setJapaneseComment
{
	my ($this,$data) = @_;
	$this->set_comment( 'JapaneseComment',$data );	
}
#-------------------------------------------------------------------
# アトリビュートの属性（Japanese）を設定します。
sub getJapaneseAttribute
{
	my ($this) = @_;
	return $this->get_languageAttribute('JapaneseMessage');
}
# アトリビュートの属性（Japanese）を設定します。
sub setJapaneseAttribute
{
	my ($this,$font,$width,$line) = @_;
	$this->set_languageAttribute('JapaneseMessage',$font,$width,$line);
}
#-------------------------------------------------------------------
# メッセージ（English）を取得する。
sub getEnglishMessage
{
	my ($this) = @_;
	return $this->get_( 'EnglishMessage' );
}
# メッセージ（English）を設定する。
sub setEnglishMessage
{
	my ($this,$data) = @_;
	$this->set_language( 'EnglishMessage',$data );
}
#-------------------------------------------------------------------
# コメント（English）を取得する。
sub getEnglishComment
{
	 my ($this) = @_;
	 return $this->get_( 'EnglishComment' );
}
# コメント（English）を設定する。
sub setEnglishComment
{
	my ($this,$data) = @_;
	$this->set_attribute( 'EnglishComment',$data );	
}
#-------------------------------------------------------------------
# アトリビュートの属性（English）を設定します。
sub getEnglishAttribute
{
	my ($this) = @_;
	return $this->get_languageAttribute('EnglishMessage');
}
# アトリビュートの属性（English）を設定します。
sub setEnglishAttribute
{
	my ($this,$font,$width,$line) = @_;
	$this->set_languageAttribute('EnglishMessage',$font,$width,$line);
}
#-------------------------------------------------------------------
# メッセージ（French）を取得する。
sub getFrenchMessage
{
	my ($this) = @_;
	return $this->get_( 'FrenchMessage' );
}
# メッセージ（French）を設定する。
sub setFrenchMessage
{
	my ($this,$data) = @_;
	$this->set_language( 'FrenchMessage',$data );
}
#-------------------------------------------------------------------
# コメント（French）を取得する。
sub getFrenchComment
{
	 my ($this) = @_;
	 return $this->get_( 'FrenchComment' );
}
# コメント（French）を設定する。
sub setFrenchComment
{
	my ($this,$data) = @_;
	$this->set_attribute( 'FrenchComment',$data );	
}
#-------------------------------------------------------------------
# アトリビュートの属性（French）を設定します。
sub getFrenchAttribute
{
	my ($this) = @_;
	return $this->get_languageAttribute('FrenchMessage');
}
# アトリビュートの属性（French）を設定します。
sub setFrenchAttribute
{
	my ($this,$font,$width,$line) = @_;
	$this->set_languageAttribute('FrenchMessage',$font,$width,$line);
}
#-------------------------------------------------------------------
# メッセージ（German）を取得する。
sub getGermanMessage
{
	my ($this) = @_;
	return $this->get_( 'GermanMessage' );
}
# メッセージ（German）を設定する。
sub setGermanMessage
{
	my ($this,$data) = @_;
	$this->set_language( 'GermanMessage',$data );
}
#-------------------------------------------------------------------
# コメント（German）を取得する。
sub getGermanComment
{
	 my ($this) = @_;
	 return $this->get_( 'GermanComment' );
}
# コメント（German）を設定する。
sub setGermanComment
{
	my ($this,$data) = @_;
	$this->set_attribute( 'GermanComment',$data );	
}
#-------------------------------------------------------------------
# アトリビュートの属性（German）を設定します。
sub getGermanAttribute
{
	my ($this) = @_;
	return $this->get_languageAttribute('GermanMessage');
}
# アトリビュートの属性（German）を設定します。
sub setGermanAttribute
{
	my ($this,$font,$width,$line) = @_;
	$this->set_languageAttribute('GermanMessage',$font,$width,$line);
}
#-------------------------------------------------------------------
# メッセージ（Italian）を取得する。
sub getItalianMessage
{
	my ($this) = @_;
	return $this->get_( 'ItalianMessage' );
}
# メッセージ（Italian）を設定する。
sub setItalianMessage
{
	my ($this,$data) = @_;
	$this->set_language( 'ItalianMessage',$data );
}
#-------------------------------------------------------------------
# コメント（Italian）を取得する。
sub getItalianComment
{
	 my ($this) = @_;
	 return $this->get_( 'ItalianComment' );
}
# コメント（Italian）を設定する。
sub setItalianComment
{
	my ($this,$data) = @_;
	$this->set_attribute( 'ItalianComment',$data );	
}
#-------------------------------------------------------------------
# アトリビュートの属性（Italian）を設定します。
sub getItalianAttribute
{
	my ($this) = @_;
	return $this->get_languageAttribute('ItalianMessage');
}
# アトリビュートの属性（Italian）を設定します。
sub setItalianAttribute
{
	my ($this,$font,$width,$line) = @_;
	$this->set_languageAttribute('ItalianMessage',$font,$width,$line);
}
#-------------------------------------------------------------------
# メッセージ（Spanish）を取得する。
sub getSpanishMessage
{
	my ($this) = @_;
	return $this->get_( 'SpanishMessage' );
}
# メッセージ（Spanish）を設定する。
sub setSpanishMessage
{
	my ($this,$data) = @_;
	$this->set_language( 'SpanishMessage',$data );
}
#-------------------------------------------------------------------
# コメント（Spanish）を取得する。
sub getSpanishComment
{
	 my ($this) = @_;
	 return $this->get_( 'SpanishComment' );
}
# コメント（Spanish）を設定する。
sub setSpanishComment
{
	my ($this,$data) = @_;
	$this->set_attribute( 'SpanishComment',$data );	
}
#-------------------------------------------------------------------
# アトリビュートの属性（Spanish）を設定します。
sub getSpanishAttribute
{
	my ($this) = @_;
	return $this->get_languageAttribute('SpanishMessage');
}
# アトリビュートの属性（Spanish）を設定します。
sub setSpanishAttribute
{
	my ($this,$font,$width,$line) = @_;
	$this->set_languageAttribute('SpanishMessage',$font,$width,$line);
}
#-------------------------------------------------------------------
# メッセージ（Korean）を取得する。
sub getKoreanMessage
{
	my ($this) = @_;
	return $this->get_( 'KoreanMessage' );
}
# メッセージ（Korean）を設定する。
sub setKoreanMessage
{
	my ($this,$data) = @_;
	$this->set_language( 'KoreanMessage',$data );
}
#-------------------------------------------------------------------
# アトリビュートの属性（Korean）を設定します。
sub getKoreanAttribute
{
	my ($this) = @_;
	return $this->get_languageAttribute('KoreanMessage');
}
# アトリビュートの属性（Korean）を設定します。
sub setKoreanAttribute
{
	my ($this,$font,$width,$line) = @_;
	$this->set_languageAttribute('KoreanMessage',$font,$width,$line);
}
#-------------------------------------------------------------------
# キャラ指定を取得する。
sub getCharacter
{
	 my ($this) = @_;
	 return $this->get_( 'Character' );
}
# キャラ指定を設定する。
sub setCharacter
{
	my ($this,$data) = @_;
	$this->set_attribute( 'Character',$data );	
}
#-------------------------------------------------------------------
# スクロールを取得する。
sub getScroll
{
	 my ($this) = @_;
	 return $this->get_( 'Scroll' );
}
# スクロールを設定する。
sub setScroll
{
	my ($this,$data) = @_;
	$this->set_attribute( 'Scroll',$data );	
}
#-------------------------------------------------------------------
# ウインドウコンテキストを取得する。
sub getWindowContext
{
	 my ($this) = @_;
	 return $this->get_( 'WindowContext' );
}
# ウインドウコンテキストを設定する。
sub setWindowContext
{
	my ($this,$data) = @_;
	$this->set_attribute( 'WindowContext',$data );	
}
#-------------------------------------------------------------------
# オリジナルgmmファイル名を取得する。
sub getOriginalFile
{
	 my ($this) = @_;
	 return $this->get_( 'OriginalFile' );
}
# オリジナルgmmファイル名を設定する。
sub setOriginalFile
{
	my ($this,$data) = @_;
	$this->set_attribute( 'OriginalFile',$data );	
}
# 以下は内部関数
####################################################################
sub init_member
{
	my ( $row,$member,$language ) = @_;

	my @node_list;

	# テーブル
	$member->{'name2id'} = $NAME2ID->{$language};
	$member->{'id2name'} = $ID2NAME->{$language};
	
	# row
	$member->{'row'} = $row;

	# comment 1つのみ
	@node_list = $row->getElementsByTagName('comment',0);
	foreach my $node ( @node_list )
	{
		$member->{'JapaneseComment'} = $node;
	}		

	# language
	@node_list = $row->getElementsByTagName('language',0);
	foreach my $node ( @node_list )
	{
		my $name = $node->getAttribute('name');
		$name = $member->{'name2id'}->{$name};
		$member->{$name} = $node;
	}	

	# attribute
	@node_list = $row->getElementsByTagName('attribute',0);
	foreach my $node ( @node_list )
	{
		my $name = $node->getAttribute('name');
		$name = $member->{'name2id'}->{$name};
		$member->{$name} = $node;
	}
}
#-------------------------------------------------------------------
# メンバの取得
sub get_
{
	my ($this,$key) = @_;

	# key が存在しない場合
	unless ( defined($this->{$key}) )
	{
		return '';
	}
	
	return dom::util::getText( $this->{$key} );
}
#-------------------------------------------------------------------
# メンバの設定
sub set_comment
{
	my ($this,$key,$data) = @_;

	# key が存在しない場合
	unless ( defined($this->{$key}) )
	{
		my $doc = $this->{'row'}->getOwnerDocument();
		my $node = $doc->createElement('comment');
		$this->{'row'}->appendChild($node);
		$this->{$key} = $node;
	}

	dom::util::setText( $this->{$key},$data );
}
#-------------------------------------------------------------------
# メンバの設定
sub set_language
{
	my ($this,$key,$data) = @_;

	# key が存在しない場合
	unless ( defined($this->{$key}) )
	{
		$this->create_node('language',$key );
	}

	dom::util::setText( $this->{$key},$data );
}
#-------------------------------------------------------------------
# メンバの設定
sub set_attribute
{
	my ($this,$key,$data) = @_;

	# key が存在しない場合
	unless ( defined($this->{$key}) )
	{
		$this->create_node('attribute',$key );
	}

	dom::util::setText( $this->{$key},$data );
}
#-------------------------------------------------------------------
# 新規ノードの作成
sub create_node
{
	my ($this,$tag,$key) = @_;

	my $doc = $this->{'row'}->getOwnerDocument();
	my $node = $doc->createElement($tag);
	my $name = $this->{'id2name'}->{$key};
	$node->setAttribute('name',$name);
	$this->{'row'}->appendChild($node);
	$this->{$key} = $node;
}
#-------------------------------------------------------------------
# language アトリビュートの属性を取得します。
sub get_languageAttribute
{
	my ($this,$key) = @_;
	
	# key が存在しない場合
	unless ( defined($this->{$key}) )
	{
		return ('','','');
	}
	
	my $node = $this->{$key};
	my $font	= $node->getAttribute('font'); 
	my $width	= $node->getAttribute('width'); 
	my $line	= $node->getAttribute('line');
	
	return ($font,$width,$line);	
}
#-------------------------------------------------------------------
# language アトリビュートの属性を設定します。
sub set_languageAttribute
{
	my ($this,$key,$font,$width,$line) = @_;

	# key が存在しない場合
	unless ( defined($this->{$key}) )
	{
		$this->create_node('language',$key );
	}

	my $node = $this->{$key};
	$node->setAttribute( 'font', $font  );
	$node->setAttribute( 'width',$width );
	$node->setAttribute( 'line', $line  );
}
#-------------------------------------------------------------------


1;
