
package set;

use strict;
use utf8;
use XML::DOM;

####################################################################
# ウインドウの情報を設定する。
# ...
####################################################################
sub setWindowInfo
{
	my $ref = shift;
	my $ref_info = shift;

	foreach my $row ( @{$ref->{rows}} )
	{
print 'id:',$row->getAttribute('id'),"\n";

		# ウインドウコンテキストを取得
		my $window = $ref->getWindowContext($row);

		# ウインドウコンテキストが空なら次へ
		next if ($window eq '');
		
		# ウインドウ情報が存在する場合
		if (exists($ref_info->{$window}))
		{
			# フォント・幅・行数を設定する。
			$ref->setEnglishMessageAttribute
			(
				$row,
				getFont($ref_info->{$window}->{FONT}),
				$ref_info->{$window}->{WIDTH},
				$ref_info->{$window}->{LINE}
			);
		}
		# ウインドウ情報が存在しない場合
		else
		{	
print "error! window: $window\n";
		}
print "-----------------------------------------------------------\n";
	}
}
1;
