
package xls::layout;

use strict;
use utf8;
use Win32::OLE qw(in with CP_UTF8);
use Win32::OLE::Const 'Microsoft Excel';

require 'pm/util/log.pm';

# 環境に合わせて設定を変更して下さい。
#-------------------------------------------------------------------
my $SHEET_NAME		= 'layout';			#シート名
my $TITLE_ROW_IDX	= 1;				#タイトル行インデックス
my $WINDOW			= 'Window Context';	#項目名（ウインドウ）
my $FONT			= 'FONT';			#項目名（フォント）
my $WIDTH			= 'W';				#項目名（幅）
my $LINE			= 'Line';			#項目名（行数）
my $SCROLL			= 'Scrollable';		#項目名（スクロール）

my $FNT = 
{
	"TALK"		=> ' 0:font_talk',
	"SYSTEM"	=> ' 1:font_system',
	"BUTTON"	=> ' 2:font_button',
	"UNKNOWN"	=> ' 3:font_unknown',
	"TEST1"		=> ' 4:test1',
	"NUM"		=> ' 5:font_num',
	"G"			=> ' 6:font_graphic'
};

my $SCROLLTBL = 
{
	0	=>	'FALSE',
	1	=>	'TRUE'
};

#-------------------------------------------------------------------

# NEW
####################################################################
sub new
{
	# file : xls file (絶対パスで指定して下さい)
	my ($pkg,$file) = @_;

	# 相対アドレスなら絶対アドレスに変換
	unless ($file =~ /^\w:/)
	{
		$file = Cwd::getcwd().'/'.$file;
	}

	my $member ={};

	_init($member,$file);
	bless $member,$pkg;
}
####################################################################
# ウインドウの情報を設定する。
####################################################################
sub getWindowInfo
{
	my ($this,$window) = @_;

	if ( exists($this->{$window}) )
	{
		my $f = $this->{$window}->{'FONT'};
		my $w = $this->{$window}->{'WIDTH'};
		my $l = $this->{$window}->{'LINE'};
		my $s = $this->{$window}->{'SCROLL'};
		return ($f,$w,$l,$s);
	}
	else
	{
		my $msg = "$window はレイアウトファイルに存在しません。";
		util::log::msg('Error',$msg);
		return ('','','','');
	}
}
#-------------------------------------------------------------------
# memberを初期化する
#-------------------------------------------------------------------
sub _init
{
	my ($member,$file) = @_;
	
	# Excel 起動
	my $excel = Win32::OLE->new('Excel.Application')
				or die "error! can't use Excel";

	# Book を開く
	my $book =	$excel->Workbooks->Open($file)
				or die "error! can't open $file";

	# Sheet を開く
	my $sheet = $book->Worksheets($SHEET_NAME)
				or die "error! can't open $SHEET_NAME";

	# タイトル行から各項目のインデックスを取得する
	my $index =_getIndex($sheet);
	
	# ウインドウの情報を取得する
	my $max = $sheet->Cells(65536,$index->{$WINDOW})->End(xlUp)->{Row};
	for ( my $i=$TITLE_ROW_IDX+1; $i<=$max; $i++)
	{
		util::log::setID($i);
		_registerMember
		(
			$member,
			$sheet->Cells($i,$index->{$WINDOW})->{Value},	
			$sheet->Cells($i,$index->{$FONT})->{Value},
			$sheet->Cells($i,$index->{$WIDTH})->{Value},
			$sheet->Cells($i,$index->{$LINE})->{Value},
			$sheet->Cells($i,$index->{$SCROLL})->{Value}
		);
	}

	# Book を閉じる
	$book->Close();
}
#-------------------------------------------------------------------
# タイトル行のインデックスを取得する。
#-------------------------------------------------------------------
sub _getAllIndex
{
	my ($sheet) = @_;
	
	my $max = $sheet->Cells($TITLE_ROW_IDX,256)->End(xlToLeft)->{Column};
	my $index;
	for (my $i=1; $i<=$max; $i++)
	{
		my $item = $sheet->Cells($TITLE_ROW_IDX,$i)->{Value};
		$index->{$item} = $i;
	}
	return $index;
}
#-------------------------------------------------------------------
# ウインドウ情報に関するインデックスを取得する。
#-------------------------------------------------------------------
sub _getIndex
{
	my ($sheet) = @_;

	my $index = _getAllIndex($sheet);
	
	# 項目の確認
	foreach my $val ($WINDOW,$FONT,$WIDTH,$LINE,$SCROLL)
	{
		next if exists($index->{$val});
		util::log::msg('Error',"$val がありません");
	}
	return $index;
}
#-------------------------------------------------------------------
# メンバにウインドウ情報を登録する
#-------------------------------------------------------------------
sub _registerMember
{
	my ($info,$id,$f,$w,$l,$s) = @_;

	return if ($id eq '');	# IDがないならなにもしない。
	$f = _getFontName($f);
	$s = _getScrollString($s);

	# 既に登録済みのウインドウ情報の場合
	if (exists($info->{$id}))
	{
		# 既出のウインドウ名だった場合　警告表示
		# 先に出現したウインドウ情報を優先
		my $old_f = $info->{$id}->{'FONT'};
		my $old_w = $info->{$id}->{'WIDTH'};
		my $old_l = $info->{$id}->{'LINE'};
		my $old_s = $info->{$id}->{'SCROLL'};
		unless (($f eq $old_f) && ($w eq $old_w) && ($l eq $old_l) && ($s eq $old_s))
		{
			util::log::msg('Error',$id,$f,$w,$l,$s,'ウインドウコンテキストに重複があります');
		}
		else
		{
			util::log::msg('OK2',$id,$f,$w,$l,$s);
		}
	}
	# 未取得のウインドウ情報の場合
	else
	{
		$info->{$id} = 
		{
			'FONT'	=> $f,
			'WIDTH'	=> $w,
			'LINE'	=> $l,
			'SCROLL'=> $s
		};
		util::log::msg('OK1',$id,$f,$w,$l,$s);
	}
}
#-------------------------------------------------------------------
# Excel上のフォント名をgmm上のフォント名に変換する。
#-------------------------------------------------------------------
sub _getFontName
{
	my ($font) = @_;

	if (exists($FNT->{$font}))
	{
		return $FNT->{$font};
	}
	else
	{
		util::log::msg('Error',$font.'というフォントは指定できません');
		return $font;
	}
}
#-------------------------------------------------------------------
# Excel上のフォント名をgmm上のフォント名に変換する。
#-------------------------------------------------------------------
sub _getScrollString
{
	my ($scroll) = @_;

	if (exists($SCROLLTBL->{$scroll}))
	{
		return $SCROLLTBL->{$scroll};
	}
	else
	{
		util::log::msg('Error',$scroll.'スクロールの設定に誤りがあります');
		return $scroll;
	}
}
####################################################################
1;
