﻿use strict;
use utf8;
use Win32::OLE qw(in with CP_UTF8);
use Win32::OLE::Const 'Microsoft Excel';
use Cwd;

$Win32::OLE::CP = CP_UTF8;

my $SHEET_NO = 1;

#***********************************************************
# パッケージxls
#***********************************************************
package xls;

my $excel;

#===========================================================
# パッケージ初期化。
#===========================================================
{
	$excel = Win32::OLE->new('Excel.Application');
	if (!defined($excel)) {
		die "excelが開始できません。\n";
	}
	$excel->{DisplayAlerts} = 0;
}

#===========================================================
# パッケージ終了。
#===========================================================
END {
	$excel->Quit();
	$excel = undef;
}

#===========================================================
# オブジェクト生成。
#===========================================================
sub new {
	my ($class, $fname) = @_;

	bless {
		fname => $fname
	}, $class;
}

#===========================================================
# データ取得。
#===========================================================
sub getData {
	my ($self, $end_col) = @_;
	my ($range, $data);

	$self->open_book();

	$range = $self->{sheet}->Range("A65536")->End(::xlUp);
	$data = $self->{sheet}->Range("A1:$end_col$range->{Row}")->{Value};
	for my $i (@{$data}) {
		for my $j (@{$i}) {
			$j = substr($j . 'あ', 0, length($j));
		}
	}

	return $data;
}

#===========================================================
# データ設定。
#===========================================================
sub setData {
	my ($self, $end_col, $data) = @_;
	my ($range);

	$self->open_book();

	$range = $self->{sheet}->Range("A65536")->End(::xlUp);
	$self->{sheet}->Range("A1:$end_col$range->{Row}")->{Value} = $data;
}

#===========================================================
# book保存。
#===========================================================
sub Save {
	my ($self) = @_;

	$self->{book}->Save();
}

#===========================================================
# book別名に保存。
#===========================================================
sub SaveAs {
	my ($self, $fname) = @_;
	my ($path);

	$path = ::getcwd();
	$self->{book}->SaveAs("$path/$fname");
}

#===========================================================
# 色取得。
#===========================================================
sub getColor {
	my ($self, $row, $col) = @_;

	$self->open_book();

	return $self->{sheet}->Cells($row, $col)->{Interior}{ColorIndex};
}

#===========================================================
# 色設定。
#===========================================================
sub setColor {
	my ($self, $row, $col, $col_idx) = @_;

	$self->open_book();

	$self->{sheet}->Cells($row, $col)->{Interior}{ColorIndex} = $col_idx;
}

#-----------------------------------------------------------
# private
#-----------------------------------------------------------

#===========================================================
# テキストノードを取得。
#===========================================================
sub open_book {
	my ($self) = @_;

	if (!$self->{sheet}) {
		my ($path);

		$path = ::getcwd();
		$self->{book} = $excel->Workbooks->Open("$path/$self->{fname}");
		if (!defined($self->{book})) {
			die "bookが開けません。\n";
		}
		$self->{sheet} = $self->{book}->Worksheets($SHEET_NO);
		if (!defined($self->{sheet})) {
			die "sheetが取れません。\n";
		}
	}
}

1;
