﻿use strict;
use File::Find;
use utf8;
use xls;
require "pm/util/log.pm";

binmode(STDOUT, "utf8");
binmode(STDERR, "encoding(shiftjis)");

my %check_col = (
	"DP_Areanames.xls"   => { msg_id => 'A', text => [
		'E' ] },
	"DP_Berries.xls"     => { msg_id => 'A', text => [
		'E', 'H' ] },
	"DP_Characters.xls"  => { msg_id => 'A', text => [
		'E' ] },
	"DP_Items.xls"       => { msg_id => 'A', text => [
		'E', 'H' ] },
	"DP_Moves.xls"       => { msg_id => 'A', text => [
		'E', 'H' ] },
	"DP_Pokedex.xls"     => { msg_id => 'A', text => [
		'D', 'I', 'L' ] },
	"DP_Simpletext.xls"  => { msg_id => 'A', text => [
		'E' ] },
	"DP_SpeAbility.xls"  => { msg_id => 'A', text => [
		'E', 'H' ] },
	"DP_Stickers.xls"    => { msg_id => 'A', text => [
		'E', 'H' ] },
	"DP_Trainers.xls"    => { msg_id => 'A', text => [
		'E' ] },
	"DP_Underground.xls" => { msg_id => 'A', text => [
		'E', 'H' ] }
);
my %COL_NUM;

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	if (@ARGV != 3) {
		die "add src dstです。\n";
	}

	my %f_list = (
		"old" => [ sort @{get_file_list($ARGV[1])} ],
		"new" => [ sort @{get_file_list($ARGV[0])} ]
	);

	{
		# カラム文字をインデクス値に変換するテーブル。
		my ($letter);

		$letter = 'A';
		for my $i (0 .. 100) {
			$COL_NUM{$letter} = $i;
			$letter++;
		}
	}
	for (my $i = 0; $i < @{$f_list{old}}; $i++) {
		my (%file, %xls, %data, @head, $col, $row);
		my %path = (
			"old" => $f_list{old}[$i],
			"new" => $f_list{new}[$i]
		);
		my %file = %path;

		for my $i (keys %path) {
			$file{$i} =~ s/^.*[\\\/]_?([^\\\/]+)$/$1/;
			$xls{$i} = new xls($path{$i});
			$data{$i} = $xls{$i}->getData('Z');
			@head = @{$data{$i}[0]};	# ヘッダは共通なので１つでよい。
		}
		if ($file{old} ne $file{new}) {
			die "error: ファイル名が一致しない。\n";
		}

		util::log::setFileName($file{old});
		$col = $check_col{$file{old}};
		$col->{msg_id} = $COL_NUM{$col->{msg_id}};
		for my $j (@{$col->{text}}) {
			$j = $COL_NUM{$j};
		}

		if (0) {
			$row = 2;
		}
		for (my $j = 1; $j < @{$data{old}}; $j++) {
			my ($msg_id);
			my %msg_id = (
				"old" => $data{old}[$j][$col->{msg_id}],
				"new" => $data{new}[$j][$col->{msg_id}]
			);

			if ($msg_id{old} ne $msg_id{new}) {
				util::log::msg("idが一致しません。");
			}
			$msg_id = $msg_id{old};
			if (0) {
				my ($c);

				$c = 1;
				for (@{$data{old}[$j]}) {
					if ($xls{old}->getColor($row, $c) == 46) {
						$xls{old}->setColor($row, $c, 2);
					}
					$c++;
				}
			}
			for my $k (@{$col->{text}}) {
				my %text = (
					"old" => $data{old}[$j][$k],
					"new" => $data{new}[$j][$k],
					"old_ref" => \$data{old}[$j][$k]
				);
				my $head = $head[$k];

				util::log::setMsgId($msg_id);
				if ($text{old} ne $text{new}) {
					if ($text{old} eq "") {
						util::log::msg('NEW', $head, $text{new});
					} elsif ($text{new} eq "") {
						util::log::msg('DEL', $head, $text{old});
					} else {
						util::log::msg('UP', $head, $text{old}, '->', $text{new});
					}
					${$text{old_ref}} = $text{new};
					if (0) {
						$xls{old}->setColor($row, $col->{text}[$k] + 1, 46);
					}
				}
			}
			if (0) {
				$row++;
			}
		}
		$xls{old}->setData('Z', $data{old});
		$xls{old}->SaveAs("$ARGV[2]/$file{new}");
	}
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir) = @_;
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.xls$/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, $dir);
	return \@list;
}
