#ifndef _SCREEN_H_
#define _SCREEN_H_


#ifdef __cplusplus
extern "C" {
#endif

void screenInit(void);
void screenLocate(int x,int y);
void screenHome(void);
void screenClear(void);
void screenClearLine(int y);
void screenScrollUp(void);
void screenPutc(char ch);
void screenPrintf(char *fmt, ...);
void screenVPrintf(char *fmt, va_list vlist);

void screenColor(u8 color);

enum {
	COLOR_BLACK = 0,
	COLOR_RED,
	COLOR_GREEN,
	COLOR_BLUE,
	COLOR_YELLOW,
	COLOR_PURPLE,
	COLOR_LIGHTBLUE,
	COLOR_DARKRED,
	COLOR_DARKGREEN,
	COLOR_DARKBLUE,
	COLOR_DARKYELLOW,
	COLOR_DARKPURPLE,
	COLOR_DARKLIGHTBLUE,
	COLOR_GRAY,
	COLOR_DARK_GRAY,
	COLOR_WHITE
};



#ifdef __cplusplus
}
#endif

#endif /* _SCREEN_H_ */
