/*---------------------------------------------------------------------------*
  Project:  NitroSDK - libraries - loader
  File:     loader.c

  Copyright 2003-2006 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  Revision 1.7  2006/01/18 02:11:19  kitase_hirotake
  do-indent

  Revision 1.6  2005/11/21 10:52:28  kitase_hirotake
  PXI_Init ̍폜

  Revision 1.5  2005/02/28 05:26:01  yosizaki
  do-indent.

  Revision 1.4  2004/09/04 10:01:14  sato_masaki
  includewb_Amb_private.hɕύXB

  Revision 1.3  2004/09/03 11:48:54  yasu
  fix typo

  Revision 1.2  2004/09/03 07:09:25  sato_masaki
  MBCũt@CɂXVBNVRAM܂̃l[ɑΉB

  Revision 1.1  2004/08/31 11:00:13  sato_masaki
  initial check-in

 *---------------------------------------------------------------------------*/

#include <nitro.h>

#if	defined(SDK_ARM7)
#include <nitro_wl/ARM7/WlLib.h>
#else
#ifdef SDK_SMALL_BUILD
#include "IPL_work.h"
#endif
#endif


#include <nitro/mb.h>
#include <mb_private.h>
#include "loader.h"

// --------------------------------------------------------------------------
#define GAME_MAINP_ENTRY_POINT			(HW_ROM_HEADER_BUF+0x24)
#define GAME_SUBP_ENTRY_POINT			(HW_ROM_HEADER_BUF+0x34)

// Download̃TCY

#define MB_OVT_MAX_SIZE					MB_COMM_BLOCK_SIZE      // OVT̍őTCYiBlockTCYőTCYƂj

/*----------------------------------------------------------------------------*/
#define MB_TRIGGER_SIGNAL_TO_ARM7		(0x00000001)

/*----------------------------------------------------------------------------*/
static void MIm_CpuClear32(register u32 data, register void *destp, register u32 size);
static void MIm_CpuClear32(register u32 data, register void *destp, register u32 size);
static void LOADERi_LocateAllSegments(MBDownloadFileInfo * mdfi);
static void MBi_SearchAndLocateSegmentInfo(MBDownloadFileInfo * mdfi, u16 processor);
static void LOADERi_Jump(void);
static void MBi_fifo_callback_arm7(PXIFifoTag tag, u32 msg_adr, BOOL err);

/*----------------------------------------------------------------------------*/
static MB_LoaderCallback loader_precallback = NULL;

/*----------------------------------------------------------------------------*/


#if	defined(SDK_ARM7)

/*---------------------------------------------------------------------------*
  Name:         MIm_CpuCopy32

  Description:  [_[pCpuCopy

  Arguments:    srcp, destp, size

  Returns:      void
 *---------------------------------------------------------------------------*/

#include <nitro/code32.h>

asm void MIm_CpuCopy32( register const void *srcp, register void *destp, register u32 size )
{
        add     r12, r1, r2             // r12: destEndp = destp + size

@30:
        cmp     r1, r12                 // while (destp < destEndp)
        ldmltia r0!, {r2}               // *((vu32 *)(destp)++) = *((vu32 *)(srcp)++)
        stmltia r1!, {r2}
        blt     @30

        bx      lr
}

#ifndef SDK_SMALL_BUILD
static asm void MIm_CpuClear32( register u32 data, register void *destp, register u32 size )
{
        add     r12, r1, r2             // r12: destEndp = destp + size

@20:
        cmp     r1, r12                 // while (destp < destEndp)
        stmltia r1!, {r0}               // *((vu32 *)(destp++)) = data
        blt     @20

        bx      lr
}
#endif

#include <nitro/codereset.h>


/*---------------------------------------------------------------------------*
  Name:         LOADERi_LocateAllSegments

  Description:  ARM9,ARM7̊eZOgKvɉčĔzuB

  Arguments:    mdfi

  Returns:      void
 *---------------------------------------------------------------------------*/

static void LOADERi_LocateAllSegments(MBDownloadFileInfo * mdfi)
{
    MBi_SearchAndLocateSegmentInfo(mdfi, MI_PROCESSOR_ARM9);    // ARM9ZOgɂĂ̔zu
    MBi_SearchAndLocateSegmentInfo(mdfi, MI_PROCESSOR_ARM7);    // ARM7ZOgɂĂ̔zu
}


/* w̃ZOg, Ĕzu */
static void MBi_SearchAndLocateSegmentInfo(MBDownloadFileInfo * mdfi, u16 processor)
{
    int     i;
    MbSegmentInfo *seg_info;

    if (mdfi)
    {
        for (i = 0; i < MB_DL_SEGMENT_NUM; ++i)
        {
            seg_info = &mdfi->seg[i];
            if (seg_info->target == processor)
            {
                if (seg_info->recv_addr != seg_info->load_addr)
                {
                    MIm_CpuCopy32((void *)seg_info->recv_addr, (void *)seg_info->load_addr,
                                  seg_info->size);
#ifndef SDK_SMALL_BUILD                // IPL̏ꍇ́ÃNAIPLōsB
                    MIm_CpuClear32(0, (void *)seg_info->recv_addr, seg_info->size);
#endif
                }
            }
        }
    }
}


/*---------------------------------------------------------------------------*
  Name:         LOADERi_Jump

  Description:  [_[N (ARM7/9 )

  Arguments:    

  Returns:      void
 *---------------------------------------------------------------------------*/

static void LOADERi_Jump(void)
{
#if	defined(SDK_ARM7)

    MBDownloadFileInfo *mdfi = (MBDownloadFileInfo *) MB_DOWNLOAD_FILEINFO_ADDRESS;
    MBParam *p_param = (MBParam *)HW_WM_BOOT_BUF;

    if (p_param->boot_type != MB_TYPE_MULTIBOOT)
    {                                  // u[g^Cv}`u[głȂꍇ́ATRUE^[B
        return;
    }

    LOADERi_LocateAllSegments(mdfi);   // u[gvO̍ĔzusB

#endif
}


/*---------------------------------------------------------------------------*
  Name:         MBi_fifo_callback_arm7

  Description:  p PXI ^OoRŃ[_[N

  Arguments:    

  Returns:      None.
 *---------------------------------------------------------------------------*/

static void MBi_fifo_callback_arm7(PXIFifoTag tag, u32 msg_adr, BOOL err)
{
#pragma unused( err )

    if (tag == PXI_FIFO_TAG_MB && msg_adr == (u32)MB_TRIGGER_SIGNAL_TO_ARM7)
    {
        if (loader_precallback)
        {
            (*loader_precallback) ();
        }
    }
}

#endif /* defined(SDK_ARM7) */


/*---------------------------------------------------------------------------*
  Name:         LOADER_Start

  Description:  [_[̃X^[g

  Arguments:    None.

  Returns:      TRUE - success FALSE - failed
 *---------------------------------------------------------------------------*/


void LOADER_Start(void)
{

#if	defined(SDK_ARM9)
    int     result;
    MBDownloadFileInfo *mdfi = (MBDownloadFileInfo *) MB_DOWNLOAD_FILEINFO_ADDRESS;
    MBParam *p_param = (MBParam *)HW_WM_BOOT_BUF;

    // Gg|CgROMo^GÅYAhXɃRs[iŏIIɂ́AROMo^GA_E[ĥŕKvȂȂj
    *(u32 *)GAME_SUBP_ENTRY_POINT = mdfi->header.arm7EntryAddr;
    *(u32 *)GAME_MAINP_ENTRY_POINT = mdfi->header.arm9EntryAddr;

    // }`u[g̎̓fobKGgɔ΂Ȃ悤NAB
#ifdef SDK_SMALL_BUILD
    GetSharedWorkAddr()->isOnDebugger = 0;
#endif

    // VXëփ}`u[gtO
    p_param->boot_type = MB_TYPE_MULTIBOOT;
    // e@VXë֏
    MI_CpuCopy8((void *)MB_BSSDESC_ADDRESS, &p_param->parent_bss_desc, MB_BSSDESC_SIZE);

    // ARM7փ[_[Nʒm
    result = PXI_SendWordByFifo(PXI_FIFO_TAG_MB, (u32)MB_TRIGGER_SIGNAL_TO_ARM7, FALSE);
    SDK_ASSERTMSG((result >= 0), "ARM9:FIFO SEND ERROR!\n");

    return;

#else  /* defined(SDK_ARM9) */

    // [_[R[
    LOADERi_Jump();

#endif
}


/*---------------------------------------------------------------------------*
  Name:         LOADER_Init

  Description:  [_[̏

  Arguments:    callback - u[g̏oƂɕԂR[obN

  Returns:      None.
 *---------------------------------------------------------------------------*/

void LOADER_Init(MB_LoaderCallback callback)
{
    MBParam *p_param = (MBParam *)HW_WM_BOOT_BUF;

#if	defined(SDK_ARM7)

    loader_precallback = callback;

    /* u[gtO̕␳(}`u[gtOw肳ĂȂꍇROMƂ݂ȂB) */
    if (p_param->boot_type != MB_TYPE_MULTIBOOT)
    {
        p_param->boot_type = MB_TYPE_NORMAL;
    }
    /* ̏, K MB_TYPE_MULTIBOOT  MB_TYPE_NORMAL ɂȂ */

    // }`u[gĎFIFOR[obNZbg
    PXI_SetFifoRecvCallback(PXI_FIFO_TAG_MB, MBi_fifo_callback_arm7);

#else  /* defined(SDK_ARM7) */

#pragma unused(callback)

#endif
}



/*----------------------------------------------------------------------------*
/*  sgp
 *----------------------------------------------------------------------------*/

#if	defined(LOADER_USE_OVT_BUF)

//----------------------------------------------------------------------
// I[o[Ce[u
//----------------------------------------------------------------------
typedef struct
{
    u32     id;                        // I[o[C ID 
    void   *ram_address;               // [h擪ʒu 
    u32     ram_size;                  // [hTCY 
    u32     bss_size;                  // bss ̈TCY 
    void   *sinit_init;                // static initializer 擪AhX 
    void   *sinit_init_end;            // static initializer ŏIAhX
    u32     file_id;                   // I[o[Ct@CID
    u32     rsv;                       // \B
}
ROM_OVT;


// OVT̍őTCYiɂĂ͍čl̗]nj
#define MB_OVT_MAX_SIZE		MB_COMM_BLOCKSIZE

// Overlay Table Buffer
// }`u[gvOŁAX^eBbNCjVCUN̂ɕKv
// I[o[Ce[uŗeʂςĂB
// IPLɂdlł܂܂ŁAɒuĂ
static u32 mb_ovt_buf[MB_OVT_MAX_SIZE / sizeof(u32)];

static void MB_SetOverlayTable(ROM_OVT * srcp, u16 sec_num)
{
    if (srcp && sec_num)
    {
        MI_CpuCopy8((void *)srcp, (void *)mb_ovt_buf, sec_num * sizeof(ROM_OVT));
    }
}

#endif
