//============================================================================================
/**
 * @file	bag.h
 * @brief	obOʏ OQƏ
 * @author	Hiroyuki Nakamura
 * @date	05.08.03
 */
//============================================================================================
#ifndef BAG_H
#define BAG_H
#undef GLOBAL
#ifdef BAG_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
#include "application/bag_def.h"
#include "itemtool/myitem.h"

typedef struct _BAG_DATA	BAG_DATA;

enum {
	BAG_MODE_FIELD = 0,
	BAG_MODE_ITEMSET,
	BAG_MODE_ITEMSALE,
	BAG_MODE_KINOMI,
	BAG_MODE_MIX,
	BAG_MODE_MIX_SIO,
};

enum {
	BAG_RET_USE = 0,
	BAG_RET_TAG,
	BAG_RET_ITEMSET,		// j[uv
	BAG_RET_ENTER,			// j[uĂv
	BAG_RET_POKEITEMSET,	// |PXguv
	BAG_RET_CANCEL
};


//============================================================================================
//	O[oϐ
//============================================================================================
#ifndef BAG_H_GLOBAL
GLOBAL const PROC_DATA BagProcData;		// vZX`f[^
#endif


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃f[^̈m
 *
 * @param	mode	擾[h
 *
 * @return	mۂ̈̃AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL BAG_DATA * BagSystemDataAlloc( u8 mode );

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃f[^TCY擾
 *
 * @param	none
 *
 * @return	f[^TCY
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BagSystemDataSizeGet(void);

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̏y[Wݒ
 *
 * @param	dat		f[^ݒꏊ
 * @param	page	y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAG_InitPageSet( BAG_DATA * dat, u8 page );

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃[hݒ
 *
 * @param	dat		f[^ݒꏊ
 * @param	mode	obOʂ̖
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAG_ModeSet( BAG_DATA * dat, u8 mode );

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̏f[^쐬
 *
 * @param	dat		f[^ݒꏊ
 * @param	sv		Z[uf[^
 * @param	mode	obOʂ̖
 * @param	cur		J[\Lꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAG_SysDataSet( BAG_DATA * dat, SAVEDATA * sv, u8 mode, void * cur );

//--------------------------------------------------------------------------------------------
/**
 * |Pbgf[^쐬
 *
 * @param	dat		obOʂ̃f[^
 * @param	item	QƂACef[^
 * @param	type	|Pbg^Cv
 * @param	poke	|Pbgԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagPocketDataMake( BAG_DATA * dat, MINEITEM * item, u8 type, u8 poke );

//--------------------------------------------------------------------------------------------
/**
 * ]ԃtOZbg
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagCycleFlagSet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * ACegp`FbN[NZbg
 *
 * @param	dat		obOʂ̃f[^
 * @param	icwk	ACegp`FbN[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_ItemUseCheckSet( BAG_DATA * dat, void * icwk );

//--------------------------------------------------------------------------------------------
/**
 * ACegp|Pʒuݒ
 *
 * @param	dat			obOʂ̃f[^
 * @param	use_poke	gp|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_UsePokeSet( BAG_DATA * dat, u8 use_poke );

//--------------------------------------------------------------------------------------------
/**
 * }bv[hݒ
 *
 * @param	dat			obOʂ̃f[^
 * @param	map_mode	}bv[h
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAG_SysMapModeSet( BAG_DATA * dat, u16 map_mode );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾F݂̃|Pbgԍ
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	݂̃|Pbgԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BagSysNowPocketNumGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobOʂ̖
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obOʂ̖
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BagSysModeGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobOŎ擾ACe
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obOŎ擾ACe
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 BagSysReturnItemGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * OACegp|Pʒu擾
 *
 * @param	dat			obOʂ̃f[^
 *
 * @return	ACegp|Pʒu
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 Bag_UsePokeGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobO̖߂l
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obO̖߂l
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 BagSysReturnModeGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FJ[\ʒuAXN[JE^
 *
 * @param	dat		obOʂ̃f[^
 * @param	poke	|Pbgԍ
 * @param	cur		J[\ʒu
 * @param	scr		XN[JE^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagCursorPosGet( BAG_DATA * dat, u8 poke, u16 * cur, u16 * scr );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FJE^i`m[gpj
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	݂̃|Pbgԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BagSysSaleCntGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
GLOBAL PROC_RESULT BagProc_Init( PROC * proc, int * seq );

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
GLOBAL PROC_RESULT BagProc_Main( PROC * proc, int * seq );

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
GLOBAL PROC_RESULT BagProc_End( PROC * proc, int * seq );



//--------------------------------------------------------------------------------------------
/**
 * obOŎgpACẽbZ[WZbg
 *
 * @param	sv		Z[uf[^
 * @param	buf		bZ[WWJꏊ
 * @param	item	ACeԍ
 * @param	heap	q[vID
 *
 * @return	"TRUE = obOŎgpACe"
 * @return	"FALSE = ȊO"
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL BAG_ItemUseMsgSet( SAVEDATA * sv, STRBUF * buf, u16 item, u32 heap );


//--------------------------------------------------------------------------------------------
/**
 * ACegpG[bZ[WZbg
 *
 * @param	myst	v[[f[^
 * @param	buf		bZ[WWJꏊ
 * @param	item	ACeԍ
 * @param	err		G[ID
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAG_ItemUseErrorMsgSet( void * myst, STRBUF * buf, u16 item, u32 err, u32 heap );



#undef GLOBAL
#endif	/* BAG_H */
