//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_bg.h
 *	@brief		BGǗVXe
 *	@author		tomoya takahashi
 *	@data		2005.09.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __IMC_BG_H__
#define __IMC_BG_H__

#include <nnsys.h>
#include "bg_system.h"

#undef GLOBAL
#ifdef	__IMC_BG_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_BG_SCR_OFS	(128)	// XN[LN^ItZbg
#define IMC_BG_SCR_PLTT_OFS	(0x5)	// XN[pbgItZbg
#define IMC_BG_SCR_MAT_SX	(0)		// XN[XN[zuʒu
#define IMC_BG_SCR_MAT_SY	(0)		// XN[XN[zuʒu

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	BGf[^\	
//	
//=====================================
typedef struct {
	GF_BGL_INI* bg_ini;

	int arc_file;		// A[JCut@Cio[	
	int scrn_arc;		// XN[f[^CfbNX
	
	int x;			// XN[\tLN^ItZbg
	int y;			// XN[\tLN^ItZbg
	int width_char;	// 	LN^P
	int height_char;// 	LN^P
	int frame;		// BGt[
	int pltt_offs;	// pbgItZbgiԍj
	int pltt_num;	// pbg{
	int char_offs;	// LN^ItZbg	(LN^P)
} IMC_BG;

//-------------------------------------
//	
//	o^f[^
//	
//=====================================
typedef struct {
	GF_BGL_INI* bg_ini;

	int arc_file;		// A[JCut@Cio[	
	int char_arc;		// LN^f[^CfbNX
	int pltt_arc;		// pbgf[^CfbNX
	int scrn_arc;		// XN[f[^CfbNX
	
	int x;		// W	(0~255)
	int y;		// W	(0~255)
	int frame;	// BGt[
	int pltt_num;	// ]pbg{
	int pltt_offs;	// pbgItZbgiԍj
	int char_offs;	// LN^ItZbg

	int heap;			// gpq[v
} IMC_BG_ADD;

//-------------------------------------
//	
//	BGAj\
//	
//=====================================
typedef struct {
	const IMC_BG*		bg;		// bgf[^
	int scrn_arc01;		// XN[f[^CfbNX
	int timing;			// ύX^C~O
	int	count;			// ^E^
	int scrn_no;		// ̃XN[No
	int heap;			// gpq[v
} IMC_BG_ANM;

//-------------------------------------
//	
//	BGAjf[^\
//	
//=====================================
typedef struct {
	const IMC_BG*		bg;			// bgf[^
	int			scrn_arc;	// 2t[ڂBG
	int			timing;		// ύX^C~O
	int			heap;
} IMC_BG_ANM_INIT;




//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGf[^̓o^ & VKύX
 *
 *	@param	obj		BGIuWF
 *	@param	add		o^f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_BG_MakaObj( IMC_BG* obj, IMC_BG_ADD* add );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGf[^̔j
 *
 *	@param	obj		BGIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_BG_DeleteObj( IMC_BG* obj );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGAj[V
 *
 *	@param	anm		AjBGf[^i[
 *	@param	init	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_BG_AnmInit( IMC_BG_ANM* anm, IMC_BG_ANM_INIT* init );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Aj[VXV
 *
 *	@param	anm		Aj[VBG
 *	@param	frame	i߂t[l
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_BG_Anm( IMC_BG_ANM* anm, int frame );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGAjI
 *
 *	@param	anm		Aj[VBG
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_BG_AnmDelete( IMC_BG_ANM* anm );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGScroll܂B
 *
 *	@param	obj		\ĂBG
 *	@param	scr_bg	XN[BG
 *	@param	scr_x	XN[邘l
 *	@param	scr_y	XN[邙l
 *	@param	scr_syncXN[ɎgVN
 *	@param	end_flg	ImtO
 *
 *	@return	none
 *
 * ŏIIɂscr_bg̕BGʂɏo悤ɂȂ܂
 *
 * ܂BGf[^zu
 * 256x256
 * 128~255̕ɃLN^悤ɂȂĂKv܂B
 *
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_BG_ScrollReq( IMC_BG* obj, IMC_BG_ADD* scr_bg, int scr_x, int scr_y, int scr_sync, BOOL* end_flg );

#undef	GLOBAL
#endif		// __IMC_BG_H__

