//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_drawsys.h
 *	@brief		C[WNbv`VXef[^ǗVXe
 *				̃VXegp΁Aׂĕ`o悤ɂ܂B
 *	@author		tomoya takahashi
 *	@data		2005.09.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __IMC_DRAWSYS_H__
#define __IMC_DRAWSYS_H__

#include <nnsys.h>
#include "include/system/swsprite.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "system/softsprite.h"
#include "res_manager.h"
#include "bg_system.h"
#include "clact.h"
#include "include/system/clact_util.h"
#include "include/system/clact_util_res.h"
#include "include/system/clact_util_vram.h"

#undef GLOBAL
#ifdef	__IMC_DRAWSYS_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define	IMC_DRAW_USE_RES_NUM	(4)		// LN^@pbg@Z@ZAj

//-------------------------------------
//	
//	LN^f[^̎wʒuɐF
//	paramŖ`FbN
//	߂lp
//	
//=====================================
enum{
	IMC_DRAW_CHAR_CHECK_FALSE,
	IMC_DRAW_CHAR_CHECK_TRUE,
	IMC_DRAW_CHAR_CHECK_ERR,
};


//-------------------------------------
//	LN^f[^̃XN[\W
//=====================================


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	`f[^܂Ƃ߂\
//	
//=====================================
typedef struct {
	// XvCgf[^
	SWSP_SYS_PTR	SWSP_drawSys;		// XvCg`VXe
	SWSP_CHAR_PTR*	SWSP_charData;		// LN^f[^z
	int					SWSP_charNum;		// o^\ő吔
	int					SWSP_charNow;		// ̓o^
	SWSP_PLTT_PTR*	SWSP_plttData;		// pbgf[^z
	int					SWSP_plttNum;		// o^\ő吔
	int					SWSP_plttNow;		// ̓o^
	BOOL			SWSP_DrawFlag;			// `tO

	SOFT_SPRITE_MANAGER* SSM_drawSys;		// |P`pXvCg
	BOOL SSM_DrawFlag;						// |P`tO

	// ANZTppbgItZbge[u
	u8* accePlttOfsTbl;

	// ANZT|PpApbÑLN^f[^
	RES_MANAGER_PTR		SWSP_charRes;		// LN^f[^̃\[X	
	NNSG2dCharacterData** SWSP_UPchar;		// ApbÑf[^
	int					SWSP_UPcharNum;		// ApbÑf[^

	// BGf[^
	GF_BGL_INI*		BG_Ini;
	
	// OBJf[^
	CLACT_SET_PTR		clactSet;			// ZAN^[Zbg
	CLACT_U_RES_MANAGER_PTR	resMan[IMC_DRAW_USE_RES_NUM];	// \[X}l[W
	CLACT_U_EASYRENDER_DATA		renddata;	// ȈՃ_[f[^

} IMC_DRAW_DATA;

//-------------------------------------
//	
//	\[Xo^f[^
//	
//=====================================
typedef struct {
	// XvCg
	SWSP_CHARDATA* SWSP_charTbl;
	int	SWSP_charNum;
	SWSP_PLTTDATA* SWSP_plttTbl;
	int	SWSP_plttNum;

	// ̏Ŕj郊\[X̊i[
	RES_MANAGER_PTR		SWSP_charRes;		// LN^f[^̃\[X	
	RES_MANAGER_PTR		SWSP_plttRes;		// pbgf[^̃\[X	
} IMC_DRAW_LOADRES_DATA;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXe`o悤Ɋݒ肵܂
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_SetUp( void );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ݒ肵f[^j܂
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_PutBack( void );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`pVXe̐ݒs܂B
 *
 *	@param	drawData	`f[^
 *
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_InitSys( IMC_DRAW_DATA* drawData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXef[^j
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_DeleteSys( IMC_DRAW_DATA* drawData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`֐̂`VXe̕`
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_DrawSys( IMC_DRAW_DATA* drawData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[X̓ǂݍ݂s܂	XVramɓWJ܂
 *
 *	@param	drawData	`f[^i[̈
 *	@param	loadData	ǂݍރ\[Xf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_LoadResource( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[X̔js܂
 *
 *	@param	drawData	`f[^i[̈
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_DeleteResource( IMC_DRAW_DATA* drawData );


//----------------------------------------------------------------------------
/**
 *	@brief	AN^[o^
 *
 *	@param	drawData	[N
 *	@param	contid		ǗID
 *	@param	x			W
 *	@param	y			W
 *	@param	pri			D揇
 *	@param	draw_area	`GA
 *
 *	@return	AN^[[N
 */
//-----------------------------------------------------------------------------
GLOBAL CLACT_WORK_PTR IMC_DRAW_AddClact( IMC_DRAW_DATA* drawData, int contid, int x, int y, int pri, int draw_area );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^ǂݍ
 *
 *	@param	drawData		`VXef[^
 *	@param	fileIdx			t@CCfbNX
 *	@param	dataIdx			f[^CfbNX
 *	@param	comp			ktO
 *	@param	vramType		Vram^Cv
 *	@param	id				ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_CLACT_LoadCharData( IMC_DRAW_DATA* drawData, int fileIdx, int dataIdx, BOOL comp, int vramType, int id );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^ǂݍ
 *
 *	@param	drawData		`VXef[^
 *	@param	fileIdx			t@CCfbNX
 *	@param	dataIdx			f[^CfbNX
 *	@param	comp			ktO
 *	@param	vramType		Vram^Cv
 *	@param	load_num		pbgǂݍݐ
 *	@param	id				ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_CLACT_LoadPlttData( IMC_DRAW_DATA* drawData, int fileIdx, int dataIdx, BOOL comp, int vramType, int load_num, int id );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Zf[^ǂݍ
 *
 *	@param	drawData		`VXef[^
 *	@param	fileIdx			t@CCfbNX
 *	@param	dataIdx			f[^CfbNX
 *	@param	comp			ktO
 *	@param	id				ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_CLACT_LoadCellData( IMC_DRAW_DATA* drawData, int fileIdx, int dataIdx, BOOL comp, int id );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAjf[^ǂݍ
 *
 *	@param	drawData		`VXef[^
 *	@param	fileIdx			t@CCfbNX
 *	@param	dataIdx			f[^CfbNX
 *	@param	comp			ktO
 *	@param	id				ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_CLACT_LoadCellAnmData( IMC_DRAW_DATA* drawData, int fileIdx, int dataIdx, BOOL comp, int id );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^\[Xf[^݂̂̔j
 *
 *	@param	drawData	`VXef[^
 *	@param	id			ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_CLACT_DeleteCharRes( IMC_DRAW_DATA* drawData, int id );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbg\[Xf[^݂̂̔j
 *
 *	@param	drawData	`VXef[^
 *	@param	id			ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_CLACT_DeletePlttRes( IMC_DRAW_DATA* drawData, int id );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Z\[Xf[^݂̂̔j
 *
 *	@param	drawData	`VXef[^
 *	@param	id			ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_CLACT_DeleteCellRes( IMC_DRAW_DATA* drawData, int id );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAj\[Xf[^݂̂̔j
 *
 *	@param	drawData	`VXef[^
 *	@param	id			ǗID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_CLACT_DeleteCellAnmRes( IMC_DRAW_DATA* drawData, int id );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgp̓ǂݍރt@C쐬
 *
 *	@param	drawData	`VXef[^
 *	@param	loadData	쐬
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_MakeLoadSWSP_samp( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgp̓ǂݍ݃t@Cj
 *
 *	@param	loadData	ǂݍ݃f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_DestLoadSWSP( IMC_DRAW_LOADRES_DATA* loadData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^̓o^
 *
 *	@param	drawData	`f[^\
 *	@param	buff		LN^f[^obt@
 *	@param	char_no		o^LN^io[iANZTio[Linkj
 *
 *	@return	ApbÑLN^f[^
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL NNSG2dCharacterData* IMC_DRAW_SetCharData( IMC_DRAW_DATA* drawData, void* buff, int char_no );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ʏ펞̃EBhE}XNݒ
 *
 *	@param	none	
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_WndMaskNormalSet( void );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNg𓮂ĂƂ̃EBhE}XNݒ
 *
 *	@param	none	
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_WndMaskObjMoveSet( void );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN̕\D揇ʐݒ
 *
 *	@param	none	
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_EndCheckBGPri( void );

//-----------------------------------------------------------------------------
/**
*		LN^f[^āAقƂɂ̈ʒuɔFȊO̐FɂȂ
*		邩`FbN
*/
//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^̎wʒuɐFparamŖ`FbN
 *
 *	@param	char_data		`FbNɎgLN^f[^
 *	@param	offs_x			xItZbg
 *	@param	offs_y			yItZbg
 *	@param	param			`FbNFio[
 *
 *	@retval	IMC_DRAW_CHAR_CHECK_TRUE	param̐F
 *	@retval	IMC_DRAW_CHAR_CHECK_FALSE	param̐FȂ
 *	@retval	IMC_DRAW_CHAR_CHECK_ERR		G[
 *
 * PUF
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int IMC_DRAW_CharCheck( NNSG2dCharacterData* char_data, int offs_x, int offs_y, int param );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXepVuN֐
 *
 *	@param	drawData	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_VBlank( IMC_DRAW_DATA* drawData );

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTp\tgEFAXvCgf[^m
 *
 *	@param	drawData	ǂݍ݃f[^[N	
 *	@param	heap 
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_SWSPResDataAllocMemory( IMC_DRAW_LOADRES_DATA* loadData, int heap );

//-----------------------------------------------------------------------------
/**
 *		vC[p֐	
 *			C[WNbvȊÕVXegpĂ炤Ƃ́Å֐ŏȂǂsB
 *			܂Epbg̕\ɕKvȕ̂ݍ쐬悤ɂȂĂ܂B
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvvC[p	֐
 *	@param	drawData	`f[^
 *	@param	cp_swsp		C[WNbvp\tgEFAXvCgVXef[^
 *	@param	heap		q[vID
 *
 *	@retval	none
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_InitSysPlayer( IMC_DRAW_DATA* drawData, const SWSP_SYSDATA* cp_swsp, int heap );
GLOBAL void IMC_DRAW_InitSysPlayerBG( IMC_DRAW_DATA* drawData, GF_BGL_INI* BG_Ini, int heap );



//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXef[^j
 *
 *	@param	drawData	`f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_DeleteSysPlayer( IMC_DRAW_DATA* drawData );
GLOBAL void IMC_DRAW_DeleteSysPlayerBG( IMC_DRAW_DATA* drawData );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXepVuN֐
 *
 *	@param	drawData	`VXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_VBlankPlayer( IMC_DRAW_DATA* drawData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`֐̂`VXe̕`
 *
 *	@param	drawData	`f[^
 *	@param	center_x	S
 *	@param	center_y	S
 *	@param	rota_num	]p
 *	@param	p_scale		XP[xNg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_DRAW_DrawSysPlayer( IMC_DRAW_DATA* drawData, int center_x, int center_y, u16 rota_num, const VecFx32* p_scale );


//-----------------------------------------------------------------------------
/**
 *		previewVXep
 */
//-----------------------------------------------------------------------------
// previewVXe
GLOBAL void IMC_DRAW_InitSysPrev( IMC_DRAW_DATA* drawData, int heap );
GLOBAL void IMC_DRAW_DeleteSysPrev( IMC_DRAW_DATA* drawData );
GLOBAL void IMC_DRAW_VBlankPrev( IMC_DRAW_DATA* drawData );
GLOBAL void IMC_DRAW_DrawSysPrev( IMC_DRAW_DATA* drawData );



#undef	GLOBAL
#endif		// __IMC_DRAWSYS_H__

