//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_left_box.h
 *	@brief		{bNXVXe
 *	@author		tomoya takahashi
 *	@data		2005.09.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __IMC_LEFT_BOX_H__
#define __IMC_LEFT_BOX_H__

#include <nnsys.h>

#include "include/application/imageClip/imc_accessorie.h"
#include "include/application/imageClip/imc_obj_list.h"
#include "include/application/imageClip/imc_bg.h"
#include "include/application/imageClip/imc_item_buff.h"
#include "touchpanel.h"


#undef GLOBAL
#ifdef	__IMC_LEFT_BOX_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
//	
//	{bNXANZT\D揇ʊJn
//	
//=====================================
#define IMC_LBOX_ACCE_PRIORITY_START	(-1)



//-------------------------------------
//	
//	BGp
//	
//=====================================
#define	IMC_LBOX_BG_PLTT_NUM	(1)
#define IMC_LBOX_BG_PLTT_OFFS	(2)

//-------------------------------------
//	
//	̓
//	
//=====================================
enum{
	IMC_LBOX_STATE_NORM,	// ʏ
	IMC_LBOX_STATE_FADE,	// pbgtF[h
};

//-------------------------------------
//	
//	tF[h
//	
//=====================================
enum{
	IMC_LBOX_FADE_X = 1,
	IMC_LBOX_FADE_Y = 2
};

//-------------------------------------
//	
//	XgZӰ
//	
//=====================================
enum{
	IMC_LBOX_ADD_ONE,		// +1
	IMC_LBOX_SUB_ONE,		// -1
};

//-------------------------------------
//
//	pbgtF[hAEgp
//	Xg[h
//
//	tF[hAEgpXg
//	PȂł
//	
//	tF[hȂXg`悳邽
//=====================================
#define IMC_LBOX_FADELIST_MODE		(IMC_OBJLIST_ACCE_MAX)
#define IMC_LBOX_FADELIST_LISTNUM	(1)
#define IMC_LBOX_LIST_NUM			(IMC_LBOX_FADELIST_MODE + 1)


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	pbgXg
//	
//=====================================
typedef struct {
	IMC_OBJLIST*			dummyTbl;		// Xg_~[e[u
	int						dummyNum;		// _~[e[u
	int						dummyCurrent;	// ̃Jg_~[e[u
} IMC_LEFT_LIST_DATA;

//-------------------------------------
//	
//	{bNX\	
//	`敔
//	
//=====================================
typedef struct {
	// `VXef[^
	SWSP_SYS_PTR	SWSP_drawSys;		// XvCg`VXe
	SWSP_CHAR_PTR*	SWSP_charData;		// LN^f[^z
	SWSP_PLTT_PTR*	SWSP_plttData;		// pbgf[^z
	u8* accePlttOfsTbl;						// ANZTpbgItZbg
	
	// BGf[^
	GF_BGL_INI*		BG_Ini;
	
	// ANZTf[^
	IMC_ACCESSORIE_OBJ_TBL*	acce;
	
	// wif[^Xg
	IMC_BG	bg;
	IMC_ACCESSORIE_OBJ_TBL*	bg_acce;	// BGTlC
	
	// f[^Xg
	
} IMC_LEFT_BOXDRAW;

//-------------------------------------
//	
//	{bNX\̃f[^
//	
//=====================================
typedef struct {

	// ̕ҏW[h
	// ANZT	BG	TEh
	int		mode;

	// BGTlC\f[^
	IMC_ITEM_BUFF* p_item_buff;

	// IuWFNgXg
	IMC_OBJLIST_TBL* objListTbl;
	
	// ANZT[h̃Xgf[^
	// 擪_~[f[^
	// 擪_~[f[^
	// ̃Jg_~[f[^
	//
	IMC_LEFT_LIST_DATA	acce_list[ IMC_LBOX_LIST_NUM ];

	int	state;		// ̓ 
	int back_no;	// ̔wiio[
} IMC_LEFT_BOXDATA;


//-------------------------------------
//	
//	{bNXf[^
//	
//=====================================
typedef struct {

	IMC_LEFT_BOXDATA	boxData;
	IMC_LEFT_BOXDRAW	boxDraw;
} IMC_LEFT_BOX;



//-------------------------------------
//	
//	{bNX\	
//	
//=====================================
typedef struct {
	SWSP_SYS_PTR	SWSP_drawSys;		// XvCg`VXe
	SWSP_CHAR_PTR*	SWSP_charData;		// LN^f[^z
	SWSP_PLTT_PTR*	SWSP_plttData;		// pbgf[^z
	u8* accePlttOfsTbl;						// ANZTpbgItZbg
	
	// BGf[^
	GF_BGL_INI*		BG_Ini;

	IMC_ACCESSORIE_OBJ_TBL* acce;			// ANZTXgf[^
	IMC_OBJLIST_TBL*		objListTbl;		// IuWFNgXge[u
	int						accelist_num;	// 쐬ANZTXg
	int						bglist_num;		// 쐬BGTlCXg
	int						sndlist_num;	// 쐬TEhTlCXg

	IMC_ITEM_BUFF* p_item_buff;		// BG̕\f[^
} IMC_LEFT_BOX_INIT;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXp̈쐬
 *
 *	@param	lbox		{bNXpf[^
 *	@param	init		{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_InitSys( IMC_LEFT_BOX* lbox, IMC_LEFT_BOX_INIT* init );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNp̈j
 *
 *	@param	lbox		j鍶{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_DeleteSys( IMC_LEFT_BOX* lbox );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT[io[烊Xgio[擾
 *
 *	@param	mode			[h
 *	@param	accessorie_no	ANZTio[
 *
 *	@return	int		ANZT[Xgio[
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int IMC_LBOX_GetListNo( int mode, int accessorie_no, IMC_ITEM_BUFF* p_item_buff );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	[hƃANZTio[o^ĂׂW擾
 *
 *	@param	mode			[h
 *	@param	accessorie_no	ANZTio[
 *	@param	x				Wi[
 *	@param	y				Wi[
 *
 *	@return	none
 *	
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_GetMat( int mode, int accessorie_no, int* x, int* y, int size_x, int size_y, IMC_ITEM_BUFF* p_item_buff );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̐VKǉ
 *
 *	@param	lbox				{bNXpf[^
 *	@param	mode				ANZT[h
 *	@param	accessorie_no		ǉANZTio[
 *
 *	@return	none
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZT^Cv
	IMC_OBJLIST_BG,		// BGTlC^Cv
	IMC_OBJLIST_SND,		// TEhTlC^Cv
	IMC_OBJLIST_ACCE_MAX		// [hő吔
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_AddAccessorie( IMC_LEFT_BOX* lbox, int mode, int accessorie_no );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̈ړǉ
 *
 *	@param	lbox		{bNXpf[^
 *	@param	acce_obj	ANZTf[^
 *	@param	mode		ANZT[h
 *	@param	list_num	o^郊Xg
 *
 *	@return	none
 * 
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_AddAccessorieMove( IMC_LEFT_BOX* lbox, int mode, int list_num, IMC_OBJLIST* acce_obj );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTIuWFj
 *
 *	@param	acce_obj	jANZT
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_DeleteAccessorie( IMC_OBJLIST* acce_obj );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ړ邽߂̃Xg̍폜
 *
 *	@param	acce_obj	ړ邽߂ɃXg폜ANZTf[^
 *
 *	@return	none
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_DeleteAccessorieMove( IMC_OBJLIST* acce_obj );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	o^ĂANZTSĂ͂
 *
 *	@param	lbox	{bNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_DeleteAccessorieAll( IMC_LEFT_BOX* lbox );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTXgSĂ̍W𓮂
 *
 *	@param	lbox		{bNX
 *	@param	mode		[h
 *	@param	list_no		Xgio[
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_AccessorieListMove( IMC_LEFT_BOX* lbox, int mode, int list_no, int x, int y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXANZT̕\D揇ݒ
 *
 *	@param	lbox	ubN
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_SetAccessoriePriority( IMC_LEFT_BOX* lbox );

//----------------------------------------------------------------------------
/**
 *
 * ŃGtFNgs܂B
 *
 *	@brief	JgANZTXgύX
 *
 *	@param	lbox			{bNXf[^
 *	@param	mode			ANZT[h
 *	@param	list_num		ݒ肷JgANZTXg
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZT^Cv
	IMC_OBJLIST_BG,			// BGTlC^Cv
	IMC_OBJLIST_SND,		// TEhTlC^Cv
	IMC_LBOX_FADELIST_MODE	// tF[hpXg	list_num͂OŒ
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_LBOX_ChangeCurrentAccessorie( IMC_LEFT_BOX* lbox, int mode, int list_num );

//----------------------------------------------------------------------------
/**
 * ŃGtFNgs܂B
 *
 *	@brief	JgANZTXg̑Z
 *
 *	@param	lbox			{bNXf[^
 *	@param	mode			ANZT[h
 *	@param	add_mode		[h
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZT^Cv
	IMC_OBJLIST_BG,			// BGTlC^Cv
	IMC_OBJLIST_SND,		// TEhTlC^Cv
	IMC_LBOX_FADELIST_MODE	// tF[hpXg	list_num͂OŒ

	add_mode
		IMC_LBOX_ADD_ONE,		// +1
		IMC_LBOX_SUB_ONE,		// -1
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_LBOX_AddCurrentAccessorie( IMC_LEFT_BOX* lbox, int mode, int add_mode );

//----------------------------------------------------------------------------
/**
 *
 * GtFNgȂ
 *
 *	@brief	JgANZTXgݒ
 *
 *	@param	lbox			{bNXf[^
 *	@param	mode			ANZT[h
 *	@param	list_num		ݒ肷JgANZTXg
 *
 *	@return	none
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZT^Cv
	IMC_OBJLIST_BG,			// BGTlC^Cv
	IMC_OBJLIST_SND,		// TEhTlC^Cv
	IMC_LBOX_FADELIST_MODE	// tF[hpXg	list_num͂OŒ
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_SetCurrentAccessorie( IMC_LEFT_BOX* lbox, int mode, int list_num );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`pl{bNXɓĂ邩`FbN
 *
 *	@param	lbox		{bNXf[^
 *
 *	@retval	TRUE		qbg
 *	@retval	FALSE		qbg
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_LBOX_TPHit( IMC_LEFT_BOX* lbox );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wW{bNXɓĂ邩`FbN
 *
 *	@param	lbox		{bNXf[^
 *	@param	x			肘W
 *	@param	y			肙W
 *
 *	@retval	TRUE		qbg
 *	@retval	FALSE		qbg
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_LBOX_TPHitSelf( IMC_LEFT_BOX* lbox, int x, int y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTƂ̓蔻s
 *
 *	@param	lbox	{bNX
 *
 *	@return	none
 *
 *	JgANZTXg`FbN܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL IMC_OBJLIST* IMC_LBOX_TPHitAccessorie( IMC_LEFT_BOX* lbox );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTƂ̓蔻ׂs
 *
 *	@param	lbox	{bNX
 *	@param	offset_x	ItZbgW
 *	@param	offset_y	ItZbgW
 *	@param	SWSP_UPchar	LN^\[Xe[u
 *
 *	@return	none
 *
 *	JgANZTXg`FbN܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL IMC_OBJLIST* IMC_LBOX_TPHitAccessorieEx( IMC_LEFT_BOX* lbox, int* offset_x, int* offset_y, NNSG2dCharacterData** SWSP_UPchar );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BG\
 *
 *	@param	rbox		{bNX
 *	@param	bg_num		{bNXBGio[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_BGSet( IMC_LEFT_BOX* lbox, int bg_num );

//----------------------------------------------------------------------------
/**
 * GtFNgt
 *
 *	@brief	{bNXwiύX
 *
 *	@param	lbox		{bNf[^
 *	@param	bg_num		ύXBGio[
 *	@param	fade_way	tF[h
 *	@param	sync		VNōs
 *	@param	end_flg		ImtO
 *
 *	@return	none
 *
 * fade_way
	IMC_LBOX_FADE_X = 1,
	IMC_LBOX_FADE_Y = 2
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_BGChange( IMC_LEFT_BOX* lbox, int bg_num, int fade_way, int sync, BOOL* end_flg );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGN[
 *
 *	@param	lbox		{bNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_LBOX_BGClean( IMC_LEFT_BOX* lbox );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	݂̃[h
 *
 *	@param	lbox	{bNX
 *
 *	@return	ANZT[h
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZT^Cv
	IMC_OBJLIST_BG,			// BGTlC^Cv
	IMC_OBJLIST_SND,		// TEhTlC^Cv
	IMC_LBOX_FADELIST_MODE	// tF[hpXg	list_num͂OŒ
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int IMC_LBOX_GetMode( IMC_LEFT_BOX* lbox );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	[hƂ̃Jg_~[e[uio[擾
 *
 *	@param	lbox	{bNXf[^
 *	@param	mode	ׂ[h
 *	
 *	@return	Jg_~[e[uio[
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int IMC_LBOX_GetCurrentNo( IMC_LEFT_BOX* lbox, int mode  );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	_~[e[u擾
 *
 *	@param	lbox		{bNXIuWF
 *	@param	mode		ANZT[h
 *
 *	@return	_~[e[u
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int IMC_LBOX_GetDummyTblNum( IMC_LEFT_BOX* lbox, int mode );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bN󂵂Ă悢ԂȂ̂`FbN
 *
 *	@param	lbox	{bNXf[^
 *
 *	@retval	TRUE	OK
 *	@retval FALSE	NG		tF[hł
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_LBOX_ENDCheck( IMC_LEFT_BOX* lbox );
	
#undef	GLOBAL
#endif		// __IMC_LEFT_BOX_H__
