//============================================================================================
/**
 * @file	namein.h
 * @bfief	O͉ʏ
 * @author	Akito Mori
 * @date	05.10.05
 */
//============================================================================================
#ifndef _NAMEIN_H_
#define _NAMEIN_H_

#include "gflib/strbuf.h"
#include "poketool/boxdata.h"
#include "savedata/config.h"

//============================================================================================
//	萔`
//============================================================================================

// O̓[h
enum {
	NAMEIN_MYNAME = 0,	// ̖O
	NAMEIN_POKEMON,		// |P̖O
	NAMEIN_BOX,			// {bNX̖O
	NAMEIN_RIVALNAME,	// Col[
	NAMEIN_FRIENDCODE,	// ƂR[h
	NAMEIN_RANDOMGROUP, // ̎O[v̖O
	NAMEIN_STONE,		// Δ(zzj
	NAMEIN_FRIENDNAME,  // WIFIƂ蒠ɏނƂ̖O
};


// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/06/27
// ؍łmakeɑΉ

// |PO͂̒
#if (PM_LANG==LANG_JAPAN) || (PM_LANG==LANG_KOREA)
#define NAMEIN_POKEMON_LENGTH	(  5 )
#else
#define NAMEIN_POKEMON_LENGTH	( 10 )
#endif

// g[i[͂̒
#if (PM_LANG==LANG_JAPAN) || (PM_LANG==LANG_KOREA)
#define NAMEIN_PERSON_LENGTH	(  5 )
#else
#define NAMEIN_PERSON_LENGTH	( 7 )
#endif


// O[v͂̒
#if (PM_LANG==LANG_JAPAN) || (PM_LANG==LANG_KOREA)
#define NAMEIN_GROUP_LENGTH		(  5 )
#else
#define NAMEIN_GROUP_LENGTH		( 7 )
#endif

// ----------------------------------------------------------------------------





#define STRBUF_ENABLE_MAGICNUMBER	(0x12345678)


extern const PROC_DATA NameInProcData;	// vZX`f[^


typedef struct NAMEIN_WORK NAMEIN_WORK;	// |C^QƂł閼O̓[N\

// O͌ĂяoɕKvȃp[^̍\
// NAMEIN_PARAM *NameIn_ParamAllocMake(int HeapId, int mode, int info, int wordmax)
// Ăяoč쐬B
// B
typedef struct{
	int mode;		// ̓[h(enumQƁj
	int info;		// ̓[hƂĒjlElA|P̊JNOȂ
	int form;		// ̓[h|P̎Ɍ`l󂯎
	int wordmax;	// ͕ő吔
	int sex;		// |P̐(PARA_MALE=0...PARA_FEMALE=1...PARA_UNK=2(ʂȂ))


	int cancel;		// O͂IɔftOB
					// ͕OB͍ŏƓꍇ͂̃tOB

	STRBUF *strbuf; // STRBUFɂ͂Q̈Ӗ݂B
					// P͖O͉ʂf[^󂯎郏[Nł邱ƁBO͂I炱Rs[
					// P́AO͂ɍsƂɂɕi[Ă,
					// O͉ʂ͂̕\ȂJnBƂĂ@\

	u16 str[20];	// ̔zɂʂ͕ԂĂ܂Bi20ɈӖ͂܂j


	// --------|PߊlŃ{bNX]ɂȂɕKv-------------
	
	int get_msg_id; 	// |Pߊl̎BOX]̃bZ[WID
	BOX_DATA  *boxdata;	// |Pߊl̎BOX]ɁABOX̖O擾邽߂ɕKv
	CONFIG    *config;  // RtBO\

}NAMEIN_PARAM;

//==============================================================================
/**
 * O疼O͏p[^[炢[NĕԂ
 *
 * @param   HeapId		[N쐬HEAPIDwiFreeKv܂j
 * @param   mode		O̓[hienumIj
 * @param   info		jE(PM_MALE,PM_FEMALE)A|P̊JNOȂǂi[ABOX0ł悢
 * @param   wordmax		͕ő吔
 *
 * @retval  NAMEIN_PARAM *	̃|C^NameInInitɓn
 */
//==============================================================================
extern NAMEIN_PARAM* NameIn_ParamAllocMake(int HeapId, int mode, int info, int wordmax, CONFIG *config);

//==============================================================================
/**
 * O̓p[^[폜
 * O͏IɎQƂIɂ̊֐ĂяoĉĂB
 * 
 * @param   param			
 *
 * @retval  extern void		
 */
//==============================================================================
extern void NameIn_ParamDelete(NAMEIN_PARAM *param);

#endif