//============================================================================================
/**
 * @file	pms_input.h
 * @bfief	ȈՉb͉
 * @author	taya
 * @date	06.01.20
 */
//============================================================================================
#ifndef __PMS_INPUT_H__
#define __PMS_INPUT_H__

#include "system/procsys.h"
#include "savedata/savedata_def.h"
#include "system/pms_data.h"


//------------------------------------------------------
/**
 *  ͉ʗpp[^^
 */
//------------------------------------------------------
typedef  struct _PMSI_PARAM		PMSI_PARAM;

//------------------------------------------------------
/**
 *  ̓[h
 */
//------------------------------------------------------
enum PMSI_MODE {
	PMSI_MODE_SINGLE,	///< PP[h
	PMSI_MODE_DOUBLE,	///< PQ[h
	PMSI_MODE_SENTENCE,	///< ̓[h
};


//------------------------------------------------------
/**
 *  ^Cv
 */
//------------------------------------------------------
enum PMSI_GUIDANCE {
	PMSI_GUIDANCE_DEFAULT,		///< ėpIȕ
	PMSI_GUIDANCE_BATTLE_READY,	///< ΐO
	PMSI_GUIDANCE_BATTLE_WON,	///< ̃Rg
	PMSI_GUIDANCE_BATTLE_LOST,	///< ƂRg
	PMSI_GUIDANCE_TREND,		///< s
};


//------------------------------------------------------
/**
 *  ̑̊֘A萔
 */
//------------------------------------------------------
enum {
	PMS_INPUT_WORD_MAX = 2,		///< ͉\ȒPő吔
};


//------------------------------------------------------
/**
 *  ȈՉb͉ʗpp[^֐
 */
//------------------------------------------------------

//------------------------------------------------------------------
/**
 * ȈՉb͉ʃp[^쐬
 *
 * @param   input_mode			̓[hienum PMSI_MODEj
 * @param   guidance_type		^Cvienum PMSI_GUIDANCEj
 * @param   savedata			Z[uf[^|C^
 * @param   heapID				쐬pq[vID
 *
 * @retval  PMSI_PARAM*			쐬ꂽp[^IuWFNgւ̃|C^
 */
//------------------------------------------------------------------
extern PMSI_PARAM*  PMSI_PARAM_Create( u32 input_mode, u32 guidance_type, SAVEDATA* savedata, u32 heapID );

//------------------------------------------------------------------
/**
 * ȈՉb͉ʃp[^j
 *
 * @param   p		p[^IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
extern void PMSI_PARAM_Delete( PMSI_PARAM* p );



//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏ԂɎgpp[^ZbgiPP[hpj
 *
 * @param   p			p[^IuWFNg
 * @param   word		ZbgȈՉbPR[h
 *
 */
//------------------------------------------------------------------
extern void PMSI_PARAM_SetInitializeDataSingle( PMSI_PARAM* p, PMS_WORD word );

//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏ԂɎgpp[^ZbgiPQ[hpj
 *
 * @param   p			p[^IuWFNg
 * @param   word0		ZbgȈՉbPR[hP
 * @param   word1		ZbgȈՉbPR[hQ
 *
 */
//------------------------------------------------------------------
extern void PMSI_PARAM_SetInitializeDataDouble( PMSI_PARAM* p, PMS_WORD word0, PMS_WORD word1 );

//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏ԂɎgpp[^Zbgi̓[hpj
 *
 * @param   p		p[^IuWFNg
 * @param   pms		ZbgȈՉbf[^|C^
 *
 */
//------------------------------------------------------------------
extern void PMSI_PARAM_SetInitializeDataSentence( PMSI_PARAM* p, const PMS_DATA* pms );


//------------------------------------------------------------------
/**
 * ԂύXȂĂA̓LZƂ݂ȂȂ悤ɂ
 *
 * @param   p		p[^IuWFNg
 *
 */
//------------------------------------------------------------------
extern void PMSI_PARAM_SetNotEditEgnore( PMSI_PARAM* p );

//------------------------------------------------------------------
/**
 * xʂ󂯎APxA͉ʗpp[^ƂĎg悤ɂ
 *
 * @param   p		p[^IuWFNg
 *
 */
//------------------------------------------------------------------
extern void PMSI_PARAM_SetReuseState( PMSI_PARAM* p );

//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏IA͂LZꂽǂ`FbN
 *
 * @param   p			p[^IuWFNg
 *
 * @retval  BOOL		TRUEŃLZꂽ
 */
//------------------------------------------------------------------
extern BOOL PMSI_PARAM_CheckCanceled( const PMSI_PARAM* p );

//------------------------------------------------------------------
/**
 * ȈՉb͉ʂ̏IAԂύXȂꂽ`FbN
 *
 * @param   p			p[^IuWFNg
 *
 * @retval  BOOL		TRUEŕύXꂽ
 */
//------------------------------------------------------------------
extern BOOL PMSI_PARAM_CheckModified( const PMSI_PARAM* p );



//------------------------------------------------------------------
/**
 * ͉ʂœ͂ꂽf[^擾iPP[hj
 *
 * @param   p			p[^IuWFNg
 *
 * @retval  PMS_WORD		̓f[^iPR[hj
 */
//------------------------------------------------------------------
extern PMS_WORD  PMSI_PARAM_GetInputDataSingle( const PMSI_PARAM* p );

//------------------------------------------------------------------
/**
 * ͉ʂœ͂ꂽf[^擾iPQ[hj
 *
 * @param   p		p[^IuWFNg
 * @param   dst		͂ꂽf[^󂯎obt@
 *
 */
//------------------------------------------------------------------
extern void PMSI_PARAM_GetInputDataDouble( const PMSI_PARAM* p,  PMS_WORD* dst );

//------------------------------------------------------------------
/**
 * ͉ʂœ͂ꂽf[^擾i̓[hj
 *
 * @param   p		p[^IuWFNg
 * @param   pms		͂ꂽf[^󂯎\̃AhX
 *
 */
//------------------------------------------------------------------
extern void PMSI_PARAM_GetInputDataSentence( const PMSI_PARAM* p, PMS_DATA* pms );









//------------------------------------------------------
/**
 *  ȈՉb͉PROC֐
 */
//------------------------------------------------------
extern PROC_RESULT PMSInput_Init( PROC * proc, int * seq );
extern PROC_RESULT PMSInput_Main( PROC * proc, int * seq );
extern PROC_RESULT PMSInput_Quit( PROC * proc, int * seq );



#endif
