/**
 *	@file	poru_tool.h
 *	@brief	|gc[
 *	@author	Miyuki Iwasawa
 *	@date	06.03.14
 */

#ifndef __H_PORU_TOOL_H__
#define __H_PORU_TOOL_H__

#include "savedata/savedata_def.h"
#include "savedata/poruto_util.h"
#include "savedata/mystatus.h"
#include "system/gamedata.h"
#include "itemtool/myitem.h"
#include "poketool/pokeparty.h"
#include "application/p_status.h"
#include "application/pokelist.h"

typedef enum{
 PORU_FAVOLITE_SUKI,	///<D
 PORU_FAVOLITE_KIRAI,	///<LC
 PORU_FAVOLITE_NRM,		///<
}PORU_FAVOLITE;

///|gf[^Xg\
typedef struct _PORU_LIST{
	u8	id;			///f[^ID
	u8	level;		///<|g̃x
	u8	flavor;		///<|g̎
	u8	taste;		///<Ȃ߂炩

	union{
		struct{
		u8	spicy:1;	///<Ă閡
		u8	astr:1;
		u8	sweet:1;
		u8	bitter:1;
		u8	sour:1;
		u8	view:1;	///<`tO
		u8	del:1;		///<폜tO
		u8	valid:1;	///<L/tO
		};
		u8 flags;
	};
	u8	myid;
	u8	prev;
	u8	next;

//	STRBUF	*lvbuf;
}PORU_LIST;

///|gĂяo[N
typedef struct _PORUTO_PARAM{
	u8		porunum;	///<Ăяõ|g̐
	u8		selID;
	u8		ret_mode;	///<^[l
	u8		ret_view;	///<^[view[h
	u16		listPos;	///<Xg|WV
	u16		curPos;		///<J[\|WV
	
	PORUTO_BLOCK* poruSave;	///<|gZ[uf[^
	MYSTATUS	*mySave;	///<Xe[^X
	POKEPARTY	*ppSave;	///<|Pp[eB
	MYITEM		*itemSave;	///<ACe
	CONFIG		*configSave;	///<RtBO

	PORU_LIST	list[PORUTO_STOCK_MAX];	///<f[^
}PORUTO_PARAM;

///I[o[CvZXOQƐ錾
extern const PROC_DATA PorutoSysProcData;

/**
 *	@brief	|gVXeĂяo[Nf[^쐬
 *
 *	K PorutoSys_ReleaseCallWork()֐ŉ邱ƁI
 */
extern PORUTO_PARAM* PorutoSys_CreateCallWork(SAVEDATA* savedata,int heapID);

/**
 *	@brief	|gP[XĂяo[N
 */
extern void PorutoSys_ReleaseCallWork(PORUTO_PARAM* pp);

/**
 *	@brief	|gf[^Ɛi炻̃|gDԂ
 */
extern PORU_FAVOLITE PoruSys_IsFavolite(PORUTO_DATA *dat,u8 seikaku);

/**
 *	@brief	|gp[^|Pp[^Push
 */
extern void PoruSys_PoruPara2Poke(PORUTO_DATA* dat,POKEMON_PARAM* poke);

/**
 *	@brief	iǂ̖DԂ
 *
 *	@param	|P̐iNo
 *	@param	mode	PORU_FAVOLITE_SUKI:DȖ^CvԂ
 *					PORU_FAVOLITE_KIRAI:LCȖ^CvԂ
 *
 *	@retval	PORUTO_FTYPE_SPICY	h
 *	@retval	PORUTO_FTYPE_ASTR	Ԃ
 *	@retval	PORUTO_FTYPE_SWEET	܂
 *	@retval	PORUTO_FTYPE_BITTER	ꂢ
 *	@retval	PORUTO_FTYPE_SOUR	ς
 *	@retval	PORUTO_FTYPE_MIX	DȂ
 */
extern u8	PoruSys_GetFavolite(u8 seikaku,PORU_FAVOLITE mode);



#endif	//__H_PORU_TOOL_H__

