//============================================================================================
/**
 * @file	b_tower_data.h
 * @bfief	og^[p`
 * @author	HisashiSogabe/Miyuki Iwasawa
 * @date	06.04.20
 */
//============================================================================================

#ifndef __B_TOWER_H_
#define __B_TOWER_H_

//============================================================================================
/**
 *	f[^
 */
//============================================================================================

//og^[pg[i[f[^\
//g[i[Abf[^́AgmmŊǗig[i[ID擾j
typedef struct{
	u16		tr_type;				//g[i[^Cv
	u16		use_poke_cnt;			//gp\|P	
	u16		use_poke_table[1];		//gp\|PINDEXe[uiϒj
}B_TOWER_TRAINER_ROM_DATA;

//og^[p|Pf[^\
typedef struct{
	u16		mons_no;				//X^[io[
	u16		waza[WAZA_TEMOTI_MAX];	//Z
	u8		exp_bit;				//w͒lU蕪rbg
	u8		chr;					//i
	u16		item_no;				//
	u16		dummy;					//4oCgE␳
}B_TOWER_POKEMON_ROM_DATA;

//============================================================================================
/**
 *	Wifif[^
 */
//============================================================================================
/**
 * @biref	^[p|Pf[^^
 * Z[uf[^Ƃ肷̂savedata/b_tower.htypedef`؂
 * sS|C^łł悤ɂĂ
 */
struct _B_TOWER_POKEMON{
	union{
		struct{
			u16	mons_no:11;	///<X^[io[
			u16	form_no:5;	///<X^[io[
		};
		u16	mons_param;
	};
	u16	item_no;	///<

	u16	waza[WAZA_TEMOTI_MAX];		///<Z

	u32	id_no;					///<IDNo
	u32	personal_rnd;			///<

	union{
		struct{
		u32	hp_rnd		:5;		///<HPp[
		u32	pow_rnd		:5;		///<POWp[
		u32	def_rnd		:5;		///<DEFp[
		u32	agi_rnd		:5;		///<AGIp[
		u32	spepow_rnd	:5;		///<SPEPOWp[
		u32	spedef_rnd	:5;		///<SPEDEFp[
		u32	ngname_f	:1;		///<NGl[tO
		u32				:1;		//1ch ]
		};
		u32 power_rnd;
	};

	union{
		struct{
		u8	hp_exp;				///<HPw͒l
		u8	pow_exp;			///<POWw͒l
		u8	def_exp;			///<DEFw͒l
		u8	agi_exp;			///<AGIw͒l
		u8	spepow_exp;			///<SPEPOWw͒l
		u8	spedef_exp;			///<SPEDEFw͒l
		};
		u8 exp[6];
	};
	union{
		struct{
		u8	pp_count0:2;	///<Z1|CgAbv
		u8	pp_count1:2;	///<Z2|CgAbv
		u8	pp_count2:2;	///<Z3|CgAbv
		u8	pp_count3:2;	///<Z4|CgAbv
		};
		u8 pp_count;
	};

	u8	country_code;			///<R[h

	u8	tokusei;				///<
	u8	natuki;				///<Ȃx

	///jbNl[ ((MONS_NAME_SIZE:10)+(EOM_SIZE:1))*(STRCODE:u16)=22
	STRCODE	nickname[MONS_NAME_SIZE+EOM_SIZE];
};

//^[g[i[f[^
typedef struct _B_TOWER_TRAINER{
	u32		player_id;	///<g[i[ID
	u16		tr_type;	///<g[i[^Cv
	u16		dummy;		///<_~[
	STRCODE	name[PERSON_NAME_SIZE+EOM_SIZE];
	
	u16		appear_word[4];						//oꃁbZ[W	
	u16		win_word[4];						//bZ[W	
	u16		lose_word[4];						//sރbZ[W
}B_TOWER_TRAINER;

//og^[@ΐ푊f[^\
struct _B_TOWER_PARTNER_DATA{
	B_TOWER_TRAINER	bt_trd;			//g[i[f[^
	struct _B_TOWER_POKEMON	btpwd[4];		//|Pf[^
};


/**
 * @brief	Wifiog^[[_[f[^\
 * Z[uf[^Ƃ肷̂savedata/b_tower.htypedef`؂
 * sS|C^łł悤ɂĂ
 */
struct _B_TOWER_LEADER_DATA{
	STRCODE	name[PERSON_NAME_SIZE+EOM_SIZE];	//g[i[((PERSON_NAME_SIZE:7)+(EOM_SIZE:1))*(STRCODE:u16)=16

	u8		casette_version;				//JZbgo[W
	u8		lang_version;					//o[W
	u8		country_code;					//R[h
	u8		address;						//ZłƂ

	u8		id_no[4];						//!< vC[ID(u32^\̃TCY34ɂ邽u8[4]ɂĂ)
//	u32		id_no;							//IDNo	

	u16		leader_word[4];					//[_[bZ[W

	union{
		struct{
			u8	ngname_f:1;	//NGl[tO(onȂNGl[)
			u8	gender	:1;	//
			u8			:6;	//܂6bit
		};
		u8	flags;
	};
	u8	padding;							///<pfBO
};

/**
 *	@biref	^[AI}`yA̕ۑKvȃ|Pp[^
 *
 * Z[uf[^Ƃ肷̂savedata/b_tower.htypedef`؂
 * sS|C^łł悤ɂĂ
 */
struct _B_TOWER_PAREPOKE_PARAM{
	u32	poke_id;	///<|Pidۑ
	u16	poke_no[BTOWER_STOCK_PAREPOKE_MAX];	///<^[f[^|Pf[^Qindex0-999
	u32	poke_rnd[BTOWER_STOCK_PAREPOKE_MAX];	///<|P̌ۑ
};

#endif __B_TOWER_H_
