//=============================================================================
/**
 * @file	comm_command.h
 * @brief	f[^Lsꍇ̒ʐMVXe
 *          gpꍇɏޕKv̂܂Ƃ߂wb_[
 * @author	Katsumi Ohno
 * @date    2005.07.26
 */
//=============================================================================

#ifndef __COMM_COMMAND_H__
#define __COMM_COMMAND_H__


//==============================================================================
//	`
//==============================================================================

//==============================================================================
//	^錾
//==============================================================================
// R[obN֐̏
typedef void (*PTRCommRecvFunc)(int netID, int size, void* pData, void* pWork);
// TCYŒ̏ꍇTCY֐ŕԂ
typedef int (*PTRCommRecvSizeFunc)(void);
// Mobt@Ăꍇ̃|C^
typedef u8* (*PTRCommRecvBuffAddr)(int netID, void* pWork, int size);


typedef struct {
    PTRCommRecvFunc callbackFunc;    ///< R}hɌĂ΂R[obN֐
    PTRCommRecvSizeFunc getSizeFunc; ///< R}h̑Mf[^TCYŒȂ珑Ă
    PTRCommRecvBuffAddr getAddrFunc;
} CommPacketTbl;

#define   _SET(callfunc, getSize, name)       {callfunc,  getSize},

/// ėpʐMR}h̒`
enum CommCommand_e {
  CS_NONE = 0xee,                ///< ȂɂȂ
  CS_FREE = 0,                   ///< R}h
  CS_COMMAND_MIN = 1,             ///< ŏl
  CS_EXIT = CS_COMMAND_MIN,            ///< I
  CS_AUTO_EXIT,            ///< I
  CS_COMM_INFO,       ///< info
  CS_COMM_INFO_ARRAY,  ///< info𓊂Ԃ
  CS_COMM_INFO_END,   ///< info񑗐MI
  CS_COMM_NEGOTIATION,  ///< ̃lSVG[V
  CS_COMM_NEGOTIATION_RETURN,
  CS_DEBUG_VARIABLE,         ///< fobOpi{ԂŃR}hԍςȂ悤ɂ̂܂܂Ăj
  CS_DEBUG_START,            ///< fobOp ogX^[g
  CS_DSMP_CHANGE,            ///< DS[hʐMMP[hʐMɐ؂ւ鋖𓾂
  CS_DSMP_CHANGE_REQ,        ///< DS[hʐMMP[hʐMɐ؂ւwo
  CS_DSMP_CHANGE_END,        ///< DS[hʐMMP[hʐMɐ؂ւƂʒm
  CS_COMMAND_THROWOUT,       ///< R}hj鋖𓾂
  CS_COMMAND_THROWOUT_REQ,   ///< R}hjwo
  CS_COMMAND_THROWOUT_END,   ///< R}hjƂʒm-----
  CS_TIMING_SYNC,            ///< R}h
  CS_TIMING_SYNC_END,        ///< ꂽƂԂR}h
  CS_TIMING_SYNC_INFO,       ///< ̏󋵂q@ɕԂR}h
  CS_LIST_NO,                ///< DSp Iԍ𑗂肠
  CS_TOOL_TEMP,              ///< DSp ėpf[^]
  CS_WIFI_EXIT,
  //------------------------------------------------܂----------
  CS_COMMAND_MAX   // I[--------------͈ړȂł     21
};

#define COMM_VARIABLE_SIZE (0xffff)   ///< σf[^Mł邱ƂĂ


/// R}he[ȕ
extern void CommCommandInitialize(const CommPacketTbl* pCommPacketLocal,int listNum,void* pWork);
/// R}he[ůJ
extern void CommCommandFinalize( void );
/// f[^̃TCY𓾂
extern int CommCommandGetPacketSize(int command);
///  R}he[uj鎞̖
extern BOOL CommCommandThrowOut(void);
///  R}he[ujIǂ
extern BOOL CommCommandIsThrowOuted(void);
///  R[obNĂ
extern void CommCommandCallBack(int netID, int command, int size, void* pData);
/// vg
extern void CommCommandDebugPrint(int command);

// TCYwpȈՊ֐  eʍ팸̈extern錾  06.03.29
extern int _getVariable(void);
extern int _getZero(void);
extern int _getOne(void);

extern void* CommCommandCreateBuffStart(int command, int netID, int size);
extern BOOL CommCommandCreateBuffCheck(int command);


#endif// __COMM_COMMAND_H__

