//=============================================================================
/**
 * @file	comm_mp.h
 * @brief	ʐM̐ڑǗĂNX  comm_system.c 番
 * @author	Katsumi Ohno
 * @date    2006.01.25
 */
//=============================================================================

#ifndef _COMM_MP_H_
#define _COMM_MP_H_


#include "gflib/tcb.h" //TCB_PTR̂
#include "savedata/mystatus.h" //MYSTATUŜ

//==============================================================================
// extern錾
//==============================================================================

/// 
extern void CommMPInitialize(MYSTATUS* pMyStatus);
/// ʐMĂ邩ǂ
extern BOOL CommMPIsConnect(void);

//e@̏܂BȂɂq@҂܂
extern BOOL CommMPParentInit(BOOL bAlloc, BOOL bTGIDChange, BOOL bEntry);
// q@̏܂Bɐe@Tɍs܂
extern BOOL CommMPChildInit(BOOL bAlloc, BOOL bBconInit);
/// ʐMI
extern BOOL CommMPFinalize(void);
/// ʐMĂȂ̂܂ܐޏ
extern void CommMPStealth(BOOL bStalth);
// e@̐Ԃ܂
extern int CommMPGetParentCount(void);
// e@̃XLXgɍXVꍇTRUE
extern BOOL CommMPIsScanListChange(void);
// e@EtOZbg
extern void CommMPResetScanChangeFlag(void);
// e@݂ȂĂ䐔Ԃ
extern int CommMPGetParentConnectionNum(int index);
// Ɍqłl炻indexԂ܂
extern int CommMPGetFastConnectIndex(void);
// ̒iKŌqłl炻indexԂ܂
extern int CommMPGetNextConnectIndex(void);
// e@̖OMYSTATUSŕԂ܂B
extern void CommMPGetParentName(int index, MYSTATUS* pMyStatus);
// e@IDԂ܂
extern u32 CommMPGetPokeID(int index);
// q@@MPԂŐڑ-- CC_CONNECT_STARTINGAĂ琬ł
extern int CommMPChildNameAndIDConnect(STRBUF* pStrBuff, u32 pokeID);
// q@@f[^VFAOԂŐڑ-- TRUEAĂ琬ł
extern BOOL CommMPChildIndexConnect(u16 index);
// q@ e@BCOÑ^CAEgĎ܂
extern void CommMPParentBconCheck(void);

/// ʐM؂ւsieq]ɕKvȏj
extern BOOL CommMPSwitchParentChild(void);
/// ʐMؒf[hɓǂ
extern BOOL CommMPIsConnectStalth(void);
/// q@ȂǂmF
extern BOOL CommMPIsChildsConnecting(void);
/// e@ؒfꍇTRUE
extern BOOL CommMPParentDisconnect(void);
/// VRAMD̃CNj[̂Ă
extern void CommVRAMDFinalize(void);
/// VRAMD̃CNj[ݒJnĂ
extern BOOL CommIsVRAMDStart(void);
/// ʐMG[ǂ
extern BOOL CommMPIsError(void);
/// ł邩ǂ
extern BOOL CommMPIsInitialize(void);
/// q@ȂG[ɂꍇZbg
extern void CommMPSetNoChildError(BOOL bOn);
/// NɃG[ɂꍇZbg
extern void CommMPSetDisconnectOtherError(BOOL bOn);

/// r[Rf[^𓾂  폜\
extern WMBssDesc* CommMPGetWMBssDesc(int index);
/// r[R̃f[^NA
extern void ChildBconDataInit(void);
/// GFr[Rf[^𓾂
extern _GF_BSS_DATA_INFO* CommMPGetGFBss(int index);
/// r[Rf[^  폜\
extern void CommMPResetWMBssDesc(int index);
/// r[Rf[^
extern void CommMPResetGFBss(int index);


///BCONPMSf[^ ̊֐CommMPFlashMyBssĂԂƂŔf
extern void CommMPSetMyPMS(PMS_DATA* pPMS);
///BCOÑM[Vf[^ ̊֐CommMPFlashMyBssĂԂƂŔf
extern void CommMPSetMyRegulation(void* pRegulation);
///r[Rf[^Ɍ݂̏󋵂𔽉f
extern void CommMPFlashMyBss(void);

/// MYSTATUS𓾂
extern MYSTATUS* CommMPGetMyStatus(void);
/// BCONɊ܂܂MYSTATUSԂ
extern MYSTATUS* CommMPGetBconMyStatus(int index);

/// ؒf[hɓǂԂ
extern BOOL CommMPIsAutoExit(void);
/// ؒf[hON
extern void CommMPSetAutoExit(void);
/// WMʐMAChԂɂ邩ǂ
extern BOOL CommMPIsStateIdle(void);

extern void CommMPSetBackupMacAddress(u8* pMac, int netID);
/// T[rXԍ擾
extern int CommMPGetServiceNo(void);
/// Ct^C ܂͌ɖ߂
extern void CommMPSetLifeTime(BOOL bMinimum);

/// Cӂ̃T[rX̗pҐԂ܂
extern int CommMPGetServiceNumber(int serviceNo);
// vZX
extern void CommMpProcess(u16 bitmap);
// r[R𑗂ǂ
extern BOOL CommMPIsParentBeaconSent(void);

extern BOOL CommMPIsChildStateScan(void);

//   r[Rf[^ɎRɃf[^ڂ܂
extern void CommMPSetBeaconTempData(void* pData);
//   r[Rf[^f[^o܂
extern const void* CommMPGetBeaconTempData(int index);

// ֘AQ[̃r[RW
extern BOOL CommMPPartyGameScanChildInit(void);

// ڑ悤ƂĂ`lAڑ`l𓾂
extern int CommMPGetChannel(void);

extern void * CommMPGetMyGFBss(void);
extern int CommMPGetBConUncacheTime(int index);

extern int CommBmpListPosBconIndexGet(int index);

#endif // _COMM_MP_H_

