/*---------------------------------------------------------------------------*
  Project:  Wireless PassBy Library - include
  File:     wpb.h

  2005 Ambrella
 *---------------------------------------------------------------------------*/

#ifndef WPB_H_
#define WPB_H_

#ifdef __cplusplus
extern "C" {
#endif

/*===========================================================================*/

#include <nitro/types.h>
#include <nitro/math.h>
#include <nitro/wm.h>

/*---------------------------------------------------------------------------*
    \̒`
 *---------------------------------------------------------------------------*/

typedef enum WCStatus {
	WC_STATUS_READY = 0,               // 
	WC_STATUS_ERROR,                   // ǂɂȂȂG[
	WC_STATUS_BUSY,                    // ԑJڒɂrW[
	WC_STATUS_PARENT,                  // e@ƂĐڑςݏ
	WC_STATUS_CHILD,                   // q@ƂĐڑςݏ
	WC_STATUS_END,                     // I (Target̂)
	WC_STATUS_MAX
} WCStatus;

// APĨR[obNŕԂXe[gR[h
typedef enum WPBStateCode {
	WPB_STATECODE_START,        /* Ⴂҋ@Jn */
	WPB_STATECODE_PARENT_FOUND, /* e@𔭌 */
	WPB_STATECODE_CONNECTED,    /* ڑ */
	WPB_STATECODE_EXCHANGED,    /* f[^ */
	WPB_STATECODE_DISCONNECTED, /* ؒfʒm */
	WPB_STATECODE_END,          /* Ⴂҋ@I */
	WPB_STATECODE_MAX
} WPBStateCode;

// R[obN̈
typedef struct WPBCallback {
	u16             state;               // R[obN̔v
	u16             errcode;             // 񓯊̌
	u16             wlCmdID;             // G[ƂȂR}hID
	u16             wlResult;            // G[ƂȂvR[h
	const WMBssDesc *bssDesc;            // e@
	u16             bssDescCount;        // e@
	u8              macAddress[WM_SIZE_BSSID]; // ႢMACAhX
	const void      *extinfo;
	const void      *send_ptr;
	int             send_size;
	void            *recv_ptr;
	int             recv_size;
} WPBCallback;

// WPB APĨR[obŇ^
typedef void (*WPBCallbackFunc)(WPBCallback *arg);

// [NGA
#define PASS_PACKET_SIZE                 512
#define PASS_BUFFER_SIZE                 (PASS_PACKET_SIZE - 4)
#define WPBC_PARENT_DATA_SIZE_MAX        PASS_PACKET_SIZE
#define WPBC_CHILD_DATA_SIZE_MAX         PASS_PACKET_SIZE

#define WPB_RECEIVE_BUFFER \
	(MATH_MAX(WM_SIZE_MP_PARENT_RECEIVE_BUFFER(WPBC_PARENT_DATA_SIZE_MAX, \
											   1, FALSE), \
			  WM_SIZE_MP_CHILD_RECEIVE_BUFFER(WPBC_CHILD_DATA_SIZE_MAX, \
											  FALSE)))
#define WPB_SEND_BUFFER \
	(MATH_MAX(WM_SIZE_MP_PARENT_SEND_BUFFER(WPBC_PARENT_DATA_SIZE_MAX, \
											FALSE), \
			  WM_SIZE_MP_CHILD_SEND_BUFFER(WPBC_CHILD_DATA_SIZE_MAX, FALSE)))

typedef struct WPBBuf {
	WMParentParam pparaBuf;
	union {
		WMScanExParam param;
		u32           dummy[96 / sizeof(u32)]; /* fixme */
	} wmScanExParam;
	/* XLobt@ */
	u16           scanBuf[WM_SIZE_SCAN_EX_BUF / sizeof(u16) * 3];
	u16           recvBuf[WPB_RECEIVE_BUFFER / sizeof(u16)];
	u16           sendBuf[WPB_SEND_BUFFER / sizeof(u16)];
	u16           gameInfo[WM_SIZE_USER_GAMEINFO / sizeof(u16)];

	WPBCallbackFunc wpbCallback;
	WCStatus wcStatus;              // ݂̏ԂǗ
	WCStatus wcTarget;              // ԕύX̖ڕWǗ
	BOOL     wcSendFlag;            // MtO(ʏMP[h)
	u16      sChannel;
	u16      sChannelBusyRatio;
	BOOL     measure_channel_flag;
	/* e@ */
	u16             child_found_num;
	u16             pad_1; /* padding */
	u16             *current_bssdesc_ptr;
	/* ڑ̐e@BssDesc|C^(q@pf[^) */
	const WMBssDesc *parent_bssdesc_ptr;
} WPBBuf;

/*---------------------------------------------------------------------------*
    ֐`
 *---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*
  Name:         WPB_SetBuffer

  Description:  CuŎgpobt@w肷B
                WPB_SetGameInfȏOɌĂяoKvB

  Arguments:    wpbBuf       - ĂяoɂĊmۂꂽobt@ւ̃|C^w肷B
                               32oCgACĂKvB

  Returns:      WMErrCode    -   ʂԂB
                WM_ERRCODE_SUCCESS       : Ɋ
                WM_ERRCODE_INVALID_PARAM : ֐Ɏw肵p[^s
 *---------------------------------------------------------------------------*/
WMErrCode WPB_SetBuffer(WPBBuf *wpbBuf);

/*---------------------------------------------------------------------------*
  Name:         WPB_SetCallback

  Description:  R[obN֐ݒ肷B
                WPB_Start̑OɌĂяoKvB
                ̊֐̎sOɁAWPB_SetBufferĂяoKvB

  Arguments:    callback  -   [U[ւ̃R[obN֐iCxgɃR[obNj

  Returns:      WMErrCode    -   ʂԂB
                WM_ERRCODE_SUCCESS       : Ɋ
                WM_ERRCODE_FAILED : Ɏs (WPB_SetBufferĂяoĂȂ)
 *---------------------------------------------------------------------------*/
WMErrCode WPB_SetCallback(WPBCallbackFunc callback);

/*---------------------------------------------------------------------------*
  Name:         WPB_SetGameInfo

  Description:  e@ƂĕKvȃp[^ݒ肷B
                WPB_StartsOɁAK1xĂяoKvB
                Ⴂҋ@ɂĂяoB
                ̊֐̎sOɁAWPB_SetBufferĂяoKvB

  Arguments:    gameInfo       -   [U[Q[ւ̃|C^w肷B
                gameInfoLength -   [U[Q[̃TCYw肷B
                                   ő 112 oCg܂Ŏw肷邱ƂłB
                ggid           -   Q[O[vIDw肷B

  Returns:      WMErrCode    -   ʂԂB
                WM_ERRCODE_SUCCESS       : Ɋ
                WM_ERRCODE_FAILED : Ɏs (WPB_SetBufferĂяoĂȂ)
                WM_ERRCODE_ILLEGAL_STATE : łɂႢڑmAʐM
                WM_ERRCODE_INVALID_PARAM : ֐Ɏw肵p[^s
 *---------------------------------------------------------------------------*/
WMErrCode WPB_SetGameInfo(const u16 *gameInfo,
						  u16       gameInfoLength,
						  u32       ggid);
/*---------------------------------------------------------------------------*
  Name:         WPB_Start

  Description:  ႢʐMҋ@ԂɂBWMԂWM_READŶƂɎgp\B
                ̊֐̎sOɁAWPB_SetGameInfoĂяoKvB

  Arguments:    None.

  Returns:      WMErrCode    -   ʂԂB
                WM_ERRCODE_SUCCESS       : Ɋ
                WM_ERRCODE_ILLEGAL_STATE : łɂႢڑmAʐM
                WM_ERRCODE_INVALID_PARAM : ֐Ɏw肵p[^s
 *---------------------------------------------------------------------------*/
WMErrCode WPB_Start();

/*---------------------------------------------------------------------------*
  Name:         WPB_End

  Description:  ႢʐMҋ@ԂIB
                jbgւ̓d~߁AWM_READY Xe[gɈڍsB

  Arguments:    None.

  Returns:      WMErrCode    -   ʂԂB
                WM_ERRCODE_SUCCESS       : Ɋ
                WM_ERRCODE_ILLEGAL_STATE : ႢʐMҋ@łȂ
 *---------------------------------------------------------------------------*/
WMErrCode WPB_End(void);

int WPB_Finished(void);
void WPB_ForceFinish(void);


/*---------------------------------------------------------------------------*
  Name:         WPB_CheckParent

  Description:  e@̃XgAGGID v̂ԂB
                ݂ꍇ́A_ɑIB

  Arguments:    bssDesc       -  e@̏W
                bssDescCount  -  e@̐
                ggid          -  GGID

  Returns:      const WMBssDesc *  -  GGID ve@ԂBv̂Ȃꍇ NULL ԂB
 *---------------------------------------------------------------------------*/
const WMBssDesc *WPB_TestParent(const WMBssDesc *bssDesc,
								int bssDescCount, u32 ggid);

#ifdef  __cplusplus
}       /* extern "C" */
#endif

#endif /* WPB_H_ */

/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
