//==============================================================================
/**
 * @file	contest.h
 * @brief	ReXg̃wb_
 * @author	matsuda
 * @date	2005.11.16()
 */
//==============================================================================
#ifndef __CONTEST_H__
#define __CONTEST_H__

#include "battle/battle_common.h"
#include "system/buflen.h"
#include "field/field_common.h"
#include "poketool/poke_tool.h"
#include "system/wordset.h"
#include "savedata/mystatus.h"
#include "contest/actin_ex.h"

#include "contest/contest_def.h"

#include "include/application/imageClip/imc_playsys.h"

#include "contest/contest_conv.h"


//--------------------------------------------------------------
//	fobO`
//--------------------------------------------------------------
///쐬҂
#define WAIT_FIX		(0)		///<1:쐬ALB@0:܂쐬ĂȂ̂Ŗ

#define DEBUG_SIO_WAIT	(0)		///<1:ʐMpɋŃEFCg

///fobOj[̑I[h
enum{
	DEBUG_CON_VISUAL,
	DEBUG_CON_CLIP_VISUAL,
	DEBUG_CON_DANCE,
	DEBUG_CON_ACTIN,
	DEBUG_CON_RESULT,
//	DEBUG_CON_SIO,
};


//==============================================================================
//	萔`
//==============================================================================
///ReXgo[W
#define CONTEST_VERSION			(100)

///ReXgVXeMobt@TCY
///(e̎Mobt@ł͂ȂReXgVXe̎Mobt@ł邱Ƃɒ!)
#define CC_RECIEVE_BUF_MAX		(256)

///ReXg̋ʂŎgp郁bZ[WĨEBhE܂ł̃EFCg() check
#define CONTEST_MESSAGE_END_WAIT	0	//(20)

///ʐM̃bZ[Wx
#define CONTEST_SIO_MSG_SPEED		(1)	//(4)

//--------------------------------------------------------------
//	쒆̕
//--------------------------------------------------------------
enum{
	CON_CLASS_VISUAL,		///<rWA
	CON_CLASS_DANCE,		///<_X
	CON_CLASS_ACTIN,		///<Z
	CON_CLASS_RESULT,		///<ʔ\
};

//--------------------------------------------------------------
//	q[v
//--------------------------------------------------------------
///ReXgS̃VXeŎgpq[vTCY
#define CONTEST_ALLOC_SIZE		(0x3000 + 0x1000)	//+0x1000=؃bv{CXǉ
///Z͕Ŏgpq[vTCY
#define ACTIN_ALLOC_SIZE		(0x70000)
///rWAŎgpq[vTCY
#define VISUAL_ALLOC_SIZE		(0x70000)
///_XŎgpq[vTCY
#define DANCE_ALLOC_SIZE		(0xa0000)
///ʔ\Ŏgpq[vTCY
#define CONRES_ALLOC_SIZE		(0x70000)

///f[^Mpobt@TCY
#define CON_HUGEBUF_SIZE		(1024)

///QXgR̍őQ
#define GUEST_JUDGE_MAX			(1)
///ʂ̐R̍őQ
#define NORMAL_JUDGE_MAX		(2)
///R̍őQ
#define JUDGE_MAX				(GUEST_JUDGE_MAX + NORMAL_JUDGE_MAX)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///APln[gAN^[̍ő吔
#define APP_HEART_MAX				(6)
///APl̃n[g1ŎĂ|Cg
#define APP_APPEAL_ICON_ONE_POINT		(10)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///OBJpbgFPFDǗ{(pbgP)
#define CONTEST_MAIN_OBJPAL_NUM				(16 - 2)	//-2 = ʐMACR{[JCYp
///OBJpbgFPFDǗ{(J[P)
#define CONTEST_MAIN_OBJPAL_COLOR_NUM		(CONTEST_MAIN_OBJPAL_NUM * 16)
///OBJpbgFoCgTCY
#define CONTEST_MAIN_OBJPAL_SIZE			(CONTEST_MAIN_OBJPAL_COLOR_NUM * sizeof(u16))
///OBJpbgFtF[hbit
#define CONTEST_MAIN_OBJPAL_FADEBIT			(0x3fff)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///J̃tbVGtFNgEVYl
#define CON_CAMERA_FLASH_EVY			(4)	//12
///J̃tbVGtFNgɂt[
#define CON_CAMERA_FLASH_FRAME			(6)


//==============================================================================
//	\̒`
//==============================================================================

///Mp̌Œ蒷ׂ̍f[^Q
typedef struct{
	u8 player_sex;		///<vC[̐
	u8 character;		///<i
	u8 popularity;		///<lC
	u16 obj_code;		///<OBJR[h
}CON_ETC_SIO_DATA;

//--------------------------------------------------------------
/**
 * ReXgpC[WNbv֘A܂Ƃ߂\
 */
//--------------------------------------------------------------
typedef struct{
	IMC_PLAYERSYS_PTR imc_ptr;	///<C[WNbvvC[VXeւ̃|C^
	int x;						///<WX
	int y;						///<WY(W)
	int z;						///<WZ
}CONTEST_IMC_WORK;

//--------------------------------------------------------------
/**
 * CON_IMC_LOCAL\̓̒ʐMMf[^
 *
 * ̒gSđM܂
 */
//--------------------------------------------------------------
typedef struct{
	//-- MŎgobt@ --//
	u32 counter;			///<JEg_EMpobt@
	
	//-- M݂̂Ɏgobt@ --//
	u8 force_end;			///<ItO(TRUE:I)
}CON_IMC_LOCAL_SIO;

//--------------------------------------------------------------
/**
 * C[WNbvŎgp郏[N(ReXgVXeŎĂKv̂镨̂)
 * {IɒʐMpłB
 * M̂CON_IMC_LOCAL_SIO\̂̃f[^݂̂łB
 */
//--------------------------------------------------------------
typedef struct{
	CON_IMC_LOCAL_SIO recieve_sio;		///<Mobt@
	CON_IMC_LOCAL_SIO trans_sio;		///<Mobt@

	//-- }V̌ʂ̎Mpobt@ --//
	u8 recieve_force_end[BREEDER_MAX];	///<ItO(TRUE:I)

	//-- VXeIȃf[^ --//
	u8 server_no;				///<T[o[netID
	u8 my_net_id;				///<netID
	u8 sio_flag;				///<ʐMtO TRUE ʐM
	u8 player_num;				///<vC[l

//	u8 dummy[1];	///<4oCgEItZbg
}CON_IMC_LOCAL;

//--------------------------------------------------------------
/**
 * ReXg̊eŎ擾_
 */
//--------------------------------------------------------------
typedef struct{
	s16 bp;				///<u[_[|Cg(|bNœhÂh)
	s16 clip;			///<Nbv|Cg
	s16 dance;			///<_XŊl|Cg
	s16 actin;			///<Z͕Ŋl|Cg
	
	u8 final_ranking;	///<ŏIIȏ
	
	u8 dummy[3];
}CONTEST_SCORE;

//--------------------------------------------------------------
/**
 * @brief   ReXg:Q[isp[^
 *
 * ReXgisׂ̃p[^Ă܂B
 * ʐM̓T[o[q@̓f[^󂯎鎖ɂȂ܂B
 */
//--------------------------------------------------------------
typedef struct{
	POKEMON_PARAM *pp[BREEDER_MAX];	///<oꂷu[_[̃|Pf[^
	BREEDER_DATA bd[BREEDER_MAX];	///<u[_[f[^
	JUDGE_DATA jd[JUDGE_MAX];		///<Rf[^
	STRBUF *breeder_name_str[BREEDER_MAX];	///<u[_[(vC[)
	IMC_CONTEST_SAVEDATA *imc_data[BREEDER_MAX];	///<eu[_[̃Nbvf[^
	
	u8 player_sex[BREEDER_MAX];		///<u[_[̐
	u8 character[BREEDER_MAX];		///<u[_[̐i
	u8 popularity[BREEDER_MAX];		///<u[_[̐lC
	u16 obj_code[BREEDER_MAX];		///<OBJR[h
	
	u8 server_no;					///<T[o[̃u[_[ԍ
	u8 server_version;				///<T[o[̃ReXgo[W
	u8 special_judge_no;			///<RoRNo
	
	//-- 牺͎Ŏ擾\ȃf[^B͒ʐMŖႤf[^ --//
	u8 type;						///<CONTYPE_???
	u8 rank;						///<CONRANK_???
	u8 mode;						///<CONMODE_???
	u8 theme;						///<CON_IMAGE_THEME_???
	u8 my_breeder_no;				///<̃u[_[ԍ
	u8 my_net_id;					///<netID
	u8 my_version;					///<̃ReXgo[W
	u8 cpu_num;						///<CPU̐
	u8 player_num;					///<vC[̐

	//-- _FT[o[̂݌vZĕێBq@͊{IɎĂȂB --//
	//-- ʔ\ɌʂƂāAe瑗Ă܂ --//
	//-- (Cxgŏʂ⓾_gp邾낤 --//
	CONTEST_SCORE score[BREEDER_MAX];	///<eŊl_
	
}CONTEST_GAME_PARAM;

///J̃tbV䃏[NFXNvgŎgp
typedef struct{
	TCB_PTR tcb;
	const u8 *wait_tbl;		///<tbṼEFCge[uւ̃|C^
	s16 wait;
	u8 count;
	u8 seq;
	u8 breeder_no;
}CONSCR_CAMERA_FLASH;

//--------------------------------------------------------------
/**
 * @brief   ReXgVXe[N
 *
 * ReXgŜ̐isǗׂ̃[NłB
 * e}VɌʂɍ쐬܂B
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_GAME_PARAM c_game;		///<ReXgFQ[isp[^
	POKEPARTY *poke_party;			///<莝|P̍\
	void *perap_voice[BREEDER_MAX];	///<؃bv̖f[^ւ̃|C^
	void *class_proc;				///<݂̊̕Ǘ[Nւ̃|C^
	u8 class_flag;					///<ݎs̕(CON_CLASS_???)
	u8 sio_flag;					///<TRUEFʐM
	u8 actin_sort[BREEDER_MAX];		///<Z͕Jn̕я
	
	u8 seq;
	int work;
	int wait;
	TCB_PTR sio_tcb;
	
	//ʐM̑Mobt@
	u8 recieve_buf[CC_NETID_MAX][CC_RECIEVE_BUF_MAX];	///<Mobt@
	u8 recieve_count;				///<Mf[^󂯎lJEg
	u8 huge_buf[CON_HUGEBUF_SIZE];				///<f[^Mpobt@
	u8 recieve_huge_buf[CC_NETID_MAX][CON_HUGEBUF_SIZE];		///<f[^Mpobt@
	
	//RtBO
	const CONFIG *config;		///<RtBOf[^ւ̃|C^
	//Z[uf[^
	SAVEDATA *sv;				///<Z[uf[^ւ̃|C^
	POKEMON_PARAM *my_pp;		///<oꂳ鎩̎莝|Pւ̃|C^(tB[h)
								///<ŌɃ{ȂǂZbgׂɎĂ܂B
	const MYSTATUS *my_status;	///<}CXe[^Xւ̃|C^
	u8 temoti_pos;				///<oꂳ|P̎莝ʒu
	u8 hof_flag;				///<atO
	u8 zenkoku_zukan_flag;		///<S}ӃtO
	
	//C[WNbvʗp(ReXgł͎gp܂)
	IMC_SAVEDATA *imc_save;		///<C[WNbṽZ[uf[^ւ̃|C^
	CON_IMC_LOCAL imc_local;	///<C[WNbvŎgp郏[N
	void *icpw;					///<C[WNbvʍ\pf[^ւ̃|C^
	
	//XNvgŎgp郏[N
	CONSCR_CAMERA_FLASH *conscr_flash;		///<J̃tbV䃏[N
	
	//_̎ޔp[N
	u32 push_random_seed;		///<Cxgis̃_̎ޔp[N
}CONTEST_SYSTEM;


//--------------------------------------------------------------
/**
 * @brief   ReXgVXe쐬f[^
 */
//--------------------------------------------------------------
typedef struct{
	u8 type;							///<CONTYPE_???
	u8 rank;							///<CONRANK_???
	u8 mode;							///<CONMODE_???
	u8 hof_flag;						///<atO(TRUE:a肵Ă)
	u8 zenkoku_zukan_flag;				///<S}ӓtO(TRUE:肵Ă)
	u8 temoti_pos;				///<oꂳ|P̎莝ʒu
	POKEMON_PARAM *my_pp;				///<oꂳ鎩̎莝|Pւ̃|C^
	const STRBUF *player_name_str;		///<vC[ւ̃|C^
	const MYSTATUS *my_status;			///<}CXe[^Xւ̃|C^
	IMC_SAVEDATA *imc_save;				///<C[WNbvZ[uf[^[Nւ̃|C^
	const CONFIG *config;				///<RtBOւ̃|C^
	SAVEDATA *sv;						///<Z[uf[^ւ̃|C^
	void *perap_voice;					///<؃bv{CXւ̃|C^
}CONTEST_INIT_DATA;



//==============================================================================
//	O֐錾
//==============================================================================
extern u16 contest_rand(CONTEST_SYSTEM *consys);
extern u16 contest_fix_rand(u32 seed, u32 *new_seed);
extern CONTEST_SYSTEM * Contest_SystemCreate(const CONTEST_INIT_DATA *cid);
extern void Contest_SystemExit(CONTEST_SYSTEM *consys);
extern void ConScr_JudgeNameGet(CONTEST_SYSTEM *consys, int judge_no, 
	WORDSET *wordset, u32 buf_id);
extern void ConScr_BreederNameGet(CONTEST_SYSTEM *consys, int entry_no, WORDSET *wordset, 
	u32 buf_id);
extern void ConScr_NickNameGet(CONTEST_SYSTEM *consys, int entry_no, WORDSET *wordset, u32 buf_id);
extern void ConScr_RankNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id);
extern void ConScr_TypeNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id);
extern void ConScr_VictoryBreederNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id);
extern u32 ConScr_VictoryItemNoGet(CONTEST_SYSTEM *consys);
extern BOOL Contest_SioParamInitSet(CONTEST_SYSTEM *consys);
extern BOOL Contest_SioFastDataEndCheck(CONTEST_SYSTEM *consys);
extern void EventCmd_ContestProc(GMEVENT_CONTROL * event, CONTEST_SYSTEM *consys);
extern void ConScr_SioTimingSend(CONTEST_SYSTEM *consys, u8 timing_no);
extern BOOL ConScr_SioTimingCheck(CONTEST_SYSTEM *consys, u8 timing_no);
extern int ConScr_RankingCheck(CONTEST_SYSTEM *consys);
extern void ConScr_EndParamSet(CONTEST_SYSTEM *consys, SAVEDATA *sv, u32 place_id, 
	FNOTE_DATA *f_note);
extern void ConScr_VictoryNickNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, u32 buf_id);
extern int ConScr_VictoryEntryNoGet(CONTEST_SYSTEM *consys);
extern int ConScr_MyEntryNoGet(CONTEST_SYSTEM *consys);
extern int ConScr_OBJCodeGet(CONTEST_SYSTEM *consys, int entry_no);
extern int ConScr_PopularityGet(CONTEST_SYSTEM *consys, int entry_no);
extern int ConScr_DeskModeGet(CONTEST_SYSTEM *consys);
extern void ConScr_MsgPrintFlagSet(CONTEST_SYSTEM *consys);
extern void ConScr_MsgPrintFlagReset(CONTEST_SYSTEM *consys);
extern void ConScr_FlashTaskCreate(CONTEST_SYSTEM *consys, int entry_no);
extern BOOL ConScr_FlashTaskCheck(CONTEST_SYSTEM *consys);
extern void ConScr_VictoryParamGet(CONTEST_SYSTEM *consys, 
	int *victory_entry, int *sio_flag, int *cpu_flag, int *tutorial, int *practice);
extern void ConScr_EntryParamGet(CONTEST_SYSTEM *consys, u16 *rank, u16 *type, u16 *mode, 
	u16 *temoti_pos);
extern BOOL ConScr_HaveRibbonCheck(CONTEST_SYSTEM *consys);
extern void ConScr_RibbonItemNameGet(CONTEST_SYSTEM *consys, WORDSET *wordset, 
	u32 buf_id, int heap_id);
extern u32 ConScr_AcceNoGet(CONTEST_SYSTEM *consys);

//-- con_record.c --//
extern void * ContestSioRecord_Create( void * fsys );
extern void ContestSioRecord_Delete(void *con_rec);
extern void EventCmd_ConRecordDisp(GMEVENT_CONTROL *event);

//-- con_tool.c --//
extern void ConTool_MsgPrintFlagSet(int sio_flag);
extern void ConTool_MsgPrintFlagReset(void);

//-- con_battle.c --//
extern BOOL ContestPokeFlipCheck(u32 monsno);


#ifdef PM_DEBUG
extern void DebugContest_FieldConnectStart(FIELDSYS_WORK *fsys, int debug_mode);
#endif


#endif	//__CONTEST_H__

