//=============================================================================================
/**
 * @file	bg_sys.h
 * @brief	af`VXevO
 */
//=============================================================================================
#ifndef _BG_SYS_H_
#define _BG_SYS_H_

#undef GLOBAL
#ifdef __BG_SYS_H_GLOBAL__
#define GLOBAL /*	*/
#else
#define GLOBAL extern
#endif


//=============================================================================================
//	^錾
//=============================================================================================
//CETu@XN[w
#define GF_BGL_MAIN_DISP	(0)
#define GF_BGL_SUB_DISP		(1)

//[h`
#define GF_BGL_MODE_TEXT	(0)		// eLXg
#define GF_BGL_MODE_AFFINE	(1)		// AtB
#define GF_BGL_MODE_256X16	(2)		// AtBgBG

//afio[`
#define GF_BGL_FRAME0_M	(0)
#define GF_BGL_FRAME1_M	(1)
#define GF_BGL_FRAME2_M	(2)
#define GF_BGL_FRAME3_M	(3)
#define GF_BGL_FRAME0_S	(4)
#define GF_BGL_FRAME1_S	(5)
#define GF_BGL_FRAME2_S	(6)
#define GF_BGL_FRAME3_S	(7)

//afXN[TCY`
#define	GF_BGL_SCRSIZ_128x128		( 0 )
#define	GF_BGL_SCRSIZ_256x256		( 1 )
#define	GF_BGL_SCRSIZ_256x512		( 2 )
#define	GF_BGL_SCRSIZ_512x256		( 3 )
#define	GF_BGL_SCRSIZ_512x512		( 4 )
#define	GF_BGL_SCRSIZ_1024x1024		( 5 )

// f[^\`
#define GF_BGL_DATA_LZH	(0)

//afXN[[h`
#define GF_BGL_SCROLL_X_SET	(0)
#define GF_BGL_SCROLL_X_INC	(1)
#define GF_BGL_SCROLL_X_DEC	(2)
#define GF_BGL_SCROLL_Y_SET	(3)
#define GF_BGL_SCROLL_Y_INC	(4)
#define GF_BGL_SCROLL_Y_DEC	(5)

// gkE]ύXp[^
enum {
	GF_BGL_RADION_SET = 0,	// ]pxύXiw肵lZbgj
	GF_BGL_RADION_INC,		// ]pxύXiw肵l{j
	GF_BGL_RADION_DEC,		// ]pxύXiw肵l|j

	GF_BGL_SCALE_X_SET,		// XgkύXiw肵lZbgj
	GF_BGL_SCALE_X_INC,		// XgkύXiw肵l{j
	GF_BGL_SCALE_X_DEC,		// XgkύXiw肵l|j

	GF_BGL_SCALE_Y_SET,		// YgkύXiw肵lZbgj
	GF_BGL_SCALE_Y_INC,		// YgkύXiw肵l{j
	GF_BGL_SCALE_Y_DEC,		// YgkύXiw肵l|j

	GF_BGL_CENTER_X_SET,	// ]SXWύXiw肵lZbgj
	GF_BGL_CENTER_X_INC,	// ]SXWύXiw肵l{j
	GF_BGL_CENTER_X_DEC,	// ]SXWύXiw肵l|j

	GF_BGL_CENTER_Y_SET,	// ]SYWύXiw肵lZbgj
	GF_BGL_CENTER_Y_INC,	// ]SYWύXiw肵l{j
	GF_BGL_CENTER_Y_DEC,	// ]SYWύXiw肵l|j
};

//afXN[f[^ߐsp`
#define GF_BGL_SCRWRT_PALNL		(16)	//pbgiXN[f[^pj
#define GF_BGL_SCRWRT_PALIN		(17)	//pbgi]Ƀpbgf[^݁j

//BGXN[f[^̃obt@[h`
#define GF_BGL_MODE_1DBUF		(0)		//ʏ1zf[^
#define GF_BGL_MODE_2DBUF		(1)		//܂ԂL2?zf[^

//rbg}bvVtgp`
#define	GF_BGL_BMPWIN_SHIFT_U	(0)
#define	GF_BGL_BMPWIN_SHIFT_D	(1)
#define	GF_BGL_BMPWIN_SHIFT_L	(2)	//
#define	GF_BGL_BMPWIN_SHIFT_R	(3)	//

//rbg}bvݗp`
#define	GF_BGL_BMPPRT_NOTNUKI	( 0xffff )	// FwȂ

// rbg}bvCfbNXl
#define	GF_BGL_BITMAP_NULL	(0xff)

// BitmapWindow̃rbg[h
enum {
	GF_BGL_BMPWIN_BITMODE_4 = 0,
	GF_BGL_BMPWIN_BITMODE_8 = 1,
};


//--------------------------------------------------------------------
//afVXe\
typedef struct {
	GXDispMode 	dispMode;		//\[hw
	GXBGMode	bgMode;			//af[hw(CXN[)
	GXBGMode	bgModeSub;		//af[hw(TuXN[)
	GXBG0As		bg0_2Dor3D;		//afÔQcARc[hI
}GF_BGL_SYS_HEADER;

//--------------------------------------------------------------------
//afRg[ݒ\
typedef struct {
	int		scrollX;		//\wݒ
	int		scrollY;		//\xݒ
	u32		scrbufferSiz;	//XN[obt@TCY( 0 = gpȂ )
	u32		scrbufferOfs;	//XN[obt@ItZbg

    u8		screenSize;		//XN[TCY
    u8		colorMode;		//J[[h
    u8		screenBase;		//XN[x[XubN
    u8		charBase;		//LN^x[XubN
    u8		bgExtPltt;		//afgpbgXbgI
	u8		priority;		//\vCIeB[
	u8		areaOver;		//GAI[o[tO
	u8		dummy;			//
	BOOL	mosaic;			//UCNݒ

}GF_BGL_BGCNT_HEADER;

//--------------------------------------------------------------------
//rbg}bv`f[^\
typedef struct{
	const u8 *adrs;		///<LN^f[^̐擪AhX
	u16	size_x;			///<LN^f[^XTCY
	u16	size_y;			///<LN^f[^YTCY
}BMPPRT_HEADER;

//--------------------------------------------------------------------
///rbg}bvXgpf[^\
typedef struct{
	u8	frm_num;	///<EChEgpt[
	u8	pos_x;		///<EChË̍XWiLPʂŎwj
	u8	pos_y;		///<EChË̍YWiLPʂŎwj
	u8	siz_x;		///<EChËXTCYiLPʂŎwj
	u8	siz_y;		///<EChËYTCYiLPʂŎwj
	u8	palnum;		///<EChË̃pbgio[
	u16	chrnum;		///<EChEL̈̊JnLN^io[
}BMPWIN_DAT;


typedef struct _GF_BGL_INI	GF_BGL_INI;


///rbg}bvEBhEݒ\
typedef struct {
	GF_BGL_INI * ini;
	u8		frmnum;
	u8		posx;
	u8		posy;
	u8		sizx;
	u8		sizy;
	u8		palnum;
	u16		chrofs : 15;
	u16		bitmode : 1;	
	void * chrbuf;
}GF_BGL_BMPWIN;


//--------------------------------------------------------------------
// BGʍĐݒp[^
enum {
	BGL_RESET_COLOR = 0,	// BGĐݒtOFJ[[h
	BGL_RESET_SCRBASE,		// BGĐݒtOFXN[x[X
	BGL_RESET_CHRBASE,		// BGĐݒtOFLx[X
};


//=============================================================================================
//	vg^Cv錾
//=============================================================================================

//=============================================================================================
//=============================================================================================
//	ݒ֐
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VXe[NGA擾
 *
 * @param	mode	擾[h
 *
 * @return	擾̃AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL GF_BGL_INI*  GF_BGL_BglIniAlloc( u32 heapID );

//--------------------------------------------------------------------------------------------
/**
 * q[vID擾
 *
 * @param	ini		BGLf[^
 *
 * @return	BGL̃q[vID
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 GF_BGL_HeapIDGet( GF_BGL_INI * ini );

//--------------------------------------------------------------------------------------------
/**
 * af[hݒ
 *
 * @param	data	af[hݒf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void	GF_BGL_InitBG( const GF_BGL_SYS_HEADER* data );

//--------------------------------------------------------------------------------------------
/**
 * af[hݒiʂƁj
 *
 * @param	data	af[hݒf[^
 * @param	flg		ݒ肷
 *
 * @return	none
 *
 * @li	flg = GF_BGL_MAIN_DISP : C
 * @li	flg = GF_BGL_SUB_DISP : Tu
 */
//--------------------------------------------------------------------------------------------
GLOBAL void	GF_BGL_InitBGDisp( const GF_BGL_SYS_HEADER * data, u8 flg );

//--------------------------------------------------------------------------------------------
/**
 * afʐݒ
 *
 * @param	ini			BGLf[^
 * @param	frmnum		aft[ԍ
 * @param	data		afRg[f[^
 * @param	mode		af[h
 * 
 * @return	none
 *
 * @li	mode = GF_BGL_MODE_TEXT		: eLXg
 * @li	mode = GF_BGL_MODE_AFFINE	: AtB
 * @li	mode = GF_BGL_MODE_256X16	: AtBgBG
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BGControlSet(
				GF_BGL_INI * ini, u8 frmnum, const GF_BGL_BGCNT_HEADER* data, u8 mode );

//--------------------------------------------------------------------------------------------
/**
 * afĖʐݒ
 *
 * @param	ini			BGLf[^
 * @param	frmnum		aft[ԍ
 * @param	flg			ύXp[^
 * @param	prm			ύXl
 * 
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BGControlReset( GF_BGL_INI * ini, u8 frm, u8 flg, u8 prm );

//--------------------------------------------------------------------------------------------
/**
 * GF_BGL_BGControlSetŎ擾J
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BGControlExit( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * \vCIeBݒ
 *
 * @param	frmnum		BGt[ԍ
 * @param	priority	vCIeB
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_PrioritySet( u8 frmnum, u8 priority );

//--------------------------------------------------------------------------------------------
/**
 * \ONEOFFݒ
 *
 * @param	frmnum		BGt[ԍ
 * @param	visible		VISIBLE_ON or VISIBLE_OFF
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_VisibleSet( u8 frmnum, u8 visible );


//=============================================================================================
//=============================================================================================
//	XN[֐
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * XN[
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	mode		XN[[h
 * @param	value		XN[l
 *
 * @return	none
 *
 * @li	gkʂgkE]ꍇGF_BGL_AffineScrollSet(...)gp邱
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrollSet( GF_BGL_INI * ini, u8 frmnum, u8 mode, int value );

//--------------------------------------------------------------------------------------------
/**
 * gkʂ̊gkE]EXN[
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	mode		XN[[h
 * @param	value		XN[l
 * @param	mtx			ϊs
 * @param	cx			]SXW
 * @param	cy			]SYW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_AffineScrollSet(
			GF_BGL_INI * ini, u8 frmnum,
			u8 mode, int value, const MtxFx22 * mtx, int cx, int cy );

//--------------------------------------------------------------------------------------------
/**
 * gkE]
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	mtx			ϊs
 * @param	cx			]SXW
 * @param	cy			]SYW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_AffineSet(
				GF_BGL_INI * ini, u8 frmnum, const MtxFx22 * mtx, int cx, int cy );



//--------------------------------------------------------------------------------------------
/**
 * XN[lw擾
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 *
 * @return	int			XN[lw
 */
//--------------------------------------------------------------------------------------------
GLOBAL int GF_BGL_ScrollGetX( GF_BGL_INI * ini, u32 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * XN[lx擾
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 *
 * @return	int			XN[lw
 */
//--------------------------------------------------------------------------------------------
GLOBAL int GF_BGL_ScrollGetY( GF_BGL_INI * ini, u32 frmnum );


//=============================================================================================
//=============================================================================================
//	WJ֐
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * f[^WJ
 *
 * @param	src			WJ
 * @param	dst			WJ
 * @param	datasiz		TCY
 *
 * @return	none
 *
 * @li	datasiz = GF_BGL_DATA_LZH : kf[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL void	GF_BGL_DataDecord( const void* src, void* dst, u32 datasiz );


//=============================================================================================
//=============================================================================================
//	]֐
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * t[ɐݒ肳ꂽXN[f[^S]
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_LoadScreenReq( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * wf[^XN[ɓ]
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	src			]f[^
 * @param	datasiz		]TCY
 * @param	offs		ItZbg
 *
 * @return	none
 *
 * @li	datasiz = GF_BGL_DATA_LZH : kf[^
 *
 *	kꂽf[^͉𓀏ꏊini->bgsys[frmnum].screen_bufgp邽
 *	ini->bgsys[frmnum].screen_bufɃf[^Zbg邪A񈳏k̏ꍇ́A
 *	ZbgȂ̂ŁAӂ邱ƁB
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_LoadScreen(
				GF_BGL_INI * ini, u8 frmnum, const void* src, u32 datasiz, u32 offs );

//--------------------------------------------------------------------------------------------
/**
 * wf[^XN[ɓ]it@CQƁj
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	path		t@C̃pX
 * @param	offs		ItZbg
 *
 * @return	none
 *
 *	kΉ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_LoadScreenFile( GF_BGL_INI * ini, u8 frmnum, const char * path, u32 offs );

//--------------------------------------------------------------------------------------------
/**
 *	XN[f[^obt@ɃRs[
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[
 * @param	dat			wf[^
 * @param	datasizpx	f[^TCY
 *
 * @retrn	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScreenBufSet( GF_BGL_INI * ini, u8 frmnum, const void * dat, u32 datasiz );

//--------------------------------------------------------------------------------------------
/**
 * LN^[]
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	src			]f[^
 * @param	datasiz		]TCY
 * @param	offs		ItZbg
 *
 * @return	none
 *
 * @li	datasiz = GF_BGL_DATA_LZH : kf[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_LoadCharacter(
				GF_BGL_INI * ini, u8 frmnum, const void * src, u32 datasiz, u32 offs );

//--------------------------------------------------------------------------------------------
/**
 * LN^[]it@CQƁj
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	src			]f[^
 * @param	datasiz		]TCY
 * @param	offs		ItZbg
 *
 * @return	none
 *
 *	kΉ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_LoadCharacterFile(
					GF_BGL_INI * ini, u8 frmnum, const char * path, u32 offs );

//--------------------------------------------------------------------------------------------
/**
 * ONAꂽLZbg
 *
 * @param	frmnum		BGt[ԍ
 * @param	datasiz		]TCY
 * @param	offs		ItZbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ClearCharSet( u8 frmnum, u32 datasiz, u32 offs, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * wlŃNAꂽLZbg
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	clear_code	NAR[h
 * @param	charcnt		NAL
 * @param	offs		L̈擪̃ItZbgiLj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_CharFill(
				GF_BGL_INI * ini, u32 frmnum, u32 clear_code, u32 charcnt, u32 offs );

//--------------------------------------------------------------------------------------------
/**
 * pbg]
 *
 * @param	frmnum		BGt[ԍ
 * @param	buf			pbgf[^
 * @param	siz			]TCYioCgPʁj
 * @param	ofs			ItZbgioCgPʁj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_PaletteSet( u8 frmnum, void * buf, u16 siz, u16 ofs );

//--------------------------------------------------------------------------------------------
/**
 * obNOEhJ[]ipbgÕJ[wj
 *
 * @param	frmnum		BGt[ԍ
 * @param	col			J[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BackGroundColorSet( u8 frmnum, u16 col );


//=============================================================================================
//=============================================================================================
//	XN[֘A
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * XN[f[^
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[
 * @param	buf			ރf[^
 * @param	px			݊JnwW
 * @param	py			݊JnxW
 * @param	sx			݂wTCY
 * @param	sy			݂xTCY
 *
 * @retrn	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrWrite(
				GF_BGL_INI * ini, u8 frmnum, const void * buf, u8 px, u8 py, u8 sx, u8 sy );

//--------------------------------------------------------------------------------------------
/**
 * XN[f[^݁igŁj
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[
 * @param	write_px	݊JnwW
 * @param	write_px	݊JnxW
 * @param	write_sx	݂wTCY
 * @param	write_sy	݂xTCY
 * @param	buf			ǂݍ݃f[^
 * @param	buf_px		ǂݍ݊JnwW
 * @param	buf_py		ǂݍ݊JnxW
 * @param	buf_sx		ǂݍ݃f[^wTCYiwrite_sx,syƂ͈ႢAǂݍ݃f[^
 * @param	buf_sy		ǂݍ݃f[^xTCY@Ŝ̑傫̂̂j
 *
 * @retrn	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrWriteExpand(
				GF_BGL_INI * ini, u8 frmnum, u8 write_px, u8 write_py, u8 write_sx, u8 write_sy,
				const void * buf, u8 buf_px, u8 buf_py, u8 buf_sx, u8 buf_sy );

//--------------------------------------------------------------------------------------------
/**
 * XN[f[^(܂Ԃf[^)
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[
 * @param	write_px	݊JnwW
 * @param	write_px	݊JnxW
 * @param	write_sx	݂wTCY
 * @param	write_sy	݂xTCY
 * @param	buf			ǂݍ݃f[^
 * @param	buf_px		ǂݍ݊JnwW
 * @param	buf_py		ǂݍ݊JnxW
 * @param	buf_sx		ǂݍ݃f[^wTCYiwrite_sx,syƂ͈ႢAǂݍ݃f[^
 * @param	buf_sy		ǂݍ݃f[^xTCY@Ŝ̑傫̂̂j
 *
 * @retrn	none
 *
 * @li	܂ԂL1x1`64x64L̃t[TCYXN[f[^̋`
 */
//--------------------------------------------------------------------------------------------
void GF_BGL_ScrWriteFree(
				GF_BGL_INI * ini, u8 frmnum, u8 write_px, u8 write_py, u8 write_sx, u8 write_sy,
				const void * buf, u8 buf_px, u8 buf_py, u8 buf_sx, u8 buf_sy );

//--------------------------------------------------------------------------------------------
/**
 * XN[f[^obt@ߐs
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[
 * @param	dat			wf[^
 * @param	px			݊JnwW
 * @param	py			݊JnxW
 * @param	sx			݂wTCY
 * @param	sy			݂xTCY
 * @param	mode		pbgԍȂ
 *
 * @retrn	none
 *
 * @li	mode = GF_BGL_SCRWRT_PALNL : ݂̃XN[̃pbgp
 * @li	mode = GF_BGL_SCRWRT_PALIN : datɃpbgf[^܂
 * @li	mode = 0 ` 15 : pbgԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrFill(
				GF_BGL_INI * ini, u8 frmnum, u16 dat, u8 px, u8 py, u8 sx, u8 sy, u8 mode );

//--------------------------------------------------------------------------------------------
/**
 * wt[̃XN[̎wʒũpbgύX
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 * @param	px		JnXʒu
 * @param	py		JnYʒu
 * @param	sx		XTCY
 * @param	sy		YTCY
 * @param	pal		pbgԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrPalChange(
				GF_BGL_INI * ini, u8 frmnum, u8 px, u8 py, u8 sx, u8 sy, u8 pal );

//--------------------------------------------------------------------------------------------
/**
 * XN[obt@NAē]
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrClear( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * XN[obt@wR[hŃNAē]
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 * @param   clear_code	NAR[h
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrClearCode( GF_BGL_INI * ini, u8 frmnum, u16 clear_code );

//--------------------------------------------------------------------------------------------
/**
 * XN[obt@wR[hŃNAē]NGXg
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 * @param   clear_code	NAR[h
 *
 * @return	none
 *
 * @li	]VBlank
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrClearCodeVReq( GF_BGL_INI * ini, u8 frmnum, u16 clear_code );


//=============================================================================================
//=============================================================================================
//	LN^[֘A
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Lf[^擾
 *
 * @param	frmnum	BGt[ԍ
 *
 * @return	Lf[^̃AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * GF_BGL_CgxGet( u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * 4bit̃Lf[^8bitɕϊiϊwj
 *
 * @param	chr			ϊf[^i4bitLj
 * @param	chr_size	ϊf[^̃TCY
 * @param	buf			ϊ
 * @param	pal_ofs		pbgԍ ( 0 ` 16 )
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_4BitCgxChange8BitMain( const u8 * chr, u32 chr_size, u8 * buf, u8 pal_ofs );

//--------------------------------------------------------------------------------------------
/**
 * 4bit̃Lf[^8bitɕϊiϊ擾j
 *
 * @param	chr			ϊf[^i4bitLj
 * @param	chr_size	ϊf[^̃TCY
 * @param	pal_ofs		pbgԍ ( 0 ` 16 )
 * @param	heap		q[vID
 *
 * @return	擾̃AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * GF_BGL_4BitCgxChange8Bit( const u8 * chr, u32 chr_size, u8 pal_ofs, u32 heap );


//=============================================================================================
//=============================================================================================
//	BGLXe[^X擾
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾iXN[obt@AhXj
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	XN[obt@AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * GF_BGL_ScreenAdrsGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾iXN[obt@TCYj
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	XN[obt@TCY
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 GF_BGL_ScreenSizGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾iXN[^Cv擾j
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	GF_BGL_SCRSIZ_128x128 
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 GF_BGL_ScreenTypeGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾iXN[JE^Xj
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	XN[JE^X
 */
//--------------------------------------------------------------------------------------------
GLOBAL int GF_BGL_ScreenScrollXGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾iXN[JE^Yj
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	XN[JE^Y
 */
//--------------------------------------------------------------------------------------------
GLOBAL int GF_BGL_ScreenScrollYGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾iJ[[hj
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	J[[h
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_ScreenColorModeGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾i]pxj
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	]px
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 GF_BGL_RadianGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾iX̊gkp[^j
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	X̊gkp[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL fx32 GF_BGL_ScaleXGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾iY̊gkp[^j
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	Y̊gkp[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL fx32 GF_BGL_ScaleYGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾i]SXWj
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	]SXW
 */
//--------------------------------------------------------------------------------------------
GLOBAL GF_BGL_CenterXGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGLXe[^X擾i]SYWj
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	]SYW
 */
//--------------------------------------------------------------------------------------------
GLOBAL int GF_BGL_CenterYGet( GF_BGL_INI * ini, u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * BGvCIeB擾
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 *
 * @return	vCIeB
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_PriorityGet( GF_BGL_INI * ini, u8 frm );


//=============================================================================================
//=============================================================================================
//	rbg}bv֘A
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ǂݍ݂Ə݂̃AhXƔ͈͂w肵ăL`(Fw肠j
 *
 * @param	src			ǂݍ݌Lf[^wb_[\̃|C^
 * @param	dest		ݐLf[^wb_[\̃|C^
 * @param	pos_sx		ǂݍ݌ǂݍ݊JnXW
 * @param	pos_sy		ǂݍ݌ǂݍ݊JnYW
 * @param	pos_dx		ݐ揑݊JnXW
 * @param	pos_dy		ݐ揑݊JnYW
 * @param	size_x		`͈XTCY
 * @param	size_y		`͈YTCY
 * @param	nuki_col	Fwi0`15 0xff:FwȂj
 *
 * @return	none
 *
 * @li	PUFp
 */
//--------------------------------------------------------------------------------------------
GLOBAL void	GF_BMP_PrintMain(
				const BMPPRT_HEADER * src, const BMPPRT_HEADER * dest,
				u16 pos_sx, u16 pos_sy, u16 pos_dx, u16 pos_dy,
				u16 size_x, u16 size_y, u16 nuki_col );

//--------------------------------------------------------------------------------------------
/**
 * ǂݍ݂Ə݂̃AhXƔ͈͂w肵ăL`(Fw肠j
 *
 * @param	src			ǂݍ݌Lf[^wb_[\̃|C^
 * @param	dest		ݐLf[^wb_[\̃|C^
 * @param	pos_sx		ǂݍ݌ǂݍ݊JnXW
 * @param	pos_sy		ǂݍ݌ǂݍ݊JnYW
 * @param	pos_dx		ݐ揑݊JnXW
 * @param	pos_dy		ݐ揑݊JnYW
 * @param	size_x		`͈XTCY
 * @param	size_y		`͈YTCY
 * @param	nuki_col	Fwi0`15 0xff:FwȂj
 *
 * @return	none
 *
 * @li	QTUFp
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BMP_PrintMain256(
				const BMPPRT_HEADER * src, const BMPPRT_HEADER * dest,
				u16 pos_sx, u16 pos_sy, u16 pos_dx, u16 pos_dy,
				u16 size_x, u16 size_y, u16 nuki_col );

//--------------------------------------------------------------------------------------------
/**
 * ͈͂w肵Ďw肳ꂽFR[hœhԂ
 *
 * @param	dest		ݐLf[^wb_[\̃|C^
 * @param	pos_dx		ݐ揑݊JnXW
 * @param	pos_dy		ݐ揑݊JnYW
 * @param	size_x		`͈XTCY
 * @param	size_y		`͈YTCY
 * @param	col_code	hԂFR[h
 *
 * @return	none
 *
 * @li	PUFp
 */
//--------------------------------------------------------------------------------------------
GLOBAL void	GF_BGL_BmpFill(
				const BMPPRT_HEADER *dest,
				u16 pos_dx,u16 pos_dy,u16 size_x,u16 size_y,u8 col_code);

//--------------------------------------------------------------------------------------------
/**
 * ͈͂w肵Ďw肳ꂽFR[hœhԂ
 *
 * @param	dest		ݐLf[^wb_[\̃|C^
 * @param	pos_dx		ݐ揑݊JnXW
 * @param	pos_dy		ݐ揑݊JnYW
 * @param	size_x		`͈XTCY
 * @param	size_y		`͈YTCY
 * @param	col_code	hԂFR[h
 *
 * @return	none
 *
 * @li	QTUFp
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpFill256(
			const BMPPRT_HEADER * dest,
			u16 pos_dx, u16 pos_dy, u16 size_x, u16 size_y, u8 col_code );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bvf[^m
 *
 * @param	heapID	q[vhc
 * @param	num		mۂBMPEBhE̐
 *
 * @return	mۂf[^̃AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL GF_BGL_BMPWIN * GF_BGL_BmpWinAllocGet( u32 heapID, u8 num );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bvf[^
 *
 * @param	wk		BMPf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinInit( GF_BGL_BMPWIN * wk );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bvo^`FbN
 *
 * @param	win		BMPf[^
 *
 * @retval	"TRUE = o^ς"
 * @retval	"FALSE = o^"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_BmpWinAddCheck( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bvǉ
 *
 * @param	ini		BGLf[^
 * @param	win		BMPf[^i[ꏊ
 * @param	frmnum	BGt[ԍ
 * @param	posx	XWiLPʁj
 * @param	posy	YWiLPʁj
 * @param	sizx	XTCYiLPʁj
 * @param	sizy	XTCYiLPʁj
 * @param	palnum	gppbgԍ
 * @param	chrofs	gpCGXItZbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinAdd(
				GF_BGL_INI * ini, GF_BGL_BMPWIN * win, u8 frmnum,
				u8 posx, u8 posy, u8 sizx, u8 sizy, u8 palnum, u16 chrofs );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bvǉiOBJpɃL̈悾mہj
 *
 * @param	ini		BGLf[^
 * @param	win		BMPf[^i[ꏊ
 * @param	sizx	XTCYiLPʁj
 * @param	sizy	XTCYiLPʁj
 * @param	chrofs	gpCGXItZbg
 * @param   fill_color	ߐsJ[ԍ(0`0xf)
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinObjAdd(GF_BGL_INI * ini, GF_BGL_BMPWIN * win, u8 sizx, u8 sizy, 
				u16 chrofs, u8 fill_color );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bvǉif[^wj
 *
 * @param	ini		BGLf[^
 * @param	win		BMPf[^i[ꏊ
 * @param	dat		BMPWIN_DAT\̌^f[^ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinAddEx(
				GF_BGL_INI * ini, GF_BGL_BMPWIN * win, const BMPWIN_DAT * dat );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bv폜
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinDel( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bv폜iBMPf[^Jj
 *
 * @param	win		BMPf[^
 * @param	num		
 *
 * @return	none
 *
 *	GF_BGL_BmpWinAllocGet()ŊmۂꍇɎgpĉ
 *	
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinFree( GF_BGL_BMPWIN * win, u8 num );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bv\iXN[AL]j
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinOn( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bv\iXN[]NGXgAL]j
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinOnVReq( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * EBhËXN[֘ABGobt@ɍ쐬
 *
 * @param	win		BMPf[^i[ꏊ
 *
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinMakeScrn( GF_BGL_BMPWIN* win );

//------------------------------------------------------------------
/**
 * WindoẅXN[֘ABGobt@ɍ쐬
 * iTCYwBBitmapWindow쐬̈̃XN[쐬\B傫̂͂mfBj
 *
 * @param   win			BitmapWindow ւ̃|C^
 * @param   width		XN[쐬̈̕iLPʁj
 * @param   height		XN[쐬̈̍iLPʁj
 *
 */
//------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinMakeScrnLimited( GF_BGL_BMPWIN* win, u32 width, u32 height );

//--------------------------------------------------------------------------------------------
/**
 * ֘ABGobt@̃EBhËXN[NA
 *
 * @param	win		BMPf[^i[ꏊ
 *
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinClearScrn( GF_BGL_BMPWIN* win );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bv\iL]̂݁j
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinCgxOn( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bv\
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinOff( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bv\NGXg
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinOffVReq( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * wJ[őŜhԂ
 *
 * @param	win		BMPf[^i[ꏊ
 * @param	col		J[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinDataFill( GF_BGL_BMPWIN * win, u8 col );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bv`
 *
 * @param	win		BMPf[^i[ꏊ
 * @param	src		rbg}bv\f[^|C^
 * @param	src_x	rbg}bv\Jnʒuw
 * @param	src_y	rbg}bv\Jnʒux
 * @param	src_dx	rbg}bvf[^TCYw
 * @param	src_dy	rbg}bvf[^TCYw
 * @param	win_x	EChE\Jnʒuw
 * @param	win_y	EChE\Jnʒux
 * @param	win_dx	EChEf[^TCYw
 * @param	win_dy	EChEf[^TCYx
 *
 * @retval	Ȃ
 *
 * rbg}bvf[^݂̏s
 * rbg}bvf[^̐؂\ɂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinPrint(
				GF_BGL_BMPWIN * win, void * src,
				u16 src_x, u16 src_y, u16 src_dx, u16 src_dy,
				u16 win_x, u16 win_y, u16 win_dx, u16 win_dy );

//--------------------------------------------------------------------------------------------
/**
 *	rbg}bv`igŁj
 *
 * @param	win		BMPf[^i[ꏊ
 * @param	src		rbg}bv\f[^|C^
 * @param	src_x	rbg}bv\Jnʒuw
 * @param	src_y	rbg}bv\Jnʒux
 * @param	src_dx	rbg}bvf[^TCYw
 * @param	src_dy	rbg}bvf[^TCYw
 * @param	win_x	EChE\Jnʒuw
 * @param	win_y	EChE\Jnʒux
 * @param	win_dx	EChEf[^TCYw
 * @param	win_dy	EChEf[^TCYx
 * @param	nuki	Fwi0`15 0xff:FwȂj
 *
 * @retval	Ȃ
 *
 * rbg}bvf[^݂̏s
 * rbg}bvf[^̐؂\ɂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinPrintEx(
				GF_BGL_BMPWIN * win, void * src,
				u16 src_x, u16 src_y, u16 src_dx, u16 src_dy,
				u16 win_x, u16 win_y, u16 win_dx, u16 win_dy, u16 nuki );

//--------------------------------------------------------------------------------------------
/**
 * w͈͂hԂ
 *
 * @param	win			BMPf[^
 * @param	col			hԂJ[
 * @param	px			JnXW
 * @param	py			JnYW
 * @param	sx			XTCY
 * @param	sy			YTCY
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinFill( GF_BGL_BMPWIN * win, u8 col, u16 px, u16 py, u16 sx, u16 sy );

//---------------------------------------------------------------------------------------------
/**
 * \pAbv
 *
 * @param	win		BMPf[^i[ꏊ
 * @param	src		Lf[^
 * @param	ssx		tHgXTCY
 * @param	ssy		tHgYTCY
 * @param	wx		XW
 * @param	wy		YW
 *
 * @return	none
 */
//---------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinPrintMsg(
				GF_BGL_BMPWIN * win, u8 * src,
				u16 ssx, u16 ssy, u16 wx, u16 wy );
GLOBAL void GF_BGL_BmpWinPrintMsgWide(
				GF_BGL_BMPWIN * win, const u8 * src,
				u16 ssx, u16 ssy, u16 wx, u16 wy, u16 tbl );

//--------------------------------------------------------------------------------------------
/**
 * rbg}bvEChEf[^Vtg
 *
 * @param	win		BMPf[^i[ꏊ
 * @param	direct	
 * @param	offset	Vtg
 * @param	data	󔒂ɂȂ̈𖄂߂f[^
 *
 * @return	none
 *
 * rbg}bvf[^(S̈)̃Vtgs
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinShift( GF_BGL_BMPWIN * win, u8 direct, u8 offset, u8 data );


//=============================================================================================
//=============================================================================================
//	BMPf[^
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^擾FBGLf[^
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	win->ini
 */
//--------------------------------------------------------------------------------------------
GLOBAL GF_BGL_INI * GF_BGL_BmpWinGet_BglIni( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^擾FBGt[ԍ
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	win->frmnum
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_BmpWinGet_Frame( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^擾FXTCY
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	win->sizx
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_BmpWinGet_SizeX( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^擾FYTCY
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	win->sizy
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_BmpWinGet_SizeY( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^擾FXW
 *
 * @param	win		BMPf[^i[ꏊ
 * @param	index	rbg}bvgpݒwb_INDEX
 *
 * @return	win->posx
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_BmpWinGet_PosX( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^擾FYW
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	win->posy
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_BmpWinGet_PosY( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^擾FLԍ
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	win->chrofs
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 GF_BGL_BmpWinGet_Chrofs( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^ݒFXW
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinSet_PosX( GF_BGL_BMPWIN * win, u8 px );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^ݒFYW
 *
 * @param	win		BMPf[^i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinSet_PosY( GF_BGL_BMPWIN * win, u8 py );

//--------------------------------------------------------------------------------------------
/**
 * BMPf[^ݒFpbgԍ
 *
 * @param	win		BMPf[^i[ꏊ
 * @param   palnum	pbgԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_BmpWinSet_Pal( GF_BGL_BMPWIN * win, u8 palnum );


//=============================================================================================
//=============================================================================================
//	NITRO-CHARACTERf[^WJ
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * NITRO-CHARACTER̃Lf[^ǂݍ
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 * @param	path	t@CpX
 * @param	offs	ItZbgiLPʁj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_NTRCHR_CharLoad(
				GF_BGL_INI * ini, u8 frmnum, const char * path, u32 offs );
GLOBAL void GF_BGL_NTRCHR_CharLoadEx(
				GF_BGL_INI * ini, u8 frmnum, const char * path, u32 offs, u32 size );

//--------------------------------------------------------------------------------------------
/**
 * NITRO-CHARACTER̃Lf[^擾
 *
 * @param	buf		WJpobt@iŃmہj
 * @param	mode	wq[v̈`
 * @param	path	t@CpX
 *
 * @return	Lf[^̍\
 */
//--------------------------------------------------------------------------------------------
GLOBAL NNSG2dCharacterData * GF_BGL_NTRCHR_CharGet( void ** buf, int mode, const char * path );

//--------------------------------------------------------------------------------------------
/**
 * NITRO-CHARACTER̃pbgf[^WJ
 *
 * @param	mem		WJꏊ
 * @param	mode	wq[v̈`
 * @param	path	t@CpX
 *
 * @return	pbgf[^
 *
 * @li		pal->pRawData = pbgf[^
 * @li		pal->szByte   = TCY
 */
//--------------------------------------------------------------------------------------------
GLOBAL NNSG2dPaletteData * GF_BGL_NTRCHR_PalLoad( void ** mem, int mode, const char * path );

//--------------------------------------------------------------------------------------------
/**
 * NITRO-CHARACTER̃XN[f[^ǂݍ
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 * @param	path	t@CpX
 * @param	offs	ItZbgiLPʁj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_NTRCHR_ScrnLoad(
				GF_BGL_INI * ini, u8 frmnum, const char * path, u32 offs );


//=============================================================================================
//=============================================================================================
//	VBlank֘A
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VBlank]
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 *
 * @li	VBlankŌĂŉ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_VBlankFunc( GF_BGL_INI * ini );

//--------------------------------------------------------------------------------------------
/**
 * XN[]NGXg ( VBlank )
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 *
 * @return	none
 *
 * @li	VBlankGF_BGL_VBlankFunc(...)ĂԂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_LoadScreenV_Req( GF_BGL_INI * ini , u8 frmnum );

//--------------------------------------------------------------------------------------------
/**
 * XN[NGXg
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	mode		XN[[h
 * @param	value		XN[l
 *
 * @return	none
 *
 * @li	VBlankGF_BGL_VBlankFunc(...)ĂԂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScrollReq( GF_BGL_INI * ini, u8 frmnum, u8 mode, int value );

//--------------------------------------------------------------------------------------------
/**
 * ]pxύXNGXg
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	mode		pxύX[h
 * @param	value		]l
 *
 * @return	none
 *
 * @li	VBlankGF_BGL_VBlankFunc(...)ĂԂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_RadianSetReq( GF_BGL_INI * ini, u8 frmnum, u8 mode, u16 value );

//--------------------------------------------------------------------------------------------
/**
 * gkύXNGXg
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	mode		gkύX[h
 * @param	value		ύXl
 *
 * @return	none
 *
 * @li	VBlankGF_BGL_VBlankFunc(...)ĂԂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_ScaleSetReq( GF_BGL_INI * ini, u8 frmnum, u8 mode, fx32 value );

//--------------------------------------------------------------------------------------------
/**
 * ]SWύXNGXg
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[ԍ
 * @param	mode		ύX[h
 * @param	value		ύXl
 *
 * @return	none
 *
 * @li	VBlankGF_BGL_VBlankFunc(...)ĂԂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GF_BGL_RotateCenterSetReq( GF_BGL_INI * ini, u8 frmnum, u8 mode, int value );


//=============================================================================================
//=============================================================================================
//	̑
//=============================================================================================
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * wW̃hbg`FbN
 *
 * @param	ini		BGLf[^
 * @param	frmnum	BGt[ԍ
 * @param	px		XW
 * @param	py		YW
 * @param	pat		f[^
 *
 * @retval	"TRUE = f[^(pat)ɂ"
 * @retval	"FALSE = f[^(pat)ɂȂ"
 *
 * @li	PUF̏ꍇApat̓rbgŃ`FbN
 *			j*pat = 0xfffd;
 *				J[01̏ꍇAFALSEԂ
 *
 * @li	QTUF̏ꍇApat̍Ō0xfffft
 *			jpat[] = { 88, 124, 223, 0xffff };
 *				J[88, 124, 223ȊOFALSEԂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 GF_BGL_DotCheck( GF_BGL_INI * ini, u8 frmnum, u16 px, u16 py, u16 * pat );



#undef GLOBAL
#endif
