//=============================================================================================
/**
 * @file	calctool.h
 * @brief	vZ֌W
 * @author	mori
 * @date	2004.10.28
 *
 */
//=============================================================================================
#ifndef	__CALCTOOL_H__
#define	__CALCTOOL_H__
#undef GLOBAL
#ifdef __CALCTOOL_H_GLOBAL__
#define GLOBAL /*	*/
#else
#define GLOBAL extern
#endif

#include "assert.h"


//=============================================================================================
//	萔`
//=============================================================================================
#define	AFFINE_MAX_NORMAL	( 0 )	// gk̊px0`0xffffŌvZ
#define	AFFINE_MAX_256		( 1 )	// gk̊px0`255ŌvZ
#define	AFFINE_MAX_360		( 2 )	// gk̊px0`359ŌvZ

#define FX_GET_ROTA_NUM(x)	( (x*0xffff) / 360 )	// FX_SinIdx CosIdẍ̉]l߂

#define GF_RAND_MAX			( 0xffff )		// gf_rand()̍ő吔
#define GF_MT_RAND_MAX		( 0xffffffff )	// gf_mtRand()̍ő吔

//=============================================================================================
//	vg^Cv錾
//=============================================================================================
#define ERRCHECK_ON_DEG_TO_XXX	//̒`𖳌ɂDEG֐̃G[`FbN𖳌ɂł

GLOBAL const fx32 FixSinCosTbl[360+90];
GLOBAL const u16 RotKey360Tbl[360];
 #define _Sin360( a ) (FixSinCosTbl[(a)])
 #define _Cos360( a ) (FixSinCosTbl[(a)+90])
 #define _RotKey( a ) (RotKey360Tbl[a])
/**
 *	@brief	x@Ŏw肵pxAꂼ̑Ήl擾
 *	@param	deg	u16:0-359܂ł̕ϐ
 */
 ///SinIdx(),CosIdx(),IndexL[̒lԂ(荞݂Ȃ)
 GLOBAL fx32 Sin360(u16 deg);
 GLOBAL fx32 Cos360(u16 deg);
 GLOBAL u16	RotKey(u16 deg);
 ///SinIdx(),CosIdx(),IndexL[̒lԂ(荞݂)
 GLOBAL fx32 Sin360R(u16 deg);
 GLOBAL fx32 Cos360R(u16 deg);
 GLOBAL u16	RotKeyR(u16 deg);
 ///SinIdx(),CosIdx()̒lԂ(fx32^ɎA荞݂)
 GLOBAL fx32 Sin360FX(fx32 deg);
 GLOBAL fx32 Cos360FX(fx32 deg);

GLOBAL u32 gf_get_seed(void);		// ̎̎擾
GLOBAL void gf_srand(u32 seed);		// ̏
GLOBAL u16 gf_rand(void);			// 擾i0 - 65535)
GLOBAL u32 gf_fix_rand( u32 seed );	// nĎ擾闐

GLOBAL void gf_mtSrand(u32 s);		// MT֐
GLOBAL u32 gf_mtRand(void);			// MT擾

//==============================================================================
/**
 *	mvZp_擾֐
 * 
 * @param   inDinominate	m
 *
 * @retval  u16		0`inDinominate-1̐
 */
//==============================================================================
inline u16 gf_p_rand(const u16 inDinominate)
{
	GF_ASSERT(inDinominate != 0);
	if (inDinominate <= 1){
		return 0;
	}else{
		u16 per;
		u16 val;
		per = (0xffff/inDinominate)+1;
		val = gf_rand()/per;
		GF_ASSERT((val<inDinominate)&&"ERROR:Random Calc Error!");//Ô
		return val;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * BGEOBJAffinepϊs쐬 ( 2D )
 *
 * @param	mtx			ϊsi[ꏊ
 * @param	rad			px ( MAX = 0xffff )
 * @param	scale_x		X̊g嗦
 * @param	scale_y		Y̊g嗦
 * @param	mode		pxϊ[h
 *
 * @return	ϊs
 *
 * @li	mode = AFFINE_MAX_256 : theta < 256
 * @li	mode = AFFINE_MAX_360 : theta < 360
 * @li	scale_x(y) = FX32_ONE : P{
 */
//--------------------------------------------------------------------------------------------
GLOBAL void AffineMtxMake_2D( MtxFx22 * mtx, u16 rad, fx32 scale_x, fx32 scale_y, u8 mode );


///==========================================
//xNgZñ}N
///==========================================
//xNgRs[
#define VEC_COPY(a,b)	{ \
 (a)->x = (b)->x;	\
 (a)->y = (b)->y;	\
 (a)->z = (b)->z;	\
}

//xNgZ
#define VEC_MUL(dest,a,b)	{	\
 (dest)->x = FX_Mul((a)->x,(b)->x);	\
 (dest)->y = FX_Mul((a)->y,(b)->y);	\
 (dest)->z = FX_Mul((a)->z,(b)->z);	\
}
//xNgZ
#define VEC_DIV(dest,a,b)	{	\
 (dest)->x = FX_Div((a)->x,(b)->x);	\
 (dest)->y = FX_Div((a)->y,(b)->y);	\
 (dest)->z = FX_Div((a)->z,(b)->z);	\
}
//xNg̎{
#define VEC_APPLYM(dest,a,fval) {	\
 (dest)->x = FX_MUL((a)->x,fval);	\
 (dest)->y = FX_MUL((a)->y,fval);	\
 (dest)->z = FX_MUL((a)->z,fval);	\
}
//xNgŊ
#define VEC_APPLYD(dest,a,fval) {	\
 (dest)->x = FX_Div((a)->x,fval);	\
 (dest)->y = FX_Div((a)->y,fval);	\
 (dest)->z = FX_Div((a)->z,fval);	\
}


//-----------------------------------------------------------------------------
/**
 *		
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	ʂQ_Q[tƎ]l擾
 *
 *	@param	x0		A_W
 *	@param	y0		A_W
 *	@param	x1		B_W
 *	@param	y1		B_W
 *
 *	@return	Q[tƎ]l
 */
//-----------------------------------------------------------------------------
GLOBAL s32 CalcTool_CircleVectorMove( s32 x0, s32 y0, s32 x1, s32 y1 );


//----------------------------------------------------------------------------
/**
 *	@brief	ʂQ_Cӂ̓l擾
 *
 *	@param	x0		A_W
 *	@param	y0		A_W
 *	@param	x1		B_W
 *	@param	y1		B_W
 *	@param	roopnum	P]\
 *
 *	@return	roopnumPʂ̓l
 */
//-----------------------------------------------------------------------------
GLOBAL s32 CalcTool_CircleVectorNum( s32 x0, s32 y0, s32 x1, s32 y1, u16 roopnum );


//----------------------------------------------------------------------------
/**
 *	@brief	ʂQ_Cӂ̓l擾
 *
 *	@param	x0		A_W
 *	@param	y0		A_W
 *	@param	x1		B_W
 *	@param	y1		B_W
 *	@param	r		a	̔aŏňړ߂܂
 *
 *	@return	ړ
 *
 *	p@
 *		r̉~߁Aړ~̉p[Zgɓ邩ɂA]px߂邱Ƃo܂
 */
//-----------------------------------------------------------------------------
GLOBAL s32 CalcTool_CircleVectorDistance( s32 x0, s32 y0, s32 x1, s32 y1, u32 r );

//----------------------------------------------------------------------------
/**
 *	@brief	aƋ猻݂̉]p擾
 *
 *	@param	r		a
 *	@param	dist	ړ
 *
 *	@return	ړ
 */
//-----------------------------------------------------------------------------
GLOBAL s32 CalcTool_CircleVectroDistRotaGet( u16 r, s32 dist );


#undef GLOBAL
#endif	/*__CALCTOOL_H__*/
