//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	@file		char_manager.h
 *	@brief		LN^f[^}l[W[wb_
 *	@author		tomoya takahashi
 *	@data		2004.11.22
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]



#ifndef CHAR_MANAGER_H__
#define	CHAR_MANAGER_H__

#include "nnsys.h"

#undef	GLOBAL
#ifdef	CHAR_MANAGER_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
*		OBJ}bsO[h̐
*
nai}bsO[hɂĂ̐
	n`lAgr[g̐擪LN^l[̃WX^10bitŁA0~1023̒l邱Ƃo܂B
	ŁA擪32KByte܂łɓLN^f[^͎QƏo܂B

	crł́AXvCg̃LN^f[^16KByte~256KBytewł܂B
	16Kbyte 32Kbyte͑vłA64KByte~256KByte͐擪I[܂ł̑SẴLN^f[^
	O`POQRł͎QƂ邱ƂoȂȂĂ܂܂B

	邽߂ɁAnai}bsO[hŁALN^Ew肵܂B
	jOBJ}bsO[h@PQWjb yte@̎
	LN^E@ @128Byte@@SLN^
	SLN^擪LN^l[ݒo܂B
	O		|OLN^Q	iWX^̒l@[@ۂ̎QƐ̃LN^io[j
	P		|SLN^Q
	Q		[WLN^Q
	EEEEEEEEEEEEEEEE
	POQR	[WPWSLN^Q

	ŁAO`POQR̒lŁAPQWjä̗w肷邱Ƃo悤ɂȂ܂B
	̑ɁAPLN^TCỸLN^f[^gpłASLN^
	uɔzuĂKv܂B

	̎AVramTCYɍ킹āAK؂Ȃnai}bsO[hݒ肷Kv܂B

*
*	ENitroCharacterł́ÂƂlLN^f[^oĂĂ܂
*	@̂ŁAZf[^쐬OBJ}bsO[hݒĂB
*	EȉNitroSDKwv
*	GX_OBJVRAMMODE_CHAR_2D	
*		2}bsO[hI܂B 
*		
*	GX_OBJVRAMMODE_CHAR_1D_32K
*		P}bsO[hŁA擪LN^E32oCgƂ܂B
*		p\OBJ-VRAM̍őeʂ32KBɂȂ܂B 
*		
*	 GX_OBJVRAMMODE_CHAR_1D_64K
*		P}bsO[hŁA擪LN^E64oCgƂ܂B
*		p\OBJ-VRAM̍őeʂ64KBɂȂ܂B 
*		
*	 GX_OBJVRAMMODE_CHAR_1D_128K
*		P}bsO[hŁA擪LN^E128oCgƂ܂B
*		p\OBJ-VRAM̍őeʂ128KBɂȂ܂B 
*		
*	 GX_OBJVRAMMODE_CHAR_1D_256K
*		P}bsO[hŁA擪LN^E256oCgƂ܂B
*		p\OBJ-VRAM̍őeʂ256KBɂȂ܂B 
*
*
*	QVramǗ@ɂ
*	
*	CharSet-CharSets̓
*		Vram̐擪LN^f[^ÂOffset炵
*		]Ă܂BDelChar֐gpĂ
*		Offset߂Ȃǂ̏oȂ߁A
*		ēxgp̈gƂƂo܂B
*
*	CharSetAreaCont-CharSetsAreaCont̓
*		Vram̊Ǘ̈쐬āAgp󋵂Ǘ܂B
*		TCỸLN^f[^]̈悪󂢂Ă邩
*		`FbNĂLN^f[^]܂B
*		DelCharƎgp̈ɂ܂̂ŁA
*		̈ėp邱Ƃo܂B
*/
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
*		萔`
*/
//-----------------------------------------------------------------------------
// 萔
// LN^f[^Rg[^Cv
// Rg[^Cv
//		ItZbg[[[[[擪ItZbg炵āA
//							]ItZbg߂
//		GARg[[Vram̈Ǘz񂩂󂢂Ă̈`FbN
//							]ItZbg߂
enum{
	CHARM_CONT_OFFSET,		// ItZbg^Cv
	CHARM_CONT_AREACONT,	// GARg[^Cv
};

//----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	LN^}l[W[쐬
//	\
//	
//=====================================
typedef struct {
	int CharDataNum;		// LN^䐔
	int VramTransAreaMain;	// CʂAreaContpɗpӂVramTCY
	int VramTransAreaSub;	// TuʂAreaContpɗpӂVramTCY
	int heap;				// gpq[v
} CHAR_MANAGER_MAKE;


//-------------------------------------
//	
//	LN^f[^wb_[
//	
//=====================================
typedef struct {
	NNSG2dCharacterData*	res_file;		// LN^\[X
	u32		type;			// o^^Cv
							// mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN
							// subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB
							// ɓo^FNNS_G2D_VRAM_TYPE_2DMAX
	u32		id;				// ̃LN^f[^ID

	u32		cont_type;		// VramRg[^Cv
							// CHARM_CONT_OFFSET	ItZbg^Cv
							// CHARM_CONT_AREACONT	GARg[^Cv
} CHAR_MANAGER_HEADER;

//-------------------------------------
//	
//	LN^]̃VXe
//	gpȂƂVRAM̗̈̂݊mۂ
//	VXe̊mۗ̈f[^
//	
//=====================================
typedef struct {
	u32 alloc_size;
	u32 alloc_ofs;
	u32	type;		// Vrammۂ\
	// mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN = 1
	// subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB = 2
} CHAR_MANAGER_ALLOCDATA;


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *	yLN^}l[W̓z		
 *	typedef struct {
 *		int CharDataNum;		// LN^䐔
 *		int VramTransAreaMain;	// CʂAreaContpɗpӂVramTCY
 *		int VramTransAreaSub;	// TuʂAreaContpɗpӂVramTCY
 *		int heap;				// gpq[v
 *	} CHAR_MANAGER_MAKE;
 *	
 *	̃f[^ŏ܂B
 *	CharDataNum			o^LN^̐nĂB
 *						CharDataNum̃[N쐬܂B
 *
 *	VramTransAreaMain	AreaCont֐ŎgpVramǗ̈TCYłB
 *	VramTransAreaSub	̃TCYǗ܂B
 *	
 *	heap				gpq[vID
 *
 *
 *	̃f[^ŏVramǗ
 *		AVram̍ő傪0x20000VramTransAreaMain0x10000
 *		ݒ肵Ƃ́Aȉ̂悤ȊǗԂɂȂ܂B
 *		Vram̈
 *		offset
 *		0x00000000
 *					ItZbgÂ炵p̈		CharSet CharSets
 *		0x00010000
 *					AreaContp̈		CharSetAreaCont CharSetsAreaCont
 *		0x00020000
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *
 *@brief	  LN^}l[W[
 
 *@param	CharMakeData	LN^}l[W[쐬f[^
 *
 *@return	none
 *
 * ݒ肳ĂLN^[hāAVram̊Ǘ̈Ȃǂ̍쐬
 * s܂B
 * LN^[hꏏɐݒ肷鏉֐쐬܂̂ŁA
 * ꏏɐݒ肵Ƃ́AgB
 *	InitCharManagerReg֐
 * 
 */
//-----------------------------------------------------------------------------
GLOBAL void InitCharManager( const CHAR_MANAGER_MAKE* CharMakeData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^}l[W
 *
 *	@param	CharMakeData	LN^}l[W쐬f[^
 *	@param	modeMain		LN^}bsO[h@C
 *	@param	modeSub			LN^}bsO[h@Tu
 *
 *	@return	none
 *
 *	GX_OBJVRAMMODE_CHAR_2D			2}bsO[hI܂B 
 *	GX_OBJVRAMMODE_CHAR_1D_32K		P}bsO[hŁA擪LN^E32oCgƂ܂B
 *									p\OBJ-VRAM̍őeʂ32KBɂȂ܂B 
 *	GX_OBJVRAMMODE_CHAR_1D_64K		P}bsO[hŁA擪LN^E64oCgƂ܂B
 *									p\OBJ-VRAM̍őeʂ64KBɂȂ܂B 
 *	GX_OBJVRAMMODE_CHAR_1D_128K		P}bsO[hŁA擪LN^E128oCgƂ܂B
 *									p\OBJ-VRAM̍őeʂ128KBɂȂ܂B 
 *	GX_OBJVRAMMODE_CHAR_1D_256K		P}bsO[hŁA擪LN^E256oCgƂ܂B
 *									p\OBJ-VRAM̍őeʂ256KBɂȂ܂B 
 *
 * 
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void InitCharManagerReg( const CHAR_MANAGER_MAKE* CharMakeData, GXOBJVRamModeChar modeMain, GXOBJVRamModeChar modeSub );

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}l[W[Sɔj܂B
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void DeleteCharManager(void);

//----------------------------------------------------------------------------
/**
 *
 *@brief	  [hJn֐	(Ǘ̃ItZbg)
 *
 *@param	  start_offsetFǂݍ݊Jnoffset
 *
 *@return	  none
 */
//-----------------------------------------------------------------------------
GLOBAL void CharLoadStart( u32 start_offset );	
GLOBAL void CharLoadStartSub( u32 start_offset );

//----------------------------------------------------------------------------
/**
 *
 *@brief	AreaContp̃CATu̗Ǘ̈
 *
 *@param	none
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void TransAreaInitAll( void );

//----------------------------------------------------------------------------
/**
 *
 *@brief	  [hJn֐	OŃCATuʂ̃ItZbg
 *				AreaContpVramGȀsĂ܂B
 *
 *@param	  none
 *
 *@return	  none
 */
//-----------------------------------------------------------------------------
GLOBAL void CharLoadStartAll( void );

//----------------------------------------------------------------------------
/**
 *	@brief	AreaCont֐p	gp֎~̈ݒ
 *
 *	@param	offset		gp֎~ItZbgʒu
 *	@param	size		gp֎~TCY
 *	@param	disp		
 *
 *	disp
 *		mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN = 1
 *		subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB = 2
 *
 *	@return	none
 *	
 *	gp̒
 *	GLOBAL void TransAreaInitAll( void );
 *	GLOBAL void CharLoadStartAll( void );
 *	gpɂ̐ݒĂB
 *	̂Q̊֐̒ŁA֎~̈̏sĂ܂܂	
 */
//-----------------------------------------------------------------------------
GLOBAL void SetReserveAreaContCharManager( u32 offset, u32 size, u32 disp );

//----------------------------------------------------------------------------
/**
 *
 *@brief		LN^f[^P̂Zbgă[h
 *
 *@param		pChatDataFLN^ENTRYf[^
 *
 *@retval		TRUE FZbgł  
 *@retval		FALSEFZbgłȂ
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL CharSet( const CHAR_MANAGER_HEADER* pCharData );

//----------------------------------------------------------------------------
/**
 *
 *@brief		LN^f[^𕡐Zbg
 *
 *@param		pChatData	LN^f[^z
 *@param		num			zvf
 *
 *@return		o^
 */
//-----------------------------------------------------------------------------
GLOBAL u16 CharSets( const CHAR_MANAGER_HEADER* pCharData, int num );

//----------------------------------------------------------------------------
/**
 *
 *@brief		LN^f[^P̂Zbgă[h
 *				}bsO[h̃WX^ԂɕύX郂[h
 *
 *@param		pChatDataFLN^ENTRYf[^
 *
 *@retval		TRUE FZbgł  
 *@retval		FALSEFZbgłȂ
 *
 * ̊֐̈Ӗ
 *	@CharSet֐ŁAIuWFLN^̃}bsO[h̕ύXĂ܂Ă邽߁A
 *	2D}bsO[hŃRo[gLN^f[^1Dœ]ȂǏo܂B
 *	@邽߂ɍݒ肳Ă}bsO[hLN^f[^ɐݒ肵āA
 *	]֐쐬܂B
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL CharSetCharModeAdjust( const CHAR_MANAGER_HEADER* pCharData );

//----------------------------------------------------------------------------
/**
 *
 *@brief		LN^f[^𕡐Zbg
 *				}bsO[h̃WX^ԂɕύX郂[h
 *
 *@param		pChatData	LN^f[^z
 *@param		num			zvf
 *
 *@return		o^
 */
//-----------------------------------------------------------------------------
GLOBAL u16 CharSetsCharModeAdjust( const CHAR_MANAGER_HEADER* pCharData, int num );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ǗIDVramɃLN^f[^]
 *
 *	@param	id				]̃f[^ǗID
 *	@param	pCharData		]LN^f[^
 *
 *	@return	none
 *
 * LN^f[^̃TCYꏏłKv܂
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CharDataChg( int id, NNSG2dCharacterData* pCharData );

//----------------------------------------------------------------------------
/**
 *
 *@brief	id̃LN^f[^o^Ă邩`FbN
 *
 *@param	id		`FbNid
 *
 *@retval	TRUE	o^Ă
 *@retval	FALSE	o^ĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL CheckCharID(int id);

//----------------------------------------------------------------------------
/**
 *
 *@brief	Ƃo^ł̂Ԃ
 *
 *@param	none
 *
 *@return	int		co^\
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int CheckCharRest(void);

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^j
 *
 *@param	LN^f[^ID
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void DelChar( int id );

//----------------------------------------------------------------------------
/**
 *
 *@brief	SLN^f[^j
 *
 *@param	none
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void DelCharAll( void );

//----------------------------------------------------------------------------
/**
 *
 *@brief	ID̃C[WvNV擾
 *
 *@param	LN^f[^ID
 *
 *@return	ID̃vNV
 */
//-----------------------------------------------------------------------------
GLOBAL NNSG2dImageProxy* GetCharIDProxy( int id );

//----------------------------------------------------------------------------
/**
 *
 *@brief	vNṼLN^f[^擾
 *
 *@param	pImageFC[WvNV|C^
 *
 *@return	LN^f[^
 */
//-----------------------------------------------------------------------------
GLOBAL NNSG2dCharacterData* GetCharIDData( const NNSG2dImageProxy* pImage );

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZVram]Aj[Vp̃LN^vNV擾
 *
 *@param	id		LN^f[^ID
 *@param	szByte	gpTCY
 *
 *@return	C[WvNV
 *@return	NULL		s
 *	
 *	NULLAƂ̓IWif[^gpƂƂȂ̂ŁARs[쐬ĂBi̊֐j
 *	
 */
//-----------------------------------------------------------------------------
GLOBAL NNSG2dImageProxy* GetCharVramTransData( int id, u32 szByte );

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZVram]Aj[Vp̃LN^vNVRs[Ď擾
 *
 *@param	Orig	IWiC[WvNV
 *
 *@return	Rs[Vram]ItZbg擾C[WvNV
 *@return	NULL	IWigpłȂ\܂B
 */
//-----------------------------------------------------------------------------
GLOBAL NNSG2dImageProxy* GetCharVramTransProxyCopy( const NNSG2dImageProxy* Orig );

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZVram]AjVram̈J
 *
 *@param	pImageFjLN^̈
 *			C[WvNV
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void DelVramTransData( const NNSG2dImageProxy* pImage );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OBJLN^}bsO[hLN^E擾
 *
 *	@param	mode	OBJLN^}bsO[h
 *
 *	@return	LN^E
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int CharModeMinNum( int mode );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	NNSG2dCharacterDatagpȂƂVramGAmۗp
 *
 *	@param	szByte		LN^f[^TCY
 *	@param	cont_type	VramRg[^Cv
 *	@param	type		o^
 *	@param	allocData	mۃf[^i[
 *
 *	@retval	TRUE	̈mۂł
 *	@retval	FALSE	̈mۂłȂ
 *
 *	cont_type
 *		CHARM_CONT_OFFSET	ItZbg^Cv
 *		CHARM_CONT_AREACONT	GARg[^Cv
 *
 *	type
 *		NNS_G2D_VRAM_TYPE_2DMAIN	CVRAM
 *		NNS_G2D_VRAM_TYPE_2DSUB		TuVRAM
 *
 *		**ʂ͎w肵Ȃł
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL CharVramAreaAlloc( int szByte, int cont_type, int type, CHAR_MANAGER_ALLOCDATA* allocData );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	NNSG2dCharacterDatagpȂƂVramGAjp
 *			cont_type = CHARM_CONT_AREACONT̂Ƃ悤
 *
 *	@param	allocData	o^f[^
 * 
 *	@return	none
 *
 * ItZbg炵[hŊmۂ͉̂ł܂
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void CharVramAreaFree( CHAR_MANAGER_ALLOCDATA* allocData );


//----------------------------------------------------------------------------
/**
 *	@brief	LN^}l[W|C^̎擾
 *
 *	@param	none
 *
 *	@return	LN^}l[W|C^
 */
//-----------------------------------------------------------------------------
GLOBAL void* CharManagerPtrGet( void );
//----------------------------------------------------------------------------
/**
 *	@brief	LN^}l[W|C^ݒ
 *
 *	@param	pdata	LN^}l[W|C^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
GLOBAL void CharManagerPtrSet( void* pdata );

//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
#undef	GLOBAL
#endif		// __CHAR_MANAGER_H__

