//=============================================================================================
/**
 * @file	fontdata_man.c
 * @brief	tHgf[^}l[W
 * @author	taya
 * @date	2005.09.14
 *
 * @li	ntrfont.exe ō쐬tHgf[^Ǘ}l[W
 */
//=============================================================================================
#ifndef __FONTDATA_MAN_H__
#define __FONTDATA_MAN_H__


#include "fontdata_loadtype.h"

typedef struct _GF_FONTDATA_MAN  GF_FONTDATA_MAN;


//==============================================================================================
/**
 * tHgf[^}l[W쐬
 *
 * @param   arcID			tHgf[^i[ĂA[JCuID
 * @param   datID			tHgf[^i[ĂA[JCut@CID
 * @param   loadType		tHgf[^̓ǂݏo
 * @param   fixedFontFlag	TRUEȂ瓙tHgƂĈ
 * @param   heapID			}l[W쐬q[vID
 *
 * @retval  GF_FONTDATA_MAN*	tHgf[^}l[W|C^
 *
 * @li  loadType  FONTDATA_LOADTYPE_ON_MEMORY ̏ꍇA}l[WƓq[v̈ɃtHgf[^ǂݍ
 */
//==============================================================================================
extern GF_FONTDATA_MAN* FontDataMan_Create( u32 arcID, u32 datID, FONTDATA_LOADTYPE loadType, BOOL fixedFontFlag, u32 heapID );


//==============================================================================================
/**
 * tHgf[^}l[W폜
 *
 * @param   wk		tHgf[^}l[W̃|C^
 *
 */
//==============================================================================================
extern void FontDataMan_Delete( GF_FONTDATA_MAN* wk );


//==============================================================================================
/**
 * tHgrbgf[^̓ǂݍ݃^CvύX
 *
 * @param   wk			tHgf[^}l[W|C^
 * @param   loadType	ύX̓ǂݍ݃^Cv
 *
 */
//==============================================================================================
extern void FontDataMan_ChangeLoadType( GF_FONTDATA_MAN* wk, FONTDATA_LOADTYPE loadType, u32 heapID );


//------------------------------------------------------------------
/*
 *	rbg}bvf[^擾
 *
 * @param	wk			tHgf[^}l[W
 * @param	fcode		R[h
 * @param	dst			rbg}bv擾[N
 *
 */
//------------------------------------------------------------------
extern void FontDataMan_GetBitmap( const GF_FONTDATA_MAN* wk, STRCODE fcode, MSG_FONT_DATA* dst );


//------------------------------------------------------------------
/**
 * rbg}bv̒ihbgjvZĕԂ
 *
 * @param   wk		tHgf[^}l[W
 * @param   str		
 * @param   margin	ԁihbgj
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
extern u32 FontDataMan_GetStrWidth( const GF_FONTDATA_MAN* wk, const STRCODE* str, u32 margin );

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/10/05
// sɂ킽镶́AŒs̃rbg}bvԂ֐
u32 FontDataMan_GetMaxLineWidth(const GF_FONTDATA_MAN* wk, const STRCODE* str, u32 margin);
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/14
// XNvgEBhEJۂɁAeڂ̒擾邽߂̊֐
u32 FontDataMan_GetEvWinItemWidth( const GF_FONTDATA_MAN* wk, const STRCODE* str );
// ----------------------------------------------------------------------------

#endif
