//=============================================================================================
/**
 * @file	g3d_system.h
 * @brief	Rc`ǗVXevO
 */
//=============================================================================================
#ifndef _G3D_SYSTEM_H_
#define _G3D_SYSTEM_H_

#undef GLOBAL
#ifdef __G3D_SYSTEM_H_GLOBAL__
#define GLOBAL /*	*/
#else
#define GLOBAL extern
#endif


//=============================================================================================
//	^錾
//=============================================================================================
/**
 * @brief	RcVXe}l[W\
 */
typedef struct GF_G3DMAN_tag
{
	int		heapID;		///<q[vhc

	void*	plt_memory;	///<pbg}l[Wp
	void*	tex_memory;	///<eNX`}l[Wp

}GF_G3DMAN;

/**
 * @brief	}l[W[h`	
 */
typedef enum {
	GF_G3DMAN_LNK = 0,		///<Nh[h
	GF_G3DMAN_FRM,			///<t[[h
}GF_G3DMAN_MODE;

/**
 * @brief	eNX`}l[WTCY`	
 */
typedef enum {
	GF_G3DTEX_128K = 1,		///<128KB(1ubN)
	GF_G3DTEX_256K = 2,		///<256KB(2ubN)
	GF_G3DTEX_384K = 3,		///<384KB(3ubN)
	GF_G3DTEX_512K = 4,		///<512KB(4ubN)
}GF_G3DMAN_TEXSIZE;

/**
 * @brief	pbg}l[WTCY`	
 */
typedef enum {
	GF_G3DPLT_16K = 1,		///<16KB
	GF_G3DPLT_32K = 2,		///<32KB
	GF_G3DPLT_64K = 4,		///<64KB
	GF_G3DPLT_80K = 5,		///<80KB
	GF_G3DPLT_96K = 6,		///<96KB
}GF_G3DMAN_PLTSIZE;

/**
 * @brief	ZbgAbv֐^
 */
typedef void (*GF_G3DSETUP_FUNC)( void );

//=============================================================================================
//	ݒ֐
//=============================================================================================
//=============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * VXe}l[Wݒ
 *
 * @param	heapID			擾pq[vGA
 * @param	texmanMode		eNX`}l[Wgp[h
 * @param	texmanSize		eNX`}l[Wgp̈TCYibytej
 * @param	palmanMode		pbg}l[Wgp[h
 * @param	palmanSize		pbg}l[Wgp̈TCYibytej
 * @param	setUp			ZbgAbv֐(NULL̎DefaultSetUp)
 *
 * @return	}l[W[N|C^
 */
//--------------------------------------------------------------------------------------------
GLOBAL GF_G3DMAN*  GF_G3DMAN_Init(	u32 heapID, 
									GF_G3DMAN_MODE texmanMode, GF_G3DMAN_TEXSIZE texmanSize, 
									GF_G3DMAN_MODE pltmanMode, GF_G3DMAN_PLTSIZE pltmanSize,
									GF_G3DSETUP_FUNC setup );

//--------------------------------------------------------------------------------------------
/**
 * I
 *
 * @param	man		}l[W[N|C^
 *
 * @return	none
 *
 */
//--------------------------------------------------------------------------------------------
GLOBAL void	GF_G3D_Exit( GF_G3DMAN*  man );

//------------------------------------------------------------------
//  Rcaf`֐
//  
//  @param		object_p		_[nai
//  @param		trans_p			gX[g
//  @param		rot_p			[e[V
//  @param		scale_p			XP[
//
//  @return		none
//  
//------------------------------------------------------------------
GLOBAL void GF_G3D_Draw_1mat1shape(	NNSG3dRenderObj* object_p,
									VecFx32* trans_p,
									MtxFx33* rot_p,
									VecFx32* scale_p);
#undef GLOBAL
#endif

