//=============================================================================================
/**
 * @file	msg_print.h
 * @brief	rbg}bv\pVXe
 * @author	tomo
 * @date	2004.10.28
 */
//=============================================================================================
#ifndef	__MSG_PRINT_H__
#define	__MSG_PRINT_H__

#include <nitro.h>
#include <nnsys.h>
#include "tcb.h"
#include "gflib\bg_system.h"
#include "gflib\strbuf.h"


#undef	GLOBAL
#ifdef	__MSG_PRINT_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//---------------------------------------------------------------------------------------------
/**
	萔`
 */
//---------------------------------------------------------------------------------------------
typedef u16		STRCODE;

//---------------------------------------------------------------------------------------------
/// Fԍw PRINT ̂߂̒萔E}N`

typedef u32		GF_PRINTCOLOR;

#define  GF_PRINTCOLOR_MASK			(0xff)
#define  GF_PRINTCOLOR_LETTER_SHIFT	(16)
#define  GF_PRINTCOLOR_SHADOW_SHIFT	(8)
#define  GF_PRINTCOLOR_GROUND_SHIFT	(0)

// GF_MSG_PrintColor ̈ GF_PRINT_COLOR 쐬邽߂̃}Ni FAeFAwiF̏ɔԍn j
#define  GF_PRINTCOLOR_MAKE(letter, shadow, ground)	(GF_PRINTCOLOR)(	(((letter)&GF_PRINTCOLOR_MASK) << GF_PRINTCOLOR_LETTER_SHIFT)|\
																		(((shadow)&GF_PRINTCOLOR_MASK) << GF_PRINTCOLOR_SHADOW_SHIFT)|\
																		(((ground)&GF_PRINTCOLOR_MASK) << GF_PRINTCOLOR_GROUND_SHIFT)	)

// GF_PRINTCOLOR_MAKE ōleFԍo}N
#define GF_PRINTCOLOR_GET_LETTER(c)		(((c)>>GF_PRINTCOLOR_LETTER_SHIFT)&GF_PRINTCOLOR_MASK)
#define GF_PRINTCOLOR_GET_SHADOW(c)		(((c)>>GF_PRINTCOLOR_SHADOW_SHIFT)&GF_PRINTCOLOR_MASK)
#define GF_PRINTCOLOR_GET_GROUND(c)		(((c)>>GF_PRINTCOLOR_GROUND_SHIFT)&GF_PRINTCOLOR_MASK)

//---------------------------------------------------------------------------------------------
///bZ[W\wait`

#define	MSG_NO_PUT	(0xff)	//fBXvC]Ȃ
#define	MSG_ALLPUT	(0)		//fBXvCꊇ]

//---------------------------------------------------------------------------------------------
///tHgf[^쐬vOpԂl`

typedef enum {
	PRINT_RESULT_WRITE = 0,
	PRINT_RESULT_END,
	PRINT_RESULT_LOOP,
	PRINT_RESULT_COMMAND,
}PRINT_RESULT;


//---------------------------------------------------------------------------------------------
/// FntDataColorGe() p[h`
enum COLOR_GET_MODE {
	COLOR_F,
	COLOR_S,
	COLOR_B
};

///\ݒ\
typedef struct mph_tag{
	union {
		const u16* msg;		//\bZ[W
		const STRBUF* strbuf;
	};
	GF_BGL_BMPWIN * bmpwin;	//BMPEBhEf[^

	u8		msg_index;		//bZ[WCfbNX

	u8		fnt_index;		//gptHgINDEX
	u8		start_x;		//EChE\JnXItZbg
	u8		start_y;		//EChE\JnYItZbg

	u8		write_x;	//EChE`XItZbg
	u8		write_y;	//EChE`YItZbg
	u8		space_x;	//Ԋu
	u8		space_y;	//Ԋu

	u8		style;		//tHgX^C
	u8		f_col;		//Fio[
	u8		b_col;		//wiFio[
	u8		s_col;		//eF@io[

	u16		dot_tbl;	//gphbge[u
	u8		dot_wy;		//g厞YW̕`␳l
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/06
	// 炩ߓo^ĂFɌŕύXdg݂
	u8		color_stack;
	// ----------------------------------------------------------------------------

/*	4bit color mode
u8		style:4;	//tHgX^C
u8		f_col:4;	//Fio[
u8		b_col:4;	//wiFio[
u8		s_col:4;	//eF@io[
u8		work[2];	//킹Œǉ
*/
}MSG_PRINT_HEADER;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/06
// mph_tag.color_stack ̏l
#define COLORSTACK_NOENTRY		(0xFF)
// ----------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
/**
 *	\VXegp[N\
 */
//---------------------------------------------------------------------------------------------
#define MDH_WORKSIZE	(7)

// FALSEԂPrintpBTRUEԂPrint𒆒fCallbackĂё
typedef  BOOL (*pStrPrintCallBack)(MSG_PRINT_HEADER*, u16);

typedef struct {
	MSG_PRINT_HEADER		mph;
	pStrPrintCallBack		call_back;
	u8		userwork[MDH_WORKSIZE];//[U[[N
	u8		sw;			//XCb`
	u8		seq;		//V[PX
	u8		wait:7;		//`EFCg(0:ꊇ`)
	u8		wait_flg:1;	//EFCgtO 0=ꊇ\, 1=P\
	u8		waitwork;	//[N(EFCg)
	u8		scrwork;	//[N(XN[)
	u8		msg_index;	//bZ[WCfbNX
	u8		callback_cont_flag;	// AR[obNĂяotO
	u16		callback_arg;	// R[obN֐Ɉnl
//	void * trg_wk;
	void * disp_icon;	//ʕύXACR
}MSG_DATA_HEADER;

//---------------------------------------------------------------------------------------------
/**
 *	\f[^\́iNCAgݒj
 */
//---------------------------------------------------------------------------------------------
typedef struct {
u8		size_x;		//tHgXTCYw
u8		size_y;		//tHgYTCYw
u8		space_x;	//Ԋu(ݒ)
u8		space_y;	//Ԋu(ݒ)
u8		style;	//tHgX^C(ݒ)
u8		f_col;	//Fio[
u8		b_col;	//wiFio[
u8		s_col;	//eF@io[
//u8		work[2];	//킹Œǉ
}MSG_FONT_HEADER;


//---------------------------------------------------------------------------------------------
/**
 *	f[^i[\
 */
//---------------------------------------------------------------------------------------------
typedef struct {
u8		data[0x20*4];
u8		size_x;	//\XTCY
u8		size_y;	//\YTCY
}MSG_FONT_DATA;



//---------------------------------------------------------------------------------------------
/**
 *	\VXe֐([U[ݒ)
 *
 * @param	tHg֐Qwb_
 *
 */
//---------------------------------------------------------------------------------------------
GLOBAL void	MSG_PrintSysInit( const MSG_FONT_HEADER* header );





extern u8 GF_STR_PrintSimple( GF_BGL_BMPWIN* win, u32 fontID, const STRBUF* msg, u32 xofs, u32 yofs, u32 wait, pStrPrintCallBack callback );

extern u8 GF_STR_PrintColor(
		GF_BGL_BMPWIN * win, u32 fontID, const STRBUF* msg, u32 xofs, u32 yofs, u32 wait,
		GF_PRINTCOLOR col, pStrPrintCallBack call_back );

extern u8 GF_STR_PrintExpand(
		GF_BGL_BMPWIN * win, u32 fontID, const STRBUF* msg, u32 xofs, u32 yofs, u32 wait,
		GF_PRINTCOLOR col, u32 xspc, u32 yspc, pStrPrintCallBack  call_back );

extern u8 GF_STR_Print( const MSG_PRINT_HEADER* mph_p, u32 wait, pStrPrintCallBack call_back );



//=============================================================================================
//\VXe֐
//=============================================================================================
//---------------------------------------------------------------------------------------------
/**
 *	\֐
 *
 * @param	Ȃ
 *
 * @retval	Ȃ
 */
//---------------------------------------------------------------------------------------------
GLOBAL void	MSG_PrintInit(void);
//---------------------------------------------------------------------------------------------
/*
 *	f[^ݒ
 *
 * @param	radrs		ǂݍ݃f[^JnAhX
 * @param	wadrs		݃f[^obt@AhX
 *
 * @retval	none
 */
//---------------------------------------------------------------------------------------------
GLOBAL void FntDataSet8x8_2bit(u32 radrs,u32 wadrs);

//---------------------------------------------------------------------------------------------
/*
 *	FntDataSet8x8_2bit ĂԑOɁAFԍZbgĂî߁j
 *
 * @param	col_f	Fԍ
 * @param	col_b	wiFԍ
 * @param	col_s	eFԍ
 */
//---------------------------------------------------------------------------------------------
GLOBAL void FntDataColorSet(u8 col_f, u8 col_b, u8 col_s);

GLOBAL void FntDataColorBackUp(u8* col_f, u8* col_b, u8* col_s);
GLOBAL void FntDataColorRecover(u8* col_f, u8* col_b, u8* col_s);
//---------------------------------------------------------------------------------------------
/*
 *	FntDataColorSet Őݒ肵Fԍ擾
 *
 * @param	mode	[hienum COLOR_GET_MODE : msg_print.hj
 *
 * @retval	Fԍ
 */
//---------------------------------------------------------------------------------------------
GLOBAL u8 FntDataColorGet(u8 mode);







//---------------------------------------------------------------------------------------------
/*
 * I`FbN֐
 *
 * @param	msg_index	bZ[WCfbNX
 *
 * @retval	0	I
 * @retval	1	
 */
//---------------------------------------------------------------------------------------------
GLOBAL u8 GF_MSG_PrintEndCheck( u8 msg_index );

//---------------------------------------------------------------------------------------------
/*
 * PƂ̕\^XNIɒ~
 *
 * @param	msg_index	bZ[WCfbNX
 */
//---------------------------------------------------------------------------------------------
GLOBAL void GF_STR_PrintForceStop( u8 msg_index );



GLOBAL void GF_MSG_PrintDispIcon( MSG_DATA_HEADER * mdh, u16 px, u16 py, u16 pat );




#undef	GLOBAL
#endif	/*	__MSG_PRINT_H__ */

