//============================================================================================
/**
 * @file	point_sel.h
 * @brief	ʒuCfbNXI
 * @author	Hiroyuki Nakamura
 * @date	2004.11.12
 */
//============================================================================================
#ifndef POINT_SEL_H
#define POINT_SEL_H
#undef GLOBAL
#ifdef POINT_SEL_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	V{`
//============================================================================================
// p[^擾p`
enum {
	POINT_WK_PX = 0,	// XW
	POINT_WK_PY,		// YW
	POINT_WK_SX,		// XTCY
	POINT_WK_SY,		// YTCY
	POINT_WK_UP,		// ւ̃CfbNXԍ
	POINT_WK_DOWN,		// ւ̃CfbNXԍ
	POINT_WK_LEFT,		// ւ̃CfbNXԍ
	POINT_WK_RIGHT		// Eւ̃CfbNXԍ
};

// f[^ړ`
enum {
	POINT_MV_UP = 0,	// 
	POINT_MV_DOWN,		// 
	POINT_MV_LEFT,		// E
	POINT_MV_RIGHT,		// 
	POINT_MV_NULL		// _~[
};

#define	POINT_SEL_NOMOVE	( 0xff )	// \L[ړŏ\L[ĂȂꍇ̕Ԃl

typedef struct {
	u8	px;			// XWiLłhbgłj
	u8	py;			// YW
	u8	sx;			// XTCY
	u8	sy;			// YTCY

	u8	up;			// ւ̃CfbNXԍ
	u8	down;		// ւ̃CfbNXԍ
	u8	left;		// ւ̃CfbNXԍ
	u8	right;		// Eւ̃CfbNXԍ
}POINTER_WORK;


//============================================================================================
//	O[oϐ
//============================================================================================


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * p[^擾
 *
 * @param	pw		[N
 * @param	flg		擾tO
 *
 * @return	wp[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 PointerWorkGet( const POINTER_WORK * pw, u8 flg );

//--------------------------------------------------------------------------------------------
/**
 * W擾
 *
 * @param	pw		[N
 * @param	x		XWi[ꏊ
 * @param	y		YWi[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PointerWkPosGet( const POINTER_WORK * pw, u8 * x, u8 * y );

//--------------------------------------------------------------------------------------------
/**
 * TCY擾
 *
 * @param	pw		[N
 * @param	x		XTCYi[ꏊ
 * @param	y		YTCYi[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PointerWkSizeGet( const POINTER_WORK * pw, u8 * x, u8 * y );

//--------------------------------------------------------------------------------------------
/**
 * ړw肵AWATCYACfbNX擾
 *
 * @param	pw		[N
 * @param	px		XWi[ꏊ
 * @param	py		YWi[ꏊ
 * @param	sx		XTCYi[ꏊ
 * @param	sy		YTCYi[ꏊ
 * @param	now		݂̃CfbNX
 * @param	mv		ړ
 *
 * @return	ړ̃CfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 PointerWkMoveSel(
				const POINTER_WORK * pw, u8 * px, u8 * py, u8 * sx, u8 * sy, u8 now, u8 mv );

//--------------------------------------------------------------------------------------------
/**
 * \L[̏񂩂AWATCYACfbNX擾
 *
 * @param	pw		[N
 * @param	px		XWi[ꏊ
 * @param	py		YWi[ꏊ
 * @param	sx		XTCYi[ꏊ
 * @param	sy		YTCYi[ꏊ
 * @param	now		݂̃CfbNX
 *
 * @return	ړ̃CfbNXi\L[ĂȂꍇPOINT_SEL_NOMOVEj
 *
 * @li	sys.trggp
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 PointerWkMoveSelTrg(
				const POINTER_WORK * pw, u8 * px, u8 * py, u8 * sx, u8 * sy, u8 now );

//--------------------------------------------------------------------------------------------
/**
 * Ww肵ACfbNX擾
 *
 * @param	pw		[N
 * @param	px		XW
 * @param	py		YW
 * @param	siz		f[^TCY
 *
 * @return	wW̃CfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 PointerWkMovePos( const POINTER_WORK * pw, u8 px, u8 py, u8 siz );


#undef	GLOBAL
#endif	/* POINT_SEL_H */
