//=============================================================================================
/**
 * @file	simple_3dgraphic.h
 * @brief	{RcOtBbNVXe
 */
//=============================================================================================
#ifndef __SIMPLE_3DGRAPHIC_H__
#define __SIMPLE_3DGRAPHIC_H__

#include "system.h"


#undef GLOBAL
#ifdef __SIMPLE_3DGRAPHICS_H_GLOBAL__
#define GLOBAL /*	*/
#else
#define GLOBAL extern
#endif

#define LINK_VRAM_MANAGER	//NhVRAM}l[W[gp

#include "tcb.h"

typedef void (*pCallBackFunc)(void *);	// ֐|C^^
typedef void (*pSetTexAnmCallBackFunc)(NNSG3dRenderObj* ,
		NNSG3dAnmObj* ,
		NNSG3dResMdl* ,
		NNSG3dResTex* );	// ֐|C^^

typedef struct VRAM_MANAGER_MEM_tag * VRAM_MANAGER_MEM_PTR;

typedef struct G3D_CLEAR_COLOR_tag
{
	GXRgb RGB;		//NAJ[RGB
	int Alpha;		//0 <= alpha <= 31
	int Depth;		//NAfvXl
	int PolygonID;	//Agr[gobt@̃|SIDl
	BOOL Fog;		//Agr[gobt@̃tHOLɂ邩ǂ̑I
}G3D_CLEAR_COLOR;

typedef enum{
	GF_SHADING_TOON = GX_SHADING_TOON,
	GF__SHADING_HIGHLIGHT = GX_SHADING_HIGHLIGHT,
}GF_SHADE_MODE;

typedef struct G3D_SETUP_PARAM_tag
{
	GF_SHADE_MODE ShadeMode;		//VF[fBO[h
	int Priority;		//3DʃvCIeB(0`3)
	int Ref;			//eXgsꍇ̔rl
	BOOL AntiAlias;		//A`GCAXL
	BOOL EdgeMarking;	//GbW}[LOL
	BOOL AlphaTest;		//eXgL
	BOOL AlphaBlend;	//uhL
	//NAJ[
	G3D_CLEAR_COLOR ClearColor;
}G3D_SETUP_PARAM;

typedef enum{
	LINKED_VRAM_MANAGER,
	FRM_VRAM_MANAGER,
}VRAM_MANAGER_TYPE;

typedef struct VRAM_MAN_PARAM_tag
{
	VRAM_MANAGER_TYPE Type;
	union {
		struct{
			u32 TexSzByte;
			u32	TexSzByteFor4x4;
		};
		struct{
			u16 TexSlot;
			u16 dummy[3];
		};
	};
	u32 PalSzByte;
}VRAM_MAN_PARAM;

/*---------------------------------------------------------------------------*
	O[o֐
 *---------------------------------------------------------------------------*/
GLOBAL BOOL TexKeyLive( NNSG3dResTex* pTex );	// eNX`L[UĂ邩`FbN

GLOBAL void simple_3DModelSetResFileAlready
	(NNSG3dRenderObj* object_p,
	 NNSG3dResMdl** model, NNSG3dResFileHeader** resFile);

GLOBAL void simple_3DBGInit(const u8 inMode);
GLOBAL void simple_3DBGExit(void);

GLOBAL void simple_LoadG3DModel
	(const u8 mode,
	 const char* path,
	 NNSG3dResMdl** model,
	 NNSG3dResFileHeader** resFile);

GLOBAL void simple_3DModelDraw
		(NNSG3dRenderObj* object_p,VecFx32* trans_p,MtxFx33* rot_p,VecFx32* scale_p);
GLOBAL void simple_3DModelDraw_1mat1shape
        (NNSG3dRenderObj* object_p,VecFx32* trans_p,MtxFx33* rot_p,VecFx32* scale_p);

GLOBAL void simple_3DModelSet
	(const u8 mode,
	 const char* path,NNSG3dRenderObj* object_p,
	 NNSG3dResMdl** model,NNSG3dResFileHeader** resFile);

GLOBAL BOOL LoadVRAMTexture(NNSG3dResTex* tex);
GLOBAL BOOL BindTexture(void* pResData, NNSG3dResTex* pTex);

#undef GLOBAL



#endif
