//=============================================================================================
/**
 * @file	strbuf.h
 * @brief	ėpobt@^IuWFNg
 * @author	taya
 * @date	2005.11.02
 */
//=============================================================================================
#ifndef __STRBUF_H__
#define __STRBUF_H__

#include "number_str.h"



typedef struct _STRBUF	STRBUF;


//------------------------------------------------------------------
/**
 * obt@IuWFNg쐬
 *
 * @param   size		i[ł镶iEOM܂ށj
 * @param   heapID		쐬q[vID
 *
 * @retval  STRBUF*		IuWFNgւ̃|C^
 */
//------------------------------------------------------------------
extern STRBUF* STRBUF_Create( u32 size, u32 heapID );


//------------------------------------------------------------------
/**
 * obt@IuWFNg폜
 *
 * @param   strbuf		IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
extern void STRBUF_Delete( STRBUF* strbuf );


//------------------------------------------------------------------
/**
 * eNAċ󕶎ɂ
 * iCreate ̓NAĂ̂ŌĂԕKv͖j
 *
 * @param   strbuf		IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
extern void STRBUF_Clear( STRBUF* strbuf );


//------------------------------------------------------------------
/**
 * obt@Ԃ̕Rs[
 *
 * @param   dst		Rs[obt@IuWFNg
 * @param   src		Rs[obt@IuWFNg
 *
 */
//------------------------------------------------------------------
extern void STRBUF_Copy( STRBUF* dst, const STRBUF* src );

//------------------------------------------------------------------
/**
 * ẽobt@𕡐
 *
 * @param   strbuf		̃obt@IuWFNg
 *
 * @retval  STRBUF*		ꂽobt@IuWFNg
 */
//------------------------------------------------------------------
extern STRBUF* STRBUF_CreateBufferCopy( const STRBUF* origin, u32 heapID );

//------------------------------------------------------------------
/**
 * l𕶎񉻂ăobt@ɃZbg
 *
 * @param   dst			IuWFNgւ̃|C^
 * @param   number		l
 * @param   keta		ő包
 * @param   dispType	\^Cv
 * @param   codeType	R[h^Cv
 *
 */
//------------------------------------------------------------------
extern void STRBUF_SetNumber( STRBUF* dst, int number, u32 keta, NUMBER_DISPTYPE dispType, NUMBER_CODETYPE codeType );

//------------------------------------------------------------------
/**
 * 𐔎ɕϊ  18Ή  ̊֐͕R[hɍE
 *
 * @param   src			ϊĂobt@
 * @param   pNumber     ϊI
 * @return  ꍇTRUE
 *
 */
//------------------------------------------------------------------

extern u64 STRBUF_GetNumber( const STRBUF* src, BOOL* pbFlag  );

//------------------------------------------------------------------
/**
 * r
 *
 * @param   str1		P
 * @param   str2		Q
 *
 * @retval  int			"0 = v"
 * @retval  int			"1 = sv"
 */
//------------------------------------------------------------------
extern int STRBUF_Compare( const STRBUF* str1, const STRBUF* str2 );

//------------------------------------------------------------------
/**
 * i[Ă镶Ԃ
 *
 * @param   strbuf		obt@IuWFNg
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
extern u32 STRBUF_GetLen( const STRBUF* strbuf );

//------------------------------------------------------------------
/**
 * i[Ă镶񂪉s邩𒲂ׂ
 *
 * @param   strbuf		obt@IuWFNg
 *
 * @retval  u32		̍s
 */
//------------------------------------------------------------------
extern u32 STRBUF_GetLines( const STRBUF* strbuf );

//------------------------------------------------------------------
/**
 * ́Awŝ݂ʃobt@փRs[
 *
 * @param   dst		Rs[obt@
 * @param   src		Rs[obt@
 * @param   line	sԍi0 originj
 *
 */
//------------------------------------------------------------------
extern void STRBUF_CopyLine( STRBUF* dst, const STRBUF* src, u32 line );

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/24
// 擪̕Ls^CY֐ǉ
extern void STRBUF_Capitalize( STRBUF *strbuf );
// ----------------------------------------------------------------------------


//==========================================================================================
// fobOp
//==========================================================================================
#ifdef PM_DEBUG
extern BOOL STRBUF_CheckValid(const void* ptr);
//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊiPUijfobOp
 *
 * @param   dst			[out] obt@IuWFNgւ̃|C^
 * @param   number		l
 * @param   keta		ő包
 * @param   dispType	\^Cv
 * @param   codeType	R[h^Cv
 *
 * @return	none
 *
 * @li	type = NUMBER_DISPTYPE_LEFT		l
 * @li	type = NUMBER_DISPTYPE_SPACE	ElAȂ͋
 * @li	type = NUMBER_DISPTYPE_ZERO		ElAȂ͐̃[
 */
//--------------------------------------------------------------------------------------------
extern void STRBUF_SetHexNumber(STRBUF* dst, int num, u32 keta,
								NUMBER_DISPTYPE dispType, NUMBER_CODETYPE codeType );
#endif



#endif
