//=============================================================================================
/**
 * @file	tcb.h
 * @brief	ėp^XN䃂W[wb_
 * @author	tamada
 * @date	2003.02.20
 * @since	2003.01.20
 *
 * TCB... Task Control Block̗łB
 * lbĝǂ̃TCgpN܂B
 */
//=============================================================================================

#ifndef	__TCB_H__
#define	__TCB_H__




/*====================================================================================*/
/*  ^錾                                                                            */
/*====================================================================================*/

//------------------------------------------------------------------
/**
 * @brief	TCBSYS ^錾
 *
 * TCBVXe[N\̂̐錾B
 * CpEVBlankpȂǁACӂ̉ӏŎs
 * TCBVXe쐬邱ƂoB
 *
 * e͉BĂAڂ̃ANZX͂łȂB
  */
//------------------------------------------------------------------
typedef struct _TCBSYS		TCBSYS;

//------------------------------------------------------------------
/**
 * @brief	TCB|C^^
 *
 * TCBւ͂̃|C^^oRŃANZXB
 * TCB\̂𒼐ڃANZXłȂ悤ɂȂĂB
 */
//------------------------------------------------------------------
typedef	struct _TCB * TCB_PTR;

//------------------------------------------------------------------
/**
 * @brief	TCB֐^
 *
 * TCBɓo^s֐̌^`B
 * ƂTCB_PTRƁA[Nւ̃|C^Ƃ悤ɂȂĂ
 */
//------------------------------------------------------------------
typedef void (*TCB_FUNC)( TCB_PTR, void * );

/*====================================================================================*/
/*  ֐錾                                                                          */
/*====================================================================================*/


//------------------------------------------------------------------
/**
 * TCB VXe\ẑɕKvȃʂvZ
 *
 * @param   task_max		ғłő^XN
 *
 * @retval  u32		TCYioCgPʁj
 */
//------------------------------------------------------------------
extern u32 TCBSYS_CalcSystemWorkSize( u32 task_max );

//------------------------------------------------------------------
/**
 * TCBVXe쐬
 *
 * @param   task_max		ғłő^XN
 * @param   work_area		VXe쐬ɕKv[ȃTCỸ[NGAAhX
 *
 * @retval  TCBSYS*		쐬ꂽTCBVXe|C^
 *
 * work_area ɕKvȃTCÝATCBSYS_CalcSystemWorkSize ŌvZB
 */
//------------------------------------------------------------------
extern TCBSYS*  TCBSYS_Create( u32 task_max, void* work_area );

//------------------------------------------------------------------
/**
 *	TCBVXegpȌ
 */
//------------------------------------------------------------------
extern void TCBSYS_Init( TCBSYS* tcbsys );

//------------------------------------------------------------------
/**
 *	@brief	TCBVXeC
 *
 *	TCBVXeɓo^Ăe^XND揇ɌĂяo
 *
 *  @param	tcbsys		TCBVXe[N|C^
 *
 */
//------------------------------------------------------------------
extern void TCBSYS_Main( TCBSYS* tcbsys );

//------------------------------------------------------------------------------
/**
	@brief	TCBǉ
	@param	tcbsys	TCBVXe|C^
	@param	func	TCB_FUNC:֘Ats֐|C^
	@param	work	void*:֘At郏[NGAւvoid^|C^
	@param	pri		u32:^XNvCIeB

	@return	TCB_PTR	ǉTCB|C^
*/
//------------------------------------------------------------------------------
extern TCB_PTR TCBSYS_AddTask( TCBSYS* tcbsys, TCB_FUNC func, void* work, u32 pri );


//------------------------------------------------------------------------------
/**
	@brief	TCB
	@param	tcb		TCB|C^
*/
//------------------------------------------------------------------------------
extern void TCBSYS_DeleteTask( TCB_PTR tcb );


//------------------------------------------------------------------
/**
 * @brief	TCB֐̐؂ւ
 *
 * TCB̓֐؂ւ
 *
 * @param	tcb		ΏۂƂȂTCBւ̃|C^
 * @param	func	V؂ւ铮֐
*/
//------------------------------------------------------------------
extern void TCB_ChangeFunc(TCB_PTR tcb, TCB_FUNC func);

//------------------------------------------------------------------
/**
 * @brief	TCB[N̎擾
 *
 * TCB̕ێĂ郏[NAhX擾
 *
 * @param	tcb	TCBւ̃|C^
 * @return	[Nւ̃|C^
 */ 
//------------------------------------------------------------------
extern void * TCB_GetWork(TCB_PTR tcb);

//------------------------------------------------------------------
/**
 * @brief	TCBvCIeB̎擾
 *
 * TCB̓D揇ʂ擾
 *
 * @param	tcb	TCBւ̃|C^
 * @return	vCIeB̒l
 */
//------------------------------------------------------------------
extern u32 TCB_GetPriority(TCB_PTR tcb);


#endif /*__TCB_H__*/
