//============================================================================================
/**
 * @file	item.h
 * @brief	ACef[^
 * @author	Hiroyuki Nakamura
 * @date	05.09.06
 */
//============================================================================================
#ifndef ITEM_H
#define ITEM_H
#undef GLOBAL
#ifdef ITEM_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif

#include "gflib/strbuf.h"
#include "itemtool/itemsym.h"
#include "itemtool/itemequip.h"


//============================================================================================
//	萔`
//============================================================================================
typedef struct _ITEM_DATA	ITEMDATA;		// ACef[^

// ACeIDiACR擾ȂǂɎgpj
#define	ITEM_DUMMY_ID	( 0 )				// _~[ID
#define	ITEM_RETURN_ID	( 0xffff )			// ߂

// CfbNX擾`
enum {
	ITEM_GET_DATA = 0,		// ACef[^
	ITEM_GET_ICON_CGX,		// ACRL
	ITEM_GET_ICON_PAL,		// ACRpbg
	ITEM_GET_AGB_NUM		// AGB̃ACeԍ
};

// p[^擾`
enum {
	ITEM_PRM_PRICE,					// l
	ITEM_PRM_EQUIP,					// 
	ITEM_PRM_ATTACK,				// З
	ITEM_PRM_EVENT,					// dv
	ITEM_PRM_CNV,					// ֗{^
	ITEM_PRM_POCKET,				// ۑi|Pbgԍj
	ITEM_PRM_FIELD,					// field@\
	ITEM_PRM_BATTLE,				// battle@\
	ITEM_PRM_TUIBAMU_EFF,			// ΂ތ
	ITEM_PRM_NAGETUKERU_EFF,		// Ȃ
	ITEM_PRM_NAGETUKERU_ATC,		// ȂЗ
	ITEM_PRM_SIZENNOMEGUMI_ATC,		// ̂߂݈З
	ITEM_PRM_SIZENNOMEGUMI_TYPE,	// ̂߂݃^Cv
	ITEM_PRM_BTL_POCKET,			// 퓬ۑi|Pbgԍj
	ITEM_PRM_W_TYPE,				// [N^Cv
	ITEM_PRM_SLEEP_RCV,				// 
	ITEM_PRM_POISON_RCV,			// ŉ
	ITEM_PRM_BURN_RCV,				// Ώ
	ITEM_PRM_ICE_RCV,				// X
	ITEM_PRM_PARALYZE_RCV,			// ჉
	ITEM_PRM_PANIC_RCV,				// 
	ITEM_PRM_MEROMERO_RCV,			// 
	ITEM_PRM_ABILITY_GUARD,			// \̓K[h
	ITEM_PRM_DEATH_RCV,				// m
	ITEM_PRM_ALL_DEATH_RCV,			// Sm
	ITEM_PRM_LV_UP,					// xAbv
	ITEM_PRM_EVOLUTION,				// i
	ITEM_PRM_ATTACK_UP,				// U̓Abv
	ITEM_PRM_DEFENCE_UP,			// h̓Abv
	ITEM_PRM_SP_ATTACK_UP,			// UAbv
	ITEM_PRM_SP_DEFENCE_UP,			// hAbv
	ITEM_PRM_AGILITY_UP,			// fAbv
	ITEM_PRM_HIT_UP,				// Abv
	ITEM_PRM_CRITICAL_UP,			// NeBJAbv
	ITEM_PRM_PP_UP,					// PPAbv
	ITEM_PRM_PP_3UP,				// PPAbviRiKj
	ITEM_PRM_PP_RCV,				// PP
	ITEM_PRM_ALL_PP_RCV,			// PP񕜁iSĂ̋Zj
	ITEM_PRM_HP_RCV,				// HP
	ITEM_PRM_HP_EXP,				// HPw͒lAbv
	ITEM_PRM_POWER_EXP,				// Uw͒lAbv
	ITEM_PRM_DEFENCE_EXP,			// hw͒lAbv
	ITEM_PRM_AGILITY_EXP,			// fw͒lAbv
	ITEM_PRM_SP_ATTACK_EXP,			// Uw͒lAbv
	ITEM_PRM_SP_DEFENCE_EXP,		// hw͒lAbv
	ITEM_PRM_FRIEND1,				// ȂxP
	ITEM_PRM_FRIEND2,				// ȂxQ
	ITEM_PRM_FRIEND3,				// ȂxR
	ITEM_PRM_HP_EXP_POINT,			// HPw͒l̒l
	ITEM_PRM_POWER_EXP_POINT,		// Uw͒l̒l
	ITEM_PRM_DEFENCE_EXP_POINT,		// hw͒l̒l
	ITEM_PRM_AGILITY_EXP_POINT,		// fw͒l̒l
	ITEM_PRM_SP_ATTACK_EXP_POINT,	// Uw͒l̒l
	ITEM_PRM_SP_DEFENCE_EXP_POINT,	// hw͒l̒l
	ITEM_PRM_HP_RCV_POINT,			// HP񕜒l̒l
	ITEM_PRM_PP_RCV_POINT,			// pp񕜒l̒l
	ITEM_PRM_FRIEND1_POINT,			// Ȃx1̒l
	ITEM_PRM_FRIEND2_POINT,			// Ȃx2̒l
	ITEM_PRM_FRIEND3_POINT,			// Ȃx3̒l
};

// [N^Cv̎
enum {
	ITEM_WKTYPE_DUMMY = 0,		// _~[
	ITEM_WKTYPE_POKEUSE,		// |PɎg
};

//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * wACewʒuɑ}
 *
 * @param	item	ACef[^
 * @param	pos1	wACeʒu
 * @param	pos2	}ʒu
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
GLOBAL void ItemPutIn( void * item, u16 pos1, u16 pos2 );

//============================================================================================
//============================================================================================
//	f[^擾
//============================================================================================
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * f[^CfbNX擾
 *
 * @param	item		ACeԍ
 * @param	type		擾f[^
 *
 * @return	wf[^
 *
 * @li	type = ITEM_GET_DATA		: ACef[^̃A[JCuCfbNX
 * @li	type = ITEM_GET_ICON_CGX	: ACRL̃A[JCuCfbNX
 * @li	type = ITEM_GET_ICON_PAL	: ACRpbg̃A[JCuCfbNX
 * @li	type = ITEM_GET_AGB_NUM		: AGB̃ACeԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 GetItemIndex( u16 item, u16 type );

//--------------------------------------------------------------------------------------------
/**
 * AGB̃ACeDP̃ACeɕϊ
 *
 * @param	agb		AGB̃ACeԍ
 *
 * @retval	"ITEM_DUMMY_ID = DPɂȂACe"
 * @retval	"ITEM_DUMMY_ID != DP̃ACeԍ"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 ITEM_AgbItemCnv( u16 agb );

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃ZA[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	ZA[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 ItemIconCellGet(void);

//--------------------------------------------------------------------------------------------
/**
 * ACeACR̃ZAjA[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	ZAjA[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 ItemIconCAnmGet(void);

//--------------------------------------------------------------------------------------------
/**
 * A[JCuf[^[h
 *
 * @param	item		ACeԍ
 * @param	type		擾f[^
 * @param	heap_id		q[vID
 *
 * @return	wf[^
 *
 * @li	type = ITEM_GET_DATA		: ACef[^
 * @li	type = ITEM_GET_ICON_CGX	: ACR̃Lf[^
 * @li	type = ITEM_GET_ICON_PAL	: ACR̃pbgf[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * GetItemArcData( u16 item, u16 type, u32 heap_id );

//--------------------------------------------------------------------------------------------
/**
 * O擾
 *
 * @param	buf			i[ꏊ
 * @param	item		ACeԍ
 * @param	heap_id		q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void GetItemName( STRBUF* buf, u16 item, u32 heap_id );

//--------------------------------------------------------------------------------------------
/**
 * 擾
 *
 * @param   buf			ACei[obt@
 * @param	item		ACeԍ
 * @param	heap_id		q[vID
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
GLOBAL void ItemInfoGet( STRBUF * buf, u16 item, u16 heap_id );

//--------------------------------------------------------------------------------------------
/**
 * 擾
 *
 * @param   buf			ACei[obt@
 * @param	item		ACeԍ
 * @param	heap_id		q[vID
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
GLOBAL void ItemEpuipInfoGet( STRBUF * buf, u16 item, u16 heap_id );

//--------------------------------------------------------------------------------------------
/**
 * p[^擾iACeԍwj
 *
 * @param	item	ACeԍ
 * @param	param	擾p[^`
 * @param	heap_id		q[vID
 *
 * @return	wp[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL s32 ItemParamGet( u16 item, u16 param, u32 heap_id );

//--------------------------------------------------------------------------------------------
/**
 * p[^擾iACef[^wj
 *
 * @param	item	ACef[^
 * @param	param	擾p[^`
 *
 * @return	wp[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL s32 ItemBufParamGet( ITEMDATA * item, u16 param );

//--------------------------------------------------------------------------------------------
/**
 * Z}VŊoZ擾
 *
 * @param	item	ACeԍ
 *
 * @return	Zԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL const u16 GetWazaNoItem( u16 item );

//--------------------------------------------------------------------------------------------
/**
 * IꂽZ`Zǂ
 *
 * @param	waza	Zԍ
 *
 * @retval	"TRUE = `Z"
 * @retval	"FALSE = `ZȊO"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 HidenWazaCheck( u16 waza );

//--------------------------------------------------------------------------------------------
/**
 * Z}Vԍ擾
 *
 * @param	item	ACeԍ
 *
 * @return	Z}Vԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 WazaMashineNoGet( u16 item );

//--------------------------------------------------------------------------------------------
/**
 * ACe[ǂ`FbN
 *
 * @param	item	ACeԍ
 *
 * @retval	"TRUE = ["
 * @retval	"FALSE = [ȊO"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 ItemMailCheck( u16 item );

//--------------------------------------------------------------------------------------------
/**
 * ACeԍ烁[̃fUC擾
 *
 * @param	item	ACeԍ
 *
 * @return	fUCID
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 ItemMailDesignGet( u16 item );

//--------------------------------------------------------------------------------------------
/**
 * [̃fUCACeԍ擾
 *
 * @param	design		fUCID
 *
 * @return	ACeԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 MailItemNumGet( u8 design );

//--------------------------------------------------------------------------------------------
/**
 * ACe؂̎ǂ`FbN
 *
 * @param	item	ACeԍ
 *
 * @retval	"TRUE = ؂̎"
 * @retval	"FALSE = ؂̎ȊO"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 ItemNutsCheck( u16 item );

//--------------------------------------------------------------------------------------------
/**
 * ؂̎̔ԍ擾
 *
 * @param	item	ACeԍ
 *
 * @return	؂̎ԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 NutsNoGet( u16 item );

//--------------------------------------------------------------------------------------------
/**
 * wID̖؂̎̃ACeԍ擾
 *
 * @param	id		؂̎ID
 *
 * @return	ACeԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 NutsIDItemGet( u8 id );

//--------------------------------------------------------------------------------------------
/**
 * ACe򂩂ǂ`FbN
 *
 * @param	item	ACeԍ
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = "
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 ItemKanpouyakuCheck( u16 item );

//--------------------------------------------------------------------------------------------
/**
 * ACee[uׂăɓWJ
 *
 * @param	heapID	WJ郁q[vID
 *
 * @retval	mۂ̃AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL	void	*ItemDataTableLoad(int heapID);

//--------------------------------------------------------------------------------------------
/**
 * ACee[uCӂ̃AhX擾
 *
 * @param	item	ACee[u
 * @param	index	Ƃ肾CfbNXio[
 *
 * @retval	擾AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL	ITEMDATA	*GetItemDataPointer(ITEMDATA *item,u16 index);

#undef GLOBAL
#endif	/* ITEM_H */
