/*---------------------------------------------------------------------------*
  Project:  DP WiFi Library
  File:     dpw_common.h

  Copyright 2003-2006 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $NoKeywords: $
 *---------------------------------------------------------------------------*/

/*! @file
	@brief	DP WiFi Common Cu
	
	@author	Yamaguchi Ryo(yamaguchi_ryo@nintendo.co.jp)
	
*/

#ifndef DPW_COMMON_H_
#define DPW_COMMON_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _NITRO
#include <dwc.h>
#else
#include <nitro.h>
#include <dwc.h>
#endif

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/12/13
// versiont@C PG5_WIFIRELEASE = yes 錾ĂA
// Wi-Fi̐ڑeXgT[opubNT[oɐ؂ւ

#ifdef PG5_WIFIRELEASE
#define DPW_SERVER_PUBLIC
#endif

// ----------------------------------------------------------------------------

/*-----------------------------------------------------------------------*
					^E萔錾
 *-----------------------------------------------------------------------*/

//! [AhX̒(NULLI[)
#define DPW_MAIL_ADDR_LENGTH 55

//! [AhX̔F؂JnpX[h
#define DPW_MAIL_ADDR_AUTH_START_PASSWORD 0xffff

//! [AhX̔F؂IɒʂfobOppX[hAɔF،ʂDPW_PROFILE_AUTHRESULT_SUCCESSɂȂ܂BF؃[͑M܂B
#define DPW_MAIL_ADDR_AUTH_DEBUG_PASSWORD 9999

//! Dpw_Common_Profile\̂mailRecvFlagõrbgtO
typedef enum {
    DPW_PROFILE_MAILRECVFLAG_EXCHANGE = 0x1 //!< |PꂽƂ̃[M邩
}DPW_PROFILE_MAILRECVFLAG;

//! Dpw_Common_Profile\̂flagõrbgtO
typedef enum {
    DPW_PROFILE_FLAG_HANGEUL_AVAILABLE = 0x1 //!< nO\ł邩
}DPW_PROFILE_FLAG;

//! ̏o^p\
typedef struct {
    u8      version;                        //!< o[W
    u8      language;                       //!< R[h
	u8      countryCode;                    //!< Zł鍑R[h
	u8      localCode;                      //!< ZłnR[h
	u32     playerId;			            //!< vC[ID
	u16     playerName[8];		            //!< vC[(|PR[h)
    u32     flag;                           //!< etOADPW_PROFILE_FLAG񋓑̂̒lZbgĂB
    u8      macAddr[6];                     //!< MACAhXACuŊi[̂ŃZbgKv͂܂B
    u8      reserved[2];                    //!< pfBO
    char    mailAddr[DPW_MAIL_ADDR_LENGTH+1]; //!< [AhXBASCIINULLI[̂ZbgĂB[M@\gpȂꍇ͋󕶎ĂB
    u32     mailRecvFlag;                   //!< [MtOADPW_PROFILE_MAILRECVFLAG񋓑̂̒lZbgĂB
    u16     mailAddrAuthVerification;       //!< [AhXFؗpmFR[hB0`999̐͂ĂB
    u16     mailAddrAuthPass;               //!< [AhXF؃pX[hBF؂JnƂDPW_MAIL_ADDR_AUTH_START_PASSWORDZbgĂB
} Dpw_Common_Profile;

//! Dpw_Common_ProfileResult\̂codeoɊi[錋
typedef enum {
    DPW_PROFILE_RESULTCODE_SUCCESS,             //!< ̓o^ɐ܂BmailAddrAuthResultoɔF،ʂi[܂B
    DPW_PROFILE_RESULTCODE_ERROR_INVALIDPARAM,  //!< Mp[^słB
    DPW_PROFILE_RESULTCODE_ERROR_SERVERSTATE    //!< T[ȍԂeiX͈ꎞ~łB
} DPW_PROFILE_RESULTCODE;

//! Dpw_Common_ProfileResult\̂mailAddrAuthResulto([AhXF،)Ɋi[錋ʁB
typedef enum {
    DPW_PROFILE_AUTHRESULT_SUCCESS,     //!< FؐB[@\LɂȂA[̗L31ɉ܂B[AhXɋ󕶎ꂽꍇ͕K̒lԂA[@\ɂȂ܂B
    DPW_PROFILE_AUTHRESULT_SEND,        //!< F؃[𑗐M܂BF؃[ɏĂpX[hmailAddrAuthPassɃZbgAēxDpw_xx_SetProfileAsync֐ĂłB
    DPW_PROFILE_AUTHRESULT_SENDFAILURE, //!< F؃[̑MɎs܂B炭[AhXԈĂ܂B
    DPW_PROFILE_AUTHRESULT_FAILURE      //!< F؂Ɏs܂BF؃[ɋLqĂpX[hƑMꂽpX[hႢ܂B͔F؃[̑MƈقȂ郁[AhXłB
} DPW_PROFILE_AUTHRESULT;

//! ̏o^X|Xp\
typedef struct {
    u32 code;                   //!< ʃR[hBDPW_PROFILE_RESULTCODE񋓑̂̒li[܂B
    u32 mailAddrAuthResult;     //!< [AhXF،ʁBcodeoDPW_PROFILE_RESULTCODE_SUCCESSZbgꂽꍇ̂݁ADPW_PROFILE_AUTHRESULT񋓑̂̒li[܂BDP؍łł͕K0ɂȂ܂B
} Dpw_Common_ProfileResult;

/*-----------------------------------------------------------------------*
					O[oϐ`
 *-----------------------------------------------------------------------*/



/*-----------------------------------------------------------------------*
					֐O錾
 *-----------------------------------------------------------------------*/

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // DPW_COMMON_H_